// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes a quota for an Amazon Web Services account. The following are account
// quotas:
//
// * AllocatedStorage - The total allocated storage per account, in GiB.
// The used value is the total allocated storage in the account, in GiB.
//
// *
// AuthorizationsPerDBSecurityGroup - The number of ingress rules per DB security
// group. The used value is the highest number of ingress rules in a DB security
// group in the account. Other DB security groups in the account might have a lower
// number of ingress rules.
//
// * CustomEndpointsPerDBCluster - The number of custom
// endpoints per DB cluster. The used value is the highest number of custom
// endpoints in a DB clusters in the account. Other DB clusters in the account
// might have a lower number of custom endpoints.
//
// * DBClusterParameterGroups - The
// number of DB cluster parameter groups per account, excluding default parameter
// groups. The used value is the count of nondefault DB cluster parameter groups in
// the account.
//
// * DBClusterRoles - The number of associated Amazon Web Services
// Identity and Access Management (IAM) roles per DB cluster. The used value is the
// highest number of associated IAM roles for a DB cluster in the account. Other DB
// clusters in the account might have a lower number of associated IAM roles.
//
// *
// DBClusters - The number of DB clusters per account. The used value is the count
// of DB clusters in the account.
//
// * DBInstanceRoles - The number of associated IAM
// roles per DB instance. The used value is the highest number of associated IAM
// roles for a DB instance in the account. Other DB instances in the account might
// have a lower number of associated IAM roles.
//
// * DBInstances - The number of DB
// instances per account. The used value is the count of the DB instances in the
// account. Amazon RDS DB instances, Amazon Aurora DB instances, Amazon Neptune
// instances, and Amazon DocumentDB instances apply to this quota.
//
// *
// DBParameterGroups - The number of DB parameter groups per account, excluding
// default parameter groups. The used value is the count of nondefault DB parameter
// groups in the account.
//
// * DBSecurityGroups - The number of DB security groups
// (not VPC security groups) per account, excluding the default security group. The
// used value is the count of nondefault DB security groups in the account.
//
// *
// DBSubnetGroups - The number of DB subnet groups per account. The used value is
// the count of the DB subnet groups in the account.
//
// * EventSubscriptions - The
// number of event subscriptions per account. The used value is the count of the
// event subscriptions in the account.
//
// * ManualClusterSnapshots - The number of
// manual DB cluster snapshots per account. The used value is the count of the
// manual DB cluster snapshots in the account.
//
// * ManualSnapshots - The number of
// manual DB instance snapshots per account. The used value is the count of the
// manual DB instance snapshots in the account.
//
// * OptionGroups - The number of DB
// option groups per account, excluding default option groups. The used value is
// the count of nondefault DB option groups in the account.
//
// *
// ReadReplicasPerMaster - The number of read replicas per DB instance. The used
// value is the highest number of read replicas for a DB instance in the account.
// Other DB instances in the account might have a lower number of read replicas.
//
// *
// ReservedDBInstances - The number of reserved DB instances per account. The used
// value is the count of the active reserved DB instances in the account.
//
// *
// SubnetsPerDBSubnetGroup - The number of subnets per DB subnet group. The used
// value is highest number of subnets for a DB subnet group in the account. Other
// DB subnet groups in the account might have a lower number of subnets.
//
// For more
// information, see Quotas for Amazon RDS
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html) in the
// Amazon RDS User Guide and Quotas for Amazon Aurora
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html)
// in the Amazon Aurora User Guide.
type AccountQuota struct {

	// The name of the Amazon RDS quota for this Amazon Web Services account.
	AccountQuotaName *string

	// The maximum allowed value for the quota.
	Max int64

	// The amount currently used toward the quota maximum.
	Used int64

	noSmithyDocumentSerde
}

// Contains Availability Zone information. This data type is used as an element in
// the OrderableDBInstanceOption data type.
type AvailabilityZone struct {

	// The name of the Availability Zone.
	Name *string

	noSmithyDocumentSerde
}

// Contains the available processor feature information for the DB instance class
// of a DB instance. For more information, see Configuring the Processor of the DB
// Instance Class
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor)
// in the Amazon RDS User Guide.
type AvailableProcessorFeature struct {

	// The allowed values for the processor feature of the DB instance class.
	AllowedValues *string

	// The default value for the processor feature of the DB instance class.
	DefaultValue *string

	// The name of the processor feature. Valid names are coreCount and threadsPerCore.
	Name *string

	noSmithyDocumentSerde
}

// A CA certificate for an Amazon Web Services account.
type Certificate struct {

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string

	// The unique key that identifies a certificate.
	CertificateIdentifier *string

	// The type of the certificate.
	CertificateType *string

	// Whether there is an override for the default certificate identifier.
	CustomerOverride *bool

	// If there is an override for the default certificate identifier, when the
	// override expires.
	CustomerOverrideValidTill *time.Time

	// The thumbprint of the certificate.
	Thumbprint *string

	// The starting date from which the certificate is valid.
	ValidFrom *time.Time

	// The final date that the certificate continues to be valid.
	ValidTill *time.Time

	noSmithyDocumentSerde
}

// This data type is used as a response element in the action
// DescribeDBEngineVersions.
type CharacterSet struct {

	// The description of the character set.
	CharacterSetDescription *string

	// The name of the character set.
	CharacterSetName *string

	noSmithyDocumentSerde
}

// The configuration setting for the log types to be enabled for export to
// CloudWatch Logs for a specific DB instance or DB cluster. The EnableLogTypes and
// DisableLogTypes arrays determine which logs will be exported (or not exported)
// to CloudWatch Logs. The values within these arrays depend on the DB engine being
// used. For more information about exporting CloudWatch Logs for Amazon RDS DB
// instances, see Publishing Database Logs to Amazon CloudWatch Logs
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
// in the Amazon RDS User Guide. For more information about exporting CloudWatch
// Logs for Amazon Aurora DB clusters, see Publishing Database Logs to Amazon
// CloudWatch Logs
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
// in the Amazon Aurora User Guide.
type CloudwatchLogsExportConfiguration struct {

	// The list of log types to disable.
	DisableLogTypes []string

	// The list of log types to enable.
	EnableLogTypes []string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the ModifyDBCluster operation
// and contains changes that will be applied during the next maintenance window.
type ClusterPendingModifiedValues struct {

	// The DBClusterIdentifier value for the DB cluster.
	DBClusterIdentifier *string

	// The database engine version.
	EngineVersion *string

	// A value that indicates whether mapping of Amazon Web Services Identity and
	// Access Management (IAM) accounts to database accounts is enabled.
	IAMDatabaseAuthenticationEnabled *bool

	// The master credentials for the DB cluster.
	MasterUserPassword *string

	// A list of the log types whose configuration is still pending. In other words,
	// these log types are in the process of being activated or deactivated.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports

	noSmithyDocumentSerde
}

// Specifies the settings that control the size and behavior of the connection pool
// associated with a DBProxyTargetGroup.
type ConnectionPoolConfiguration struct {

	// The number of seconds for a proxy to wait for a connection to become available
	// in the connection pool. Only applies when the proxy has opened its maximum
	// number of connections and all connections are busy with client sessions.
	// Default: 120 Constraints: between 1 and 3600, or 0 representing unlimited
	ConnectionBorrowTimeout *int32

	// One or more SQL statements for the proxy to run when opening each new database
	// connection. Typically used with SET statements to make sure that each connection
	// has identical settings such as time zone and character set. For multiple
	// statements, use semicolons as the separator. You can also include multiple
	// variables in a single SET statement, such as SET x=1, y=2. Default: no
	// initialization query
	InitQuery *string

	// The maximum size of the connection pool for each target in a target group. The
	// value is expressed as a percentage of the max_connections setting for the RDS DB
	// instance or Aurora DB cluster used by the target group. Default: 100
	// Constraints: between 1 and 100
	MaxConnectionsPercent *int32

	// Controls how actively the proxy closes idle database connections in the
	// connection pool. The value is expressed as a percentage of the max_connections
	// setting for the RDS DB instance or Aurora DB cluster used by the target group.
	// With a high value, the proxy leaves a high percentage of idle database
	// connections open. A low value causes the proxy to close more idle connections
	// and return them to the database. Default: 50 Constraints: between 0 and
	// MaxConnectionsPercent
	MaxIdleConnectionsPercent *int32

	// Each item in the list represents a class of SQL operations that normally cause
	// all later statements in a session using a proxy to be pinned to the same
	// underlying database connection. Including an item in the list exempts that class
	// of SQL operations from the pinning behavior. Default: no session pinning filters
	SessionPinningFilters []string

	noSmithyDocumentSerde
}

// Displays the settings that control the size and behavior of the connection pool
// associated with a DBProxyTarget.
type ConnectionPoolConfigurationInfo struct {

	// The number of seconds for a proxy to wait for a connection to become available
	// in the connection pool. Only applies when the proxy has opened its maximum
	// number of connections and all connections are busy with client sessions.
	ConnectionBorrowTimeout int32

	// One or more SQL statements for the proxy to run when opening each new database
	// connection. Typically used with SET statements to make sure that each connection
	// has identical settings such as time zone and character set. This setting is
	// empty by default. For multiple statements, use semicolons as the separator. You
	// can also include multiple variables in a single SET statement, such as SET x=1,
	// y=2.
	InitQuery *string

	// The maximum size of the connection pool for each target in a target group. The
	// value is expressed as a percentage of the max_connections setting for the RDS DB
	// instance or Aurora DB cluster used by the target group.
	MaxConnectionsPercent int32

	// Controls how actively the proxy closes idle database connections in the
	// connection pool. The value is expressed as a percentage of the max_connections
	// setting for the RDS DB instance or Aurora DB cluster used by the target group.
	// With a high value, the proxy leaves a high percentage of idle database
	// connections open. A low value causes the proxy to close more idle connections
	// and return them to the database.
	MaxIdleConnectionsPercent int32

	// Each item in the list represents a class of SQL operations that normally cause
	// all later statements in a session using a proxy to be pinned to the same
	// underlying database connection. Including an item in the list exempts that class
	// of SQL operations from the pinning behavior. Currently, the only allowed value
	// is EXCLUDE_VARIABLE_SETS.
	SessionPinningFilters []string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster. For
// an Amazon Aurora DB cluster, this data type is used as a response element in the
// operations CreateDBCluster, DeleteDBCluster, DescribeDBClusters,
// FailoverDBCluster, ModifyDBCluster, PromoteReadReplicaDBCluster,
// RestoreDBClusterFromS3, RestoreDBClusterFromSnapshot,
// RestoreDBClusterToPointInTime, StartDBCluster, and StopDBCluster. For a Multi-AZ
// DB cluster, this data type is used as a response element in the operations
// CreateDBCluster, DeleteDBCluster, DescribeDBClusters, FailoverDBCluster,
// ModifyDBCluster, RebootDBCluster, RestoreDBClusterFromSnapshot, and
// RestoreDBClusterToPointInTime. For more information on Amazon Aurora DB
// clusters, see  What is Amazon Aurora?
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide. For more information on Multi-AZ DB clusters,
// see  Multi-AZ deployments with two readable standby DB instances
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html)
// in the Amazon RDS User Guide.
type DBCluster struct {

	// The name of the Amazon Kinesis data stream used for the database activity
	// stream.
	ActivityStreamKinesisStreamName *string

	// The Amazon Web Services KMS key identifier used for encrypting messages in the
	// database activity stream. The Amazon Web Services KMS key identifier is the key
	// ARN, key ID, alias ARN, or alias name for the KMS key.
	ActivityStreamKmsKeyId *string

	// The mode of the database activity stream. Database events such as a change or
	// access generate an activity stream event. The database session can handle these
	// events either synchronously or asynchronously.
	ActivityStreamMode ActivityStreamMode

	// The status of the database activity stream.
	ActivityStreamStatus ActivityStreamStatus

	// For all database engines except Amazon Aurora, AllocatedStorage specifies the
	// allocated storage size in gibibytes (GiB). For Aurora, AllocatedStorage always
	// returns 1, because Aurora DB cluster storage size isn't fixed, but instead
	// automatically adjusts as needed.
	AllocatedStorage *int32

	// Provides a list of the Amazon Web Services Identity and Access Management (IAM)
	// roles that are associated with the DB cluster. IAM roles that are associated
	// with a DB cluster grant permission for the DB cluster to access other Amazon Web
	// Services on your behalf.
	AssociatedRoles []DBClusterRole

	// A value that indicates that minor version patches are applied automatically.
	// This setting is only for non-Aurora Multi-AZ DB clusters.
	AutoMinorVersionUpgrade bool

	// The time when a stopped DB cluster is restarted automatically.
	AutomaticRestartTime *time.Time

	// Provides the list of Availability Zones (AZs) where instances in the DB cluster
	// can be created.
	AvailabilityZones []string

	// The number of change records stored for Backtrack.
	BacktrackConsumedChangeRecords *int64

	// The target backtrack window, in seconds. If this value is set to 0, backtracking
	// is disabled for the DB cluster. Otherwise, backtracking is enabled.
	BacktrackWindow *int64

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int32

	// The current capacity of an Aurora Serverless v1 DB cluster. The capacity is 0
	// (zero) when the cluster is paused. For more information about Aurora Serverless
	// v1, see Using Amazon Aurora Serverless v1
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
	// in the Amazon Aurora User Guide.
	Capacity *int32

	// If present, specifies the name of the character set that this cluster is
	// associated with.
	CharacterSetName *string

	// Identifies the clone group to which the DB cluster is associated.
	CloneGroupId *string

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time

	// Specifies whether tags are copied from the DB cluster to snapshots of the DB
	// cluster.
	CopyTagsToSnapshot *bool

	// Specifies whether the DB cluster is a clone of a DB cluster owned by a different
	// Amazon Web Services account.
	CrossAccountClone *bool

	// Identifies all custom endpoints associated with the cluster.
	CustomEndpoints []string

	// The Amazon Resource Name (ARN) for the DB cluster.
	DBClusterArn *string

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string

	// The name of the compute and memory capacity class of the DB instance. This
	// setting is only for non-Aurora Multi-AZ DB clusters.
	DBClusterInstanceClass *string

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []DBClusterMember

	// Provides the list of option group memberships for this DB cluster.
	DBClusterOptionGroupMemberships []DBClusterOptionGroupStatus

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string

	// Specifies information on the subnet group associated with the DB cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string

	// Contains the name of the initial database of this DB cluster that was provided
	// at create time, if one was specified when the DB cluster was created. This same
	// name is returned for the life of the DB cluster.
	DatabaseName *string

	// The Amazon Web Services Region-unique, immutable identifier for the DB cluster.
	// This identifier is found in Amazon Web Services CloudTrail log entries whenever
	// the KMS key for the DB cluster is accessed.
	DbClusterResourceId *string

	// Indicates if the DB cluster has deletion protection enabled. The database can't
	// be deleted when deletion protection is enabled.
	DeletionProtection *bool

	// The Active Directory Domain membership records associated with the DB cluster.
	DomainMemberships []DomainMembership

	// The earliest time to which a DB cluster can be backtracked.
	EarliestBacktrackTime *time.Time

	// The earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time

	// A list of log types that this DB cluster is configured to export to CloudWatch
	// Logs. Log types vary by DB engine. For information about the log types for each
	// DB engine, see Amazon RDS Database Log Files
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html)
	// in the Amazon Aurora User Guide.
	EnabledCloudwatchLogsExports []string

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string

	// The name of the database engine to be used for this DB cluster.
	Engine *string

	// The DB engine mode of the DB cluster, either provisioned, serverless,
	// parallelquery, global, or multimaster. For more information, see
	// CreateDBCluster
	// (https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
	EngineMode *string

	// Indicates the database engine version.
	EngineVersion *string

	// Specifies whether you have requested to enable write forwarding for a secondary
	// cluster in an Aurora global database. Because write forwarding takes time to
	// enable, check the value of GlobalWriteForwardingStatus to confirm that the
	// request has completed before using the write forwarding feature for this
	// cluster.
	GlobalWriteForwardingRequested *bool

	// Specifies whether a secondary cluster in an Aurora global database has write
	// forwarding enabled, not enabled, or is in the process of enabling it.
	GlobalWriteForwardingStatus WriteForwardingStatus

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string

	// A value that indicates whether the HTTP endpoint for an Aurora Serverless v1 DB
	// cluster is enabled. When enabled, the HTTP endpoint provides a connectionless
	// web service API for running SQL queries on the Aurora Serverless v1 DB cluster.
	// You can also query your database from inside the RDS console with the query
	// editor. For more information, see Using the Data API for Aurora Serverless v1
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in
	// the Amazon Aurora User Guide.
	HttpEndpointEnabled *bool

	// A value that indicates whether the mapping of Amazon Web Services Identity and
	// Access Management (IAM) accounts to database accounts is enabled.
	IAMDatabaseAuthenticationEnabled *bool

	// The Provisioned IOPS (I/O operations per second) value. This setting is only for
	// non-Aurora Multi-AZ DB clusters.
	Iops *int32

	// If StorageEncrypted is enabled, the Amazon Web Services KMS key identifier for
	// the encrypted DB cluster. The Amazon Web Services KMS key identifier is the key
	// ARN, key ID, alias ARN, or alias name for the KMS key.
	KmsKeyId *string

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time

	// Contains the master username for the DB cluster.
	MasterUsername *string

	// The interval, in seconds, between points when Enhanced Monitoring metrics are
	// collected for the DB cluster. This setting is only for non-Aurora Multi-AZ DB
	// clusters.
	MonitoringInterval *int32

	// The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to
	// Amazon CloudWatch Logs. This setting is only for non-Aurora Multi-AZ DB
	// clusters.
	MonitoringRoleArn *string

	// Specifies whether the DB cluster has instances in multiple Availability Zones.
	MultiAZ *bool

	// A value that specifies that changes to the DB cluster are pending. This element
	// is only included when changes are pending. Specific changes are identified by
	// subelements.
	PendingModifiedValues *ClusterPendingModifiedValues

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string

	// True if Performance Insights is enabled for the DB cluster, and otherwise false.
	// This setting is only for non-Aurora Multi-AZ DB clusters.
	PerformanceInsightsEnabled *bool

	// The Amazon Web Services KMS key identifier for encryption of Performance
	// Insights data. The Amazon Web Services KMS key identifier is the key ARN, key
	// ID, alias ARN, or alias name for the KMS key. This setting is only for
	// non-Aurora Multi-AZ DB clusters.
	PerformanceInsightsKMSKeyId *string

	// The number of days to retain Performance Insights data. The default is 7 days.
	// The following values are valid:
	//
	// * 7
	//
	// * month * 31, where month is a number of
	// months from 1-23
	//
	// * 731
	//
	// For example, the following values are valid:
	//
	// * 93 (3
	// months * 31)
	//
	// * 341 (11 months * 31)
	//
	// * 589 (19 months * 31)
	//
	// * 731
	//
	// This
	// setting is only for non-Aurora Multi-AZ DB clusters.
	PerformanceInsightsRetentionPeriod *int32

	// Specifies the port that the database engine is listening on.
	Port *int32

	// Specifies the daily time range during which automated backups are created if
	// automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string

	// Specifies the weekly time range during which system maintenance can occur, in
	// Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string

	// Specifies the accessibility options for the DB instance. When the DB instance is
	// publicly accessible, its Domain Name System (DNS) endpoint resolves to the
	// private IP address from within the DB instance's virtual private cloud (VPC). It
	// resolves to the public IP address from outside of the DB instance's VPC. Access
	// to the DB instance is ultimately controlled by the security group it uses. That
	// public access is not permitted if the security group assigned to the DB instance
	// doesn't permit it. When the DB instance isn't publicly accessible, it is an
	// internal DB instance with a DNS name that resolves to a private IP address. For
	// more information, see CreateDBInstance. This setting is only for non-Aurora
	// Multi-AZ DB clusters.
	PubliclyAccessible *bool

	// Contains one or more identifiers of the read replicas associated with this DB
	// cluster.
	ReadReplicaIdentifiers []string

	// The reader endpoint for the DB cluster. The reader endpoint for a DB cluster
	// load-balances connections across the Aurora Replicas that are available in a DB
	// cluster. As clients request new connections to the reader endpoint, Aurora
	// distributes the connection requests among the Aurora Replicas in the DB cluster.
	// This functionality can help balance your read workload across multiple Aurora
	// Replicas in your DB cluster. If a failover occurs, and the Aurora Replica that
	// you are connected to is promoted to be the primary instance, your connection is
	// dropped. To continue sending your read workload to other Aurora Replicas in the
	// cluster, you can then reconnect to the reader endpoint.
	ReaderEndpoint *string

	// Contains the identifier of the source DB cluster if this DB cluster is a read
	// replica.
	ReplicationSourceIdentifier *string

	// Shows the scaling configuration for an Aurora DB cluster in serverless DB engine
	// mode. For more information, see Using Amazon Aurora Serverless v1
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
	// in the Amazon Aurora User Guide.
	ScalingConfigurationInfo *ScalingConfigurationInfo

	// Shows the scaling configuration for an Aurora Serverless v2 DB cluster. For more
	// information, see Using Amazon Aurora Serverless v2
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html)
	// in the Amazon Aurora User Guide.
	ServerlessV2ScalingConfiguration *ServerlessV2ScalingConfigurationInfo

	// Specifies the current state of this DB cluster.
	Status *string

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted bool

	// The storage type associated with the DB cluster. This setting is only for
	// non-Aurora Multi-AZ DB clusters.
	StorageType *string

	// A list of tags. For more information, see Tagging Amazon RDS Resources
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in
	// the Amazon RDS User Guide.
	TagList []Tag

	// Provides a list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []VpcSecurityGroupMembership

	noSmithyDocumentSerde
}

// This data type is used as a response element in the DescribeDBClusterBacktracks
// action.
type DBClusterBacktrack struct {

	// Contains the backtrack identifier.
	BacktrackIdentifier *string

	// The timestamp of the time at which the backtrack was requested.
	BacktrackRequestCreationTime *time.Time

	// The timestamp of the time to which the DB cluster was backtracked.
	BacktrackTo *time.Time

	// The timestamp of the time from which the DB cluster was backtracked.
	BacktrackedFrom *time.Time

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string

	// The status of the backtrack. This property returns one of the following
	// values:
	//
	// * applying - The backtrack is currently being applied to or rolled back
	// from the DB cluster.
	//
	// * completed - The backtrack has successfully been applied
	// to or rolled back from the DB cluster.
	//
	// * failed - An error occurred while the
	// backtrack was applied to or rolled back from the DB cluster.
	//
	// * pending - The
	// backtrack is currently pending application to or rollback from the DB cluster.
	Status *string

	noSmithyDocumentSerde
}

// This data type represents the information you need to connect to an Amazon
// Aurora DB cluster. This data type is used as a response element in the following
// actions:
//
// * CreateDBClusterEndpoint
//
// * DescribeDBClusterEndpoints
//
// *
// ModifyDBClusterEndpoint
//
// * DeleteDBClusterEndpoint
//
// For the data structure that
// represents Amazon RDS DB instance endpoints, see Endpoint.
type DBClusterEndpoint struct {

	// The type associated with a custom endpoint. One of: READER, WRITER, ANY.
	CustomEndpointType *string

	// The Amazon Resource Name (ARN) for the endpoint.
	DBClusterEndpointArn *string

	// The identifier associated with the endpoint. This parameter is stored as a
	// lowercase string.
	DBClusterEndpointIdentifier *string

	// A unique system-generated identifier for an endpoint. It remains the same for
	// the whole life of the endpoint.
	DBClusterEndpointResourceIdentifier *string

	// The DB cluster identifier of the DB cluster associated with the endpoint. This
	// parameter is stored as a lowercase string.
	DBClusterIdentifier *string

	// The DNS address of the endpoint.
	Endpoint *string

	// The type of the endpoint. One of: READER, WRITER, CUSTOM.
	EndpointType *string

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []string

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []string

	// The current status of the endpoint. One of: creating, available, deleting,
	// inactive, modifying. The inactive state applies to an endpoint that can't be
	// used for a certain kind of cluster, such as a writer endpoint for a read-only
	// secondary cluster in a global database.
	Status *string

	noSmithyDocumentSerde
}

// Contains information about an instance that is part of a DB cluster.
type DBClusterMember struct {

	// Specifies the status of the DB cluster parameter group for this member of the DB
	// cluster.
	DBClusterParameterGroupStatus *string

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string

	// Value that is true if the cluster member is the primary instance for the DB
	// cluster and false otherwise.
	IsClusterWriter bool

	// A value that specifies the order in which an Aurora Replica is promoted to the
	// primary instance after a failure of the existing primary instance. For more
	// information, see  Fault Tolerance for an Aurora DB Cluster
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
	// in the Amazon Aurora User Guide.
	PromotionTier *int32

	noSmithyDocumentSerde
}

// Contains status information for a DB cluster option group.
type DBClusterOptionGroupStatus struct {

	// Specifies the name of the DB cluster option group.
	DBClusterOptionGroupName *string

	// Specifies the status of the DB cluster option group.
	Status *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB cluster parameter group. This data type
// is used as a response element in the DescribeDBClusterParameterGroups action.
type DBClusterParameterGroup struct {

	// The Amazon Resource Name (ARN) for the DB cluster parameter group.
	DBClusterParameterGroupArn *string

	// The name of the DB cluster parameter group.
	DBClusterParameterGroupName *string

	// The name of the DB parameter group family that this DB cluster parameter group
	// is compatible with.
	DBParameterGroupFamily *string

	// Provides the customer-specified description for this DB cluster parameter group.
	Description *string

	noSmithyDocumentSerde
}

// Describes an Amazon Web Services Identity and Access Management (IAM) role that
// is associated with a DB cluster.
type DBClusterRole struct {

	// The name of the feature associated with the Amazon Web Services Identity and
	// Access Management (IAM) role. For information about supported feature names, see
	// DBEngineVersion.
	FeatureName *string

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the DB
	// cluster.
	RoleArn *string

	// Describes the state of association between the IAM role and the DB cluster. The
	// Status property returns one of the following values:
	//
	// * ACTIVE - the IAM role
	// ARN is associated with the DB cluster and can be used to access other Amazon Web
	// Services on your behalf.
	//
	// * PENDING - the IAM role ARN is being associated with
	// the DB cluster.
	//
	// * INVALID - the IAM role ARN is associated with the DB cluster,
	// but the DB cluster is unable to assume the IAM role in order to access other
	// Amazon Web Services on your behalf.
	Status *string

	noSmithyDocumentSerde
}

// Contains the details for an Amazon RDS DB cluster snapshot This data type is
// used as a response element in the DescribeDBClusterSnapshots action.
type DBClusterSnapshot struct {

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage int32

	// Provides the list of Availability Zones (AZs) where instances in the DB cluster
	// snapshot can be restored.
	AvailabilityZones []string

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string

	// The Amazon Resource Name (ARN) for the DB cluster snapshot.
	DBClusterSnapshotArn *string

	// Specifies the identifier for the DB cluster snapshot.
	DBClusterSnapshotIdentifier *string

	// Specifies the name of the database engine for this DB cluster snapshot.
	Engine *string

	// Provides the engine mode of the database engine for this DB cluster snapshot.
	EngineMode *string

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string

	// True if mapping of Amazon Web Services Identity and Access Management (IAM)
	// accounts to database accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled bool

	// If StorageEncrypted is true, the Amazon Web Services KMS key identifier for the
	// encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the
	// key ARN, key ID, alias ARN, or alias name for the KMS key.
	KmsKeyId *string

	// Provides the license model information for this DB cluster snapshot.
	LicenseModel *string

	// Provides the master username for this DB cluster snapshot.
	MasterUsername *string

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress int32

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port int32

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string

	// If the DB cluster snapshot was copied from a source DB cluster snapshot, the
	// Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null
	// value.
	SourceDBClusterSnapshotArn *string

	// Specifies the status of this DB cluster snapshot. Valid statuses are the
	// following:
	//
	// * available
	//
	// * copying
	//
	// * creating
	Status *string

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted bool

	// A list of tags. For more information, see Tagging Amazon RDS Resources
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in
	// the Amazon RDS User Guide.
	TagList []Tag

	// Provides the VPC ID associated with the DB cluster snapshot.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains the name and values of a manual DB cluster snapshot attribute. Manual
// DB cluster snapshot attributes are used to authorize other Amazon Web Services
// accounts to restore a manual DB cluster snapshot. For more information, see the
// ModifyDBClusterSnapshotAttribute API action.
type DBClusterSnapshotAttribute struct {

	// The name of the manual DB cluster snapshot attribute. The attribute named
	// restore refers to the list of Amazon Web Services accounts that have permission
	// to copy or restore the manual DB cluster snapshot. For more information, see the
	// ModifyDBClusterSnapshotAttribute API action.
	AttributeName *string

	// The value(s) for the manual DB cluster snapshot attribute. If the AttributeName
	// field is set to restore, then this element returns a list of IDs of the Amazon
	// Web Services accounts that are authorized to copy or restore the manual DB
	// cluster snapshot. If a value of all is in the list, then the manual DB cluster
	// snapshot is public and available for any Amazon Web Services account to copy or
	// restore.
	AttributeValues []string

	noSmithyDocumentSerde
}

// Contains the results of a successful call to the
// DescribeDBClusterSnapshotAttributes API action. Manual DB cluster snapshot
// attributes are used to authorize other Amazon Web Services accounts to copy or
// restore a manual DB cluster snapshot. For more information, see the
// ModifyDBClusterSnapshotAttribute API action.
type DBClusterSnapshotAttributesResult struct {

	// The list of attributes and values for the manual DB cluster snapshot.
	DBClusterSnapshotAttributes []DBClusterSnapshotAttribute

	// The identifier of the manual DB cluster snapshot that the attributes apply to.
	DBClusterSnapshotIdentifier *string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the action
// DescribeDBEngineVersions.
type DBEngineVersion struct {

	// The creation time of the DB engine version.
	CreateTime *time.Time

	// The description of the database engine.
	DBEngineDescription *string

	// The ARN of the custom engine version.
	DBEngineVersionArn *string

	// The description of the database engine version.
	DBEngineVersionDescription *string

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string

	// The name of the Amazon S3 bucket that contains your database installation files.
	DatabaseInstallationFilesS3BucketName *string

	// The Amazon S3 directory that contains the database installation files. If not
	// specified, then no prefix is assumed.
	DatabaseInstallationFilesS3Prefix *string

	// The default character set for new instances of this engine version, if the
	// CharacterSetName parameter of the CreateDBInstance API isn't specified.
	DefaultCharacterSet *CharacterSet

	// The name of the database engine.
	Engine *string

	// The version number of the database engine.
	EngineVersion *string

	// The types of logs that the database engine has available for export to
	// CloudWatch Logs.
	ExportableLogTypes []string

	// The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter
	// is required for RDS Custom, but optional for Amazon RDS.
	KMSKeyId *string

	// The major engine version of the CEV.
	MajorEngineVersion *string

	// The status of the DB engine version, either available or deprecated.
	Status *string

	// A list of the character sets supported by this engine for the CharacterSetName
	// parameter of the CreateDBInstance operation.
	SupportedCharacterSets []CharacterSet

	// A list of the supported DB engine modes.
	SupportedEngineModes []string

	// A list of features supported by the DB engine. The supported features vary by DB
	// engine and DB engine version. To determine the supported features for a specific
	// DB engine and DB engine version using the CLI, use the following command: aws
	// rds describe-db-engine-versions --engine --engine-version  For example, to
	// determine the supported features for RDS for PostgreSQL version 13.3 using the
	// CLI, use the following command: aws rds describe-db-engine-versions --engine
	// postgres --engine-version 13.3 The supported features are listed under
	// SupportedFeatureNames in the output.
	SupportedFeatureNames []string

	// A list of the character sets supported by the Oracle DB engine for the
	// NcharCharacterSetName parameter of the CreateDBInstance operation.
	SupportedNcharCharacterSets []CharacterSet

	// A list of the time zones supported by this engine for the Timezone parameter of
	// the CreateDBInstance action.
	SupportedTimezones []Timezone

	// A value that indicates whether the engine version supports Babelfish for Aurora
	// PostgreSQL.
	SupportsBabelfish bool

	// A value that indicates whether you can use Aurora global databases with a
	// specific DB engine version.
	SupportsGlobalDatabases bool

	// A value that indicates whether the engine version supports exporting the log
	// types specified by ExportableLogTypes to CloudWatch Logs.
	SupportsLogExportsToCloudwatchLogs bool

	// A value that indicates whether you can use Aurora parallel query with a specific
	// DB engine version.
	SupportsParallelQuery bool

	// Indicates whether the database engine version supports read replicas.
	SupportsReadReplica bool

	// A list of tags. For more information, see Tagging Amazon RDS Resources
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in
	// the Amazon RDS User Guide.
	TagList []Tag

	// A list of engine versions that this database engine version can be upgraded to.
	ValidUpgradeTarget []UpgradeTarget

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB instance. This data type is used as a
// response element in the operations CreateDBInstance,
// CreateDBInstanceReadReplica, DeleteDBInstance, DescribeDBInstances,
// ModifyDBInstance, PromoteReadReplica, RebootDBInstance,
// RestoreDBInstanceFromDBSnapshot, RestoreDBInstanceFromS3,
// RestoreDBInstanceToPointInTime, StartDBInstance, and StopDBInstance.
type DBInstance struct {

	// Indicates whether engine-native audit fields are included in the database
	// activity stream.
	ActivityStreamEngineNativeAuditFieldsIncluded *bool

	// The name of the Amazon Kinesis data stream used for the database activity
	// stream.
	ActivityStreamKinesisStreamName *string

	// The Amazon Web Services KMS key identifier used for encrypting messages in the
	// database activity stream. The Amazon Web Services KMS key identifier is the key
	// ARN, key ID, alias ARN, or alias name for the KMS key.
	ActivityStreamKmsKeyId *string

	// The mode of the database activity stream. Database events such as a change or
	// access generate an activity stream event. RDS for Oracle always handles these
	// events asynchronously.
	ActivityStreamMode ActivityStreamMode

	// The status of the policy state of the activity stream.
	ActivityStreamPolicyStatus ActivityStreamPolicyStatus

	// The status of the database activity stream.
	ActivityStreamStatus ActivityStreamStatus

	// Specifies the allocated storage size specified in gibibytes (GiB).
	AllocatedStorage int32

	// The Amazon Web Services Identity and Access Management (IAM) roles associated
	// with the DB instance.
	AssociatedRoles []DBInstanceRole

	// A value that indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade bool

	// The time when a stopped DB instance is restarted automatically.
	AutomaticRestartTime *time.Time

	// The automation mode of the RDS Custom DB instance: full or all paused. If full,
	// the DB instance automates monitoring and instance recovery. If all paused, the
	// instance pauses automation for the duration set by
	// --resume-full-automation-mode-minutes.
	AutomationMode AutomationMode

	// Specifies the name of the Availability Zone the DB instance is located in.
	AvailabilityZone *string

	// The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services
	// Backup.
	AwsBackupRecoveryPointArn *string

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod int32

	// Specifies where automated backups and manual snapshots are stored: Amazon Web
	// Services Outposts or the Amazon Web Services Region.
	BackupTarget *string

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string

	// If present, specifies the name of the character set that this instance is
	// associated with.
	CharacterSetName *string

	// Specifies whether tags are copied from the DB instance to snapshots of the DB
	// instance. Amazon Aurora Not applicable. Copying tags to snapshots is managed by
	// the DB cluster. Setting this value for an Aurora DB instance has no effect on
	// the DB cluster setting. For more information, see DBCluster.
	CopyTagsToSnapshot bool

	// The instance profile associated with the underlying Amazon EC2 instance of an
	// RDS Custom DB instance. The instance profile must meet the following
	// requirements:
	//
	// * The profile must exist in your account.
	//
	// * The profile must
	// have an IAM role that Amazon EC2 has permissions to assume.
	//
	// * The instance
	// profile name and the associated IAM role name must start with the prefix
	// AWSRDSCustom.
	//
	// For the list of permissions required for the IAM role, see
	// Configure IAM and your VPC
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc)
	// in the Amazon RDS User Guide.
	CustomIamInstanceProfile *string

	// Specifies whether a customer-owned IP address (CoIP) is enabled for an RDS on
	// Outposts DB instance. A CoIP provides local or external connectivity to
	// resources in your Outpost subnets through your on-premises network. For some use
	// cases, a CoIP can provide lower latency for connections to the DB instance from
	// outside of its virtual private cloud (VPC) on your local network. For more
	// information about RDS on Outposts, see Working with Amazon RDS on Amazon Web
	// Services Outposts
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in
	// the Amazon RDS User Guide. For more information about CoIPs, see Customer-owned
	// IP addresses
	// (https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing)
	// in the Amazon Web Services Outposts User Guide.
	CustomerOwnedIpEnabled *bool

	// If the DB instance is a member of a DB cluster, contains the name of the DB
	// cluster that the DB instance is a member of.
	DBClusterIdentifier *string

	// The Amazon Resource Name (ARN) for the DB instance.
	DBInstanceArn *string

	// The list of replicated automated backups associated with the DB instance.
	DBInstanceAutomatedBackupsReplications []DBInstanceAutomatedBackupsReplication

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string

	// Contains a user-supplied database identifier. This identifier is the unique key
	// that identifies a DB instance.
	DBInstanceIdentifier *string

	// Specifies the current state of this database. For information about DB instance
	// statuses, see Viewing DB instance status
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status)
	// in the Amazon RDS User Guide.
	DBInstanceStatus *string

	// The meaning of this parameter differs according to the database engine you use.
	// MySQL, MariaDB, SQL Server, PostgreSQL Contains the name of the initial database
	// of this instance that was provided at create time, if one was specified when the
	// DB instance was created. This same name is returned for the life of the DB
	// instance. Type: String Oracle Contains the Oracle System ID (SID) of the created
	// DB instance. Not shown when the returned parameters do not apply to an Oracle DB
	// instance.
	DBName *string

	// Provides the list of DB parameter groups applied to this DB instance.
	DBParameterGroups []DBParameterGroupStatus

	// A list of DB security group elements containing DBSecurityGroup.Name and
	// DBSecurityGroup.Status subelements.
	DBSecurityGroups []DBSecurityGroupMembership

	// Specifies information on the subnet group associated with the DB instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup

	// Specifies the port that the DB instance listens on. If the DB instance is part
	// of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort int32

	// The Amazon Web Services Region-unique, immutable identifier for the DB instance.
	// This identifier is found in Amazon Web Services CloudTrail log entries whenever
	// the Amazon Web Services KMS key for the DB instance is accessed.
	DbiResourceId *string

	// Indicates if the DB instance has deletion protection enabled. The database can't
	// be deleted when deletion protection is enabled. For more information, see
	// Deleting a DB Instance
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
	DeletionProtection bool

	// The Active Directory Domain membership records associated with the DB instance.
	DomainMemberships []DomainMembership

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs. Log types vary by DB engine. For information about the log types for each
	// DB engine, see Amazon RDS Database Log Files
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html) in
	// the Amazon RDS User Guide.
	EnabledCloudwatchLogsExports []string

	// Specifies the connection endpoint. The endpoint might not be shown for instances
	// whose status is creating.
	Endpoint *Endpoint

	// The name of the database engine to be used for this DB instance.
	Engine *string

	// Indicates the database engine version.
	EngineVersion *string

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that
	// receives the Enhanced Monitoring metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string

	// True if mapping of Amazon Web Services Identity and Access Management (IAM)
	// accounts to database accounts is enabled, and otherwise false. IAM database
	// authentication can be enabled for the following database engines
	//
	// * For MySQL
	// 5.6, minor version 5.6.34 or higher
	//
	// * For MySQL 5.7, minor version 5.7.16 or
	// higher
	//
	// * Aurora 5.6 or higher. To enable IAM database authentication for
	// Aurora, see DBCluster Type.
	IAMDatabaseAuthenticationEnabled bool

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *time.Time

	// Specifies the Provisioned IOPS (I/O operations per second) value.
	Iops *int32

	// If StorageEncrypted is true, the Amazon Web Services KMS key identifier for the
	// encrypted DB instance. The Amazon Web Services KMS key identifier is the key
	// ARN, key ID, alias ARN, or alias name for the KMS key.
	KmsKeyId *string

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time

	// License model information for this DB instance. This setting doesn't apply to
	// RDS Custom.
	LicenseModel *string

	// Specifies the listener connection endpoint for SQL Server Always On.
	ListenerEndpoint *Endpoint

	// Contains the master username for the DB instance.
	MasterUsername *string

	// The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale
	// the storage of the DB instance.
	MaxAllocatedStorage *int32

	// The interval, in seconds, between points when Enhanced Monitoring metrics are
	// collected for the DB instance.
	MonitoringInterval *int32

	// The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to
	// Amazon CloudWatch Logs.
	MonitoringRoleArn *string

	// Specifies if the DB instance is a Multi-AZ deployment. This setting doesn't
	// apply to RDS Custom.
	MultiAZ bool

	// The name of the NCHAR character set for the Oracle DB instance. This character
	// set specifies the Unicode encoding for data stored in table columns of type
	// NCHAR, NCLOB, or NVARCHAR2.
	NcharCharacterSetName *string

	// The network type of the DB instance. Valid values:
	//
	// * IPV4
	//
	// * DUAL
	//
	// The network
	// type is determined by the DBSubnetGroup specified for the DB instance. A
	// DBSubnetGroup can support only the IPv4 protocol or the IPv4 and the IPv6
	// protocols (DUAL). For more information, see  Working with a DB instance in a VPC
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
	// in the Amazon RDS User Guide and  Working with a DB instance in a VPC
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
	// in the Amazon Aurora User Guide.
	NetworkType *string

	// Provides the list of option group memberships for this DB instance.
	OptionGroupMemberships []OptionGroupMembership

	// A value that specifies that changes to the DB instance are pending. This element
	// is only included when changes are pending. Specific changes are identified by
	// subelements.
	PendingModifiedValues *PendingModifiedValues

	// True if Performance Insights is enabled for the DB instance, and otherwise
	// false.
	PerformanceInsightsEnabled *bool

	// The Amazon Web Services KMS key identifier for encryption of Performance
	// Insights data. The Amazon Web Services KMS key identifier is the key ARN, key
	// ID, alias ARN, or alias name for the KMS key.
	PerformanceInsightsKMSKeyId *string

	// The number of days to retain Performance Insights data. The default is 7 days.
	// The following values are valid:
	//
	// * 7
	//
	// * month * 31, where month is a number of
	// months from 1-23
	//
	// * 731
	//
	// For example, the following values are valid:
	//
	// * 93 (3
	// months * 31)
	//
	// * 341 (11 months * 31)
	//
	// * 589 (19 months * 31)
	//
	// * 731
	PerformanceInsightsRetentionPeriod *int32

	// Specifies the daily time range during which automated backups are created if
	// automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string

	// Specifies the weekly time range during which system maintenance can occur, in
	// Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []ProcessorFeature

	// A value that specifies the order in which an Aurora Replica is promoted to the
	// primary instance after a failure of the existing primary instance. For more
	// information, see  Fault Tolerance for an Aurora DB Cluster
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
	// in the Amazon Aurora User Guide.
	PromotionTier *int32

	// Specifies the accessibility options for the DB instance. When the DB cluster is
	// publicly accessible, its Domain Name System (DNS) endpoint resolves to the
	// private IP address from within the DB cluster's virtual private cloud (VPC). It
	// resolves to the public IP address from outside of the DB cluster's VPC. Access
	// to the DB cluster is ultimately controlled by the security group it uses. That
	// public access isn't permitted if the security group assigned to the DB cluster
	// doesn't permit it. When the DB instance isn't publicly accessible, it is an
	// internal DB instance with a DNS name that resolves to a private IP address. For
	// more information, see CreateDBInstance.
	PubliclyAccessible bool

	// Contains one or more identifiers of Aurora DB clusters to which the RDS DB
	// instance is replicated as a read replica. For example, when you create an Aurora
	// read replica of an RDS for MySQL DB instance, the Aurora MySQL DB cluster for
	// the Aurora read replica is shown. This output doesn't contain information about
	// cross-Region Aurora read replicas. Currently, each RDS DB instance can have only
	// one Aurora read replica.
	ReadReplicaDBClusterIdentifiers []string

	// Contains one or more identifiers of the read replicas associated with this DB
	// instance.
	ReadReplicaDBInstanceIdentifiers []string

	// Contains the identifier of the source DB instance if this DB instance is a read
	// replica.
	ReadReplicaSourceDBInstanceIdentifier *string

	// The open mode of an Oracle read replica. The default is open-read-only. For more
	// information, see Working with Oracle Read Replicas for Amazon RDS
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html)
	// in the Amazon RDS User Guide. This attribute is only supported in RDS for
	// Oracle.
	ReplicaMode ReplicaMode

	// The number of minutes to pause the automation. When the time period ends, RDS
	// Custom resumes full automation. The minimum value is 60 (default). The maximum
	// value is 1,440.
	ResumeFullAutomationModeTime *time.Time

	// If present, specifies the name of the secondary Availability Zone for a DB
	// instance with multi-AZ support.
	SecondaryAvailabilityZone *string

	// The status of a read replica. If the instance isn't a read replica, this is
	// blank.
	StatusInfos []DBInstanceStatusInfo

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted bool

	// Specifies the storage type associated with DB instance.
	StorageType *string

	// A list of tags. For more information, see Tagging Amazon RDS Resources
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in
	// the Amazon RDS User Guide.
	TagList []Tag

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string

	// The time zone of the DB instance. In most cases, the Timezone element is empty.
	// Timezone content appears only for Microsoft SQL Server DB instances that were
	// created with a time zone specified.
	Timezone *string

	// Provides a list of VPC security group elements that the DB instance belongs to.
	VpcSecurityGroups []VpcSecurityGroupMembership

	noSmithyDocumentSerde
}

// An automated backup of a DB instance. It consists of system backups, transaction
// logs, and the database instance properties that existed at the time you deleted
// the source instance.
type DBInstanceAutomatedBackup struct {

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage int32

	// The Availability Zone that the automated backup was created in. For information
	// on Amazon Web Services Regions and Availability Zones, see Regions and
	// Availability Zones
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
	AvailabilityZone *string

	// The retention period for the automated backups.
	BackupRetentionPeriod *int32

	// Specifies where automated backups are stored: Amazon Web Services Outposts or
	// the Amazon Web Services Region.
	BackupTarget *string

	// The Amazon Resource Name (ARN) for the automated backups.
	DBInstanceArn *string

	// The Amazon Resource Name (ARN) for the replicated automated backups.
	DBInstanceAutomatedBackupsArn *string

	// The list of replications to different Amazon Web Services Regions associated
	// with the automated backup.
	DBInstanceAutomatedBackupsReplications []DBInstanceAutomatedBackupsReplication

	// The customer id of the instance that is/was associated with the automated
	// backup.
	DBInstanceIdentifier *string

	// The identifier for the source DB instance, which can't be changed and which is
	// unique to an Amazon Web Services Region.
	DbiResourceId *string

	// Specifies whether the automated backup is encrypted.
	Encrypted bool

	// The name of the database engine for this automated backup.
	Engine *string

	// The version of the database engine for the automated backup.
	EngineVersion *string

	// True if mapping of Amazon Web Services Identity and Access Management (IAM)
	// accounts to database accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled bool

	// Provides the date and time that the DB instance was created.
	InstanceCreateTime *time.Time

	// The IOPS (I/O operations per second) value for the automated backup.
	Iops *int32

	// The Amazon Web Services KMS key ID for an automated backup. The Amazon Web
	// Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for
	// the KMS key.
	KmsKeyId *string

	// License model information for the automated backup.
	LicenseModel *string

	// The license model of an automated backup.
	MasterUsername *string

	// The option group the automated backup is associated with. If omitted, the
	// default option group for the engine specified is used.
	OptionGroupName *string

	// The port number that the automated backup used for connections. Default:
	// Inherits from the source DB instance Valid Values: 1150-65535
	Port int32

	// The Amazon Web Services Region associated with the automated backup.
	Region *string

	// Earliest and latest time an instance can be restored to.
	RestoreWindow *RestoreWindow

	// Provides a list of status information for an automated backup:
	//
	// * active -
	// automated backups for current instances
	//
	// * retained - automated backups for
	// deleted instances
	//
	// * creating - automated backups that are waiting for the first
	// automated snapshot to be available.
	Status *string

	// Specifies the storage type associated with the automated backup.
	StorageType *string

	// The ARN from the key store with which the automated backup is associated for TDE
	// encryption.
	TdeCredentialArn *string

	// The time zone of the automated backup. In most cases, the Timezone element is
	// empty. Timezone content appears only for Microsoft SQL Server DB instances that
	// were created with a time zone specified.
	Timezone *string

	// Provides the VPC ID associated with the DB instance
	VpcId *string

	noSmithyDocumentSerde
}

// Automated backups of a DB instance replicated to another Amazon Web Services
// Region. They consist of system backups, transaction logs, and database instance
// properties.
type DBInstanceAutomatedBackupsReplication struct {

	// The Amazon Resource Name (ARN) of the replicated automated backups.
	DBInstanceAutomatedBackupsArn *string

	noSmithyDocumentSerde
}

// Describes an Amazon Web Services Identity and Access Management (IAM) role that
// is associated with a DB instance.
type DBInstanceRole struct {

	// The name of the feature associated with the Amazon Web Services Identity and
	// Access Management (IAM) role. For information about supported feature names, see
	// DBEngineVersion.
	FeatureName *string

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the DB
	// instance.
	RoleArn *string

	// Describes the state of association between the IAM role and the DB instance. The
	// Status property returns one of the following values:
	//
	// * ACTIVE - the IAM role
	// ARN is associated with the DB instance and can be used to access other Amazon
	// Web Services services on your behalf.
	//
	// * PENDING - the IAM role ARN is being
	// associated with the DB instance.
	//
	// * INVALID - the IAM role ARN is associated
	// with the DB instance, but the DB instance is unable to assume the IAM role in
	// order to access other Amazon Web Services services on your behalf.
	Status *string

	noSmithyDocumentSerde
}

// Provides a list of status information for a DB instance.
type DBInstanceStatusInfo struct {

	// Details of the error if there is an error for the instance. If the instance
	// isn't in an error state, this value is blank.
	Message *string

	// Boolean value that is true if the instance is operating normally, or false if
	// the instance is in an error state.
	Normal bool

	// Status of the DB instance. For a StatusType of read replica, the values can be
	// replicating, replication stop point set, replication stop point reached, error,
	// stopped, or terminated.
	Status *string

	// This value is currently "read replication."
	StatusType *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB parameter group. This data type is used
// as a response element in the DescribeDBParameterGroups action.
type DBParameterGroup struct {

	// The Amazon Resource Name (ARN) for the DB parameter group.
	DBParameterGroupArn *string

	// The name of the DB parameter group family that this DB parameter group is
	// compatible with.
	DBParameterGroupFamily *string

	// The name of the DB parameter group.
	DBParameterGroupName *string

	// Provides the customer-specified description for this DB parameter group.
	Description *string

	noSmithyDocumentSerde
}

// The status of the DB parameter group. This data type is used as a response
// element in the following actions:
//
// * CreateDBInstance
//
// *
// CreateDBInstanceReadReplica
//
// * DeleteDBInstance
//
// * ModifyDBInstance
//
// *
// RebootDBInstance
//
// * RestoreDBInstanceFromDBSnapshot
type DBParameterGroupStatus struct {

	// The name of the DB parameter group.
	DBParameterGroupName *string

	// The status of parameter updates.
	ParameterApplyStatus *string

	noSmithyDocumentSerde
}

// The data structure representing a proxy managed by the RDS Proxy. This data type
// is used as a response element in the DescribeDBProxies action.
type DBProxy struct {

	// One or more data structures specifying the authorization mechanism to connect to
	// the associated RDS DB instance or Aurora DB cluster.
	Auth []UserAuthConfigInfo

	// The date and time when the proxy was first created.
	CreatedDate *time.Time

	// The Amazon Resource Name (ARN) for the proxy.
	DBProxyArn *string

	// The identifier for the proxy. This name must be unique for all proxies owned by
	// your Amazon Web Services account in the specified Amazon Web Services Region.
	DBProxyName *string

	// Whether the proxy includes detailed information about SQL statements in its
	// logs. This information helps you to debug issues involving SQL behavior or the
	// performance and scalability of the proxy connections. The debug information
	// includes the text of SQL statements that you submit through the proxy. Thus,
	// only enable this setting when needed for debugging, and only when you have
	// security measures in place to safeguard any sensitive information that appears
	// in the logs.
	DebugLogging bool

	// The endpoint that you can use to connect to the DB proxy. You include the
	// endpoint value in the connection string for a database client application.
	Endpoint *string

	// The kinds of databases that the proxy can connect to. This value determines
	// which database network protocol the proxy recognizes when it interprets network
	// traffic to and from the database. MYSQL supports Aurora MySQL, RDS for MariaDB,
	// and RDS for MySQL databases. POSTGRESQL supports Aurora PostgreSQL and RDS for
	// PostgreSQL databases.
	EngineFamily *string

	// The number of seconds a connection to the proxy can have no activity before the
	// proxy drops the client connection. The proxy keeps the underlying database
	// connection open and puts it back into the connection pool for reuse by later
	// connection requests. Default: 1800 (30 minutes) Constraints: 1 to 28,800
	IdleClientTimeout int32

	// Indicates whether Transport Layer Security (TLS) encryption is required for
	// connections to the proxy.
	RequireTLS bool

	// The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access
	// Amazon Secrets Manager.
	RoleArn *string

	// The current status of this proxy. A status of available means the proxy is ready
	// to handle requests. Other values indicate that you must wait for the proxy to be
	// ready, or take some action to resolve an issue.
	Status DBProxyStatus

	// The date and time when the proxy was last updated.
	UpdatedDate *time.Time

	// Provides the VPC ID of the DB proxy.
	VpcId *string

	// Provides a list of VPC security groups that the proxy belongs to.
	VpcSecurityGroupIds []string

	// The EC2 subnet IDs for the proxy.
	VpcSubnetIds []string

	noSmithyDocumentSerde
}

// The data structure representing an endpoint associated with a DB proxy. RDS
// automatically creates one endpoint for each DB proxy. For Aurora DB clusters,
// you can associate additional endpoints with the same DB proxy. These endpoints
// can be read/write or read-only. They can also reside in different VPCs than the
// associated DB proxy. This data type is used as a response element in the
// DescribeDBProxyEndpoints operation.
type DBProxyEndpoint struct {

	// The date and time when the DB proxy endpoint was first created.
	CreatedDate *time.Time

	// The Amazon Resource Name (ARN) for the DB proxy endpoint.
	DBProxyEndpointArn *string

	// The name for the DB proxy endpoint. An identifier must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen
	// or contain two consecutive hyphens.
	DBProxyEndpointName *string

	// The identifier for the DB proxy that is associated with this DB proxy endpoint.
	DBProxyName *string

	// The endpoint that you can use to connect to the DB proxy. You include the
	// endpoint value in the connection string for a database client application.
	Endpoint *string

	// A value that indicates whether this endpoint is the default endpoint for the
	// associated DB proxy. Default DB proxy endpoints always have read/write
	// capability. Other endpoints that you associate with the DB proxy can be either
	// read/write or read-only.
	IsDefault bool

	// The current status of this DB proxy endpoint. A status of available means the
	// endpoint is ready to handle requests. Other values indicate that you must wait
	// for the endpoint to be ready, or take some action to resolve an issue.
	Status DBProxyEndpointStatus

	// A value that indicates whether the DB proxy endpoint can be used for read/write
	// or read-only operations.
	TargetRole DBProxyEndpointTargetRole

	// Provides the VPC ID of the DB proxy endpoint.
	VpcId *string

	// Provides a list of VPC security groups that the DB proxy endpoint belongs to.
	VpcSecurityGroupIds []string

	// The EC2 subnet IDs for the DB proxy endpoint.
	VpcSubnetIds []string

	noSmithyDocumentSerde
}

// Contains the details for an RDS Proxy target. It represents an RDS DB instance
// or Aurora DB cluster that the proxy can connect to. One or more targets are
// associated with an RDS Proxy target group. This data type is used as a response
// element in the DescribeDBProxyTargets action.
type DBProxyTarget struct {

	// The writer endpoint for the RDS DB instance or Aurora DB cluster.
	Endpoint *string

	// The port that the RDS Proxy uses to connect to the target RDS DB instance or
	// Aurora DB cluster.
	Port int32

	// The identifier representing the target. It can be the instance identifier for an
	// RDS DB instance, or the cluster identifier for an Aurora DB cluster.
	RdsResourceId *string

	// A value that indicates whether the target of the proxy can be used for
	// read/write or read-only operations.
	Role TargetRole

	// The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
	TargetArn *string

	// Information about the connection health of the RDS Proxy target.
	TargetHealth *TargetHealth

	// The DB cluster identifier when the target represents an Aurora DB cluster. This
	// field is blank when the target represents an RDS DB instance.
	TrackedClusterId *string

	// Specifies the kind of database, such as an RDS DB instance or an Aurora DB
	// cluster, that the target represents.
	Type TargetType

	noSmithyDocumentSerde
}

// Represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy
// can connect to. Currently, each target group is associated with exactly one RDS
// DB instance or Aurora DB cluster. This data type is used as a response element
// in the DescribeDBProxyTargetGroups action.
type DBProxyTargetGroup struct {

	// The settings that determine the size and behavior of the connection pool for the
	// target group.
	ConnectionPoolConfig *ConnectionPoolConfigurationInfo

	// The date and time when the target group was first created.
	CreatedDate *time.Time

	// The identifier for the RDS proxy associated with this target group.
	DBProxyName *string

	// Whether this target group is the first one used for connection requests by the
	// associated proxy. Because each proxy is currently associated with a single
	// target group, currently this setting is always true.
	IsDefault bool

	// The current status of this target group. A status of available means the target
	// group is correctly associated with a database. Other values indicate that you
	// must wait for the target group to be ready, or take some action to resolve an
	// issue.
	Status *string

	// The Amazon Resource Name (ARN) representing the target group.
	TargetGroupArn *string

	// The identifier for the target group. This name must be unique for all target
	// groups owned by your Amazon Web Services account in the specified Amazon Web
	// Services Region.
	TargetGroupName *string

	// The date and time when the target group was last updated.
	UpdatedDate *time.Time

	noSmithyDocumentSerde
}

// Contains the details for an Amazon RDS DB security group. This data type is used
// as a response element in the DescribeDBSecurityGroups action.
type DBSecurityGroup struct {

	// The Amazon Resource Name (ARN) for the DB security group.
	DBSecurityGroupArn *string

	// Provides the description of the DB security group.
	DBSecurityGroupDescription *string

	// Specifies the name of the DB security group.
	DBSecurityGroupName *string

	// Contains a list of EC2SecurityGroup elements.
	EC2SecurityGroups []EC2SecurityGroup

	// Contains a list of IPRange elements.
	IPRanges []IPRange

	// Provides the Amazon Web Services ID of the owner of a specific DB security
	// group.
	OwnerId *string

	// Provides the VpcId of the DB security group.
	VpcId *string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the following actions:
//
// *
// ModifyDBInstance
//
// * RebootDBInstance
//
// * RestoreDBInstanceFromDBSnapshot
//
// *
// RestoreDBInstanceToPointInTime
type DBSecurityGroupMembership struct {

	// The name of the DB security group.
	DBSecurityGroupName *string

	// The status of the DB security group.
	Status *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB snapshot. This data type is used as a
// response element in the DescribeDBSnapshots action.
type DBSnapshot struct {

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage int32

	// Specifies the name of the Availability Zone the DB instance was located in at
	// the time of the DB snapshot.
	AvailabilityZone *string

	// Specifies the DB instance identifier of the DB instance this DB snapshot was
	// created from.
	DBInstanceIdentifier *string

	// The Amazon Resource Name (ARN) for the DB snapshot.
	DBSnapshotArn *string

	// Specifies the identifier for the DB snapshot.
	DBSnapshotIdentifier *string

	// The identifier for the source DB instance, which can't be changed and which is
	// unique to an Amazon Web Services Region.
	DbiResourceId *string

	// Specifies whether the DB snapshot is encrypted.
	Encrypted bool

	// Specifies the name of the database engine.
	Engine *string

	// Specifies the version of the database engine.
	EngineVersion *string

	// True if mapping of Amazon Web Services Identity and Access Management (IAM)
	// accounts to database accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled bool

	// Specifies the time in Coordinated Universal Time (UTC) when the DB instance,
	// from which the snapshot was taken, was created.
	InstanceCreateTime *time.Time

	// Specifies the Provisioned IOPS (I/O operations per second) value of the DB
	// instance at the time of the snapshot.
	Iops *int32

	// If Encrypted is true, the Amazon Web Services KMS key identifier for the
	// encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key
	// ARN, key ID, alias ARN, or alias name for the KMS key.
	KmsKeyId *string

	// License model information for the restored DB instance.
	LicenseModel *string

	// Provides the master username for the DB snapshot.
	MasterUsername *string

	// Provides the option group name for the DB snapshot.
	OptionGroupName *string

	// Specifies the time of the CreateDBSnapshot operation in Coordinated Universal
	// Time (UTC). Doesn't change when the snapshot is copied.
	OriginalSnapshotCreateTime *time.Time

	// The percentage of the estimated data that has been transferred.
	PercentProgress int32

	// Specifies the port that the database engine was listening on at the time of the
	// snapshot.
	Port int32

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance when the DB snapshot was created.
	ProcessorFeatures []ProcessorFeature

	// Specifies when the snapshot was taken in Coordinated Universal Time (UTC).
	// Changes for the copy when the snapshot is copied.
	SnapshotCreateTime *time.Time

	// Specifies where manual snapshots are stored: Amazon Web Services Outposts or the
	// Amazon Web Services Region.
	SnapshotTarget *string

	// Provides the type of the DB snapshot.
	SnapshotType *string

	// The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from.
	// It only has a value in the case of a cross-account or cross-Region copy.
	SourceDBSnapshotIdentifier *string

	// The Amazon Web Services Region that the DB snapshot was created in or copied
	// from.
	SourceRegion *string

	// Specifies the status of this DB snapshot.
	Status *string

	// Specifies the storage type associated with DB snapshot.
	StorageType *string

	// A list of tags. For more information, see Tagging Amazon RDS Resources
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in
	// the Amazon RDS User Guide.
	TagList []Tag

	// The ARN from the key store with which to associate the instance for TDE
	// encryption.
	TdeCredentialArn *string

	// The time zone of the DB snapshot. In most cases, the Timezone element is empty.
	// Timezone content appears only for snapshots taken from Microsoft SQL Server DB
	// instances that were created with a time zone specified.
	Timezone *string

	// Provides the VPC ID associated with the DB snapshot.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains the name and values of a manual DB snapshot attribute Manual DB
// snapshot attributes are used to authorize other Amazon Web Services accounts to
// restore a manual DB snapshot. For more information, see the
// ModifyDBSnapshotAttribute API.
type DBSnapshotAttribute struct {

	// The name of the manual DB snapshot attribute. The attribute named restore refers
	// to the list of Amazon Web Services accounts that have permission to copy or
	// restore the manual DB cluster snapshot. For more information, see the
	// ModifyDBSnapshotAttribute API action.
	AttributeName *string

	// The value or values for the manual DB snapshot attribute. If the AttributeName
	// field is set to restore, then this element returns a list of IDs of the Amazon
	// Web Services accounts that are authorized to copy or restore the manual DB
	// snapshot. If a value of all is in the list, then the manual DB snapshot is
	// public and available for any Amazon Web Services account to copy or restore.
	AttributeValues []string

	noSmithyDocumentSerde
}

// Contains the results of a successful call to the DescribeDBSnapshotAttributes
// API action. Manual DB snapshot attributes are used to authorize other Amazon Web
// Services accounts to copy or restore a manual DB snapshot. For more information,
// see the ModifyDBSnapshotAttribute API action.
type DBSnapshotAttributesResult struct {

	// The list of attributes and values for the manual DB snapshot.
	DBSnapshotAttributes []DBSnapshotAttribute

	// The identifier of the manual DB snapshot that the attributes apply to.
	DBSnapshotIdentifier *string

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB subnet group. This data type is used as
// a response element in the DescribeDBSubnetGroups action.
type DBSubnetGroup struct {

	// The Amazon Resource Name (ARN) for the DB subnet group.
	DBSubnetGroupArn *string

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string

	// The name of the DB subnet group.
	DBSubnetGroupName *string

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string

	// Contains a list of Subnet elements.
	Subnets []Subnet

	// The network type of the DB subnet group. Valid values:
	//
	// * IPV4
	//
	// * DUAL
	//
	// A
	// DBSubnetGroup can support only the IPv4 protocol or the IPv4 and the IPv6
	// protocols (DUAL). For more information, see  Working with a DB instance in a VPC
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
	// in the Amazon RDS User Guide.
	SupportedNetworkTypes []string

	// Provides the VpcId of the DB subnet group.
	VpcId *string

	noSmithyDocumentSerde
}

// This data type is used as a response element to DescribeDBLogFiles.
type DescribeDBLogFilesDetails struct {

	// A POSIX timestamp when the last log entry was written.
	LastWritten int64

	// The name of the log file for the specified DB instance.
	LogFileName *string

	// The size, in bytes, of the log file for the specified DB instance.
	Size int64

	noSmithyDocumentSerde
}

// An Active Directory Domain membership record associated with the DB instance or
// cluster.
type DomainMembership struct {

	// The identifier of the Active Directory Domain.
	Domain *string

	// The fully qualified domain name of the Active Directory Domain.
	FQDN *string

	// The name of the IAM role to be used when making API calls to the Directory
	// Service.
	IAMRoleName *string

	// The status of the Active Directory Domain membership for the DB instance or
	// cluster. Values include joined, pending-join, failed, and so on.
	Status *string

	noSmithyDocumentSerde
}

// A range of double values.
type DoubleRange struct {

	// The minimum value in the range.
	From float64

	// The maximum value in the range.
	To float64

	noSmithyDocumentSerde
}

// This data type is used as a response element in the following actions:
//
// *
// AuthorizeDBSecurityGroupIngress
//
// * DescribeDBSecurityGroups
//
// *
// RevokeDBSecurityGroupIngress
type EC2SecurityGroup struct {

	// Specifies the id of the EC2 security group.
	EC2SecurityGroupId *string

	// Specifies the name of the EC2 security group.
	EC2SecurityGroupName *string

	// Specifies the Amazon Web Services ID of the owner of the EC2 security group
	// specified in the EC2SecurityGroupName field.
	EC2SecurityGroupOwnerId *string

	// Provides the status of the EC2 security group. Status can be "authorizing",
	// "authorized", "revoking", and "revoked".
	Status *string

	noSmithyDocumentSerde
}

// This data type represents the information you need to connect to an Amazon RDS
// DB instance. This data type is used as a response element in the following
// actions:
//
// * CreateDBInstance
//
// * DescribeDBInstances
//
// * DeleteDBInstance
//
// For the
// data structure that represents Amazon Aurora DB cluster endpoints, see
// DBClusterEndpoint.
type Endpoint struct {

	// Specifies the DNS address of the DB instance.
	Address *string

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string

	// Specifies the port that the database engine is listening on.
	Port int32

	noSmithyDocumentSerde
}

// Contains the result of a successful invocation of the
// DescribeEngineDefaultParameters action.
type EngineDefaults struct {

	// Specifies the name of the DB parameter group family that the engine default
	// parameters apply to.
	DBParameterGroupFamily *string

	// An optional pagination token provided by a previous EngineDefaults request. If
	// this parameter is specified, the response includes only records beyond the
	// marker, up to the value specified by MaxRecords .
	Marker *string

	// Contains a list of engine default parameters.
	Parameters []Parameter

	noSmithyDocumentSerde
}

// This data type is used as a response element in the DescribeEvents
// (https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEvents.html)
// action.
type Event struct {

	// Specifies the date and time of the event.
	Date *time.Time

	// Specifies the category for the event.
	EventCategories []string

	// Provides the text of this event.
	Message *string

	// The Amazon Resource Name (ARN) for the event.
	SourceArn *string

	// Provides the identifier for the source of the event.
	SourceIdentifier *string

	// Specifies the source type for this event.
	SourceType SourceType

	noSmithyDocumentSerde
}

// Contains the results of a successful invocation of the DescribeEventCategories
// (https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEventCategories.html)
// operation.
type EventCategoriesMap struct {

	// The event categories for the specified source type
	EventCategories []string

	// The source type that the returned categories belong to
	SourceType *string

	noSmithyDocumentSerde
}

// Contains the results of a successful invocation of the
// DescribeEventSubscriptions action.
type EventSubscription struct {

	// The RDS event notification subscription Id.
	CustSubscriptionId *string

	// The Amazon Web Services customer account associated with the RDS event
	// notification subscription.
	CustomerAwsId *string

	// A Boolean value indicating if the subscription is enabled. True indicates the
	// subscription is enabled.
	Enabled bool

	// A list of event categories for the RDS event notification subscription.
	EventCategoriesList []string

	// The Amazon Resource Name (ARN) for the event subscription.
	EventSubscriptionArn *string

	// The topic ARN of the RDS event notification subscription.
	SnsTopicArn *string

	// A list of source IDs for the RDS event notification subscription.
	SourceIdsList []string

	// The source type for the RDS event notification subscription.
	SourceType *string

	// The status of the RDS event notification subscription. Constraints: Can be one
	// of the following: creating | modifying | deleting | active | no-permission |
	// topic-not-exist The status "no-permission" indicates that RDS no longer has
	// permission to post to the SNS topic. The status "topic-not-exist" indicates that
	// the topic was deleted after the subscription was created.
	Status *string

	// The time the RDS event notification subscription was created.
	SubscriptionCreationTime *string

	noSmithyDocumentSerde
}

// Contains the details of a snapshot export to Amazon S3. This data type is used
// as a response element in the DescribeExportTasks action.
type ExportTask struct {

	// The data exported from the snapshot. Valid values are the following:
	//
	// * database
	// - Export all the data from a specified database.
	//
	// * database.table table-name -
	// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS
	// for MariaDB, and Aurora MySQL.
	//
	// * database.schema schema-name - Export a
	// database schema of the snapshot. This format is valid only for RDS for
	// PostgreSQL and Aurora PostgreSQL.
	//
	// * database.schema.table table-name - Export a
	// table of the database schema. This format is valid only for RDS for PostgreSQL
	// and Aurora PostgreSQL.
	ExportOnly []string

	// A unique identifier for the snapshot export task. This ID isn't an identifier
	// for the Amazon S3 bucket where the snapshot is exported to.
	ExportTaskIdentifier *string

	// The reason the export failed, if it failed.
	FailureCause *string

	// The name of the IAM role that is used to write to Amazon S3 when exporting a
	// snapshot.
	IamRoleArn *string

	// The key identifier of the Amazon Web Services KMS key that is used to encrypt
	// the snapshot when it's exported to Amazon S3. The KMS key identifier is its key
	// ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
	// must have encryption and decryption permissions to use this KMS key.
	KmsKeyId *string

	// The progress of the snapshot export task as a percentage.
	PercentProgress int32

	// The Amazon S3 bucket that the snapshot is exported to.
	S3Bucket *string

	// The Amazon S3 bucket prefix that is the file name and path of the exported
	// snapshot.
	S3Prefix *string

	// The time that the snapshot was created.
	SnapshotTime *time.Time

	// The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
	SourceArn *string

	// The progress status of the export task.
	Status *string

	// The time that the snapshot export task completed.
	TaskEndTime *time.Time

	// The time that the snapshot export task started.
	TaskStartTime *time.Time

	// The total amount of data exported, in gigabytes.
	TotalExtractedDataInGB int32

	// A warning about the snapshot export task.
	WarningMessage *string

	noSmithyDocumentSerde
}

// Contains the state of scheduled or in-process failover operations on an Aurora
// global database (GlobalCluster). This Data type is empty unless a failover
// operation is scheduled or is currently underway on the Aurora global database.
type FailoverState struct {

	// The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being
	// demoted, and which is associated with this state.
	FromDbClusterArn *string

	// The current status of the Aurora global database (GlobalCluster). Possible
	// values are as follows:
	//
	// * pending  A request to fail over the Aurora global
	// database (GlobalCluster) has been received by the service. The GlobalCluster's
	// primary DB cluster and the specified secondary DB cluster are being verified
	// before the failover process can start.
	//
	// * failing-over  This status covers the
	// range of Aurora internal operations that take place during the failover process,
	// such as demoting the primary Aurora DB cluster, promoting the secondary Aurora
	// DB, and synchronizing replicas.
	//
	// * cancelling  The request to fail over the
	// Aurora global database (GlobalCluster) was cancelled and the primary Aurora DB
	// cluster and the selected secondary Aurora DB cluster are returning to their
	// previous states.
	Status FailoverStatus

	// The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being
	// promoted, and which is associated with this state.
	ToDbClusterArn *string

	noSmithyDocumentSerde
}

// A filter name and value pair that is used to return a more specific list of
// results from a describe operation. Filters can be used to match a set of
// resources by specific criteria, such as IDs. The filters supported by a describe
// operation are documented with the describe operation. Currently, wildcards are
// not supported in filters. The following actions can be filtered:
//
// *
// DescribeDBClusterBacktracks
//
// * DescribeDBClusterEndpoints
//
// *
// DescribeDBClusters
//
// * DescribeDBInstances
//
// * DescribePendingMaintenanceActions
type Filter struct {

	// The name of the filter. Filter names are case-sensitive.
	//
	// This member is required.
	Name *string

	// One or more filter values. Filter values are case-sensitive.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// A data type representing an Aurora global database.
type GlobalCluster struct {

	// The default database name within the new global database cluster.
	DatabaseName *string

	// The deletion protection setting for the new global database cluster.
	DeletionProtection *bool

	// The Aurora database engine used by the global database cluster.
	Engine *string

	// Indicates the database engine version.
	EngineVersion *string

	// A data object containing all properties for the current state of an in-process
	// or pending failover process for this Aurora global database. This object is
	// empty unless the FailoverGlobalCluster API operation has been called on this
	// Aurora global database (GlobalCluster).
	FailoverState *FailoverState

	// The Amazon Resource Name (ARN) for the global database cluster.
	GlobalClusterArn *string

	// Contains a user-supplied global database cluster identifier. This identifier is
	// the unique key that identifies a global database cluster.
	GlobalClusterIdentifier *string

	// The list of cluster IDs for secondary clusters within the global database
	// cluster. Currently limited to 1 item.
	GlobalClusterMembers []GlobalClusterMember

	// The Amazon Web Services Region-unique, immutable identifier for the global
	// database cluster. This identifier is found in Amazon Web Services CloudTrail log
	// entries whenever the Amazon Web Services KMS key for the DB cluster is accessed.
	GlobalClusterResourceId *string

	// Specifies the current state of this global database cluster.
	Status *string

	// The storage encryption setting for the global database cluster.
	StorageEncrypted *bool

	noSmithyDocumentSerde
}

// A data structure with information about any primary and secondary clusters
// associated with an Aurora global database.
type GlobalClusterMember struct {

	// The Amazon Resource Name (ARN) for each Aurora cluster.
	DBClusterArn *string

	// Specifies whether a secondary cluster in an Aurora global database has write
	// forwarding enabled, not enabled, or is in the process of enabling it.
	GlobalWriteForwardingStatus WriteForwardingStatus

	// Specifies whether the Aurora cluster is the primary cluster (that is, has
	// read-write capability) for the Aurora global database with which it is
	// associated.
	IsWriter bool

	// The Amazon Resource Name (ARN) for each read-only secondary cluster associated
	// with the Aurora global database.
	Readers []string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the DescribeDBSecurityGroups
// action.
type IPRange struct {

	// Specifies the IP range.
	CIDRIP *string

	// Specifies the status of the IP range. Status can be "authorizing", "authorized",
	// "revoking", and "revoked".
	Status *string

	noSmithyDocumentSerde
}

// The minimum DB engine version required for each corresponding allowed value for
// an option setting.
type MinimumEngineVersionPerAllowedValue struct {

	// The allowed value for an option setting.
	AllowedValue *string

	// The minimum DB engine version required for the allowed value.
	MinimumEngineVersion *string

	noSmithyDocumentSerde
}

// Option details.
type Option struct {

	// If the option requires access to a port, then this DB security group allows
	// access to the port.
	DBSecurityGroupMemberships []DBSecurityGroupMembership

	// The description of the option.
	OptionDescription *string

	// The name of the option.
	OptionName *string

	// The option settings for this option.
	OptionSettings []OptionSetting

	// The version of the option.
	OptionVersion *string

	// Indicate if this option is permanent.
	Permanent bool

	// Indicate if this option is persistent.
	Persistent bool

	// If required, the port configured for this option to use.
	Port *int32

	// If the option requires access to a port, then this VPC security group allows
	// access to the port.
	VpcSecurityGroupMemberships []VpcSecurityGroupMembership

	noSmithyDocumentSerde
}

// A list of all available options
type OptionConfiguration struct {

	// The configuration of options to include in a group.
	//
	// This member is required.
	OptionName *string

	// A list of DBSecurityGroupMembership name strings used for this option.
	DBSecurityGroupMemberships []string

	// The option settings to include in an option group.
	OptionSettings []OptionSetting

	// The version for the option.
	OptionVersion *string

	// The optional port for the option.
	Port *int32

	// A list of VpcSecurityGroupMembership name strings used for this option.
	VpcSecurityGroupMemberships []string

	noSmithyDocumentSerde
}

//
type OptionGroup struct {

	// Indicates whether this option group can be applied to both VPC and non-VPC
	// instances. The value true indicates the option group can be applied to both VPC
	// and non-VPC instances.
	AllowsVpcAndNonVpcInstanceMemberships bool

	// Indicates the name of the engine that this option group can be applied to.
	EngineName *string

	// Indicates the major engine version associated with this option group.
	MajorEngineVersion *string

	// The Amazon Resource Name (ARN) for the option group.
	OptionGroupArn *string

	// Provides a description of the option group.
	OptionGroupDescription *string

	// Specifies the name of the option group.
	OptionGroupName *string

	// Indicates what options are available in the option group.
	Options []Option

	// If AllowsVpcAndNonVpcInstanceMemberships is false, this field is blank. If
	// AllowsVpcAndNonVpcInstanceMemberships is true and this field is blank, then this
	// option group can be applied to both VPC and non-VPC instances. If this field
	// contains a value, then this option group can only be applied to instances that
	// are in the VPC indicated by this field.
	VpcId *string

	noSmithyDocumentSerde
}

// Provides information on the option groups the DB instance is a member of.
type OptionGroupMembership struct {

	// The name of the option group that the instance belongs to.
	OptionGroupName *string

	// The status of the DB instance's option group membership. Valid values are:
	// in-sync, pending-apply, pending-removal, pending-maintenance-apply,
	// pending-maintenance-removal, applying, removing, and failed.
	Status *string

	noSmithyDocumentSerde
}

// Available option.
type OptionGroupOption struct {

	// If the option requires a port, specifies the default port for the option.
	DefaultPort *int32

	// The description of the option.
	Description *string

	// The name of the engine that this option can be applied to.
	EngineName *string

	// Indicates the major engine version that the option is available for.
	MajorEngineVersion *string

	// The minimum required engine version for the option to be applied.
	MinimumRequiredMinorEngineVersion *string

	// The name of the option.
	Name *string

	// The option settings that are available (and the default value) for each option
	// in an option group.
	OptionGroupOptionSettings []OptionGroupOptionSetting

	// The versions that are available for the option.
	OptionGroupOptionVersions []OptionVersion

	// The options that conflict with this option.
	OptionsConflictsWith []string

	// The options that are prerequisites for this option.
	OptionsDependedOn []string

	// Permanent options can never be removed from an option group. An option group
	// containing a permanent option can't be removed from a DB instance.
	Permanent bool

	// Persistent options can't be removed from an option group while DB instances are
	// associated with the option group. If you disassociate all DB instances from the
	// option group, your can remove the persistent option from the option group.
	Persistent bool

	// Specifies whether the option requires a port.
	PortRequired bool

	// If true, you must enable the Auto Minor Version Upgrade setting for your DB
	// instance before you can use this option. You can enable Auto Minor Version
	// Upgrade when you first create your DB instance, or by modifying your DB instance
	// later.
	RequiresAutoMinorEngineVersionUpgrade bool

	// If true, you can change the option to an earlier version of the option. This
	// only applies to options that have different versions available.
	SupportsOptionVersionDowngrade *bool

	// If true, you can only use this option with a DB instance that is in a VPC.
	VpcOnly bool

	noSmithyDocumentSerde
}

// Option group option settings are used to display settings available for each
// option with their default values and other information. These values are used
// with the DescribeOptionGroupOptions action.
type OptionGroupOptionSetting struct {

	// Indicates the acceptable values for the option group option.
	AllowedValues *string

	// The DB engine specific parameter type for the option group option.
	ApplyType *string

	// The default value for the option group option.
	DefaultValue *string

	// Boolean value where true indicates that this option group option can be changed
	// from the default value.
	IsModifiable bool

	// Boolean value where true indicates that a value must be specified for this
	// option setting of the option group option.
	IsRequired bool

	// The minimum DB engine version required for the corresponding allowed value for
	// this option setting.
	MinimumEngineVersionPerAllowedValue []MinimumEngineVersionPerAllowedValue

	// The description of the option group option.
	SettingDescription *string

	// The name of the option group option.
	SettingName *string

	noSmithyDocumentSerde
}

// Option settings are the actual settings being applied or configured for that
// option. It is used when you modify an option group or describe option groups.
// For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called
// SQLNET.ENCRYPTION_SERVER that can have several different values.
type OptionSetting struct {

	// The allowed values of the option setting.
	AllowedValues *string

	// The DB engine specific parameter type.
	ApplyType *string

	// The data type of the option setting.
	DataType *string

	// The default value of the option setting.
	DefaultValue *string

	// The description of the option setting.
	Description *string

	// Indicates if the option setting is part of a collection.
	IsCollection bool

	// A Boolean value that, when true, indicates the option setting can be modified
	// from the default.
	IsModifiable bool

	// The name of the option that has settings that you can set.
	Name *string

	// The current value of the option setting.
	Value *string

	noSmithyDocumentSerde
}

// The version for an option. Option group option versions are returned by the
// DescribeOptionGroupOptions action.
type OptionVersion struct {

	// True if the version is the default version of the option, and otherwise false.
	IsDefault bool

	// The version of the option.
	Version *string

	noSmithyDocumentSerde
}

// Contains a list of available options for a DB instance. This data type is used
// as a response element in the DescribeOrderableDBInstanceOptions action.
type OrderableDBInstanceOption struct {

	// The Availability Zone group for a DB instance.
	AvailabilityZoneGroup *string

	// A list of Availability Zones for a DB instance.
	AvailabilityZones []AvailabilityZone

	// A list of the available processor features for the DB instance class of a DB
	// instance.
	AvailableProcessorFeatures []AvailableProcessorFeature

	// The DB instance class for a DB instance.
	DBInstanceClass *string

	// The engine type of a DB instance.
	Engine *string

	// The engine version of a DB instance.
	EngineVersion *string

	// The license model for a DB instance.
	LicenseModel *string

	// Maximum total provisioned IOPS for a DB instance.
	MaxIopsPerDbInstance *int32

	// Maximum provisioned IOPS per GiB for a DB instance.
	MaxIopsPerGib *float64

	// Maximum storage size for a DB instance.
	MaxStorageSize *int32

	// Minimum total provisioned IOPS for a DB instance.
	MinIopsPerDbInstance *int32

	// Minimum provisioned IOPS per GiB for a DB instance.
	MinIopsPerGib *float64

	// Minimum storage size for a DB instance.
	MinStorageSize *int32

	// Indicates whether a DB instance is Multi-AZ capable.
	MultiAZCapable bool

	// Whether a DB instance supports RDS on Outposts. For more information about RDS
	// on Outposts, see Amazon RDS on Amazon Web Services Outposts
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in
	// the Amazon RDS User Guide.
	OutpostCapable bool

	// Indicates whether a DB instance can have a read replica.
	ReadReplicaCapable bool

	// Indicates the storage type for a DB instance.
	StorageType *string

	// The list of supported modes for Database Activity Streams. Aurora PostgreSQL
	// returns the value [sync, async]. Aurora MySQL and RDS for Oracle return [async]
	// only. If Database Activity Streams isn't supported, the return value is an empty
	// list.
	SupportedActivityStreamModes []string

	// A list of the supported DB engine modes.
	SupportedEngineModes []string

	// The network types supported by the DB instance (IPV4 or DUAL). A DB instance can
	// support only the IPv4 protocol or the IPv4 and the IPv6 protocols (DUAL). For
	// more information, see  Working with a DB instance in a VPC
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html)
	// in the Amazon RDS User Guide.
	SupportedNetworkTypes []string

	// Whether DB instances can be configured as a Multi-AZ DB cluster. For more
	// information on Multi-AZ DB clusters, see  Multi-AZ deployments with two readable
	// standby DB instances
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html)
	// in the Amazon RDS User Guide.
	SupportsClusters bool

	// Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1
	// to 60 seconds.
	SupportsEnhancedMonitoring bool

	// A value that indicates whether you can use Aurora global databases with a
	// specific combination of other DB engine attributes.
	SupportsGlobalDatabases bool

	// Indicates whether a DB instance supports IAM database authentication.
	SupportsIAMDatabaseAuthentication bool

	// Indicates whether a DB instance supports provisioned IOPS.
	SupportsIops bool

	// Whether a DB instance supports Kerberos Authentication.
	SupportsKerberosAuthentication *bool

	// True if a DB instance supports Performance Insights, otherwise false.
	SupportsPerformanceInsights bool

	// Whether Amazon RDS can automatically scale storage for DB instances that use the
	// specified DB instance class.
	SupportsStorageAutoscaling *bool

	// Indicates whether a DB instance supports encrypted storage.
	SupportsStorageEncryption bool

	// Indicates whether a DB instance is in a VPC.
	Vpc bool

	noSmithyDocumentSerde
}

// A data type that represents an Outpost. For more information about RDS on
// Outposts, see Amazon RDS on Amazon Web Services Outposts
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in
// the Amazon RDS User Guide.
type Outpost struct {

	// The Amazon Resource Name (ARN) of the Outpost.
	Arn *string

	noSmithyDocumentSerde
}

// This data type is used as a request parameter in the ModifyDBParameterGroup and
// ResetDBParameterGroup actions. This data type is used as a response element in
// the DescribeEngineDefaultParameters and DescribeDBParameters actions.
type Parameter struct {

	// Specifies the valid range of values for the parameter.
	AllowedValues *string

	// Indicates when to apply parameter updates.
	ApplyMethod ApplyMethod

	// Specifies the engine specific parameters type.
	ApplyType *string

	// Specifies the valid data type for the parameter.
	DataType *string

	// Provides a description of the parameter.
	Description *string

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable bool

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string

	// Specifies the name of the parameter.
	ParameterName *string

	// Specifies the value of the parameter.
	ParameterValue *string

	// Indicates the source of the parameter value.
	Source *string

	// The valid DB engine modes.
	SupportedEngineModes []string

	noSmithyDocumentSerde
}

// A list of the log types whose configuration is still pending. In other words,
// these log types are in the process of being activated or deactivated.
type PendingCloudwatchLogsExports struct {

	// Log types that are in the process of being enabled. After they are enabled,
	// these log types are exported to CloudWatch Logs.
	LogTypesToDisable []string

	// Log types that are in the process of being deactivated. After they are
	// deactivated, these log types aren't exported to CloudWatch Logs.
	LogTypesToEnable []string

	noSmithyDocumentSerde
}

// Provides information about a pending maintenance action for a resource.
type PendingMaintenanceAction struct {

	// The type of pending maintenance action that is available for the resource. Valid
	// actions are system-update, db-upgrade, hardware-maintenance, and
	// ca-certificate-rotation.
	Action *string

	// The date of the maintenance window when the action is applied. The maintenance
	// action is applied to the resource during its first maintenance window after this
	// date.
	AutoAppliedAfterDate *time.Time

	// The effective date when the pending maintenance action is applied to the
	// resource. This date takes into account opt-in requests received from the
	// ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate, and the
	// ForcedApplyDate. This value is blank if an opt-in request has not been received
	// and nothing has been specified as AutoAppliedAfterDate or ForcedApplyDate.
	CurrentApplyDate *time.Time

	// A description providing more detail about the maintenance action.
	Description *string

	// The date when the maintenance action is automatically applied. On this date, the
	// maintenance action is applied to the resource as soon as possible, regardless of
	// the maintenance window for the resource. There might be a delay of one or more
	// days from this date before the maintenance action is applied.
	ForcedApplyDate *time.Time

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the ModifyDBInstance operation
// and contains changes that will be applied during the next maintenance window.
type PendingModifiedValues struct {

	// The allocated storage size for the DB instance specified in gibibytes (GiB).
	AllocatedStorage *int32

	// The automation mode of the RDS Custom DB instance: full or all-paused. If full,
	// the DB instance automates monitoring and instance recovery. If all-paused, the
	// instance pauses automation for the duration set by
	// --resume-full-automation-mode-minutes.
	AutomationMode AutomationMode

	// The number of days for which automated backups are retained.
	BackupRetentionPeriod *int32

	// The identifier of the CA certificate for the DB instance.
	CACertificateIdentifier *string

	// The name of the compute and memory capacity class for the DB instance.
	DBInstanceClass *string

	// The database identifier for the DB instance.
	DBInstanceIdentifier *string

	// The DB subnet group for the DB instance.
	DBSubnetGroupName *string

	// The database engine version.
	EngineVersion *string

	// Whether mapping of Amazon Web Services Identity and Access Management (IAM)
	// accounts to database accounts is enabled.
	IAMDatabaseAuthenticationEnabled *bool

	// The Provisioned IOPS value for the DB instance.
	Iops *int32

	// The license model for the DB instance. Valid values: license-included |
	// bring-your-own-license | general-public-license
	LicenseModel *string

	// The master credentials for the DB instance.
	MasterUserPassword *string

	// A value that indicates that the Single-AZ DB instance will change to a Multi-AZ
	// deployment.
	MultiAZ *bool

	// A list of the log types whose configuration is still pending. In other words,
	// these log types are in the process of being activated or deactivated.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports

	// The port for the DB instance.
	Port *int32

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []ProcessorFeature

	// The number of minutes to pause the automation. When the time period ends, RDS
	// Custom resumes full automation. The minimum value is 60 (default). The maximum
	// value is 1,440.
	ResumeFullAutomationModeTime *time.Time

	// The storage type of the DB instance.
	StorageType *string

	noSmithyDocumentSerde
}

// Contains the processor features of a DB instance class. To specify the number of
// CPU cores, use the coreCount feature name for the Name parameter. To specify the
// number of threads per core, use the threadsPerCore feature name for the Name
// parameter. You can set the processor features of the DB instance class for a DB
// instance when you call one of the following actions:
//
// * CreateDBInstance
//
// *
// ModifyDBInstance
//
// * RestoreDBInstanceFromDBSnapshot
//
// *
// RestoreDBInstanceFromS3
//
// * RestoreDBInstanceToPointInTime
//
// You can view the
// valid processor values for a particular instance class by calling the
// DescribeOrderableDBInstanceOptions action and specifying the instance class for
// the DBInstanceClass parameter. In addition, you can use the following actions
// for DB instance class processor information:
//
// * DescribeDBInstances
//
// *
// DescribeDBSnapshots
//
// * DescribeValidDBInstanceModifications
//
// If you call
// DescribeDBInstances, ProcessorFeature returns non-null values only if the
// following conditions are met:
//
// * You are accessing an Oracle DB instance.
//
// *
// Your Oracle DB instance class supports configuring the number of CPU cores and
// threads per core.
//
// * The current number CPU cores and threads is set to a
// non-default value.
//
// For more information, see Configuring the Processor of the
// DB Instance Class
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor)
// in the Amazon RDS User Guide.
type ProcessorFeature struct {

	// The name of the processor feature. Valid names are coreCount and threadsPerCore.
	Name *string

	// The value of a processor feature name.
	Value *string

	noSmithyDocumentSerde
}

// A range of integer values.
type Range struct {

	// The minimum value in the range.
	From int32

	// The step value for the range. For example, if you have a range of 5,000 to
	// 10,000, with a step value of 1,000, the valid values start at 5,000 and step up
	// by 1,000. Even though 7,500 is within the range, it isn't a valid value for the
	// range. The valid values are 5,000, 6,000, 7,000, 8,000...
	Step *int32

	// The maximum value in the range.
	To int32

	noSmithyDocumentSerde
}

// This data type is used as a response element in the DescribeReservedDBInstances
// and DescribeReservedDBInstancesOfferings actions.
type RecurringCharge struct {

	// The amount of the recurring charge.
	RecurringChargeAmount float64

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the DescribeReservedDBInstances
// and PurchaseReservedDBInstancesOffering actions.
type ReservedDBInstance struct {

	// The currency code for the reserved DB instance.
	CurrencyCode *string

	// The DB instance class for the reserved DB instance.
	DBInstanceClass *string

	// The number of reserved DB instances.
	DBInstanceCount int32

	// The duration of the reservation in seconds.
	Duration int32

	// The fixed price charged for this reserved DB instance.
	FixedPrice float64

	// The unique identifier for the lease associated with the reserved DB instance.
	// Amazon Web Services Support might request the lease ID for an issue related to a
	// reserved DB instance.
	LeaseId *string

	// Indicates if the reservation applies to Multi-AZ deployments.
	MultiAZ bool

	// The offering type of this reserved DB instance.
	OfferingType *string

	// The description of the reserved DB instance.
	ProductDescription *string

	// The recurring price charged to run this reserved DB instance.
	RecurringCharges []RecurringCharge

	// The Amazon Resource Name (ARN) for the reserved DB instance.
	ReservedDBInstanceArn *string

	// The unique identifier for the reservation.
	ReservedDBInstanceId *string

	// The offering identifier.
	ReservedDBInstancesOfferingId *string

	// The time the reservation started.
	StartTime *time.Time

	// The state of the reserved DB instance.
	State *string

	// The hourly price charged for this reserved DB instance.
	UsagePrice float64

	noSmithyDocumentSerde
}

// This data type is used as a response element in the
// DescribeReservedDBInstancesOfferings action.
type ReservedDBInstancesOffering struct {

	// The currency code for the reserved DB instance offering.
	CurrencyCode *string

	// The DB instance class for the reserved DB instance.
	DBInstanceClass *string

	// The duration of the offering in seconds.
	Duration int32

	// The fixed price charged for this offering.
	FixedPrice float64

	// Indicates if the offering applies to Multi-AZ deployments.
	MultiAZ bool

	// The offering type.
	OfferingType *string

	// The database engine used by the offering.
	ProductDescription *string

	// The recurring price charged to run this reserved DB instance.
	RecurringCharges []RecurringCharge

	// The offering identifier.
	ReservedDBInstancesOfferingId *string

	// The hourly price charged for this offering.
	UsagePrice float64

	noSmithyDocumentSerde
}

// Describes the pending maintenance actions for a resource.
type ResourcePendingMaintenanceActions struct {

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []PendingMaintenanceAction

	// The ARN of the resource that has pending maintenance actions.
	ResourceIdentifier *string

	noSmithyDocumentSerde
}

// Earliest and latest time an instance can be restored to:
type RestoreWindow struct {

	// The earliest time you can restore an instance to.
	EarliestTime *time.Time

	// The latest time you can restore an instance to.
	LatestTime *time.Time

	noSmithyDocumentSerde
}

// Contains the scaling configuration of an Aurora Serverless v1 DB cluster. For
// more information, see Using Amazon Aurora Serverless v1
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
// in the Amazon Aurora User Guide.
type ScalingConfiguration struct {

	// A value that indicates whether to allow or disallow automatic pause for an
	// Aurora DB cluster in serverless DB engine mode. A DB cluster can be paused only
	// when it's idle (it has no connections). If a DB cluster is paused for more than
	// seven days, the DB cluster might be backed up with a snapshot. In this case, the
	// DB cluster is restored when there is a request to connect to it.
	AutoPause *bool

	// The maximum capacity for an Aurora DB cluster in serverless DB engine mode. For
	// Aurora MySQL, valid capacity values are 1, 2, 4, 8, 16, 32, 64, 128, and 256.
	// For Aurora PostgreSQL, valid capacity values are 2, 4, 8, 16, 32, 64, 192, and
	// 384. The maximum capacity must be greater than or equal to the minimum capacity.
	MaxCapacity *int32

	// The minimum capacity for an Aurora DB cluster in serverless DB engine mode. For
	// Aurora MySQL, valid capacity values are 1, 2, 4, 8, 16, 32, 64, 128, and 256.
	// For Aurora PostgreSQL, valid capacity values are 2, 4, 8, 16, 32, 64, 192, and
	// 384. The minimum capacity must be less than or equal to the maximum capacity.
	MinCapacity *int32

	// The amount of time, in seconds, that Aurora Serverless v1 tries to find a
	// scaling point to perform seamless scaling before enforcing the timeout action.
	// The default is 300. Specify a value between 60 and 600 seconds.
	SecondsBeforeTimeout *int32

	// The time, in seconds, before an Aurora DB cluster in serverless mode is paused.
	// Specify a value between 300 and 86,400 seconds.
	SecondsUntilAutoPause *int32

	// The action to take when the timeout is reached, either ForceApplyCapacityChange
	// or RollbackCapacityChange. ForceApplyCapacityChange sets the capacity to the
	// specified value as soon as possible. RollbackCapacityChange, the default,
	// ignores the capacity change if a scaling point isn't found in the timeout
	// period. If you specify ForceApplyCapacityChange, connections that prevent Aurora
	// Serverless v1 from finding a scaling point might be dropped. For more
	// information, see  Autoscaling for Aurora Serverless v1
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling)
	// in the Amazon Aurora User Guide.
	TimeoutAction *string

	noSmithyDocumentSerde
}

// Shows the scaling configuration for an Aurora DB cluster in serverless DB engine
// mode. For more information, see Using Amazon Aurora Serverless v1
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
// in the Amazon Aurora User Guide.
type ScalingConfigurationInfo struct {

	// A value that indicates whether automatic pause is allowed for the Aurora DB
	// cluster in serverless DB engine mode. When the value is set to false for an
	// Aurora Serverless v1 DB cluster, the DB cluster automatically resumes.
	AutoPause *bool

	// The maximum capacity for an Aurora DB cluster in serverless DB engine mode.
	MaxCapacity *int32

	// The minimum capacity for an Aurora DB cluster in serverless DB engine mode.
	MinCapacity *int32

	// The number of seconds before scaling times out. What happens when an attempted
	// scaling action times out is determined by the TimeoutAction setting.
	SecondsBeforeTimeout *int32

	// The remaining amount of time, in seconds, before the Aurora DB cluster in
	// serverless mode is paused. A DB cluster can be paused only when it's idle (it
	// has no connections).
	SecondsUntilAutoPause *int32

	// The action that occurs when Aurora times out while attempting to change the
	// capacity of an Aurora Serverless v1 cluster. The value is either
	// ForceApplyCapacityChange or RollbackCapacityChange. ForceApplyCapacityChange,
	// the default, sets the capacity to the specified value as soon as possible.
	// RollbackCapacityChange ignores the capacity change if a scaling point isn't
	// found in the timeout period.
	TimeoutAction *string

	noSmithyDocumentSerde
}

// Contains the scaling configuration of an Aurora Serverless v2 DB cluster. For
// more information, see Using Amazon Aurora Serverless v2
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html)
// in the Amazon Aurora User Guide.
type ServerlessV2ScalingConfiguration struct {

	// The maximum number of Aurora capacity units (ACUs) for a DB instance in an
	// Aurora Serverless v2 cluster. You can specify ACU values in half-step
	// increments, such as 40, 40.5, 41, and so on. The largest value that you can use
	// is 128.
	MaxCapacity *float64

	// The minimum number of Aurora capacity units (ACUs) for a DB instance in an
	// Aurora Serverless v2 cluster. You can specify ACU values in half-step
	// increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is
	// 0.5.
	MinCapacity *float64

	noSmithyDocumentSerde
}

// Shows the scaling configuration for an Aurora Serverless v2 DB cluster. For more
// information, see Using Amazon Aurora Serverless v2
// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html)
// in the Amazon Aurora User Guide.
type ServerlessV2ScalingConfigurationInfo struct {

	// The maximum number of Aurora capacity units (ACUs) for a DB instance in an
	// Aurora Serverless v2 cluster. You can specify ACU values in half-step
	// increments, such as 40, 40.5, 41, and so on. The largest value that you can use
	// is 128.
	MaxCapacity *float64

	// The minimum number of Aurora capacity units (ACUs) for a DB instance in an
	// Aurora Serverless v2 cluster. You can specify ACU values in half-step
	// increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is
	// 0.5.
	MinCapacity *float64

	noSmithyDocumentSerde
}

// Contains an Amazon Web Services Region name as the result of a successful call
// to the DescribeSourceRegions action.
type SourceRegion struct {

	// The endpoint for the source Amazon Web Services Region endpoint.
	Endpoint *string

	// The name of the source Amazon Web Services Region.
	RegionName *string

	// The status of the source Amazon Web Services Region.
	Status *string

	// Whether the source Amazon Web Services Region supports replicating automated
	// backups to the current Amazon Web Services Region.
	SupportsDBInstanceAutomatedBackupsReplication bool

	noSmithyDocumentSerde
}

// This data type is used as a response element for the DescribeDBSubnetGroups
// operation.
type Subnet struct {

	// Contains Availability Zone information. This data type is used as an element in
	// the OrderableDBInstanceOption data type.
	SubnetAvailabilityZone *AvailabilityZone

	// The identifier of the subnet.
	SubnetIdentifier *string

	// If the subnet is associated with an Outpost, this value specifies the Outpost.
	// For more information about RDS on Outposts, see Amazon RDS on Amazon Web
	// Services Outposts
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in
	// the Amazon RDS User Guide.
	SubnetOutpost *Outpost

	// The status of the subnet.
	SubnetStatus *string

	noSmithyDocumentSerde
}

// Metadata assigned to an Amazon RDS resource consisting of a key-value pair.
type Tag struct {

	// A key is the required name of the tag. The string value can be from 1 to 128
	// Unicode characters in length and can't be prefixed with aws: or rds:. The string
	// can only contain only the set of Unicode letters, digits, white-space, '_', '.',
	// ':', '/', '=', '+', '-', '@' (Java regex:
	// "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").
	Key *string

	// A value is the optional value of the tag. The string value can be from 1 to 256
	// Unicode characters in length and can't be prefixed with aws: or rds:. The string
	// can only contain only the set of Unicode letters, digits, white-space, '_', '.',
	// ':', '/', '=', '+', '-', '@' (Java regex:
	// "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").
	Value *string

	noSmithyDocumentSerde
}

// Information about the connection health of an RDS Proxy target.
type TargetHealth struct {

	// A description of the health of the RDS Proxy target. If the State is AVAILABLE,
	// a description is not included.
	Description *string

	// The reason for the current health State of the RDS Proxy target.
	Reason TargetHealthReason

	// The current state of the connection health lifecycle for the RDS Proxy target.
	// The following is a typical lifecycle example for the states of an RDS Proxy
	// target: registering > unavailable > available > unavailable > available
	State TargetState

	noSmithyDocumentSerde
}

// A time zone associated with a DBInstance or a DBSnapshot. This data type is an
// element in the response to the DescribeDBInstances, the DescribeDBSnapshots, and
// the DescribeDBEngineVersions actions.
type Timezone struct {

	// The name of the time zone.
	TimezoneName *string

	noSmithyDocumentSerde
}

// The version of the database engine that a DB instance can be upgraded to.
type UpgradeTarget struct {

	// A value that indicates whether the target version is applied to any source DB
	// instances that have AutoMinorVersionUpgrade set to true.
	AutoUpgrade bool

	// The version of the database engine that a DB instance can be upgraded to.
	Description *string

	// The name of the upgrade target database engine.
	Engine *string

	// The version number of the upgrade target database engine.
	EngineVersion *string

	// A value that indicates whether upgrading to the target version requires
	// upgrading the major version of the database engine.
	IsMajorVersionUpgrade bool

	// A list of the supported DB engine modes for the target engine version.
	SupportedEngineModes []string

	// A value that indicates whether you can use Babelfish for Aurora PostgreSQL with
	// the target engine version.
	SupportsBabelfish *bool

	// A value that indicates whether you can use Aurora global databases with the
	// target engine version.
	SupportsGlobalDatabases *bool

	// A value that indicates whether you can use Aurora parallel query with the target
	// engine version.
	SupportsParallelQuery *bool

	noSmithyDocumentSerde
}

// Specifies the details of authentication used by a proxy to log in as a specific
// database user.
type UserAuthConfig struct {

	// The type of authentication that the proxy uses for connections from the proxy to
	// the underlying database.
	AuthScheme AuthScheme

	// A user-specified description about the authentication used by a proxy to log in
	// as a specific database user.
	Description *string

	// Whether to require or disallow Amazon Web Services Identity and Access
	// Management (IAM) authentication for connections to the proxy.
	IAMAuth IAMAuthMode

	// The Amazon Resource Name (ARN) representing the secret that the proxy uses to
	// authenticate to the RDS DB instance or Aurora DB cluster. These secrets are
	// stored within Amazon Secrets Manager.
	SecretArn *string

	// The name of the database user to which the proxy connects.
	UserName *string

	noSmithyDocumentSerde
}

// Returns the details of authentication used by a proxy to log in as a specific
// database user.
type UserAuthConfigInfo struct {

	// The type of authentication that the proxy uses for connections from the proxy to
	// the underlying database.
	AuthScheme AuthScheme

	// A user-specified description about the authentication used by a proxy to log in
	// as a specific database user.
	Description *string

	// Whether to require or disallow Amazon Web Services Identity and Access
	// Management (IAM) authentication for connections to the proxy.
	IAMAuth IAMAuthMode

	// The Amazon Resource Name (ARN) representing the secret that the proxy uses to
	// authenticate to the RDS DB instance or Aurora DB cluster. These secrets are
	// stored within Amazon Secrets Manager.
	SecretArn *string

	// The name of the database user to which the proxy connects.
	UserName *string

	noSmithyDocumentSerde
}

// Information about valid modifications that you can make to your DB instance.
// Contains the result of a successful call to the
// DescribeValidDBInstanceModifications action. You can use this information when
// you call ModifyDBInstance.
type ValidDBInstanceModificationsMessage struct {

	// Valid storage options for your DB instance.
	Storage []ValidStorageOptions

	// Valid processor features for your DB instance.
	ValidProcessorFeatures []AvailableProcessorFeature

	noSmithyDocumentSerde
}

// Information about valid modifications that you can make to your DB instance.
// Contains the result of a successful call to the
// DescribeValidDBInstanceModifications action.
type ValidStorageOptions struct {

	// The valid range of Provisioned IOPS to gibibytes of storage multiplier. For
	// example, 3-10, which means that provisioned IOPS can be between 3 and 10 times
	// storage.
	IopsToStorageRatio []DoubleRange

	// The valid range of provisioned IOPS. For example, 1000-20000.
	ProvisionedIops []Range

	// The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
	StorageSize []Range

	// The valid storage types for your DB instance. For example, gp2, io1.
	StorageType *string

	// Whether or not Amazon RDS can automatically scale storage for DB instances that
	// use the new instance class.
	SupportsStorageAutoscaling bool

	noSmithyDocumentSerde
}

// This data type is used as a response element for queries on VPC security group
// membership.
type VpcSecurityGroupMembership struct {

	// The membership status of the VPC security group. Currently, the only valid
	// status is active.
	Status *string

	// The name of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
