// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Details about a beta appliance software update.
type AlternateSoftwareMetadata struct {

	// The appliance software version.
	Version *string

	noSmithyDocumentSerde
}

// An application instance on a device.
type ApplicationInstance struct {

	// The application instance's ID.
	ApplicationInstanceId *string

	// The application instance's ARN.
	Arn *string

	// When the application instance was created.
	CreatedTime *time.Time

	// The device's ID.
	DefaultRuntimeContextDevice *string

	// The device's name.
	DefaultRuntimeContextDeviceName *string

	// The application instance's description.
	Description *string

	// The application instance's health status.
	HealthStatus ApplicationInstanceHealthStatus

	// The application instance's name.
	Name *string

	// The application instance's status.
	Status ApplicationInstanceStatus

	// The application instance's status description.
	StatusDescription *string

	// The application instance's tags.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A conflict exception error argument.
type ConflictExceptionErrorArgument struct {

	// The error argument's name.
	//
	// This member is required.
	Name *string

	// The error argument's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A device.
type Device struct {

	// The device's maker.
	Brand DeviceBrand

	// When the device was created.
	CreatedTime *time.Time

	// The device's ID.
	DeviceId *string

	// When the device was updated.
	LastUpdatedTime *time.Time

	// The device's lease expiration time.
	LeaseExpirationTime *time.Time

	// The device's name.
	Name *string

	// The device's provisioning status.
	ProvisioningStatus DeviceStatus

	noSmithyDocumentSerde
}

// A job that runs on a device.
type DeviceJob struct {

	// When the job was created.
	CreatedTime *time.Time

	// The ID of the target device.
	DeviceId *string

	// The name of the target device
	DeviceName *string

	// The job's ID.
	JobId *string

	noSmithyDocumentSerde
}

// A job's configuration.
type DeviceJobConfig struct {

	// A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.
	OTAJobConfig *OTAJobConfig

	noSmithyDocumentSerde
}

// A device's network configuration.
type EthernetPayload struct {

	// How the device gets an IP address.
	//
	// This member is required.
	ConnectionType ConnectionType

	// Network configuration for a static IP connection.
	StaticIpConnectionInfo *StaticIpConnectionInfo

	noSmithyDocumentSerde
}

// A device's Ethernet status.
type EthernetStatus struct {

	// The device's connection status.
	ConnectionStatus NetworkConnectionStatus

	// The device's physical address.
	HwAddress *string

	// The device's IP address.
	IpAddress *string

	noSmithyDocumentSerde
}

// A job for a device.
type Job struct {

	// The target device's ID.
	DeviceId *string

	// The job's ID.
	JobId *string

	noSmithyDocumentSerde
}

// Tags for a job.
type JobResourceTags struct {

	// The job's type.
	//
	// This member is required.
	ResourceType JobResourceType

	// The job's tags.
	//
	// This member is required.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Parameter overrides for an application instance. This is a JSON document that
// has a single key (PayloadData) where the value is an escaped string
// representation of the overrides document.
//
// The following types satisfy this interface:
//  ManifestOverridesPayloadMemberPayloadData
type ManifestOverridesPayload interface {
	isManifestOverridesPayload()
}

// The overrides document.
type ManifestOverridesPayloadMemberPayloadData struct {
	Value string

	noSmithyDocumentSerde
}

func (*ManifestOverridesPayloadMemberPayloadData) isManifestOverridesPayload() {}

// A application verion's manifest file. This is a JSON document that has a single
// key (PayloadData) where the value is an escaped string representation of the
// application manifest (graph.json). This file is located in the graphs folder in
// your application source.
//
// The following types satisfy this interface:
//  ManifestPayloadMemberPayloadData
type ManifestPayload interface {
	isManifestPayload()
}

// The application manifest.
type ManifestPayloadMemberPayloadData struct {
	Value string

	noSmithyDocumentSerde
}

func (*ManifestPayloadMemberPayloadData) isManifestPayload() {}

// The network configuration for a device.
type NetworkPayload struct {

	// Settings for Ethernet port 0.
	Ethernet0 *EthernetPayload

	// Settings for Ethernet port 1.
	Ethernet1 *EthernetPayload

	// Network time protocol (NTP) server settings.
	Ntp *NtpPayload

	noSmithyDocumentSerde
}

// The network status of a device.
type NetworkStatus struct {

	// The status of Ethernet port 0.
	Ethernet0Status *EthernetStatus

	// The status of Ethernet port 1.
	Ethernet1Status *EthernetStatus

	// When the network status changed.
	LastUpdatedTime *time.Time

	// Details about a network time protocol (NTP) server connection.
	NtpStatus *NtpStatus

	noSmithyDocumentSerde
}

// An application node that represents a camera stream, a model, code, or output.
type Node struct {

	// The node's category.
	//
	// This member is required.
	Category NodeCategory

	// When the node was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The node's name.
	//
	// This member is required.
	Name *string

	// The node's ID.
	//
	// This member is required.
	NodeId *string

	// The node's package ID.
	//
	// This member is required.
	PackageId *string

	// The node's package name.
	//
	// This member is required.
	PackageName *string

	// The node's package version.
	//
	// This member is required.
	PackageVersion *string

	// The node's patch version.
	//
	// This member is required.
	PatchVersion *string

	// The node's description.
	Description *string

	// The account ID of the node's owner.
	OwnerAccount *string

	// The node's ARN.
	PackageArn *string

	noSmithyDocumentSerde
}

// A job to create a camera stream node.
type NodeFromTemplateJob struct {

	// When the job was created.
	CreatedTime *time.Time

	// The job's ID.
	JobId *string

	// The node's name.
	NodeName *string

	// The job's status.
	Status NodeFromTemplateJobStatus

	// The job's status message.
	StatusMessage *string

	// The job's template type.
	TemplateType TemplateType

	noSmithyDocumentSerde
}

// A node input port.
type NodeInputPort struct {

	// The input port's default value.
	DefaultValue *string

	// The input port's description.
	Description *string

	// The input port's max connections.
	MaxConnections int32

	// The input port's name.
	Name *string

	// The input port's type.
	Type PortType

	noSmithyDocumentSerde
}

// A node instance.
type NodeInstance struct {

	// The instance's current status.
	//
	// This member is required.
	CurrentStatus NodeInstanceStatus

	// The instance's ID.
	//
	// This member is required.
	NodeInstanceId *string

	// The node's ID.
	NodeId *string

	// The instance's name.
	NodeName *string

	// The instance's package name.
	PackageName *string

	// The instance's package patch version.
	PackagePatchVersion *string

	// The instance's package version.
	PackageVersion *string

	noSmithyDocumentSerde
}

// A node interface.
type NodeInterface struct {

	// The node interface's inputs.
	//
	// This member is required.
	Inputs []NodeInputPort

	// The node interface's outputs.
	//
	// This member is required.
	Outputs []NodeOutputPort

	noSmithyDocumentSerde
}

// A node output port.
type NodeOutputPort struct {

	// The output port's description.
	Description *string

	// The output port's name.
	Name *string

	// The output port's type.
	Type PortType

	noSmithyDocumentSerde
}

// Network time protocol (NTP) server settings. Use this option to connect to local
// NTP servers instead of pool.ntp.org.
type NtpPayload struct {

	// NTP servers to use, in order of preference.
	//
	// This member is required.
	NtpServers []string

	noSmithyDocumentSerde
}

// Details about an NTP server connection.
type NtpStatus struct {

	// The connection's status.
	ConnectionStatus NetworkConnectionStatus

	// The IP address of the server.
	IpAddress *string

	// The domain name of the server.
	NtpServerName *string

	noSmithyDocumentSerde
}

// An over-the-air update (OTA) job configuration.
type OTAJobConfig struct {

	// The target version of the device software.
	//
	// This member is required.
	ImageVersion *string

	noSmithyDocumentSerde
}

// The location of an output object in Amazon S3.
type OutPutS3Location struct {

	// The object's bucket.
	//
	// This member is required.
	BucketName *string

	// The object's key.
	//
	// This member is required.
	ObjectKey *string

	noSmithyDocumentSerde
}

// A job to import a package version.
type PackageImportJob struct {

	// When the job was created.
	CreatedTime *time.Time

	// The job's ID.
	JobId *string

	// The job's type.
	JobType PackageImportJobType

	// When the job was updated.
	LastUpdatedTime *time.Time

	// The job's status.
	Status PackageImportJobStatus

	// The job's status message.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A configuration for a package import job.
type PackageImportJobInputConfig struct {

	// The package version's input configuration.
	PackageVersionInputConfig *PackageVersionInputConfig

	noSmithyDocumentSerde
}

// Results of a package import job.
type PackageImportJobOutput struct {

	// The package's output location.
	//
	// This member is required.
	OutputS3Location *OutPutS3Location

	// The package's ID.
	//
	// This member is required.
	PackageId *string

	// The package's version.
	//
	// This member is required.
	PackageVersion *string

	// The package's patch version.
	//
	// This member is required.
	PatchVersion *string

	noSmithyDocumentSerde
}

// An output configuration for a package import job.
type PackageImportJobOutputConfig struct {

	// The package version's output configuration.
	PackageVersionOutputConfig *PackageVersionOutputConfig

	noSmithyDocumentSerde
}

// A package summary.
type PackageListItem struct {

	// The package's ARN.
	Arn *string

	// When the package was created.
	CreatedTime *time.Time

	// The package's ID.
	PackageId *string

	// The package's name.
	PackageName *string

	// The package's tags.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A package object.
type PackageObject struct {

	// The object's name.
	//
	// This member is required.
	Name *string

	// The object's package version.
	//
	// This member is required.
	PackageVersion *string

	// The object's patch version.
	//
	// This member is required.
	PatchVersion *string

	noSmithyDocumentSerde
}

// A package version input configuration.
type PackageVersionInputConfig struct {

	// A location in Amazon S3.
	//
	// This member is required.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// A package version output configuration.
type PackageVersionOutputConfig struct {

	// The output's package name.
	//
	// This member is required.
	PackageName *string

	// The output's package version.
	//
	// This member is required.
	PackageVersion *string

	// Indicates that the version is recommended for all users.
	MarkLatest bool

	noSmithyDocumentSerde
}

// A location in Amazon S3.
type S3Location struct {

	// A bucket name.
	//
	// This member is required.
	BucketName *string

	// An object key.
	//
	// This member is required.
	ObjectKey *string

	// The bucket's Region.
	Region *string

	noSmithyDocumentSerde
}

// A static IP configuration.
type StaticIpConnectionInfo struct {

	// The connection's default gateway.
	//
	// This member is required.
	DefaultGateway *string

	// The connection's DNS address.
	//
	// This member is required.
	Dns []string

	// The connection's IP address.
	//
	// This member is required.
	IpAddress *string

	// The connection's DNS mask.
	//
	// This member is required.
	Mask *string

	noSmithyDocumentSerde
}

// A storage location.
type StorageLocation struct {

	// The location's binary prefix.
	//
	// This member is required.
	BinaryPrefixLocation *string

	// The location's bucket.
	//
	// This member is required.
	Bucket *string

	// The location's generated prefix.
	//
	// This member is required.
	GeneratedPrefixLocation *string

	// The location's manifest prefix.
	//
	// This member is required.
	ManifestPrefixLocation *string

	// The location's repo prefix.
	//
	// This member is required.
	RepoPrefixLocation *string

	noSmithyDocumentSerde
}

// A validation exception error argument.
type ValidationExceptionErrorArgument struct {

	// The argument's name.
	//
	// This member is required.
	Name *string

	// The argument's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A validation exception field.
type ValidationExceptionField struct {

	// The field's message.
	//
	// This member is required.
	Message *string

	// The field's name.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isManifestOverridesPayload() {}
func (*UnknownUnionMember) isManifestPayload()          {}
