// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// An Amazon Chime SDK meeting attendee. Includes a unique AttendeeId and
// JoinToken. The JoinToken allows a client to authenticate and join as the
// specified attendee. The JoinToken expires when the meeting ends, or when
// DeleteAttendee is called. After that, the attendee is unable to join the
// meeting. We recommend securely transferring each JoinToken from your server
// application to the client so that no other client has access to the token except
// for the one authorized to represent the attendee.
type Attendee struct {

	// The Amazon Chime SDK attendee ID.
	AttendeeId *string

	// The capabilities assigned to an attendee: audio, video, or content. You use the
	// capabilities with a set of values that control what the capabilities can do,
	// such as SendReceive data. For more information about those values, see . When
	// using capabilities, be aware of these corner cases:
	//
	// * You can't set content
	// capabilities to SendReceive or Receive unless you also set video capabilities to
	// SendReceive or Receive. If you don't set the video capability to receive, the
	// response will contain an HTTP 400 Bad Request status code. However, you can set
	// your video capability to receive and you set your content capability to not
	// receive.
	//
	// * When you change an audio capability from None or Receive to Send or
	// SendReceive , and if the attendee left their microphone unmuted, audio will flow
	// from the attendee to the other meeting participants.
	//
	// * When you change a video
	// or content capability from None or Receive to Send or SendReceive , and if the
	// attendee turned on their video or content streams, remote attendess can receive
	// those streams, but only after media renegotiation between the client and the
	// Amazon Chime back-end server.
	Capabilities *AttendeeCapabilities

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	ExternalUserId *string

	// The join token used by the Amazon Chime SDK attendee.
	JoinToken *string

	noSmithyDocumentSerde
}

// The media capabilities of an attendee: audio, video, or content. You use the
// capabilities with a set of values that control what the capabilities can do,
// such as SendReceive data. For more information about those values, see . When
// using capabilities, be aware of these corner cases:
//
// * You can't set content
// capabilities to SendReceive or Receive unless you also set video capabilities to
// SendReceive or Receive. If you don't set the video capability to receive, the
// response will contain an HTTP 400 Bad Request status code. However, you can set
// your video capability to receive and you set your content capability to not
// receive.
//
// * When you change an audio capability from None or Receive to Send or
// SendReceive , and if the attendee left their microphone unmuted, audio will flow
// from the attendee to the other meeting participants.
//
// * When you change a video
// or content capability from None or Receive to Send or SendReceive , and if the
// attendee turned on their video or content streams, remote attendess can receive
// those streams, but only after media renegotiation between the client and the
// Amazon Chime back-end server.
type AttendeeCapabilities struct {

	// The audio capability assigned to an attendee.
	//
	// This member is required.
	Audio MediaCapabilities

	// The content capability assigned to an attendee.
	//
	// This member is required.
	Content MediaCapabilities

	// The video capability assigned to an attendee.
	//
	// This member is required.
	Video MediaCapabilities

	noSmithyDocumentSerde
}

// A structure that contains one or more attendee IDs.
type AttendeeIdItem struct {

	// A list of one or more attendee IDs.
	//
	// This member is required.
	AttendeeId *string

	noSmithyDocumentSerde
}

// An optional category of meeting features that contains audio-specific
// configurations, such as operating parameters for Amazon Voice Focus.
type AudioFeatures struct {

	// Makes echo reduction available to clients who connect to the meeting.
	EchoReduction MeetingFeatureStatus

	noSmithyDocumentSerde
}

// The list of errors returned when errors are encountered during the
// BatchCreateAttendee and CreateAttendee actions. This includes external user IDs,
// error codes, and error messages.
type CreateAttendeeError struct {

	// The error code.
	ErrorCode *string

	// The error message.
	ErrorMessage *string

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	ExternalUserId *string

	noSmithyDocumentSerde
}

// The Amazon Chime SDK attendee fields to create, used with the
// BatchCreateAttendee action.
type CreateAttendeeRequestItem struct {

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// This member is required.
	ExternalUserId *string

	// A list of one or more capabilities.
	Capabilities *AttendeeCapabilities

	noSmithyDocumentSerde
}

// Settings specific to the Amazon Transcribe Medical engine.
type EngineTranscribeMedicalSettings struct {

	// The language code specified for the Amazon Transcribe Medical engine.
	//
	// This member is required.
	LanguageCode TranscribeMedicalLanguageCode

	// The specialty specified for the Amazon Transcribe Medical engine.
	//
	// This member is required.
	Specialty TranscribeMedicalSpecialty

	// The type of transcription.
	//
	// This member is required.
	Type TranscribeMedicalType

	// Set this field to PHI to identify personal health information in the
	// transcription output.
	ContentIdentificationType TranscribeMedicalContentIdentificationType

	// The AWS Region passed to Amazon Transcribe Medical. If you don't specify a
	// Region, Amazon Chime uses the meeting's Region.
	Region TranscribeMedicalRegion

	// The name of the vocabulary passed to Amazon Transcribe Medical.
	VocabularyName *string

	noSmithyDocumentSerde
}

// Settings specific to the Amazon Transcribe engine.
type EngineTranscribeSettings struct {

	// Set this field to PII to identify personally identifiable information in the
	// transcription output.
	ContentIdentificationType TranscribeContentIdentificationType

	// Set this field to PII to redact personally identifiable information in the
	// transcription output. Content redaction is performed only upon complete
	// transcription of the audio segments. You can’t set ContentRedactionType and
	// ContentIdentificationType in the same request. If you set both, your request
	// returns a BadRequestException.
	ContentRedactionType TranscribeContentRedactionType

	// Generates partial transcription results that are less likely to change as
	// meeting attendees speak. It does so by only allowing the last few words from the
	// partial results to change.
	EnablePartialResultsStabilization bool

	// Automatically identifies the language spoken in media files.
	IdentifyLanguage bool

	// The language code specified for the Amazon Transcribe engine.
	LanguageCode TranscribeLanguageCode

	// The name of the language model used during transcription.
	LanguageModelName *string

	// Language codes for the languages that you want to identify. You must provide at
	// least 2 codes.
	LanguageOptions *string

	// The stabity level of a partial results transcription. Determines how stable you
	// want the transcription results to be. A higher level means the transcription
	// results are less likely to change.
	PartialResultsStability TranscribePartialResultsStability

	// Lists the PII entity types you want to identify or redact. To specify entity
	// types, you must enable ContentIdentificationType or ContentRedactionType.
	// PIIEntityTypes must be comma-separated. The available values are:
	// BANK_ACCOUNT_NUMBER, BANK_ROUTING, CREDIT_DEBIT_NUMBER, CREDIT_DEBIT_CVV,
	// CREDIT_DEBIT_EXPIRY, PIN, EMAIL, ADDRESS, NAME, PHONE, SSN, and ALL.
	// PiiEntityTypes is an optional parameter with a default value of ALL.
	PiiEntityTypes *string

	// Language code for the preferred language.
	PreferredLanguage TranscribeLanguageCode

	// The AWS Region passed to Amazon Transcribe. If you don't specify a Region,
	// Amazon Chime uses the meeting's Region.
	Region TranscribeRegion

	// The filtering method passed to Amazon Transcribe.
	VocabularyFilterMethod TranscribeVocabularyFilterMethod

	// The name of the vocabulary filter passed to Amazon Transcribe.
	VocabularyFilterName *string

	// The name of the vocabulary passed to Amazon Transcribe.
	VocabularyName *string

	noSmithyDocumentSerde
}

// A set of endpoints used by clients to connect to the media service group for an
// Amazon Chime SDK meeting.
type MediaPlacement struct {

	// The audio fallback URL.
	AudioFallbackUrl *string

	// The audio host URL.
	AudioHostUrl *string

	// The event ingestion URL.
	EventIngestionUrl *string

	// The screen data URL.
	ScreenDataUrl *string

	// The screen sharing URL.
	ScreenSharingUrl *string

	// The screen viewing URL.
	ScreenViewingUrl *string

	// The signaling URL.
	SignalingUrl *string

	// The turn control URL.
	TurnControlUrl *string

	noSmithyDocumentSerde
}

// A meeting created using the Amazon Chime SDK.
type Meeting struct {

	// The external meeting ID.
	ExternalMeetingId *string

	// The media placement for the meeting.
	MediaPlacement *MediaPlacement

	// The Region in which you create the meeting. Available values: af-south-1,
	// ap-northeast-1, ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2,
	// ca-central-1, eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2,
	// eu-west-3, sa-east-1, us-east-1, us-east-2, us-west-1, us-west-2. Available
	// values in AWS GovCloud (US) Regions: us-gov-east-1, us-gov-west-1.
	MediaRegion *string

	// The features available to a meeting, such as Amazon Voice Focus.
	MeetingFeatures *MeetingFeaturesConfiguration

	// Reserved.
	MeetingHostId *string

	// The Amazon Chime SDK meeting ID.
	MeetingId *string

	// When specified, replicates the media from the primary meeting to this meeting.
	PrimaryMeetingId *string

	// Array of strings.
	TenantIds []string

	noSmithyDocumentSerde
}

// The configuration settings of the features available to a meeting.>
type MeetingFeaturesConfiguration struct {

	// The configuration settings for the audio features available to a meeting.
	Audio *AudioFeatures

	noSmithyDocumentSerde
}

// The configuration for resource targets to receive notifications when meeting and
// attendee events occur.
type NotificationsConfiguration struct {

	// The ARN of the AWS Lambda function in the notifications configuration.
	LambdaFunctionArn *string

	// The ARN of the SNS topic.
	SnsTopicArn *string

	// The ARN of the SQS queue.
	SqsQueueArn *string

	noSmithyDocumentSerde
}

// The configuration for the current transcription operation. Must contain
// EngineTranscribeSettings or EngineTranscribeMedicalSettings.
type TranscriptionConfiguration struct {

	// The transcription configuration settings passed to Amazon Transcribe Medical.
	EngineTranscribeMedicalSettings *EngineTranscribeMedicalSettings

	// The transcription configuration settings passed to Amazon Transcribe.
	EngineTranscribeSettings *EngineTranscribeSettings

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
