//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
	"time"
)

// MarshalJSON implements the json.Marshaller interface for type AbsoluteDeleteOption.
func (a AbsoluteDeleteOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "duration", a.Duration)
	objectMap["objectType"] = "AbsoluteDeleteOption"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AbsoluteDeleteOption.
func (a *AbsoluteDeleteOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdhocBasedTriggerContext.
func (a AdhocBasedTriggerContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AdhocBasedTriggerContext"
	populate(objectMap, "taggingCriteria", a.TaggingCriteria)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdhocBasedTriggerContext.
func (a *AdhocBasedTriggerContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "taggingCriteria":
			err = unpopulate(val, "TaggingCriteria", &a.TaggingCriteria)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupDiscreteRecoveryPoint.
func (a AzureBackupDiscreteRecoveryPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "friendlyName", a.FriendlyName)
	objectMap["objectType"] = "AzureBackupDiscreteRecoveryPoint"
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "policyVersion", a.PolicyVersion)
	populate(objectMap, "recoveryPointDataStoresDetails", a.RecoveryPointDataStoresDetails)
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	populateTimeRFC3339(objectMap, "recoveryPointTime", a.RecoveryPointTime)
	populate(objectMap, "recoveryPointType", a.RecoveryPointType)
	populate(objectMap, "retentionTagName", a.RetentionTagName)
	populate(objectMap, "retentionTagVersion", a.RetentionTagVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupDiscreteRecoveryPoint.
func (a *AzureBackupDiscreteRecoveryPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "policyVersion":
			err = unpopulate(val, "PolicyVersion", &a.PolicyVersion)
			delete(rawMsg, key)
		case "recoveryPointDataStoresDetails":
			err = unpopulate(val, "RecoveryPointDataStoresDetails", &a.RecoveryPointDataStoresDetails)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTime", &a.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &a.RecoveryPointType)
			delete(rawMsg, key)
		case "retentionTagName":
			err = unpopulate(val, "RetentionTagName", &a.RetentionTagName)
			delete(rawMsg, key)
		case "retentionTagVersion":
			err = unpopulate(val, "RetentionTagVersion", &a.RetentionTagVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupFindRestorableTimeRangesResponse.
func (a AzureBackupFindRestorableTimeRangesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "objectType", a.ObjectType)
	populate(objectMap, "restorableTimeRanges", a.RestorableTimeRanges)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupJob.
func (a AzureBackupJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activityID", a.ActivityID)
	populate(objectMap, "backupInstanceFriendlyName", a.BackupInstanceFriendlyName)
	populate(objectMap, "backupInstanceId", a.BackupInstanceID)
	populate(objectMap, "dataSourceId", a.DataSourceID)
	populate(objectMap, "dataSourceLocation", a.DataSourceLocation)
	populate(objectMap, "dataSourceName", a.DataSourceName)
	populate(objectMap, "dataSourceSetName", a.DataSourceSetName)
	populate(objectMap, "dataSourceType", a.DataSourceType)
	populate(objectMap, "destinationDataStoreName", a.DestinationDataStoreName)
	populate(objectMap, "duration", a.Duration)
	populateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "extendedInfo", a.ExtendedInfo)
	populate(objectMap, "isUserTriggered", a.IsUserTriggered)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "operationCategory", a.OperationCategory)
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "progressEnabled", a.ProgressEnabled)
	populate(objectMap, "progressUrl", a.ProgressURL)
	populate(objectMap, "restoreType", a.RestoreType)
	populate(objectMap, "sourceDataStoreName", a.SourceDataStoreName)
	populate(objectMap, "sourceResourceGroup", a.SourceResourceGroup)
	populate(objectMap, "sourceSubscriptionID", a.SourceSubscriptionID)
	populateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	populate(objectMap, "supportedActions", a.SupportedActions)
	populate(objectMap, "vaultName", a.VaultName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupJob.
func (a *AzureBackupJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityID":
			err = unpopulate(val, "ActivityID", &a.ActivityID)
			delete(rawMsg, key)
		case "backupInstanceFriendlyName":
			err = unpopulate(val, "BackupInstanceFriendlyName", &a.BackupInstanceFriendlyName)
			delete(rawMsg, key)
		case "backupInstanceId":
			err = unpopulate(val, "BackupInstanceID", &a.BackupInstanceID)
			delete(rawMsg, key)
		case "dataSourceId":
			err = unpopulate(val, "DataSourceID", &a.DataSourceID)
			delete(rawMsg, key)
		case "dataSourceLocation":
			err = unpopulate(val, "DataSourceLocation", &a.DataSourceLocation)
			delete(rawMsg, key)
		case "dataSourceName":
			err = unpopulate(val, "DataSourceName", &a.DataSourceName)
			delete(rawMsg, key)
		case "dataSourceSetName":
			err = unpopulate(val, "DataSourceSetName", &a.DataSourceSetName)
			delete(rawMsg, key)
		case "dataSourceType":
			err = unpopulate(val, "DataSourceType", &a.DataSourceType)
			delete(rawMsg, key)
		case "destinationDataStoreName":
			err = unpopulate(val, "DestinationDataStoreName", &a.DestinationDataStoreName)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "extendedInfo":
			err = unpopulate(val, "ExtendedInfo", &a.ExtendedInfo)
			delete(rawMsg, key)
		case "isUserTriggered":
			err = unpopulate(val, "IsUserTriggered", &a.IsUserTriggered)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "operationCategory":
			err = unpopulate(val, "OperationCategory", &a.OperationCategory)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "progressEnabled":
			err = unpopulate(val, "ProgressEnabled", &a.ProgressEnabled)
			delete(rawMsg, key)
		case "progressUrl":
			err = unpopulate(val, "ProgressURL", &a.ProgressURL)
			delete(rawMsg, key)
		case "restoreType":
			err = unpopulate(val, "RestoreType", &a.RestoreType)
			delete(rawMsg, key)
		case "sourceDataStoreName":
			err = unpopulate(val, "SourceDataStoreName", &a.SourceDataStoreName)
			delete(rawMsg, key)
		case "sourceResourceGroup":
			err = unpopulate(val, "SourceResourceGroup", &a.SourceResourceGroup)
			delete(rawMsg, key)
		case "sourceSubscriptionID":
			err = unpopulate(val, "SourceSubscriptionID", &a.SourceSubscriptionID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "supportedActions":
			err = unpopulate(val, "SupportedActions", &a.SupportedActions)
			delete(rawMsg, key)
		case "vaultName":
			err = unpopulate(val, "VaultName", &a.VaultName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupParams.
func (a AzureBackupParams) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupType", a.BackupType)
	objectMap["objectType"] = "AzureBackupParams"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupParams.
func (a *AzureBackupParams) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupType":
			err = unpopulate(val, "BackupType", &a.BackupType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRecoveryPointBasedRestoreRequest.
func (a AzureBackupRecoveryPointBasedRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureBackupRecoveryPointBasedRestoreRequest"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	populate(objectMap, "restoreTargetInfo", a.RestoreTargetInfo)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRecoveryPointBasedRestoreRequest.
func (a *AzureBackupRecoveryPointBasedRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		case "restoreTargetInfo":
			a.RestoreTargetInfo, err = unmarshalRestoreTargetInfoBaseClassification(val)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRecoveryPointResource.
func (a AzureBackupRecoveryPointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRecoveryPointResource.
func (a *AzureBackupRecoveryPointResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			a.Properties, err = unmarshalAzureBackupRecoveryPointClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRecoveryTimeBasedRestoreRequest.
func (a AzureBackupRecoveryTimeBasedRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureBackupRecoveryTimeBasedRestoreRequest"
	populate(objectMap, "recoveryPointTime", a.RecoveryPointTime)
	populate(objectMap, "restoreTargetInfo", a.RestoreTargetInfo)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRecoveryTimeBasedRestoreRequest.
func (a *AzureBackupRecoveryTimeBasedRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulate(val, "RecoveryPointTime", &a.RecoveryPointTime)
			delete(rawMsg, key)
		case "restoreTargetInfo":
			a.RestoreTargetInfo, err = unmarshalRestoreTargetInfoBaseClassification(val)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRestoreRequest.
func (a AzureBackupRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = a.ObjectType
	populate(objectMap, "restoreTargetInfo", a.RestoreTargetInfo)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRestoreRequest.
func (a *AzureBackupRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "restoreTargetInfo":
			a.RestoreTargetInfo, err = unmarshalRestoreTargetInfoBaseClassification(val)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRestoreWithRehydrationRequest.
func (a AzureBackupRestoreWithRehydrationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "AzureBackupRestoreWithRehydrationRequest"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	populate(objectMap, "rehydrationPriority", a.RehydrationPriority)
	populate(objectMap, "rehydrationRetentionDuration", a.RehydrationRetentionDuration)
	populate(objectMap, "restoreTargetInfo", a.RestoreTargetInfo)
	populate(objectMap, "sourceDataStoreType", a.SourceDataStoreType)
	populate(objectMap, "sourceResourceId", a.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRestoreWithRehydrationRequest.
func (a *AzureBackupRestoreWithRehydrationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		case "rehydrationPriority":
			err = unpopulate(val, "RehydrationPriority", &a.RehydrationPriority)
			delete(rawMsg, key)
		case "rehydrationRetentionDuration":
			err = unpopulate(val, "RehydrationRetentionDuration", &a.RehydrationRetentionDuration)
			delete(rawMsg, key)
		case "restoreTargetInfo":
			a.RestoreTargetInfo, err = unmarshalRestoreTargetInfoBaseClassification(val)
			delete(rawMsg, key)
		case "sourceDataStoreType":
			err = unpopulate(val, "SourceDataStoreType", &a.SourceDataStoreType)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &a.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBackupRule.
func (a AzureBackupRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupParameters", a.BackupParameters)
	populate(objectMap, "dataStore", a.DataStore)
	populate(objectMap, "name", a.Name)
	objectMap["objectType"] = "AzureBackupRule"
	populate(objectMap, "trigger", a.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBackupRule.
func (a *AzureBackupRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupParameters":
			a.BackupParameters, err = unmarshalBackupParametersClassification(val)
			delete(rawMsg, key)
		case "dataStore":
			err = unpopulate(val, "DataStore", &a.DataStore)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "trigger":
			a.Trigger, err = unmarshalTriggerContextClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureOperationalStoreParameters.
func (a AzureOperationalStoreParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataStoreType", a.DataStoreType)
	objectMap["objectType"] = "AzureOperationalStoreParameters"
	populate(objectMap, "resourceGroupId", a.ResourceGroupID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureOperationalStoreParameters.
func (a *AzureOperationalStoreParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataStoreType":
			err = unpopulate(val, "DataStoreType", &a.DataStoreType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		case "resourceGroupId":
			err = unpopulate(val, "ResourceGroupID", &a.ResourceGroupID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureRetentionRule.
func (a AzureRetentionRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isDefault", a.IsDefault)
	populate(objectMap, "lifecycles", a.Lifecycles)
	populate(objectMap, "name", a.Name)
	objectMap["objectType"] = "AzureRetentionRule"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureRetentionRule.
func (a *AzureRetentionRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isDefault":
			err = unpopulate(val, "IsDefault", &a.IsDefault)
			delete(rawMsg, key)
		case "lifecycles":
			err = unpopulate(val, "Lifecycles", &a.Lifecycles)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &a.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupInstance.
func (b BackupInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentProtectionState", b.CurrentProtectionState)
	populate(objectMap, "dataSourceInfo", b.DataSourceInfo)
	populate(objectMap, "dataSourceSetInfo", b.DataSourceSetInfo)
	populate(objectMap, "datasourceAuthCredentials", b.DatasourceAuthCredentials)
	populate(objectMap, "friendlyName", b.FriendlyName)
	populate(objectMap, "objectType", b.ObjectType)
	populate(objectMap, "policyInfo", b.PolicyInfo)
	populate(objectMap, "protectionErrorDetails", b.ProtectionErrorDetails)
	populate(objectMap, "protectionStatus", b.ProtectionStatus)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "validationType", b.ValidationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupInstance.
func (b *BackupInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentProtectionState":
			err = unpopulate(val, "CurrentProtectionState", &b.CurrentProtectionState)
			delete(rawMsg, key)
		case "dataSourceInfo":
			err = unpopulate(val, "DataSourceInfo", &b.DataSourceInfo)
			delete(rawMsg, key)
		case "dataSourceSetInfo":
			err = unpopulate(val, "DataSourceSetInfo", &b.DataSourceSetInfo)
			delete(rawMsg, key)
		case "datasourceAuthCredentials":
			b.DatasourceAuthCredentials, err = unmarshalAuthCredentialsClassification(val)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &b.FriendlyName)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		case "policyInfo":
			err = unpopulate(val, "PolicyInfo", &b.PolicyInfo)
			delete(rawMsg, key)
		case "protectionErrorDetails":
			err = unpopulate(val, "ProtectionErrorDetails", &b.ProtectionErrorDetails)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &b.ProtectionStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "validationType":
			err = unpopulate(val, "ValidationType", &b.ValidationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicy.
func (b BackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datasourceTypes", b.DatasourceTypes)
	objectMap["objectType"] = "BackupPolicy"
	populate(objectMap, "policyRules", b.PolicyRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicy.
func (b *BackupPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceTypes":
			err = unpopulate(val, "DatasourceTypes", &b.DatasourceTypes)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &b.ObjectType)
			delete(rawMsg, key)
		case "policyRules":
			b.PolicyRules, err = unmarshalBasePolicyRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupSchedule.
func (b BackupSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "repeatingTimeIntervals", b.RepeatingTimeIntervals)
	populate(objectMap, "timeZone", b.TimeZone)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackupVault.
func (b BackupVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "monitoringSettings", b.MonitoringSettings)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "resourceMoveDetails", b.ResourceMoveDetails)
	populate(objectMap, "resourceMoveState", b.ResourceMoveState)
	populate(objectMap, "storageSettings", b.StorageSettings)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BackupVaultResource.
func (b BackupVaultResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "identity", b.Identity)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BaseBackupPolicy.
func (b BaseBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datasourceTypes", b.DatasourceTypes)
	objectMap["objectType"] = b.ObjectType
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BaseBackupPolicyResource.
func (b BaseBackupPolicyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaseBackupPolicyResource.
func (b *BaseBackupPolicyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			b.Properties, err = unmarshalBaseBackupPolicyClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyOnExpiryOption.
func (c CopyOnExpiryOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "CopyOnExpiryOption"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyOnExpiryOption.
func (c *CopyOnExpiryOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &c.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomCopyOption.
func (c CustomCopyOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "duration", c.Duration)
	objectMap["objectType"] = "CustomCopyOption"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomCopyOption.
func (c *CustomCopyOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &c.Duration)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &c.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DppTrackedResource.
func (d DppTrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", d.ETag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FeatureValidationRequest.
func (f FeatureValidationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "featureName", f.FeatureName)
	populate(objectMap, "featureType", f.FeatureType)
	objectMap["objectType"] = "FeatureValidationRequest"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureValidationRequest.
func (f *FeatureValidationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureName":
			err = unpopulate(val, "FeatureName", &f.FeatureName)
			delete(rawMsg, key)
		case "featureType":
			err = unpopulate(val, "FeatureType", &f.FeatureType)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &f.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureValidationResponse.
func (f *FeatureValidationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureType":
			err = unpopulate(val, "FeatureType", &f.FeatureType)
			delete(rawMsg, key)
		case "features":
			err = unpopulate(val, "Features", &f.Features)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &f.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImmediateCopyOption.
func (i ImmediateCopyOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "ImmediateCopyOption"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImmediateCopyOption.
func (i *ImmediateCopyOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerError.
func (i InnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", i.AdditionalInfo)
	populate(objectMap, "code", i.Code)
	populate(objectMap, "embeddedInnerError", i.EmbeddedInnerError)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ItemLevelRestoreTargetInfo.
func (i ItemLevelRestoreTargetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datasourceAuthCredentials", i.DatasourceAuthCredentials)
	populate(objectMap, "datasourceInfo", i.DatasourceInfo)
	populate(objectMap, "datasourceSetInfo", i.DatasourceSetInfo)
	objectMap["objectType"] = "ItemLevelRestoreTargetInfo"
	populate(objectMap, "recoveryOption", i.RecoveryOption)
	populate(objectMap, "restoreCriteria", i.RestoreCriteria)
	populate(objectMap, "restoreLocation", i.RestoreLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ItemLevelRestoreTargetInfo.
func (i *ItemLevelRestoreTargetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceAuthCredentials":
			i.DatasourceAuthCredentials, err = unmarshalAuthCredentialsClassification(val)
			delete(rawMsg, key)
		case "datasourceInfo":
			err = unpopulate(val, "DatasourceInfo", &i.DatasourceInfo)
			delete(rawMsg, key)
		case "datasourceSetInfo":
			err = unpopulate(val, "DatasourceSetInfo", &i.DatasourceSetInfo)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &i.ObjectType)
			delete(rawMsg, key)
		case "recoveryOption":
			err = unpopulate(val, "RecoveryOption", &i.RecoveryOption)
			delete(rawMsg, key)
		case "restoreCriteria":
			i.RestoreCriteria, err = unmarshalItemLevelRestoreCriteriaClassificationArray(val)
			delete(rawMsg, key)
		case "restoreLocation":
			err = unpopulate(val, "RestoreLocation", &i.RestoreLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobExtendedInfo.
func (j JobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalDetails", j.AdditionalDetails)
	populate(objectMap, "backupInstanceState", j.BackupInstanceState)
	populate(objectMap, "dataTransferredInBytes", j.DataTransferredInBytes)
	populate(objectMap, "recoveryDestination", j.RecoveryDestination)
	populate(objectMap, "sourceRecoverPoint", j.SourceRecoverPoint)
	populate(objectMap, "subTasks", j.SubTasks)
	populate(objectMap, "targetRecoverPoint", j.TargetRecoverPoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobSubTask.
func (j JobSubTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalDetails", j.AdditionalDetails)
	populate(objectMap, "taskId", j.TaskID)
	populate(objectMap, "taskName", j.TaskName)
	populate(objectMap, "taskProgress", j.TaskProgress)
	populate(objectMap, "taskStatus", j.TaskStatus)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesPVRestoreCriteria.
func (k KubernetesPVRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", k.Name)
	objectMap["objectType"] = "KubernetesPVRestoreCriteria"
	populate(objectMap, "storageClassName", k.StorageClassName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesPVRestoreCriteria.
func (k *KubernetesPVRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "storageClassName":
			err = unpopulate(val, "StorageClassName", &k.StorageClassName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesStorageClassRestoreCriteria.
func (k KubernetesStorageClassRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "KubernetesStorageClassRestoreCriteria"
	populate(objectMap, "provisioner", k.Provisioner)
	populate(objectMap, "selectedStorageClassName", k.SelectedStorageClassName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesStorageClassRestoreCriteria.
func (k *KubernetesStorageClassRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "provisioner":
			err = unpopulate(val, "Provisioner", &k.Provisioner)
			delete(rawMsg, key)
		case "selectedStorageClassName":
			err = unpopulate(val, "SelectedStorageClassName", &k.SelectedStorageClassName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationJobExtendedInfo.
func (o *OperationJobExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &o.JobID)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &o.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResource.
func (o *OperationResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			o.Properties, err = unmarshalOperationExtendedInfoClassification(val)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchResourceRequestInput.
func (p PatchResourceRequestInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PolicyParameters.
func (p PolicyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataStoreParametersList", p.DataStoreParametersList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyParameters.
func (p *PolicyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataStoreParametersList":
			p.DataStoreParametersList, err = unmarshalDataStoreParametersClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RangeBasedItemLevelRestoreCriteria.
func (r RangeBasedItemLevelRestoreCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "maxMatchingValue", r.MaxMatchingValue)
	populate(objectMap, "minMatchingValue", r.MinMatchingValue)
	objectMap["objectType"] = "RangeBasedItemLevelRestoreCriteria"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RangeBasedItemLevelRestoreCriteria.
func (r *RangeBasedItemLevelRestoreCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxMatchingValue":
			err = unpopulate(val, "MaxMatchingValue", &r.MaxMatchingValue)
			delete(rawMsg, key)
		case "minMatchingValue":
			err = unpopulate(val, "MinMatchingValue", &r.MinMatchingValue)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointDataStoreDetails.
func (r RecoveryPointDataStoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populateTimeRFC3339(objectMap, "expiryTime", r.ExpiryTime)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "metaData", r.MetaData)
	populateTimeRFC3339(objectMap, "rehydrationExpiryTime", r.RehydrationExpiryTime)
	populate(objectMap, "rehydrationStatus", r.RehydrationStatus)
	populate(objectMap, "state", r.State)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "visible", r.Visible)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointDataStoreDetails.
func (r *RecoveryPointDataStoreDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &r.ExpiryTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "metaData":
			err = unpopulate(val, "MetaData", &r.MetaData)
			delete(rawMsg, key)
		case "rehydrationExpiryTime":
			err = unpopulateTimeRFC3339(val, "RehydrationExpiryTime", &r.RehydrationExpiryTime)
			delete(rawMsg, key)
		case "rehydrationStatus":
			err = unpopulate(val, "RehydrationStatus", &r.RehydrationStatus)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &r.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "visible":
			err = unpopulate(val, "Visible", &r.Visible)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuard.
func (r ResourceGuard) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowAutoApprovals", r.AllowAutoApprovals)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "resourceGuardOperations", r.ResourceGuardOperations)
	populate(objectMap, "vaultCriticalOperationExclusionList", r.VaultCriticalOperationExclusionList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGuardResource.
func (r ResourceGuardResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", r.ETag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RestoreFilesTargetInfo.
func (r RestoreFilesTargetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "RestoreFilesTargetInfo"
	populate(objectMap, "recoveryOption", r.RecoveryOption)
	populate(objectMap, "restoreLocation", r.RestoreLocation)
	populate(objectMap, "targetDetails", r.TargetDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreFilesTargetInfo.
func (r *RestoreFilesTargetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		case "recoveryOption":
			err = unpopulate(val, "RecoveryOption", &r.RecoveryOption)
			delete(rawMsg, key)
		case "restoreLocation":
			err = unpopulate(val, "RestoreLocation", &r.RestoreLocation)
			delete(rawMsg, key)
		case "targetDetails":
			err = unpopulate(val, "TargetDetails", &r.TargetDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreJobRecoveryPointDetails.
func (r RestoreJobRecoveryPointDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recoveryPointID", r.RecoveryPointID)
	populateTimeRFC3339(objectMap, "recoveryPointTime", r.RecoveryPointTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreJobRecoveryPointDetails.
func (r *RestoreJobRecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryPointID":
			err = unpopulate(val, "RecoveryPointID", &r.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTime", &r.RecoveryPointTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreTargetInfo.
func (r RestoreTargetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datasourceAuthCredentials", r.DatasourceAuthCredentials)
	populate(objectMap, "datasourceInfo", r.DatasourceInfo)
	populate(objectMap, "datasourceSetInfo", r.DatasourceSetInfo)
	objectMap["objectType"] = "RestoreTargetInfo"
	populate(objectMap, "recoveryOption", r.RecoveryOption)
	populate(objectMap, "restoreLocation", r.RestoreLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreTargetInfo.
func (r *RestoreTargetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasourceAuthCredentials":
			r.DatasourceAuthCredentials, err = unmarshalAuthCredentialsClassification(val)
			delete(rawMsg, key)
		case "datasourceInfo":
			err = unpopulate(val, "DatasourceInfo", &r.DatasourceInfo)
			delete(rawMsg, key)
		case "datasourceSetInfo":
			err = unpopulate(val, "DatasourceSetInfo", &r.DatasourceSetInfo)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &r.ObjectType)
			delete(rawMsg, key)
		case "recoveryOption":
			err = unpopulate(val, "RecoveryOption", &r.RecoveryOption)
			delete(rawMsg, key)
		case "restoreLocation":
			err = unpopulate(val, "RestoreLocation", &r.RestoreLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleBasedBackupCriteria.
func (s ScheduleBasedBackupCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "absoluteCriteria", s.AbsoluteCriteria)
	populate(objectMap, "daysOfMonth", s.DaysOfMonth)
	populate(objectMap, "daysOfTheWeek", s.DaysOfTheWeek)
	populate(objectMap, "monthsOfYear", s.MonthsOfYear)
	objectMap["objectType"] = "ScheduleBasedBackupCriteria"
	aux := make([]*timeRFC3339, len(s.ScheduleTimes), len(s.ScheduleTimes))
	for i := 0; i < len(s.ScheduleTimes); i++ {
		aux[i] = (*timeRFC3339)(s.ScheduleTimes[i])
	}
	populate(objectMap, "scheduleTimes", aux)
	populate(objectMap, "weeksOfTheMonth", s.WeeksOfTheMonth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleBasedBackupCriteria.
func (s *ScheduleBasedBackupCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "absoluteCriteria":
			err = unpopulate(val, "AbsoluteCriteria", &s.AbsoluteCriteria)
			delete(rawMsg, key)
		case "daysOfMonth":
			err = unpopulate(val, "DaysOfMonth", &s.DaysOfMonth)
			delete(rawMsg, key)
		case "daysOfTheWeek":
			err = unpopulate(val, "DaysOfTheWeek", &s.DaysOfTheWeek)
			delete(rawMsg, key)
		case "monthsOfYear":
			err = unpopulate(val, "MonthsOfYear", &s.MonthsOfYear)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &s.ObjectType)
			delete(rawMsg, key)
		case "scheduleTimes":
			var aux []*timeRFC3339
			err = unpopulate(val, "ScheduleTimes", &aux)
			for _, au := range aux {
				s.ScheduleTimes = append(s.ScheduleTimes, (*time.Time)(au))
			}
			delete(rawMsg, key)
		case "weeksOfTheMonth":
			err = unpopulate(val, "WeeksOfTheMonth", &s.WeeksOfTheMonth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleBasedTriggerContext.
func (s ScheduleBasedTriggerContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "ScheduleBasedTriggerContext"
	populate(objectMap, "schedule", s.Schedule)
	populate(objectMap, "taggingCriteria", s.TaggingCriteria)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleBasedTriggerContext.
func (s *ScheduleBasedTriggerContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &s.ObjectType)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &s.Schedule)
			delete(rawMsg, key)
		case "taggingCriteria":
			err = unpopulate(val, "TaggingCriteria", &s.TaggingCriteria)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretStoreBasedAuthCredentials.
func (s SecretStoreBasedAuthCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["objectType"] = "SecretStoreBasedAuthCredentials"
	populate(objectMap, "secretStoreResource", s.SecretStoreResource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretStoreBasedAuthCredentials.
func (s *SecretStoreBasedAuthCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectType":
			err = unpopulate(val, "ObjectType", &s.ObjectType)
			delete(rawMsg, key)
		case "secretStoreResource":
			err = unpopulate(val, "SecretStoreResource", &s.SecretStoreResource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceLifeCycle.
func (s SourceLifeCycle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deleteAfter", s.DeleteAfter)
	populate(objectMap, "sourceDataStore", s.SourceDataStore)
	populate(objectMap, "targetDataStoreCopySettings", s.TargetDataStoreCopySettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceLifeCycle.
func (s *SourceLifeCycle) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteAfter":
			s.DeleteAfter, err = unmarshalDeleteOptionClassification(val)
			delete(rawMsg, key)
		case "sourceDataStore":
			err = unpopulate(val, "SourceDataStore", &s.SourceDataStore)
			delete(rawMsg, key)
		case "targetDataStoreCopySettings":
			err = unpopulate(val, "TargetDataStoreCopySettings", &s.TargetDataStoreCopySettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaggingCriteria.
func (t TaggingCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "criteria", t.Criteria)
	populate(objectMap, "isDefault", t.IsDefault)
	populate(objectMap, "tagInfo", t.TagInfo)
	populate(objectMap, "taggingPriority", t.TaggingPriority)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaggingCriteria.
func (t *TaggingCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "criteria":
			t.Criteria, err = unmarshalBackupCriteriaClassificationArray(val)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &t.IsDefault)
			delete(rawMsg, key)
		case "tagInfo":
			err = unpopulate(val, "TagInfo", &t.TagInfo)
			delete(rawMsg, key)
		case "taggingPriority":
			err = unpopulate(val, "TaggingPriority", &t.TaggingPriority)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetCopySetting.
func (t TargetCopySetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "copyAfter", t.CopyAfter)
	populate(objectMap, "dataStore", t.DataStore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetCopySetting.
func (t *TargetCopySetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyAfter":
			t.CopyAfter, err = unmarshalCopyOptionClassification(val)
			delete(rawMsg, key)
		case "dataStore":
			err = unpopulate(val, "DataStore", &t.DataStore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserFacingError.
func (u UserFacingError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", u.Code)
	populate(objectMap, "details", u.Details)
	populate(objectMap, "innerError", u.InnerError)
	populate(objectMap, "isRetryable", u.IsRetryable)
	populate(objectMap, "isUserError", u.IsUserError)
	populate(objectMap, "message", u.Message)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "recommendedAction", u.RecommendedAction)
	populate(objectMap, "target", u.Target)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ValidateRestoreRequestObject.
func (v ValidateRestoreRequestObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "restoreRequestObject", v.RestoreRequestObject)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateRestoreRequestObject.
func (v *ValidateRestoreRequestObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "restoreRequestObject":
			v.RestoreRequestObject, err = unmarshalAzureBackupRestoreRequestClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
