//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatalakeanalytics

import "time"

// Account - A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics
// account.
type Account struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties defined by Data Lake Analytics all properties are specific to each resource provider.
	Properties *AccountProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountBasic - A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics
// account.
type AccountBasic struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties defined by Data Lake Analytics all properties are specific to each resource provider.
	Properties *AccountPropertiesBasic `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountListResult - Data Lake Analytics account list information.
type AccountListResult struct {
	// READ-ONLY; The current number of data lake analytics accounts under this subscription.
	Count *int32 `json:"count,omitempty" azure:"ro"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*AccountBasic `json:"value,omitempty" azure:"ro"`
}

// AccountProperties - The account specific properties that are associated with an underlying Data Lake Analytics account.
// Returned only when retrieving a specific account.
type AccountProperties struct {
	// The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled,
	// this is not enforced.
	FirewallAllowAzureIPs *FirewallAllowAzureIPsState `json:"firewallAllowAzureIps,omitempty"`

	// The current state of the IP address firewall for this account.
	FirewallState *FirewallState `json:"firewallState,omitempty"`

	// The maximum supported degree of parallelism for this account.
	MaxDegreeOfParallelism *int32 `json:"maxDegreeOfParallelism,omitempty"`

	// The maximum supported degree of parallelism per job for this account.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`

	// The maximum supported jobs running under the account at the same time.
	MaxJobCount *int32 `json:"maxJobCount,omitempty"`

	// The commitment tier for the next month.
	NewTier *TierType `json:"newTier,omitempty"`

	// The list of Data Lake Store accounts associated with this account.
	PublicDataLakeStoreAccounts []*DataLakeStoreAccountInformation `json:"publicDataLakeStoreAccounts,omitempty"`

	// The number of days that job metadata is retained.
	QueryStoreRetention *int32 `json:"queryStoreRetention,omitempty"`

	// READ-ONLY; The unique identifier associated with this Data Lake Analytics account.
	AccountID *string `json:"accountId,omitempty" azure:"ro"`

	// READ-ONLY; The list of compute policies associated with this account.
	ComputePolicies []*ComputePolicy `json:"computePolicies,omitempty" azure:"ro"`

	// READ-ONLY; The account creation time.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The commitment tier in use for the current month.
	CurrentTier *TierType `json:"currentTier,omitempty" azure:"ro"`

	// READ-ONLY; The list of Data Lake Store accounts associated with this account.
	DataLakeStoreAccounts []*DataLakeStoreAccountInformation `json:"dataLakeStoreAccounts,omitempty" azure:"ro"`

	// READ-ONLY; The current state of the DebugDataAccessLevel for this account.
	DebugDataAccessLevel *DebugDataAccessLevel `json:"debugDataAccessLevel,omitempty" azure:"ro"`

	// READ-ONLY; The default Data Lake Store account associated with this account.
	DefaultDataLakeStoreAccount *string `json:"defaultDataLakeStoreAccount,omitempty" azure:"ro"`

	// READ-ONLY; The type of the default Data Lake Store account associated with this account.
	DefaultDataLakeStoreAccountType *string `json:"defaultDataLakeStoreAccountType,omitempty" azure:"ro"`

	// READ-ONLY; The full CName endpoint for this account.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`

	// READ-ONLY; The list of firewall rules associated with this account.
	FirewallRules []*FirewallRule `json:"firewallRules,omitempty" azure:"ro"`

	// READ-ONLY; The list of hiveMetastores associated with this account.
	HiveMetastores []*HiveMetastore `json:"hiveMetastores,omitempty" azure:"ro"`

	// READ-ONLY; The account last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; The maximum supported active jobs under the account at the same time.
	MaxActiveJobCountPerUser *int32 `json:"maxActiveJobCountPerUser,omitempty" azure:"ro"`

	// READ-ONLY; The maximum supported active jobs under the account at the same time.
	MaxJobRunningTimeInMin *int32 `json:"maxJobRunningTimeInMin,omitempty" azure:"ro"`

	// READ-ONLY; The maximum supported jobs queued under the account at the same time.
	MaxQueuedJobCountPerUser *int32 `json:"maxQueuedJobCountPerUser,omitempty" azure:"ro"`

	// READ-ONLY; The minimum supported priority per job for this account.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the Data Lake Analytics account.
	ProvisioningState *DataLakeAnalyticsAccountStatus `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The state of the Data Lake Analytics account.
	State *DataLakeAnalyticsAccountState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The list of Azure Blob Storage accounts associated with this account.
	StorageAccounts []*StorageAccountInformation `json:"storageAccounts,omitempty" azure:"ro"`

	// READ-ONLY; The system defined maximum supported degree of parallelism for this account, which restricts the maximum value
	// of parallelism the user can set for the account.
	SystemMaxDegreeOfParallelism *int32 `json:"systemMaxDegreeOfParallelism,omitempty" azure:"ro"`

	// READ-ONLY; The system defined maximum supported jobs running under the account at the same time, which restricts the maximum
	// number of running jobs the user can set for the account.
	SystemMaxJobCount *int32 `json:"systemMaxJobCount,omitempty" azure:"ro"`

	// READ-ONLY; The list of virtualNetwork rules associated with this account.
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty" azure:"ro"`
}

// AccountPropertiesBasic - The basic account specific properties that are associated with an underlying Data Lake Analytics
// account.
type AccountPropertiesBasic struct {
	// READ-ONLY; The unique identifier associated with this Data Lake Analytics account.
	AccountID *string `json:"accountId,omitempty" azure:"ro"`

	// READ-ONLY; The account creation time.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The full CName endpoint for this account.
	Endpoint *string `json:"endpoint,omitempty" azure:"ro"`

	// READ-ONLY; The account last modified time.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the Data Lake Analytics account.
	ProvisioningState *DataLakeAnalyticsAccountStatus `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The state of the Data Lake Analytics account.
	State *DataLakeAnalyticsAccountState `json:"state,omitempty" azure:"ro"`
}

// AccountsClientBeginCreateOptions contains the optional parameters for the AccountsClient.BeginCreate method.
type AccountsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginDeleteOptions contains the optional parameters for the AccountsClient.BeginDelete method.
type AccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginUpdateOptions contains the optional parameters for the AccountsClient.BeginUpdate method.
type AccountsClientBeginUpdateOptions struct {
	// Parameters supplied to the update Data Lake Analytics account operation.
	Parameters *UpdateDataLakeAnalyticsAccountParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientCheckNameAvailabilityOptions contains the optional parameters for the AccountsClient.CheckNameAvailability
// method.
type AccountsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.ListByResourceGroup method.
type AccountsClientListByResourceGroupOptions struct {
	// The Boolean value of true or false to request a count of the matching resources included with the resources in the response,
	// e.g. Categories?$count=true. Optional.
	Count *bool
	// OData filter. Optional.
	Filter *string
	// OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the
	// order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
	// Optional.
	Orderby *string
	// OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description.
	// Optional.
	Select *string
	// The number of items to skip over before returning elements. Optional.
	Skip *int32
	// The number of items to return. Optional.
	Top *int32
}

// AccountsClientListOptions contains the optional parameters for the AccountsClient.List method.
type AccountsClientListOptions struct {
	// The Boolean value of true or false to request a count of the matching resources included with the resources in the response,
	// e.g. Categories?$count=true. Optional.
	Count *bool
	// OData filter. Optional.
	Filter *string
	// OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the
	// order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
	// Optional.
	Orderby *string
	// OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description.
	// Optional.
	Select *string
	// The number of items to skip over before returning elements. Optional.
	Skip *int32
	// The number of items to return. Optional.
	Top *int32
}

// AddDataLakeStoreParameters - The parameters used to add a new Data Lake Store account.
type AddDataLakeStoreParameters struct {
	// The Data Lake Store account properties to use when adding a new Data Lake Store account.
	Properties *AddDataLakeStoreProperties `json:"properties,omitempty"`
}

// AddDataLakeStoreProperties - The Data Lake Store account properties to use when adding a new Data Lake Store account.
type AddDataLakeStoreProperties struct {
	// The optional suffix for the Data Lake Store account.
	Suffix *string `json:"suffix,omitempty"`
}

// AddDataLakeStoreWithAccountParameters - The parameters used to add a new Data Lake Store account while creating a new Data
// Lake Analytics account.
type AddDataLakeStoreWithAccountParameters struct {
	// REQUIRED; The unique name of the Data Lake Store account to add.
	Name *string `json:"name,omitempty"`

	// The Data Lake Store account properties to use when adding a new Data Lake Store account.
	Properties *AddDataLakeStoreProperties `json:"properties,omitempty"`
}

// AddStorageAccountParameters - The parameters used to add a new Azure Storage account.
type AddStorageAccountParameters struct {
	// REQUIRED; The Azure Storage account properties to use when adding a new Azure Storage account.
	Properties *AddStorageAccountProperties `json:"properties,omitempty"`
}

// AddStorageAccountProperties - The Azure Storage account properties to use when adding a new Azure Storage account.
type AddStorageAccountProperties struct {
	// REQUIRED; The access key associated with this Azure Storage account that will be used to connect to it.
	AccessKey *string `json:"accessKey,omitempty"`

	// The optional suffix for the storage account.
	Suffix *string `json:"suffix,omitempty"`
}

// AddStorageAccountWithAccountParameters - The parameters used to add a new Azure Storage account while creating a new Data
// Lake Analytics account.
type AddStorageAccountWithAccountParameters struct {
	// REQUIRED; The unique name of the Azure Storage account to add.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The Azure Storage account properties to use when adding a new Azure Storage account.
	Properties *AddStorageAccountProperties `json:"properties,omitempty"`
}

// CapabilityInformation - Subscription-level properties and limits for Data Lake Analytics.
type CapabilityInformation struct {
	// READ-ONLY; The current number of accounts under this subscription.
	AccountCount *int32 `json:"accountCount,omitempty" azure:"ro"`

	// READ-ONLY; The maximum supported number of accounts under this subscription.
	MaxAccountCount *int32 `json:"maxAccountCount,omitempty" azure:"ro"`

	// READ-ONLY; The Boolean value of true or false to indicate the maintenance state.
	MigrationState *bool `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; The subscription state.
	State *SubscriptionState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The subscription credentials that uniquely identifies the subscription.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// CheckNameAvailabilityParameters - Data Lake Analytics account name availability check parameters.
type CheckNameAvailabilityParameters struct {
	// REQUIRED; The Data Lake Analytics name to check availability for.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The resource type. Note: This should not be set by the user, as the constant value is Microsoft.DataLakeAnalytics/accounts
	Type *CheckNameAvailabilityParametersType `json:"type,omitempty"`
}

// ComputePoliciesClientCreateOrUpdateOptions contains the optional parameters for the ComputePoliciesClient.CreateOrUpdate
// method.
type ComputePoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ComputePoliciesClientDeleteOptions contains the optional parameters for the ComputePoliciesClient.Delete method.
type ComputePoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ComputePoliciesClientGetOptions contains the optional parameters for the ComputePoliciesClient.Get method.
type ComputePoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComputePoliciesClientListByAccountOptions contains the optional parameters for the ComputePoliciesClient.ListByAccount
// method.
type ComputePoliciesClientListByAccountOptions struct {
	// placeholder for future optional parameters
}

// ComputePoliciesClientUpdateOptions contains the optional parameters for the ComputePoliciesClient.Update method.
type ComputePoliciesClientUpdateOptions struct {
	// Parameters supplied to update the compute policy.
	Parameters *UpdateComputePolicyParameters
}

// ComputePolicy - Data Lake Analytics compute policy information.
type ComputePolicy struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The compute policy properties.
	Properties *ComputePolicyProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ComputePolicyListResult - The list of compute policies in the account.
type ComputePolicyListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*ComputePolicy `json:"value,omitempty" azure:"ro"`
}

// ComputePolicyProperties - The compute policy properties.
type ComputePolicyProperties struct {
	// READ-ONLY; The maximum degree of parallelism per job this user can use to submit jobs.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty" azure:"ro"`

	// READ-ONLY; The minimum priority per job this user can use to submit jobs.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty" azure:"ro"`

	// READ-ONLY; The AAD object identifier for the entity to create a policy for.
	ObjectID *string `json:"objectId,omitempty" azure:"ro"`

	// READ-ONLY; The type of AAD object the object identifier refers to.
	ObjectType *AADObjectType `json:"objectType,omitempty" azure:"ro"`
}

// CreateComputePolicyWithAccountParameters - The parameters used to create a new compute policy while creating a new Data
// Lake Analytics account.
type CreateComputePolicyWithAccountParameters struct {
	// REQUIRED; The unique name of the compute policy to create.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The compute policy properties to use when creating a new compute policy.
	Properties *CreateOrUpdateComputePolicyProperties `json:"properties,omitempty"`
}

// CreateDataLakeAnalyticsAccountParameters - The parameters to use for creating a Data Lake Analytics account.
type CreateDataLakeAnalyticsAccountParameters struct {
	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The Data Lake Analytics account properties to use for creating.
	Properties *CreateDataLakeAnalyticsAccountProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

type CreateDataLakeAnalyticsAccountProperties struct {
	// REQUIRED; The list of Data Lake Store accounts associated with this account.
	DataLakeStoreAccounts []*AddDataLakeStoreWithAccountParameters `json:"dataLakeStoreAccounts,omitempty"`

	// REQUIRED; The default Data Lake Store account associated with this account.
	DefaultDataLakeStoreAccount *string `json:"defaultDataLakeStoreAccount,omitempty"`

	// The list of compute policies associated with this account.
	ComputePolicies []*CreateComputePolicyWithAccountParameters `json:"computePolicies,omitempty"`

	// The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled,
	// this is not enforced.
	FirewallAllowAzureIPs *FirewallAllowAzureIPsState `json:"firewallAllowAzureIps,omitempty"`

	// The list of firewall rules associated with this account.
	FirewallRules []*CreateFirewallRuleWithAccountParameters `json:"firewallRules,omitempty"`

	// The current state of the IP address firewall for this account.
	FirewallState *FirewallState `json:"firewallState,omitempty"`

	// The maximum supported degree of parallelism for this account.
	MaxDegreeOfParallelism *int32 `json:"maxDegreeOfParallelism,omitempty"`

	// The maximum supported degree of parallelism per job for this account.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`

	// The maximum supported jobs running under the account at the same time.
	MaxJobCount *int32 `json:"maxJobCount,omitempty"`

	// The minimum supported priority per job for this account.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`

	// The commitment tier for the next month.
	NewTier *TierType `json:"newTier,omitempty"`

	// The number of days that job metadata is retained.
	QueryStoreRetention *int32 `json:"queryStoreRetention,omitempty"`

	// The list of Azure Blob Storage accounts associated with this account.
	StorageAccounts []*AddStorageAccountWithAccountParameters `json:"storageAccounts,omitempty"`
}

// CreateFirewallRuleWithAccountParameters - The parameters used to create a new firewall rule while creating a new Data Lake
// Analytics account.
type CreateFirewallRuleWithAccountParameters struct {
	// REQUIRED; The unique name of the firewall rule to create.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The firewall rule properties to use when creating a new firewall rule.
	Properties *CreateOrUpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// CreateOrUpdateComputePolicyParameters - The parameters used to create a new compute policy.
type CreateOrUpdateComputePolicyParameters struct {
	// REQUIRED; The compute policy properties to use when creating a new compute policy.
	Properties *CreateOrUpdateComputePolicyProperties `json:"properties,omitempty"`
}

// CreateOrUpdateComputePolicyProperties - The compute policy properties to use when creating a new compute policy.
type CreateOrUpdateComputePolicyProperties struct {
	// REQUIRED; The AAD object identifier for the entity to create a policy for.
	ObjectID *string `json:"objectId,omitempty"`

	// REQUIRED; The type of AAD object the object identifier refers to.
	ObjectType *AADObjectType `json:"objectType,omitempty"`

	// The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property,
	// or both must be passed.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`

	// The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property,
	// or both must be passed.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`
}

// CreateOrUpdateFirewallRuleParameters - The parameters used to create a new firewall rule.
type CreateOrUpdateFirewallRuleParameters struct {
	// REQUIRED; The firewall rule properties to use when creating a new firewall rule.
	Properties *CreateOrUpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// CreateOrUpdateFirewallRuleProperties - The firewall rule properties to use when creating a new firewall rule.
type CreateOrUpdateFirewallRuleProperties struct {
	// REQUIRED; The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same
	// protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`

	// REQUIRED; The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same
	// protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
}

// DataLakeStoreAccountInformation - Data Lake Store account information.
type DataLakeStoreAccountInformation struct {
	// The Data Lake Store account properties.
	Properties *DataLakeStoreAccountInformationProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataLakeStoreAccountInformationListResult - Data Lake Store account list information.
type DataLakeStoreAccountInformationListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*DataLakeStoreAccountInformation `json:"value,omitempty" azure:"ro"`
}

// DataLakeStoreAccountInformationProperties - The Data Lake Store account properties.
type DataLakeStoreAccountInformationProperties struct {
	// READ-ONLY; The optional suffix for the Data Lake Store account.
	Suffix *string `json:"suffix,omitempty" azure:"ro"`
}

// DataLakeStoreAccountsClientAddOptions contains the optional parameters for the DataLakeStoreAccountsClient.Add method.
type DataLakeStoreAccountsClientAddOptions struct {
	// The details of the Data Lake Store account.
	Parameters *AddDataLakeStoreParameters
}

// DataLakeStoreAccountsClientDeleteOptions contains the optional parameters for the DataLakeStoreAccountsClient.Delete method.
type DataLakeStoreAccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataLakeStoreAccountsClientGetOptions contains the optional parameters for the DataLakeStoreAccountsClient.Get method.
type DataLakeStoreAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataLakeStoreAccountsClientListByAccountOptions contains the optional parameters for the DataLakeStoreAccountsClient.ListByAccount
// method.
type DataLakeStoreAccountsClientListByAccountOptions struct {
	// The Boolean value of true or false to request a count of the matching resources included with the resources in the response,
	// e.g. Categories?$count=true. Optional.
	Count *bool
	// OData filter. Optional.
	Filter *string
	// OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the
	// order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
	// Optional.
	Orderby *string
	// OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description.
	// Optional.
	Select *string
	// The number of items to skip over before returning elements. Optional.
	Skip *int32
	// The number of items to return. Optional.
	Top *int32
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// FirewallRule - Data Lake Analytics firewall rule information.
type FirewallRule struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The firewall rule properties.
	Properties *FirewallRuleProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FirewallRuleListResult - Data Lake Analytics firewall rule list information.
type FirewallRuleListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*FirewallRule `json:"value,omitempty" azure:"ro"`
}

// FirewallRuleProperties - The firewall rule properties.
type FirewallRuleProperties struct {
	// READ-ONLY; The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same
	// protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the
	// same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty" azure:"ro"`
}

// FirewallRulesClientCreateOrUpdateOptions contains the optional parameters for the FirewallRulesClient.CreateOrUpdate method.
type FirewallRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientDeleteOptions contains the optional parameters for the FirewallRulesClient.Delete method.
type FirewallRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientGetOptions contains the optional parameters for the FirewallRulesClient.Get method.
type FirewallRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientListByAccountOptions contains the optional parameters for the FirewallRulesClient.ListByAccount method.
type FirewallRulesClientListByAccountOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientUpdateOptions contains the optional parameters for the FirewallRulesClient.Update method.
type FirewallRulesClientUpdateOptions struct {
	// Parameters supplied to update the firewall rule.
	Parameters *UpdateFirewallRuleParameters
}

type HiveMetastore struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The HiveMetastoreProperties rule properties.
	Properties *HiveMetastoreProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HiveMetastoreListResult - Data Lake Analytics HiveMetastore list information.
type HiveMetastoreListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*HiveMetastore `json:"value,omitempty" azure:"ro"`
}

// HiveMetastoreProperties - The HiveMetastore properties.
type HiveMetastoreProperties struct {
	// READ-ONLY; The databaseName for the Hive MetaStore
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The current state of the NestedResource
	NestedResourceProvisioningState *NestedResourceProvisioningState `json:"nestedResourceProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The password for the Hive MetaStore
	Password *string `json:"password,omitempty" azure:"ro"`

	// READ-ONLY; The runtimeVersion for the Hive MetaStore
	RuntimeVersion *string `json:"runtimeVersion,omitempty" azure:"ro"`

	// READ-ONLY; The serverUri for the Hive MetaStore
	ServerURI *string `json:"serverUri,omitempty" azure:"ro"`

	// READ-ONLY; The userName for the Hive MetaStore
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// LocationsClientGetCapabilityOptions contains the optional parameters for the LocationsClient.GetCapability method.
type LocationsClientGetCapabilityOptions struct {
	// placeholder for future optional parameters
}

// NameAvailabilityInformation - Data Lake Analytics account name availability result information.
type NameAvailabilityInformation struct {
	// READ-ONLY; The message describing why the Data Lake Analytics account name is not available, if nameAvailable is false.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The Boolean value of true or false to indicate whether the Data Lake Analytics account name is available or
	// not.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The reason why the Data Lake Analytics account name is not available, if nameAvailable is false.
	Reason *string `json:"reason,omitempty" azure:"ro"`
}

// Operation - An available operation for Data Lake Analytics.
type Operation struct {
	// READ-ONLY; The display information for the operation.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; The OperationMetaPropertyInfo for the operation.
	Properties *OperationMetaPropertyInfo `json:"properties,omitempty" azure:"ro"`
}

// OperationDisplay - The display information for a particular operation.
type OperationDisplay struct {
	// READ-ONLY; A friendly description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; A friendly name of the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider of the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the operation.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - The list of available operations for Data Lake Analytics.
type OperationListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

type OperationMetaLogSpecification struct {
	// The blobDuration for OperationMetaLogSpecification.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// The displayName for OperationMetaLogSpecification.
	DisplayName *string `json:"displayName,omitempty"`

	// The name for OperationMetaLogSpecification.
	Name *string `json:"name,omitempty"`
}

type OperationMetaMetricAvailabilitiesSpecification struct {
	// The blobDuration for OperationMetaMetricAvailabilitiesSpecification.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// The timegrain for OperationMetaMetricAvailabilitiesSpecification.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

type OperationMetaMetricSpecification struct {
	// The aggregationType for OperationMetaMetricSpecification.
	AggregationType *string `json:"aggregationType,omitempty"`

	// The availabilities for OperationMetaMetricSpecification.
	Availabilities []*OperationMetaMetricAvailabilitiesSpecification `json:"availabilities,omitempty"`

	// The displayName for OperationMetaMetricSpecification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// The displayName for OperationMetaMetricSpecification.
	DisplayName *string `json:"displayName,omitempty"`

	// The name for OperationMetaMetricSpecification.
	Name *string `json:"name,omitempty"`

	// The unit for OperationMetaMetricSpecification.
	Unit *string `json:"unit,omitempty"`
}

type OperationMetaPropertyInfo struct {
	// The operations OperationMetaServiceSpecification.
	ServiceSpecification *OperationMetaServiceSpecification `json:"serviceSpecification,omitempty"`
}

type OperationMetaServiceSpecification struct {
	// The logSpecifications for OperationMetaServiceSpecification.
	LogSpecifications []*OperationMetaLogSpecification `json:"logSpecifications,omitempty"`

	// The metricSpecifications for OperationMetaServiceSpecification.
	MetricSpecifications []*OperationMetaMetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Resource - The resource model definition.
type Resource struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SasTokenInformation - SAS token information.
type SasTokenInformation struct {
	// READ-ONLY; The access token for the associated Azure Storage Container.
	AccessToken *string `json:"accessToken,omitempty" azure:"ro"`
}

// SasTokenInformationListResult - The SAS response that contains the storage account, container and associated SAS token
// for connection use.
type SasTokenInformationListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*SasTokenInformation `json:"value,omitempty" azure:"ro"`
}

// StorageAccountInformation - Azure Storage account information.
type StorageAccountInformation struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Storage account properties.
	Properties *StorageAccountInformationProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageAccountInformationListResult - Azure Storage account list information.
type StorageAccountInformationListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*StorageAccountInformation `json:"value,omitempty" azure:"ro"`
}

// StorageAccountInformationProperties - The Azure Storage account properties.
type StorageAccountInformationProperties struct {
	// READ-ONLY; The optional suffix for the storage account.
	Suffix *string `json:"suffix,omitempty" azure:"ro"`
}

// StorageAccountsClientAddOptions contains the optional parameters for the StorageAccountsClient.Add method.
type StorageAccountsClientAddOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountsClientDeleteOptions contains the optional parameters for the StorageAccountsClient.Delete method.
type StorageAccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountsClientGetOptions contains the optional parameters for the StorageAccountsClient.Get method.
type StorageAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountsClientGetStorageContainerOptions contains the optional parameters for the StorageAccountsClient.GetStorageContainer
// method.
type StorageAccountsClientGetStorageContainerOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountsClientListByAccountOptions contains the optional parameters for the StorageAccountsClient.ListByAccount
// method.
type StorageAccountsClientListByAccountOptions struct {
	// The Boolean value of true or false to request a count of the matching resources included with the resources in the response,
	// e.g. Categories?$count=true. Optional.
	Count *bool
	// The OData filter. Optional.
	Filter *string
	// OrderBy clause. One or more comma-separated expressions with an optional "asc" (the default) or "desc" depending on the
	// order you'd like the values sorted, e.g. Categories?$orderby=CategoryName desc.
	// Optional.
	Orderby *string
	// OData Select statement. Limits the properties on each entry to just those requested, e.g. Categories?$select=CategoryName,Description.
	// Optional.
	Select *string
	// The number of items to skip over before returning elements. Optional.
	Skip *int32
	// The number of items to return. Optional.
	Top *int32
}

// StorageAccountsClientListSasTokensOptions contains the optional parameters for the StorageAccountsClient.ListSasTokens
// method.
type StorageAccountsClientListSasTokensOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountsClientListStorageContainersOptions contains the optional parameters for the StorageAccountsClient.ListStorageContainers
// method.
type StorageAccountsClientListStorageContainersOptions struct {
	// placeholder for future optional parameters
}

// StorageAccountsClientUpdateOptions contains the optional parameters for the StorageAccountsClient.Update method.
type StorageAccountsClientUpdateOptions struct {
	// The parameters containing the access key and suffix to update the storage account with, if any. Passing nothing results
	// in no change.
	Parameters *UpdateStorageAccountParameters
}

// StorageContainer - Azure Storage blob container information.
type StorageContainer struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties of the blob container.
	Properties *StorageContainerProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageContainerListResult - The list of blob containers associated with the storage account attached to the Data Lake
// Analytics account.
type StorageContainerListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*StorageContainer `json:"value,omitempty" azure:"ro"`
}

// StorageContainerProperties - Azure Storage blob container properties information.
type StorageContainerProperties struct {
	// READ-ONLY; The last modified time of the blob container.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// SubResource - The resource model definition for a nested resource.
type SubResource struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateComputePolicyParameters - The parameters used to update a compute policy.
type UpdateComputePolicyParameters struct {
	// The compute policy properties to use when updating a compute policy.
	Properties *UpdateComputePolicyProperties `json:"properties,omitempty"`
}

// UpdateComputePolicyProperties - The compute policy properties to use when updating a compute policy.
type UpdateComputePolicyProperties struct {
	// The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property,
	// or both must be passed.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`

	// The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property,
	// or both must be passed.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`

	// The AAD object identifier for the entity to create a policy for.
	ObjectID *string `json:"objectId,omitempty"`

	// The type of AAD object the object identifier refers to.
	ObjectType *AADObjectType `json:"objectType,omitempty"`
}

// UpdateComputePolicyWithAccountParameters - The parameters used to update a compute policy while updating a Data Lake Analytics
// account.
type UpdateComputePolicyWithAccountParameters struct {
	// REQUIRED; The unique name of the compute policy to update.
	Name *string `json:"name,omitempty"`

	// The compute policy properties to use when updating a compute policy.
	Properties *UpdateComputePolicyProperties `json:"properties,omitempty"`
}

// UpdateDataLakeAnalyticsAccountParameters - The parameters that can be used to update an existing Data Lake Analytics account.
type UpdateDataLakeAnalyticsAccountParameters struct {
	// The properties that can be updated in an existing Data Lake Analytics account.
	Properties *UpdateDataLakeAnalyticsAccountProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// UpdateDataLakeAnalyticsAccountProperties - The properties to update that are associated with an underlying Data Lake Analytics
// account.
type UpdateDataLakeAnalyticsAccountProperties struct {
	// The list of compute policies associated with this account.
	ComputePolicies []*UpdateComputePolicyWithAccountParameters `json:"computePolicies,omitempty"`

	// The list of Data Lake Store accounts associated with this account.
	DataLakeStoreAccounts []*UpdateDataLakeStoreWithAccountParameters `json:"dataLakeStoreAccounts,omitempty"`

	// The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled,
	// this is not enforced.
	FirewallAllowAzureIPs *FirewallAllowAzureIPsState `json:"firewallAllowAzureIps,omitempty"`

	// The list of firewall rules associated with this account.
	FirewallRules []*UpdateFirewallRuleWithAccountParameters `json:"firewallRules,omitempty"`

	// The current state of the IP address firewall for this account. Disabling the firewall does not remove existing rules, they
	// will just be ignored until the firewall is re-enabled.
	FirewallState *FirewallState `json:"firewallState,omitempty"`

	// The maximum supported degree of parallelism for this account.
	MaxDegreeOfParallelism *int32 `json:"maxDegreeOfParallelism,omitempty"`

	// The maximum supported degree of parallelism per job for this account.
	MaxDegreeOfParallelismPerJob *int32 `json:"maxDegreeOfParallelismPerJob,omitempty"`

	// The maximum supported jobs running under the account at the same time.
	MaxJobCount *int32 `json:"maxJobCount,omitempty"`

	// The minimum supported priority per job for this account.
	MinPriorityPerJob *int32 `json:"minPriorityPerJob,omitempty"`

	// The commitment tier to use for next month.
	NewTier *TierType `json:"newTier,omitempty"`

	// The number of days that job metadata is retained.
	QueryStoreRetention *int32 `json:"queryStoreRetention,omitempty"`

	// The list of Azure Blob storage accounts associated with this account.
	StorageAccounts []*UpdateStorageAccountWithAccountParameters `json:"storageAccounts,omitempty"`
}

// UpdateDataLakeStoreProperties - The Data Lake Store account properties to use when updating a Data Lake Store account.
type UpdateDataLakeStoreProperties struct {
	// The optional suffix for the Data Lake Store account.
	Suffix *string `json:"suffix,omitempty"`
}

// UpdateDataLakeStoreWithAccountParameters - The parameters used to update a Data Lake Store account while updating a Data
// Lake Analytics account.
type UpdateDataLakeStoreWithAccountParameters struct {
	// REQUIRED; The unique name of the Data Lake Store account to update.
	Name *string `json:"name,omitempty"`

	// The Data Lake Store account properties to use when updating a Data Lake Store account.
	Properties *UpdateDataLakeStoreProperties `json:"properties,omitempty"`
}

// UpdateFirewallRuleParameters - The parameters used to update a firewall rule.
type UpdateFirewallRuleParameters struct {
	// The firewall rule properties to use when updating a firewall rule.
	Properties *UpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// UpdateFirewallRuleProperties - The firewall rule properties to use when updating a firewall rule.
type UpdateFirewallRuleProperties struct {
	// The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`

	// The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
}

// UpdateFirewallRuleWithAccountParameters - The parameters used to update a firewall rule while updating a Data Lake Analytics
// account.
type UpdateFirewallRuleWithAccountParameters struct {
	// REQUIRED; The unique name of the firewall rule to update.
	Name *string `json:"name,omitempty"`

	// The firewall rule properties to use when updating a firewall rule.
	Properties *UpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// UpdateStorageAccountParameters - The parameters used to update an Azure Storage account.
type UpdateStorageAccountParameters struct {
	// The Azure Storage account properties to use when updating an Azure Storage account.
	Properties *UpdateStorageAccountProperties `json:"properties,omitempty"`
}

// UpdateStorageAccountProperties - The Azure Storage account properties to use when updating an Azure Storage account.
type UpdateStorageAccountProperties struct {
	// The updated access key associated with this Azure Storage account that will be used to connect to it.
	AccessKey *string `json:"accessKey,omitempty"`

	// The optional suffix for the storage account.
	Suffix *string `json:"suffix,omitempty"`
}

// UpdateStorageAccountWithAccountParameters - The parameters used to update an Azure Storage account while updating a Data
// Lake Analytics account.
type UpdateStorageAccountWithAccountParameters struct {
	// REQUIRED; The unique name of the Azure Storage account to update.
	Name *string `json:"name,omitempty"`

	// The Azure Storage account properties to use when updating an Azure Storage account.
	Properties *UpdateStorageAccountProperties `json:"properties,omitempty"`
}

// VirtualNetworkRule - Data Lake Analytics VirtualNetwork Rule information.
type VirtualNetworkRule struct {
	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The VirtualNetwork rule properties.
	Properties *VirtualNetworkRuleProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkRuleListResult - Data Lake Analytics VirtualNetwork rule list information.
type VirtualNetworkRuleListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The results of the list operation.
	Value []*VirtualNetworkRule `json:"value,omitempty" azure:"ro"`
}

// VirtualNetworkRuleProperties - The VirtualNetwork Rule properties.
type VirtualNetworkRuleProperties struct {
	// READ-ONLY; The resource identifier for the subnet
	SubnetID *string `json:"subnetId,omitempty" azure:"ro"`

	// READ-ONLY; The current state of the VirtualNetwork Rule
	VirtualNetworkRuleState *VirtualNetworkRuleState `json:"virtualNetworkRuleState,omitempty" azure:"ro"`
}
