//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatadog

import "time"

type APIKey struct {
	// REQUIRED; The value of the API key.
	Key *string `json:"key,omitempty"`

	// The time of creation of the API key.
	Created *string `json:"created,omitempty"`

	// The user that created the API key.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The name of the API key.
	Name *string `json:"name,omitempty"`
}

// APIKeyListResponse - Response of a list operation.
type APIKeyListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*APIKey `json:"value,omitempty"`
}

// AgreementProperties - Terms properties.
type AgreementProperties struct {
	// If any version of the terms have been accepted, otherwise false.
	Accepted *bool `json:"accepted,omitempty"`

	// Link to HTML with Microsoft and Publisher terms.
	LicenseTextLink *string `json:"licenseTextLink,omitempty"`

	// Plan identifier string.
	Plan *string `json:"plan,omitempty"`

	// Link to the privacy policy of the publisher.
	PrivacyPolicyLink *string `json:"privacyPolicyLink,omitempty"`

	// Product identifier string.
	Product *string `json:"product,omitempty"`

	// Publisher identifier string.
	Publisher *string `json:"publisher,omitempty"`

	// Date and time in UTC of when the terms were accepted. This is empty if Accepted is false.
	RetrieveDatetime *time.Time `json:"retrieveDatetime,omitempty"`

	// Terms signature.
	Signature *string `json:"signature,omitempty"`
}

type AgreementResource struct {
	// Represents the properties of the resource.
	Properties *AgreementProperties `json:"properties,omitempty"`

	// READ-ONLY; ARM id of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the agreement.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgreementResourceListResponse - Response of a list operation.
type AgreementResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*AgreementResource `json:"value,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// FilteringTag - The definition of a filtering tag. Filtering tags are used for capturing resources and include/exclude them
// from being monitored.
type FilteringTag struct {
	// Valid actions for a filtering tag. Exclusion takes priority over inclusion.
	Action *TagAction `json:"action,omitempty"`

	// The name (also known as the key) of the tag.
	Name *string `json:"name,omitempty"`

	// The value of the tag.
	Value *string `json:"value,omitempty"`
}

type Host struct {
	// The aliases for the host.
	Aliases []*string `json:"aliases,omitempty"`

	// The Datadog integrations reporting metrics for the host.
	Apps []*string     `json:"apps,omitempty"`
	Meta *HostMetadata `json:"meta,omitempty"`

	// The name of the host.
	Name *string `json:"name,omitempty"`
}

// HostListResponse - Response of a list operation.
type HostListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*Host `json:"value,omitempty"`
}

type HostMetadata struct {
	// The agent version.
	AgentVersion  *string        `json:"agentVersion,omitempty"`
	InstallMethod *InstallMethod `json:"installMethod,omitempty"`
	LogsAgent     *LogsAgent     `json:"logsAgent,omitempty"`
}

type IdentityProperties struct {
	// Identity type
	Type *ManagedIdentityTypes `json:"type,omitempty"`

	// READ-ONLY; The identity ID.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

type InstallMethod struct {
	// The installer version.
	InstallerVersion *string `json:"installerVersion,omitempty"`

	// The tool.
	Tool *string `json:"tool,omitempty"`

	// The tool version.
	ToolVersion *string `json:"toolVersion,omitempty"`
}

// LinkedResource - The definition of a linked resource.
type LinkedResource struct {
	// The ARM id of the linked resource.
	ID *string `json:"id,omitempty"`
}

// LinkedResourceListResponse - Response of a list operation.
type LinkedResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*LinkedResource `json:"value,omitempty"`
}

// LogRules - Set of rules for sending logs for the Monitor resource.
type LogRules struct {
	// List of filtering tags to be used for capturing logs. This only takes effect if SendResourceLogs flag is enabled. If empty,
	// all resources will be captured. If only Exclude action is specified, the
	// rules will apply to the list of all available resources. If Include actions are specified, the rules will only include
	// resources with the associated tags.
	FilteringTags []*FilteringTag `json:"filteringTags,omitempty"`

	// Flag specifying if AAD logs should be sent for the Monitor resource.
	SendAADLogs *bool `json:"sendAadLogs,omitempty"`

	// Flag specifying if Azure resource logs should be sent for the Monitor resource.
	SendResourceLogs *bool `json:"sendResourceLogs,omitempty"`

	// Flag specifying if Azure subscription logs should be sent for the Monitor resource.
	SendSubscriptionLogs *bool `json:"sendSubscriptionLogs,omitempty"`
}

type LogsAgent struct {
	// The transport.
	Transport *string `json:"transport,omitempty"`
}

// MarketplaceAgreementsClientCreateOrUpdateOptions contains the optional parameters for the MarketplaceAgreementsClient.CreateOrUpdate
// method.
type MarketplaceAgreementsClientCreateOrUpdateOptions struct {
	Body *AgreementResource
}

// MarketplaceAgreementsClientListOptions contains the optional parameters for the MarketplaceAgreementsClient.List method.
type MarketplaceAgreementsClientListOptions struct {
	// placeholder for future optional parameters
}

// MetricRules - Set of rules for sending metrics for the Monitor resource.
type MetricRules struct {
	// List of filtering tags to be used for capturing metrics. If empty, all resources will be captured. If only Exclude action
	// is specified, the rules will apply to the list of all available resources. If
	// Include actions are specified, the rules will only include resources with the associated tags.
	FilteringTags []*FilteringTag `json:"filteringTags,omitempty"`
}

// MonitorProperties - Properties specific to the monitor resource.
type MonitorProperties struct {
	// Datadog organization properties
	DatadogOrganizationProperties *OrganizationProperties `json:"datadogOrganizationProperties,omitempty"`

	// Flag specifying if the resource monitoring is enabled or disabled.
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`

	// User info
	UserInfo *UserInfo `json:"userInfo,omitempty"`

	// READ-ONLY
	LiftrResourceCategory *LiftrResourceCategories `json:"liftrResourceCategory,omitempty" azure:"ro"`

	// READ-ONLY; The priority of the resource.
	LiftrResourcePreference *int32 `json:"liftrResourcePreference,omitempty" azure:"ro"`

	// READ-ONLY; Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource
	// will go in Suspended state.
	MarketplaceSubscriptionStatus *MarketplaceSubscriptionStatus `json:"marketplaceSubscriptionStatus,omitempty" azure:"ro"`

	// READ-ONLY
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

type MonitorResource struct {
	// REQUIRED
	Location *string             `json:"location,omitempty"`
	Identity *IdentityProperties `json:"identity,omitempty"`

	// Properties specific to the monitor resource.
	Properties *MonitorProperties `json:"properties,omitempty"`
	SKU        *ResourceSKU       `json:"sku,omitempty"`

	// Dictionary of
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; ARM id of the monitor resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the monitor resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the monitor resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MonitorResourceListResponse - Response of a list operation.
type MonitorResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*MonitorResource `json:"value,omitempty"`
}

// MonitorResourceUpdateParameters - The parameters for a PATCH request to a monitor resource.
type MonitorResourceUpdateParameters struct {
	// The set of properties that can be update in a PATCH request to a monitor resource.
	Properties *MonitorUpdateProperties `json:"properties,omitempty"`
	SKU        *ResourceSKU             `json:"sku,omitempty"`

	// The new tags of the monitor resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MonitorUpdateProperties - The set of properties that can be update in a PATCH request to a monitor resource.
type MonitorUpdateProperties struct {
	// Flag specifying if the resource monitoring is enabled or disabled.
	MonitoringStatus *MonitoringStatus `json:"monitoringStatus,omitempty"`
}

// MonitoredResource - The properties of a resource currently being monitored by the Datadog monitor resource.
type MonitoredResource struct {
	// The ARM id of the resource.
	ID *string `json:"id,omitempty"`

	// Reason for why the resource is sending logs (or why it is not sending).
	ReasonForLogsStatus *string `json:"reasonForLogsStatus,omitempty"`

	// Reason for why the resource is sending metrics (or why it is not sending).
	ReasonForMetricsStatus *string `json:"reasonForMetricsStatus,omitempty"`

	// Flag indicating if resource is sending logs to Datadog.
	SendingLogs *bool `json:"sendingLogs,omitempty"`

	// Flag indicating if resource is sending metrics to Datadog.
	SendingMetrics *bool `json:"sendingMetrics,omitempty"`
}

// MonitoredResourceListResponse - Response of a list operation.
type MonitoredResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*MonitoredResource `json:"value,omitempty"`
}

// MonitoringTagRules - Capture logs and metrics of Azure resources based on ARM tags.
type MonitoringTagRules struct {
	// Definition of the properties for a TagRules resource.
	Properties *MonitoringTagRulesProperties `json:"properties,omitempty"`

	// READ-ONLY; The id of the rule set.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the rule set.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the rule set.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MonitoringTagRulesListResponse - Response of a list operation.
type MonitoringTagRulesListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*MonitoringTagRules `json:"value,omitempty"`
}

// MonitoringTagRulesProperties - Definition of the properties for a TagRules resource.
type MonitoringTagRulesProperties struct {
	// Set of rules for sending logs for the Monitor resource.
	LogRules *LogRules `json:"logRules,omitempty"`

	// Set of rules for sending metrics for the Monitor resource.
	MetricRules *MetricRules `json:"metricRules,omitempty"`

	// READ-ONLY
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// MonitorsClientBeginCreateOptions contains the optional parameters for the MonitorsClient.BeginCreate method.
type MonitorsClientBeginCreateOptions struct {
	Body *MonitorResource
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitorsClientBeginDeleteOptions contains the optional parameters for the MonitorsClient.BeginDelete method.
type MonitorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitorsClientBeginUpdateOptions contains the optional parameters for the MonitorsClient.BeginUpdate method.
type MonitorsClientBeginUpdateOptions struct {
	Body *MonitorResourceUpdateParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MonitorsClientGetDefaultKeyOptions contains the optional parameters for the MonitorsClient.GetDefaultKey method.
type MonitorsClientGetDefaultKeyOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientGetOptions contains the optional parameters for the MonitorsClient.Get method.
type MonitorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListAPIKeysOptions contains the optional parameters for the MonitorsClient.ListAPIKeys method.
type MonitorsClientListAPIKeysOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListByResourceGroupOptions contains the optional parameters for the MonitorsClient.ListByResourceGroup method.
type MonitorsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListHostsOptions contains the optional parameters for the MonitorsClient.ListHosts method.
type MonitorsClientListHostsOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListLinkedResourcesOptions contains the optional parameters for the MonitorsClient.ListLinkedResources method.
type MonitorsClientListLinkedResourcesOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListMonitoredResourcesOptions contains the optional parameters for the MonitorsClient.ListMonitoredResources
// method.
type MonitorsClientListMonitoredResourcesOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientListOptions contains the optional parameters for the MonitorsClient.List method.
type MonitorsClientListOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientRefreshSetPasswordLinkOptions contains the optional parameters for the MonitorsClient.RefreshSetPasswordLink
// method.
type MonitorsClientRefreshSetPasswordLinkOptions struct {
	// placeholder for future optional parameters
}

// MonitorsClientSetDefaultKeyOptions contains the optional parameters for the MonitorsClient.SetDefaultKey method.
type MonitorsClientSetDefaultKeyOptions struct {
	Body *APIKey
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation, e.g., 'Write monitors'.
	Description *string `json:"description,omitempty"`

	// Operation type, e.g., read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider, i.e., Microsoft.Datadog.
	Provider *string `json:"provider,omitempty"`

	// Type on which the operation is performed, e.g., 'monitors'.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of GET request to list the Microsoft.Datadog operations.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the Microsoft.Datadog provider.
	Value []*OperationResult `json:"value,omitempty"`
}

// OperationResult - A Microsoft.Datadog REST API operation.
type OperationResult struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name, i.e., {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OrganizationProperties - Datadog organization properties
type OrganizationProperties struct {
	// Api key associated to the Datadog organization.
	APIKey *string `json:"apiKey,omitempty"`

	// Application key associated to the Datadog organization.
	ApplicationKey *string `json:"applicationKey,omitempty"`

	// The Id of the Enterprise App used for Single sign on.
	EnterpriseAppID *string `json:"enterpriseAppId,omitempty"`

	// The auth code used to linking to an existing datadog organization.
	LinkingAuthCode *string `json:"linkingAuthCode,omitempty"`

	// The client_id from an existing in exchange for an auth token to link organization.
	LinkingClientID *string `json:"linkingClientId,omitempty"`

	// The redirect uri for linking.
	RedirectURI *string `json:"redirectUri,omitempty"`

	// READ-ONLY; Id of the Datadog organization.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the Datadog organization.
	Name *string `json:"name,omitempty" azure:"ro"`
}

type ResourceSKU struct {
	// REQUIRED; Name of the SKU.
	Name *string `json:"name,omitempty"`
}

type SetPasswordLink struct {
	SetPasswordLink *string `json:"setPasswordLink,omitempty"`
}

// SingleSignOnConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the SingleSignOnConfigurationsClient.BeginCreateOrUpdate
// method.
type SingleSignOnConfigurationsClientBeginCreateOrUpdateOptions struct {
	Body *SingleSignOnResource
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SingleSignOnConfigurationsClientGetOptions contains the optional parameters for the SingleSignOnConfigurationsClient.Get
// method.
type SingleSignOnConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SingleSignOnConfigurationsClientListOptions contains the optional parameters for the SingleSignOnConfigurationsClient.List
// method.
type SingleSignOnConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

type SingleSignOnProperties struct {
	// The Id of the Enterprise App used for Single sign-on.
	EnterpriseAppID *string `json:"enterpriseAppId,omitempty"`

	// Various states of the SSO resource
	SingleSignOnState *SingleSignOnStates `json:"singleSignOnState,omitempty"`

	// READ-ONLY
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The login URL specific to this Datadog Organization.
	SingleSignOnURL *string `json:"singleSignOnUrl,omitempty" azure:"ro"`
}

type SingleSignOnResource struct {
	Properties *SingleSignOnProperties `json:"properties,omitempty"`

	// READ-ONLY; ARM id of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the configuration.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SingleSignOnResourceListResponse - Response of a list operation.
type SingleSignOnResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of a list operation.
	Value []*SingleSignOnResource `json:"value,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagRulesClientCreateOrUpdateOptions contains the optional parameters for the TagRulesClient.CreateOrUpdate method.
type TagRulesClientCreateOrUpdateOptions struct {
	Body *MonitoringTagRules
}

// TagRulesClientGetOptions contains the optional parameters for the TagRulesClient.Get method.
type TagRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// TagRulesClientListOptions contains the optional parameters for the TagRulesClient.List method.
type TagRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// UserInfo - User info
type UserInfo struct {
	// Email of the user used by Datadog for contacting them if needed
	EmailAddress *string `json:"emailAddress,omitempty"`

	// Name of the user
	Name *string `json:"name,omitempty"`

	// Phone number of the user used by Datadog for contacting them if needed
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}
