//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armconsumption

import "time"

// AggregatedCostClientGetByManagementGroupOptions contains the optional parameters for the AggregatedCostClient.GetByManagementGroup
// method.
type AggregatedCostClientGetByManagementGroupOptions struct {
	// May be used to filter aggregated cost by properties/usageStart (Utc time), properties/usageEnd (Utc time). The filter supports
	// 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently support
	// 'ne', 'or', or 'not'. Tag filter is a key value pair string where key and value is separated by a colon (:).
	Filter *string
}

// AggregatedCostClientGetForBillingPeriodByManagementGroupOptions contains the optional parameters for the AggregatedCostClient.GetForBillingPeriodByManagementGroup
// method.
type AggregatedCostClientGetForBillingPeriodByManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// Amount - The amount plus currency .
type Amount struct {
	// READ-ONLY; Amount currency.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; Amount.
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

// AmountWithExchangeRate - The amount with exchange rate.
type AmountWithExchangeRate struct {
	// READ-ONLY; Amount currency.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; The exchange rate.
	ExchangeRate *float64 `json:"exchangeRate,omitempty" azure:"ro"`

	// READ-ONLY; The exchange rate month.
	ExchangeRateMonth *int32 `json:"exchangeRateMonth,omitempty" azure:"ro"`

	// READ-ONLY; Amount.
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

// Balance - A balance resource.
type Balance struct {
	// The properties of the balance.
	Properties *BalanceProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BalanceProperties - The properties of the balance.
type BalanceProperties struct {
	// The billing frequency.
	BillingFrequency *BillingFrequency `json:"billingFrequency,omitempty"`

	// READ-ONLY; List of Adjustments (Promo credit, SIE credit etc.).
	AdjustmentDetails []*BalancePropertiesAdjustmentDetailsItem `json:"adjustmentDetails,omitempty" azure:"ro"`

	// READ-ONLY; Total adjustment amount.
	Adjustments *float64 `json:"adjustments,omitempty" azure:"ro"`

	// READ-ONLY; Total charges for Azure Marketplace.
	AzureMarketplaceServiceCharges *float64 `json:"azureMarketplaceServiceCharges,omitempty" azure:"ro"`

	// READ-ONLY; The beginning balance for the billing period.
	BeginningBalance *float64 `json:"beginningBalance,omitempty" azure:"ro"`

	// READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *float64 `json:"chargesBilledSeparately,omitempty" azure:"ro"`

	// READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; The ending balance for the billing period (for open periods this will be updated daily).
	EndingBalance *float64 `json:"endingBalance,omitempty" azure:"ro"`

	// READ-ONLY; Total new purchase amount.
	NewPurchases *float64 `json:"newPurchases,omitempty" azure:"ro"`

	// READ-ONLY; List of new purchases.
	NewPurchasesDetails []*BalancePropertiesNewPurchasesDetailsItem `json:"newPurchasesDetails,omitempty" azure:"ro"`

	// READ-ONLY; Price is hidden or not.
	PriceHidden *bool `json:"priceHidden,omitempty" azure:"ro"`

	// READ-ONLY; Overage for Azure services.
	ServiceOverage *float64 `json:"serviceOverage,omitempty" azure:"ro"`

	// READ-ONLY; serviceOverage + chargesBilledSeparately.
	TotalOverage *float64 `json:"totalOverage,omitempty" azure:"ro"`

	// READ-ONLY; Azure service commitment + total Overage.
	TotalUsage *float64 `json:"totalUsage,omitempty" azure:"ro"`

	// READ-ONLY; Total Commitment usage.
	Utilized *float64 `json:"utilized,omitempty" azure:"ro"`
}

type BalancePropertiesAdjustmentDetailsItem struct {
	// READ-ONLY; the name of new adjustment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; the value of new adjustment.
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

type BalancePropertiesNewPurchasesDetailsItem struct {
	// READ-ONLY; the name of new purchase.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; the value of new purchase.
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

// BalancesClientGetByBillingAccountOptions contains the optional parameters for the BalancesClient.GetByBillingAccount method.
type BalancesClientGetByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// BalancesClientGetForBillingPeriodByBillingAccountOptions contains the optional parameters for the BalancesClient.GetForBillingPeriodByBillingAccount
// method.
type BalancesClientGetForBillingPeriodByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// Budget - A budget resource.
type Budget struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// The properties of the budget.
	Properties *BudgetProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BudgetComparisonExpression - The comparison expression to be used in the budgets.
type BudgetComparisonExpression struct {
	// REQUIRED; The name of the column to use in comparison.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The operator to use for comparison.
	Operator *BudgetOperatorType `json:"operator,omitempty"`

	// REQUIRED; Array of values to use for comparison
	Values []*string `json:"values,omitempty"`
}

// BudgetFilter - May be used to filter budgets by resource group, resource, or meter.
type BudgetFilter struct {
	// The logical "AND" expression. Must have at least 2 items.
	And []*BudgetFilterProperties `json:"and,omitempty"`

	// Has comparison expression for a dimension
	Dimensions *BudgetComparisonExpression `json:"dimensions,omitempty"`

	// Has comparison expression for a tag
	Tags *BudgetComparisonExpression `json:"tags,omitempty"`
}

// BudgetFilterProperties - The Dimensions or Tags to filter a budget by.
type BudgetFilterProperties struct {
	// Has comparison expression for a dimension
	Dimensions *BudgetComparisonExpression `json:"dimensions,omitempty"`

	// Has comparison expression for a tag
	Tags *BudgetComparisonExpression `json:"tags,omitempty"`
}

// BudgetProperties - The properties of the budget.
type BudgetProperties struct {
	// REQUIRED; The total amount of cost to track with the budget
	Amount *float64 `json:"amount,omitempty"`

	// REQUIRED; The category of the budget, whether the budget tracks cost or usage.
	Category *CategoryType `json:"category,omitempty"`

	// REQUIRED; The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter,
	// and BillingAnnual are only supported by WD customers
	TimeGrain *TimeGrainType `json:"timeGrain,omitempty"`

	// REQUIRED; Has start and end date of the budget. The start date must be first of the month and should be less than the end
	// date. Budget start date must be on or after June 1, 2017. Future start date should not
	// be more than twelve months. Past start date should be selected within the timegrain period. There are no restrictions on
	// the end date.
	TimePeriod *BudgetTimePeriod `json:"timePeriod,omitempty"`

	// May be used to filter budgets by user-specified dimensions and/or tags.
	Filter *BudgetFilter `json:"filter,omitempty"`

	// Dictionary of notifications associated with the budget. Budget can have up to five notifications.
	Notifications map[string]*Notification `json:"notifications,omitempty"`

	// READ-ONLY; The current amount of cost which is being tracked for a budget.
	CurrentSpend *CurrentSpend `json:"currentSpend,omitempty" azure:"ro"`

	// READ-ONLY; The forecasted cost which is being tracked for a budget.
	ForecastSpend *ForecastSpend `json:"forecastSpend,omitempty" azure:"ro"`
}

// BudgetTimePeriod - The start and end date for a budget.
type BudgetTimePeriod struct {
	// REQUIRED; The start date for the budget.
	StartDate *time.Time `json:"startDate,omitempty"`

	// The end date for the budget. If not provided, we default this to 10 years from the start date.
	EndDate *time.Time `json:"endDate,omitempty"`
}

// BudgetsClientCreateOrUpdateOptions contains the optional parameters for the BudgetsClient.CreateOrUpdate method.
type BudgetsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// BudgetsClientDeleteOptions contains the optional parameters for the BudgetsClient.Delete method.
type BudgetsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BudgetsClientGetOptions contains the optional parameters for the BudgetsClient.Get method.
type BudgetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BudgetsClientListOptions contains the optional parameters for the BudgetsClient.List method.
type BudgetsClientListOptions struct {
	// placeholder for future optional parameters
}

// BudgetsListResult - Result of listing budgets. It contains a list of available budgets in the scope provided.
type BudgetsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of budgets.
	Value []*Budget `json:"value,omitempty" azure:"ro"`
}

// ChargeSummaryClassification provides polymorphic access to related types.
// Call the interface's GetChargeSummary() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ChargeSummary, *LegacyChargeSummary, *ModernChargeSummary
type ChargeSummaryClassification interface {
	// GetChargeSummary returns the ChargeSummary content of the underlying type.
	GetChargeSummary() *ChargeSummary
}

// ChargeSummary - A charge summary resource.
type ChargeSummary struct {
	// REQUIRED; Specifies the kind of charge summary.
	Kind *ChargeSummaryKind `json:"kind,omitempty"`

	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetChargeSummary implements the ChargeSummaryClassification interface for type ChargeSummary.
func (c *ChargeSummary) GetChargeSummary() *ChargeSummary { return c }

// ChargesClientListOptions contains the optional parameters for the ChargesClient.List method.
type ChargesClientListOptions struct {
	// May be used to group charges for billingAccount scope by properties/billingProfileId, properties/invoiceSectionId, properties/customerId
	// (specific for Partner Led), or for billingProfile scope by
	// properties/invoiceSectionId.
	Apply *string
	// End date
	EndDate *string
	// May be used to filter charges by properties/usageEnd (Utc time), properties/usageStart (Utc time). The filter supports
	// 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently support 'ne',
	// 'or', or 'not'. Tag filter is a key value pair string where key and value is separated by a colon (:).
	Filter *string
	// Start date
	StartDate *string
}

// ChargesListResult - Result of listing charge summary.
type ChargesListResult struct {
	// READ-ONLY; The list of charge summary
	Value []ChargeSummaryClassification `json:"value,omitempty" azure:"ro"`
}

// CreditBalanceSummary - Summary of credit balances.
type CreditBalanceSummary struct {
	// READ-ONLY; Current balance.
	CurrentBalance *Amount `json:"currentBalance,omitempty" azure:"ro"`

	// READ-ONLY; Estimated balance.
	EstimatedBalance *Amount `json:"estimatedBalance,omitempty" azure:"ro"`

	// READ-ONLY; Estimated balance in billing currency.
	EstimatedBalanceInBillingCurrency *AmountWithExchangeRate `json:"estimatedBalanceInBillingCurrency,omitempty" azure:"ro"`
}

// CreditSummary - A credit summary resource.
type CreditSummary struct {
	// The properties of the credit summary.
	Properties *CreditSummaryProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CreditSummaryProperties - The properties of the credit summary.
type CreditSummaryProperties struct {
	// READ-ONLY; Summary of balances associated with this credit summary.
	BalanceSummary *CreditBalanceSummary `json:"balanceSummary,omitempty" azure:"ro"`

	// READ-ONLY; The billing currency.
	BillingCurrency *string `json:"billingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The credit currency.
	CreditCurrency *string `json:"creditCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The eTag for the resource.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; Expired credit.
	ExpiredCredit *Amount `json:"expiredCredit,omitempty" azure:"ro"`

	// READ-ONLY; Pending credit adjustments.
	PendingCreditAdjustments *Amount `json:"pendingCreditAdjustments,omitempty" azure:"ro"`

	// READ-ONLY; Pending eligible charges.
	PendingEligibleCharges *Amount `json:"pendingEligibleCharges,omitempty" azure:"ro"`

	// READ-ONLY; Credit's reseller.
	Reseller *Reseller `json:"reseller,omitempty" azure:"ro"`
}

// CreditsClientGetOptions contains the optional parameters for the CreditsClient.Get method.
type CreditsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CurrentSpend - The current amount of cost which is being tracked for a budget.
type CurrentSpend struct {
	// READ-ONLY; The total amount of cost which is being tracked by the budget.
	Amount *float64 `json:"amount,omitempty" azure:"ro"`

	// READ-ONLY; The unit of measure for the budget amount.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// DownloadProperties - The properties of the price sheet download.
type DownloadProperties struct {
	// READ-ONLY; The link (url) to download the pricesheet.
	DownloadURL *string `json:"downloadUrl,omitempty" azure:"ro"`

	// READ-ONLY; Download link validity.
	ValidTill *string `json:"validTill,omitempty" azure:"ro"`
}

// ErrorDetails - The details of the error.
type ErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason is provided
// in the error message.
// Some Error responses:
// * 429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the "x-ms-ratelimit-microsoft.consumption-retry-after"
// header.
//
// * 503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time specified in the "Retry-After"
// header.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// EventProperties - The event properties.
type EventProperties struct {
	// Identifies the type of the event.
	EventType *EventType `json:"eventType,omitempty"`

	// READ-ONLY; The amount of balance adjustment. The property is not available for ConsumptionCommitment lots.
	Adjustments *Amount `json:"adjustments,omitempty" azure:"ro"`

	// READ-ONLY; The amount of balance adjustment in billing currency.
	AdjustmentsInBillingCurrency *AmountWithExchangeRate `json:"adjustmentsInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The billing currency of the event.
	BillingCurrency *string `json:"billingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the billing profile for which the event happened. The property is only available for billing
	// account of type MicrosoftCustomerAgreement.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies the billing profile for which the event happened. The property is only available
	// for billing account of type MicrosoftCustomerAgreement.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; Amount of canceled credit.
	CanceledCredit *Amount `json:"canceledCredit,omitempty" azure:"ro"`

	// READ-ONLY; The amount of charges for events of type SettleCharges and PendingEligibleCharges.
	Charges *Amount `json:"charges,omitempty" azure:"ro"`

	// READ-ONLY; The amount of charges for events of type SettleCharges and PendingEligibleCharges in billing currency.
	ChargesInBillingCurrency *AmountWithExchangeRate `json:"chargesInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The balance after the event.
	ClosedBalance *Amount `json:"closedBalance,omitempty" azure:"ro"`

	// READ-ONLY; The balance in billing currency after the event.
	ClosedBalanceInBillingCurrency *AmountWithExchangeRate `json:"closedBalanceInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The credit currency of the event.
	CreditCurrency *string `json:"creditCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The amount of expired credit or commitment for NewCredit or SettleCharges event.
	CreditExpired *Amount `json:"creditExpired,omitempty" azure:"ro"`

	// READ-ONLY; The amount of expired credit or commitment for NewCredit or SettleCharges event in billing currency.
	CreditExpiredInBillingCurrency *AmountWithExchangeRate `json:"creditExpiredInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The description of the event.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The eTag for the resource.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; The number which uniquely identifies the invoice on which the event was billed. This will be empty for unbilled
	// events.
	InvoiceNumber *string `json:"invoiceNumber,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies the lot for which the event happened.
	LotID *string `json:"lotId,omitempty" azure:"ro"`

	// READ-ONLY; Identifies the source of the lot for which the event happened.
	LotSource *string `json:"lotSource,omitempty" azure:"ro"`

	// READ-ONLY; The amount of new credit or commitment for NewCredit or SettleCharges event.
	NewCredit *Amount `json:"newCredit,omitempty" azure:"ro"`

	// READ-ONLY; The amount of new credit or commitment for NewCredit or SettleCharges event in billing currency.
	NewCreditInBillingCurrency *AmountWithExchangeRate `json:"newCreditInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The reseller of the event.
	Reseller *Reseller `json:"reseller,omitempty" azure:"ro"`

	// READ-ONLY; The date of the event.
	TransactionDate *time.Time `json:"transactionDate,omitempty" azure:"ro"`
}

// EventSummary - An event summary resource.
type EventSummary struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// The event properties.
	Properties *EventProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Events - Result of listing event summary.
type Events struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of event summary.
	Value []*EventSummary `json:"value,omitempty" azure:"ro"`
}

// EventsClientListByBillingAccountOptions contains the optional parameters for the EventsClient.ListByBillingAccount method.
type EventsClientListByBillingAccountOptions struct {
	// May be used to filter the events by lotId, lotSource etc. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'.
	// It does not currently support 'ne', 'or', or 'not'. Tag filter is a key value
	// pair string where key and value is separated by a colon (:).
	Filter *string
}

// EventsClientListByBillingProfileOptions contains the optional parameters for the EventsClient.ListByBillingProfile method.
type EventsClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// ForecastSpend - The forecasted cost which is being tracked for a budget.
type ForecastSpend struct {
	// READ-ONLY; The forecasted cost for the total time period which is being tracked by the budget. This value is only provided
	// if the budget contains a forecast alert type.
	Amount *float64 `json:"amount,omitempty" azure:"ro"`

	// READ-ONLY; The unit of measure for the budget amount.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// HighCasedErrorDetails - The details of the error.
type HighCasedErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// HighCasedErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason
// is provided in the error message.
// Some Error responses:
// * 429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the "x-ms-ratelimit-microsoft.consumption-retry-after"
// header.
//
// * 503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time specified in the "Retry-After"
// header.
type HighCasedErrorResponse struct {
	// The details of the error.
	Error *HighCasedErrorDetails `json:"error,omitempty"`
}

// LegacyChargeSummary - Legacy charge summary.
type LegacyChargeSummary struct {
	// REQUIRED; Specifies the kind of charge summary.
	Kind *ChargeSummaryKind `json:"kind,omitempty"`

	// REQUIRED; Properties for legacy charge summary
	Properties *LegacyChargeSummaryProperties `json:"properties,omitempty"`

	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetChargeSummary implements the ChargeSummaryClassification interface for type LegacyChargeSummary.
func (l *LegacyChargeSummary) GetChargeSummary() *ChargeSummary {
	return &ChargeSummary{
		Kind: l.Kind,
		ID:   l.ID,
		Name: l.Name,
		Type: l.Type,
		ETag: l.ETag,
	}
}

// LegacyChargeSummaryProperties - The properties of legacy charge summary.
type LegacyChargeSummaryProperties struct {
	// READ-ONLY; Azure Charges.
	AzureCharges *float64 `json:"azureCharges,omitempty" azure:"ro"`

	// READ-ONLY; The id of the billing period resource that the charge belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty" azure:"ro"`

	// READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *float64 `json:"chargesBilledSeparately,omitempty" azure:"ro"`

	// READ-ONLY; Currency Code
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; Marketplace Charges.
	MarketplaceCharges *float64 `json:"marketplaceCharges,omitempty" azure:"ro"`

	// READ-ONLY; Usage end date.
	UsageEnd *string `json:"usageEnd,omitempty" azure:"ro"`

	// READ-ONLY; Usage start date.
	UsageStart *string `json:"usageStart,omitempty" azure:"ro"`
}

// LegacyReservationRecommendation - Legacy reservation recommendation.
type LegacyReservationRecommendation struct {
	// REQUIRED; Specifies the kind of reservation recommendation.
	Kind *ReservationRecommendationKind `json:"kind,omitempty"`

	// REQUIRED; Properties for legacy reservation recommendation
	Properties LegacyReservationRecommendationPropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource sku
	SKU *string `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetReservationRecommendation implements the ReservationRecommendationClassification interface for type LegacyReservationRecommendation.
func (l *LegacyReservationRecommendation) GetReservationRecommendation() *ReservationRecommendation {
	return &ReservationRecommendation{
		Kind:     l.Kind,
		ID:       l.ID,
		Name:     l.Name,
		Type:     l.Type,
		Etag:     l.Etag,
		Tags:     l.Tags,
		Location: l.Location,
		SKU:      l.SKU,
	}
}

// LegacyReservationRecommendationPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetLegacyReservationRecommendationProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LegacyReservationRecommendationProperties, *LegacySharedScopeReservationRecommendationProperties, *LegacySingleScopeReservationRecommendationProperties
type LegacyReservationRecommendationPropertiesClassification interface {
	// GetLegacyReservationRecommendationProperties returns the LegacyReservationRecommendationProperties content of the underlying type.
	GetLegacyReservationRecommendationProperties() *LegacyReservationRecommendationProperties
}

// LegacyReservationRecommendationProperties - The properties of the reservation recommendation.
type LegacyReservationRecommendationProperties struct {
	// REQUIRED; Shared or single recommendation.
	Scope *string `json:"scope,omitempty"`

	// READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *float64 `json:"costWithNoReservedInstances,omitempty" azure:"ro"`

	// READ-ONLY; The usage date for looking back.
	FirstUsageDate *time.Time `json:"firstUsageDate,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string `json:"instanceFlexibilityGroup,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float32 `json:"instanceFlexibilityRatio,omitempty" azure:"ro"`

	// READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *string `json:"lookBackPeriod,omitempty" azure:"ro"`

	// READ-ONLY; The meter id (GUID)
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *float64 `json:"netSavings,omitempty" azure:"ro"`

	// READ-ONLY; The normalized Size.
	NormalizedSize *string `json:"normalizedSize,omitempty" azure:"ro"`

	// READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *float64 `json:"recommendedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float32 `json:"recommendedQuantityNormalized,omitempty" azure:"ro"`

	// READ-ONLY; The azure resource type.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; List of sku properties
	SKUProperties []*SKUProperty `json:"skuProperties,omitempty" azure:"ro"`

	// READ-ONLY; RI recommendations in one or three year terms.
	Term *string `json:"term,omitempty" azure:"ro"`

	// READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *float64 `json:"totalCostWithReservedInstances,omitempty" azure:"ro"`
}

// GetLegacyReservationRecommendationProperties implements the LegacyReservationRecommendationPropertiesClassification interface
// for type LegacyReservationRecommendationProperties.
func (l *LegacyReservationRecommendationProperties) GetLegacyReservationRecommendationProperties() *LegacyReservationRecommendationProperties {
	return l
}

// LegacyReservationTransaction - Legacy Reservation transaction resource.
type LegacyReservationTransaction struct {
	// The properties of a legacy reservation transaction.
	Properties *LegacyReservationTransactionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags []*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LegacyReservationTransactionProperties - The properties of a legacy reservation transaction.
type LegacyReservationTransactionProperties struct {
	// READ-ONLY; The name of the account that makes the transaction.
	AccountName *string `json:"accountName,omitempty" azure:"ro"`

	// READ-ONLY; The email of the account owner that makes the transaction.
	AccountOwnerEmail *string `json:"accountOwnerEmail,omitempty" azure:"ro"`

	// READ-ONLY; The charge of the transaction.
	Amount *float64 `json:"amount,omitempty" azure:"ro"`

	// READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	ArmSKUName *string `json:"armSkuName,omitempty" azure:"ro"`

	// READ-ONLY; The billing frequency, which can be either one-time or recurring.
	BillingFrequency *string `json:"billingFrequency,omitempty" azure:"ro"`

	// READ-ONLY; The billing month(yyyyMMdd), on which the event initiated.
	BillingMonth *int32 `json:"billingMonth,omitempty" azure:"ro"`

	// READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string `json:"costCenter,omitempty" azure:"ro"`

	// READ-ONLY; The ISO currency in which the transaction is charged, for example, USD.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; The current enrollment.
	CurrentEnrollment *string `json:"currentEnrollment,omitempty" azure:"ro"`

	// READ-ONLY; The department name.
	DepartmentName *string `json:"departmentName,omitempty" azure:"ro"`

	// READ-ONLY; The description of the transaction.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The date of the transaction
	EventDate *time.Time `json:"eventDate,omitempty" azure:"ro"`

	// READ-ONLY; The type of the transaction (Purchase, Cancel, etc.)
	EventType *string `json:"eventType,omitempty" azure:"ro"`

	// READ-ONLY; The monetary commitment amount at the enrollment scope.
	MonetaryCommitment *float64 `json:"monetaryCommitment,omitempty" azure:"ro"`

	// READ-ONLY; The overage amount at the enrollment scope.
	Overage *float64 `json:"overage,omitempty" azure:"ro"`

	// READ-ONLY; The purchasing enrollment.
	PurchasingEnrollment *string `json:"purchasingEnrollment,omitempty" azure:"ro"`

	// READ-ONLY; The subscription guid that makes the transaction.
	PurchasingSubscriptionGUID *string `json:"purchasingSubscriptionGuid,omitempty" azure:"ro"`

	// READ-ONLY; The subscription name that makes the transaction.
	PurchasingSubscriptionName *string `json:"purchasingSubscriptionName,omitempty" azure:"ro"`

	// READ-ONLY; The quantity of the transaction.
	Quantity *float64 `json:"quantity,omitempty" azure:"ro"`

	// READ-ONLY; The region of the transaction.
	Region *string `json:"region,omitempty" azure:"ro"`

	// READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents
	// a single purchase transaction. A reservation order contains reservations. The reservation
	// order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the reservation order.
	ReservationOrderName *string `json:"reservationOrderName,omitempty" azure:"ro"`

	// READ-ONLY; This is the term of the transaction.
	Term *string `json:"term,omitempty" azure:"ro"`
}

// LegacySharedScopeReservationRecommendationProperties - The properties of the legacy reservation recommendation for shared
// scope.
type LegacySharedScopeReservationRecommendationProperties struct {
	// REQUIRED; Shared or single recommendation.
	Scope *string `json:"scope,omitempty"`

	// READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *float64 `json:"costWithNoReservedInstances,omitempty" azure:"ro"`

	// READ-ONLY; The usage date for looking back.
	FirstUsageDate *time.Time `json:"firstUsageDate,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string `json:"instanceFlexibilityGroup,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float32 `json:"instanceFlexibilityRatio,omitempty" azure:"ro"`

	// READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *string `json:"lookBackPeriod,omitempty" azure:"ro"`

	// READ-ONLY; The meter id (GUID)
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *float64 `json:"netSavings,omitempty" azure:"ro"`

	// READ-ONLY; The normalized Size.
	NormalizedSize *string `json:"normalizedSize,omitempty" azure:"ro"`

	// READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *float64 `json:"recommendedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float32 `json:"recommendedQuantityNormalized,omitempty" azure:"ro"`

	// READ-ONLY; The azure resource type.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; List of sku properties
	SKUProperties []*SKUProperty `json:"skuProperties,omitempty" azure:"ro"`

	// READ-ONLY; RI recommendations in one or three year terms.
	Term *string `json:"term,omitempty" azure:"ro"`

	// READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *float64 `json:"totalCostWithReservedInstances,omitempty" azure:"ro"`
}

// GetLegacyReservationRecommendationProperties implements the LegacyReservationRecommendationPropertiesClassification interface
// for type LegacySharedScopeReservationRecommendationProperties.
func (l *LegacySharedScopeReservationRecommendationProperties) GetLegacyReservationRecommendationProperties() *LegacyReservationRecommendationProperties {
	return &LegacyReservationRecommendationProperties{
		LookBackPeriod:                 l.LookBackPeriod,
		InstanceFlexibilityRatio:       l.InstanceFlexibilityRatio,
		InstanceFlexibilityGroup:       l.InstanceFlexibilityGroup,
		NormalizedSize:                 l.NormalizedSize,
		RecommendedQuantityNormalized:  l.RecommendedQuantityNormalized,
		MeterID:                        l.MeterID,
		ResourceType:                   l.ResourceType,
		Term:                           l.Term,
		CostWithNoReservedInstances:    l.CostWithNoReservedInstances,
		RecommendedQuantity:            l.RecommendedQuantity,
		TotalCostWithReservedInstances: l.TotalCostWithReservedInstances,
		NetSavings:                     l.NetSavings,
		FirstUsageDate:                 l.FirstUsageDate,
		Scope:                          l.Scope,
		SKUProperties:                  l.SKUProperties,
	}
}

// LegacySingleScopeReservationRecommendationProperties - The properties of the legacy reservation recommendation for single
// scope.
type LegacySingleScopeReservationRecommendationProperties struct {
	// REQUIRED; Shared or single recommendation.
	Scope *string `json:"scope,omitempty"`

	// READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *float64 `json:"costWithNoReservedInstances,omitempty" azure:"ro"`

	// READ-ONLY; The usage date for looking back.
	FirstUsageDate *time.Time `json:"firstUsageDate,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string `json:"instanceFlexibilityGroup,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float32 `json:"instanceFlexibilityRatio,omitempty" azure:"ro"`

	// READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *string `json:"lookBackPeriod,omitempty" azure:"ro"`

	// READ-ONLY; The meter id (GUID)
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *float64 `json:"netSavings,omitempty" azure:"ro"`

	// READ-ONLY; The normalized Size.
	NormalizedSize *string `json:"normalizedSize,omitempty" azure:"ro"`

	// READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *float64 `json:"recommendedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float32 `json:"recommendedQuantityNormalized,omitempty" azure:"ro"`

	// READ-ONLY; The azure resource type.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; List of sku properties
	SKUProperties []*SKUProperty `json:"skuProperties,omitempty" azure:"ro"`

	// READ-ONLY; Subscription id associated with single scoped recommendation.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; RI recommendations in one or three year terms.
	Term *string `json:"term,omitempty" azure:"ro"`

	// READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *float64 `json:"totalCostWithReservedInstances,omitempty" azure:"ro"`
}

// GetLegacyReservationRecommendationProperties implements the LegacyReservationRecommendationPropertiesClassification interface
// for type LegacySingleScopeReservationRecommendationProperties.
func (l *LegacySingleScopeReservationRecommendationProperties) GetLegacyReservationRecommendationProperties() *LegacyReservationRecommendationProperties {
	return &LegacyReservationRecommendationProperties{
		LookBackPeriod:                 l.LookBackPeriod,
		InstanceFlexibilityRatio:       l.InstanceFlexibilityRatio,
		InstanceFlexibilityGroup:       l.InstanceFlexibilityGroup,
		NormalizedSize:                 l.NormalizedSize,
		RecommendedQuantityNormalized:  l.RecommendedQuantityNormalized,
		MeterID:                        l.MeterID,
		ResourceType:                   l.ResourceType,
		Term:                           l.Term,
		CostWithNoReservedInstances:    l.CostWithNoReservedInstances,
		RecommendedQuantity:            l.RecommendedQuantity,
		TotalCostWithReservedInstances: l.TotalCostWithReservedInstances,
		NetSavings:                     l.NetSavings,
		FirstUsageDate:                 l.FirstUsageDate,
		Scope:                          l.Scope,
		SKUProperties:                  l.SKUProperties,
	}
}

// LegacyUsageDetail - Legacy usage detail.
type LegacyUsageDetail struct {
	// REQUIRED; Specifies the kind of usage details.
	Kind *UsageDetailsKind `json:"kind,omitempty"`

	// REQUIRED; Properties for legacy usage details
	Properties *LegacyUsageDetailProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetUsageDetail implements the UsageDetailClassification interface for type LegacyUsageDetail.
func (l *LegacyUsageDetail) GetUsageDetail() *UsageDetail {
	return &UsageDetail{
		Kind: l.Kind,
		ID:   l.ID,
		Name: l.Name,
		Type: l.Type,
		Etag: l.Etag,
		Tags: l.Tags,
	}
}

// LegacyUsageDetailProperties - The properties of the legacy usage detail.
type LegacyUsageDetailProperties struct {
	// READ-ONLY; Account Name.
	AccountName *string `json:"accountName,omitempty" azure:"ro"`

	// READ-ONLY; Account Owner Id.
	AccountOwnerID *string `json:"accountOwnerId,omitempty" azure:"ro"`

	// READ-ONLY; Additional details of this usage item. By default this is not populated, unless it's specified in $expand. Use
	// this field to get usage line item specific details such as the actual VM Size
	// (ServiceType) or the ratio in which the reservation discount is applied.
	AdditionalInfo *string `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; Unique identifier for the applicable benefit.
	BenefitID *string `json:"benefitId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the applicable benefit.
	BenefitName *string `json:"benefitName,omitempty" azure:"ro"`

	// READ-ONLY; Billing Account identifier.
	BillingAccountID *string `json:"billingAccountId,omitempty" azure:"ro"`

	// READ-ONLY; Billing Account Name.
	BillingAccountName *string `json:"billingAccountName,omitempty" azure:"ro"`

	// READ-ONLY; Billing Currency.
	BillingCurrency *string `json:"billingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The billing period end date.
	BillingPeriodEndDate *time.Time `json:"billingPeriodEndDate,omitempty" azure:"ro"`

	// READ-ONLY; The billing period start date.
	BillingPeriodStartDate *time.Time `json:"billingPeriodStartDate,omitempty" azure:"ro"`

	// READ-ONLY; Billing Profile identifier.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; Billing Profile Name.
	BillingProfileName *string `json:"billingProfileName,omitempty" azure:"ro"`

	// READ-ONLY; Indicates a charge represents credits, usage, a Marketplace purchase, a reservation fee, or a refund.
	ChargeType *string `json:"chargeType,omitempty" azure:"ro"`

	// READ-ONLY; Consumed service name. Name of the azure resource provider that emits the usage or was purchased. This value
	// is not provided for marketplace usage.
	ConsumedService *string `json:"consumedService,omitempty" azure:"ro"`

	// READ-ONLY; The amount of cost before tax.
	Cost *float64 `json:"cost,omitempty" azure:"ro"`

	// READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string `json:"costCenter,omitempty" azure:"ro"`

	// READ-ONLY; Date for the usage record.
	Date *time.Time `json:"date,omitempty" azure:"ro"`

	// READ-ONLY; Effective Price that's charged for the usage.
	EffectivePrice *float64 `json:"effectivePrice,omitempty" azure:"ro"`

	// READ-ONLY; Indicates how frequently this charge will occur. OneTime for purchases which only happen once, Monthly for fees
	// which recur every month, and UsageBased for charges based on how much a service is used.
	Frequency *string `json:"frequency,omitempty" azure:"ro"`

	// READ-ONLY; Invoice Section Name.
	InvoiceSection *string `json:"invoiceSection,omitempty" azure:"ro"`

	// READ-ONLY; Is Azure Credit Eligible.
	IsAzureCreditEligible *bool `json:"isAzureCreditEligible,omitempty" azure:"ro"`

	// READ-ONLY; The details about the meter. By default this is not populated, unless it's specified in $expand.
	MeterDetails *MeterDetailsResponse `json:"meterDetails,omitempty" azure:"ro"`

	// READ-ONLY; The meter id (GUID). Not available for marketplace. For reserved instance this represents the primary meter
	// for which the reservation was purchased. For the actual VM Size for which the reservation is
	// purchased see productOrderName.
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; Offer Id. Ex: MS-AZR-0017P, MS-AZR-0148P.
	OfferID *string `json:"offerId,omitempty" azure:"ro"`

	// READ-ONLY; Part Number of the service used. Can be used to join with the price sheet. Not available for marketplace.
	PartNumber *string `json:"partNumber,omitempty" azure:"ro"`

	// READ-ONLY; Retail price for the resource.
	PayGPrice *float64 `json:"payGPrice,omitempty" azure:"ro"`

	// READ-ONLY; Plan Name.
	PlanName *string `json:"planName,omitempty" azure:"ro"`

	// READ-ONLY; Identifier that indicates how the meter is priced.
	PricingModel *PricingModelType `json:"pricingModel,omitempty" azure:"ro"`

	// READ-ONLY; Product name for the consumed service or purchase. Not available for Marketplace.
	Product *string `json:"product,omitempty" azure:"ro"`

	// READ-ONLY; Product Order Id. For reservations this is the Reservation Order ID.
	ProductOrderID *string `json:"productOrderId,omitempty" azure:"ro"`

	// READ-ONLY; Product Order Name. For reservations this is the SKU that was purchased.
	ProductOrderName *string `json:"productOrderName,omitempty" azure:"ro"`

	// READ-ONLY; Publisher Name.
	PublisherName *string `json:"publisherName,omitempty" azure:"ro"`

	// READ-ONLY; Publisher Type.
	PublisherType *string `json:"publisherType,omitempty" azure:"ro"`

	// READ-ONLY; The usage quantity.
	Quantity *float64 `json:"quantity,omitempty" azure:"ro"`

	// READ-ONLY; ARM resource id of the reservation. Only applies to records relevant to reservations.
	ReservationID *string `json:"reservationId,omitempty" azure:"ro"`

	// READ-ONLY; User provided display name of the reservation. Last known name for a particular day is populated in the daily
	// data. Only applies to records relevant to reservations.
	ReservationName *string `json:"reservationName,omitempty" azure:"ro"`

	// READ-ONLY; Resource Group Name.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Unique identifier of the Azure Resource Manager usage detail resource.
	ResourceID *string `json:"resourceId,omitempty" azure:"ro"`

	// READ-ONLY; Resource Location.
	ResourceLocation *string `json:"resourceLocation,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	ResourceName *string `json:"resourceName,omitempty" azure:"ro"`

	// READ-ONLY; Service-specific metadata.
	ServiceInfo1 *string `json:"serviceInfo1,omitempty" azure:"ro"`

	// READ-ONLY; Legacy field with optional service-specific metadata.
	ServiceInfo2 *string `json:"serviceInfo2,omitempty" azure:"ro"`

	// READ-ONLY; Subscription guid.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; Subscription name.
	SubscriptionName *string `json:"subscriptionName,omitempty" azure:"ro"`

	// READ-ONLY; Term (in months). 1 month for monthly recurring purchase. 12 months for a 1 year reservation. 36 months for
	// a 3 year reservation.
	Term *string `json:"term,omitempty" azure:"ro"`

	// READ-ONLY; Unit Price is the price applicable to you. (your EA or other contract price).
	UnitPrice *float64 `json:"unitPrice,omitempty" azure:"ro"`
}

// LotProperties - The lot properties.
type LotProperties struct {
	// READ-ONLY; The billing currency of the lot.
	BillingCurrency *string `json:"billingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The balance as of the last invoice.
	ClosedBalance *Amount `json:"closedBalance,omitempty" azure:"ro"`

	// READ-ONLY; The balance as of the last invoice in billing currency.
	ClosedBalanceInBillingCurrency *AmountWithExchangeRate `json:"closedBalanceInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The currency of the lot.
	CreditCurrency *string `json:"creditCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The eTag for the resource.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; The expiration date of a lot.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The original amount of a lot.
	OriginalAmount *Amount `json:"originalAmount,omitempty" azure:"ro"`

	// READ-ONLY; The original amount of a lot in billing currency.
	OriginalAmountInBillingCurrency *AmountWithExchangeRate `json:"originalAmountInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The po number of the invoice on which the lot was added. This property is not available for ConsumptionCommitment
	// lots.
	PoNumber *string `json:"poNumber,omitempty" azure:"ro"`

	// READ-ONLY; The date when the lot was added.
	PurchasedDate *time.Time `json:"purchasedDate,omitempty" azure:"ro"`

	// READ-ONLY; The reseller of the lot.
	Reseller *Reseller `json:"reseller,omitempty" azure:"ro"`

	// READ-ONLY; The source of the lot.
	Source *LotSource `json:"source,omitempty" azure:"ro"`

	// READ-ONLY; The date when the lot became effective.
	StartDate *time.Time `json:"startDate,omitempty" azure:"ro"`

	// READ-ONLY; The status of the lot.
	Status *Status `json:"status,omitempty" azure:"ro"`
}

// LotSummary - A lot summary resource.
type LotSummary struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// The lot properties.
	Properties *LotProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Lots - Result of listing lot summary.
type Lots struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of lot summary.
	Value []*LotSummary `json:"value,omitempty" azure:"ro"`
}

// LotsClientListByBillingAccountOptions contains the optional parameters for the LotsClient.ListByBillingAccount method.
type LotsClientListByBillingAccountOptions struct {
	// May be used to filter the lots by Status, Source etc. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does
	// not currently support 'ne', 'or', or 'not'. Tag filter is a key value pair
	// string where key and value is separated by a colon (:).
	Filter *string
}

// LotsClientListByBillingProfileOptions contains the optional parameters for the LotsClient.ListByBillingProfile method.
type LotsClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// LotsClientListByCustomerOptions contains the optional parameters for the LotsClient.ListByCustomer method.
type LotsClientListByCustomerOptions struct {
	// May be used to filter the lots by Status, Source etc. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. Tag
	// filter is a key value pair string where key and value is separated by a colon
	// (:).
	Filter *string
}

// ManagementGroupAggregatedCostProperties - The properties of the Management Group Aggregated Cost.
type ManagementGroupAggregatedCostProperties struct {
	// Children of a management group
	Children []*ManagementGroupAggregatedCostResult `json:"children,omitempty"`

	// List of subscription Guids excluded from the calculation of aggregated cost
	ExcludedSubscriptions []*string `json:"excludedSubscriptions,omitempty"`

	// List of subscription Guids included in the calculation of aggregated cost
	IncludedSubscriptions []*string `json:"includedSubscriptions,omitempty"`

	// READ-ONLY; Azure Charges.
	AzureCharges *float64 `json:"azureCharges,omitempty" azure:"ro"`

	// READ-ONLY; The id of the billing period resource that the aggregated cost belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty" azure:"ro"`

	// READ-ONLY; Charges Billed Separately.
	ChargesBilledSeparately *float64 `json:"chargesBilledSeparately,omitempty" azure:"ro"`

	// READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; Marketplace Charges.
	MarketplaceCharges *float64 `json:"marketplaceCharges,omitempty" azure:"ro"`

	// READ-ONLY; The end of the date time range covered by the aggregated cost.
	UsageEnd *time.Time `json:"usageEnd,omitempty" azure:"ro"`

	// READ-ONLY; The start of the date time range covered by aggregated cost.
	UsageStart *time.Time `json:"usageStart,omitempty" azure:"ro"`
}

// ManagementGroupAggregatedCostResult - A management group aggregated cost resource.
type ManagementGroupAggregatedCostResult struct {
	// The properties of the Management Group Aggregated Cost.
	Properties *ManagementGroupAggregatedCostProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Marketplace - A marketplace resource.
type Marketplace struct {
	// The properties of the marketplace usage detail.
	Properties *MarketplaceProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarketplaceProperties - The properties of the marketplace usage detail.
type MarketplaceProperties struct {
	// READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty" azure:"ro"`

	// READ-ONLY; Additional information.
	AdditionalInfo *string `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; Additional details of this usage item. By default this is not populated, unless it's specified in $expand.
	AdditionalProperties *string `json:"additionalProperties,omitempty" azure:"ro"`

	// READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty" azure:"ro"`

	// READ-ONLY; The quantity of usage.
	ConsumedQuantity *float64 `json:"consumedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; Consumed service name.
	ConsumedService *string `json:"consumedService,omitempty" azure:"ro"`

	// READ-ONLY; The cost center of this department if it is a department and a costcenter exists
	CostCenter *string `json:"costCenter,omitempty" azure:"ro"`

	// READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; Department name.
	DepartmentName *string `json:"departmentName,omitempty" azure:"ro"`

	// READ-ONLY; The uri of the resource instance that the usage is about.
	InstanceID *string `json:"instanceId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource instance that the usage is about.
	InstanceName *string `json:"instanceName,omitempty" azure:"ro"`

	// READ-ONLY; The estimated usage is subject to change.
	IsEstimated *bool `json:"isEstimated,omitempty" azure:"ro"`

	// READ-ONLY; Flag indicating whether this is a recurring charge or not.
	IsRecurringCharge *bool `json:"isRecurringCharge,omitempty" azure:"ro"`

	// READ-ONLY; The meter id (GUID).
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; The type of offer.
	OfferName *string `json:"offerName,omitempty" azure:"ro"`

	// READ-ONLY; The order number.
	OrderNumber *string `json:"orderNumber,omitempty" azure:"ro"`

	// READ-ONLY; The name of plan.
	PlanName *string `json:"planName,omitempty" azure:"ro"`

	// READ-ONLY; The amount of cost before tax.
	PretaxCost *float64 `json:"pretaxCost,omitempty" azure:"ro"`

	// READ-ONLY; The name of publisher.
	PublisherName *string `json:"publisherName,omitempty" azure:"ro"`

	// READ-ONLY; The name of resource group.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; The marketplace resource rate.
	ResourceRate *float64 `json:"resourceRate,omitempty" azure:"ro"`

	// READ-ONLY; Subscription guid.
	SubscriptionGUID *string `json:"subscriptionGuid,omitempty" azure:"ro"`

	// READ-ONLY; Subscription name.
	SubscriptionName *string `json:"subscriptionName,omitempty" azure:"ro"`

	// READ-ONLY; The unit of measure.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty" azure:"ro"`

	// READ-ONLY; The end of the date time range covered by the usage detail.
	UsageEnd *time.Time `json:"usageEnd,omitempty" azure:"ro"`

	// READ-ONLY; The start of the date time range covered by the usage detail.
	UsageStart *time.Time `json:"usageStart,omitempty" azure:"ro"`
}

// MarketplacesClientListOptions contains the optional parameters for the MarketplacesClient.List method.
type MarketplacesClientListOptions struct {
	// May be used to filter marketplaces by properties/usageEnd (Utc time), properties/usageStart (Utc time), properties/resourceGroup,
	// properties/instanceName or properties/instanceId. The filter supports
	// 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently support 'ne', 'or', or 'not'.
	Filter *string
	// Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skiptoken parameter that
	// specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// May be used to limit the number of results to the most recent N marketplaces.
	Top *int32
}

// MarketplacesListResult - Result of listing marketplaces. It contains a list of available marketplaces in reverse chronological
// order by billing period.
type MarketplacesListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of marketplaces.
	Value []*Marketplace `json:"value,omitempty" azure:"ro"`
}

// MeterDetails - The properties of the meter detail.
type MeterDetails struct {
	// READ-ONLY; The category of the meter, for example, 'Cloud services', 'Networking', etc..
	MeterCategory *string `json:"meterCategory,omitempty" azure:"ro"`

	// READ-ONLY; The location in which the Azure service is available.
	MeterLocation *string `json:"meterLocation,omitempty" azure:"ro"`

	// READ-ONLY; The name of the meter, within the given meter category
	MeterName *string `json:"meterName,omitempty" azure:"ro"`

	// READ-ONLY; The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc..
	MeterSubCategory *string `json:"meterSubCategory,omitempty" azure:"ro"`

	// READ-ONLY; The pretax listing price.
	PretaxStandardRate *float64 `json:"pretaxStandardRate,omitempty" azure:"ro"`

	// READ-ONLY; The name of the service.
	ServiceName *string `json:"serviceName,omitempty" azure:"ro"`

	// READ-ONLY; The service tier.
	ServiceTier *string `json:"serviceTier,omitempty" azure:"ro"`

	// READ-ONLY; The total included quantity associated with the offer.
	TotalIncludedQuantity *float64 `json:"totalIncludedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// MeterDetailsResponse - The properties of the meter detail.
type MeterDetailsResponse struct {
	// READ-ONLY; The category of the meter, for example, 'Cloud services', 'Networking', etc..
	MeterCategory *string `json:"meterCategory,omitempty" azure:"ro"`

	// READ-ONLY; The name of the meter, within the given meter category
	MeterName *string `json:"meterName,omitempty" azure:"ro"`

	// READ-ONLY; The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc..
	MeterSubCategory *string `json:"meterSubCategory,omitempty" azure:"ro"`

	// READ-ONLY; The service family.
	ServiceFamily *string `json:"serviceFamily,omitempty" azure:"ro"`

	// READ-ONLY; The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty" azure:"ro"`
}

// ModernChargeSummary - Modern charge summary.
type ModernChargeSummary struct {
	// REQUIRED; Specifies the kind of charge summary.
	Kind *ChargeSummaryKind `json:"kind,omitempty"`

	// REQUIRED; Properties for modern charge summary
	Properties *ModernChargeSummaryProperties `json:"properties,omitempty"`

	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetChargeSummary implements the ChargeSummaryClassification interface for type ModernChargeSummary.
func (m *ModernChargeSummary) GetChargeSummary() *ChargeSummary {
	return &ChargeSummary{
		Kind: m.Kind,
		ID:   m.ID,
		Name: m.Name,
		Type: m.Type,
		ETag: m.ETag,
	}
}

// ModernChargeSummaryProperties - The properties of modern charge summary.
type ModernChargeSummaryProperties struct {
	// READ-ONLY; Azure Charges.
	AzureCharges *Amount `json:"azureCharges,omitempty" azure:"ro"`

	// READ-ONLY; Billing Account Id
	BillingAccountID *string `json:"billingAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The id of the billing period resource that the charge belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty" azure:"ro"`

	// READ-ONLY; Billing Profile Id
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *Amount `json:"chargesBilledSeparately,omitempty" azure:"ro"`

	// READ-ONLY; Customer Id
	CustomerID *string `json:"customerId,omitempty" azure:"ro"`

	// READ-ONLY; Invoice Section Id
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty" azure:"ro"`

	// READ-ONLY; Is charge Invoiced
	IsInvoiced *bool `json:"isInvoiced,omitempty" azure:"ro"`

	// READ-ONLY; Marketplace Charges.
	MarketplaceCharges *Amount `json:"marketplaceCharges,omitempty" azure:"ro"`

	// READ-ONLY; Usage end date.
	UsageEnd *string `json:"usageEnd,omitempty" azure:"ro"`

	// READ-ONLY; Usage start date.
	UsageStart *string `json:"usageStart,omitempty" azure:"ro"`
}

// ModernReservationRecommendation - Modern reservation recommendation.
type ModernReservationRecommendation struct {
	// REQUIRED; Specifies the kind of reservation recommendation.
	Kind *ReservationRecommendationKind `json:"kind,omitempty"`

	// REQUIRED; Properties for modern reservation recommendation
	Properties *ModernReservationRecommendationProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource sku
	SKU *string `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetReservationRecommendation implements the ReservationRecommendationClassification interface for type ModernReservationRecommendation.
func (m *ModernReservationRecommendation) GetReservationRecommendation() *ReservationRecommendation {
	return &ReservationRecommendation{
		Kind:     m.Kind,
		ID:       m.ID,
		Name:     m.Name,
		Type:     m.Type,
		Etag:     m.Etag,
		Tags:     m.Tags,
		Location: m.Location,
		SKU:      m.SKU,
	}
}

// ModernReservationRecommendationProperties - The properties of the reservation recommendation.
type ModernReservationRecommendationProperties struct {
	// READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *Amount `json:"costWithNoReservedInstances,omitempty" azure:"ro"`

	// READ-ONLY; The usage date for looking back.
	FirstUsageDate *time.Time `json:"firstUsageDate,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string `json:"instanceFlexibilityGroup,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float32 `json:"instanceFlexibilityRatio,omitempty" azure:"ro"`

	// READ-ONLY; Resource Location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *int32 `json:"lookBackPeriod,omitempty" azure:"ro"`

	// READ-ONLY; The meter id (GUID)
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *Amount `json:"netSavings,omitempty" azure:"ro"`

	// READ-ONLY; The normalized Size.
	NormalizedSize *string `json:"normalizedSize,omitempty" azure:"ro"`

	// READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *float64 `json:"recommendedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float32 `json:"recommendedQuantityNormalized,omitempty" azure:"ro"`

	// READ-ONLY; This is the ARM Sku name.
	SKUName *string `json:"skuName,omitempty" azure:"ro"`

	// READ-ONLY; List of sku properties
	SKUProperties []*SKUProperty `json:"skuProperties,omitempty" azure:"ro"`

	// READ-ONLY; Shared or single recommendation.
	Scope *string `json:"scope,omitempty" azure:"ro"`

	// READ-ONLY; RI recommendations in one or three year terms.
	Term *string `json:"term,omitempty" azure:"ro"`

	// READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *Amount `json:"totalCostWithReservedInstances,omitempty" azure:"ro"`
}

// ModernReservationTransaction - Modern Reservation transaction resource.
type ModernReservationTransaction struct {
	// REQUIRED; The properties of a modern reservation transaction.
	Properties *ModernReservationTransactionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags []*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ModernReservationTransactionProperties - The properties of a modern reservation transaction.
type ModernReservationTransactionProperties struct {
	// READ-ONLY; The charge of the transaction.
	Amount *float64 `json:"amount,omitempty" azure:"ro"`

	// READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	ArmSKUName *string `json:"armSkuName,omitempty" azure:"ro"`

	// READ-ONLY; The billing frequency, which can be either one-time or recurring.
	BillingFrequency *string `json:"billingFrequency,omitempty" azure:"ro"`

	// READ-ONLY; Billing profile Id.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; Billing profile name.
	BillingProfileName *string `json:"billingProfileName,omitempty" azure:"ro"`

	// READ-ONLY; The ISO currency in which the transaction is charged, for example, USD.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; The description of the transaction.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The date of the transaction
	EventDate *time.Time `json:"eventDate,omitempty" azure:"ro"`

	// READ-ONLY; The type of the transaction (Purchase, Cancel, etc.)
	EventType *string `json:"eventType,omitempty" azure:"ro"`

	// READ-ONLY; Invoice Number
	Invoice *string `json:"invoice,omitempty" azure:"ro"`

	// READ-ONLY; Invoice Id as on the invoice where the specific transaction appears.
	InvoiceID *string `json:"invoiceId,omitempty" azure:"ro"`

	// READ-ONLY; Invoice Section Id
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty" azure:"ro"`

	// READ-ONLY; Invoice Section Name.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty" azure:"ro"`

	// READ-ONLY; The subscription guid that makes the transaction.
	PurchasingSubscriptionGUID *string `json:"purchasingSubscriptionGuid,omitempty" azure:"ro"`

	// READ-ONLY; The subscription name that makes the transaction.
	PurchasingSubscriptionName *string `json:"purchasingSubscriptionName,omitempty" azure:"ro"`

	// READ-ONLY; The quantity of the transaction.
	Quantity *float64 `json:"quantity,omitempty" azure:"ro"`

	// READ-ONLY; The region of the transaction.
	Region *string `json:"region,omitempty" azure:"ro"`

	// READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents
	// a single purchase transaction. A reservation order contains reservations. The reservation
	// order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the reservation order.
	ReservationOrderName *string `json:"reservationOrderName,omitempty" azure:"ro"`

	// READ-ONLY; This is the term of the transaction.
	Term *string `json:"term,omitempty" azure:"ro"`
}

// ModernReservationTransactionsListResult - Result of listing reservation recommendations.
type ModernReservationTransactionsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of reservation recommendations.
	Value []*ModernReservationTransaction `json:"value,omitempty" azure:"ro"`
}

// ModernUsageDetail - Modern usage detail.
type ModernUsageDetail struct {
	// REQUIRED; Specifies the kind of usage details.
	Kind *UsageDetailsKind `json:"kind,omitempty"`

	// REQUIRED; Properties for modern usage details
	Properties *ModernUsageDetailProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetUsageDetail implements the UsageDetailClassification interface for type ModernUsageDetail.
func (m *ModernUsageDetail) GetUsageDetail() *UsageDetail {
	return &UsageDetail{
		Kind: m.Kind,
		ID:   m.ID,
		Name: m.Name,
		Type: m.Type,
		Etag: m.Etag,
		Tags: m.Tags,
	}
}

// ModernUsageDetailProperties - The properties of the usage detail.
type ModernUsageDetailProperties struct {
	// READ-ONLY; Additional details of this usage item. Use this field to get usage line item specific details such as the actual
	// VM Size (ServiceType) or the ratio in which the reservation discount is applied.
	AdditionalInfo *string `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; Unique identifier for the applicable benefit.
	BenefitID *string `json:"benefitId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the applicable benefit.
	BenefitName *string `json:"benefitName,omitempty" azure:"ro"`

	// READ-ONLY; Billing Account identifier.
	BillingAccountID *string `json:"billingAccountId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the Billing Account.
	BillingAccountName *string `json:"billingAccountName,omitempty" azure:"ro"`

	// READ-ONLY; The currency defining the billed cost.
	BillingCurrencyCode *string `json:"billingCurrencyCode,omitempty" azure:"ro"`

	// READ-ONLY; Billing Period End Date as in the invoice.
	BillingPeriodEndDate *time.Time `json:"billingPeriodEndDate,omitempty" azure:"ro"`

	// READ-ONLY; Billing Period Start Date as in the invoice.
	BillingPeriodStartDate *time.Time `json:"billingPeriodStartDate,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for the billing profile that groups costs across invoices in the a singular billing currency across
	// across the customers who have onboarded the Microsoft customer agreement and the
	// customers in CSP who have made entitlement purchases like SaaS, Marketplace, RI, etc.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the billing profile that groups costs across invoices in the a singular billing currency across across
	// the customers who have onboarded the Microsoft customer agreement and the customers in
	// CSP who have made entitlement purchases like SaaS, Marketplace, RI, etc.
	BillingProfileName *string `json:"billingProfileName,omitempty" azure:"ro"`

	// READ-ONLY; Indicates a charge represents credits, usage, a Marketplace purchase, a reservation fee, or a refund.
	ChargeType *string `json:"chargeType,omitempty" azure:"ro"`

	// READ-ONLY; Consumed service name. Name of the azure resource provider that emits the usage or was purchased. This value
	// is not provided for marketplace usage.
	ConsumedService *string `json:"consumedService,omitempty" azure:"ro"`

	// READ-ONLY; Name for Cost Allocation Rule.
	CostAllocationRuleName *string `json:"costAllocationRuleName,omitempty" azure:"ro"`

	// READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string `json:"costCenter,omitempty" azure:"ro"`

	// READ-ONLY; ExtendedCost or blended cost before tax in billed currency.
	CostInBillingCurrency *float64 `json:"costInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; ExtendedCost or blended cost before tax in pricing currency to correlate with prices.
	CostInPricingCurrency *float64 `json:"costInPricingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; Estimated extendedCost or blended cost before tax in USD.
	CostInUSD *float64 `json:"costInUSD,omitempty" azure:"ro"`

	// READ-ONLY; Name of the customer's AAD tenant.
	CustomerName *string `json:"customerName,omitempty" azure:"ro"`

	// READ-ONLY; Identifier of the customer's AAD tenant.
	CustomerTenantID *string `json:"customerTenantId,omitempty" azure:"ro"`

	// READ-ONLY; Date for the usage record.
	Date *time.Time `json:"date,omitempty" azure:"ro"`

	// READ-ONLY; Effective Price that's charged for the usage.
	EffectivePrice *float64 `json:"effectivePrice,omitempty" azure:"ro"`

	// READ-ONLY; Exchange rate used in conversion from pricing currency to billing currency.
	ExchangeRate *string `json:"exchangeRate,omitempty" azure:"ro"`

	// READ-ONLY; Date on which exchange rate used in conversion from pricing currency to billing currency.
	ExchangeRateDate *time.Time `json:"exchangeRateDate,omitempty" azure:"ro"`

	// READ-ONLY; Exchange Rate from pricing currency to billing currency.
	ExchangeRatePricingToBilling *float64 `json:"exchangeRatePricingToBilling,omitempty" azure:"ro"`

	// READ-ONLY; Indicates how frequently this charge will occur. OneTime for purchases which only happen once, Monthly for fees
	// which recur every month, and UsageBased for charges based on how much a service is used.
	Frequency *string `json:"frequency,omitempty" azure:"ro"`

	// READ-ONLY; Instance Name.
	InstanceName *string `json:"instanceName,omitempty" azure:"ro"`

	// READ-ONLY; Invoice ID as on the invoice where the specific transaction appears.
	InvoiceID *string `json:"invoiceId,omitempty" azure:"ro"`

	// READ-ONLY; Identifier of the project that is being charged in the invoice. Not applicable for Microsoft Customer Agreements
	// onboarded by partners.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the project that is being charged in the invoice. Not applicable for Microsoft Customer Agreements onboarded
	// by partners.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty" azure:"ro"`

	// READ-ONLY; Determines if the cost is eligible to be paid for using Azure credits.
	IsAzureCreditEligible *bool `json:"isAzureCreditEligible,omitempty" azure:"ro"`

	// READ-ONLY; Market Price that's charged for the usage.
	MarketPrice *float64 `json:"marketPrice,omitempty" azure:"ro"`

	// READ-ONLY; Identifies the top-level service for the usage.
	MeterCategory *string `json:"meterCategory,omitempty" azure:"ro"`

	// READ-ONLY; The meter id (GUID). Not available for marketplace. For reserved instance this represents the primary meter
	// for which the reservation was purchased. For the actual VM Size for which the reservation is
	// purchased see productOrderName.
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; Identifies the name of the meter against which consumption is measured.
	MeterName *string `json:"meterName,omitempty" azure:"ro"`

	// READ-ONLY; Identifies the location of the datacenter for certain services that are priced based on datacenter location.
	MeterRegion *string `json:"meterRegion,omitempty" azure:"ro"`

	// READ-ONLY; Defines the type or sub-category of Azure service that can affect the rate.
	MeterSubCategory *string `json:"meterSubCategory,omitempty" azure:"ro"`

	// READ-ONLY; Flag to indicate if partner earned credit has been applied or not.
	PartnerEarnedCreditApplied *string `json:"partnerEarnedCreditApplied,omitempty" azure:"ro"`

	// READ-ONLY; Rate of discount applied if there is a partner earned credit (PEC) based on partner admin link access.
	PartnerEarnedCreditRate *float64 `json:"partnerEarnedCreditRate,omitempty" azure:"ro"`

	// READ-ONLY; Name of the partner' AAD tenant.
	PartnerName *string `json:"partnerName,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for the partner's AAD tenant.
	PartnerTenantID *string `json:"partnerTenantId,omitempty" azure:"ro"`

	// READ-ONLY; Retail price for the resource.
	PayGPrice *float64 `json:"payGPrice,omitempty" azure:"ro"`

	// READ-ONLY; The amount of PayG cost before tax in billing currency.
	PaygCostInBillingCurrency *float64 `json:"paygCostInBillingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The amount of PayG cost before tax in US Dollar currency.
	PaygCostInUSD *float64 `json:"paygCostInUSD,omitempty" azure:"ro"`

	// READ-ONLY; Reference to an original invoice there is a refund (negative cost). This is populated only when there is a refund.
	PreviousInvoiceID *string `json:"previousInvoiceId,omitempty" azure:"ro"`

	// READ-ONLY; Pricing Billing Currency.
	PricingCurrencyCode *string `json:"pricingCurrencyCode,omitempty" azure:"ro"`

	// READ-ONLY; Identifier that indicates how the meter is priced
	PricingModel *PricingModelType `json:"pricingModel,omitempty" azure:"ro"`

	// READ-ONLY; Name of the product that has accrued charges by consumption or purchase as listed in the invoice. Not available
	// for Marketplace.
	Product *string `json:"product,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for the product that has accrued charges by consumption or purchase . This is the concatenated key
	// of productId and SkuId in partner center.
	ProductIdentifier *string `json:"productIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; The identifier for the asset or Azure plan name that the subscription belongs to. For example: Azure Plan. For
	// reservations this is the Reservation Order ID.
	ProductOrderID *string `json:"productOrderId,omitempty" azure:"ro"`

	// READ-ONLY; Product Order Name. For reservations this is the SKU that was purchased.
	ProductOrderName *string `json:"productOrderName,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for Product Category or Line Of Business, Ex - Azure, Microsoft 365, AWS e.t.c
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Publisher Id.
	PublisherID *string `json:"publisherId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the publisher of the service including Microsoft or Third Party publishers.
	PublisherName *string `json:"publisherName,omitempty" azure:"ro"`

	// READ-ONLY; Type of publisher that identifies if the publisher is first party, third party reseller or third party agency.
	PublisherType *string `json:"publisherType,omitempty" azure:"ro"`

	// READ-ONLY; Measure the quantity purchased or consumed.The amount of the meter used during the billing period.
	Quantity *float64 `json:"quantity,omitempty" azure:"ro"`

	// READ-ONLY; MPNId for the reseller associated with the subscription.
	ResellerMpnID *string `json:"resellerMpnId,omitempty" azure:"ro"`

	// READ-ONLY; Reseller Name.
	ResellerName *string `json:"resellerName,omitempty" azure:"ro"`

	// READ-ONLY; ARM resource id of the reservation. Only applies to records relevant to reservations.
	ReservationID *string `json:"reservationId,omitempty" azure:"ro"`

	// READ-ONLY; User provided display name of the reservation. Last known name for a particular day is populated in the daily
	// data. Only applies to records relevant to reservations.
	ReservationName *string `json:"reservationName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the Azure resource group used for cohesive lifecycle management of resources.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource location.
	ResourceLocation *string `json:"resourceLocation,omitempty" azure:"ro"`

	// READ-ONLY; Resource Location Normalized.
	ResourceLocationNormalized *string `json:"resourceLocationNormalized,omitempty" azure:"ro"`

	// READ-ONLY; List the service family for the product purchased or charged (Example: Storage ; Compute).
	ServiceFamily *string `json:"serviceFamily,omitempty" azure:"ro"`

	// READ-ONLY; Service-specific metadata.
	ServiceInfo1 *string `json:"serviceInfo1,omitempty" azure:"ro"`

	// READ-ONLY; Legacy field with optional service-specific metadata.
	ServiceInfo2 *string `json:"serviceInfo2,omitempty" azure:"ro"`

	// READ-ONLY; End date for the period when the service usage was rated for charges. The prices for Azure services are determined
	// based on the rating period.
	ServicePeriodEndDate *time.Time `json:"servicePeriodEndDate,omitempty" azure:"ro"`

	// READ-ONLY; Start date for the rating period when the service usage was rated for charges. The prices for Azure services
	// are determined for the rating period.
	ServicePeriodStartDate *time.Time `json:"servicePeriodStartDate,omitempty" azure:"ro"`

	// READ-ONLY; Unique Microsoft generated identifier for the Azure Subscription.
	SubscriptionGUID *string `json:"subscriptionGuid,omitempty" azure:"ro"`

	// READ-ONLY; Name of the Azure Subscription.
	SubscriptionName *string `json:"subscriptionName,omitempty" azure:"ro"`

	// READ-ONLY; Term (in months). Displays the term for the validity of the offer. For example. In case of reserved instances
	// it displays 12 months for yearly term of reserved instance. For one time purchases or
	// recurring purchases, the terms displays 1 month; This is not applicable for Azure consumption.
	Term *string `json:"term,omitempty" azure:"ro"`

	// READ-ONLY; Identifies the Unit that the service is charged in. For example, GB, hours, 10,000 s.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty" azure:"ro"`

	// READ-ONLY; Unit Price is the price applicable to you. (your EA or other contract price).
	UnitPrice *float64 `json:"unitPrice,omitempty" azure:"ro"`
}

// Notification - The notification associated with a budget.
type Notification struct {
	// REQUIRED; Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact
	// email or contact group specified at the Subscription or Resource Group scopes. All
	// other scopes must have at least one contact email specified.
	ContactEmails []*string `json:"contactEmails,omitempty"`

	// REQUIRED; The notification is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; The comparison operator.
	Operator *OperatorType `json:"operator,omitempty"`

	// REQUIRED; Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It
	// is always percent and has to be between 0 and 1000.
	Threshold *float64 `json:"threshold,omitempty"`

	// Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified
	// Azure resource id. Only supported at Subscription or Resource Group scopes.
	ContactGroups []*string `json:"contactGroups,omitempty"`

	// Contact roles to send the budget notification to when the threshold is exceeded.
	ContactRoles []*string `json:"contactRoles,omitempty"`

	// Language in which the recipient will receive the notification
	Locale *CultureCode `json:"locale,omitempty"`

	// The type of threshold
	ThresholdType *ThresholdType `json:"thresholdType,omitempty"`
}

// Operation - A Consumption REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Operation Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.Consumption.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed: UsageDetail, etc.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of listing consumption operations. It contains a list of operations and a URL link to get
// the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of consumption operations supported by the Microsoft.Consumption resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PriceSheetClientGetByBillingPeriodOptions contains the optional parameters for the PriceSheetClient.GetByBillingPeriod
// method.
type PriceSheetClientGetByBillingPeriodOptions struct {
	// May be used to expand the properties/meterDetails within a price sheet. By default, these fields are not included when
	// returning price sheet.
	Expand *string
	// Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skiptoken parameter that
	// specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// May be used to limit the number of results to the top N results.
	Top *int32
}

// PriceSheetClientGetOptions contains the optional parameters for the PriceSheetClient.Get method.
type PriceSheetClientGetOptions struct {
	// May be used to expand the properties/meterDetails within a price sheet. By default, these fields are not included when
	// returning price sheet.
	Expand *string
	// Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skiptoken parameter that
	// specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// May be used to limit the number of results to the top N results.
	Top *int32
}

// PriceSheetModel - price sheet result. It contains the pricesheet associated with billing period
type PriceSheetModel struct {
	// READ-ONLY; Pricesheet download details.
	Download *MeterDetails `json:"download,omitempty" azure:"ro"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Price sheet
	Pricesheets []*PriceSheetProperties `json:"pricesheets,omitempty" azure:"ro"`
}

// PriceSheetProperties - The properties of the price sheet.
type PriceSheetProperties struct {
	// READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty" azure:"ro"`

	// READ-ONLY; Currency Code
	CurrencyCode *string `json:"currencyCode,omitempty" azure:"ro"`

	// READ-ONLY; Included quality for an offer
	IncludedQuantity *float64 `json:"includedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; The details about the meter. By default this is not populated, unless it's specified in $expand.
	MeterDetails *MeterDetails `json:"meterDetails,omitempty" azure:"ro"`

	// READ-ONLY; The meter id (GUID)
	MeterID *string `json:"meterId,omitempty" azure:"ro"`

	// READ-ONLY; Offer Id
	OfferID *string `json:"offerId,omitempty" azure:"ro"`

	// READ-ONLY; Part Number
	PartNumber *string `json:"partNumber,omitempty" azure:"ro"`

	// READ-ONLY; Unit of measure
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty" azure:"ro"`

	// READ-ONLY; Unit Price
	UnitPrice *float64 `json:"unitPrice,omitempty" azure:"ro"`
}

// PriceSheetResult - An pricesheet resource.
type PriceSheetResult struct {
	// price sheet result. It contains the pricesheet associated with billing period
	Properties *PriceSheetModel `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProxyResource - The Resource model definition.
type ProxyResource struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Reseller - The reseller properties.
type Reseller struct {
	// READ-ONLY; The reseller property description.
	ResellerDescription *string `json:"resellerDescription,omitempty" azure:"ro"`

	// READ-ONLY; The reseller property ID.
	ResellerID *string `json:"resellerId,omitempty" azure:"ro"`
}

// ReservationDetail - reservation detail resource.
type ReservationDetail struct {
	// The properties of the reservation detail.
	Properties *ReservationDetailProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReservationDetailProperties - The properties of the reservation detail.
type ReservationDetailProperties struct {
	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string `json:"instanceFlexibilityGroup,omitempty" azure:"ro"`

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *string `json:"instanceFlexibilityRatio,omitempty" azure:"ro"`

	// READ-ONLY; This identifier is the name of the resource or the fully qualified Resource ID.
	InstanceID *string `json:"instanceId,omitempty" azure:"ro"`

	// READ-ONLY; The reservation kind.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping
	// for applying the benefit scope and also specifies the number of instances to which
	// the reservation benefit can be applied to.
	ReservationID *string `json:"reservationId,omitempty" azure:"ro"`

	// READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents
	// a single purchase transaction. A reservation order contains reservations. The reservation
	// order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty" azure:"ro"`

	// READ-ONLY; This is the total hours reserved for the day. E.g. if reservation for 1 instance was made on 1 PM, this will
	// be 11 hours for that day and 24 hours from subsequent days.
	ReservedHours *float64 `json:"reservedHours,omitempty" azure:"ro"`

	// READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	SKUName *string `json:"skuName,omitempty" azure:"ro"`

	// READ-ONLY; This is the total count of instances that are reserved for the reservationId.
	TotalReservedQuantity *float64 `json:"totalReservedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; The date on which consumption occurred.
	UsageDate *time.Time `json:"usageDate,omitempty" azure:"ro"`

	// READ-ONLY; This is the total hours used by the instance.
	UsedHours *float64 `json:"usedHours,omitempty" azure:"ro"`
}

// ReservationDetailsListResult - Result of listing reservation details.
type ReservationDetailsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of reservation details.
	Value []*ReservationDetail `json:"value,omitempty" azure:"ro"`
}

// ReservationRecommendationClassification provides polymorphic access to related types.
// Call the interface's GetReservationRecommendation() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LegacyReservationRecommendation, *ModernReservationRecommendation, *ReservationRecommendation
type ReservationRecommendationClassification interface {
	// GetReservationRecommendation returns the ReservationRecommendation content of the underlying type.
	GetReservationRecommendation() *ReservationRecommendation
}

// ReservationRecommendation - A reservation recommendation resource.
type ReservationRecommendation struct {
	// REQUIRED; Specifies the kind of reservation recommendation.
	Kind *ReservationRecommendationKind `json:"kind,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource sku
	SKU *string `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetReservationRecommendation implements the ReservationRecommendationClassification interface for type ReservationRecommendation.
func (r *ReservationRecommendation) GetReservationRecommendation() *ReservationRecommendation {
	return r
}

// ReservationRecommendationDetailsCalculatedSavingsProperties - Details of estimated savings.
type ReservationRecommendationDetailsCalculatedSavingsProperties struct {
	// The number of reserved units used to calculate savings. Always 1 for virtual machines.
	ReservedUnitCount *float32 `json:"reservedUnitCount,omitempty"`

	// READ-ONLY; The cost without reservation.
	OnDemandCost *float32 `json:"onDemandCost,omitempty" azure:"ro"`

	// READ-ONLY; The difference between total reservation cost and reservation cost.
	OverageCost *float32 `json:"overageCost,omitempty" azure:"ro"`

	// READ-ONLY; The quantity for calculated savings.
	Quantity *float32 `json:"quantity,omitempty" azure:"ro"`

	// READ-ONLY; The exact cost of the estimated usage using reservation.
	ReservationCost *float32 `json:"reservationCost,omitempty" azure:"ro"`

	// READ-ONLY; The amount saved by purchasing the recommended quantity of reservation.
	Savings *float32 `json:"savings,omitempty" azure:"ro"`

	// READ-ONLY; The cost of the suggested quantity.
	TotalReservationCost *float32 `json:"totalReservationCost,omitempty" azure:"ro"`
}

// ReservationRecommendationDetailsClientGetOptions contains the optional parameters for the ReservationRecommendationDetailsClient.Get
// method.
type ReservationRecommendationDetailsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReservationRecommendationDetailsModel - Reservation recommendation details.
type ReservationRecommendationDetailsModel struct {
	// Resource Location.
	Location *string `json:"location,omitempty"`

	// The properties of the reservation recommendation.
	Properties *ReservationRecommendationDetailsProperties `json:"properties,omitempty"`

	// Resource sku
	SKU *string `json:"sku,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReservationRecommendationDetailsProperties - The properties of the reservation recommendation.
type ReservationRecommendationDetailsProperties struct {
	// READ-ONLY; An ISO 4217 currency code identifier for the costs and savings
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; Resource specific properties.
	Resource *ReservationRecommendationDetailsResourceProperties `json:"resource,omitempty" azure:"ro"`

	// READ-ONLY; Resource Group.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Savings information for the recommendation.
	Savings *ReservationRecommendationDetailsSavingsProperties `json:"savings,omitempty" azure:"ro"`

	// READ-ONLY; Scope of the reservation, ex: Single or Shared.
	Scope *string `json:"scope,omitempty" azure:"ro"`

	// READ-ONLY; Historical usage details used to calculate the estimated savings.
	Usage *ReservationRecommendationDetailsUsageProperties `json:"usage,omitempty" azure:"ro"`
}

// ReservationRecommendationDetailsResourceProperties - Details of the resource.
type ReservationRecommendationDetailsResourceProperties struct {
	// READ-ONLY; List of subscriptions for which the reservation is applied.
	AppliedScopes []*string `json:"appliedScopes,omitempty" azure:"ro"`

	// READ-ONLY; On demand rate of the resource.
	OnDemandRate *float32 `json:"onDemandRate,omitempty" azure:"ro"`

	// READ-ONLY; Azure product ex: StandardE8sv3 etc.
	Product *string `json:"product,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource region ex:EastUS, WestUS etc.
	Region *string `json:"region,omitempty" azure:"ro"`

	// READ-ONLY; Reservation rate of the resource.
	ReservationRate *float32 `json:"reservationRate,omitempty" azure:"ro"`

	// READ-ONLY; The azure resource type.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`
}

// ReservationRecommendationDetailsSavingsProperties - Details of the estimated savings.
type ReservationRecommendationDetailsSavingsProperties struct {
	// List of calculated savings.
	CalculatedSavings []*ReservationRecommendationDetailsCalculatedSavingsProperties `json:"calculatedSavings,omitempty"`

	// READ-ONLY; Number of days of usage to look back used for computing the recommendation.
	LookBackPeriod *int32 `json:"lookBackPeriod,omitempty" azure:"ro"`

	// READ-ONLY; Number of recommended units of the resource.
	RecommendedQuantity *float32 `json:"recommendedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; Term period of the reservation, ex: P1Y or P3Y.
	ReservationOrderTerm *string `json:"reservationOrderTerm,omitempty" azure:"ro"`

	// READ-ONLY; Type of savings, ex: instance.
	SavingsType *string `json:"savingsType,omitempty" azure:"ro"`

	// READ-ONLY; Measurement unit ex: hour etc.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty" azure:"ro"`
}

// ReservationRecommendationDetailsUsageProperties - Details about historical usage data that has been used for computing
// the recommendation.
type ReservationRecommendationDetailsUsageProperties struct {
	// READ-ONLY; The first usage date used for looking back for computing the recommendation.
	FirstConsumptionDate *string `json:"firstConsumptionDate,omitempty" azure:"ro"`

	// READ-ONLY; The last usage date used for looking back for computing the recommendation.
	LastConsumptionDate *string `json:"lastConsumptionDate,omitempty" azure:"ro"`

	// READ-ONLY; What the usage data values represent ex: virtual machine instance.
	LookBackUnitType *string `json:"lookBackUnitType,omitempty" azure:"ro"`

	// READ-ONLY; The breakdown of historical resource usage. The values are in the order of usage between the firstConsumptionDate
	// and the lastConsumptionDate.
	UsageData []*float32 `json:"usageData,omitempty" azure:"ro"`

	// READ-ONLY; The grain of the values represented in the usage data ex: hourly.
	UsageGrain *string `json:"usageGrain,omitempty" azure:"ro"`
}

// ReservationRecommendationsClientListOptions contains the optional parameters for the ReservationRecommendationsClient.List
// method.
type ReservationRecommendationsClientListOptions struct {
	// May be used to filter reservationRecommendations by: properties/scope with allowed values ['Single', 'Shared'] and default
	// value 'Single'; properties/resourceType with allowed values
	// ['VirtualMachines', 'SQLDatabases', 'PostgreSQL', 'ManagedDisk', 'MySQL', 'RedHat', 'MariaDB', 'RedisCache', 'CosmosDB',
	// 'SqlDataWarehouse', 'SUSELinux', 'AppService', 'BlockBlob',
	// 'AzureDataExplorer', 'VMwareCloudSimple'] and default value 'VirtualMachines'; and properties/lookBackPeriod with allowed
	// values ['Last7Days', 'Last30Days', 'Last60Days'] and default value
	// 'Last7Days'.
	Filter *string
}

// ReservationRecommendationsListResult - Result of listing reservation recommendations.
type ReservationRecommendationsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The link (url) to the previous page of results.
	PreviousLink *string `json:"previousLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of reservation recommendations.
	Value []ReservationRecommendationClassification `json:"value,omitempty" azure:"ro"`
}

// ReservationSummariesListResult - Result of listing reservation summaries.
type ReservationSummariesListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of reservation summaries.
	Value []*ReservationSummary `json:"value,omitempty" azure:"ro"`
}

// ReservationSummary - reservation summary resource.
type ReservationSummary struct {
	// The properties of the reservation summary.
	Properties *ReservationSummaryProperties `json:"properties,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReservationSummaryProperties - The properties of the reservation summary.
type ReservationSummaryProperties struct {
	// READ-ONLY; This is average utilization for the entire time range. (day or month depending on the grain)
	AvgUtilizationPercentage *float64 `json:"avgUtilizationPercentage,omitempty" azure:"ro"`

	// READ-ONLY; The reservation kind.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; This is the maximum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to
	// 12/10/2017 and on that for hour 4 and 5, utilization was 100%, this field will return 100%
	// for that day.
	MaxUtilizationPercentage *float64 `json:"maxUtilizationPercentage,omitempty" azure:"ro"`

	// READ-ONLY; This is the minimum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to
	// 12/10/2017 and on that for hour 4 and 5, utilization was 10%, this field will return 10%
	// for that day
	MinUtilizationPercentage *float64 `json:"minUtilizationPercentage,omitempty" azure:"ro"`

	// READ-ONLY; This is the purchased quantity for the reservationId.
	PurchasedQuantity *float64 `json:"purchasedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; This is the remaining quantity for the reservationId.
	RemainingQuantity *float64 `json:"remainingQuantity,omitempty" azure:"ro"`

	// READ-ONLY; The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping
	// for applying the benefit scope and also specifies the number of instances to which
	// the reservation benefit can be applied to.
	ReservationID *string `json:"reservationId,omitempty" azure:"ro"`

	// READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents
	// a single purchase transaction. A reservation order contains reservations. The reservation
	// order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty" azure:"ro"`

	// READ-ONLY; This is the total hours reserved. E.g. if reservation for 1 instance was made on 1 PM, this will be 11 hours
	// for that day and 24 hours from subsequent days
	ReservedHours *float64 `json:"reservedHours,omitempty" azure:"ro"`

	// READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	SKUName *string `json:"skuName,omitempty" azure:"ro"`

	// READ-ONLY; This is the total count of instances that are reserved for the reservationId.
	TotalReservedQuantity *float64 `json:"totalReservedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; Data corresponding to the utilization record. If the grain of data is monthly, it will be first day of month.
	UsageDate *time.Time `json:"usageDate,omitempty" azure:"ro"`

	// READ-ONLY; Total used hours by the reservation
	UsedHours *float64 `json:"usedHours,omitempty" azure:"ro"`

	// READ-ONLY; This is the used quantity for the reservationId.
	UsedQuantity *float64 `json:"usedQuantity,omitempty" azure:"ro"`

	// READ-ONLY; This is the utilized percentage for the reservation Id.
	UtilizedPercentage *float64 `json:"utilizedPercentage,omitempty" azure:"ro"`
}

// ReservationTransaction - Reservation transaction resource.
type ReservationTransaction struct {
	// The properties of a legacy reservation transaction.
	Properties *LegacyReservationTransactionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags []*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReservationTransactionResource - The Resource model definition.
type ReservationTransactionResource struct {
	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags []*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReservationTransactionsClientListByBillingProfileOptions contains the optional parameters for the ReservationTransactionsClient.ListByBillingProfile
// method.
type ReservationTransactionsClientListByBillingProfileOptions struct {
	// Filter reservation transactions by date range. The properties/EventDate for start date and end date. The filter supports
	// 'le' and 'ge'
	Filter *string
}

// ReservationTransactionsClientListOptions contains the optional parameters for the ReservationTransactionsClient.List method.
type ReservationTransactionsClientListOptions struct {
	// Filter reservation transactions by date range. The properties/EventDate for start date and end date. The filter supports
	// 'le' and 'ge'
	Filter *string
}

// ReservationTransactionsListResult - Result of listing reservation recommendations.
type ReservationTransactionsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of reservation recommendations.
	Value []*ReservationTransaction `json:"value,omitempty" azure:"ro"`
}

// ReservationsDetailsClientListByReservationOrderAndReservationOptions contains the optional parameters for the ReservationsDetailsClient.ListByReservationOrderAndReservation
// method.
type ReservationsDetailsClientListByReservationOrderAndReservationOptions struct {
	// placeholder for future optional parameters
}

// ReservationsDetailsClientListByReservationOrderOptions contains the optional parameters for the ReservationsDetailsClient.ListByReservationOrder
// method.
type ReservationsDetailsClientListByReservationOrderOptions struct {
	// placeholder for future optional parameters
}

// ReservationsDetailsClientListOptions contains the optional parameters for the ReservationsDetailsClient.List method.
type ReservationsDetailsClientListOptions struct {
	// End date. Only applicable when querying with billing profile
	EndDate *string
	// Filter reservation details by date range. The properties/UsageDate for start date and end date. The filter supports 'le'
	// and 'ge'. Not applicable when querying with billing profile
	Filter *string
	// Reservation Id GUID. Only valid if reservationOrderId is also provided. Filter to a specific reservation
	ReservationID *string
	// Reservation Order Id GUID. Required if reservationId is provided. Filter to a specific reservation order
	ReservationOrderID *string
	// Start date. Only applicable when querying with billing profile
	StartDate *string
}

// ReservationsSummariesClientListByReservationOrderAndReservationOptions contains the optional parameters for the ReservationsSummariesClient.ListByReservationOrderAndReservation
// method.
type ReservationsSummariesClientListByReservationOrderAndReservationOptions struct {
	// Required only for daily grain. The properties/UsageDate for start date and end date. The filter supports 'le' and 'ge'
	Filter *string
}

// ReservationsSummariesClientListByReservationOrderOptions contains the optional parameters for the ReservationsSummariesClient.ListByReservationOrder
// method.
type ReservationsSummariesClientListByReservationOrderOptions struct {
	// Required only for daily grain. The properties/UsageDate for start date and end date. The filter supports 'le' and 'ge'
	Filter *string
}

// ReservationsSummariesClientListOptions contains the optional parameters for the ReservationsSummariesClient.List method.
type ReservationsSummariesClientListOptions struct {
	// End date. Only applicable when querying with billing profile
	EndDate *string
	// Required only for daily grain. The properties/UsageDate for start date and end date. The filter supports 'le' and 'ge'.
	// Not applicable when querying with billing profile
	Filter *string
	// Reservation Id GUID. Only valid if reservationOrderId is also provided. Filter to a specific reservation
	ReservationID *string
	// Reservation Order Id GUID. Required if reservationId is provided. Filter to a specific reservation order
	ReservationOrderID *string
	// Start date. Only applicable when querying with billing profile
	StartDate *string
}

// Resource - The Resource model definition.
type Resource struct {
	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceAttributes - The Resource model definition.
type ResourceAttributes struct {
	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource sku
	SKU *string `json:"sku,omitempty" azure:"ro"`
}

// SKUProperty - The Sku property
type SKUProperty struct {
	// READ-ONLY; The name of sku property.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The value of sku property.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// Tag - The tag resource.
type Tag struct {
	// Tag key.
	Key *string `json:"key,omitempty"`

	// Tag values.
	Value []*string `json:"value,omitempty"`
}

// TagProperties - The properties of the tag.
type TagProperties struct {
	// A list of Tag.
	Tags []*Tag `json:"tags,omitempty"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The link (url) to the previous page of results.
	PreviousLink *string `json:"previousLink,omitempty" azure:"ro"`
}

// TagsClientGetOptions contains the optional parameters for the TagsClient.Get method.
type TagsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TagsResult - A resource listing all tags.
type TagsResult struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// The properties of the tag.
	Properties *TagProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UsageDetailClassification provides polymorphic access to related types.
// Call the interface's GetUsageDetail() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LegacyUsageDetail, *ModernUsageDetail, *UsageDetail
type UsageDetailClassification interface {
	// GetUsageDetail returns the UsageDetail content of the underlying type.
	GetUsageDetail() *UsageDetail
}

// UsageDetail - An usage detail resource.
type UsageDetail struct {
	// REQUIRED; Specifies the kind of usage details.
	Kind *UsageDetailsKind `json:"kind,omitempty"`

	// READ-ONLY; The etag for the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetUsageDetail implements the UsageDetailClassification interface for type UsageDetail.
func (u *UsageDetail) GetUsageDetail() *UsageDetail { return u }

// UsageDetailsClientListOptions contains the optional parameters for the UsageDetailsClient.List method.
type UsageDetailsClientListOptions struct {
	// May be used to expand the properties/additionalInfo or properties/meterDetails within a list of usage details. By default,
	// these fields are not included when listing usage details.
	Expand *string
	// May be used to filter usageDetails by properties/resourceGroup, properties/resourceName, properties/resourceId, properties/chargeType,
	// properties/reservationId, properties/publisherType or tags. The
	// filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently support 'ne', 'or', or 'not'. Tag filter
	// is a key value pair string where key and value is separated by a colon (:).
	// PublisherType Filter accepts two values azure and marketplace and it is currently supported for Web Direct Offer Type
	Filter *string
	// Allows to select different type of cost/usage records.
	Metric *Metrictype
	// Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skiptoken parameter that
	// specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// UsageDetailsListResult - Result of listing usage details. It contains a list of available usage details in reverse chronological
// order by billing period.
type UsageDetailsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of usage details.
	Value []UsageDetailClassification `json:"value,omitempty" azure:"ro"`
}
