// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a slot in an intent. A slot is a variable needed to fulfill an intent.
// For example, an OrderPizza intent might need slots for size, crust, and number
// of pizzas. For each slot, you define one or more utterances that Amazon Lex uses
// to elicit a response from the user.
func (c *Client) CreateSlot(ctx context.Context, params *CreateSlotInput, optFns ...func(*Options)) (*CreateSlotOutput, error) {
	if params == nil {
		params = &CreateSlotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateSlot", params, optFns, c.addOperationCreateSlotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateSlotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateSlotInput struct {

	// The identifier of the bot associated with the slot.
	//
	// This member is required.
	BotId *string

	// The version of the bot associated with the slot.
	//
	// This member is required.
	BotVersion *string

	// The identifier of the intent that contains the slot.
	//
	// This member is required.
	IntentId *string

	// The identifier of the language and locale that the slot will be used in. The
	// string must match one of the supported locales. All of the bots, intents, slot
	// types used by the slot must have the same locale. For more information, see
	// Supported languages
	// (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// This member is required.
	LocaleId *string

	// The name of the slot. Slot names must be unique within the bot that contains the
	// slot.
	//
	// This member is required.
	SlotName *string

	// Specifies prompts that Amazon Lex sends to the user to elicit a response that
	// provides the value for the slot.
	//
	// This member is required.
	ValueElicitationSetting *types.SlotValueElicitationSetting

	// A description of the slot. Use this to help identify the slot in lists.
	Description *string

	// Indicates whether the slot returns multiple values in one response. Multi-value
	// slots are only available in the en-US locale. If you set this value to true in
	// any other locale, Amazon Lex throws a ValidationException. If the
	// multipleValuesSetting is not set, the default value is false.
	MultipleValuesSetting *types.MultipleValuesSetting

	// Determines how slot values are used in Amazon CloudWatch logs. If the value of
	// the obfuscationSetting parameter is DefaultObfuscation, slot values are
	// obfuscated in the log output. If the value is None, the actual value is present
	// in the log output. The default is to obfuscate values in the CloudWatch logs.
	ObfuscationSetting *types.ObfuscationSetting

	// The unique identifier for the slot type associated with this slot. The slot type
	// determines the values that can be entered into the slot.
	SlotTypeId *string

	noSmithyDocumentSerde
}

type CreateSlotOutput struct {

	// The unique identifier of the bot associated with the slot.
	BotId *string

	// The version of the bot associated with the slot.
	BotVersion *string

	// The timestamp of the date and time that the slot was created.
	CreationDateTime *time.Time

	// The description associated with the slot.
	Description *string

	// The unique identifier of the intent associated with the slot.
	IntentId *string

	// The language and local specified for the slot.
	LocaleId *string

	// Indicates whether the slot returns multiple values in one response.
	MultipleValuesSetting *types.MultipleValuesSetting

	// Indicates whether the slot is configured to obfuscate values in Amazon
	// CloudWatch logs.
	ObfuscationSetting *types.ObfuscationSetting

	// The unique identifier associated with the slot. Use this to identify the slot
	// when you update or delete it.
	SlotId *string

	// The name specified for the slot.
	SlotName *string

	// The unique identifier of the slot type associated with this slot.
	SlotTypeId *string

	// The value elicitation settings specified for the slot.
	ValueElicitationSetting *types.SlotValueElicitationSetting

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateSlotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateSlot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateSlot{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateSlotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateSlot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateSlot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lex",
		OperationName: "CreateSlot",
	}
}
