// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates a conformance pack. A conformance pack is a collection of
// Config rules that can be easily deployed in an account and a region and across
// Amazon Web Services Organization. For information on how many conformance packs
// you can have per account, see  Service Limits
// (https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html) in
// the Config Developer Guide. This API creates a service-linked role
// AWSServiceRoleForConfigConforms in your account. The service-linked role is
// created only when the role does not exist in your account. You must specify
// either the TemplateS3Uri or the TemplateBody parameter, but not both. If you
// provide both Config uses the TemplateS3Uri parameter and ignores the
// TemplateBody parameter.
func (c *Client) PutConformancePack(ctx context.Context, params *PutConformancePackInput, optFns ...func(*Options)) (*PutConformancePackOutput, error) {
	if params == nil {
		params = &PutConformancePackInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutConformancePack", params, optFns, c.addOperationPutConformancePackMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutConformancePackOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutConformancePackInput struct {

	// Name of the conformance pack you want to create.
	//
	// This member is required.
	ConformancePackName *string

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []types.ConformancePackInputParameter

	// The name of the Amazon S3 bucket where Config stores conformance pack templates.
	// This field is optional.
	DeliveryS3Bucket *string

	// The prefix for the Amazon S3 bucket. This field is optional.
	DeliveryS3KeyPrefix *string

	// A string containing full conformance pack template body. Structure containing
	// the template body with a minimum length of 1 byte and a maximum length of 51,200
	// bytes. You can only use a YAML template with two resource types: Config rule
	// (AWS::Config::ConfigRule) and a remediation action
	// (AWS::Config::RemediationConfiguration).
	TemplateBody *string

	// Location of file containing the template body (s3://bucketname/prefix). The uri
	// must point to the conformance pack template (max size: 300 KB) that is located
	// in an Amazon S3 bucket in the same region as the conformance pack. You must have
	// access to read Amazon S3 bucket.
	TemplateS3Uri *string

	noSmithyDocumentSerde
}

type PutConformancePackOutput struct {

	// ARN of the conformance pack.
	ConformancePackArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutConformancePackMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPutConformancePack{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPutConformancePack{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutConformancePackValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutConformancePack(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutConformancePack(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "config",
		OperationName: "PutConformancePack",
	}
}
