// Code generated by smithy-go-codegen DO NOT EDIT.

package appmesh

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/appmesh/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateGatewayRoute struct {
}

func (*validateOpCreateGatewayRoute) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateGatewayRoute) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateGatewayRouteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateGatewayRouteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateMesh struct {
}

func (*validateOpCreateMesh) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateMesh) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateMeshInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateMeshInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateRoute struct {
}

func (*validateOpCreateRoute) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateRoute) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateRouteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateRouteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVirtualGateway struct {
}

func (*validateOpCreateVirtualGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVirtualGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVirtualGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVirtualGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVirtualNode struct {
}

func (*validateOpCreateVirtualNode) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVirtualNode) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVirtualNodeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVirtualNodeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVirtualRouter struct {
}

func (*validateOpCreateVirtualRouter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVirtualRouter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVirtualRouterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVirtualRouterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVirtualService struct {
}

func (*validateOpCreateVirtualService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVirtualService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVirtualServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVirtualServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteGatewayRoute struct {
}

func (*validateOpDeleteGatewayRoute) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteGatewayRoute) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteGatewayRouteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteGatewayRouteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteMesh struct {
}

func (*validateOpDeleteMesh) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteMesh) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteMeshInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteMeshInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteRoute struct {
}

func (*validateOpDeleteRoute) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteRoute) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteRouteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteRouteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVirtualGateway struct {
}

func (*validateOpDeleteVirtualGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVirtualGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVirtualGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVirtualGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVirtualNode struct {
}

func (*validateOpDeleteVirtualNode) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVirtualNode) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVirtualNodeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVirtualNodeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVirtualRouter struct {
}

func (*validateOpDeleteVirtualRouter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVirtualRouter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVirtualRouterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVirtualRouterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVirtualService struct {
}

func (*validateOpDeleteVirtualService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVirtualService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVirtualServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVirtualServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeGatewayRoute struct {
}

func (*validateOpDescribeGatewayRoute) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeGatewayRoute) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeGatewayRouteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeGatewayRouteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeMesh struct {
}

func (*validateOpDescribeMesh) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeMesh) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeMeshInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeMeshInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeRoute struct {
}

func (*validateOpDescribeRoute) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeRoute) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeRouteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeRouteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeVirtualGateway struct {
}

func (*validateOpDescribeVirtualGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeVirtualGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeVirtualGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeVirtualGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeVirtualNode struct {
}

func (*validateOpDescribeVirtualNode) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeVirtualNode) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeVirtualNodeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeVirtualNodeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeVirtualRouter struct {
}

func (*validateOpDescribeVirtualRouter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeVirtualRouter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeVirtualRouterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeVirtualRouterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeVirtualService struct {
}

func (*validateOpDescribeVirtualService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeVirtualService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeVirtualServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeVirtualServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListGatewayRoutes struct {
}

func (*validateOpListGatewayRoutes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListGatewayRoutes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListGatewayRoutesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListGatewayRoutesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListRoutes struct {
}

func (*validateOpListRoutes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListRoutes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListRoutesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListRoutesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListVirtualGateways struct {
}

func (*validateOpListVirtualGateways) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListVirtualGateways) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListVirtualGatewaysInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListVirtualGatewaysInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListVirtualNodes struct {
}

func (*validateOpListVirtualNodes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListVirtualNodes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListVirtualNodesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListVirtualNodesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListVirtualRouters struct {
}

func (*validateOpListVirtualRouters) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListVirtualRouters) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListVirtualRoutersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListVirtualRoutersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListVirtualServices struct {
}

func (*validateOpListVirtualServices) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListVirtualServices) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListVirtualServicesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListVirtualServicesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateGatewayRoute struct {
}

func (*validateOpUpdateGatewayRoute) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateGatewayRoute) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateGatewayRouteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateGatewayRouteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateMesh struct {
}

func (*validateOpUpdateMesh) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateMesh) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateMeshInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateMeshInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateRoute struct {
}

func (*validateOpUpdateRoute) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateRoute) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateRouteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateRouteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateVirtualGateway struct {
}

func (*validateOpUpdateVirtualGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateVirtualGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateVirtualGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateVirtualGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateVirtualNode struct {
}

func (*validateOpUpdateVirtualNode) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateVirtualNode) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateVirtualNodeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateVirtualNodeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateVirtualRouter struct {
}

func (*validateOpUpdateVirtualRouter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateVirtualRouter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateVirtualRouterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateVirtualRouterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateVirtualService struct {
}

func (*validateOpUpdateVirtualService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateVirtualService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateVirtualServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateVirtualServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateGatewayRouteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateGatewayRoute{}, middleware.After)
}

func addOpCreateMeshValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateMesh{}, middleware.After)
}

func addOpCreateRouteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateRoute{}, middleware.After)
}

func addOpCreateVirtualGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVirtualGateway{}, middleware.After)
}

func addOpCreateVirtualNodeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVirtualNode{}, middleware.After)
}

func addOpCreateVirtualRouterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVirtualRouter{}, middleware.After)
}

func addOpCreateVirtualServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVirtualService{}, middleware.After)
}

func addOpDeleteGatewayRouteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteGatewayRoute{}, middleware.After)
}

func addOpDeleteMeshValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteMesh{}, middleware.After)
}

func addOpDeleteRouteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteRoute{}, middleware.After)
}

func addOpDeleteVirtualGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVirtualGateway{}, middleware.After)
}

func addOpDeleteVirtualNodeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVirtualNode{}, middleware.After)
}

func addOpDeleteVirtualRouterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVirtualRouter{}, middleware.After)
}

func addOpDeleteVirtualServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVirtualService{}, middleware.After)
}

func addOpDescribeGatewayRouteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeGatewayRoute{}, middleware.After)
}

func addOpDescribeMeshValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeMesh{}, middleware.After)
}

func addOpDescribeRouteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeRoute{}, middleware.After)
}

func addOpDescribeVirtualGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeVirtualGateway{}, middleware.After)
}

func addOpDescribeVirtualNodeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeVirtualNode{}, middleware.After)
}

func addOpDescribeVirtualRouterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeVirtualRouter{}, middleware.After)
}

func addOpDescribeVirtualServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeVirtualService{}, middleware.After)
}

func addOpListGatewayRoutesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListGatewayRoutes{}, middleware.After)
}

func addOpListRoutesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListRoutes{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpListVirtualGatewaysValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListVirtualGateways{}, middleware.After)
}

func addOpListVirtualNodesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListVirtualNodes{}, middleware.After)
}

func addOpListVirtualRoutersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListVirtualRouters{}, middleware.After)
}

func addOpListVirtualServicesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListVirtualServices{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateGatewayRouteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateGatewayRoute{}, middleware.After)
}

func addOpUpdateMeshValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateMesh{}, middleware.After)
}

func addOpUpdateRouteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateRoute{}, middleware.After)
}

func addOpUpdateVirtualGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateVirtualGateway{}, middleware.After)
}

func addOpUpdateVirtualNodeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateVirtualNode{}, middleware.After)
}

func addOpUpdateVirtualRouterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateVirtualRouter{}, middleware.After)
}

func addOpUpdateVirtualServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateVirtualService{}, middleware.After)
}

func validateAccessLog(v types.AccessLog) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AccessLog"}
	switch uv := v.(type) {
	case *types.AccessLogMemberFile:
		if err := validateFileAccessLog(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAwsCloudMapInstanceAttribute(v *types.AwsCloudMapInstanceAttribute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AwsCloudMapInstanceAttribute"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAwsCloudMapInstanceAttributes(v []types.AwsCloudMapInstanceAttribute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AwsCloudMapInstanceAttributes"}
	for i := range v {
		if err := validateAwsCloudMapInstanceAttribute(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAwsCloudMapServiceDiscovery(v *types.AwsCloudMapServiceDiscovery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AwsCloudMapServiceDiscovery"}
	if v.NamespaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NamespaceName"))
	}
	if v.ServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceName"))
	}
	if v.Attributes != nil {
		if err := validateAwsCloudMapInstanceAttributes(v.Attributes); err != nil {
			invalidParams.AddNested("Attributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBackend(v types.Backend) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Backend"}
	switch uv := v.(type) {
	case *types.BackendMemberVirtualService:
		if err := validateVirtualServiceBackend(&uv.Value); err != nil {
			invalidParams.AddNested("[virtualService]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBackendDefaults(v *types.BackendDefaults) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BackendDefaults"}
	if v.ClientPolicy != nil {
		if err := validateClientPolicy(v.ClientPolicy); err != nil {
			invalidParams.AddNested("ClientPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBackends(v []types.Backend) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Backends"}
	for i := range v {
		if err := validateBackend(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClientPolicy(v *types.ClientPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClientPolicy"}
	if v.Tls != nil {
		if err := validateClientPolicyTls(v.Tls); err != nil {
			invalidParams.AddNested("Tls", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClientPolicyTls(v *types.ClientPolicyTls) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClientPolicyTls"}
	if v.Certificate != nil {
		if err := validateClientTlsCertificate(v.Certificate); err != nil {
			invalidParams.AddNested("Certificate", err.(smithy.InvalidParamsError))
		}
	}
	if v.Validation == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Validation"))
	} else if v.Validation != nil {
		if err := validateTlsValidationContext(v.Validation); err != nil {
			invalidParams.AddNested("Validation", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClientTlsCertificate(v types.ClientTlsCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClientTlsCertificate"}
	switch uv := v.(type) {
	case *types.ClientTlsCertificateMemberFile:
		if err := validateListenerTlsFileCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	case *types.ClientTlsCertificateMemberSds:
		if err := validateListenerTlsSdsCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[sds]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDnsServiceDiscovery(v *types.DnsServiceDiscovery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DnsServiceDiscovery"}
	if v.Hostname == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Hostname"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEgressFilter(v *types.EgressFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EgressFilter"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFileAccessLog(v *types.FileAccessLog) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FileAccessLog"}
	if v.Path == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Path"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGatewayRouteSpec(v *types.GatewayRouteSpec) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GatewayRouteSpec"}
	if v.HttpRoute != nil {
		if err := validateHttpGatewayRoute(v.HttpRoute); err != nil {
			invalidParams.AddNested("HttpRoute", err.(smithy.InvalidParamsError))
		}
	}
	if v.Http2Route != nil {
		if err := validateHttpGatewayRoute(v.Http2Route); err != nil {
			invalidParams.AddNested("Http2Route", err.(smithy.InvalidParamsError))
		}
	}
	if v.GrpcRoute != nil {
		if err := validateGrpcGatewayRoute(v.GrpcRoute); err != nil {
			invalidParams.AddNested("GrpcRoute", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGatewayRouteTarget(v *types.GatewayRouteTarget) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GatewayRouteTarget"}
	if v.VirtualService == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualService"))
	} else if v.VirtualService != nil {
		if err := validateGatewayRouteVirtualService(v.VirtualService); err != nil {
			invalidParams.AddNested("VirtualService", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGatewayRouteVirtualService(v *types.GatewayRouteVirtualService) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GatewayRouteVirtualService"}
	if v.VirtualServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualServiceName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcGatewayRoute(v *types.GrpcGatewayRoute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcGatewayRoute"}
	if v.Match == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Match"))
	} else if v.Match != nil {
		if err := validateGrpcGatewayRouteMatch(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateGrpcGatewayRouteAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcGatewayRouteAction(v *types.GrpcGatewayRouteAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcGatewayRouteAction"}
	if v.Target == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Target"))
	} else if v.Target != nil {
		if err := validateGatewayRouteTarget(v.Target); err != nil {
			invalidParams.AddNested("Target", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcGatewayRouteMatch(v *types.GrpcGatewayRouteMatch) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcGatewayRouteMatch"}
	if v.Metadata != nil {
		if err := validateGrpcGatewayRouteMetadataList(v.Metadata); err != nil {
			invalidParams.AddNested("Metadata", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcGatewayRouteMetadata(v *types.GrpcGatewayRouteMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcGatewayRouteMetadata"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Match != nil {
		if err := validateGrpcMetadataMatchMethod(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcGatewayRouteMetadataList(v []types.GrpcGatewayRouteMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcGatewayRouteMetadataList"}
	for i := range v {
		if err := validateGrpcGatewayRouteMetadata(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcMetadataMatchMethod(v types.GrpcMetadataMatchMethod) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcMetadataMatchMethod"}
	switch uv := v.(type) {
	case *types.GrpcMetadataMatchMethodMemberRange:
		if err := validateMatchRange(&uv.Value); err != nil {
			invalidParams.AddNested("[range]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcRetryPolicy(v *types.GrpcRetryPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcRetryPolicy"}
	if v.PerRetryTimeout == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PerRetryTimeout"))
	}
	if v.MaxRetries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxRetries"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcRoute(v *types.GrpcRoute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcRoute"}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateGrpcRouteAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.Match == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Match"))
	} else if v.Match != nil {
		if err := validateGrpcRouteMatch(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetryPolicy != nil {
		if err := validateGrpcRetryPolicy(v.RetryPolicy); err != nil {
			invalidParams.AddNested("RetryPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcRouteAction(v *types.GrpcRouteAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcRouteAction"}
	if v.WeightedTargets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WeightedTargets"))
	} else if v.WeightedTargets != nil {
		if err := validateWeightedTargets(v.WeightedTargets); err != nil {
			invalidParams.AddNested("WeightedTargets", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcRouteMatch(v *types.GrpcRouteMatch) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcRouteMatch"}
	if v.Metadata != nil {
		if err := validateGrpcRouteMetadataList(v.Metadata); err != nil {
			invalidParams.AddNested("Metadata", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcRouteMetadata(v *types.GrpcRouteMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcRouteMetadata"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Match != nil {
		if err := validateGrpcRouteMetadataMatchMethod(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcRouteMetadataList(v []types.GrpcRouteMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcRouteMetadataList"}
	for i := range v {
		if err := validateGrpcRouteMetadata(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGrpcRouteMetadataMatchMethod(v types.GrpcRouteMetadataMatchMethod) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GrpcRouteMetadataMatchMethod"}
	switch uv := v.(type) {
	case *types.GrpcRouteMetadataMatchMethodMemberRange:
		if err := validateMatchRange(&uv.Value); err != nil {
			invalidParams.AddNested("[range]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHeaderMatchMethod(v types.HeaderMatchMethod) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HeaderMatchMethod"}
	switch uv := v.(type) {
	case *types.HeaderMatchMethodMemberRange:
		if err := validateMatchRange(&uv.Value); err != nil {
			invalidParams.AddNested("[range]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHealthCheckPolicy(v *types.HealthCheckPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HealthCheckPolicy"}
	if v.TimeoutMillis == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeoutMillis"))
	}
	if v.IntervalMillis == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IntervalMillis"))
	}
	if len(v.Protocol) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Protocol"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpGatewayRoute(v *types.HttpGatewayRoute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpGatewayRoute"}
	if v.Match == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Match"))
	} else if v.Match != nil {
		if err := validateHttpGatewayRouteMatch(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateHttpGatewayRouteAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpGatewayRouteAction(v *types.HttpGatewayRouteAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpGatewayRouteAction"}
	if v.Target == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Target"))
	} else if v.Target != nil {
		if err := validateGatewayRouteTarget(v.Target); err != nil {
			invalidParams.AddNested("Target", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpGatewayRouteHeader(v *types.HttpGatewayRouteHeader) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpGatewayRouteHeader"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Match != nil {
		if err := validateHeaderMatchMethod(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpGatewayRouteHeaders(v []types.HttpGatewayRouteHeader) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpGatewayRouteHeaders"}
	for i := range v {
		if err := validateHttpGatewayRouteHeader(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpGatewayRouteMatch(v *types.HttpGatewayRouteMatch) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpGatewayRouteMatch"}
	if v.QueryParameters != nil {
		if err := validateHttpQueryParameters(v.QueryParameters); err != nil {
			invalidParams.AddNested("QueryParameters", err.(smithy.InvalidParamsError))
		}
	}
	if v.Headers != nil {
		if err := validateHttpGatewayRouteHeaders(v.Headers); err != nil {
			invalidParams.AddNested("Headers", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpQueryParameter(v *types.HttpQueryParameter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpQueryParameter"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpQueryParameters(v []types.HttpQueryParameter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpQueryParameters"}
	for i := range v {
		if err := validateHttpQueryParameter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpRetryPolicy(v *types.HttpRetryPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpRetryPolicy"}
	if v.PerRetryTimeout == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PerRetryTimeout"))
	}
	if v.MaxRetries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxRetries"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpRoute(v *types.HttpRoute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpRoute"}
	if v.Match == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Match"))
	} else if v.Match != nil {
		if err := validateHttpRouteMatch(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateHttpRouteAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetryPolicy != nil {
		if err := validateHttpRetryPolicy(v.RetryPolicy); err != nil {
			invalidParams.AddNested("RetryPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpRouteAction(v *types.HttpRouteAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpRouteAction"}
	if v.WeightedTargets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WeightedTargets"))
	} else if v.WeightedTargets != nil {
		if err := validateWeightedTargets(v.WeightedTargets); err != nil {
			invalidParams.AddNested("WeightedTargets", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpRouteHeader(v *types.HttpRouteHeader) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpRouteHeader"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Match != nil {
		if err := validateHeaderMatchMethod(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpRouteHeaders(v []types.HttpRouteHeader) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpRouteHeaders"}
	for i := range v {
		if err := validateHttpRouteHeader(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpRouteMatch(v *types.HttpRouteMatch) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpRouteMatch"}
	if v.QueryParameters != nil {
		if err := validateHttpQueryParameters(v.QueryParameters); err != nil {
			invalidParams.AddNested("QueryParameters", err.(smithy.InvalidParamsError))
		}
	}
	if v.Headers != nil {
		if err := validateHttpRouteHeaders(v.Headers); err != nil {
			invalidParams.AddNested("Headers", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListener(v *types.Listener) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Listener"}
	if v.PortMapping == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PortMapping"))
	} else if v.PortMapping != nil {
		if err := validatePortMapping(v.PortMapping); err != nil {
			invalidParams.AddNested("PortMapping", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tls != nil {
		if err := validateListenerTls(v.Tls); err != nil {
			invalidParams.AddNested("Tls", err.(smithy.InvalidParamsError))
		}
	}
	if v.HealthCheck != nil {
		if err := validateHealthCheckPolicy(v.HealthCheck); err != nil {
			invalidParams.AddNested("HealthCheck", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutlierDetection != nil {
		if err := validateOutlierDetection(v.OutlierDetection); err != nil {
			invalidParams.AddNested("OutlierDetection", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConnectionPool != nil {
		if err := validateVirtualNodeConnectionPool(v.ConnectionPool); err != nil {
			invalidParams.AddNested("ConnectionPool", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListeners(v []types.Listener) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Listeners"}
	for i := range v {
		if err := validateListener(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListenerTls(v *types.ListenerTls) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListenerTls"}
	if len(v.Mode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Mode"))
	}
	if v.Certificate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Certificate"))
	} else if v.Certificate != nil {
		if err := validateListenerTlsCertificate(v.Certificate); err != nil {
			invalidParams.AddNested("Certificate", err.(smithy.InvalidParamsError))
		}
	}
	if v.Validation != nil {
		if err := validateListenerTlsValidationContext(v.Validation); err != nil {
			invalidParams.AddNested("Validation", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListenerTlsAcmCertificate(v *types.ListenerTlsAcmCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListenerTlsAcmCertificate"}
	if v.CertificateArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListenerTlsCertificate(v types.ListenerTlsCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListenerTlsCertificate"}
	switch uv := v.(type) {
	case *types.ListenerTlsCertificateMemberAcm:
		if err := validateListenerTlsAcmCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[acm]", err.(smithy.InvalidParamsError))
		}

	case *types.ListenerTlsCertificateMemberFile:
		if err := validateListenerTlsFileCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	case *types.ListenerTlsCertificateMemberSds:
		if err := validateListenerTlsSdsCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[sds]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListenerTlsFileCertificate(v *types.ListenerTlsFileCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListenerTlsFileCertificate"}
	if v.CertificateChain == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateChain"))
	}
	if v.PrivateKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrivateKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListenerTlsSdsCertificate(v *types.ListenerTlsSdsCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListenerTlsSdsCertificate"}
	if v.SecretName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecretName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListenerTlsValidationContext(v *types.ListenerTlsValidationContext) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListenerTlsValidationContext"}
	if v.Trust == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Trust"))
	} else if v.Trust != nil {
		if err := validateListenerTlsValidationContextTrust(v.Trust); err != nil {
			invalidParams.AddNested("Trust", err.(smithy.InvalidParamsError))
		}
	}
	if v.SubjectAlternativeNames != nil {
		if err := validateSubjectAlternativeNames(v.SubjectAlternativeNames); err != nil {
			invalidParams.AddNested("SubjectAlternativeNames", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListenerTlsValidationContextTrust(v types.ListenerTlsValidationContextTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListenerTlsValidationContextTrust"}
	switch uv := v.(type) {
	case *types.ListenerTlsValidationContextTrustMemberFile:
		if err := validateTlsValidationContextFileTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	case *types.ListenerTlsValidationContextTrustMemberSds:
		if err := validateTlsValidationContextSdsTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[sds]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLogging(v *types.Logging) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Logging"}
	if v.AccessLog != nil {
		if err := validateAccessLog(v.AccessLog); err != nil {
			invalidParams.AddNested("AccessLog", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMatchRange(v *types.MatchRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MatchRange"}
	if v.Start == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Start"))
	}
	if v.End == nil {
		invalidParams.Add(smithy.NewErrParamRequired("End"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMeshSpec(v *types.MeshSpec) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MeshSpec"}
	if v.EgressFilter != nil {
		if err := validateEgressFilter(v.EgressFilter); err != nil {
			invalidParams.AddNested("EgressFilter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutlierDetection(v *types.OutlierDetection) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutlierDetection"}
	if v.MaxServerErrors == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxServerErrors"))
	}
	if v.Interval == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Interval"))
	}
	if v.BaseEjectionDuration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BaseEjectionDuration"))
	}
	if v.MaxEjectionPercent == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxEjectionPercent"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePortMapping(v *types.PortMapping) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PortMapping"}
	if len(v.Protocol) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Protocol"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRouteSpec(v *types.RouteSpec) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RouteSpec"}
	if v.HttpRoute != nil {
		if err := validateHttpRoute(v.HttpRoute); err != nil {
			invalidParams.AddNested("HttpRoute", err.(smithy.InvalidParamsError))
		}
	}
	if v.TcpRoute != nil {
		if err := validateTcpRoute(v.TcpRoute); err != nil {
			invalidParams.AddNested("TcpRoute", err.(smithy.InvalidParamsError))
		}
	}
	if v.Http2Route != nil {
		if err := validateHttpRoute(v.Http2Route); err != nil {
			invalidParams.AddNested("Http2Route", err.(smithy.InvalidParamsError))
		}
	}
	if v.GrpcRoute != nil {
		if err := validateGrpcRoute(v.GrpcRoute); err != nil {
			invalidParams.AddNested("GrpcRoute", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceDiscovery(v types.ServiceDiscovery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceDiscovery"}
	switch uv := v.(type) {
	case *types.ServiceDiscoveryMemberAwsCloudMap:
		if err := validateAwsCloudMapServiceDiscovery(&uv.Value); err != nil {
			invalidParams.AddNested("[awsCloudMap]", err.(smithy.InvalidParamsError))
		}

	case *types.ServiceDiscoveryMemberDns:
		if err := validateDnsServiceDiscovery(&uv.Value); err != nil {
			invalidParams.AddNested("[dns]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSubjectAlternativeNameMatchers(v *types.SubjectAlternativeNameMatchers) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SubjectAlternativeNameMatchers"}
	if v.Exact == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Exact"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSubjectAlternativeNames(v *types.SubjectAlternativeNames) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SubjectAlternativeNames"}
	if v.Match == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Match"))
	} else if v.Match != nil {
		if err := validateSubjectAlternativeNameMatchers(v.Match); err != nil {
			invalidParams.AddNested("Match", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.TagRef) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTagRef(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagRef(v *types.TagRef) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagRef"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTcpRoute(v *types.TcpRoute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TcpRoute"}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateTcpRouteAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTcpRouteAction(v *types.TcpRouteAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TcpRouteAction"}
	if v.WeightedTargets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WeightedTargets"))
	} else if v.WeightedTargets != nil {
		if err := validateWeightedTargets(v.WeightedTargets); err != nil {
			invalidParams.AddNested("WeightedTargets", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTlsValidationContext(v *types.TlsValidationContext) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TlsValidationContext"}
	if v.Trust == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Trust"))
	} else if v.Trust != nil {
		if err := validateTlsValidationContextTrust(v.Trust); err != nil {
			invalidParams.AddNested("Trust", err.(smithy.InvalidParamsError))
		}
	}
	if v.SubjectAlternativeNames != nil {
		if err := validateSubjectAlternativeNames(v.SubjectAlternativeNames); err != nil {
			invalidParams.AddNested("SubjectAlternativeNames", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTlsValidationContextAcmTrust(v *types.TlsValidationContextAcmTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TlsValidationContextAcmTrust"}
	if v.CertificateAuthorityArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateAuthorityArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTlsValidationContextFileTrust(v *types.TlsValidationContextFileTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TlsValidationContextFileTrust"}
	if v.CertificateChain == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateChain"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTlsValidationContextSdsTrust(v *types.TlsValidationContextSdsTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TlsValidationContextSdsTrust"}
	if v.SecretName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecretName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTlsValidationContextTrust(v types.TlsValidationContextTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TlsValidationContextTrust"}
	switch uv := v.(type) {
	case *types.TlsValidationContextTrustMemberAcm:
		if err := validateTlsValidationContextAcmTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[acm]", err.(smithy.InvalidParamsError))
		}

	case *types.TlsValidationContextTrustMemberFile:
		if err := validateTlsValidationContextFileTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	case *types.TlsValidationContextTrustMemberSds:
		if err := validateTlsValidationContextSdsTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[sds]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayAccessLog(v types.VirtualGatewayAccessLog) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayAccessLog"}
	switch uv := v.(type) {
	case *types.VirtualGatewayAccessLogMemberFile:
		if err := validateVirtualGatewayFileAccessLog(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayBackendDefaults(v *types.VirtualGatewayBackendDefaults) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayBackendDefaults"}
	if v.ClientPolicy != nil {
		if err := validateVirtualGatewayClientPolicy(v.ClientPolicy); err != nil {
			invalidParams.AddNested("ClientPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayClientPolicy(v *types.VirtualGatewayClientPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayClientPolicy"}
	if v.Tls != nil {
		if err := validateVirtualGatewayClientPolicyTls(v.Tls); err != nil {
			invalidParams.AddNested("Tls", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayClientPolicyTls(v *types.VirtualGatewayClientPolicyTls) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayClientPolicyTls"}
	if v.Certificate != nil {
		if err := validateVirtualGatewayClientTlsCertificate(v.Certificate); err != nil {
			invalidParams.AddNested("Certificate", err.(smithy.InvalidParamsError))
		}
	}
	if v.Validation == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Validation"))
	} else if v.Validation != nil {
		if err := validateVirtualGatewayTlsValidationContext(v.Validation); err != nil {
			invalidParams.AddNested("Validation", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayClientTlsCertificate(v types.VirtualGatewayClientTlsCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayClientTlsCertificate"}
	switch uv := v.(type) {
	case *types.VirtualGatewayClientTlsCertificateMemberFile:
		if err := validateVirtualGatewayListenerTlsFileCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualGatewayClientTlsCertificateMemberSds:
		if err := validateVirtualGatewayListenerTlsSdsCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[sds]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayConnectionPool(v types.VirtualGatewayConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayConnectionPool"}
	switch uv := v.(type) {
	case *types.VirtualGatewayConnectionPoolMemberGrpc:
		if err := validateVirtualGatewayGrpcConnectionPool(&uv.Value); err != nil {
			invalidParams.AddNested("[grpc]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualGatewayConnectionPoolMemberHttp:
		if err := validateVirtualGatewayHttpConnectionPool(&uv.Value); err != nil {
			invalidParams.AddNested("[http]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualGatewayConnectionPoolMemberHttp2:
		if err := validateVirtualGatewayHttp2ConnectionPool(&uv.Value); err != nil {
			invalidParams.AddNested("[http2]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayFileAccessLog(v *types.VirtualGatewayFileAccessLog) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayFileAccessLog"}
	if v.Path == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Path"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayGrpcConnectionPool(v *types.VirtualGatewayGrpcConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayGrpcConnectionPool"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayHealthCheckPolicy(v *types.VirtualGatewayHealthCheckPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayHealthCheckPolicy"}
	if v.TimeoutMillis == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeoutMillis"))
	}
	if v.IntervalMillis == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IntervalMillis"))
	}
	if len(v.Protocol) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Protocol"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayHttp2ConnectionPool(v *types.VirtualGatewayHttp2ConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayHttp2ConnectionPool"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayHttpConnectionPool(v *types.VirtualGatewayHttpConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayHttpConnectionPool"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListener(v *types.VirtualGatewayListener) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListener"}
	if v.HealthCheck != nil {
		if err := validateVirtualGatewayHealthCheckPolicy(v.HealthCheck); err != nil {
			invalidParams.AddNested("HealthCheck", err.(smithy.InvalidParamsError))
		}
	}
	if v.PortMapping == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PortMapping"))
	} else if v.PortMapping != nil {
		if err := validateVirtualGatewayPortMapping(v.PortMapping); err != nil {
			invalidParams.AddNested("PortMapping", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tls != nil {
		if err := validateVirtualGatewayListenerTls(v.Tls); err != nil {
			invalidParams.AddNested("Tls", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConnectionPool != nil {
		if err := validateVirtualGatewayConnectionPool(v.ConnectionPool); err != nil {
			invalidParams.AddNested("ConnectionPool", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListeners(v []types.VirtualGatewayListener) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListeners"}
	for i := range v {
		if err := validateVirtualGatewayListener(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListenerTls(v *types.VirtualGatewayListenerTls) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListenerTls"}
	if len(v.Mode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Mode"))
	}
	if v.Validation != nil {
		if err := validateVirtualGatewayListenerTlsValidationContext(v.Validation); err != nil {
			invalidParams.AddNested("Validation", err.(smithy.InvalidParamsError))
		}
	}
	if v.Certificate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Certificate"))
	} else if v.Certificate != nil {
		if err := validateVirtualGatewayListenerTlsCertificate(v.Certificate); err != nil {
			invalidParams.AddNested("Certificate", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListenerTlsAcmCertificate(v *types.VirtualGatewayListenerTlsAcmCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListenerTlsAcmCertificate"}
	if v.CertificateArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListenerTlsCertificate(v types.VirtualGatewayListenerTlsCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListenerTlsCertificate"}
	switch uv := v.(type) {
	case *types.VirtualGatewayListenerTlsCertificateMemberAcm:
		if err := validateVirtualGatewayListenerTlsAcmCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[acm]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualGatewayListenerTlsCertificateMemberFile:
		if err := validateVirtualGatewayListenerTlsFileCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualGatewayListenerTlsCertificateMemberSds:
		if err := validateVirtualGatewayListenerTlsSdsCertificate(&uv.Value); err != nil {
			invalidParams.AddNested("[sds]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListenerTlsFileCertificate(v *types.VirtualGatewayListenerTlsFileCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListenerTlsFileCertificate"}
	if v.CertificateChain == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateChain"))
	}
	if v.PrivateKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrivateKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListenerTlsSdsCertificate(v *types.VirtualGatewayListenerTlsSdsCertificate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListenerTlsSdsCertificate"}
	if v.SecretName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecretName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListenerTlsValidationContext(v *types.VirtualGatewayListenerTlsValidationContext) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListenerTlsValidationContext"}
	if v.Trust == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Trust"))
	} else if v.Trust != nil {
		if err := validateVirtualGatewayListenerTlsValidationContextTrust(v.Trust); err != nil {
			invalidParams.AddNested("Trust", err.(smithy.InvalidParamsError))
		}
	}
	if v.SubjectAlternativeNames != nil {
		if err := validateSubjectAlternativeNames(v.SubjectAlternativeNames); err != nil {
			invalidParams.AddNested("SubjectAlternativeNames", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayListenerTlsValidationContextTrust(v types.VirtualGatewayListenerTlsValidationContextTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayListenerTlsValidationContextTrust"}
	switch uv := v.(type) {
	case *types.VirtualGatewayListenerTlsValidationContextTrustMemberFile:
		if err := validateVirtualGatewayTlsValidationContextFileTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualGatewayListenerTlsValidationContextTrustMemberSds:
		if err := validateVirtualGatewayTlsValidationContextSdsTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[sds]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayLogging(v *types.VirtualGatewayLogging) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayLogging"}
	if v.AccessLog != nil {
		if err := validateVirtualGatewayAccessLog(v.AccessLog); err != nil {
			invalidParams.AddNested("AccessLog", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayPortMapping(v *types.VirtualGatewayPortMapping) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayPortMapping"}
	if len(v.Protocol) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Protocol"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewaySpec(v *types.VirtualGatewaySpec) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewaySpec"}
	if v.BackendDefaults != nil {
		if err := validateVirtualGatewayBackendDefaults(v.BackendDefaults); err != nil {
			invalidParams.AddNested("BackendDefaults", err.(smithy.InvalidParamsError))
		}
	}
	if v.Listeners == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Listeners"))
	} else if v.Listeners != nil {
		if err := validateVirtualGatewayListeners(v.Listeners); err != nil {
			invalidParams.AddNested("Listeners", err.(smithy.InvalidParamsError))
		}
	}
	if v.Logging != nil {
		if err := validateVirtualGatewayLogging(v.Logging); err != nil {
			invalidParams.AddNested("Logging", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayTlsValidationContext(v *types.VirtualGatewayTlsValidationContext) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayTlsValidationContext"}
	if v.Trust == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Trust"))
	} else if v.Trust != nil {
		if err := validateVirtualGatewayTlsValidationContextTrust(v.Trust); err != nil {
			invalidParams.AddNested("Trust", err.(smithy.InvalidParamsError))
		}
	}
	if v.SubjectAlternativeNames != nil {
		if err := validateSubjectAlternativeNames(v.SubjectAlternativeNames); err != nil {
			invalidParams.AddNested("SubjectAlternativeNames", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayTlsValidationContextAcmTrust(v *types.VirtualGatewayTlsValidationContextAcmTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayTlsValidationContextAcmTrust"}
	if v.CertificateAuthorityArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateAuthorityArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayTlsValidationContextFileTrust(v *types.VirtualGatewayTlsValidationContextFileTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayTlsValidationContextFileTrust"}
	if v.CertificateChain == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateChain"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayTlsValidationContextSdsTrust(v *types.VirtualGatewayTlsValidationContextSdsTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayTlsValidationContextSdsTrust"}
	if v.SecretName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecretName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualGatewayTlsValidationContextTrust(v types.VirtualGatewayTlsValidationContextTrust) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualGatewayTlsValidationContextTrust"}
	switch uv := v.(type) {
	case *types.VirtualGatewayTlsValidationContextTrustMemberAcm:
		if err := validateVirtualGatewayTlsValidationContextAcmTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[acm]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualGatewayTlsValidationContextTrustMemberFile:
		if err := validateVirtualGatewayTlsValidationContextFileTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[file]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualGatewayTlsValidationContextTrustMemberSds:
		if err := validateVirtualGatewayTlsValidationContextSdsTrust(&uv.Value); err != nil {
			invalidParams.AddNested("[sds]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualNodeConnectionPool(v types.VirtualNodeConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualNodeConnectionPool"}
	switch uv := v.(type) {
	case *types.VirtualNodeConnectionPoolMemberGrpc:
		if err := validateVirtualNodeGrpcConnectionPool(&uv.Value); err != nil {
			invalidParams.AddNested("[grpc]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualNodeConnectionPoolMemberHttp:
		if err := validateVirtualNodeHttpConnectionPool(&uv.Value); err != nil {
			invalidParams.AddNested("[http]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualNodeConnectionPoolMemberHttp2:
		if err := validateVirtualNodeHttp2ConnectionPool(&uv.Value); err != nil {
			invalidParams.AddNested("[http2]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualNodeConnectionPoolMemberTcp:
		if err := validateVirtualNodeTcpConnectionPool(&uv.Value); err != nil {
			invalidParams.AddNested("[tcp]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualNodeGrpcConnectionPool(v *types.VirtualNodeGrpcConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualNodeGrpcConnectionPool"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualNodeHttp2ConnectionPool(v *types.VirtualNodeHttp2ConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualNodeHttp2ConnectionPool"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualNodeHttpConnectionPool(v *types.VirtualNodeHttpConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualNodeHttpConnectionPool"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualNodeServiceProvider(v *types.VirtualNodeServiceProvider) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualNodeServiceProvider"}
	if v.VirtualNodeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualNodeName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualNodeSpec(v *types.VirtualNodeSpec) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualNodeSpec"}
	if v.ServiceDiscovery != nil {
		if err := validateServiceDiscovery(v.ServiceDiscovery); err != nil {
			invalidParams.AddNested("ServiceDiscovery", err.(smithy.InvalidParamsError))
		}
	}
	if v.Listeners != nil {
		if err := validateListeners(v.Listeners); err != nil {
			invalidParams.AddNested("Listeners", err.(smithy.InvalidParamsError))
		}
	}
	if v.Backends != nil {
		if err := validateBackends(v.Backends); err != nil {
			invalidParams.AddNested("Backends", err.(smithy.InvalidParamsError))
		}
	}
	if v.BackendDefaults != nil {
		if err := validateBackendDefaults(v.BackendDefaults); err != nil {
			invalidParams.AddNested("BackendDefaults", err.(smithy.InvalidParamsError))
		}
	}
	if v.Logging != nil {
		if err := validateLogging(v.Logging); err != nil {
			invalidParams.AddNested("Logging", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualNodeTcpConnectionPool(v *types.VirtualNodeTcpConnectionPool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualNodeTcpConnectionPool"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualRouterListener(v *types.VirtualRouterListener) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualRouterListener"}
	if v.PortMapping == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PortMapping"))
	} else if v.PortMapping != nil {
		if err := validatePortMapping(v.PortMapping); err != nil {
			invalidParams.AddNested("PortMapping", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualRouterListeners(v []types.VirtualRouterListener) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualRouterListeners"}
	for i := range v {
		if err := validateVirtualRouterListener(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualRouterServiceProvider(v *types.VirtualRouterServiceProvider) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualRouterServiceProvider"}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualRouterSpec(v *types.VirtualRouterSpec) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualRouterSpec"}
	if v.Listeners != nil {
		if err := validateVirtualRouterListeners(v.Listeners); err != nil {
			invalidParams.AddNested("Listeners", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualServiceBackend(v *types.VirtualServiceBackend) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualServiceBackend"}
	if v.VirtualServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualServiceName"))
	}
	if v.ClientPolicy != nil {
		if err := validateClientPolicy(v.ClientPolicy); err != nil {
			invalidParams.AddNested("ClientPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualServiceProvider(v types.VirtualServiceProvider) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualServiceProvider"}
	switch uv := v.(type) {
	case *types.VirtualServiceProviderMemberVirtualNode:
		if err := validateVirtualNodeServiceProvider(&uv.Value); err != nil {
			invalidParams.AddNested("[virtualNode]", err.(smithy.InvalidParamsError))
		}

	case *types.VirtualServiceProviderMemberVirtualRouter:
		if err := validateVirtualRouterServiceProvider(&uv.Value); err != nil {
			invalidParams.AddNested("[virtualRouter]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVirtualServiceSpec(v *types.VirtualServiceSpec) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VirtualServiceSpec"}
	if v.Provider != nil {
		if err := validateVirtualServiceProvider(v.Provider); err != nil {
			invalidParams.AddNested("Provider", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWeightedTarget(v *types.WeightedTarget) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WeightedTarget"}
	if v.VirtualNode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualNode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWeightedTargets(v []types.WeightedTarget) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WeightedTargets"}
	for i := range v {
		if err := validateWeightedTarget(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateGatewayRouteInput(v *CreateGatewayRouteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateGatewayRouteInput"}
	if v.GatewayRouteName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayRouteName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateGatewayRouteSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateMeshInput(v *CreateMeshInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateMeshInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec != nil {
		if err := validateMeshSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateRouteInput(v *CreateRouteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateRouteInput"}
	if v.RouteName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RouteName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateRouteSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVirtualGatewayInput(v *CreateVirtualGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVirtualGatewayInput"}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateVirtualGatewaySpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVirtualNodeInput(v *CreateVirtualNodeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVirtualNodeInput"}
	if v.VirtualNodeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualNodeName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateVirtualNodeSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVirtualRouterInput(v *CreateVirtualRouterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVirtualRouterInput"}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateVirtualRouterSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVirtualServiceInput(v *CreateVirtualServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVirtualServiceInput"}
	if v.VirtualServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualServiceName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateVirtualServiceSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteGatewayRouteInput(v *DeleteGatewayRouteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteGatewayRouteInput"}
	if v.GatewayRouteName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayRouteName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteMeshInput(v *DeleteMeshInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteMeshInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteRouteInput(v *DeleteRouteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteRouteInput"}
	if v.RouteName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RouteName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVirtualGatewayInput(v *DeleteVirtualGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVirtualGatewayInput"}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVirtualNodeInput(v *DeleteVirtualNodeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVirtualNodeInput"}
	if v.VirtualNodeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualNodeName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVirtualRouterInput(v *DeleteVirtualRouterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVirtualRouterInput"}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVirtualServiceInput(v *DeleteVirtualServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVirtualServiceInput"}
	if v.VirtualServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualServiceName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeGatewayRouteInput(v *DescribeGatewayRouteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeGatewayRouteInput"}
	if v.GatewayRouteName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayRouteName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeMeshInput(v *DescribeMeshInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeMeshInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeRouteInput(v *DescribeRouteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeRouteInput"}
	if v.RouteName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RouteName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeVirtualGatewayInput(v *DescribeVirtualGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeVirtualGatewayInput"}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeVirtualNodeInput(v *DescribeVirtualNodeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeVirtualNodeInput"}
	if v.VirtualNodeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualNodeName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeVirtualRouterInput(v *DescribeVirtualRouterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeVirtualRouterInput"}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeVirtualServiceInput(v *DescribeVirtualServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeVirtualServiceInput"}
	if v.VirtualServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualServiceName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListGatewayRoutesInput(v *ListGatewayRoutesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListGatewayRoutesInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListRoutesInput(v *ListRoutesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListRoutesInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListVirtualGatewaysInput(v *ListVirtualGatewaysInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListVirtualGatewaysInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListVirtualNodesInput(v *ListVirtualNodesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListVirtualNodesInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListVirtualRoutersInput(v *ListVirtualRoutersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListVirtualRoutersInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListVirtualServicesInput(v *ListVirtualServicesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListVirtualServicesInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateGatewayRouteInput(v *UpdateGatewayRouteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateGatewayRouteInput"}
	if v.GatewayRouteName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayRouteName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateGatewayRouteSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateMeshInput(v *UpdateMeshInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateMeshInput"}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec != nil {
		if err := validateMeshSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateRouteInput(v *UpdateRouteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateRouteInput"}
	if v.RouteName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RouteName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateRouteSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateVirtualGatewayInput(v *UpdateVirtualGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateVirtualGatewayInput"}
	if v.VirtualGatewayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualGatewayName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateVirtualGatewaySpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateVirtualNodeInput(v *UpdateVirtualNodeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateVirtualNodeInput"}
	if v.VirtualNodeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualNodeName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateVirtualNodeSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateVirtualRouterInput(v *UpdateVirtualRouterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateVirtualRouterInput"}
	if v.VirtualRouterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualRouterName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateVirtualRouterSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateVirtualServiceInput(v *UpdateVirtualServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateVirtualServiceInput"}
	if v.VirtualServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VirtualServiceName"))
	}
	if v.MeshName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MeshName"))
	}
	if v.Spec == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Spec"))
	} else if v.Spec != nil {
		if err := validateVirtualServiceSpec(v.Spec); err != nil {
			invalidParams.AddNested("Spec", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
