//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AdvancedThreatProtectionClient contains the methods for the AdvancedThreatProtection group.
// Don't use this type directly, use NewAdvancedThreatProtectionClient() instead.
type AdvancedThreatProtectionClient struct {
	host string
	pl   runtime.Pipeline
}

// NewAdvancedThreatProtectionClient creates a new instance of AdvancedThreatProtectionClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAdvancedThreatProtectionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AdvancedThreatProtectionClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AdvancedThreatProtectionClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// Create - Creates or updates the Advanced Threat Protection settings on a specified resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-01-01
// resourceID - The identifier of the resource.
// advancedThreatProtectionSetting - Advanced Threat Protection Settings
// options - AdvancedThreatProtectionClientCreateOptions contains the optional parameters for the AdvancedThreatProtectionClient.Create
// method.
func (client *AdvancedThreatProtectionClient) Create(ctx context.Context, resourceID string, advancedThreatProtectionSetting AdvancedThreatProtectionSetting, options *AdvancedThreatProtectionClientCreateOptions) (AdvancedThreatProtectionClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, resourceID, advancedThreatProtectionSetting, options)
	if err != nil {
		return AdvancedThreatProtectionClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AdvancedThreatProtectionClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AdvancedThreatProtectionClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *AdvancedThreatProtectionClient) createCreateRequest(ctx context.Context, resourceID string, advancedThreatProtectionSetting AdvancedThreatProtectionSetting, options *AdvancedThreatProtectionClientCreateOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	urlPath = strings.ReplaceAll(urlPath, "{settingName}", url.PathEscape("current"))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, advancedThreatProtectionSetting)
}

// createHandleResponse handles the Create response.
func (client *AdvancedThreatProtectionClient) createHandleResponse(resp *http.Response) (AdvancedThreatProtectionClientCreateResponse, error) {
	result := AdvancedThreatProtectionClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AdvancedThreatProtectionSetting); err != nil {
		return AdvancedThreatProtectionClientCreateResponse{}, err
	}
	return result, nil
}

// Get - Gets the Advanced Threat Protection settings for the specified resource.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-01-01
// resourceID - The identifier of the resource.
// options - AdvancedThreatProtectionClientGetOptions contains the optional parameters for the AdvancedThreatProtectionClient.Get
// method.
func (client *AdvancedThreatProtectionClient) Get(ctx context.Context, resourceID string, options *AdvancedThreatProtectionClientGetOptions) (AdvancedThreatProtectionClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceID, options)
	if err != nil {
		return AdvancedThreatProtectionClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AdvancedThreatProtectionClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AdvancedThreatProtectionClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *AdvancedThreatProtectionClient) getCreateRequest(ctx context.Context, resourceID string, options *AdvancedThreatProtectionClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	urlPath = strings.ReplaceAll(urlPath, "{settingName}", url.PathEscape("current"))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AdvancedThreatProtectionClient) getHandleResponse(resp *http.Response) (AdvancedThreatProtectionClientGetResponse, error) {
	result := AdvancedThreatProtectionClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AdvancedThreatProtectionSetting); err != nil {
		return AdvancedThreatProtectionClientGetResponse{}, err
	}
	return result, nil
}
