//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogic

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIOperation.
func (a APIOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APIOperationPropertiesDefinition.
func (a APIOperationPropertiesDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "api", a.API)
	populate(objectMap, "annotation", a.Annotation)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "inputsDefinition", a.InputsDefinition)
	populate(objectMap, "isNotification", a.IsNotification)
	populate(objectMap, "isWebhook", a.IsWebhook)
	populate(objectMap, "pageable", a.Pageable)
	populate(objectMap, "responsesDefinition", a.ResponsesDefinition)
	populate(objectMap, "summary", a.Summary)
	populate(objectMap, "trigger", a.Trigger)
	populate(objectMap, "triggerHint", a.TriggerHint)
	populate(objectMap, "visibility", a.Visibility)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APIResourceMetadata.
func (a APIResourceMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ApiType", a.APIType)
	populate(objectMap, "brandColor", a.BrandColor)
	populate(objectMap, "connectionType", a.ConnectionType)
	populate(objectMap, "deploymentParameters", a.DeploymentParameters)
	populate(objectMap, "hideKey", a.HideKey)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "source", a.Source)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "wsdlImportMethod", a.WsdlImportMethod)
	populate(objectMap, "wsdlService", a.WsdlService)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type APIResourceProperties.
func (a APIResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiDefinitionUrl", a.APIDefinitionURL)
	populate(objectMap, "apiDefinitions", a.APIDefinitions)
	populate(objectMap, "backendService", a.BackendService)
	populate(objectMap, "capabilities", a.Capabilities)
	populate(objectMap, "category", a.Category)
	populate(objectMap, "connectionParameters", a.ConnectionParameters)
	populate(objectMap, "generalInformation", a.GeneralInformation)
	populate(objectMap, "integrationServiceEnvironment", a.IntegrationServiceEnvironment)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "policies", a.Policies)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "runtimeUrls", a.RuntimeUrls)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactContentPropertiesDefinition.
func (a ArtifactContentPropertiesDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "changedTime", a.ChangedTime)
	populate(objectMap, "content", &a.Content)
	populate(objectMap, "contentLink", a.ContentLink)
	populate(objectMap, "contentType", a.ContentType)
	populateTimeRFC3339(objectMap, "createdTime", a.CreatedTime)
	populate(objectMap, "metadata", &a.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactContentPropertiesDefinition.
func (a *ArtifactContentPropertiesDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &a.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &a.ContentLink)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &a.ContentType)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &a.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactProperties.
func (a ArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "changedTime", a.ChangedTime)
	populateTimeRFC3339(objectMap, "createdTime", a.CreatedTime)
	populate(objectMap, "metadata", &a.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactProperties.
func (a *ArtifactProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &a.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &a.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssemblyDefinition.
func (a AssemblyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AssemblyProperties.
func (a AssemblyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assemblyCulture", a.AssemblyCulture)
	populate(objectMap, "assemblyName", a.AssemblyName)
	populate(objectMap, "assemblyPublicKeyToken", a.AssemblyPublicKeyToken)
	populate(objectMap, "assemblyVersion", a.AssemblyVersion)
	populateTimeRFC3339(objectMap, "changedTime", a.ChangedTime)
	populate(objectMap, "content", &a.Content)
	populate(objectMap, "contentLink", a.ContentLink)
	populate(objectMap, "contentType", a.ContentType)
	populateTimeRFC3339(objectMap, "createdTime", a.CreatedTime)
	populate(objectMap, "metadata", &a.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssemblyProperties.
func (a *AssemblyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assemblyCulture":
			err = unpopulate(val, "AssemblyCulture", &a.AssemblyCulture)
			delete(rawMsg, key)
		case "assemblyName":
			err = unpopulate(val, "AssemblyName", &a.AssemblyName)
			delete(rawMsg, key)
		case "assemblyPublicKeyToken":
			err = unpopulate(val, "AssemblyPublicKeyToken", &a.AssemblyPublicKeyToken)
			delete(rawMsg, key)
		case "assemblyVersion":
			err = unpopulate(val, "AssemblyVersion", &a.AssemblyVersion)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &a.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &a.ContentLink)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &a.ContentType)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &a.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type B2BPartnerContent.
func (b B2BPartnerContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "businessIdentities", b.BusinessIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BatchConfiguration.
func (b BatchConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BatchConfigurationProperties.
func (b BatchConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "batchGroupName", b.BatchGroupName)
	populateTimeRFC3339(objectMap, "changedTime", b.ChangedTime)
	populateTimeRFC3339(objectMap, "createdTime", b.CreatedTime)
	populate(objectMap, "metadata", &b.Metadata)
	populate(objectMap, "releaseCriteria", b.ReleaseCriteria)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchConfigurationProperties.
func (b *BatchConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "batchGroupName":
			err = unpopulate(val, "BatchGroupName", &b.BatchGroupName)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &b.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &b.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &b.Metadata)
			delete(rawMsg, key)
		case "releaseCriteria":
			err = unpopulate(val, "ReleaseCriteria", &b.ReleaseCriteria)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EdifactProtocolSettings.
func (e EdifactProtocolSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "acknowledgementSettings", e.AcknowledgementSettings)
	populate(objectMap, "edifactDelimiterOverrides", e.EdifactDelimiterOverrides)
	populate(objectMap, "envelopeOverrides", e.EnvelopeOverrides)
	populate(objectMap, "envelopeSettings", e.EnvelopeSettings)
	populate(objectMap, "framingSettings", e.FramingSettings)
	populate(objectMap, "messageFilter", e.MessageFilter)
	populate(objectMap, "messageFilterList", e.MessageFilterList)
	populate(objectMap, "processingSettings", e.ProcessingSettings)
	populate(objectMap, "schemaReferences", e.SchemaReferences)
	populate(objectMap, "validationOverrides", e.ValidationOverrides)
	populate(objectMap, "validationSettings", e.ValidationSettings)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FlowAccessControlConfigurationPolicy.
func (f FlowAccessControlConfigurationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedCallerIpAddresses", f.AllowedCallerIPAddresses)
	populate(objectMap, "openAuthenticationPolicies", f.OpenAuthenticationPolicies)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type FlowEndpoints.
func (f FlowEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessEndpointIpAddresses", f.AccessEndpointIPAddresses)
	populate(objectMap, "outgoingIpAddresses", f.OutgoingIPAddresses)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GetCallbackURLParameters.
func (g GetCallbackURLParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keyType", g.KeyType)
	populateTimeRFC3339(objectMap, "notAfter", g.NotAfter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetCallbackURLParameters.
func (g *GetCallbackURLParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyType":
			err = unpopulate(val, "KeyType", &g.KeyType)
			delete(rawMsg, key)
		case "notAfter":
			err = unpopulateTimeRFC3339(val, "NotAfter", &g.NotAfter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccount.
func (i IntegrationAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "sku", i.SKU)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountAgreement.
func (i IntegrationAccountAgreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountAgreementProperties.
func (i IntegrationAccountAgreementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agreementType", i.AgreementType)
	populateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", i.Content)
	populateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "guestIdentity", i.GuestIdentity)
	populate(objectMap, "guestPartner", i.GuestPartner)
	populate(objectMap, "hostIdentity", i.HostIdentity)
	populate(objectMap, "hostPartner", i.HostPartner)
	populate(objectMap, "metadata", &i.Metadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountAgreementProperties.
func (i *IntegrationAccountAgreementProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agreementType":
			err = unpopulate(val, "AgreementType", &i.AgreementType)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "guestIdentity":
			err = unpopulate(val, "GuestIdentity", &i.GuestIdentity)
			delete(rawMsg, key)
		case "guestPartner":
			err = unpopulate(val, "GuestPartner", &i.GuestPartner)
			delete(rawMsg, key)
		case "hostIdentity":
			err = unpopulate(val, "HostIdentity", &i.HostIdentity)
			delete(rawMsg, key)
		case "hostPartner":
			err = unpopulate(val, "HostPartner", &i.HostPartner)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountCertificate.
func (i IntegrationAccountCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountCertificateProperties.
func (i IntegrationAccountCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "key", i.Key)
	populate(objectMap, "metadata", &i.Metadata)
	populate(objectMap, "publicCertificate", i.PublicCertificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountCertificateProperties.
func (i *IntegrationAccountCertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &i.Key)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "publicCertificate":
			err = unpopulate(val, "PublicCertificate", &i.PublicCertificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountMap.
func (i IntegrationAccountMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountMapProperties.
func (i IntegrationAccountMapProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", i.Content)
	populate(objectMap, "contentLink", i.ContentLink)
	populate(objectMap, "contentType", i.ContentType)
	populateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "mapType", i.MapType)
	populate(objectMap, "metadata", &i.Metadata)
	populate(objectMap, "parametersSchema", i.ParametersSchema)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountMapProperties.
func (i *IntegrationAccountMapProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &i.ContentLink)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &i.ContentType)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "mapType":
			err = unpopulate(val, "MapType", &i.MapType)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "parametersSchema":
			err = unpopulate(val, "ParametersSchema", &i.ParametersSchema)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountPartner.
func (i IntegrationAccountPartner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountPartnerProperties.
func (i IntegrationAccountPartnerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", i.Content)
	populateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "metadata", &i.Metadata)
	populate(objectMap, "partnerType", i.PartnerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountPartnerProperties.
func (i *IntegrationAccountPartnerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "partnerType":
			err = unpopulate(val, "PartnerType", &i.PartnerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSchema.
func (i IntegrationAccountSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSchemaProperties.
func (i IntegrationAccountSchemaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", i.Content)
	populate(objectMap, "contentLink", i.ContentLink)
	populate(objectMap, "contentType", i.ContentType)
	populateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	populate(objectMap, "documentName", i.DocumentName)
	populate(objectMap, "fileName", i.FileName)
	populate(objectMap, "metadata", &i.Metadata)
	populate(objectMap, "schemaType", i.SchemaType)
	populate(objectMap, "targetNamespace", i.TargetNamespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSchemaProperties.
func (i *IntegrationAccountSchemaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "contentLink":
			err = unpopulate(val, "ContentLink", &i.ContentLink)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &i.ContentType)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		case "documentName":
			err = unpopulate(val, "DocumentName", &i.DocumentName)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &i.FileName)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &i.Metadata)
			delete(rawMsg, key)
		case "schemaType":
			err = unpopulate(val, "SchemaType", &i.SchemaType)
			delete(rawMsg, key)
		case "targetNamespace":
			err = unpopulate(val, "TargetNamespace", &i.TargetNamespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSession.
func (i IntegrationAccountSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSessionFilter.
func (i *IntegrationAccountSessionFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationAccountSessionProperties.
func (i IntegrationAccountSessionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "changedTime", i.ChangedTime)
	populate(objectMap, "content", &i.Content)
	populateTimeRFC3339(objectMap, "createdTime", i.CreatedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationAccountSessionProperties.
func (i *IntegrationAccountSessionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &i.ChangedTime)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &i.Content)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &i.CreatedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironment.
func (i IntegrationServiceEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "identity", i.Identity)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "sku", i.SKU)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentManagedAPI.
func (i IntegrationServiceEnvironmentManagedAPI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationServiceEnvironmentManagedAPIProperties.
func (i IntegrationServiceEnvironmentManagedAPIProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiDefinitionUrl", i.APIDefinitionURL)
	populate(objectMap, "apiDefinitions", i.APIDefinitions)
	populate(objectMap, "backendService", i.BackendService)
	populate(objectMap, "capabilities", i.Capabilities)
	populate(objectMap, "category", i.Category)
	populate(objectMap, "connectionParameters", i.ConnectionParameters)
	populate(objectMap, "deploymentParameters", i.DeploymentParameters)
	populate(objectMap, "generalInformation", i.GeneralInformation)
	populate(objectMap, "integrationServiceEnvironment", i.IntegrationServiceEnvironment)
	populate(objectMap, "metadata", i.Metadata)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "policies", i.Policies)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "runtimeUrls", i.RuntimeUrls)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedAPI.
func (m ManagedAPI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkConfiguration.
func (n NetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessEndpoint", n.AccessEndpoint)
	populate(objectMap, "subnets", n.Subnets)
	populate(objectMap, "virtualNetworkAddressSpace", n.VirtualNetworkAddressSpace)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OpenAuthenticationAccessPolicies.
func (o OpenAuthenticationAccessPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "policies", o.Policies)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OpenAuthenticationAccessPolicy.
func (o OpenAuthenticationAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "claims", o.Claims)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type OperationResult.
func (o OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", o.Code)
	populate(objectMap, "correlation", o.Correlation)
	populateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", &o.Error)
	populate(objectMap, "inputs", &o.Inputs)
	populate(objectMap, "inputsLink", o.InputsLink)
	populate(objectMap, "iterationCount", o.IterationCount)
	populate(objectMap, "outputs", &o.Outputs)
	populate(objectMap, "outputsLink", o.OutputsLink)
	populate(objectMap, "retryHistory", o.RetryHistory)
	populateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	populate(objectMap, "trackedProperties", &o.TrackedProperties)
	populate(objectMap, "trackingId", o.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &o.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &o.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &o.InputsLink)
			delete(rawMsg, key)
		case "iterationCount":
			err = unpopulate(val, "IterationCount", &o.IterationCount)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &o.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &o.OutputsLink)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &o.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &o.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &o.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultProperties.
func (o OperationResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", o.Code)
	populate(objectMap, "correlation", o.Correlation)
	populateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", &o.Error)
	populateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultProperties.
func (o *OperationResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &o.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecurrenceSchedule.
func (r RecurrenceSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hours", r.Hours)
	populate(objectMap, "minutes", r.Minutes)
	populate(objectMap, "monthDays", r.MonthDays)
	populate(objectMap, "monthlyOccurrences", r.MonthlyOccurrences)
	populate(objectMap, "weekDays", r.WeekDays)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestHistory.
func (r RequestHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RequestHistoryProperties.
func (r RequestHistoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "request", r.Request)
	populate(objectMap, "response", r.Response)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHistoryProperties.
func (r *RequestHistoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &r.Request)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &r.Response)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RetryHistory.
func (r RetryHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientRequestId", r.ClientRequestID)
	populate(objectMap, "code", r.Code)
	populateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "serviceRequestId", r.ServiceRequestID)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetryHistory.
func (r *RetryHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &r.ClientRequestID)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "serviceRequestId":
			err = unpopulate(val, "ServiceRequestID", &r.ServiceRequestID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunActionCorrelation.
func (r RunActionCorrelation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionTrackingId", r.ActionTrackingID)
	populate(objectMap, "clientKeywords", r.ClientKeywords)
	populate(objectMap, "clientTrackingId", r.ClientTrackingID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RunCorrelation.
func (r RunCorrelation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientKeywords", r.ClientKeywords)
	populate(objectMap, "clientTrackingId", r.ClientTrackingID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicList.
func (s SwaggerCustomDynamicList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "builtInOperation", s.BuiltInOperation)
	populate(objectMap, "itemTitlePath", s.ItemTitlePath)
	populate(objectMap, "itemValuePath", s.ItemValuePath)
	populate(objectMap, "itemsPath", s.ItemsPath)
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "parameters", s.Parameters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicProperties.
func (s SwaggerCustomDynamicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "valuePath", s.ValuePath)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicSchema.
func (s SwaggerCustomDynamicSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "valuePath", s.ValuePath)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerCustomDynamicTreeCommand.
func (s SwaggerCustomDynamicTreeCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "itemFullTitlePath", s.ItemFullTitlePath)
	populate(objectMap, "itemIsParent", s.ItemIsParent)
	populate(objectMap, "itemTitlePath", s.ItemTitlePath)
	populate(objectMap, "itemValuePath", s.ItemValuePath)
	populate(objectMap, "itemsPath", s.ItemsPath)
	populate(objectMap, "operationId", s.OperationID)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "selectableFilter", s.SelectableFilter)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerExternalDocumentation.
func (s SwaggerExternalDocumentation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", s.Description)
	populate(objectMap, "extensions", s.Extensions)
	populate(objectMap, "uri", s.URI)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerSchema.
func (s SwaggerSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalProperties", &s.AdditionalProperties)
	populate(objectMap, "allOf", s.AllOf)
	populate(objectMap, "discriminator", s.Discriminator)
	populate(objectMap, "dynamicListNew", s.DynamicListNew)
	populate(objectMap, "dynamicSchemaNew", s.DynamicSchemaNew)
	populate(objectMap, "dynamicSchemaOld", s.DynamicSchemaOld)
	populate(objectMap, "dynamicTree", s.DynamicTree)
	populate(objectMap, "example", &s.Example)
	populate(objectMap, "externalDocs", s.ExternalDocs)
	populate(objectMap, "items", s.Items)
	populate(objectMap, "maxProperties", s.MaxProperties)
	populate(objectMap, "minProperties", s.MinProperties)
	populate(objectMap, "notificationUrlExtension", s.NotificationURLExtension)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "readOnly", s.ReadOnly)
	populate(objectMap, "ref", s.Ref)
	populate(objectMap, "required", s.Required)
	populate(objectMap, "title", s.Title)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "xml", s.XML)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerXML.
func (s SwaggerXML) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attribute", s.Attribute)
	populate(objectMap, "extensions", s.Extensions)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "namespace", s.Namespace)
	populate(objectMap, "prefix", s.Prefix)
	populate(objectMap, "wrapped", s.Wrapped)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TrackingEvent.
func (t TrackingEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", t.Error)
	populate(objectMap, "eventLevel", t.EventLevel)
	populateTimeRFC3339(objectMap, "eventTime", t.EventTime)
	populate(objectMap, "record", &t.Record)
	populate(objectMap, "recordType", t.RecordType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackingEvent.
func (t *TrackingEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &t.Error)
			delete(rawMsg, key)
		case "eventLevel":
			err = unpopulate(val, "EventLevel", &t.EventLevel)
			delete(rawMsg, key)
		case "eventTime":
			err = unpopulateTimeRFC3339(val, "EventTime", &t.EventTime)
			delete(rawMsg, key)
		case "record":
			err = unpopulate(val, "Record", &t.Record)
			delete(rawMsg, key)
		case "recordType":
			err = unpopulate(val, "RecordType", &t.RecordType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackingEventsDefinition.
func (t TrackingEventsDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "events", t.Events)
	populate(objectMap, "sourceType", t.SourceType)
	populate(objectMap, "trackEventsOptions", t.TrackEventsOptions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Workflow.
func (w Workflow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowProperties.
func (w WorkflowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessControl", w.AccessControl)
	populate(objectMap, "accessEndpoint", w.AccessEndpoint)
	populateTimeRFC3339(objectMap, "changedTime", w.ChangedTime)
	populateTimeRFC3339(objectMap, "createdTime", w.CreatedTime)
	populate(objectMap, "definition", &w.Definition)
	populate(objectMap, "endpointsConfiguration", w.EndpointsConfiguration)
	populate(objectMap, "integrationAccount", w.IntegrationAccount)
	populate(objectMap, "integrationServiceEnvironment", w.IntegrationServiceEnvironment)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "state", w.State)
	populate(objectMap, "version", w.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowProperties.
func (w *WorkflowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &w.AccessControl)
			delete(rawMsg, key)
		case "accessEndpoint":
			err = unpopulate(val, "AccessEndpoint", &w.AccessEndpoint)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &w.Definition)
			delete(rawMsg, key)
		case "endpointsConfiguration":
			err = unpopulate(val, "EndpointsConfiguration", &w.EndpointsConfiguration)
			delete(rawMsg, key)
		case "integrationAccount":
			err = unpopulate(val, "IntegrationAccount", &w.IntegrationAccount)
			delete(rawMsg, key)
		case "integrationServiceEnvironment":
			err = unpopulate(val, "IntegrationServiceEnvironment", &w.IntegrationServiceEnvironment)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &w.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionProperties.
func (w *WorkflowRunActionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &w.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionRepetitionDefinition.
func (w WorkflowRunActionRepetitionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowRunActionRepetitionProperties.
func (w WorkflowRunActionRepetitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", w.Code)
	populate(objectMap, "correlation", w.Correlation)
	populateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populate(objectMap, "error", &w.Error)
	populate(objectMap, "inputs", &w.Inputs)
	populate(objectMap, "inputsLink", w.InputsLink)
	populate(objectMap, "iterationCount", w.IterationCount)
	populate(objectMap, "outputs", &w.Outputs)
	populate(objectMap, "outputsLink", w.OutputsLink)
	populate(objectMap, "repetitionIndexes", w.RepetitionIndexes)
	populate(objectMap, "retryHistory", w.RetryHistory)
	populateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "trackedProperties", &w.TrackedProperties)
	populate(objectMap, "trackingId", w.TrackingID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunActionRepetitionProperties.
func (w *WorkflowRunActionRepetitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &w.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "iterationCount":
			err = unpopulate(val, "IterationCount", &w.IterationCount)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "repetitionIndexes":
			err = unpopulate(val, "RepetitionIndexes", &w.RepetitionIndexes)
			delete(rawMsg, key)
		case "retryHistory":
			err = unpopulate(val, "RetryHistory", &w.RetryHistory)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunProperties.
func (w *WorkflowRunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &w.CorrelationID)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &w.Response)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &w.Trigger)
			delete(rawMsg, key)
		case "waitEndTime":
			err = unpopulateTimeRFC3339(val, "WaitEndTime", &w.WaitEndTime)
			delete(rawMsg, key)
		case "workflow":
			err = unpopulate(val, "Workflow", &w.Workflow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowRunTrigger.
func (w *WorkflowRunTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &w.Inputs)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &w.Outputs)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "scheduledTime":
			err = unpopulateTimeRFC3339(val, "ScheduledTime", &w.ScheduledTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackedProperties":
			err = unpopulate(val, "TrackedProperties", &w.TrackedProperties)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerHistoryProperties.
func (w *WorkflowTriggerHistoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &w.Code)
			delete(rawMsg, key)
		case "correlation":
			err = unpopulate(val, "Correlation", &w.Correlation)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "fired":
			err = unpopulate(val, "Fired", &w.Fired)
			delete(rawMsg, key)
		case "inputsLink":
			err = unpopulate(val, "InputsLink", &w.InputsLink)
			delete(rawMsg, key)
		case "outputsLink":
			err = unpopulate(val, "OutputsLink", &w.OutputsLink)
			delete(rawMsg, key)
		case "run":
			err = unpopulate(val, "Run", &w.Run)
			delete(rawMsg, key)
		case "scheduledTime":
			err = unpopulateTimeRFC3339(val, "ScheduledTime", &w.ScheduledTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &w.TrackingID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowTriggerProperties.
func (w *WorkflowTriggerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "lastExecutionTime":
			err = unpopulateTimeRFC3339(val, "LastExecutionTime", &w.LastExecutionTime)
			delete(rawMsg, key)
		case "nextExecutionTime":
			err = unpopulateTimeRFC3339(val, "NextExecutionTime", &w.NextExecutionTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &w.Recurrence)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "workflow":
			err = unpopulate(val, "Workflow", &w.Workflow)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowVersion.
func (w WorkflowVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowVersionProperties.
func (w WorkflowVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessControl", w.AccessControl)
	populate(objectMap, "accessEndpoint", w.AccessEndpoint)
	populateTimeRFC3339(objectMap, "changedTime", w.ChangedTime)
	populateTimeRFC3339(objectMap, "createdTime", w.CreatedTime)
	populate(objectMap, "definition", &w.Definition)
	populate(objectMap, "endpointsConfiguration", w.EndpointsConfiguration)
	populate(objectMap, "integrationAccount", w.IntegrationAccount)
	populate(objectMap, "parameters", w.Parameters)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "state", w.State)
	populate(objectMap, "version", w.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowVersionProperties.
func (w *WorkflowVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControl":
			err = unpopulate(val, "AccessControl", &w.AccessControl)
			delete(rawMsg, key)
		case "accessEndpoint":
			err = unpopulate(val, "AccessEndpoint", &w.AccessEndpoint)
			delete(rawMsg, key)
		case "changedTime":
			err = unpopulateTimeRFC3339(val, "ChangedTime", &w.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &w.CreatedTime)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &w.Definition)
			delete(rawMsg, key)
		case "endpointsConfiguration":
			err = unpopulate(val, "EndpointsConfiguration", &w.EndpointsConfiguration)
			delete(rawMsg, key)
		case "integrationAccount":
			err = unpopulate(val, "IntegrationAccount", &w.IntegrationAccount)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &w.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &w.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WsdlService.
func (w WsdlService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "EndpointQualifiedNames", w.EndpointQualifiedNames)
	populate(objectMap, "qualifiedName", w.QualifiedName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type X12ProtocolSettings.
func (x X12ProtocolSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "acknowledgementSettings", x.AcknowledgementSettings)
	populate(objectMap, "envelopeOverrides", x.EnvelopeOverrides)
	populate(objectMap, "envelopeSettings", x.EnvelopeSettings)
	populate(objectMap, "framingSettings", x.FramingSettings)
	populate(objectMap, "messageFilter", x.MessageFilter)
	populate(objectMap, "messageFilterList", x.MessageFilterList)
	populate(objectMap, "processingSettings", x.ProcessingSettings)
	populate(objectMap, "schemaReferences", x.SchemaReferences)
	populate(objectMap, "securitySettings", x.SecuritySettings)
	populate(objectMap, "validationOverrides", x.ValidationOverrides)
	populate(objectMap, "validationSettings", x.ValidationSettings)
	populate(objectMap, "x12DelimiterOverrides", x.X12DelimiterOverrides)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
