//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentmanager

import "time"

// APIKeyAuthentication - ApiKey authentication gives a name and a value that can be included in either the request header
// or query parameters.
type APIKeyAuthentication struct {
	// REQUIRED; The location of the authentication key/value pair in the request.
	In *RestAuthLocation `json:"in,omitempty"`

	// REQUIRED; The key name of the authentication key/value pair.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The authentication type.
	Type *RestAuthType `json:"type,omitempty"`

	// REQUIRED; The value of the authentication key/value pair.
	Value *string `json:"value,omitempty"`
}

// GetRestRequestAuthentication implements the RestRequestAuthenticationClassification interface for type APIKeyAuthentication.
func (a *APIKeyAuthentication) GetRestRequestAuthentication() *RestRequestAuthentication {
	return &RestRequestAuthentication{
		Type: a.Type,
	}
}

// ArtifactSource - The resource that defines the source location where the artifacts are located.
type ArtifactSource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties that define the artifact source.
	Properties *ArtifactSourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ArtifactSourceProperties - The properties that define the artifact source.
type ArtifactSourceProperties struct {
	// REQUIRED; The authentication method to use to access the artifact source.
	Authentication AuthenticationClassification `json:"authentication,omitempty"`

	// REQUIRED; The type of artifact source used.
	SourceType *string `json:"sourceType,omitempty"`

	// The path from the location that the 'authentication' property [say, a SAS URI to the blob container] refers to, to the
	// location of the artifacts. This can be used to differentiate different versions
	// of the artifacts. Or, different types of artifacts like binaries or templates. The location referenced by the authentication
	// property concatenated with this optional artifactRoot path forms the
	// artifact source location where the artifacts are expected to be found.
	ArtifactRoot *string `json:"artifactRoot,omitempty"`
}

// ArtifactSourcePropertiesAutoGenerated - The properties that define the source location where the artifacts are located.
type ArtifactSourcePropertiesAutoGenerated struct {
	// REQUIRED; The authentication method to use to access the artifact source.
	Authentication AuthenticationClassification `json:"authentication,omitempty"`

	// REQUIRED; The type of artifact source used.
	SourceType *string `json:"sourceType,omitempty"`

	// The path from the location that the 'authentication' property [say, a SAS URI to the blob container] refers to, to the
	// location of the artifacts. This can be used to differentiate different versions
	// of the artifacts. Or, different types of artifacts like binaries or templates. The location referenced by the authentication
	// property concatenated with this optional artifactRoot path forms the
	// artifact source location where the artifacts are expected to be found.
	ArtifactRoot *string `json:"artifactRoot,omitempty"`
}

// ArtifactSourcesClientCreateOrUpdateOptions contains the optional parameters for the ArtifactSourcesClient.CreateOrUpdate
// method.
type ArtifactSourcesClientCreateOrUpdateOptions struct {
	// Source object that defines the resource.
	ArtifactSourceInfo *ArtifactSource
}

// ArtifactSourcesClientDeleteOptions contains the optional parameters for the ArtifactSourcesClient.Delete method.
type ArtifactSourcesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ArtifactSourcesClientGetOptions contains the optional parameters for the ArtifactSourcesClient.Get method.
type ArtifactSourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ArtifactSourcesClientListOptions contains the optional parameters for the ArtifactSourcesClient.List method.
type ArtifactSourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// AuthenticationClassification provides polymorphic access to related types.
// Call the interface's GetAuthentication() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Authentication, *SasAuthentication
type AuthenticationClassification interface {
	// GetAuthentication returns the Authentication content of the underlying type.
	GetAuthentication() *Authentication
}

// Authentication - Defines the authentication method and properties to access the artifacts.
type Authentication struct {
	// REQUIRED; The authentication type
	Type *string `json:"type,omitempty"`
}

// GetAuthentication implements the AuthenticationClassification interface for type Authentication.
func (a *Authentication) GetAuthentication() *Authentication { return a }

// CloudError - The error information object.
type CloudError struct {
	// The properties that define the error.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - Detailed error information of any failure.
type CloudErrorBody struct {
	// More detailed error information.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// Error target
	Target *string `json:"target,omitempty"`

	// READ-ONLY; Error code string.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Descriptive error information.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// HealthCheckStepAttributesClassification provides polymorphic access to related types.
// Call the interface's GetHealthCheckStepAttributes() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *HealthCheckStepAttributes, *RestHealthCheckStepAttributes
type HealthCheckStepAttributesClassification interface {
	// GetHealthCheckStepAttributes returns the HealthCheckStepAttributes content of the underlying type.
	GetHealthCheckStepAttributes() *HealthCheckStepAttributes
}

// HealthCheckStepAttributes - The attributes for the health check step.
type HealthCheckStepAttributes struct {
	// REQUIRED; The duration in ISO 8601 format for which the resource is expected to be continuously healthy. If maxElasticDuration
	// is specified, healthy state duration is enforced after the detection of first
	// healthy signal.
	HealthyStateDuration *string `json:"healthyStateDuration,omitempty"`

	// REQUIRED; The type of health check.
	Type *string `json:"type,omitempty"`

	// The duration in ISO 8601 format for which the health check waits for the resource to become healthy. Health check fails
	// if it doesn't. Health check starts to enforce healthyStateDuration once resource
	// becomes healthy.
	MaxElasticDuration *string `json:"maxElasticDuration,omitempty"`

	// The duration in ISO 8601 format for which health check waits idly without any checks.
	WaitDuration *string `json:"waitDuration,omitempty"`
}

// GetHealthCheckStepAttributes implements the HealthCheckStepAttributesClassification interface for type HealthCheckStepAttributes.
func (h *HealthCheckStepAttributes) GetHealthCheckStepAttributes() *HealthCheckStepAttributes {
	return h
}

// HealthCheckStepProperties - Defines the properties of a health check step.
type HealthCheckStepProperties struct {
	// REQUIRED; The health check step attributes
	Attributes HealthCheckStepAttributesClassification `json:"attributes,omitempty"`

	// REQUIRED; The type of step.
	StepType *StepType `json:"stepType,omitempty"`
}

// GetStepProperties implements the StepPropertiesClassification interface for type HealthCheckStepProperties.
func (h *HealthCheckStepProperties) GetStepProperties() *StepProperties {
	return &StepProperties{
		StepType: h.StepType,
	}
}

// Identity for the resource.
type Identity struct {
	// REQUIRED; The list of identities.
	IdentityIDs []*string `json:"identityIds,omitempty"`

	// REQUIRED; The identity type.
	Type *string `json:"type,omitempty"`
}

// Message - Supplementary contextual messages during a rollout.
type Message struct {
	// READ-ONLY; The actual message text.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Time in UTC this message was provided.
	TimeStamp *time.Time `json:"timeStamp,omitempty" azure:"ro"`
}

// Operation - Represents an operation that can be performed on the service.
type Operation struct {
	// The display name of the operation.
	Display *OperationDetail `json:"display,omitempty"`

	// The name of the operation.
	Name *string `json:"name,omitempty"`

	// The origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// The properties of the operation.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationDetail - The detail about an operation.
type OperationDetail struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The name of the operation.
	Operation *string `json:"operation,omitempty"`

	// The name of the provider that supports the operation.
	Provider *string `json:"provider,omitempty"`

	// The resource type on which this operation can be performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsList - The operations response.
type OperationsList struct {
	// The list of supported operations
	Value *Operation `json:"value,omitempty"`
}

// PrePostStep - The properties that define a step.
type PrePostStep struct {
	// REQUIRED; The resource Id of the step to be run.
	StepID *string `json:"stepId,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceOperation - Individual resource operation information.
type ResourceOperation struct {
	// Name of the resource as specified in the artifacts. For ARM resources, this is the name of the resource specified in the
	// template.
	ResourceName *string `json:"resourceName,omitempty"`

	// Type of the resource as specified in the artifacts. For ARM resources, this is the type of the resource specified in the
	// template.
	ResourceType *string `json:"resourceType,omitempty"`

	// READ-ONLY; Unique identifier of the operation. For ARM resources, this is the operationId obtained from ARM service.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`

	// READ-ONLY; State of the resource deployment. For ARM resources, this is the current provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Http status code of the operation.
	StatusCode *string `json:"statusCode,omitempty" azure:"ro"`

	// READ-ONLY; Descriptive information of the resource operation.
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// RestHealthCheck - A REST based health check
type RestHealthCheck struct {
	// REQUIRED; A unique name for this check.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The request to the health provider.
	Request *RestRequest `json:"request,omitempty"`

	// The expected response from the health provider. If no expected response is provided, the default is to expect the received
	// response to have an HTTP status code of 200 OK.
	Response *RestResponse `json:"response,omitempty"`
}

// RestHealthCheckStepAttributes - Defines the REST health check step properties.
type RestHealthCheckStepAttributes struct {
	// REQUIRED; The duration in ISO 8601 format for which the resource is expected to be continuously healthy. If maxElasticDuration
	// is specified, healthy state duration is enforced after the detection of first
	// healthy signal.
	HealthyStateDuration *string `json:"healthyStateDuration,omitempty"`

	// REQUIRED; The type of health check.
	Type *string `json:"type,omitempty"`

	// The duration in ISO 8601 format for which the health check waits for the resource to become healthy. Health check fails
	// if it doesn't. Health check starts to enforce healthyStateDuration once resource
	// becomes healthy.
	MaxElasticDuration *string `json:"maxElasticDuration,omitempty"`

	// The REST health check parameters.
	Properties *RestParameters `json:"properties,omitempty"`

	// The duration in ISO 8601 format for which health check waits idly without any checks.
	WaitDuration *string `json:"waitDuration,omitempty"`
}

// GetHealthCheckStepAttributes implements the HealthCheckStepAttributesClassification interface for type RestHealthCheckStepAttributes.
func (r *RestHealthCheckStepAttributes) GetHealthCheckStepAttributes() *HealthCheckStepAttributes {
	return &HealthCheckStepAttributes{
		Type:                 r.Type,
		WaitDuration:         r.WaitDuration,
		MaxElasticDuration:   r.MaxElasticDuration,
		HealthyStateDuration: r.HealthyStateDuration,
	}
}

// RestParameters - The parameters for the REST health check.
type RestParameters struct {
	// REQUIRED; The list of checks that form the health check step.
	HealthChecks []*RestHealthCheck `json:"healthChecks,omitempty"`
}

// RestRequest - The properties that make up a REST request
type RestRequest struct {
	// REQUIRED; The authentication information required in the request to the health provider.
	Authentication RestRequestAuthenticationClassification `json:"authentication,omitempty"`

	// REQUIRED; The HTTP method to use for the request.
	Method *RestRequestMethod `json:"method,omitempty"`

	// REQUIRED; The HTTP URI to use for the request.
	URI *string `json:"uri,omitempty"`
}

// RestRequestAuthenticationClassification provides polymorphic access to related types.
// Call the interface's GetRestRequestAuthentication() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *APIKeyAuthentication, *RestRequestAuthentication, *RolloutIdentityAuthentication
type RestRequestAuthenticationClassification interface {
	// GetRestRequestAuthentication returns the RestRequestAuthentication content of the underlying type.
	GetRestRequestAuthentication() *RestRequestAuthentication
}

// RestRequestAuthentication - The authentication information required in the REST health check request to the health provider.
type RestRequestAuthentication struct {
	// REQUIRED; The authentication type.
	Type *RestAuthType `json:"type,omitempty"`
}

// GetRestRequestAuthentication implements the RestRequestAuthenticationClassification interface for type RestRequestAuthentication.
func (r *RestRequestAuthentication) GetRestRequestAuthentication() *RestRequestAuthentication {
	return r
}

// RestResponse - The properties that make up the expected REST response
type RestResponse struct {
	// The regular expressions to match the response content with.
	Regex *RestResponseRegex `json:"regex,omitempty"`

	// The HTTP status codes expected in a successful health check response. The response is expected to match one of the given
	// status codes. If no expected status codes are provided, default expected status
	// code is 200 OK.
	SuccessStatusCodes []*string `json:"successStatusCodes,omitempty"`
}

// RestResponseRegex - The regular expressions to match the response content with.
type RestResponseRegex struct {
	// Indicates whether any or all of the expressions should match with the response content.
	MatchQuantifier *RestMatchQuantifier `json:"matchQuantifier,omitempty"`

	// The list of regular expressions.
	Matches []*string `json:"matches,omitempty"`
}

// Rollout - Defines the rollout.
type Rollout struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Identity for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The properties that define a rollout.
	Properties *RolloutProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RolloutIdentityAuthentication - RolloutIdentity uses the user-assigned managed identity authentication context specified
// in the Identity property during rollout creation.
type RolloutIdentityAuthentication struct {
	// REQUIRED; The authentication type.
	Type *RestAuthType `json:"type,omitempty"`
}

// GetRestRequestAuthentication implements the RestRequestAuthenticationClassification interface for type RolloutIdentityAuthentication.
func (r *RolloutIdentityAuthentication) GetRestRequestAuthentication() *RestRequestAuthentication {
	return &RestRequestAuthentication{
		Type: r.Type,
	}
}

// RolloutOperationInfo - Detailed runtime information of the rollout.
type RolloutOperationInfo struct {
	// READ-ONLY; The start time of the rollout in UTC. This property will not be set if the rollout has not completed yet.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The detailed error information for any failure.
	Error *CloudErrorBody `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The ordinal count of the number of retry attempts on a rollout. 0 if no retries of the rollout have been performed.
	// If the rollout is updated with a PUT, this count is reset to 0.
	RetryAttempt *int32 `json:"retryAttempt,omitempty" azure:"ro"`

	// READ-ONLY; True, if all steps that succeeded on the previous run/attempt were chosen to be skipped in this retry attempt.
	// False, otherwise.
	SkipSucceededOnRetry *bool `json:"skipSucceededOnRetry,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the rollout in UTC.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// RolloutProperties - The properties that define a rollout.
type RolloutProperties struct {
	// REQUIRED; The version of the build being deployed.
	BuildVersion *string `json:"buildVersion,omitempty"`

	// REQUIRED; The list of step groups that define the orchestration.
	StepGroups []*StepGroup `json:"stepGroups,omitempty"`

	// REQUIRED; The resource Id of the service topology from which service units are being referenced in step groups to be deployed.
	TargetServiceTopologyID *string `json:"targetServiceTopologyId,omitempty"`

	// The reference to the artifact source resource Id where the payload is located.
	ArtifactSourceID *string `json:"artifactSourceId,omitempty"`

	// READ-ONLY; Operational information of the rollout.
	OperationInfo *RolloutOperationInfo `json:"operationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The detailed information on the services being deployed.
	Services []*Service `json:"services,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the rollout.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The cardinal count of total number of retries performed on the rollout at a given time.
	TotalRetryAttempts *int32 `json:"totalRetryAttempts,omitempty" azure:"ro"`
}

// RolloutPropertiesAutoGenerated - Defines the properties of a rollout.
type RolloutPropertiesAutoGenerated struct {
	// READ-ONLY; Operational information of the rollout.
	OperationInfo *RolloutOperationInfo `json:"operationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The detailed information on the services being deployed.
	Services []*Service `json:"services,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the rollout.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The cardinal count of total number of retries performed on the rollout at a given time.
	TotalRetryAttempts *int32 `json:"totalRetryAttempts,omitempty" azure:"ro"`
}

// RolloutRequest - Defines the PUT rollout request body.
type RolloutRequest struct {
	// REQUIRED; Identity for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; Defines the properties that make up a rollout request.
	Properties *RolloutRequestProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RolloutRequestProperties - The properties for defining a rollout.
type RolloutRequestProperties struct {
	// REQUIRED; The version of the build being deployed.
	BuildVersion *string `json:"buildVersion,omitempty"`

	// REQUIRED; The list of step groups that define the orchestration.
	StepGroups []*StepGroup `json:"stepGroups,omitempty"`

	// REQUIRED; The resource Id of the service topology from which service units are being referenced in step groups to be deployed.
	TargetServiceTopologyID *string `json:"targetServiceTopologyId,omitempty"`

	// The reference to the artifact source resource Id where the payload is located.
	ArtifactSourceID *string `json:"artifactSourceId,omitempty"`
}

// RolloutStep - Defines a specific step on a target service unit.
type RolloutStep struct {
	// REQUIRED; Name of the step.
	Name *string `json:"name,omitempty"`

	// The step group the current step is part of.
	StepGroup *string `json:"stepGroup,omitempty"`

	// READ-ONLY; Supplementary informative messages during rollout.
	Messages []*Message `json:"messages,omitempty" azure:"ro"`

	// READ-ONLY; Detailed information of specific action execution.
	OperationInfo *StepOperationInfo `json:"operationInfo,omitempty" azure:"ro"`

	// READ-ONLY; Set of resource operations that were performed, if any, on an Azure resource.
	ResourceOperations []*ResourceOperation `json:"resourceOperations,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the step.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// RolloutsClientBeginCreateOrUpdateOptions contains the optional parameters for the RolloutsClient.BeginCreateOrUpdate method.
type RolloutsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// Source rollout request object that defines the rollout.
	RolloutRequest *RolloutRequest
}

// RolloutsClientCancelOptions contains the optional parameters for the RolloutsClient.Cancel method.
type RolloutsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// RolloutsClientDeleteOptions contains the optional parameters for the RolloutsClient.Delete method.
type RolloutsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RolloutsClientGetOptions contains the optional parameters for the RolloutsClient.Get method.
type RolloutsClientGetOptions struct {
	// Rollout retry attempt ordinal to get the result of. If not specified, result of the latest attempt will be returned.
	RetryAttempt *int32
}

// RolloutsClientListOptions contains the optional parameters for the RolloutsClient.List method.
type RolloutsClientListOptions struct {
	// placeholder for future optional parameters
}

// RolloutsClientRestartOptions contains the optional parameters for the RolloutsClient.Restart method.
type RolloutsClientRestartOptions struct {
	// If true, will skip all succeeded steps so far in the rollout. If false, will execute the entire rollout again regardless
	// of the current state of individual resources. Defaults to false if not
	// specified.
	SkipSucceeded *bool
}

// SasAuthentication - Defines the properties to access the artifacts using an Azure Storage SAS URI.
type SasAuthentication struct {
	// REQUIRED; The authentication type
	Type *string `json:"type,omitempty"`

	// The SAS properties
	Properties *SasProperties `json:"properties,omitempty"`
}

// GetAuthentication implements the AuthenticationClassification interface for type SasAuthentication.
func (s *SasAuthentication) GetAuthentication() *Authentication {
	return &Authentication{
		Type: s.Type,
	}
}

// SasProperties - The properties that define SAS authentication.
type SasProperties struct {
	// REQUIRED; The SAS URI to the Azure Storage blob container. Any offset from the root of the container to where the artifacts
	// are located can be defined in the artifactRoot.
	SasURI *string `json:"sasUri,omitempty"`
}

// Service - Defines a service.
type Service struct {
	// REQUIRED; The Azure location to which the resources in the service belong to or should be deployed to.
	TargetLocation *string `json:"targetLocation,omitempty"`

	// REQUIRED; The subscription to which the resources in the service belong to or should be deployed to.
	TargetSubscriptionID *string `json:"targetSubscriptionId,omitempty"`

	// Name of the service.
	Name *string `json:"name,omitempty"`

	// The detailed information about the units that make up the service.
	ServiceUnits []*ServiceUnit `json:"serviceUnits,omitempty"`
}

// ServiceProperties - The properties of a service.
type ServiceProperties struct {
	// REQUIRED; The Azure location to which the resources in the service belong to or should be deployed to.
	TargetLocation *string `json:"targetLocation,omitempty"`

	// REQUIRED; The subscription to which the resources in the service belong to or should be deployed to.
	TargetSubscriptionID *string `json:"targetSubscriptionId,omitempty"`
}

// ServiceResource - The resource representation of a service in a service topology.
type ServiceResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; The properties that define a service in a service topology.
	Properties *ServiceResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceResourceProperties - The properties that define a service in a service topology.
type ServiceResourceProperties struct {
	// REQUIRED; The Azure location to which the resources in the service belong to or should be deployed to.
	TargetLocation *string `json:"targetLocation,omitempty"`

	// REQUIRED; The subscription to which the resources in the service belong to or should be deployed to.
	TargetSubscriptionID *string `json:"targetSubscriptionId,omitempty"`
}

// ServiceTopologiesClientCreateOrUpdateOptions contains the optional parameters for the ServiceTopologiesClient.CreateOrUpdate
// method.
type ServiceTopologiesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceTopologiesClientDeleteOptions contains the optional parameters for the ServiceTopologiesClient.Delete method.
type ServiceTopologiesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServiceTopologiesClientGetOptions contains the optional parameters for the ServiceTopologiesClient.Get method.
type ServiceTopologiesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceTopologiesClientListOptions contains the optional parameters for the ServiceTopologiesClient.List method.
type ServiceTopologiesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceTopologyProperties - The properties of a service topology.
type ServiceTopologyProperties struct {
	// The resource Id of the artifact source that contains the artifacts that can be referenced in the service units.
	ArtifactSourceID *string `json:"artifactSourceId,omitempty"`
}

// ServiceTopologyResource - The resource representation of a service topology.
type ServiceTopologyResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; The properties that define the service topology.
	Properties *ServiceTopologyResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceTopologyResourceProperties - The properties that define the service topology.
type ServiceTopologyResourceProperties struct {
	// The resource Id of the artifact source that contains the artifacts that can be referenced in the service units.
	ArtifactSourceID *string `json:"artifactSourceId,omitempty"`
}

// ServiceUnit - Defines a service unit.
type ServiceUnit struct {
	// REQUIRED; Describes the type of ARM deployment to be performed on the resource.
	DeploymentMode *DeploymentMode `json:"deploymentMode,omitempty"`

	// REQUIRED; The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`

	// The artifacts for the service unit.
	Artifacts *ServiceUnitArtifacts `json:"artifacts,omitempty"`

	// Name of the service unit.
	Name *string `json:"name,omitempty"`

	// Detailed step information, if present.
	Steps []*RolloutStep `json:"steps,omitempty"`
}

// ServiceUnitArtifacts - Defines the artifacts of a service unit.
type ServiceUnitArtifacts struct {
	// The path to the ARM parameters file relative to the artifact source.
	ParametersArtifactSourceRelativePath *string `json:"parametersArtifactSourceRelativePath,omitempty"`

	// The full URI of the ARM parameters file with the SAS token.
	ParametersURI *string `json:"parametersUri,omitempty"`

	// The path to the ARM template file relative to the artifact source.
	TemplateArtifactSourceRelativePath *string `json:"templateArtifactSourceRelativePath,omitempty"`

	// The full URI of the ARM template file with the SAS token.
	TemplateURI *string `json:"templateUri,omitempty"`
}

// ServiceUnitProperties - Defines the properties of a service unit.
type ServiceUnitProperties struct {
	// REQUIRED; Describes the type of ARM deployment to be performed on the resource.
	DeploymentMode *DeploymentMode `json:"deploymentMode,omitempty"`

	// REQUIRED; The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`

	// The artifacts for the service unit.
	Artifacts *ServiceUnitArtifacts `json:"artifacts,omitempty"`
}

// ServiceUnitResource - Represents the response of a service unit resource.
type ServiceUnitResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; The properties that define the service unit.
	Properties *ServiceUnitResourceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceUnitResourceProperties - The properties that define the service unit.
type ServiceUnitResourceProperties struct {
	// REQUIRED; Describes the type of ARM deployment to be performed on the resource.
	DeploymentMode *DeploymentMode `json:"deploymentMode,omitempty"`

	// REQUIRED; The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`

	// The artifacts for the service unit.
	Artifacts *ServiceUnitArtifacts `json:"artifacts,omitempty"`
}

// ServiceUnitsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServiceUnitsClient.BeginCreateOrUpdate
// method.
type ServiceUnitsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceUnitsClientDeleteOptions contains the optional parameters for the ServiceUnitsClient.Delete method.
type ServiceUnitsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServiceUnitsClientGetOptions contains the optional parameters for the ServiceUnitsClient.Get method.
type ServiceUnitsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceUnitsClientListOptions contains the optional parameters for the ServiceUnitsClient.List method.
type ServiceUnitsClientListOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientCreateOrUpdateOptions contains the optional parameters for the ServicesClient.CreateOrUpdate method.
type ServicesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientDeleteOptions contains the optional parameters for the ServicesClient.Delete method.
type ServicesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListOptions contains the optional parameters for the ServicesClient.List method.
type ServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// StepGroup - The properties that define a Step group in a rollout.
type StepGroup struct {
	// REQUIRED; The resource Id of service unit to be deployed. The service unit should be from the service topology referenced
	// in targetServiceTopologyId
	DeploymentTargetID *string `json:"deploymentTargetId,omitempty"`

	// REQUIRED; The name of the step group.
	Name *string `json:"name,omitempty"`

	// The list of step group names on which this step group depends on.
	DependsOnStepGroups []*string `json:"dependsOnStepGroups,omitempty"`

	// The list of steps to be run after deploying the target.
	PostDeploymentSteps []*PrePostStep `json:"postDeploymentSteps,omitempty"`

	// The list of steps to be run before deploying the target.
	PreDeploymentSteps []*PrePostStep `json:"preDeploymentSteps,omitempty"`
}

// StepOperationInfo - Detailed information of a specific step run.
type StepOperationInfo struct {
	// The errors, if any, for the action.
	Error *CloudErrorBody `json:"error,omitempty"`

	// READ-ONLY; Unique identifier to track the request for ARM-based resources.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM deployment initiated as part of the step.
	DeploymentName *string `json:"deploymentName,omitempty" azure:"ro"`

	// READ-ONLY; End time of the action in UTC.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Last time in UTC this operation was updated.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the action in UTC.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// StepPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetStepProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *HealthCheckStepProperties, *StepProperties, *WaitStepProperties
type StepPropertiesClassification interface {
	// GetStepProperties returns the StepProperties content of the underlying type.
	GetStepProperties() *StepProperties
}

// StepProperties - The properties of a step resource.
type StepProperties struct {
	// REQUIRED; The type of step.
	StepType *StepType `json:"stepType,omitempty"`
}

// GetStepProperties implements the StepPropertiesClassification interface for type StepProperties.
func (s *StepProperties) GetStepProperties() *StepProperties { return s }

// StepResource - The resource representation of a rollout step.
type StepResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; The properties that define the step.
	Properties StepPropertiesClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StepsClientCreateOrUpdateOptions contains the optional parameters for the StepsClient.CreateOrUpdate method.
type StepsClientCreateOrUpdateOptions struct {
	// The step object.
	StepInfo *StepResource
}

// StepsClientDeleteOptions contains the optional parameters for the StepsClient.Delete method.
type StepsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// StepsClientGetOptions contains the optional parameters for the StepsClient.Get method.
type StepsClientGetOptions struct {
	// placeholder for future optional parameters
}

// StepsClientListOptions contains the optional parameters for the StepsClient.List method.
type StepsClientListOptions struct {
	// placeholder for future optional parameters
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WaitStepAttributes - The parameters for the wait step.
type WaitStepAttributes struct {
	// REQUIRED; The duration in ISO 8601 format of how long the wait should be.
	Duration *string `json:"duration,omitempty"`
}

// WaitStepProperties - Defines the properties of a Wait step.
type WaitStepProperties struct {
	// REQUIRED; The Wait attributes
	Attributes *WaitStepAttributes `json:"attributes,omitempty"`

	// REQUIRED; The type of step.
	StepType *StepType `json:"stepType,omitempty"`
}

// GetStepProperties implements the StepPropertiesClassification interface for type WaitStepProperties.
func (w *WaitStepProperties) GetStepProperties() *StepProperties {
	return &StepProperties{
		StepType: w.StepType,
	}
}
