//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerservice

import "time"

// AccessProfile - Profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// Base64-encoded Kubernetes configuration file.
	KubeConfig []byte `json:"kubeConfig,omitempty"`
}

// AgentPool - Agent Pool.
type AgentPool struct {
	// Properties of an agent pool.
	Properties *ManagedClusterAgentPoolProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolAvailableVersions - The list of available versions for an agent pool.
type AgentPoolAvailableVersions struct {
	// REQUIRED; Properties of agent pool available versions.
	Properties *AgentPoolAvailableVersionsProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the agent pool version list.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the agent pool version list.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the agent pool version list.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolAvailableVersionsProperties - The list of available agent pool versions.
type AgentPoolAvailableVersionsProperties struct {
	// List of versions available for agent pool.
	AgentPoolVersions []*AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem `json:"agentPoolVersions,omitempty"`
}

type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem struct {
	// Whether this version is the default agent pool version.
	Default *bool `json:"default,omitempty"`

	// Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// AgentPoolListResult - The response from the List Agent Pools operation.
type AgentPoolListResult struct {
	// The list of agent pools.
	Value []*AgentPool `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of agent pool results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AgentPoolNetworkProfile - Network settings of an agent pool.
type AgentPoolNetworkProfile struct {
	// The port ranges that are allowed to access. The specified ranges are allowed to overlap.
	AllowedHostPorts []*PortRange `json:"allowedHostPorts,omitempty"`

	// The IDs of the application security groups which agent pool will associate when created.
	ApplicationSecurityGroups []*string `json:"applicationSecurityGroups,omitempty"`

	// IPTags of instance-level public IPs.
	NodePublicIPTags []*IPTag `json:"nodePublicIPTags,omitempty"`
}

// AgentPoolUpgradeProfile - The list of available upgrades for an agent pool.
type AgentPoolUpgradeProfile struct {
	// REQUIRED; The properties of the agent pool upgrade profile.
	Properties *AgentPoolUpgradeProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the agent pool upgrade profile.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the agent pool upgrade profile.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the agent pool upgrade profile.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolUpgradeProfileProperties - The list of available upgrade versions.
type AgentPoolUpgradeProfileProperties struct {
	// REQUIRED; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// REQUIRED; The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// The latest AKS supported node image version.
	LatestNodeImageVersion *string `json:"latestNodeImageVersion,omitempty"`

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*AgentPoolUpgradeProfilePropertiesUpgradesItem `json:"upgrades,omitempty"`
}

type AgentPoolUpgradeProfilePropertiesUpgradesItem struct {
	// Whether the Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// AgentPoolUpgradeSettings - Settings for upgrading an agentpool
type AgentPoolUpgradeSettings struct {
	// This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage
	// of the total agent pool size at the time of the upgrade. For
	// percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best
	// practices, see:
	// https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
	MaxSurge *string `json:"maxSurge,omitempty"`
}

// AgentPoolWindowsProfile - The Windows agent pool's specific profile.
type AgentPoolWindowsProfile struct {
	// The default value is false. Outbound NAT can only be disabled if the cluster outboundType is NAT Gateway and the Windows
	// agent pool does not have node public IP enabled.
	DisableOutboundNat *bool `json:"disableOutboundNat,omitempty"`
}

// AgentPoolsClientAbortLatestOperationOptions contains the optional parameters for the AgentPoolsClient.AbortLatestOperation
// method.
type AgentPoolsClientAbortLatestOperationOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the AgentPoolsClient.BeginCreateOrUpdate
// method.
type AgentPoolsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientBeginDeleteOptions contains the optional parameters for the AgentPoolsClient.BeginDelete method.
type AgentPoolsClientBeginDeleteOptions struct {
	// ignore-pod-disruption-budget=true to delete those pods on a node without considering Pod Disruption Budget
	IgnorePodDisruptionBudget *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientBeginUpgradeNodeImageVersionOptions contains the optional parameters for the AgentPoolsClient.BeginUpgradeNodeImageVersion
// method.
type AgentPoolsClientBeginUpgradeNodeImageVersionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AgentPoolsClientGetAvailableAgentPoolVersionsOptions contains the optional parameters for the AgentPoolsClient.GetAvailableAgentPoolVersions
// method.
type AgentPoolsClientGetAvailableAgentPoolVersionsOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientGetOptions contains the optional parameters for the AgentPoolsClient.Get method.
type AgentPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientGetUpgradeProfileOptions contains the optional parameters for the AgentPoolsClient.GetUpgradeProfile method.
type AgentPoolsClientGetUpgradeProfileOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsClientListOptions contains the optional parameters for the AgentPoolsClient.List method.
type AgentPoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// AzureKeyVaultKms - Azure Key Vault key management service settings for the security profile.
type AzureKeyVaultKms struct {
	// Whether to enable Azure Key Vault key management service. The default is false.
	Enabled *bool `json:"enabled,omitempty"`

	// Identifier of Azure Key Vault key. See key identifier format [https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name]
	// for more details.
	// When Azure Key Vault key management service is enabled, this field is required and must be a valid key identifier. When
	// Azure Key Vault key management service is disabled, leave the field empty.
	KeyID *string `json:"keyId,omitempty"`

	// Network access of key vault. The possible values are Public and Private. Public means the key vault allows public access
	// from all networks. Private means the key vault disables public access and
	// enables private link. The default value is Public.
	KeyVaultNetworkAccess *KeyVaultNetworkAccessTypes `json:"keyVaultNetworkAccess,omitempty"`

	// Resource ID of key vault. When keyVaultNetworkAccess is Private, this field is required and must be a valid resource ID.
	// When keyVaultNetworkAccess is Public, leave the field empty.
	KeyVaultResourceID *string `json:"keyVaultResourceId,omitempty"`
}

// CommandResultProperties - The results of a run command
type CommandResultProperties struct {
	// READ-ONLY; The exit code of the command
	ExitCode *int32 `json:"exitCode,omitempty" azure:"ro"`

	// READ-ONLY; The time when the command finished.
	FinishedAt *time.Time `json:"finishedAt,omitempty" azure:"ro"`

	// READ-ONLY; The command output.
	Logs *string `json:"logs,omitempty" azure:"ro"`

	// READ-ONLY; provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; An explanation of why provisioningState is set to failed (if so).
	Reason *string `json:"reason,omitempty" azure:"ro"`

	// READ-ONLY; The time when the command started.
	StartedAt *time.Time `json:"startedAt,omitempty" azure:"ro"`
}

// CreationData - Data used when creating a target resource from a source resource.
type CreationData struct {
	// This is the ARM ID of the source object to be used to create the target object.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// CredentialResult - The credential result response.
type CredentialResult struct {
	// READ-ONLY; The name of the credential.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value []byte `json:"value,omitempty" azure:"ro"`
}

// CredentialResults - The list credential result response.
type CredentialResults struct {
	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs []*CredentialResult `json:"kubeconfigs,omitempty" azure:"ro"`
}

// EndpointDependency - A domain name that AKS agent nodes are reaching at.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`

	// The Ports and Protocols used when connecting to domainName.
	EndpointDetails []*EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail - connect information from the AKS agent nodes to a single endpoint.
type EndpointDetail struct {
	// Description of the detail
	Description *string `json:"description,omitempty"`

	// An IP Address that Domain Name currently resolves to.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`

	// The protocol used for connection
	Protocol *string `json:"protocol,omitempty"`
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string `json:"name,omitempty"`

	// The type of the extended location.
	Type *ExtendedLocationTypes `json:"type,omitempty"`
}

// Fleet - The Fleet resource which contains multiple Kubernetes clusters as its members.
type Fleet struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a Fleet.
	Properties *FleetProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FleetCredentialResult - The credential result response.
type FleetCredentialResult struct {
	// READ-ONLY; The name of the credential.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value []byte `json:"value,omitempty" azure:"ro"`
}

// FleetCredentialResults - The list credential result response.
type FleetCredentialResults struct {
	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs []*FleetCredentialResult `json:"kubeconfigs,omitempty" azure:"ro"`
}

// FleetHubProfile - The FleetHubProfile configures the fleet hub.
type FleetHubProfile struct {
	// DNS prefix used to create the FQDN for the Fleet hub.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// READ-ONLY; The FQDN of the Fleet hub.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The Kubernetes version of the Fleet hub.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty" azure:"ro"`
}

// FleetListResult - The response from the List Fleets operation.
type FleetListResult struct {
	// The list of Fleets.
	Value []*Fleet `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next page of Fleets.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// FleetMember - A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.
type FleetMember struct {
	// Properties of a Fleet member.
	Properties *FleetMemberProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FleetMemberProperties - Properties of a Fleet member.
type FleetMemberProperties struct {
	// The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
	ClusterResourceID *string `json:"clusterResourceId,omitempty"`

	// READ-ONLY; The provisioning state of the last accepted operation.
	ProvisioningState *FleetMemberProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// FleetMembersClientBeginCreateOrUpdateOptions contains the optional parameters for the FleetMembersClient.BeginCreateOrUpdate
// method.
type FleetMembersClientBeginCreateOrUpdateOptions struct {
	// Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting
	// concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new resource to be created and prevent updating an existing resource. Other values will result in
	// a 412 Pre-condition Failed response.
	IfNoneMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FleetMembersClientBeginDeleteOptions contains the optional parameters for the FleetMembersClient.BeginDelete method.
type FleetMembersClientBeginDeleteOptions struct {
	// Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting
	// concurrent changes.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FleetMembersClientGetOptions contains the optional parameters for the FleetMembersClient.Get method.
type FleetMembersClientGetOptions struct {
	// placeholder for future optional parameters
}

// FleetMembersClientListByFleetOptions contains the optional parameters for the FleetMembersClient.ListByFleet method.
type FleetMembersClientListByFleetOptions struct {
	// placeholder for future optional parameters
}

// FleetMembersListResult - The response from the List FleetMembers operation.
type FleetMembersListResult struct {
	// The list of members in a given Fleet.
	Value []*FleetMember `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next page of Fleet members.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// FleetPatch - Properties of a Fleet that can be patched.
type FleetPatch struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// FleetProperties - Properties of a Fleet.
type FleetProperties struct {
	// The FleetHubProfile configures the Fleet's hub.
	HubProfile *FleetHubProfile `json:"hubProfile,omitempty"`

	// READ-ONLY; The provisioning state of the last accepted operation.
	ProvisioningState *FleetProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// FleetsClientBeginCreateOrUpdateOptions contains the optional parameters for the FleetsClient.BeginCreateOrUpdate method.
type FleetsClientBeginCreateOrUpdateOptions struct {
	// Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting
	// concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new resource to be created and prevent updating an existing resource. Other values will result in
	// a 412 Pre-condition Failed response.
	IfNoneMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FleetsClientBeginDeleteOptions contains the optional parameters for the FleetsClient.BeginDelete method.
type FleetsClientBeginDeleteOptions struct {
	// Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting
	// concurrent changes.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FleetsClientGetOptions contains the optional parameters for the FleetsClient.Get method.
type FleetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FleetsClientListByResourceGroupOptions contains the optional parameters for the FleetsClient.ListByResourceGroup method.
type FleetsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// FleetsClientListCredentialsOptions contains the optional parameters for the FleetsClient.ListCredentials method.
type FleetsClientListCredentialsOptions struct {
	// placeholder for future optional parameters
}

// FleetsClientListOptions contains the optional parameters for the FleetsClient.List method.
type FleetsClientListOptions struct {
	// placeholder for future optional parameters
}

// FleetsClientUpdateOptions contains the optional parameters for the FleetsClient.Update method.
type FleetsClientUpdateOptions struct {
	// Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting
	// concurrent changes.
	IfMatch *string
	// The properties of a Fleet to update.
	Parameters *FleetPatch
}

// GuardrailsProfile - The Guardrails profile.
type GuardrailsProfile struct {
	// REQUIRED; The guardrails level to be used. By default, Guardrails is enabled for all namespaces except those that AKS excludes
	// via systemExcludedNamespaces
	Level *Level `json:"level,omitempty"`

	// REQUIRED; The version of constraints to use
	Version *string `json:"version,omitempty"`

	// List of namespaces excluded from guardrails checks
	ExcludedNamespaces []*string `json:"excludedNamespaces,omitempty"`

	// READ-ONLY; List of namespaces specified by AKS to be excluded from Guardrails
	SystemExcludedNamespaces []*string `json:"systemExcludedNamespaces,omitempty" azure:"ro"`
}

// IPTag - Contains the IPTag associated with the object.
type IPTag struct {
	// The IP tag type. Example: RoutingPreference.
	IPTagType *string `json:"ipTagType,omitempty"`

	// The value of the IP tag associated with the public IP. Example: Internet.
	Tag *string `json:"tag,omitempty"`
}

// KubeletConfig - See AKS custom node configuration [https://docs.microsoft.com/azure/aks/custom-node-configuration] for
// more details.
type KubeletConfig struct {
	// Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in *).
	AllowedUnsafeSysctls []*string `json:"allowedUnsafeSysctls,omitempty"`

	// The default is true.
	CPUCfsQuota *bool `json:"cpuCfsQuota,omitempty"`

	// The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For
	// example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and
	// 'h'.
	CPUCfsQuotaPeriod *string `json:"cpuCfsQuotaPeriod,omitempty"`

	// The default is 'none'. See Kubernetes CPU management policies [https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies]
	// for more information. Allowed
	// values are 'none' and 'static'.
	CPUManagerPolicy *string `json:"cpuManagerPolicy,omitempty"`

	// The maximum number of container log files that can be present for a container. The number must be ≥ 2.
	ContainerLogMaxFiles *int32 `json:"containerLogMaxFiles,omitempty"`

	// The maximum size (e.g. 10Mi) of container log file before it is rotated.
	ContainerLogMaxSizeMB *int32 `json:"containerLogMaxSizeMB,omitempty"`

	// If set to true it will make the Kubelet fail to start if swap is enabled on the node.
	FailSwapOn *bool `json:"failSwapOn,omitempty"`

	// To disable image garbage collection, set to 100. The default is 85%
	ImageGcHighThreshold *int32 `json:"imageGcHighThreshold,omitempty"`

	// This cannot be set higher than imageGcHighThreshold. The default is 80%
	ImageGcLowThreshold *int32 `json:"imageGcLowThreshold,omitempty"`

	// The maximum number of processes per pod.
	PodMaxPids *int32 `json:"podMaxPids,omitempty"`

	// For more information see Kubernetes Topology Manager [https://kubernetes.io/docs/tasks/administer-cluster/topology-manager].
	// The default is 'none'. Allowed values are 'none', 'best-effort',
	// 'restricted', and 'single-numa-node'.
	TopologyManagerPolicy *string `json:"topologyManagerPolicy,omitempty"`
}

// LinuxOSConfig - See AKS custom node configuration [https://docs.microsoft.com/azure/aks/custom-node-configuration] for
// more details.
type LinuxOSConfig struct {
	// The size in MB of a swap file that will be created on each node.
	SwapFileSizeMB *int32 `json:"swapFileSizeMB,omitempty"`

	// Sysctl settings for Linux agent nodes.
	Sysctls *SysctlConfig `json:"sysctls,omitempty"`

	// Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information
	// see Transparent Hugepages
	// [https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge].
	TransparentHugePageDefrag *string `json:"transparentHugePageDefrag,omitempty"`

	// Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see Transparent Hugepages
	// [https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge].
	TransparentHugePageEnabled *string `json:"transparentHugePageEnabled,omitempty"`
}

// LinuxProfile - Profile for Linux VMs in the container service cluster.
type LinuxProfile struct {
	// REQUIRED; The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`

	// REQUIRED; The SSH configuration for Linux-based VMs running on Azure.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// MaintenanceConfiguration - See planned maintenance [https://docs.microsoft.com/azure/aks/planned-maintenance] for more
// information about planned maintenance.
type MaintenanceConfiguration struct {
	// Properties of a default maintenance configuration.
	Properties *MaintenanceConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MaintenanceConfigurationListResult - The response from the List maintenance configurations operation.
type MaintenanceConfigurationListResult struct {
	// The list of maintenance configurations.
	Value []*MaintenanceConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of maintenance configuration results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MaintenanceConfigurationProperties - Properties used to configure planned maintenance for a Managed Cluster.
type MaintenanceConfigurationProperties struct {
	// Time slots on which upgrade is not allowed.
	NotAllowedTime []*TimeSpan `json:"notAllowedTime,omitempty"`

	// If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
	TimeInWeek []*TimeInWeek `json:"timeInWeek,omitempty"`
}

// MaintenanceConfigurationsClientCreateOrUpdateOptions contains the optional parameters for the MaintenanceConfigurationsClient.CreateOrUpdate
// method.
type MaintenanceConfigurationsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsClientDeleteOptions contains the optional parameters for the MaintenanceConfigurationsClient.Delete
// method.
type MaintenanceConfigurationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsClientGetOptions contains the optional parameters for the MaintenanceConfigurationsClient.Get
// method.
type MaintenanceConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsClientListByManagedClusterOptions contains the optional parameters for the MaintenanceConfigurationsClient.ListByManagedCluster
// method.
type MaintenanceConfigurationsClientListByManagedClusterOptions struct {
	// placeholder for future optional parameters
}

// ManagedCluster - Managed cluster.
type ManagedCluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the managed cluster, if configured.
	Identity *ManagedClusterIdentity `json:"identity,omitempty"`

	// Properties of a managed cluster.
	Properties *ManagedClusterProperties `json:"properties,omitempty"`

	// The managed cluster SKU.
	SKU *ManagedClusterSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterAADProfile - For more details see managed AAD on AKS [https://docs.microsoft.com/azure/aks/managed-aad].
type ManagedClusterAADProfile struct {
	// The list of AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs []*string `json:"adminGroupObjectIDs,omitempty"`

	// The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`

	// Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRBAC *bool `json:"enableAzureRBAC,omitempty"`

	// Whether to enable managed AAD.
	Managed *bool `json:"managed,omitempty"`

	// The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`

	// The server AAD application secret.
	ServerAppSecret *string `json:"serverAppSecret,omitempty"`

	// The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// ManagedClusterAPIServerAccessProfile - Access profile for managed cluster API server.
type ManagedClusterAPIServerAccessProfile struct {
	// IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public
	// IP Per Node, or clusters that are using a Basic Load Balancer. For more
	// information see API server authorized IP ranges [https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges].
	AuthorizedIPRanges []*string `json:"authorizedIPRanges,omitempty"`

	// Whether to disable run command for the cluster or not.
	DisableRunCommand *bool `json:"disableRunCommand,omitempty"`

	// For more details, see Creating a private AKS cluster [https://docs.microsoft.com/azure/aks/private-clusters].
	EnablePrivateCluster *bool `json:"enablePrivateCluster,omitempty"`

	// Whether to create additional public FQDN for private cluster or not.
	EnablePrivateClusterPublicFQDN *bool `json:"enablePrivateClusterPublicFQDN,omitempty"`

	// Whether to enable apiserver vnet integration for the cluster or not.
	EnableVnetIntegration *bool `json:"enableVnetIntegration,omitempty"`

	// The default is System. For more details see configure private DNS zone [https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone].
	// Allowed values are 'system' and 'none'.
	PrivateDNSZone *string `json:"privateDNSZone,omitempty"`

	// It is required when: 1. creating a new cluster with BYO Vnet; 2. updating an existing cluster to enable apiserver vnet
	// integration.
	SubnetID *string `json:"subnetId,omitempty"`
}

// ManagedClusterAccessProfile - Managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// AccessProfile of a managed cluster.
	Properties *AccessProfile `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterAddonProfile - A Kubernetes add-on profile for a managed cluster.
type ManagedClusterAddonProfile struct {
	// REQUIRED; Whether the add-on is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// Key-value pairs for configuring an add-on.
	Config map[string]*string `json:"config,omitempty"`

	// READ-ONLY; Information of user assigned identity used by this add-on.
	Identity *ManagedClusterAddonProfileIdentity `json:"identity,omitempty" azure:"ro"`
}

// ManagedClusterAddonProfileIdentity - Information of user assigned identity used by this add-on.
type ManagedClusterAddonProfileIdentity struct {
	// The client ID of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The object ID of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`

	// The resource ID of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ManagedClusterAgentPoolProfile - Profile for the container service agent pool.
type ManagedClusterAgentPoolProfile struct {
	// REQUIRED; Windows agent pool names must be 6 characters or less.
	Name *string `json:"name,omitempty"`

	// The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// AKS will associate the specified agent pool with the Capacity Reservation Group.
	CapacityReservationGroupID *string `json:"capacityReservationGroupID,omitempty"`

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user
	// pools and in the range of 1 to 1000 (inclusive) for system pools. The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`

	// When set to true, AKS adds a label to the node indicating that the feature is enabled and deploys a daemonset along with
	// host services to sync custom certificate authorities from user-provided list of
	// base64 encoded certificates into node trust stores. Defaults to false.
	EnableCustomCATrust *bool `json:"enableCustomCATrust,omitempty"`

	// This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`

	// See Add a FIPS-enabled node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview]
	// for more details.
	EnableFIPS *bool `json:"enableFIPS,omitempty"`

	// Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is
	// for gaming workloads, where a console needs to make a direct connection to a
	// cloud virtual machine to minimize hops. For more information see assigning a public IP per node
	// [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools]. The default
	// is false.
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`

	// Whether to enable UltraSSD
	EnableUltraSSD *bool `json:"enableUltraSSD,omitempty"`

	// GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
	GpuInstanceProfile *GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
	// For more information see Azure dedicated hosts
	// [https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts].
	HostGroupID *string `json:"hostGroupID,omitempty"`

	// The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`

	// Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
	KubeletDiskType *KubeletDiskType `json:"kubeletDiskType,omitempty"`

	// The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// A base64-encoded string which will be written to /etc/motd after decoding. This allows customization of the message of
	// the day for Linux nodes. It must not be specified for Windows nodes. It must be a
	// static string (i.e., will be printed raw and not be executed as a script).
	MessageOfTheDay *string `json:"messageOfTheDay,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions
	// and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
	Mode *AgentPoolMode `json:"mode,omitempty"`

	// Network-related settings of an agent pool.
	NetworkProfile *AgentPoolNetworkProfile `json:"networkProfile,omitempty"`

	// The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`

	// The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
	// defaults to 'Managed'. May not be changed after creation. For more information
	// see Ephemeral OS [https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os].
	OSDiskType *OSDiskType `json:"osDiskType,omitempty"`

	// Specifies the OS SKU used by the agent pool. If not specified, the default is Ubuntu if OSType=Linux or Windows2019 if
	// OSType=Windows. And the default Windows OSSKU will be changed to Windows2022
	// after Windows2019 is deprecated.
	OSSKU *OSSKU `json:"osSKU,omitempty"`

	// The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// Both patch version and are supported. When is specified, the latest supported patch version is chosen automatically. Updating
	// the agent pool with the same once it has been created will not trigger an
	// upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster
	// to the same Kubernetes version. The node pool version must have the same
	// major version as the control plane. The node pool minor version must be within two minor versions of the control plane
	// version. The node pool version cannot be greater than the control plane version.
	// For more information see upgrading a node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool].
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string `json:"podSubnetID,omitempty"`

	// When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped.
	// A stopped Agent Pool stops all of its VMs and does not accrue billing
	// charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
	PowerState *PowerState `json:"powerState,omitempty"`

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`

	// This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
	ScaleDownMode *ScaleDownMode `json:"scaleDownMode,omitempty"`

	// This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`

	// The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
	ScaleSetPriority *ScaleSetPriority `json:"scaleSetPriority,omitempty"`

	// Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price.
	// For more details on spot pricing, see spot VMs pricing
	// [https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing]
	SpotMaxPrice *float32 `json:"spotMaxPrice,omitempty"`

	// The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags,omitempty"`

	// The type of Agent Pool.
	Type *AgentPoolType `json:"type,omitempty"`

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`

	// VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might
	// fail to run correctly. For more details on restricted VM sizes, see:
	// https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize *string `json:"vmSize,omitempty"`

	// If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to
	// nodes and pods, otherwise it applies to just nodes. This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// The Windows agent pool's specific profile.
	WindowsProfile *AgentPoolWindowsProfile `json:"windowsProfile,omitempty"`

	// Determines the type of workload a node can run.
	WorkloadRuntime *WorkloadRuntime `json:"workloadRuntime,omitempty"`

	// READ-ONLY; If orchestratorVersion was a fully specified version , this field will be exactly equal to it. If orchestratorVersion
	// was , this field will contain the full version being used.
	CurrentOrchestratorVersion *string `json:"currentOrchestratorVersion,omitempty" azure:"ro"`

	// READ-ONLY; The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterAgentPoolProfileProperties - Properties for the container service agent pool profile.
type ManagedClusterAgentPoolProfileProperties struct {
	// The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// AKS will associate the specified agent pool with the Capacity Reservation Group.
	CapacityReservationGroupID *string `json:"capacityReservationGroupID,omitempty"`

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user
	// pools and in the range of 1 to 1000 (inclusive) for system pools. The default
	// value is 1.
	Count *int32 `json:"count,omitempty"`

	// CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`

	// When set to true, AKS adds a label to the node indicating that the feature is enabled and deploys a daemonset along with
	// host services to sync custom certificate authorities from user-provided list of
	// base64 encoded certificates into node trust stores. Defaults to false.
	EnableCustomCATrust *bool `json:"enableCustomCATrust,omitempty"`

	// This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`

	// See Add a FIPS-enabled node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview]
	// for more details.
	EnableFIPS *bool `json:"enableFIPS,omitempty"`

	// Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is
	// for gaming workloads, where a console needs to make a direct connection to a
	// cloud virtual machine to minimize hops. For more information see assigning a public IP per node
	// [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools]. The default
	// is false.
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`

	// Whether to enable UltraSSD
	EnableUltraSSD *bool `json:"enableUltraSSD,omitempty"`

	// GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
	GpuInstanceProfile *GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
	// For more information see Azure dedicated hosts
	// [https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts].
	HostGroupID *string `json:"hostGroupID,omitempty"`

	// The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`

	// Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
	KubeletDiskType *KubeletDiskType `json:"kubeletDiskType,omitempty"`

	// The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// A base64-encoded string which will be written to /etc/motd after decoding. This allows customization of the message of
	// the day for Linux nodes. It must not be specified for Windows nodes. It must be a
	// static string (i.e., will be printed raw and not be executed as a script).
	MessageOfTheDay *string `json:"messageOfTheDay,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions
	// and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
	Mode *AgentPoolMode `json:"mode,omitempty"`

	// Network-related settings of an agent pool.
	NetworkProfile *AgentPoolNetworkProfile `json:"networkProfile,omitempty"`

	// The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`

	// The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
	// defaults to 'Managed'. May not be changed after creation. For more information
	// see Ephemeral OS [https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os].
	OSDiskType *OSDiskType `json:"osDiskType,omitempty"`

	// Specifies the OS SKU used by the agent pool. If not specified, the default is Ubuntu if OSType=Linux or Windows2019 if
	// OSType=Windows. And the default Windows OSSKU will be changed to Windows2022
	// after Windows2019 is deprecated.
	OSSKU *OSSKU `json:"osSKU,omitempty"`

	// The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// Both patch version and are supported. When is specified, the latest supported patch version is chosen automatically. Updating
	// the agent pool with the same once it has been created will not trigger an
	// upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster
	// to the same Kubernetes version. The node pool version must have the same
	// major version as the control plane. The node pool minor version must be within two minor versions of the control plane
	// version. The node pool version cannot be greater than the control plane version.
	// For more information see upgrading a node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool].
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string `json:"podSubnetID,omitempty"`

	// When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped.
	// A stopped Agent Pool stops all of its VMs and does not accrue billing
	// charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
	PowerState *PowerState `json:"powerState,omitempty"`

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`

	// This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
	ScaleDownMode *ScaleDownMode `json:"scaleDownMode,omitempty"`

	// This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`

	// The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
	ScaleSetPriority *ScaleSetPriority `json:"scaleSetPriority,omitempty"`

	// Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price.
	// For more details on spot pricing, see spot VMs pricing
	// [https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing]
	SpotMaxPrice *float32 `json:"spotMaxPrice,omitempty"`

	// The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags,omitempty"`

	// The type of Agent Pool.
	Type *AgentPoolType `json:"type,omitempty"`

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`

	// VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might
	// fail to run correctly. For more details on restricted VM sizes, see:
	// https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize *string `json:"vmSize,omitempty"`

	// If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to
	// nodes and pods, otherwise it applies to just nodes. This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// The Windows agent pool's specific profile.
	WindowsProfile *AgentPoolWindowsProfile `json:"windowsProfile,omitempty"`

	// Determines the type of workload a node can run.
	WorkloadRuntime *WorkloadRuntime `json:"workloadRuntime,omitempty"`

	// READ-ONLY; If orchestratorVersion was a fully specified version , this field will be exactly equal to it. If orchestratorVersion
	// was , this field will contain the full version being used.
	CurrentOrchestratorVersion *string `json:"currentOrchestratorVersion,omitempty" azure:"ro"`

	// READ-ONLY; The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterAutoUpgradeProfile - Auto upgrade profile for a managed cluster.
type ManagedClusterAutoUpgradeProfile struct {
	// For more information see setting the AKS cluster auto-upgrade channel [https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel].
	UpgradeChannel *UpgradeChannel `json:"upgradeChannel,omitempty"`
}

// ManagedClusterAzureMonitorProfile - Prometheus addon profile for the container service cluster
type ManagedClusterAzureMonitorProfile struct {
	// Metrics profile for the prometheus service addon
	Metrics *ManagedClusterAzureMonitorProfileMetrics `json:"metrics,omitempty"`
}

// ManagedClusterAzureMonitorProfileKubeStateMetrics - Kube State Metrics for prometheus addon profile for the container service
// cluster
type ManagedClusterAzureMonitorProfileKubeStateMetrics struct {
	// Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric.
	MetricAnnotationsAllowList *string `json:"metricAnnotationsAllowList,omitempty"`

	// Comma-separated list of Kubernetes annotations keys that will be used in the resource's labels metric.
	MetricLabelsAllowlist *string `json:"metricLabelsAllowlist,omitempty"`
}

// ManagedClusterAzureMonitorProfileMetrics - Metrics profile for the prometheus service addon
type ManagedClusterAzureMonitorProfileMetrics struct {
	// REQUIRED; Whether to enable the Prometheus collector
	Enabled *bool `json:"enabled,omitempty"`

	// Kube State Metrics for prometheus addon profile for the container service cluster
	KubeStateMetrics *ManagedClusterAzureMonitorProfileKubeStateMetrics `json:"kubeStateMetrics,omitempty"`
}

// ManagedClusterHTTPProxyConfig - Cluster HTTP proxy configuration.
type ManagedClusterHTTPProxyConfig struct {
	// The HTTP proxy server endpoint to use.
	HTTPProxy *string `json:"httpProxy,omitempty"`

	// The HTTPS proxy server endpoint to use.
	HTTPSProxy *string `json:"httpsProxy,omitempty"`

	// The endpoints that should not go through proxy.
	NoProxy []*string `json:"noProxy,omitempty"`

	// Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string `json:"trustedCa,omitempty"`

	// READ-ONLY; A read-only list of all endpoints for which traffic should not be sent to the proxy. This list is a superset
	// of noProxy and values injected by AKS.
	EffectiveNoProxy []*string `json:"effectiveNoProxy,omitempty" azure:"ro"`
}

// ManagedClusterIdentity - Identity for the managed cluster.
type ManagedClusterIdentity struct {
	// For more information see use managed identities in AKS [https://docs.microsoft.com/azure/aks/use-managed-identity].
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The keys must be ARM resource IDs in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ManagedServiceIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the system assigned identity which is used by master components.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the system assigned identity which is used by master components.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ManagedClusterIngressProfile - Ingress profile for the container service cluster.
type ManagedClusterIngressProfile struct {
	// Web App Routing settings for the ingress profile.
	WebAppRouting *ManagedClusterIngressProfileWebAppRouting `json:"webAppRouting,omitempty"`
}

// ManagedClusterIngressProfileWebAppRouting - Web App Routing settings for the ingress profile.
type ManagedClusterIngressProfileWebAppRouting struct {
	// Resource ID of the DNS Zone to be associated with the web app. Used only when Web App Routing is enabled.
	DNSZoneResourceID *string `json:"dnsZoneResourceId,omitempty"`

	// Whether to enable Web App Routing.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterListResult - The response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	// The list of managed clusters.
	Value []*ManagedCluster `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of managed cluster results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ManagedClusterLoadBalancerProfile - Profile of the managed cluster load balancer.
type ManagedClusterLoadBalancerProfile struct {
	// The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default
	// value is 0 which results in Azure dynamically allocating ports.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`

	// The type of the managed inbound Load Balancer BackendPool.
	BackendPoolType *BackendPoolType `json:"backendPoolType,omitempty"`

	// The effective outbound IP resources of the cluster load balancer.
	EffectiveOutboundIPs []*ResourceReference `json:"effectiveOutboundIPs,omitempty"`

	// Enable multiple standard load balancers per AKS cluster or not.
	EnableMultipleStandardLoadBalancers *bool `json:"enableMultipleStandardLoadBalancers,omitempty"`

	// Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value
	// is 30 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Desired managed outbound IPs for the cluster load balancer.
	ManagedOutboundIPs *ManagedClusterLoadBalancerProfileManagedOutboundIPs `json:"managedOutboundIPs,omitempty"`

	// Desired outbound IP Prefix resources for the cluster load balancer.
	OutboundIPPrefixes *ManagedClusterLoadBalancerProfileOutboundIPPrefixes `json:"outboundIPPrefixes,omitempty"`

	// Desired outbound IP resources for the cluster load balancer.
	OutboundIPs *ManagedClusterLoadBalancerProfileOutboundIPs `json:"outboundIPs,omitempty"`
}

// ManagedClusterLoadBalancerProfileManagedOutboundIPs - Desired managed outbound IPs for the cluster load balancer.
type ManagedClusterLoadBalancerProfileManagedOutboundIPs struct {
	// The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be
	// in the range of 1 to 100 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`

	// The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be
	// in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and
	// 1 for dual-stack.
	CountIPv6 *int32 `json:"countIPv6,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPPrefixes - Desired outbound IP Prefix resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPPrefixes struct {
	// A list of public IP prefix resources.
	PublicIPPrefixes []*ResourceReference `json:"publicIPPrefixes,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPs - Desired outbound IP resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPs struct {
	// A list of public IP resources.
	PublicIPs []*ResourceReference `json:"publicIPs,omitempty"`
}

// ManagedClusterManagedOutboundIPProfile - Profile of the managed outbound IP resources of the managed cluster.
type ManagedClusterManagedOutboundIPProfile struct {
	// The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive).
	// The default value is 1.
	Count *int32 `json:"count,omitempty"`
}

// ManagedClusterNATGatewayProfile - Profile of the managed cluster NAT gateway.
type ManagedClusterNATGatewayProfile struct {
	// The effective outbound IP resources of the cluster NAT gateway.
	EffectiveOutboundIPs []*ResourceReference `json:"effectiveOutboundIPs,omitempty"`

	// Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value
	// is 4 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Profile of the managed outbound IP resources of the cluster NAT gateway.
	ManagedOutboundIPProfile *ManagedClusterManagedOutboundIPProfile `json:"managedOutboundIPProfile,omitempty"`
}

// ManagedClusterOIDCIssuerProfile - The OIDC issuer profile of the Managed Cluster.
type ManagedClusterOIDCIssuerProfile struct {
	// Whether the OIDC issuer is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// READ-ONLY; The OIDC issuer url of the Managed Cluster.
	IssuerURL *string `json:"issuerURL,omitempty" azure:"ro"`
}

// ManagedClusterPodIdentity - Details about the pod identity assigned to the Managed Cluster.
type ManagedClusterPodIdentity struct {
	// REQUIRED; The user assigned identity details.
	Identity *UserAssignedIdentity `json:"identity,omitempty"`

	// REQUIRED; The name of the pod identity.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The namespace of the pod identity.
	Namespace *string `json:"namespace,omitempty"`

	// The binding selector to use for the AzureIdentityBinding resource.
	BindingSelector *string `json:"bindingSelector,omitempty"`

	// READ-ONLY
	ProvisioningInfo *ManagedClusterPodIdentityProvisioningInfo `json:"provisioningInfo,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state of the pod identity.
	ProvisioningState *ManagedClusterPodIdentityProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterPodIdentityException - See disable AAD Pod Identity for a specific Pod/Application [https://azure.github.io/aad-pod-identity/docs/configure/application_exception/]
// for more details.
type ManagedClusterPodIdentityException struct {
	// REQUIRED; The name of the pod identity exception.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The namespace of the pod identity exception.
	Namespace *string `json:"namespace,omitempty"`

	// REQUIRED; The pod labels to match.
	PodLabels map[string]*string `json:"podLabels,omitempty"`
}

// ManagedClusterPodIdentityProfile - See use AAD pod identity [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity]
// for more details on pod identity integration.
type ManagedClusterPodIdentityProfile struct {
	// Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing.
	// See using Kubenet network plugin with AAD Pod Identity
	// [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities]
	// for more information.
	AllowNetworkPluginKubenet *bool `json:"allowNetworkPluginKubenet,omitempty"`

	// Whether the pod identity addon is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// The pod identities to use in the cluster.
	UserAssignedIdentities []*ManagedClusterPodIdentity `json:"userAssignedIdentities,omitempty"`

	// The pod identity exceptions to allow.
	UserAssignedIdentityExceptions []*ManagedClusterPodIdentityException `json:"userAssignedIdentityExceptions,omitempty"`
}

// ManagedClusterPodIdentityProvisioningError - An error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningError struct {
	// Details about the error.
	Error *ManagedClusterPodIdentityProvisioningErrorBody `json:"error,omitempty"`
}

// ManagedClusterPodIdentityProvisioningErrorBody - An error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*ManagedClusterPodIdentityProvisioningErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

type ManagedClusterPodIdentityProvisioningInfo struct {
	// Pod identity assignment error (if any).
	Error *ManagedClusterPodIdentityProvisioningError `json:"error,omitempty"`
}

// ManagedClusterPoolUpgradeProfile - The list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// REQUIRED; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// REQUIRED; The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// The Agent Pool name.
	Name *string `json:"name,omitempty"`

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*ManagedClusterPoolUpgradeProfileUpgradesItem `json:"upgrades,omitempty"`
}

type ManagedClusterPoolUpgradeProfileUpgradesItem struct {
	// Whether the Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// ManagedClusterProperties - Properties of the managed cluster.
type ManagedClusterProperties struct {
	// The Azure Active Directory configuration.
	AADProfile *ManagedClusterAADProfile `json:"aadProfile,omitempty"`

	// The access profile for managed cluster API server.
	APIServerAccessProfile *ManagedClusterAPIServerAccessProfile `json:"apiServerAccessProfile,omitempty"`

	// The profile of managed cluster add-on.
	AddonProfiles map[string]*ManagedClusterAddonProfile `json:"addonProfiles,omitempty"`

	// The agent pool properties.
	AgentPoolProfiles []*ManagedClusterAgentPoolProfile `json:"agentPoolProfiles,omitempty"`

	// Parameters to be applied to the cluster-autoscaler when enabled
	AutoScalerProfile *ManagedClusterPropertiesAutoScalerProfile `json:"autoScalerProfile,omitempty"`

	// The auto upgrade configuration.
	AutoUpgradeProfile *ManagedClusterAutoUpgradeProfile `json:"autoUpgradeProfile,omitempty"`

	// Prometheus addon profile for the container service cluster
	AzureMonitorProfile *ManagedClusterAzureMonitorProfile `json:"azureMonitorProfile,omitempty"`

	// CreationData to be used to specify the source Snapshot ID if the cluster will be created/upgraded using a snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// This cannot be updated once the Managed Cluster has been created.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters
	// that are AAD enabled. For more details see disable local accounts
	// [https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview].
	DisableLocalAccounts *bool `json:"disableLocalAccounts,omitempty"`

	// This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
	DiskEncryptionSetID *string `json:"diskEncryptionSetID,omitempty"`

	// The default value is false. It can be enabled/disabled on creation and updation of the managed cluster. See https://aka.ms/NamespaceARMResource
	// [https://aka.ms/NamespaceARMResource] for more details
	// on Namespace as a ARM Resource.
	EnableNamespaceResources *bool `json:"enableNamespaceResources,omitempty"`

	// (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th,
	// 2020. Learn more at aka.ms/aks/azpodpolicy.
	EnablePodSecurityPolicy *bool `json:"enablePodSecurityPolicy,omitempty"`

	// Whether to enable Kubernetes Role-Based Access Control.
	EnableRBAC *bool `json:"enableRBAC,omitempty"`

	// This cannot be updated once the Managed Cluster has been created.
	FqdnSubdomain *string `json:"fqdnSubdomain,omitempty"`

	// The guardrails profile holds all the guardrails information for a given cluster
	GuardrailsProfile *GuardrailsProfile `json:"guardrailsProfile,omitempty"`

	// Configurations for provisioning the cluster with HTTP proxy servers.
	HTTPProxyConfig *ManagedClusterHTTPProxyConfig `json:"httpProxyConfig,omitempty"`

	// Identities associated with the cluster.
	IdentityProfile map[string]*UserAssignedIdentity `json:"identityProfile,omitempty"`

	// Ingress profile for the managed cluster.
	IngressProfile *ManagedClusterIngressProfile `json:"ingressProfile,omitempty"`

	// When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially
	// by major version number. For example, upgrades between 1.14.x ->
	// 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See upgrading an AKS cluster [https://docs.microsoft.com/azure/aks/upgrade-cluster]
	// for more details.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// The profile for Linux VMs in the Managed Cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`

	// The network configuration profile.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// The name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`

	// The OIDC issuer profile of the Managed Cluster.
	OidcIssuerProfile *ManagedClusterOIDCIssuerProfile `json:"oidcIssuerProfile,omitempty"`

	// See use AAD pod identity [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity] for more details on AAD pod identity
	// integration.
	PodIdentityProfile *ManagedClusterPodIdentityProfile `json:"podIdentityProfile,omitempty"`

	// Private link resources associated with the cluster.
	PrivateLinkResources []*PrivateLinkResource `json:"privateLinkResources,omitempty"`

	// Allow or deny public network access for AKS
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Security profile for the managed cluster.
	SecurityProfile *ManagedClusterSecurityProfile `json:"securityProfile,omitempty"`

	// Information about a service principal identity for the cluster to use for manipulating Azure APIs.
	ServicePrincipalProfile *ManagedClusterServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`

	// Storage profile for the managed cluster.
	StorageProfile *ManagedClusterStorageProfile `json:"storageProfile,omitempty"`

	// The profile for Windows VMs in the Managed Cluster.
	WindowsProfile *ManagedClusterWindowsProfile `json:"windowsProfile,omitempty"`

	// Workload Auto-scaler profile for the container service cluster.
	WorkloadAutoScalerProfile *ManagedClusterWorkloadAutoScalerProfile `json:"workloadAutoScalerProfile,omitempty"`

	// READ-ONLY; The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses,
	// which Kubernetes APIServer doesn't handle by default. This special FQDN supports CORS,
	// allowing the Azure Portal to function properly.
	AzurePortalFQDN *string `json:"azurePortalFQDN,omitempty" azure:"ro"`

	// READ-ONLY; The version of Kubernetes the Managed Cluster is running.
	CurrentKubernetesVersion *string `json:"currentKubernetesVersion,omitempty" azure:"ro"`

	// READ-ONLY; The FQDN of the master pool.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The max number of agent pools for the managed cluster.
	MaxAgentPools *int32 `json:"maxAgentPools,omitempty" azure:"ro"`

	// READ-ONLY; The Power State of the cluster.
	PowerState *PowerState `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; The FQDN of private cluster.
	PrivateFQDN *string `json:"privateFQDN,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterPropertiesAutoScalerProfile - Parameters to be applied to the cluster-autoscaler when enabled
type ManagedClusterPropertiesAutoScalerProfile struct {
	// Valid values are 'true' and 'false'
	BalanceSimilarNodeGroups *string `json:"balance-similar-node-groups,omitempty"`

	// If not specified, the default is 'random'. See expanders [https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders]
	// for more information.
	Expander *Expander `json:"expander,omitempty"`

	// The default is 10.
	MaxEmptyBulkDelete *string `json:"max-empty-bulk-delete,omitempty"`

	// The default is 600.
	MaxGracefulTerminationSec *string `json:"max-graceful-termination-sec,omitempty"`

	// The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	MaxNodeProvisionTime *string `json:"max-node-provision-time,omitempty"`

	// The default is 45. The maximum is 100 and the minimum is 0.
	MaxTotalUnreadyPercentage *string `json:"max-total-unready-percentage,omitempty"`

	// For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all
	// the pods, you can tell CA to ignore unscheduled pods before they're a certain
	// age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours,
	// etc).
	NewPodScaleUpDelay *string `json:"new-pod-scale-up-delay,omitempty"`

	// This must be an integer. The default is 3.
	OkTotalUnreadyCount *string `json:"ok-total-unready-count,omitempty"`

	// The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterAdd *string `json:"scale-down-delay-after-add,omitempty"`

	// The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m)
	// is supported.
	ScaleDownDelayAfterDelete *string `json:"scale-down-delay-after-delete,omitempty"`

	// The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterFailure *string `json:"scale-down-delay-after-failure,omitempty"`

	// The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnneededTime *string `json:"scale-down-unneeded-time,omitempty"`

	// The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnreadyTime *string `json:"scale-down-unready-time,omitempty"`

	// The default is '0.5'.
	ScaleDownUtilizationThreshold *string `json:"scale-down-utilization-threshold,omitempty"`

	// The default is '10'. Values must be an integer number of seconds.
	ScanInterval *string `json:"scan-interval,omitempty"`

	// The default is true.
	SkipNodesWithLocalStorage *string `json:"skip-nodes-with-local-storage,omitempty"`

	// The default is true.
	SkipNodesWithSystemPods *string `json:"skip-nodes-with-system-pods,omitempty"`
}

// ManagedClusterPropertiesForSnapshot - managed cluster properties for snapshot, these properties are read only.
type ManagedClusterPropertiesForSnapshot struct {
	// Whether the cluster has enabled Kubernetes Role-Based Access Control or not.
	EnableRbac *bool `json:"enableRbac,omitempty"`

	// The current kubernetes version.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// The current managed cluster sku.
	SKU *ManagedClusterSKU `json:"sku,omitempty"`

	// READ-ONLY; The current network profile.
	NetworkProfile *NetworkProfileForSnapshot `json:"networkProfile,omitempty" azure:"ro"`
}

// ManagedClusterSKU - The SKU of a Managed Cluster.
type ManagedClusterSKU struct {
	// The name of a managed cluster SKU.
	Name *ManagedClusterSKUName `json:"name,omitempty"`

	// If not specified, the default is 'Free'. See uptime SLA [https://docs.microsoft.com/azure/aks/uptime-sla] for more details.
	Tier *ManagedClusterSKUTier `json:"tier,omitempty"`
}

// ManagedClusterSecurityProfile - Security profile for the container service cluster.
type ManagedClusterSecurityProfile struct {
	// Azure Key Vault key management service [https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/] settings for
	// the security profile.
	AzureKeyVaultKms *AzureKeyVaultKms `json:"azureKeyVaultKms,omitempty"`

	// A list of up to 10 base64 encoded CAs that will be added to the trust store on nodes with the Custom CA Trust feature enabled.
	// For more information see Custom CA Trust Certificates
	// [https://learn.microsoft.com/en-us/azure/aks/custom-certificate-authority]
	CustomCATrustCertificates [][]byte `json:"customCATrustCertificates,omitempty"`

	// Microsoft Defender settings for the security profile.
	Defender *ManagedClusterSecurityProfileDefender `json:"defender,omitempty"`

	// ImageCleaner settings for the security profile.
	ImageCleaner *ManagedClusterSecurityProfileImageCleaner `json:"imageCleaner,omitempty"`

	// Node Restriction [https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#noderestriction] settings
	// for the security profile.
	NodeRestriction *ManagedClusterSecurityProfileNodeRestriction `json:"nodeRestriction,omitempty"`

	// Workload Identity [https://azure.github.io/azure-workload-identity/docs/] settings for the security profile.
	WorkloadIdentity *ManagedClusterSecurityProfileWorkloadIdentity `json:"workloadIdentity,omitempty"`
}

// ManagedClusterSecurityProfileDefender - Microsoft Defender settings for the security profile.
type ManagedClusterSecurityProfileDefender struct {
	// Resource ID of the Log Analytics workspace to be associated with Microsoft Defender. When Microsoft Defender is enabled,
	// this field is required and must be a valid workspace resource ID. When
	// Microsoft Defender is disabled, leave the field empty.
	LogAnalyticsWorkspaceResourceID *string `json:"logAnalyticsWorkspaceResourceId,omitempty"`

	// Microsoft Defender threat detection for Cloud settings for the security profile.
	SecurityMonitoring *ManagedClusterSecurityProfileDefenderSecurityMonitoring `json:"securityMonitoring,omitempty"`
}

// ManagedClusterSecurityProfileDefenderSecurityMonitoring - Microsoft Defender settings for the security profile threat detection.
type ManagedClusterSecurityProfileDefenderSecurityMonitoring struct {
	// Whether to enable Defender threat detection
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterSecurityProfileImageCleaner - ImageCleaner removes unused images from nodes, freeing up disk space and helping
// to reduce attack surface area. Here are settings for the security profile.
type ManagedClusterSecurityProfileImageCleaner struct {
	// Whether to enable ImageCleaner on AKS cluster.
	Enabled *bool `json:"enabled,omitempty"`

	// ImageCleaner scanning interval.
	IntervalHours *int32 `json:"intervalHours,omitempty"`
}

// ManagedClusterSecurityProfileNodeRestriction - Node Restriction settings for the security profile.
type ManagedClusterSecurityProfileNodeRestriction struct {
	// Whether to enable Node Restriction
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterSecurityProfileWorkloadIdentity - Workload Identity settings for the security profile.
type ManagedClusterSecurityProfileWorkloadIdentity struct {
	// Whether to enable Workload Identity
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating
// Azure APIs.
type ManagedClusterServicePrincipalProfile struct {
	// REQUIRED; The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`

	// The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
}

// ManagedClusterSnapshot - A managed cluster snapshot resource.
type ManagedClusterSnapshot struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a managed cluster snapshot.
	Properties *ManagedClusterSnapshotProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterSnapshotListResult - The response from the List Managed Cluster Snapshots operation.
type ManagedClusterSnapshotListResult struct {
	// The list of managed cluster snapshots.
	Value []*ManagedClusterSnapshot `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of managed cluster snapshot results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ManagedClusterSnapshotProperties - Properties for a managed cluster snapshot.
type ManagedClusterSnapshotProperties struct {
	// CreationData to be used to specify the source resource ID to create this snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// The type of a snapshot. The default is NodePool.
	SnapshotType *SnapshotType `json:"snapshotType,omitempty"`

	// READ-ONLY; What the properties will be showed when getting managed cluster snapshot. Those properties are read-only.
	ManagedClusterPropertiesReadOnly *ManagedClusterPropertiesForSnapshot `json:"managedClusterPropertiesReadOnly,omitempty" azure:"ro"`
}

// ManagedClusterSnapshotsClientCreateOrUpdateOptions contains the optional parameters for the ManagedClusterSnapshotsClient.CreateOrUpdate
// method.
type ManagedClusterSnapshotsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedClusterSnapshotsClientDeleteOptions contains the optional parameters for the ManagedClusterSnapshotsClient.Delete
// method.
type ManagedClusterSnapshotsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagedClusterSnapshotsClientGetOptions contains the optional parameters for the ManagedClusterSnapshotsClient.Get method.
type ManagedClusterSnapshotsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedClusterSnapshotsClientListByResourceGroupOptions contains the optional parameters for the ManagedClusterSnapshotsClient.ListByResourceGroup
// method.
type ManagedClusterSnapshotsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ManagedClusterSnapshotsClientListOptions contains the optional parameters for the ManagedClusterSnapshotsClient.List method.
type ManagedClusterSnapshotsClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagedClusterSnapshotsClientUpdateTagsOptions contains the optional parameters for the ManagedClusterSnapshotsClient.UpdateTags
// method.
type ManagedClusterSnapshotsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ManagedClusterStorageProfile - Storage profile for the container service cluster.
type ManagedClusterStorageProfile struct {
	// AzureBlob CSI Driver settings for the storage profile.
	BlobCSIDriver *ManagedClusterStorageProfileBlobCSIDriver `json:"blobCSIDriver,omitempty"`

	// AzureDisk CSI Driver settings for the storage profile.
	DiskCSIDriver *ManagedClusterStorageProfileDiskCSIDriver `json:"diskCSIDriver,omitempty"`

	// AzureFile CSI Driver settings for the storage profile.
	FileCSIDriver *ManagedClusterStorageProfileFileCSIDriver `json:"fileCSIDriver,omitempty"`

	// Snapshot Controller settings for the storage profile.
	SnapshotController *ManagedClusterStorageProfileSnapshotController `json:"snapshotController,omitempty"`
}

// ManagedClusterStorageProfileBlobCSIDriver - AzureBlob CSI Driver settings for the storage profile.
type ManagedClusterStorageProfileBlobCSIDriver struct {
	// Whether to enable AzureBlob CSI Driver. The default value is false.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterStorageProfileDiskCSIDriver - AzureDisk CSI Driver settings for the storage profile.
type ManagedClusterStorageProfileDiskCSIDriver struct {
	// Whether to enable AzureDisk CSI Driver. The default value is true.
	Enabled *bool `json:"enabled,omitempty"`

	// The version of AzureDisk CSI Driver. The default value is v1.
	Version *string `json:"version,omitempty"`
}

// ManagedClusterStorageProfileFileCSIDriver - AzureFile CSI Driver settings for the storage profile.
type ManagedClusterStorageProfileFileCSIDriver struct {
	// Whether to enable AzureFile CSI Driver. The default value is true.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterStorageProfileSnapshotController - Snapshot Controller settings for the storage profile.
type ManagedClusterStorageProfileSnapshotController struct {
	// Whether to enable Snapshot Controller. The default value is true.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagedClusterUpgradeProfile - The list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	// REQUIRED; The properties of the upgrade profile.
	Properties *ManagedClusterUpgradeProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the upgrade profile.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the upgrade profile.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the upgrade profile.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterUpgradeProfileProperties - Control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// REQUIRED; The list of available upgrade versions for agent pools.
	AgentPoolProfiles []*ManagedClusterPoolUpgradeProfile `json:"agentPoolProfiles,omitempty"`

	// REQUIRED; The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile `json:"controlPlaneProfile,omitempty"`
}

// ManagedClusterWindowsProfile - Profile for Windows VMs in the managed cluster.
type ManagedClusterWindowsProfile struct {
	// REQUIRED; Specifies the name of the administrator account.
	// Restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length: 1 character
	// Max-length: 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`

	// Specifies the password of the administrator account.
	// Minimum-length: 8 characters
	// Max-length: 123 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
	// "Password22", "iloveyou!"
	AdminPassword *string `json:"adminPassword,omitempty"`

	// For more details on CSI proxy, see the CSI proxy GitHub repo [https://github.com/kubernetes-csi/csi-proxy].
	EnableCSIProxy *bool `json:"enableCSIProxy,omitempty"`

	// The Windows gMSA Profile in the Managed Cluster.
	GmsaProfile *WindowsGmsaProfile `json:"gmsaProfile,omitempty"`

	// The license type to use for Windows VMs. See Azure Hybrid User Benefits [https://azure.microsoft.com/pricing/hybrid-benefit/faq/]
	// for more details.
	LicenseType *LicenseType `json:"licenseType,omitempty"`
}

// ManagedClusterWorkloadAutoScalerProfile - Workload Auto-scaler profile for the container service cluster.
type ManagedClusterWorkloadAutoScalerProfile struct {
	// KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
	Keda                  *ManagedClusterWorkloadAutoScalerProfileKeda                  `json:"keda,omitempty"`
	VerticalPodAutoscaler *ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler `json:"verticalPodAutoscaler,omitempty"`
}

// ManagedClusterWorkloadAutoScalerProfileKeda - KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler
// profile.
type ManagedClusterWorkloadAutoScalerProfileKeda struct {
	// REQUIRED; Whether to enable KEDA.
	Enabled *bool `json:"enabled,omitempty"`
}

type ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler struct {
	// REQUIRED; Controls which resource value autoscaler will change. Default value is RequestsAndLimits.
	ControlledValues *ControlledValues `json:"controlledValues,omitempty"`

	// REQUIRED; Whether to enable VPA. Default value is false.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; Each update mode level is a superset of the lower levels. Off<Initial<Recreate<=Auto. For example: if UpdateMode
	// is Initial, it means VPA sets the recommended resources in the VerticalPodAutoscaler
	// Custom Resource (from UpdateMode Off) and also assigns resources on pod creation (from Initial). The default value is Off.
	UpdateMode *UpdateMode `json:"updateMode,omitempty"`
}

// ManagedClustersClientAbortLatestOperationOptions contains the optional parameters for the ManagedClustersClient.AbortLatestOperation
// method.
type ManagedClustersClientAbortLatestOperationOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedClustersClient.BeginCreateOrUpdate
// method.
type ManagedClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginDeleteOptions contains the optional parameters for the ManagedClustersClient.BeginDelete method.
type ManagedClustersClientBeginDeleteOptions struct {
	// ignore-pod-disruption-budget=true to delete those pods on a node without considering Pod Disruption Budget
	IgnorePodDisruptionBudget *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginResetAADProfileOptions contains the optional parameters for the ManagedClustersClient.BeginResetAADProfile
// method.
type ManagedClustersClientBeginResetAADProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginResetServicePrincipalProfileOptions contains the optional parameters for the ManagedClustersClient.BeginResetServicePrincipalProfile
// method.
type ManagedClustersClientBeginResetServicePrincipalProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginRotateClusterCertificatesOptions contains the optional parameters for the ManagedClustersClient.BeginRotateClusterCertificates
// method.
type ManagedClustersClientBeginRotateClusterCertificatesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginRotateServiceAccountSigningKeysOptions contains the optional parameters for the ManagedClustersClient.BeginRotateServiceAccountSigningKeys
// method.
type ManagedClustersClientBeginRotateServiceAccountSigningKeysOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginRunCommandOptions contains the optional parameters for the ManagedClustersClient.BeginRunCommand
// method.
type ManagedClustersClientBeginRunCommandOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginStartOptions contains the optional parameters for the ManagedClustersClient.BeginStart method.
type ManagedClustersClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginStopOptions contains the optional parameters for the ManagedClustersClient.BeginStop method.
type ManagedClustersClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientBeginUpdateTagsOptions contains the optional parameters for the ManagedClustersClient.BeginUpdateTags
// method.
type ManagedClustersClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedClustersClientGetAccessProfileOptions contains the optional parameters for the ManagedClustersClient.GetAccessProfile
// method.
type ManagedClustersClientGetAccessProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientGetCommandResultOptions contains the optional parameters for the ManagedClustersClient.GetCommandResult
// method.
type ManagedClustersClientGetCommandResultOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientGetOSOptionsOptions contains the optional parameters for the ManagedClustersClient.GetOSOptions method.
type ManagedClustersClientGetOSOptionsOptions struct {
	// The resource type for which the OS options needs to be returned
	ResourceType *string
}

// ManagedClustersClientGetOptions contains the optional parameters for the ManagedClustersClient.Get method.
type ManagedClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientGetUpgradeProfileOptions contains the optional parameters for the ManagedClustersClient.GetUpgradeProfile
// method.
type ManagedClustersClientGetUpgradeProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListByResourceGroupOptions contains the optional parameters for the ManagedClustersClient.ListByResourceGroup
// method.
type ManagedClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListClusterAdminCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterAdminCredentials
// method.
type ManagedClustersClientListClusterAdminCredentialsOptions struct {
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersClientListClusterMonitoringUserCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterMonitoringUserCredentials
// method.
type ManagedClustersClientListClusterMonitoringUserCredentialsOptions struct {
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersClientListClusterUserCredentialsOptions contains the optional parameters for the ManagedClustersClient.ListClusterUserCredentials
// method.
type ManagedClustersClientListClusterUserCredentialsOptions struct {
	// Only apply to AAD clusters, specifies the format of returned kubeconfig. Format 'azure' will return azure auth-provider
	// kubeconfig; format 'exec' will return exec format kubeconfig, which requires
	// kubelogin binary in the path.
	Format *Format
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersClientListOptions contains the optional parameters for the ManagedClustersClient.List method.
type ManagedClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersClientListOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the ManagedClustersClient.ListOutboundNetworkDependenciesEndpoints
// method.
type ManagedClustersClientListOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

type ManagedServiceIdentityUserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// NetworkProfile - Profile of network configuration.
type NetworkProfile struct {
	// An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified
	// in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`

	// A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes
	// service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`

	// The eBPF dataplane used for building the Kubernetes network.
	EbpfDataplane *EbpfDataplane `json:"ebpfDataplane,omitempty"`

	// IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For
	// dual-stack, the expected values are IPv4 and IPv6.
	IPFamilies []*IPFamily `json:"ipFamilies,omitempty"`

	// Holds configuration customizations for kube-proxy. Any values not defined will use the kube-proxy defaulting behavior.
	// See https://v
	// .docs.kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/ where is represented by a - string. Kubernetes
	// version 1.23 would be '1-23'.
	KubeProxyConfig *NetworkProfileKubeProxyConfig `json:"kubeProxyConfig,omitempty"`

	// Profile of the cluster load balancer.
	LoadBalancerProfile *ManagedClusterLoadBalancerProfile `json:"loadBalancerProfile,omitempty"`

	// The default is 'standard'. See Azure Load Balancer SKUs [https://docs.microsoft.com/azure/load-balancer/skus] for more
	// information about the differences between load balancer SKUs.
	LoadBalancerSKU *LoadBalancerSKU `json:"loadBalancerSku,omitempty"`

	// Profile of the cluster NAT gateway.
	NatGatewayProfile *ManagedClusterNATGatewayProfile `json:"natGatewayProfile,omitempty"`

	// This cannot be specified if networkPlugin is anything other than 'azure'.
	NetworkMode *NetworkMode `json:"networkMode,omitempty"`

	// Network plugin used for building the Kubernetes network.
	NetworkPlugin *NetworkPlugin `json:"networkPlugin,omitempty"`

	// Network plugin mode used for building the Kubernetes network.
	NetworkPluginMode *NetworkPluginMode `json:"networkPluginMode,omitempty"`

	// Network policy used for building the Kubernetes network.
	NetworkPolicy *NetworkPolicy `json:"networkPolicy,omitempty"`

	// This can only be set at cluster creation time and cannot be changed later. For more information see egress outbound type
	// [https://docs.microsoft.com/azure/aks/egress-outboundtype].
	OutboundType *OutboundType `json:"outboundType,omitempty"`

	// A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string `json:"podCidr,omitempty"`

	// One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
	// networking.
	PodCidrs []*string `json:"podCidrs,omitempty"`

	// A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`

	// One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
	// networking. They must not overlap with any Subnet IP ranges.
	ServiceCidrs []*string `json:"serviceCidrs,omitempty"`
}

// NetworkProfileForSnapshot - network profile for managed cluster snapshot, these properties are read only.
type NetworkProfileForSnapshot struct {
	// loadBalancerSku for managed cluster snapshot.
	LoadBalancerSKU *LoadBalancerSKU `json:"loadBalancerSku,omitempty"`

	// networkMode for managed cluster snapshot.
	NetworkMode *NetworkMode `json:"networkMode,omitempty"`

	// networkPlugin for managed cluster snapshot.
	NetworkPlugin *NetworkPlugin `json:"networkPlugin,omitempty"`

	// NetworkPluginMode for managed cluster snapshot.
	NetworkPluginMode *NetworkPluginMode `json:"networkPluginMode,omitempty"`

	// networkPolicy for managed cluster snapshot.
	NetworkPolicy *NetworkPolicy `json:"networkPolicy,omitempty"`
}

// NetworkProfileKubeProxyConfig - Holds configuration customizations for kube-proxy. Any values not defined will use the
// kube-proxy defaulting behavior. See https://v
// .docs.kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/ where is represented by a - string. Kubernetes
// version 1.23 would be '1-23'.
type NetworkProfileKubeProxyConfig struct {
	// Whether to enable on kube-proxy on the cluster (if no 'kubeProxyConfig' exists, kube-proxy is enabled in AKS by default
	// without these customizations).
	Enabled *bool `json:"enabled,omitempty"`

	// Holds configuration customizations for IPVS. May only be specified if 'mode' is set to 'IPVS'.
	IpvsConfig *NetworkProfileKubeProxyConfigIpvsConfig `json:"ipvsConfig,omitempty"`

	// Specify which proxy mode to use ('IPTABLES' or 'IPVS')
	Mode *Mode `json:"mode,omitempty"`
}

// NetworkProfileKubeProxyConfigIpvsConfig - Holds configuration customizations for IPVS. May only be specified if 'mode'
// is set to 'IPVS'.
type NetworkProfileKubeProxyConfigIpvsConfig struct {
	// IPVS scheduler, for more information please see http://www.linuxvirtualserver.org/docs/scheduling.html.
	Scheduler *IpvsScheduler `json:"scheduler,omitempty"`

	// The timeout value used for IPVS TCP sessions after receiving a FIN in seconds. Must be a positive integer value.
	TCPFinTimeoutSeconds *int32 `json:"tcpFinTimeoutSeconds,omitempty"`

	// The timeout value used for idle IPVS TCP sessions in seconds. Must be a positive integer value.
	TCPTimeoutSeconds *int32 `json:"tcpTimeoutSeconds,omitempty"`

	// The timeout value used for IPVS UDP packets in seconds. Must be a positive integer value.
	UDPTimeoutSeconds *int32 `json:"udpTimeoutSeconds,omitempty"`
}

// OSOptionProfile - The OS option profile.
type OSOptionProfile struct {
	// REQUIRED; The list of OS options.
	Properties *OSOptionPropertyList `json:"properties,omitempty"`

	// READ-ONLY; The ID of the OS option resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the OS option resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the OS option resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OSOptionProperty - OS option property.
type OSOptionProperty struct {
	// REQUIRED; Whether the image is FIPS-enabled.
	EnableFipsImage *bool `json:"enable-fips-image,omitempty"`

	// REQUIRED; The OS type.
	OSType *string `json:"os-type,omitempty"`
}

// OSOptionPropertyList - The list of OS option properties.
type OSOptionPropertyList struct {
	// REQUIRED; The list of OS options.
	OSOptionPropertyList []*OSOptionProperty `json:"osOptionPropertyList,omitempty"`
}

// OperationListResult - The List Operation response.
type OperationListResult struct {
	// READ-ONLY; The list of operations
	Value []*OperationValue `json:"value,omitempty" azure:"ro"`
}

// OperationValue - Describes the properties of a Operation value.
type OperationValue struct {
	// Describes the properties of a Operation Value Display.
	Display *OperationValueDisplay `json:"display,omitempty"`

	// READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationValueDisplay - Describes the properties of a Operation Value Display.
type OperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OutboundEnvironmentEndpoint - Egress endpoints which AKS agent nodes connect to for common purpose.
type OutboundEnvironmentEndpoint struct {
	// The category of endpoints accessed by the AKS agent node, e.g. azure-resource-management, apiserver, etc.
	Category *string `json:"category,omitempty"`

	// The endpoints that AKS agent nodes connect to
	Endpoints []*EndpointDependency `json:"endpoints,omitempty"`
}

// OutboundEnvironmentEndpointCollection - Collection of OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PortRange - The port range.
type PortRange struct {
	// The maximum port that is included in the range. It should be ranged from 1 to 65535, and be greater than or equal to portStart.
	PortEnd *int32 `json:"portEnd,omitempty"`

	// The minimum port that is included in the range. It should be ranged from 1 to 65535, and be less than or equal to portEnd.
	PortStart *int32 `json:"portStart,omitempty"`

	// The network protocol of the port.
	Protocol *Protocol `json:"protocol,omitempty"`
}

// PowerState - Describes the Power State of the cluster
type PowerState struct {
	// Tells whether the cluster is Running or Stopped
	Code *Code `json:"code,omitempty"`
}

// PrivateEndpoint - Private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// The resource ID of the private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// The properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the private endpoint connection.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the private endpoint connection.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// The collection value.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The current provisioning state.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Update
// method.
type PrivateEndpointConnectionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// The group ID of the resource.
	GroupID *string `json:"groupId,omitempty"`

	// The ID of the private link resource.
	ID *string `json:"id,omitempty"`

	// The name of the private link resource.
	Name *string `json:"name,omitempty"`

	// The RequiredMembers of the resource
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The private link service ID of the resource, this field is exposed only to NRP internally.
	PrivateLinkServiceID *string `json:"privateLinkServiceID,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesListResult - A list of private link resources
type PrivateLinkResourcesListResult struct {
	// The collection value.
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkServiceConnectionState - The state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// The private link service connection description.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *ConnectionStatus `json:"status,omitempty"`
}

// ResolvePrivateLinkServiceIDClientPOSTOptions contains the optional parameters for the ResolvePrivateLinkServiceIDClient.POST
// method.
type ResolvePrivateLinkServiceIDClientPOSTOptions struct {
	// placeholder for future optional parameters
}

// ResourceReference - A reference to an Azure resource.
type ResourceReference struct {
	// The fully qualified Azure resource id.
	ID *string `json:"id,omitempty"`
}

// RunCommandRequest - A run command request
type RunCommandRequest struct {
	// REQUIRED; The command to run.
	Command *string `json:"command,omitempty"`

	// AuthToken issued for AKS AAD Server App.
	ClusterToken *string `json:"clusterToken,omitempty"`

	// A base64 encoded zip file containing the files required by the command.
	Context *string `json:"context,omitempty"`
}

// RunCommandResult - run command result.
type RunCommandResult struct {
	// Properties of command result.
	Properties *CommandResultProperties `json:"properties,omitempty"`

	// READ-ONLY; The command id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SSHConfiguration - SSH configuration for Linux-based VMs running on Azure.
type SSHConfiguration struct {
	// REQUIRED; The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
	PublicKeys []*SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey - Contains information about SSH certificate public key data.
type SSHPublicKey struct {
	// REQUIRED; Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with
	// or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// Snapshot - A node pool snapshot resource.
type Snapshot struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of a snapshot.
	Properties *SnapshotProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotListResult - The response from the List Snapshots operation.
type SnapshotListResult struct {
	// The list of snapshots.
	Value []*Snapshot `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of snapshot results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SnapshotProperties - Properties used to configure a node pool snapshot.
type SnapshotProperties struct {
	// CreationData to be used to specify the source agent pool resource ID to create this snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// The type of a snapshot. The default is NodePool.
	SnapshotType *SnapshotType `json:"snapshotType,omitempty"`

	// READ-ONLY; Whether to use a FIPS-enabled OS.
	EnableFIPS *bool `json:"enableFIPS,omitempty" azure:"ro"`

	// READ-ONLY; The version of Kubernetes.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty" azure:"ro"`

	// READ-ONLY; The version of node image.
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the OS SKU used by the agent pool. If not specified, the default is Ubuntu if OSType=Linux or Windows2019
	// if OSType=Windows. And the default Windows OSSKU will be changed to Windows2022
	// after Windows2019 is deprecated.
	OSSKU *OSSKU `json:"osSku,omitempty" azure:"ro"`

	// READ-ONLY; The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; The size of the VM.
	VMSize *string `json:"vmSize,omitempty" azure:"ro"`
}

// SnapshotsClientCreateOrUpdateOptions contains the optional parameters for the SnapshotsClient.CreateOrUpdate method.
type SnapshotsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientDeleteOptions contains the optional parameters for the SnapshotsClient.Delete method.
type SnapshotsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientGetOptions contains the optional parameters for the SnapshotsClient.Get method.
type SnapshotsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientListByResourceGroupOptions contains the optional parameters for the SnapshotsClient.ListByResourceGroup
// method.
type SnapshotsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientListOptions contains the optional parameters for the SnapshotsClient.List method.
type SnapshotsClientListOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientUpdateTagsOptions contains the optional parameters for the SnapshotsClient.UpdateTags method.
type SnapshotsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// SysctlConfig - Sysctl settings for Linux agent nodes.
type SysctlConfig struct {
	// Sysctl setting fs.aio-max-nr.
	FsAioMaxNr *int32 `json:"fsAioMaxNr,omitempty"`

	// Sysctl setting fs.file-max.
	FsFileMax *int32 `json:"fsFileMax,omitempty"`

	// Sysctl setting fs.inotify.maxuserwatches.
	FsInotifyMaxUserWatches *int32 `json:"fsInotifyMaxUserWatches,omitempty"`

	// Sysctl setting fs.nr_open.
	FsNrOpen *int32 `json:"fsNrOpen,omitempty"`

	// Sysctl setting kernel.threads-max.
	KernelThreadsMax *int32 `json:"kernelThreadsMax,omitempty"`

	// Sysctl setting net.core.netdevmaxbacklog.
	NetCoreNetdevMaxBacklog *int32 `json:"netCoreNetdevMaxBacklog,omitempty"`

	// Sysctl setting net.core.optmem_max.
	NetCoreOptmemMax *int32 `json:"netCoreOptmemMax,omitempty"`

	// Sysctl setting net.core.rmem_default.
	NetCoreRmemDefault *int32 `json:"netCoreRmemDefault,omitempty"`

	// Sysctl setting net.core.rmem_max.
	NetCoreRmemMax *int32 `json:"netCoreRmemMax,omitempty"`

	// Sysctl setting net.core.somaxconn.
	NetCoreSomaxconn *int32 `json:"netCoreSomaxconn,omitempty"`

	// Sysctl setting net.core.wmem_default.
	NetCoreWmemDefault *int32 `json:"netCoreWmemDefault,omitempty"`

	// Sysctl setting net.core.wmem_max.
	NetCoreWmemMax *int32 `json:"netCoreWmemMax,omitempty"`

	// Sysctl setting net.ipv4.iplocalport_range.
	NetIPv4IPLocalPortRange *string `json:"netIpv4IpLocalPortRange,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh1.
	NetIPv4NeighDefaultGcThresh1 *int32 `json:"netIpv4NeighDefaultGcThresh1,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh2.
	NetIPv4NeighDefaultGcThresh2 *int32 `json:"netIpv4NeighDefaultGcThresh2,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh3.
	NetIPv4NeighDefaultGcThresh3 *int32 `json:"netIpv4NeighDefaultGcThresh3,omitempty"`

	// Sysctl setting net.ipv4.tcpfintimeout.
	NetIPv4TCPFinTimeout *int32 `json:"netIpv4TcpFinTimeout,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepaliveprobes.
	NetIPv4TCPKeepaliveProbes *int32 `json:"netIpv4TcpKeepaliveProbes,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepalivetime.
	NetIPv4TCPKeepaliveTime *int32 `json:"netIpv4TcpKeepaliveTime,omitempty"`

	// Sysctl setting net.ipv4.tcpmaxsyn_backlog.
	NetIPv4TCPMaxSynBacklog *int32 `json:"netIpv4TcpMaxSynBacklog,omitempty"`

	// Sysctl setting net.ipv4.tcpmaxtw_buckets.
	NetIPv4TCPMaxTwBuckets *int32 `json:"netIpv4TcpMaxTwBuckets,omitempty"`

	// Sysctl setting net.ipv4.tcptwreuse.
	NetIPv4TCPTwReuse *bool `json:"netIpv4TcpTwReuse,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepaliveintvl.
	NetIPv4TcpkeepaliveIntvl *int32 `json:"netIpv4TcpkeepaliveIntvl,omitempty"`

	// Sysctl setting net.netfilter.nfconntrackbuckets.
	NetNetfilterNfConntrackBuckets *int32 `json:"netNetfilterNfConntrackBuckets,omitempty"`

	// Sysctl setting net.netfilter.nfconntrackmax.
	NetNetfilterNfConntrackMax *int32 `json:"netNetfilterNfConntrackMax,omitempty"`

	// Sysctl setting vm.maxmapcount.
	VMMaxMapCount *int32 `json:"vmMaxMapCount,omitempty"`

	// Sysctl setting vm.swappiness.
	VMSwappiness *int32 `json:"vmSwappiness,omitempty"`

	// Sysctl setting vm.vfscachepressure.
	VMVfsCachePressure *int32 `json:"vmVfsCachePressure,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TimeInWeek - Time in a week.
type TimeInWeek struct {
	// The day of the week.
	Day *WeekDay `json:"day,omitempty"`

	// Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds
	// to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the
	// 00:00 - 02:00 UTC time range.
	HourSlots []*int32 `json:"hourSlots,omitempty"`
}

// TimeSpan - For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
type TimeSpan struct {
	// The end of a time span
	End *time.Time `json:"end,omitempty"`

	// The start of a time span
	Start *time.Time `json:"start,omitempty"`
}

// TrustedAccessRole - Trusted access role definition.
type TrustedAccessRole struct {
	// READ-ONLY; Name of role, name is unique under a source resource type
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; List of rules for the role. This maps to 'rules' property of Kubernetes Cluster Role [https://kubernetes.io/docs/reference/kubernetes-api/authorization-resources/cluster-role-v1/#ClusterRole].
	Rules []*TrustedAccessRoleRule `json:"rules,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of Azure resource
	SourceResourceType *string `json:"sourceResourceType,omitempty" azure:"ro"`
}

// TrustedAccessRoleBinding - Defines binding between a resource and role
type TrustedAccessRoleBinding struct {
	// REQUIRED; Properties for trusted access role binding
	Properties *TrustedAccessRoleBindingProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TrustedAccessRoleBindingListResult - List of trusted access role bindings
type TrustedAccessRoleBindingListResult struct {
	// Role binding list
	Value []*TrustedAccessRoleBinding `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TrustedAccessRoleBindingProperties - Properties for trusted access role binding
type TrustedAccessRoleBindingProperties struct {
	// REQUIRED; A list of roles to bind, each item is a resource type qualified role name. For example: 'Microsoft.MachineLearningServices/workspaces/reader'.
	Roles []*string `json:"roles,omitempty"`

	// REQUIRED; The ARM resource ID of source resource that trusted access is configured for.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// READ-ONLY; The current provisioning state of trusted access role binding.
	ProvisioningState *TrustedAccessRoleBindingProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// TrustedAccessRoleBindingsClientCreateOrUpdateOptions contains the optional parameters for the TrustedAccessRoleBindingsClient.CreateOrUpdate
// method.
type TrustedAccessRoleBindingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// TrustedAccessRoleBindingsClientDeleteOptions contains the optional parameters for the TrustedAccessRoleBindingsClient.Delete
// method.
type TrustedAccessRoleBindingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TrustedAccessRoleBindingsClientGetOptions contains the optional parameters for the TrustedAccessRoleBindingsClient.Get
// method.
type TrustedAccessRoleBindingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TrustedAccessRoleBindingsClientListOptions contains the optional parameters for the TrustedAccessRoleBindingsClient.List
// method.
type TrustedAccessRoleBindingsClientListOptions struct {
	// placeholder for future optional parameters
}

// TrustedAccessRoleListResult - List of trusted access roles
type TrustedAccessRoleListResult struct {
	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Role list
	Value []*TrustedAccessRole `json:"value,omitempty" azure:"ro"`
}

// TrustedAccessRoleRule - Rule for trusted access role
type TrustedAccessRoleRule struct {
	// READ-ONLY; List of allowed apiGroups
	APIGroups []*string `json:"apiGroups,omitempty" azure:"ro"`

	// READ-ONLY; List of allowed nonResourceURLs
	NonResourceURLs []*string `json:"nonResourceURLs,omitempty" azure:"ro"`

	// READ-ONLY; List of allowed names
	ResourceNames []*string `json:"resourceNames,omitempty" azure:"ro"`

	// READ-ONLY; List of allowed resources
	Resources []*string `json:"resources,omitempty" azure:"ro"`

	// READ-ONLY; List of allowed verbs
	Verbs []*string `json:"verbs,omitempty" azure:"ro"`
}

// TrustedAccessRolesClientListOptions contains the optional parameters for the TrustedAccessRolesClient.List method.
type TrustedAccessRolesClientListOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentity - Details about a user assigned identity.
type UserAssignedIdentity struct {
	// The client ID of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The object ID of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`

	// The resource ID of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

// WindowsGmsaProfile - Windows gMSA Profile in the managed cluster.
type WindowsGmsaProfile struct {
	// Specifies the DNS server for Windows gMSA.
	// Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
	DNSServer *string `json:"dnsServer,omitempty"`

	// Specifies whether to enable Windows gMSA in the managed cluster.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the root domain name for Windows gMSA.
	// Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
	RootDomainName *string `json:"rootDomainName,omitempty"`
}
