//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcompute

import "time"

// APIEntityReference - The API entity reference.
type APIEntityReference struct {
	// The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/…
	ID *string `json:"id,omitempty"`
}

// APIError - Api error.
type APIError struct {
	// The error code.
	Code *string `json:"code,omitempty"`

	// The Api error details
	Details []*APIErrorBase `json:"details,omitempty"`

	// The Api inner error
	Innererror *InnerError `json:"innererror,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`

	// The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// APIErrorBase - Api error base.
type APIErrorBase struct {
	// The error code.
	Code *string `json:"code,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`

	// The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// AccessURI - A disk access SAS uri.
type AccessURI struct {
	// READ-ONLY; A SAS uri for accessing a disk.
	AccessSAS *string `json:"accessSAS,omitempty" azure:"ro"`

	// READ-ONLY; A SAS uri for accessing a VM guest state.
	SecurityDataAccessSAS *string `json:"securityDataAccessSAS,omitempty" azure:"ro"`
}

// AdditionalCapabilities - Enables or disables a capability on the virtual machine or virtual machine scale set.
type AdditionalCapabilities struct {
	// The flag that enables or disables hibernation capability on the VM.
	HibernationEnabled *bool `json:"hibernationEnabled,omitempty"`

	// The flag that enables or disables a capability to have one or more managed data disks with UltraSSDLRS storage account
	// type on the VM or VMSS. Managed disks with storage account type UltraSSDLRS can
	// be added to a virtual machine or virtual machine scale set only if this property is enabled.
	UltraSSDEnabled *bool `json:"ultraSSDEnabled,omitempty"`
}

// AdditionalUnattendContent - Specifies additional XML formatted information that can be included in the Unattend.xml file,
// which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in
// which the content is applied.
type AdditionalUnattendContent struct {
	// The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
	ComponentName *string `json:"componentName,omitempty"`

	// Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML
	// must be less than 4KB and must include the root element for the setting or
	// feature that is being inserted.
	Content *string `json:"content,omitempty"`

	// The pass name. Currently, the only allowable value is OobeSystem.
	PassName *string `json:"passName,omitempty"`

	// Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
	SettingName *SettingNames `json:"settingName,omitempty"`
}

// ApplicationProfile - Contains the list of gallery applications that should be made available to the VM/VMSS
type ApplicationProfile struct {
	// Specifies the gallery applications that should be made available to the VM/VMSS
	GalleryApplications []*VMGalleryApplication `json:"galleryApplications,omitempty"`
}

// AutomaticOSUpgradePolicy - The configuration parameters used for performing automatic OS upgrade.
type AutomaticOSUpgradePolicy struct {
	// Whether OS image rollback feature should be disabled. Default value is false.
	DisableAutomaticRollback *bool `json:"disableAutomaticRollback,omitempty"`

	// Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer
	// version of the OS image becomes available. Default value is false.
	// If this is set to true for Windows based scale sets, enableAutomaticUpdates
	// [https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet]
	// is automatically set to false and cannot be set to true.
	EnableAutomaticOSUpgrade *bool `json:"enableAutomaticOSUpgrade,omitempty"`

	// Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Default value is false. Auto OS Upgrade
	// will fallback to the default policy if no policy is defined on the VMSS.
	UseRollingUpgradePolicy *bool `json:"useRollingUpgradePolicy,omitempty"`
}

// AutomaticOSUpgradeProperties - Describes automatic OS upgrade properties on the image.
type AutomaticOSUpgradeProperties struct {
	// REQUIRED; Specifies whether automatic OS upgrade is supported on the image.
	AutomaticOSUpgradeSupported *bool `json:"automaticOSUpgradeSupported,omitempty"`
}

// AutomaticRepairsPolicy - Specifies the configuration parameters for automatic repairs on the virtual machine scale set.
type AutomaticRepairsPolicy struct {
	// Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
	Enabled *bool `json:"enabled,omitempty"`

	// The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the
	// state change has completed. This helps avoid premature or accidental repairs.
	// The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes (PT10M), which
	// is also the default value. The maximum allowed grace period is 90 minutes
	// (PT90M).
	GracePeriod *string `json:"gracePeriod,omitempty"`

	// Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale
	// set. Default value is replace.
	RepairAction *RepairAction `json:"repairAction,omitempty"`
}

// AvailabilitySet - Specifies information about the availability set that the virtual machine should be assigned to. Virtual
// machines specified in the same availability set are allocated to different nodes to maximize
// availability. For more information about availability sets, see Availability sets overview [https://docs.microsoft.com/azure/virtual-machines/availability-set-overview].
// For more information on Azure planned maintenance, see Maintenance and updates for Virtual Machines in Azure [https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates]
// Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability
// set.
type AvailabilitySet struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The instance view of a resource.
	Properties *AvailabilitySetProperties `json:"properties,omitempty"`

	// Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of values. Use
	// 'Aligned' for virtual machines with managed disks and 'Classic' for virtual
	// machines with unmanaged disks. Default value is 'Classic'.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AvailabilitySetListResult - The List Availability Set operation response.
type AvailabilitySetListResult struct {
	// REQUIRED; The list of availability sets
	Value []*AvailabilitySet `json:"value,omitempty"`

	// The URI to fetch the next page of AvailabilitySets. Call ListNext() with this URI to fetch the next page of AvailabilitySets.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailabilitySetProperties - The instance view of a resource.
type AvailabilitySetProperties struct {
	// Fault Domain count.
	PlatformFaultDomainCount *int32 `json:"platformFaultDomainCount,omitempty"`

	// Update Domain count.
	PlatformUpdateDomainCount *int32 `json:"platformUpdateDomainCount,omitempty"`

	// Specifies information about the proximity placement group that the availability set should be assigned to.
	// Minimum api-version: 2018-04-01.
	ProximityPlacementGroup *SubResource `json:"proximityPlacementGroup,omitempty"`

	// A list of references to all virtual machines in the availability set.
	VirtualMachines []*SubResource `json:"virtualMachines,omitempty"`

	// READ-ONLY; The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty" azure:"ro"`
}

// AvailabilitySetUpdate - Specifies information about the availability set that the virtual machine should be assigned to.
// Only tags may be updated.
type AvailabilitySetUpdate struct {
	// The instance view of a resource.
	Properties *AvailabilitySetProperties `json:"properties,omitempty"`

	// Sku of the availability set
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// AvailabilitySetsClientCreateOrUpdateOptions contains the optional parameters for the AvailabilitySetsClient.CreateOrUpdate
// method.
type AvailabilitySetsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AvailabilitySetsClientDeleteOptions contains the optional parameters for the AvailabilitySetsClient.Delete method.
type AvailabilitySetsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AvailabilitySetsClientGetOptions contains the optional parameters for the AvailabilitySetsClient.Get method.
type AvailabilitySetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AvailabilitySetsClientListAvailableSizesOptions contains the optional parameters for the AvailabilitySetsClient.ListAvailableSizes
// method.
type AvailabilitySetsClientListAvailableSizesOptions struct {
	// placeholder for future optional parameters
}

// AvailabilitySetsClientListBySubscriptionOptions contains the optional parameters for the AvailabilitySetsClient.ListBySubscription
// method.
type AvailabilitySetsClientListBySubscriptionOptions struct {
	// The expand expression to apply to the operation. Allowed values are 'instanceView'.
	Expand *string
}

// AvailabilitySetsClientListOptions contains the optional parameters for the AvailabilitySetsClient.List method.
type AvailabilitySetsClientListOptions struct {
	// placeholder for future optional parameters
}

// AvailabilitySetsClientUpdateOptions contains the optional parameters for the AvailabilitySetsClient.Update method.
type AvailabilitySetsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// AvailablePatchSummary - Describes the properties of an virtual machine instance view for available patch summary.
type AvailablePatchSummary struct {
	// READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension
	// logs.
	AssessmentActivityID *string `json:"assessmentActivityId,omitempty" azure:"ro"`

	// READ-ONLY; The number of critical or security patches that have been detected as available and not yet installed.
	CriticalAndSecurityPatchCount *int32 `json:"criticalAndSecurityPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	Error *APIError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation began.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; The number of all available patches excluding critical and security.
	OtherPatchCount *int32 `json:"otherPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete
	// installation but the reboot has not yet occurred.
	RebootPending *bool `json:"rebootPending,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation began.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes.
	// At that point it will become "Unknown", "Failed", "Succeeded", or
	// "CompletedWithWarnings."
	Status *PatchOperationStatus `json:"status,omitempty" azure:"ro"`
}

// BillingProfile - Specifies the billing related details of a Azure Spot VM or VMSS.
// Minimum api-version: 2019-03-01.
type BillingProfile struct {
	// Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS. This price is in US Dollars.
	// This price will be compared with the current Azure Spot price for the VM size. Also, the prices are compared at the time
	// of create/update of Azure Spot VM/VMSS and the operation will only succeed if
	// the maxPrice is greater than the current Azure Spot price.
	// The maxPrice will also be used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice
	// after creation of VM/VMSS.
	// Possible values are:
	// - Any decimal value greater than zero. Example: 0.01538
	// -1 – indicates default price to be up-to on-demand.
	// You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS should not be evicted for price reasons. Also, the
	// default max price is -1 if it is not provided by you.
	// Minimum api-version: 2019-03-01.
	MaxPrice *float64 `json:"maxPrice,omitempty"`
}

// BootDiagnostics - Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose
// VM status.
// You can easily view the output of your console log.
// Azure also enables you to see a screenshot of the VM from the hypervisor.
type BootDiagnostics struct {
	// Whether boot diagnostics should be enabled on the Virtual Machine.
	Enabled *bool `json:"enabled,omitempty"`

	// Uri of the storage account to use for placing the console output and screenshot.
	// If storageUri is not specified while enabling boot diagnostics, managed storage will be used.
	StorageURI *string `json:"storageUri,omitempty"`
}

// BootDiagnosticsInstanceView - The instance view of a virtual machine boot diagnostics.
type BootDiagnosticsInstanceView struct {
	// READ-ONLY; The console screenshot blob URI.
	// NOTE: This will not be set if boot diagnostics is currently enabled with managed storage.
	ConsoleScreenshotBlobURI *string `json:"consoleScreenshotBlobUri,omitempty" azure:"ro"`

	// READ-ONLY; The serial console log blob Uri.
	// NOTE: This will not be set if boot diagnostics is currently enabled with managed storage.
	SerialConsoleLogBlobURI *string `json:"serialConsoleLogBlobUri,omitempty" azure:"ro"`

	// READ-ONLY; The boot diagnostics status information for the VM.
	// NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
	Status *InstanceViewStatus `json:"status,omitempty" azure:"ro"`
}

// CapacityReservation - Specifies information about the capacity reservation.
type CapacityReservation struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently
	// VM Skus with the capability called 'CapacityReservationSupported' set to true are
	// supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list)
	// for supported values.
	SKU *SKU `json:"sku,omitempty"`

	// Properties of the Capacity reservation.
	Properties *CapacityReservationProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the
	// list of zones specified during the capacity reservation group creation. The zone
	// can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided,
	// enforces VM/VMSS using this capacity reservation to be in same zone.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CapacityReservationGroup - Specifies information about the capacity reservation group that the capacity reservations should
// be assigned to.
// Currently, a capacity reservation can only be added to a capacity reservation group at creation time. An existing capacity
// reservation cannot be added or moved to another capacity reservation group.
type CapacityReservationGroup struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// capacity reservation group Properties.
	Properties *CapacityReservationGroupProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided,
	// the group supports only regional resources in the region. If provided,
	// enforces each capacity reservation in the group to be in one of the zones.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type CapacityReservationGroupInstanceView struct {
	// READ-ONLY; List of instance view of the capacity reservations under the capacity reservation group.
	CapacityReservations []*CapacityReservationInstanceViewWithName `json:"capacityReservations,omitempty" azure:"ro"`
}

// CapacityReservationGroupListResult - The List capacity reservation group with resource group response.
type CapacityReservationGroupListResult struct {
	// REQUIRED; The list of capacity reservation groups
	Value []*CapacityReservationGroup `json:"value,omitempty"`

	// The URI to fetch the next page of capacity reservation groups. Call ListNext() with this URI to fetch the next page of
	// capacity reservation groups.
	NextLink *string `json:"nextLink,omitempty"`
}

// CapacityReservationGroupProperties - capacity reservation group Properties.
type CapacityReservationGroupProperties struct {
	// READ-ONLY; A list of all capacity reservation resource ids that belong to capacity reservation group.
	CapacityReservations []*SubResourceReadOnly `json:"capacityReservations,omitempty" azure:"ro"`

	// READ-ONLY; The capacity reservation group instance view which has the list of instance views for all the capacity reservations
	// that belong to the capacity reservation group.
	InstanceView *CapacityReservationGroupInstanceView `json:"instanceView,omitempty" azure:"ro"`

	// READ-ONLY; A list of references to all virtual machines associated to the capacity reservation group.
	VirtualMachinesAssociated []*SubResourceReadOnly `json:"virtualMachinesAssociated,omitempty" azure:"ro"`
}

// CapacityReservationGroupUpdate - Specifies information about the capacity reservation group. Only tags can be updated.
type CapacityReservationGroupUpdate struct {
	// capacity reservation group Properties.
	Properties *CapacityReservationGroupProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// CapacityReservationGroupsClientCreateOrUpdateOptions contains the optional parameters for the CapacityReservationGroupsClient.CreateOrUpdate
// method.
type CapacityReservationGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// CapacityReservationGroupsClientDeleteOptions contains the optional parameters for the CapacityReservationGroupsClient.Delete
// method.
type CapacityReservationGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CapacityReservationGroupsClientGetOptions contains the optional parameters for the CapacityReservationGroupsClient.Get
// method.
type CapacityReservationGroupsClientGetOptions struct {
	// The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the capacity
	// reservations under the capacity reservation group which is a snapshot of the
	// runtime properties of a capacity reservation that is managed by the platform and can change outside of control plane operations.
	Expand *CapacityReservationGroupInstanceViewTypes
}

// CapacityReservationGroupsClientListByResourceGroupOptions contains the optional parameters for the CapacityReservationGroupsClient.ListByResourceGroup
// method.
type CapacityReservationGroupsClientListByResourceGroupOptions struct {
	// The expand expression to apply on the operation. Based on the expand param(s) specified we return Virtual Machine or ScaleSet
	// VM Instance or both resource Ids which are associated to capacity
	// reservation group in the response.
	Expand *ExpandTypesForGetCapacityReservationGroups
}

// CapacityReservationGroupsClientListBySubscriptionOptions contains the optional parameters for the CapacityReservationGroupsClient.ListBySubscription
// method.
type CapacityReservationGroupsClientListBySubscriptionOptions struct {
	// The expand expression to apply on the operation. Based on the expand param(s) specified we return Virtual Machine or ScaleSet
	// VM Instance or both resource Ids which are associated to capacity
	// reservation group in the response.
	Expand *ExpandTypesForGetCapacityReservationGroups
}

// CapacityReservationGroupsClientUpdateOptions contains the optional parameters for the CapacityReservationGroupsClient.Update
// method.
type CapacityReservationGroupsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CapacityReservationInstanceView - The instance view of a capacity reservation that provides as snapshot of the runtime
// properties of the capacity reservation that is managed by the platform and can change outside of control plane
// operations.
type CapacityReservationInstanceView struct {
	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// Unutilized capacity of the capacity reservation.
	UtilizationInfo *CapacityReservationUtilization `json:"utilizationInfo,omitempty"`
}

// CapacityReservationInstanceViewWithName - The instance view of a capacity reservation that includes the name of the capacity
// reservation. It is used for the response to the instance view of a capacity reservation group.
type CapacityReservationInstanceViewWithName struct {
	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// Unutilized capacity of the capacity reservation.
	UtilizationInfo *CapacityReservationUtilization `json:"utilizationInfo,omitempty"`

	// READ-ONLY; The name of the capacity reservation.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// CapacityReservationListResult - The list capacity reservation operation response.
type CapacityReservationListResult struct {
	// REQUIRED; The list of capacity reservations
	Value []*CapacityReservation `json:"value,omitempty"`

	// The URI to fetch the next page of capacity reservations. Call ListNext() with this URI to fetch the next page of capacity
	// reservations.
	NextLink *string `json:"nextLink,omitempty"`
}

// CapacityReservationProfile - The parameters of a capacity reservation Profile.
type CapacityReservationProfile struct {
	// Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or scaleset
	// vm instances provided enough capacity has been reserved. Please refer to
	// https://aka.ms/CapacityReservation for more details.
	CapacityReservationGroup *SubResource `json:"capacityReservationGroup,omitempty"`
}

// CapacityReservationProperties - Properties of the Capacity reservation.
type CapacityReservationProperties struct {
	// READ-ONLY; The Capacity reservation instance view.
	InstanceView *CapacityReservationInstanceView `json:"instanceView,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the value of fault domain count that Capacity Reservation supports for requested VM size.
	// NOTE: The fault domain count specified for a resource (like virtual machines scale set) must be less than or equal to this
	// value if it deploys using capacity reservation.
	// Minimum api-version: 2022-08-01.
	PlatformFaultDomainCount *int32 `json:"platformFaultDomainCount,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The date time when the capacity reservation was last updated.
	ProvisioningTime *time.Time `json:"provisioningTime,omitempty" azure:"ro"`

	// READ-ONLY; A unique id generated and assigned to the capacity reservation by the platform which does not change throughout
	// the lifetime of the resource.
	ReservationID *string `json:"reservationId,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the time at which the Capacity Reservation resource was created.
	// Minimum api-version: 2021-11-01.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; A list of all virtual machine resource ids that are associated with the capacity reservation.
	VirtualMachinesAssociated []*SubResourceReadOnly `json:"virtualMachinesAssociated,omitempty" azure:"ro"`
}

// CapacityReservationUpdate - Specifies information about the capacity reservation. Only tags and sku.capacity can be updated.
type CapacityReservationUpdate struct {
	// Properties of the Capacity reservation.
	Properties *CapacityReservationProperties `json:"properties,omitempty"`

	// SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM
	// Skus with the capability called 'CapacityReservationSupported' set to true are
	// supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list)
	// for supported values.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// CapacityReservationUtilization - Represents the capacity reservation utilization in terms of resources allocated.
type CapacityReservationUtilization struct {
	// READ-ONLY; The value provides the current capacity of the VM size which was reserved successfully and for which the customer
	// is getting billed.
	// Minimum api-version: 2022-08-01.
	CurrentCapacity *int32 `json:"currentCapacity,omitempty" azure:"ro"`

	// READ-ONLY; A list of all virtual machines resource ids allocated against the capacity reservation.
	VirtualMachinesAllocated []*SubResourceReadOnly `json:"virtualMachinesAllocated,omitempty" azure:"ro"`
}

// CapacityReservationsClientBeginCreateOrUpdateOptions contains the optional parameters for the CapacityReservationsClient.BeginCreateOrUpdate
// method.
type CapacityReservationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CapacityReservationsClientBeginDeleteOptions contains the optional parameters for the CapacityReservationsClient.BeginDelete
// method.
type CapacityReservationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CapacityReservationsClientBeginUpdateOptions contains the optional parameters for the CapacityReservationsClient.BeginUpdate
// method.
type CapacityReservationsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CapacityReservationsClientGetOptions contains the optional parameters for the CapacityReservationsClient.Get method.
type CapacityReservationsClientGetOptions struct {
	// The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime properties of the capacity
	// reservation that is managed by the platform and can change outside of
	// control plane operations.
	Expand *CapacityReservationInstanceViewTypes
}

// CapacityReservationsClientListByCapacityReservationGroupOptions contains the optional parameters for the CapacityReservationsClient.ListByCapacityReservationGroup
// method.
type CapacityReservationsClientListByCapacityReservationGroupOptions struct {
	// placeholder for future optional parameters
}

// CloudService - Describes the cloud service.
type CloudService struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Cloud service properties
	Properties *CloudServiceProperties `json:"properties,omitempty"`

	// The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CloudServiceExtensionProfile - Describes a cloud service extension profile.
type CloudServiceExtensionProfile struct {
	// List of extensions for the cloud service.
	Extensions []*Extension `json:"extensions,omitempty"`
}

// CloudServiceExtensionProperties - Extension Properties.
type CloudServiceExtensionProperties struct {
	// Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become
	// available.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Tag to force apply the provided public and protected settings. Changing the tag value allows for re-running the extension
	// without changing any of the public or protected settings. If forceUpdateTag is
	// not changed, updates to public or protected settings would still be applied by the handler. If neither forceUpdateTag nor
	// any of public or protected settings change, extension would flow to the role
	// instance with the same sequence-number, and it is up to handler implementation whether to re-run it or not
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// Protected settings for the extension which are encrypted before sent to the role instance.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
	ProtectedSettingsFromKeyVault *CloudServiceVaultAndSecretReference `json:"protectedSettingsFromKeyVault,omitempty"`

	// The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied
	// to all roles in the cloud service.
	RolesAppliedTo []*string `json:"rolesAppliedTo,omitempty"`

	// Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension
	// (like RDP), this is the XML setting for the extension.
	Settings interface{} `json:"settings,omitempty"`

	// Specifies the type of the extension.
	Type *string `json:"type,omitempty"`

	// Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an
	// asterisk (*) is used as the value, the latest version of the extension is used.
	// If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor
	// version of the specified major version is selected. If a major version number
	// and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified,
	// an auto-upgrade is performed on the role instance.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// CloudServiceInstanceView - InstanceView of CloudService as a whole
type CloudServiceInstanceView struct {
	// Instance view statuses.
	RoleInstance *InstanceViewStatusesSummary `json:"roleInstance,omitempty"`

	// READ-ONLY; Specifies a list of unique identifiers generated internally for the cloud service.
	// NOTE: If you are using Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details.
	PrivateIDs []*string `json:"privateIds,omitempty" azure:"ro"`

	// READ-ONLY; The version of the SDK that was used to generate the package for the cloud service.
	SdkVersion *string `json:"sdkVersion,omitempty" azure:"ro"`

	// READ-ONLY
	Statuses []*ResourceInstanceViewStatus `json:"statuses,omitempty" azure:"ro"`
}

// CloudServiceListResult - The list operation result.
type CloudServiceListResult struct {
	// REQUIRED; The list of resources.
	Value []*CloudService `json:"value,omitempty"`

	// The URI to fetch the next page of resources. Use this to get the next page of resources. Do this till nextLink is null
	// to fetch all the resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// CloudServiceNetworkProfile - Network Profile for the cloud service.
type CloudServiceNetworkProfile struct {
	// List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a
	// Public Load Balancer and an Internal Load Balancer.
	LoadBalancerConfigurations []*LoadBalancerConfiguration `json:"loadBalancerConfigurations,omitempty"`

	// Slot type for the cloud service. Possible values are
	// Production
	// Staging
	// If not specified, the default value is Production.
	SlotType *CloudServiceSlotType `json:"slotType,omitempty"`

	// The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap.
	// This property cannot be updated once it is set. The swappable cloud service
	// referred by this id must be present otherwise an error will be thrown.
	SwappableCloudService *SubResource `json:"swappableCloudService,omitempty"`
}

// CloudServiceOperatingSystemsClientGetOSFamilyOptions contains the optional parameters for the CloudServiceOperatingSystemsClient.GetOSFamily
// method.
type CloudServiceOperatingSystemsClientGetOSFamilyOptions struct {
	// placeholder for future optional parameters
}

// CloudServiceOperatingSystemsClientGetOSVersionOptions contains the optional parameters for the CloudServiceOperatingSystemsClient.GetOSVersion
// method.
type CloudServiceOperatingSystemsClientGetOSVersionOptions struct {
	// placeholder for future optional parameters
}

// CloudServiceOperatingSystemsClientListOSFamiliesOptions contains the optional parameters for the CloudServiceOperatingSystemsClient.ListOSFamilies
// method.
type CloudServiceOperatingSystemsClientListOSFamiliesOptions struct {
	// placeholder for future optional parameters
}

// CloudServiceOperatingSystemsClientListOSVersionsOptions contains the optional parameters for the CloudServiceOperatingSystemsClient.ListOSVersions
// method.
type CloudServiceOperatingSystemsClientListOSVersionsOptions struct {
	// placeholder for future optional parameters
}

// CloudServiceOsProfile - Describes the OS profile for the cloud service.
type CloudServiceOsProfile struct {
	// Specifies set of certificates that should be installed onto the role instances.
	Secrets []*CloudServiceVaultSecretGroup `json:"secrets,omitempty"`
}

// CloudServiceProperties - Cloud service properties
type CloudServiceProperties struct {
	// (Optional) Indicates whether the role sku properties (roleProfile.roles.sku) specified in the model/template should override
	// the role instance count and vm size specified in the .cscfg and .csdef
	// respectively. The default value is false.
	AllowModelOverride *bool `json:"allowModelOverride,omitempty"`

	// Specifies the XML service configuration (.cscfg) for the cloud service.
	Configuration *string `json:"configuration,omitempty"`

	// Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL can
	// be Shared Access Signature (SAS) URI from any storage account. This is a
	// write-only property and is not returned in GET calls.
	ConfigurationURL *string `json:"configurationUrl,omitempty"`

	// Describes a cloud service extension profile.
	ExtensionProfile *CloudServiceExtensionProfile `json:"extensionProfile,omitempty"`

	// Network Profile for the cloud service.
	NetworkProfile *CloudServiceNetworkProfile `json:"networkProfile,omitempty"`

	// Describes the OS profile for the cloud service.
	OSProfile *CloudServiceOsProfile `json:"osProfile,omitempty"`

	// Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be
	// Shared Access Signature (SAS) URI from any storage account. This is a write-only
	// property and is not returned in GET calls.
	PackageURL *string `json:"packageUrl,omitempty"`

	// Describes the role profile for the cloud service.
	RoleProfile *CloudServiceRoleProfile `json:"roleProfile,omitempty"`

	// (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is true. If
	// false, the service model is still deployed, but the code is not run immediately.
	// Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service
	// still incurs charges, even if it is poweredoff.
	StartCloudService *bool `json:"startCloudService,omitempty"`

	// Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates
	// can be initiated manually in each update domain or initiated automatically in
	// all update domains. Possible Values are
	// Auto
	// Manual
	// Simultaneous
	// If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If
	// set to Auto, the update is automatically applied to each update domain in
	// sequence.
	UpgradeMode *CloudServiceUpgradeMode `json:"upgradeMode,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique identifier for the cloud service.
	UniqueID *string `json:"uniqueId,omitempty" azure:"ro"`
}

// CloudServiceRole - Describes a role of the cloud service.
type CloudServiceRole struct {
	// The cloud service role properties.
	Properties *CloudServiceRoleProperties `json:"properties,omitempty"`

	// Describes the cloud service role sku.
	SKU *CloudServiceRoleSKU `json:"sku,omitempty"`

	// READ-ONLY; Resource id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CloudServiceRoleInstancesClientBeginDeleteOptions contains the optional parameters for the CloudServiceRoleInstancesClient.BeginDelete
// method.
type CloudServiceRoleInstancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServiceRoleInstancesClientBeginRebuildOptions contains the optional parameters for the CloudServiceRoleInstancesClient.BeginRebuild
// method.
type CloudServiceRoleInstancesClientBeginRebuildOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServiceRoleInstancesClientBeginReimageOptions contains the optional parameters for the CloudServiceRoleInstancesClient.BeginReimage
// method.
type CloudServiceRoleInstancesClientBeginReimageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServiceRoleInstancesClientBeginRestartOptions contains the optional parameters for the CloudServiceRoleInstancesClient.BeginRestart
// method.
type CloudServiceRoleInstancesClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServiceRoleInstancesClientGetInstanceViewOptions contains the optional parameters for the CloudServiceRoleInstancesClient.GetInstanceView
// method.
type CloudServiceRoleInstancesClientGetInstanceViewOptions struct {
	// placeholder for future optional parameters
}

// CloudServiceRoleInstancesClientGetOptions contains the optional parameters for the CloudServiceRoleInstancesClient.Get
// method.
type CloudServiceRoleInstancesClientGetOptions struct {
	// The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
	Expand *InstanceViewTypes
}

// CloudServiceRoleInstancesClientGetRemoteDesktopFileOptions contains the optional parameters for the CloudServiceRoleInstancesClient.GetRemoteDesktopFile
// method.
type CloudServiceRoleInstancesClientGetRemoteDesktopFileOptions struct {
	// placeholder for future optional parameters
}

// CloudServiceRoleInstancesClientListOptions contains the optional parameters for the CloudServiceRoleInstancesClient.List
// method.
type CloudServiceRoleInstancesClientListOptions struct {
	// The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
	Expand *InstanceViewTypes
}

// CloudServiceRoleListResult - The list operation result.
type CloudServiceRoleListResult struct {
	// REQUIRED; The list of resources.
	Value []*CloudServiceRole `json:"value,omitempty"`

	// The URI to fetch the next page of resources. Use this to get the next page of resources. Do this till nextLink is null
	// to fetch all the resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// CloudServiceRoleProfile - Describes the role profile for the cloud service.
type CloudServiceRoleProfile struct {
	// List of roles for the cloud service.
	Roles []*CloudServiceRoleProfileProperties `json:"roles,omitempty"`
}

// CloudServiceRoleProfileProperties - Describes the role properties.
type CloudServiceRoleProfileProperties struct {
	// Resource name.
	Name *string `json:"name,omitempty"`

	// Describes the cloud service role sku.
	SKU *CloudServiceRoleSKU `json:"sku,omitempty"`
}

// CloudServiceRoleProperties - The cloud service role properties.
type CloudServiceRoleProperties struct {
	// READ-ONLY; Specifies the ID which uniquely identifies a cloud service role.
	UniqueID *string `json:"uniqueId,omitempty" azure:"ro"`
}

// CloudServiceRoleSKU - Describes the cloud service role sku.
type CloudServiceRoleSKU struct {
	// Specifies the number of role instances in the cloud service.
	Capacity *int64 `json:"capacity,omitempty"`

	// The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete
	// and recreate the cloud service or move back to the old sku.
	Name *string `json:"name,omitempty"`

	// Specifies the tier of the cloud service. Possible Values are
	// Standard
	// Basic
	Tier *string `json:"tier,omitempty"`
}

// CloudServiceRolesClientGetOptions contains the optional parameters for the CloudServiceRolesClient.Get method.
type CloudServiceRolesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CloudServiceRolesClientListOptions contains the optional parameters for the CloudServiceRolesClient.List method.
type CloudServiceRolesClientListOptions struct {
	// placeholder for future optional parameters
}

type CloudServiceUpdate struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// CloudServiceVaultAndSecretReference - Protected settings for the extension, referenced using KeyVault which are encrypted
// before sent to the role instance.
type CloudServiceVaultAndSecretReference struct {
	// Secret URL which contains the protected settings of the extension
	SecretURL *string `json:"secretUrl,omitempty"`

	// The ARM Resource ID of the Key Vault
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// CloudServiceVaultCertificate - Describes a single certificate reference in a Key Vault, and where the certificate should
// reside on the role instance.
type CloudServiceVaultCertificate struct {
	// This is the URL of a certificate that has been uploaded to Key Vault as a secret.
	CertificateURL *string `json:"certificateUrl,omitempty"`
}

// CloudServiceVaultSecretGroup - Describes a set of certificates which are all in the same Key Vault.
type CloudServiceVaultSecretGroup struct {
	// The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
	SourceVault *SubResource `json:"sourceVault,omitempty"`

	// The list of key vault references in SourceVault which contain certificates.
	VaultCertificates []*CloudServiceVaultCertificate `json:"vaultCertificates,omitempty"`
}

// CloudServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the CloudServicesClient.BeginCreateOrUpdate
// method.
type CloudServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientBeginDeleteInstancesOptions contains the optional parameters for the CloudServicesClient.BeginDeleteInstances
// method.
type CloudServicesClientBeginDeleteInstancesOptions struct {
	// List of cloud service role instance names.
	Parameters *RoleInstances
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientBeginDeleteOptions contains the optional parameters for the CloudServicesClient.BeginDelete method.
type CloudServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientBeginPowerOffOptions contains the optional parameters for the CloudServicesClient.BeginPowerOff method.
type CloudServicesClientBeginPowerOffOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientBeginRebuildOptions contains the optional parameters for the CloudServicesClient.BeginRebuild method.
type CloudServicesClientBeginRebuildOptions struct {
	// List of cloud service role instance names.
	Parameters *RoleInstances
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientBeginReimageOptions contains the optional parameters for the CloudServicesClient.BeginReimage method.
type CloudServicesClientBeginReimageOptions struct {
	// List of cloud service role instance names.
	Parameters *RoleInstances
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientBeginRestartOptions contains the optional parameters for the CloudServicesClient.BeginRestart method.
type CloudServicesClientBeginRestartOptions struct {
	// List of cloud service role instance names.
	Parameters *RoleInstances
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientBeginStartOptions contains the optional parameters for the CloudServicesClient.BeginStart method.
type CloudServicesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientBeginUpdateOptions contains the optional parameters for the CloudServicesClient.BeginUpdate method.
type CloudServicesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesClientGetInstanceViewOptions contains the optional parameters for the CloudServicesClient.GetInstanceView
// method.
type CloudServicesClientGetInstanceViewOptions struct {
	// placeholder for future optional parameters
}

// CloudServicesClientGetOptions contains the optional parameters for the CloudServicesClient.Get method.
type CloudServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CloudServicesClientListAllOptions contains the optional parameters for the CloudServicesClient.ListAll method.
type CloudServicesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// CloudServicesClientListOptions contains the optional parameters for the CloudServicesClient.List method.
type CloudServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// CloudServicesUpdateDomainClientBeginWalkUpdateDomainOptions contains the optional parameters for the CloudServicesUpdateDomainClient.BeginWalkUpdateDomain
// method.
type CloudServicesUpdateDomainClientBeginWalkUpdateDomainOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudServicesUpdateDomainClientGetUpdateDomainOptions contains the optional parameters for the CloudServicesUpdateDomainClient.GetUpdateDomain
// method.
type CloudServicesUpdateDomainClientGetUpdateDomainOptions struct {
	// placeholder for future optional parameters
}

// CloudServicesUpdateDomainClientListUpdateDomainsOptions contains the optional parameters for the CloudServicesUpdateDomainClient.ListUpdateDomains
// method.
type CloudServicesUpdateDomainClientListUpdateDomainsOptions struct {
	// placeholder for future optional parameters
}

// CommunityGalleriesClientGetOptions contains the optional parameters for the CommunityGalleriesClient.Get method.
type CommunityGalleriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CommunityGallery - Specifies information about the Community Gallery that you want to create or update.
type CommunityGallery struct {
	// The identifier information of community gallery.
	Identifier *CommunityGalleryIdentifier `json:"identifier,omitempty"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CommunityGalleryIdentifier - The identifier information of community gallery.
type CommunityGalleryIdentifier struct {
	// The unique id of this community gallery.
	UniqueID *string `json:"uniqueId,omitempty"`
}

// CommunityGalleryImage - Specifies information about the gallery image definition that you want to create or update.
type CommunityGalleryImage struct {
	// The identifier information of community gallery.
	Identifier *CommunityGalleryIdentifier `json:"identifier,omitempty"`

	// Describes the properties of a gallery image definition.
	Properties *CommunityGalleryImageProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CommunityGalleryImageList - The List Community Gallery Images operation response.
type CommunityGalleryImageList struct {
	// REQUIRED; A list of community gallery images.
	Value []*CommunityGalleryImage `json:"value,omitempty"`

	// The uri to fetch the next page of community gallery images. Call ListNext() with this to fetch the next page of community
	// gallery images.
	NextLink *string `json:"nextLink,omitempty"`
}

// CommunityGalleryImageProperties - Describes the properties of a gallery image definition.
type CommunityGalleryImageProperties struct {
	// REQUIRED; This is the gallery image definition identifier.
	Identifier *GalleryImageIdentifier `json:"identifier,omitempty"`

	// REQUIRED; This property allows the user to specify whether the virtual machines created under this image are 'Generalized'
	// or 'Specialized'.
	OSState *OperatingSystemStateTypes `json:"osState,omitempty"`

	// REQUIRED; This property allows you to specify the type of the OS that is included in the disk when creating a VM from a
	// managed image.
	// Possible values are:
	// Windows
	// Linux
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// The architecture of the image. Applicable to OS disks only.
	Architecture *Architecture `json:"architecture,omitempty"`

	// Describes the disallowed disk types.
	Disallowed *Disallowed `json:"disallowed,omitempty"`

	// The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property
	// is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// End-user license agreement for the current community gallery image.
	Eula *string `json:"eula,omitempty"`

	// A list of gallery image features.
	Features []*GalleryImageFeature `json:"features,omitempty"`

	// The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
	HyperVGeneration *HyperVGeneration `json:"hyperVGeneration,omitempty"`

	// Privacy statement uri for the current community gallery image.
	PrivacyStatementURI *string `json:"privacyStatementUri,omitempty"`

	// Describes the gallery image definition purchase plan. This is used by marketplace images.
	PurchasePlan *ImagePurchasePlan `json:"purchasePlan,omitempty"`

	// The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
	Recommended *RecommendedMachineConfiguration `json:"recommended,omitempty"`
}

// CommunityGalleryImageVersion - Specifies information about the gallery image version that you want to create or update.
type CommunityGalleryImageVersion struct {
	// The identifier information of community gallery.
	Identifier *CommunityGalleryIdentifier `json:"identifier,omitempty"`

	// Describes the properties of a gallery image version.
	Properties *CommunityGalleryImageVersionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CommunityGalleryImageVersionList - The List Community Gallery Image versions operation response.
type CommunityGalleryImageVersionList struct {
	// REQUIRED; A list of community gallery image versions.
	Value []*CommunityGalleryImageVersion `json:"value,omitempty"`

	// The uri to fetch the next page of community gallery image versions. Call ListNext() with this to fetch the next page of
	// community gallery image versions.
	NextLink *string `json:"nextLink,omitempty"`
}

// CommunityGalleryImageVersionProperties - Describes the properties of a gallery image version.
type CommunityGalleryImageVersionProperties struct {
	// The end of life date of the gallery image version Definition. This property can be used for decommissioning purposes. This
	// property is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`

	// The published date of the gallery image version Definition. This property can be used for decommissioning purposes. This
	// property is updatable.
	PublishedDate *time.Time `json:"publishedDate,omitempty"`

	// Describes the storage profile of the image version.
	StorageProfile *SharedGalleryImageVersionStorageProfile `json:"storageProfile,omitempty"`
}

// CommunityGalleryImageVersionsClientGetOptions contains the optional parameters for the CommunityGalleryImageVersionsClient.Get
// method.
type CommunityGalleryImageVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CommunityGalleryImageVersionsClientListOptions contains the optional parameters for the CommunityGalleryImageVersionsClient.List
// method.
type CommunityGalleryImageVersionsClientListOptions struct {
	// placeholder for future optional parameters
}

// CommunityGalleryImagesClientGetOptions contains the optional parameters for the CommunityGalleryImagesClient.Get method.
type CommunityGalleryImagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CommunityGalleryImagesClientListOptions contains the optional parameters for the CommunityGalleryImagesClient.List method.
type CommunityGalleryImagesClientListOptions struct {
	// placeholder for future optional parameters
}

// CommunityGalleryInfo - Information of community gallery if current gallery is shared to community
type CommunityGalleryInfo struct {
	// End-user license agreement for community gallery image.
	Eula *string `json:"eula,omitempty"`

	// The prefix of the gallery name that will be displayed publicly. Visible to all users.
	PublicNamePrefix *string `json:"publicNamePrefix,omitempty"`

	// Community gallery publisher support email. The email address of the publisher. Visible to all users.
	PublisherContact *string `json:"publisherContact,omitempty"`

	// The link to the publisher website. Visible to all users.
	PublisherURI *string `json:"publisherUri,omitempty"`

	// READ-ONLY; Contains info about whether community gallery sharing is enabled.
	CommunityGalleryEnabled *bool `json:"communityGalleryEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Community gallery public name list.
	PublicNames []*string `json:"publicNames,omitempty" azure:"ro"`
}

// CopyCompletionError - Indicates the error details if the background copy of a resource created via the CopyStart operation
// fails.
type CopyCompletionError struct {
	// REQUIRED; Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
	ErrorCode *CopyCompletionErrorReason `json:"errorCode,omitempty"`

	// REQUIRED; Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// CreationData - Data used when creating a disk.
type CreationData struct {
	// REQUIRED; This enumerates the possible sources of a disk's creation.
	CreateOption *DiskCreateOption `json:"createOption,omitempty"`

	// Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference
	// will be the ARM id of the shared galley image version from which to create a
	// disk.
	GalleryImageReference *ImageDiskReference `json:"galleryImageReference,omitempty"`

	// Disk source information for PIR or user images.
	ImageReference *ImageDiskReference `json:"imageReference,omitempty"`

	// Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
	LogicalSectorSize *int32 `json:"logicalSectorSize,omitempty"`

	// Set this flag to true to get a boost on the performance target of the disk deployed, see here on the respective performance
	// target. This flag can only be set on disk creation time and cannot be
	// disabled after enabled.
	PerformancePlus *bool `json:"performancePlus,omitempty"`

	// If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
	SecurityDataURI *string `json:"securityDataUri,omitempty"`

	// If createOption is Copy, this is the ARM id of the source snapshot or disk.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// If createOption is Import, this is the URI of a blob to be imported into a managed disk.
	SourceURI *string `json:"sourceUri,omitempty"`

	// Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to
	// import as a disk.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be
	// between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520
	// bytes (32 TiB + 512 bytes for the VHD footer).
	UploadSizeBytes *int64 `json:"uploadSizeBytes,omitempty"`

	// READ-ONLY; If this field is set, this is the unique id identifying the source of this resource.
	SourceUniqueID *string `json:"sourceUniqueId,omitempty" azure:"ro"`
}

// DataDisk - Describes a data disk.
type DataDisk struct {
	// REQUIRED; Specifies how the virtual machine should be created.
	// Possible values are:
	// Attach \u2013 This value is used when you are using a specialized disk to create the virtual machine.
	// FromImage \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform
	// image, you also use the imageReference element described above. If you are
	// using a marketplace image, you also use the plan element previously described.
	CreateOption *DiskCreateOptionTypes `json:"createOption,omitempty"`

	// REQUIRED; Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and
	// therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty"`

	// Specifies the caching requirements.
	// Possible values are:
	// None
	// ReadOnly
	// ReadWrite
	// Default: None for Standard storage. ReadOnly for Premium storage
	Caching *CachingTypes `json:"caching,omitempty"`

	// Specifies whether data disk should be deleted or detached upon VM deletion.
	// Possible values:
	// Delete If this value is used, the data disk is deleted when VM is deleted.
	// Detach If this value is used, the data disk is retained after VM is deleted.
	// The default value is set to detach
	DeleteOption *DiskDeleteOptionTypes `json:"deleteOption,omitempty"`

	// Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the
	// virtual machine. Supported values: ForceDetach.
	// detachOption: ForceDetach is applicable only for managed data disks. If a previous detachment attempt of the data disk
	// did not complete due to an unexpected failure from the virtual machine and the
	// disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes
	// might not have been flushed when using this detach behavior.
	// This feature is still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update
	// toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
	DetachOption *DiskDetachOptionTypes `json:"detachOption,omitempty"`

	// Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a
	// virtual machine image.
	// diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine.
	// If SourceImage is provided, the destination virtual hard drive must not
	// exist.
	Image *VirtualHardDisk `json:"image,omitempty"`

	// The managed disk parameters.
	ManagedDisk *ManagedDiskParameters `json:"managedDisk,omitempty"`

	// The disk name.
	Name *string `json:"name,omitempty"`

	// Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset
	ToBeDetached *bool `json:"toBeDetached,omitempty"`

	// The virtual hard disk.
	Vhd *VirtualHardDisk `json:"vhd,omitempty"`

	// Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`

	// READ-ONLY; Specifies the Read-Write IOPS for the managed disk when StorageAccountType is UltraSSD_LRS. Returned only for
	// VirtualMachine ScaleSet VM disks. Can be updated only via updates to the VirtualMachine
	// Scale Set.
	DiskIOPSReadWrite *int64 `json:"diskIOPSReadWrite,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the bandwidth in MB per second for the managed disk when StorageAccountType is UltraSSD_LRS. Returned
	// only for VirtualMachine ScaleSet VM disks. Can be updated only via updates to the
	// VirtualMachine Scale Set.
	DiskMBpsReadWrite *int64 `json:"diskMBpsReadWrite,omitempty" azure:"ro"`
}

// DataDiskImage - Contains the data disk images information.
type DataDiskImage struct {
	// READ-ONLY; Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM
	// and therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty" azure:"ro"`
}

// DataDiskImageEncryption - Contains encryption settings for a data disk image.
type DataDiskImageEncryption struct {
	// REQUIRED; This property specifies the logical unit number of the data disk. This value is used to identify data disks within
	// the Virtual Machine and therefore must be unique for each data disk attached to the
	// Virtual Machine.
	Lun *int32 `json:"lun,omitempty"`

	// A relative URI containing the resource ID of the disk encryption set.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// DedicatedHost - Specifies information about the Dedicated host.
type DedicatedHost struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List Microsoft.Compute
	// SKUs for a list of possible values.
	SKU *SKU `json:"sku,omitempty"`

	// Properties of the dedicated host.
	Properties *DedicatedHostProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DedicatedHostAllocatableVM - Represents the dedicated host unutilized capacity in terms of a specific VM size.
type DedicatedHostAllocatableVM struct {
	// Maximum number of VMs of size vmSize that can fit in the dedicated host's remaining capacity.
	Count *float64 `json:"count,omitempty"`

	// VM size in terms of which the unutilized capacity is represented.
	VMSize *string `json:"vmSize,omitempty"`
}

// DedicatedHostAvailableCapacity - Dedicated host unutilized capacity.
type DedicatedHostAvailableCapacity struct {
	// The unutilized capacity of the dedicated host represented in terms of each VM size that is allowed to be deployed to the
	// dedicated host.
	AllocatableVMs []*DedicatedHostAllocatableVM `json:"allocatableVMs,omitempty"`
}

// DedicatedHostGroup - Specifies information about the dedicated host group that the dedicated hosts should be assigned to.
// Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot
// be added to another dedicated host group.
type DedicatedHostGroup struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Dedicated Host Group Properties.
	Properties *DedicatedHostGroupProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation.
	// If not provided, the group supports all zones in the region. If provided,
	// enforces each host in the group to be in the same zone.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type DedicatedHostGroupInstanceView struct {
	// List of instance view of the dedicated hosts under the dedicated host group.
	Hosts []*DedicatedHostInstanceViewWithName `json:"hosts,omitempty"`
}

// DedicatedHostGroupListResult - The List Dedicated Host Group with resource group response.
type DedicatedHostGroupListResult struct {
	// REQUIRED; The list of dedicated host groups
	Value []*DedicatedHostGroup `json:"value,omitempty"`

	// The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with this URI to fetch the next page of Dedicated
	// Host Groups.
	NextLink *string `json:"nextLink,omitempty"`
}

// DedicatedHostGroupProperties - Dedicated Host Group Properties.
type DedicatedHostGroupProperties struct {
	// REQUIRED; Number of fault domains that the host group can span.
	PlatformFaultDomainCount *int32 `json:"platformFaultDomainCount,omitempty"`

	// Enables or disables a capability on the dedicated host group.
	// Minimum api-version: 2022-03-01.
	AdditionalCapabilities *DedicatedHostGroupPropertiesAdditionalCapabilities `json:"additionalCapabilities,omitempty"`

	// Specifies whether virtual machines or virtual machine scale sets can be placed automatically on the dedicated host group.
	// Automatic placement means resources are allocated on dedicated hosts, that are
	// chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when not provided.
	// Minimum api-version: 2020-06-01.
	SupportAutomaticPlacement *bool `json:"supportAutomaticPlacement,omitempty"`

	// READ-ONLY; A list of references to all dedicated hosts in the dedicated host group.
	Hosts []*SubResourceReadOnly `json:"hosts,omitempty" azure:"ro"`

	// READ-ONLY; The dedicated host group instance view, which has the list of instance view of the dedicated hosts under the
	// dedicated host group.
	InstanceView *DedicatedHostGroupInstanceView `json:"instanceView,omitempty" azure:"ro"`
}

// DedicatedHostGroupPropertiesAdditionalCapabilities - Enables or disables a capability on the dedicated host group.
// Minimum api-version: 2022-03-01.
type DedicatedHostGroupPropertiesAdditionalCapabilities struct {
	// The flag that enables or disables a capability to have UltraSSD Enabled Virtual Machines on Dedicated Hosts of the Dedicated
	// Host Group. For the Virtual Machines to be UltraSSD Enabled,
	// UltraSSDEnabled flag for the resource needs to be set true as well. The value is defaulted to 'false' when not provided.
	// Please refer to
	// https://docs.microsoft.com/en-us/azure/virtual-machines/disks-enable-ultra-ssd for more details on Ultra SSD feature.
	// NOTE: The ultraSSDEnabled setting can only be enabled for Host Groups that are created as zonal.
	// Minimum api-version: 2022-03-01.
	UltraSSDEnabled *bool `json:"ultraSSDEnabled,omitempty"`
}

// DedicatedHostGroupUpdate - Specifies information about the dedicated host group that the dedicated host should be assigned
// to. Only tags may be updated.
type DedicatedHostGroupUpdate struct {
	// Dedicated Host Group Properties.
	Properties *DedicatedHostGroupProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation.
	// If not provided, the group supports all zones in the region. If provided,
	// enforces each host in the group to be in the same zone.
	Zones []*string `json:"zones,omitempty"`
}

// DedicatedHostGroupsClientCreateOrUpdateOptions contains the optional parameters for the DedicatedHostGroupsClient.CreateOrUpdate
// method.
type DedicatedHostGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DedicatedHostGroupsClientDeleteOptions contains the optional parameters for the DedicatedHostGroupsClient.Delete method.
type DedicatedHostGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DedicatedHostGroupsClientGetOptions contains the optional parameters for the DedicatedHostGroupsClient.Get method.
type DedicatedHostGroupsClientGetOptions struct {
	// The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated
	// hosts under the dedicated host group. 'UserData' is not supported for
	// dedicated host group.
	Expand *InstanceViewTypes
}

// DedicatedHostGroupsClientListByResourceGroupOptions contains the optional parameters for the DedicatedHostGroupsClient.ListByResourceGroup
// method.
type DedicatedHostGroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DedicatedHostGroupsClientListBySubscriptionOptions contains the optional parameters for the DedicatedHostGroupsClient.ListBySubscription
// method.
type DedicatedHostGroupsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DedicatedHostGroupsClientUpdateOptions contains the optional parameters for the DedicatedHostGroupsClient.Update method.
type DedicatedHostGroupsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DedicatedHostInstanceView - The instance view of a dedicated host.
type DedicatedHostInstanceView struct {
	// Unutilized capacity of the dedicated host.
	AvailableCapacity *DedicatedHostAvailableCapacity `json:"availableCapacity,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// READ-ONLY; Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
	AssetID *string `json:"assetId,omitempty" azure:"ro"`
}

// DedicatedHostInstanceViewWithName - The instance view of a dedicated host that includes the name of the dedicated host.
// It is used for the response to the instance view of a dedicated host group.
type DedicatedHostInstanceViewWithName struct {
	// Unutilized capacity of the dedicated host.
	AvailableCapacity *DedicatedHostAvailableCapacity `json:"availableCapacity,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// READ-ONLY; Specifies the unique id of the dedicated physical machine on which the dedicated host resides.
	AssetID *string `json:"assetId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the dedicated host.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// DedicatedHostListResult - The list dedicated host operation response.
type DedicatedHostListResult struct {
	// REQUIRED; The list of dedicated hosts
	Value []*DedicatedHost `json:"value,omitempty"`

	// The URI to fetch the next page of dedicated hosts. Call ListNext() with this URI to fetch the next page of dedicated hosts.
	NextLink *string `json:"nextLink,omitempty"`
}

// DedicatedHostProperties - Properties of the dedicated host.
type DedicatedHostProperties struct {
	// Specifies whether the dedicated host should be replaced automatically in case of a failure. The value is defaulted to 'true'
	// when not provided.
	AutoReplaceOnFailure *bool `json:"autoReplaceOnFailure,omitempty"`

	// Specifies the software license type that will be applied to the VMs deployed on the dedicated host.
	// Possible values are:
	// None
	// WindowsServerHybrid
	// WindowsServerPerpetual
	// Default: None
	LicenseType *DedicatedHostLicenseTypes `json:"licenseType,omitempty"`

	// Fault domain of the dedicated host within a dedicated host group.
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`

	// READ-ONLY; A unique id generated and assigned to the dedicated host by the platform.
	// Does not change throughout the lifetime of the host.
	HostID *string `json:"hostId,omitempty" azure:"ro"`

	// READ-ONLY; The dedicated host instance view.
	InstanceView *DedicatedHostInstanceView `json:"instanceView,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The date when the host was first provisioned.
	ProvisioningTime *time.Time `json:"provisioningTime,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the time at which the Dedicated Host resource was created.
	// Minimum api-version: 2021-11-01.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; A list of references to all virtual machines in the Dedicated Host.
	VirtualMachines []*SubResourceReadOnly `json:"virtualMachines,omitempty" azure:"ro"`
}

// DedicatedHostUpdate - Specifies information about the dedicated host. Only tags, autoReplaceOnFailure and licenseType may
// be updated.
type DedicatedHostUpdate struct {
	// Properties of the dedicated host.
	Properties *DedicatedHostProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// DedicatedHostsClientBeginCreateOrUpdateOptions contains the optional parameters for the DedicatedHostsClient.BeginCreateOrUpdate
// method.
type DedicatedHostsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DedicatedHostsClientBeginDeleteOptions contains the optional parameters for the DedicatedHostsClient.BeginDelete method.
type DedicatedHostsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DedicatedHostsClientBeginRestartOptions contains the optional parameters for the DedicatedHostsClient.BeginRestart method.
type DedicatedHostsClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DedicatedHostsClientBeginUpdateOptions contains the optional parameters for the DedicatedHostsClient.BeginUpdate method.
type DedicatedHostsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DedicatedHostsClientGetOptions contains the optional parameters for the DedicatedHostsClient.Get method.
type DedicatedHostsClientGetOptions struct {
	// The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated
	// host. 'UserData' is not supported for dedicated host.
	Expand *InstanceViewTypes
}

// DedicatedHostsClientListByHostGroupOptions contains the optional parameters for the DedicatedHostsClient.ListByHostGroup
// method.
type DedicatedHostsClientListByHostGroupOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsProfile - Specifies the boot diagnostic settings state.
// Minimum api-version: 2015-06-15.
type DiagnosticsProfile struct {
	// Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status.
	// NOTE: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the
	// VM.
	// You can easily view the output of your console log.
	// Azure also enables you to see a screenshot of the VM from the hypervisor.
	BootDiagnostics *BootDiagnostics `json:"bootDiagnostics,omitempty"`
}

// DiffDiskSettings - Describes the parameters of ephemeral disk settings that can be specified for operating system disk.
// NOTE: The ephemeral disk settings can only be specified for managed disk.
type DiffDiskSettings struct {
	// Specifies the ephemeral disk settings for operating system disk.
	Option *DiffDiskOptions `json:"option,omitempty"`

	// Specifies the ephemeral disk placement for operating system disk.
	// Possible values are:
	// CacheDisk
	// ResourceDisk
	// Default: CacheDisk if one is configured for the VM size otherwise ResourceDisk is used.
	// Refer to VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux
	// VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check
	// which VM sizes exposes a cache disk.
	Placement *DiffDiskPlacement `json:"placement,omitempty"`
}

// Disallowed - Describes the disallowed disk types.
type Disallowed struct {
	// A list of disk types.
	DiskTypes []*string `json:"diskTypes,omitempty"`
}

// DisallowedConfiguration - Specifies the disallowed configuration for a virtual machine image.
type DisallowedConfiguration struct {
	// VM disk types which are disallowed.
	VMDiskType *VMDiskTypes `json:"vmDiskType,omitempty"`
}

// Disk resource.
type Disk struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The extended location where the disk will be created. Extended location cannot be changed.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Disk resource properties.
	Properties *DiskProperties `json:"properties,omitempty"`

	// The disks sku name. Can be StandardLRS, PremiumLRS, StandardSSDLRS, UltraSSDLRS, PremiumZRS, StandardSSDZRS, or PremiumV2_LRS.
	SKU *DiskSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// The Logical zone list for Disk.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; A relative URI containing the ID of the VM that has the disk attached.
	ManagedBy *string `json:"managedBy,omitempty" azure:"ro"`

	// READ-ONLY; List of relative URIs containing the IDs of the VMs that have the disk attached. maxShares should be set to
	// a value greater than one for disks to allow attaching them to multiple VMs.
	ManagedByExtended []*string `json:"managedByExtended,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiskAccess - disk access resource.
type DiskAccess struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The extended location where the disk access will be created. Extended location cannot be changed.
	ExtendedLocation *ExtendedLocation     `json:"extendedLocation,omitempty"`
	Properties       *DiskAccessProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiskAccessList - The List disk access operation response.
type DiskAccessList struct {
	// REQUIRED; A list of disk access resources.
	Value []*DiskAccess `json:"value,omitempty"`

	// The uri to fetch the next page of disk access resources. Call ListNext() with this to fetch the next page of disk access
	// resources.
	NextLink *string `json:"nextLink,omitempty"`
}

type DiskAccessProperties struct {
	// READ-ONLY; A readonly collection of private endpoint connections created on the disk. Currently only one endpoint connection
	// is supported.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The disk access resource provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The time when the disk access was created.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`
}

// DiskAccessUpdate - Used for updating a disk access resource.
type DiskAccessUpdate struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// DiskAccessesClientBeginCreateOrUpdateOptions contains the optional parameters for the DiskAccessesClient.BeginCreateOrUpdate
// method.
type DiskAccessesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskAccessesClientBeginDeleteAPrivateEndpointConnectionOptions contains the optional parameters for the DiskAccessesClient.BeginDeleteAPrivateEndpointConnection
// method.
type DiskAccessesClientBeginDeleteAPrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskAccessesClientBeginDeleteOptions contains the optional parameters for the DiskAccessesClient.BeginDelete method.
type DiskAccessesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskAccessesClientBeginUpdateAPrivateEndpointConnectionOptions contains the optional parameters for the DiskAccessesClient.BeginUpdateAPrivateEndpointConnection
// method.
type DiskAccessesClientBeginUpdateAPrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskAccessesClientBeginUpdateOptions contains the optional parameters for the DiskAccessesClient.BeginUpdate method.
type DiskAccessesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskAccessesClientGetAPrivateEndpointConnectionOptions contains the optional parameters for the DiskAccessesClient.GetAPrivateEndpointConnection
// method.
type DiskAccessesClientGetAPrivateEndpointConnectionOptions struct {
	// placeholder for future optional parameters
}

// DiskAccessesClientGetOptions contains the optional parameters for the DiskAccessesClient.Get method.
type DiskAccessesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiskAccessesClientGetPrivateLinkResourcesOptions contains the optional parameters for the DiskAccessesClient.GetPrivateLinkResources
// method.
type DiskAccessesClientGetPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// DiskAccessesClientListByResourceGroupOptions contains the optional parameters for the DiskAccessesClient.ListByResourceGroup
// method.
type DiskAccessesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DiskAccessesClientListOptions contains the optional parameters for the DiskAccessesClient.List method.
type DiskAccessesClientListOptions struct {
	// placeholder for future optional parameters
}

// DiskAccessesClientListPrivateEndpointConnectionsOptions contains the optional parameters for the DiskAccessesClient.ListPrivateEndpointConnections
// method.
type DiskAccessesClientListPrivateEndpointConnectionsOptions struct {
	// placeholder for future optional parameters
}

// DiskEncryptionSet - disk encryption set resource.
type DiskEncryptionSet struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used
	// to encrypt disks.
	Identity   *EncryptionSetIdentity   `json:"identity,omitempty"`
	Properties *EncryptionSetProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiskEncryptionSetList - The List disk encryption set operation response.
type DiskEncryptionSetList struct {
	// REQUIRED; A list of disk encryption sets.
	Value []*DiskEncryptionSet `json:"value,omitempty"`

	// The uri to fetch the next page of disk encryption sets. Call ListNext() with this to fetch the next page of disk encryption
	// sets.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiskEncryptionSetParameters - Describes the parameter of customer managed disk encryption set resource id that can be specified
// for disk.
// NOTE: The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview
// for more details.
type DiskEncryptionSetParameters struct {
	// Resource Id
	ID *string `json:"id,omitempty"`
}

// DiskEncryptionSetUpdate - disk encryption set update resource.
type DiskEncryptionSetUpdate struct {
	// The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used
	// to encrypt disks.
	Identity *EncryptionSetIdentity `json:"identity,omitempty"`

	// disk encryption set resource update properties.
	Properties *DiskEncryptionSetUpdateProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// DiskEncryptionSetUpdateProperties - disk encryption set resource update properties.
type DiskEncryptionSetUpdateProperties struct {
	// Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
	ActiveKey *KeyForDiskEncryptionSet `json:"activeKey,omitempty"`

	// The type of key used to encrypt the data of the disk.
	EncryptionType *DiskEncryptionSetType `json:"encryptionType,omitempty"`

	// Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will clear the
	// property.
	FederatedClientID *string `json:"federatedClientId,omitempty"`

	// Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
	RotationToLatestKeyVersionEnabled *bool `json:"rotationToLatestKeyVersionEnabled,omitempty"`
}

// DiskEncryptionSetsClientBeginCreateOrUpdateOptions contains the optional parameters for the DiskEncryptionSetsClient.BeginCreateOrUpdate
// method.
type DiskEncryptionSetsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskEncryptionSetsClientBeginDeleteOptions contains the optional parameters for the DiskEncryptionSetsClient.BeginDelete
// method.
type DiskEncryptionSetsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskEncryptionSetsClientBeginUpdateOptions contains the optional parameters for the DiskEncryptionSetsClient.BeginUpdate
// method.
type DiskEncryptionSetsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskEncryptionSetsClientGetOptions contains the optional parameters for the DiskEncryptionSetsClient.Get method.
type DiskEncryptionSetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiskEncryptionSetsClientListAssociatedResourcesOptions contains the optional parameters for the DiskEncryptionSetsClient.ListAssociatedResources
// method.
type DiskEncryptionSetsClientListAssociatedResourcesOptions struct {
	// placeholder for future optional parameters
}

// DiskEncryptionSetsClientListByResourceGroupOptions contains the optional parameters for the DiskEncryptionSetsClient.ListByResourceGroup
// method.
type DiskEncryptionSetsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DiskEncryptionSetsClientListOptions contains the optional parameters for the DiskEncryptionSetsClient.List method.
type DiskEncryptionSetsClientListOptions struct {
	// placeholder for future optional parameters
}

// DiskEncryptionSettings - Describes a Encryption Settings for a Disk
type DiskEncryptionSettings struct {
	// Specifies the location of the disk encryption key, which is a Key Vault Secret.
	DiskEncryptionKey *KeyVaultSecretReference `json:"diskEncryptionKey,omitempty"`

	// Specifies whether disk encryption should be enabled on the virtual machine.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the location of the key encryption key in Key Vault.
	KeyEncryptionKey *KeyVaultKeyReference `json:"keyEncryptionKey,omitempty"`
}

// DiskImageEncryption - This is the disk image encryption base class.
type DiskImageEncryption struct {
	// A relative URI containing the resource ID of the disk encryption set.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`
}

// DiskInstanceView - The instance view of the disk.
type DiskInstanceView struct {
	// Specifies the encryption settings for the OS Disk.
	// Minimum api-version: 2015-06-15
	EncryptionSettings []*DiskEncryptionSettings `json:"encryptionSettings,omitempty"`

	// The disk name.
	Name *string `json:"name,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`
}

// DiskList - The List Disks operation response.
type DiskList struct {
	// REQUIRED; A list of disks.
	Value []*Disk `json:"value,omitempty"`

	// The uri to fetch the next page of disks. Call ListNext() with this to fetch the next page of disks.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiskProperties - Disk resource properties.
type DiskProperties struct {
	// REQUIRED; Disk source information. CreationData information cannot be changed after the disk has been created.
	CreationData *CreationData `json:"creationData,omitempty"`

	// Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default.
	// Does not apply to Ultra disks.
	BurstingEnabled *bool `json:"burstingEnabled,omitempty"`

	// Percentage complete for the background copy when a resource is created via the CopyStart operation.
	CompletionPercent *float32 `json:"completionPercent,omitempty"`

	// Additional authentication requirements when exporting or uploading to a disk or snapshot.
	DataAccessAuthMode *DataAccessAuthMode `json:"dataAccessAuthMode,omitempty"`

	// ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`

	// The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer
	// between 4k and 256k bytes.
	DiskIOPSReadOnly *int64 `json:"diskIOPSReadOnly,omitempty"`

	// The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k
	// bytes.
	DiskIOPSReadWrite *int64 `json:"diskIOPSReadWrite,omitempty"`

	// The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions
	// of bytes per second - MB here uses the ISO notation, of powers of 10.
	DiskMBpsReadOnly *int64 `json:"diskMBpsReadOnly,omitempty"`

	// The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here
	// uses the ISO notation, of powers of 10.
	DiskMBpsReadWrite *int64 `json:"diskMBpsReadWrite,omitempty"`

	// If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this
	// field is present for updates or creation with other options, it indicates a
	// resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`

	// Encryption settings collection used for Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
	EncryptionSettingsCollection *EncryptionSettingsCollection `json:"encryptionSettingsCollection,omitempty"`

	// The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
	HyperVGeneration *HyperVGeneration `json:"hyperVGeneration,omitempty"`

	// The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can
	// be mounted on multiple VMs at the same time.
	MaxShares *int32 `json:"maxShares,omitempty"`

	// Policy for accessing the disk via network.
	NetworkAccessPolicy *NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`

	// The Operating System type.
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times
	// a day) by detached from one virtual machine and attached to another. This
	// property should not be set for disks that are not detached and attached frequently as it causes the disks to not align
	// with the fault domain of the virtual machine.
	OptimizedForFrequentAttach *bool `json:"optimizedForFrequentAttach,omitempty"`

	// Policy for controlling export on the disk.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Purchase plan information for the the image from which the OS disk was created. E.g. - {name: 2019-Datacenter, publisher:
	// MicrosoftWindowsServer, product: WindowsServer}
	PurchasePlan *DiskPurchasePlan `json:"purchasePlan,omitempty"`

	// Contains the security related information for the resource.
	SecurityProfile *DiskSecurityProfile `json:"securityProfile,omitempty"`

	// List of supported capabilities for the image from which the OS disk was created.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`

	// Indicates the OS on a disk supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`

	// Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/.
	// Does not apply to Ultra disks.
	Tier *string `json:"tier,omitempty"`

	// READ-ONLY; Latest time when bursting was last enabled on a disk.
	BurstingEnabledTime *time.Time `json:"burstingEnabledTime,omitempty" azure:"ro"`

	// READ-ONLY; The size of the disk in bytes. This field is read only.
	DiskSizeBytes *int64 `json:"diskSizeBytes,omitempty" azure:"ro"`

	// READ-ONLY; The state of the disk.
	DiskState *DiskState `json:"diskState,omitempty" azure:"ro"`

	// READ-ONLY; Properties of the disk for which update is pending.
	PropertyUpdatesInProgress *PropertyUpdatesInProgress `json:"propertyUpdatesInProgress,omitempty" azure:"ro"`

	// READ-ONLY; The disk provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Details of the list of all VMs that have the disk attached. maxShares should be set to a value greater than
	// one for disks to allow attaching them to multiple VMs.
	ShareInfo []*ShareInfoElement `json:"shareInfo,omitempty" azure:"ro"`

	// READ-ONLY; The time when the disk was created.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; Unique Guid identifying the resource.
	UniqueID *string `json:"uniqueId,omitempty" azure:"ro"`
}

// DiskPurchasePlan - Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
type DiskPurchasePlan struct {
	// REQUIRED; The plan ID.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference
	// element.
	Product *string `json:"product,omitempty"`

	// REQUIRED; The publisher ID.
	Publisher *string `json:"publisher,omitempty"`

	// The Offer Promotion Code.
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// DiskRestorePoint - Properties of disk restore point
type DiskRestorePoint struct {
	// Properties of an incremental disk restore point
	Properties *DiskRestorePointProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiskRestorePointClientBeginGrantAccessOptions contains the optional parameters for the DiskRestorePointClient.BeginGrantAccess
// method.
type DiskRestorePointClientBeginGrantAccessOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskRestorePointClientBeginRevokeAccessOptions contains the optional parameters for the DiskRestorePointClient.BeginRevokeAccess
// method.
type DiskRestorePointClientBeginRevokeAccessOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DiskRestorePointClientGetOptions contains the optional parameters for the DiskRestorePointClient.Get method.
type DiskRestorePointClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiskRestorePointClientListByRestorePointOptions contains the optional parameters for the DiskRestorePointClient.ListByRestorePoint
// method.
type DiskRestorePointClientListByRestorePointOptions struct {
	// placeholder for future optional parameters
}

// DiskRestorePointInstanceView - The instance view of a disk restore point.
type DiskRestorePointInstanceView struct {
	// Disk restore point Id.
	ID *string `json:"id,omitempty"`

	// The disk restore point replication status information.
	ReplicationStatus *DiskRestorePointReplicationStatus `json:"replicationStatus,omitempty"`
}

// DiskRestorePointList - The List Disk Restore Points operation response.
type DiskRestorePointList struct {
	// REQUIRED; A list of disk restore points.
	Value []*DiskRestorePoint `json:"value,omitempty"`

	// The uri to fetch the next page of disk restore points. Call ListNext() with this to fetch the next page of disk restore
	// points.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiskRestorePointProperties - Properties of an incremental disk restore point
type DiskRestorePointProperties struct {
	// Percentage complete for the background copy of disk restore point when source resource is from a different region.
	CompletionPercent *float32 `json:"completionPercent,omitempty"`

	// ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`

	// The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
	HyperVGeneration *HyperVGeneration `json:"hyperVGeneration,omitempty"`

	// Policy for accessing the disk via network.
	NetworkAccessPolicy *NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`

	// Policy for controlling export on the disk.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Purchase plan information for the the image from which the OS disk was created.
	PurchasePlan *DiskPurchasePlan `json:"purchasePlan,omitempty"`

	// Contains the security related information for the resource.
	SecurityProfile *DiskSecurityProfile `json:"securityProfile,omitempty"`

	// List of supported capabilities for the image from which the OS disk was created.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`

	// Indicates the OS on a disk supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`

	// READ-ONLY; Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty" azure:"ro"`

	// READ-ONLY; id of the backing snapshot's MIS family
	FamilyID *string `json:"familyId,omitempty" azure:"ro"`

	// READ-ONLY; The Operating System type.
	OSType *OperatingSystemTypes `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; Replication state of disk restore point when source resource is from a different region.
	ReplicationState *string `json:"replicationState,omitempty" azure:"ro"`

	// READ-ONLY; arm id of source disk or source disk restore point.
	SourceResourceID *string `json:"sourceResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Location of source disk or source disk restore point when source resource is from a different region.
	SourceResourceLocation *string `json:"sourceResourceLocation,omitempty" azure:"ro"`

	// READ-ONLY; unique incarnation id of the source disk
	SourceUniqueID *string `json:"sourceUniqueId,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of restorePoint creation
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`
}

// DiskRestorePointReplicationStatus - The instance view of a disk restore point.
type DiskRestorePointReplicationStatus struct {
	// Replication completion percentage.
	CompletionPercent *int32 `json:"completionPercent,omitempty"`

	// The resource status information.
	Status *InstanceViewStatus `json:"status,omitempty"`
}

// DiskSKU - The disks sku name. Can be StandardLRS, PremiumLRS, StandardSSDLRS, UltraSSDLRS, PremiumZRS, StandardSSDZRS,
// or PremiumV2_LRS.
type DiskSKU struct {
	// The sku name.
	Name *DiskStorageAccountTypes `json:"name,omitempty"`

	// READ-ONLY; The sku tier.
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// DiskSecurityProfile - Contains the security related information for the resource.
type DiskSecurityProfile struct {
	// ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
	SecureVMDiskEncryptionSetID *string `json:"secureVMDiskEncryptionSetId,omitempty"`

	// Specifies the SecurityType of the VM. Applicable for OS disks only.
	SecurityType *DiskSecurityTypes `json:"securityType,omitempty"`
}

// DiskUpdate - Disk update resource.
type DiskUpdate struct {
	// Disk resource update properties.
	Properties *DiskUpdateProperties `json:"properties,omitempty"`

	// The disks sku name. Can be StandardLRS, PremiumLRS, StandardSSDLRS, UltraSSDLRS, PremiumZRS, StandardSSDZRS, or PremiumV2_LRS.
	SKU *DiskSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// DiskUpdateProperties - Disk resource update properties.
type DiskUpdateProperties struct {
	// Set to true to enable bursting beyond the provisioned performance target of the disk. Bursting is disabled by default.
	// Does not apply to Ultra disks.
	BurstingEnabled *bool `json:"burstingEnabled,omitempty"`

	// Additional authentication requirements when exporting or uploading to a disk or snapshot.
	DataAccessAuthMode *DataAccessAuthMode `json:"dataAccessAuthMode,omitempty"`

	// ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`

	// The total number of IOPS that will be allowed across all VMs mounting the shared disk as ReadOnly. One operation can transfer
	// between 4k and 256k bytes.
	DiskIOPSReadOnly *int64 `json:"diskIOPSReadOnly,omitempty"`

	// The number of IOPS allowed for this disk; only settable for UltraSSD disks. One operation can transfer between 4k and 256k
	// bytes.
	DiskIOPSReadWrite *int64 `json:"diskIOPSReadWrite,omitempty"`

	// The total throughput (MBps) that will be allowed across all VMs mounting the shared disk as ReadOnly. MBps means millions
	// of bytes per second - MB here uses the ISO notation, of powers of 10.
	DiskMBpsReadOnly *int64 `json:"diskMBpsReadOnly,omitempty"`

	// The bandwidth allowed for this disk; only settable for UltraSSD disks. MBps means millions of bytes per second - MB here
	// uses the ISO notation, of powers of 10.
	DiskMBpsReadWrite *int64 `json:"diskMBpsReadWrite,omitempty"`

	// If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this
	// field is present for updates or creation with other options, it indicates a
	// resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`

	// Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
	EncryptionSettingsCollection *EncryptionSettingsCollection `json:"encryptionSettingsCollection,omitempty"`

	// The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can
	// be mounted on multiple VMs at the same time.
	MaxShares *int32 `json:"maxShares,omitempty"`

	// Policy for accessing the disk via network.
	NetworkAccessPolicy *NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`

	// the Operating System type.
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// Setting this property to true improves reliability and performance of data disks that are frequently (more than 5 times
	// a day) by detached from one virtual machine and attached to another. This
	// property should not be set for disks that are not detached and attached frequently as it causes the disks to not align
	// with the fault domain of the virtual machine.
	OptimizedForFrequentAttach *bool `json:"optimizedForFrequentAttach,omitempty"`

	// Policy for controlling export on the disk.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Purchase plan information to be added on the OS disk
	PurchasePlan *DiskPurchasePlan `json:"purchasePlan,omitempty"`

	// List of supported capabilities to be added on the OS disk.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`

	// Indicates the OS on a disk supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`

	// Performance tier of the disk (e.g, P4, S10) as described here: https://azure.microsoft.com/en-us/pricing/details/managed-disks/.
	// Does not apply to Ultra disks.
	Tier *string `json:"tier,omitempty"`

	// READ-ONLY; Properties of the disk for which update is pending.
	PropertyUpdatesInProgress *PropertyUpdatesInProgress `json:"propertyUpdatesInProgress,omitempty" azure:"ro"`
}

// DisksClientBeginCreateOrUpdateOptions contains the optional parameters for the DisksClient.BeginCreateOrUpdate method.
type DisksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientBeginDeleteOptions contains the optional parameters for the DisksClient.BeginDelete method.
type DisksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientBeginGrantAccessOptions contains the optional parameters for the DisksClient.BeginGrantAccess method.
type DisksClientBeginGrantAccessOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientBeginRevokeAccessOptions contains the optional parameters for the DisksClient.BeginRevokeAccess method.
type DisksClientBeginRevokeAccessOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientBeginUpdateOptions contains the optional parameters for the DisksClient.BeginUpdate method.
type DisksClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientGetOptions contains the optional parameters for the DisksClient.Get method.
type DisksClientGetOptions struct {
	// placeholder for future optional parameters
}

// DisksClientListByResourceGroupOptions contains the optional parameters for the DisksClient.ListByResourceGroup method.
type DisksClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DisksClientListOptions contains the optional parameters for the DisksClient.List method.
type DisksClientListOptions struct {
	// placeholder for future optional parameters
}

// Encryption at rest settings for disk or snapshot
type Encryption struct {
	// ResourceId of the disk encryption set to use for enabling encryption at rest.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The type of key used to encrypt the data of the disk.
	Type *EncryptionType `json:"type,omitempty"`
}

// EncryptionImages - Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the
// gallery artifact.
type EncryptionImages struct {
	// A list of encryption specifications for data disk images.
	DataDiskImages []*DataDiskImageEncryption `json:"dataDiskImages,omitempty"`

	// Contains encryption settings for an OS disk image.
	OSDiskImage *OSDiskImageEncryption `json:"osDiskImage,omitempty"`
}

// EncryptionSetIdentity - The managed identity for the disk encryption set. It should be given permission on the key vault
// before it can be used to encrypt disks.
type EncryptionSetIdentity struct {
	// The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption
	// Sets can be updated with Identity type None during migration of
	// subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
	Type *DiskEncryptionSetIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the disk encryption set. The user identity dictionary key references will be
	// ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id
	// header in the PUT request if the resource has a systemAssigned(implicit)
	// identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id
	// header in the PUT request if the resource has a systemAssigned(implicit) identity
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

type EncryptionSetProperties struct {
	// The key vault key which is currently used by this disk encryption set.
	ActiveKey *KeyForDiskEncryptionSet `json:"activeKey,omitempty"`

	// The type of key used to encrypt the data of the disk.
	EncryptionType *DiskEncryptionSetType `json:"encryptionType,omitempty"`

	// Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will clear the
	// property.
	FederatedClientID *string `json:"federatedClientId,omitempty"`

	// Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
	RotationToLatestKeyVersionEnabled *bool `json:"rotationToLatestKeyVersionEnabled,omitempty"`

	// READ-ONLY; The error that was encountered during auto-key rotation. If an error is present, then auto-key rotation will
	// not be attempted until the error on this disk encryption set is fixed.
	AutoKeyRotationError *APIError `json:"autoKeyRotationError,omitempty" azure:"ro"`

	// READ-ONLY; The time when the active key of this disk encryption set was updated.
	LastKeyRotationTimestamp *time.Time `json:"lastKeyRotationTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; A readonly collection of key vault keys previously used by this disk encryption set while a key rotation is
	// in progress. It will be empty if there is no ongoing key rotation.
	PreviousKeys []*KeyForDiskEncryptionSet `json:"previousKeys,omitempty" azure:"ro"`

	// READ-ONLY; The disk encryption set provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// EncryptionSettingsCollection - Encryption settings for disk or snapshot
type EncryptionSettingsCollection struct {
	// REQUIRED; Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this
	// flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption.
	// If EncryptionSettings is null in the request object, the existing settings remain unchanged.
	Enabled *bool `json:"enabled,omitempty"`

	// A collection of encryption settings, one for each disk volume.
	EncryptionSettings []*EncryptionSettingsElement `json:"encryptionSettings,omitempty"`

	// Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds
	// to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk
	// Encryption.
	EncryptionSettingsVersion *string `json:"encryptionSettingsVersion,omitempty"`
}

// EncryptionSettingsElement - Encryption settings for one disk volume.
type EncryptionSettingsElement struct {
	// Key Vault Secret Url and vault id of the disk encryption key
	DiskEncryptionKey *KeyVaultAndSecretReference `json:"diskEncryptionKey,omitempty"`

	// Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap
	// the disk encryption key.
	KeyEncryptionKey *KeyVaultAndKeyReference `json:"keyEncryptionKey,omitempty"`
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string `json:"name,omitempty"`

	// The type of the extended location.
	Type *ExtendedLocationTypes `json:"type,omitempty"`
}

// Extension - Describes a cloud service Extension.
type Extension struct {
	// The name of the extension.
	Name *string `json:"name,omitempty"`

	// Extension Properties.
	Properties *CloudServiceExtensionProperties `json:"properties,omitempty"`
}

// GalleriesClientBeginCreateOrUpdateOptions contains the optional parameters for the GalleriesClient.BeginCreateOrUpdate
// method.
type GalleriesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleriesClientBeginDeleteOptions contains the optional parameters for the GalleriesClient.BeginDelete method.
type GalleriesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleriesClientBeginUpdateOptions contains the optional parameters for the GalleriesClient.BeginUpdate method.
type GalleriesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleriesClientGetOptions contains the optional parameters for the GalleriesClient.Get method.
type GalleriesClientGetOptions struct {
	// The expand query option to apply on the operation.
	Expand *GalleryExpandParams
	// The select expression to apply on the operation.
	Select *SelectPermissions
}

// GalleriesClientListByResourceGroupOptions contains the optional parameters for the GalleriesClient.ListByResourceGroup
// method.
type GalleriesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// GalleriesClientListOptions contains the optional parameters for the GalleriesClient.List method.
type GalleriesClientListOptions struct {
	// placeholder for future optional parameters
}

// Gallery - Specifies information about the Shared Image Gallery that you want to create or update.
type Gallery struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a Shared Image Gallery.
	Properties *GalleryProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryApplication - Specifies information about the gallery Application Definition that you want to create or update.
type GalleryApplication struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a gallery Application Definition.
	Properties *GalleryApplicationProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryApplicationCustomAction - A custom action that can be performed with a Gallery Application Version.
type GalleryApplicationCustomAction struct {
	// REQUIRED; The name of the custom action. Must be unique within the Gallery Application Version.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The script to run when executing this custom action.
	Script *string `json:"script,omitempty"`

	// Description to help the users understand what this custom action does.
	Description *string `json:"description,omitempty"`

	// The parameters that this custom action uses
	Parameters []*GalleryApplicationCustomActionParameter `json:"parameters,omitempty"`
}

// GalleryApplicationCustomActionParameter - The definition of a parameter that can be passed to a custom action of a Gallery
// Application Version.
type GalleryApplicationCustomActionParameter struct {
	// REQUIRED; The name of the custom action. Must be unique within the Gallery Application Version.
	Name *string `json:"name,omitempty"`

	// The default value of the parameter. Only applies to string types
	DefaultValue *string `json:"defaultValue,omitempty"`

	// A description to help users understand what this parameter means
	Description *string `json:"description,omitempty"`

	// Indicates whether this parameter must be passed when running the custom action.
	Required *bool `json:"required,omitempty"`

	// Specifies the type of the custom action parameter. Possible values are: String, ConfigurationDataBlob or LogOutputBlob
	Type *GalleryApplicationCustomActionParameterType `json:"type,omitempty"`
}

// GalleryApplicationList - The List Gallery Applications operation response.
type GalleryApplicationList struct {
	// REQUIRED; A list of Gallery Applications.
	Value []*GalleryApplication `json:"value,omitempty"`

	// The uri to fetch the next page of Application Definitions in the Application Gallery. Call ListNext() with this to fetch
	// the next page of gallery Application Definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryApplicationProperties - Describes the properties of a gallery Application Definition.
type GalleryApplicationProperties struct {
	// REQUIRED; This property allows you to specify the supported type of the OS that application is built for.
	// Possible values are:
	// Windows
	// Linux
	SupportedOSType *OperatingSystemTypes `json:"supportedOSType,omitempty"`

	// A list of custom actions that can be performed with all of the Gallery Application Versions within this Gallery Application.
	CustomActions []*GalleryApplicationCustomAction `json:"customActions,omitempty"`

	// The description of this gallery Application Definition resource. This property is updatable.
	Description *string `json:"description,omitempty"`

	// The end of life date of the gallery Application Definition. This property can be used for decommissioning purposes. This
	// property is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// The Eula agreement for the gallery Application Definition.
	Eula *string `json:"eula,omitempty"`

	// The privacy statement uri.
	PrivacyStatementURI *string `json:"privacyStatementUri,omitempty"`

	// The release note uri.
	ReleaseNoteURI *string `json:"releaseNoteUri,omitempty"`
}

// GalleryApplicationUpdate - Specifies information about the gallery Application Definition that you want to update.
type GalleryApplicationUpdate struct {
	// Describes the properties of a gallery Application Definition.
	Properties *GalleryApplicationProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryApplicationVersion - Specifies information about the gallery Application Version that you want to create or update.
type GalleryApplicationVersion struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a gallery image version.
	Properties *GalleryApplicationVersionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryApplicationVersionList - The List Gallery Application version operation response.
type GalleryApplicationVersionList struct {
	// REQUIRED; A list of gallery Application Versions.
	Value []*GalleryApplicationVersion `json:"value,omitempty"`

	// The uri to fetch the next page of gallery Application Versions. Call ListNext() with this to fetch the next page of gallery
	// Application Versions.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryApplicationVersionProperties - Describes the properties of a gallery image version.
type GalleryApplicationVersionProperties struct {
	// REQUIRED; The publishing profile of a gallery image version.
	PublishingProfile *GalleryApplicationVersionPublishingProfile `json:"publishingProfile,omitempty"`

	// The safety profile of the Gallery Application Version.
	SafetyProfile *GalleryApplicationVersionSafetyProfile `json:"safetyProfile,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *GalleryProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; This is the replication status of the gallery image version.
	ReplicationStatus *ReplicationStatus `json:"replicationStatus,omitempty" azure:"ro"`
}

// GalleryApplicationVersionPublishingProfile - The publishing profile of a gallery image version.
type GalleryApplicationVersionPublishingProfile struct {
	// REQUIRED; The source image from which the Image Version is going to be created.
	Source *UserArtifactSource `json:"source,omitempty"`

	// Optional. Additional settings to pass to the vm-application-manager extension. For advanced use only.
	AdvancedSettings map[string]*string `json:"advancedSettings,omitempty"`

	// A list of custom actions that can be performed with this Gallery Application Version.
	CustomActions []*GalleryApplicationCustomAction `json:"customActions,omitempty"`

	// Optional. Whether or not this application reports health.
	EnableHealthCheck *bool `json:"enableHealthCheck,omitempty"`

	// The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property
	// is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
	ExcludeFromLatest *bool               `json:"excludeFromLatest,omitempty"`
	ManageActions     *UserArtifactManage `json:"manageActions,omitempty"`

	// The number of replicas of the Image Version to be created per region. This property would take effect for a region when
	// regionalReplicaCount is not specified. This property is updatable.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`

	// Optional parameter which specifies the mode to be used for replication. This property is not updatable.
	ReplicationMode *ReplicationMode `json:"replicationMode,omitempty"`

	// Additional settings for the VM app that contains the target package and config file name when it is deployed to target
	// VM or VM scale set.
	Settings *UserArtifactSettings `json:"settings,omitempty"`

	// Specifies the storage account type to be used to store the image. This property is not updatable.
	StorageAccountType *StorageAccountType `json:"storageAccountType,omitempty"`

	// The target extended locations where the Image Version is going to be replicated to. This property is updatable.
	TargetExtendedLocations []*GalleryTargetExtendedLocation `json:"targetExtendedLocations,omitempty"`

	// The target regions where the Image Version is going to be replicated to. This property is updatable.
	TargetRegions []*TargetRegion `json:"targetRegions,omitempty"`

	// READ-ONLY; The timestamp for when the gallery image version is published.
	PublishedDate *time.Time `json:"publishedDate,omitempty" azure:"ro"`
}

// GalleryApplicationVersionSafetyProfile - The safety profile of the Gallery Application Version.
type GalleryApplicationVersionSafetyProfile struct {
	// Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
	AllowDeletionOfReplicatedLocations *bool `json:"allowDeletionOfReplicatedLocations,omitempty"`
}

// GalleryApplicationVersionUpdate - Specifies information about the gallery Application Version that you want to update.
type GalleryApplicationVersionUpdate struct {
	// Describes the properties of a gallery image version.
	Properties *GalleryApplicationVersionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryApplicationVersionsClientBeginCreateOrUpdateOptions contains the optional parameters for the GalleryApplicationVersionsClient.BeginCreateOrUpdate
// method.
type GalleryApplicationVersionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryApplicationVersionsClientBeginDeleteOptions contains the optional parameters for the GalleryApplicationVersionsClient.BeginDelete
// method.
type GalleryApplicationVersionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryApplicationVersionsClientBeginUpdateOptions contains the optional parameters for the GalleryApplicationVersionsClient.BeginUpdate
// method.
type GalleryApplicationVersionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryApplicationVersionsClientGetOptions contains the optional parameters for the GalleryApplicationVersionsClient.Get
// method.
type GalleryApplicationVersionsClientGetOptions struct {
	// The expand expression to apply on the operation.
	Expand *ReplicationStatusTypes
}

// GalleryApplicationVersionsClientListByGalleryApplicationOptions contains the optional parameters for the GalleryApplicationVersionsClient.ListByGalleryApplication
// method.
type GalleryApplicationVersionsClientListByGalleryApplicationOptions struct {
	// placeholder for future optional parameters
}

// GalleryApplicationsClientBeginCreateOrUpdateOptions contains the optional parameters for the GalleryApplicationsClient.BeginCreateOrUpdate
// method.
type GalleryApplicationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryApplicationsClientBeginDeleteOptions contains the optional parameters for the GalleryApplicationsClient.BeginDelete
// method.
type GalleryApplicationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryApplicationsClientBeginUpdateOptions contains the optional parameters for the GalleryApplicationsClient.BeginUpdate
// method.
type GalleryApplicationsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryApplicationsClientGetOptions contains the optional parameters for the GalleryApplicationsClient.Get method.
type GalleryApplicationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GalleryApplicationsClientListByGalleryOptions contains the optional parameters for the GalleryApplicationsClient.ListByGallery
// method.
type GalleryApplicationsClientListByGalleryOptions struct {
	// placeholder for future optional parameters
}

// GalleryArtifactPublishingProfileBase - Describes the basic gallery artifact publishing profile.
type GalleryArtifactPublishingProfileBase struct {
	// The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property
	// is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`

	// The number of replicas of the Image Version to be created per region. This property would take effect for a region when
	// regionalReplicaCount is not specified. This property is updatable.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`

	// Optional parameter which specifies the mode to be used for replication. This property is not updatable.
	ReplicationMode *ReplicationMode `json:"replicationMode,omitempty"`

	// Specifies the storage account type to be used to store the image. This property is not updatable.
	StorageAccountType *StorageAccountType `json:"storageAccountType,omitempty"`

	// The target extended locations where the Image Version is going to be replicated to. This property is updatable.
	TargetExtendedLocations []*GalleryTargetExtendedLocation `json:"targetExtendedLocations,omitempty"`

	// The target regions where the Image Version is going to be replicated to. This property is updatable.
	TargetRegions []*TargetRegion `json:"targetRegions,omitempty"`

	// READ-ONLY; The timestamp for when the gallery image version is published.
	PublishedDate *time.Time `json:"publishedDate,omitempty" azure:"ro"`
}

// GalleryArtifactSafetyProfileBase - This is the safety profile of the Gallery Artifact Version.
type GalleryArtifactSafetyProfileBase struct {
	// Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
	AllowDeletionOfReplicatedLocations *bool `json:"allowDeletionOfReplicatedLocations,omitempty"`
}

// GalleryArtifactSource - The source image from which the Image Version is going to be created.
type GalleryArtifactSource struct {
	// REQUIRED; The managed artifact.
	ManagedImage *ManagedArtifact `json:"managedImage,omitempty"`
}

// GalleryArtifactVersionFullSource - The source of the gallery artifact version.
type GalleryArtifactVersionFullSource struct {
	// The resource Id of the source Community Gallery Image. Only required when using Community Gallery Image as a source.
	CommunityGalleryImageID *string `json:"communityGalleryImageId,omitempty"`

	// The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
	ID *string `json:"id,omitempty"`
}

// GalleryArtifactVersionSource - The gallery artifact version source.
type GalleryArtifactVersionSource struct {
	// The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
	ID *string `json:"id,omitempty"`
}

// GalleryDataDiskImage - This is the data disk image.
type GalleryDataDiskImage struct {
	// REQUIRED; This property specifies the logical unit number of the data disk. This value is used to identify data disks within
	// the Virtual Machine and therefore must be unique for each data disk attached to the
	// Virtual Machine.
	Lun *int32 `json:"lun,omitempty"`

	// The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
	HostCaching *HostCaching `json:"hostCaching,omitempty"`

	// The source for the disk image.
	Source *GalleryDiskImageSource `json:"source,omitempty"`

	// READ-ONLY; This property indicates the size of the VHD to be created.
	SizeInGB *int32 `json:"sizeInGB,omitempty" azure:"ro"`
}

// GalleryDiskImage - This is the disk image base class.
type GalleryDiskImage struct {
	// The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
	HostCaching *HostCaching `json:"hostCaching,omitempty"`

	// The source for the disk image.
	Source *GalleryDiskImageSource `json:"source,omitempty"`

	// READ-ONLY; This property indicates the size of the VHD to be created.
	SizeInGB *int32 `json:"sizeInGB,omitempty" azure:"ro"`
}

// GalleryDiskImageSource - The source for the disk image.
type GalleryDiskImageSource struct {
	// The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
	ID *string `json:"id,omitempty"`

	// The Storage Account Id that contains the vhd blob being used as a source for this artifact version.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
	URI *string `json:"uri,omitempty"`
}

// GalleryExtendedLocation - The name of the extended location.
type GalleryExtendedLocation struct {
	Name *string `json:"name,omitempty"`

	// It is type of the extended location.
	Type *GalleryExtendedLocationType `json:"type,omitempty"`
}

// GalleryIdentifier - Describes the gallery unique name.
type GalleryIdentifier struct {
	// READ-ONLY; The unique name of the Shared Image Gallery. This name is generated automatically by Azure.
	UniqueName *string `json:"uniqueName,omitempty" azure:"ro"`
}

// GalleryImage - Specifies information about the gallery image definition that you want to create or update.
type GalleryImage struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a gallery image definition.
	Properties *GalleryImageProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryImageFeature - A feature for gallery image.
type GalleryImageFeature struct {
	// The name of the gallery image feature.
	Name *string `json:"name,omitempty"`

	// The value of the gallery image feature.
	Value *string `json:"value,omitempty"`
}

// GalleryImageIdentifier - This is the gallery image definition identifier.
type GalleryImageIdentifier struct {
	// REQUIRED; The name of the gallery image definition offer.
	Offer *string `json:"offer,omitempty"`

	// REQUIRED; The name of the gallery image definition publisher.
	Publisher *string `json:"publisher,omitempty"`

	// REQUIRED; The name of the gallery image definition SKU.
	SKU *string `json:"sku,omitempty"`
}

// GalleryImageList - The List Gallery Images operation response.
type GalleryImageList struct {
	// REQUIRED; A list of Shared Image Gallery images.
	Value []*GalleryImage `json:"value,omitempty"`

	// The uri to fetch the next page of Image Definitions in the Shared Image Gallery. Call ListNext() with this to fetch the
	// next page of gallery image definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryImageProperties - Describes the properties of a gallery image definition.
type GalleryImageProperties struct {
	// REQUIRED; This is the gallery image definition identifier.
	Identifier *GalleryImageIdentifier `json:"identifier,omitempty"`

	// REQUIRED; This property allows the user to specify whether the virtual machines created under this image are 'Generalized'
	// or 'Specialized'.
	OSState *OperatingSystemStateTypes `json:"osState,omitempty"`

	// REQUIRED; This property allows you to specify the type of the OS that is included in the disk when creating a VM from a
	// managed image.
	// Possible values are:
	// Windows
	// Linux
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// The architecture of the image. Applicable to OS disks only.
	Architecture *Architecture `json:"architecture,omitempty"`

	// The description of this gallery image definition resource. This property is updatable.
	Description *string `json:"description,omitempty"`

	// Describes the disallowed disk types.
	Disallowed *Disallowed `json:"disallowed,omitempty"`

	// The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property
	// is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// The Eula agreement for the gallery image definition.
	Eula *string `json:"eula,omitempty"`

	// A list of gallery image features.
	Features []*GalleryImageFeature `json:"features,omitempty"`

	// The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
	HyperVGeneration *HyperVGeneration `json:"hyperVGeneration,omitempty"`

	// The privacy statement uri.
	PrivacyStatementURI *string `json:"privacyStatementUri,omitempty"`

	// Describes the gallery image definition purchase plan. This is used by marketplace images.
	PurchasePlan *ImagePurchasePlan `json:"purchasePlan,omitempty"`

	// The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
	Recommended *RecommendedMachineConfiguration `json:"recommended,omitempty"`

	// The release note uri.
	ReleaseNoteURI *string `json:"releaseNoteUri,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *GalleryProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GalleryImageUpdate - Specifies information about the gallery image definition that you want to update.
type GalleryImageUpdate struct {
	// Describes the properties of a gallery image definition.
	Properties *GalleryImageProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryImageVersion - Specifies information about the gallery image version that you want to create or update.
type GalleryImageVersion struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a gallery image version.
	Properties *GalleryImageVersionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryImageVersionList - The List Gallery Image version operation response.
type GalleryImageVersionList struct {
	// REQUIRED; A list of gallery image versions.
	Value []*GalleryImageVersion `json:"value,omitempty"`

	// The uri to fetch the next page of gallery image versions. Call ListNext() with this to fetch the next page of gallery image
	// versions.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryImageVersionProperties - Describes the properties of a gallery image version.
type GalleryImageVersionProperties struct {
	// REQUIRED; This is the storage profile of a Gallery Image Version.
	StorageProfile *GalleryImageVersionStorageProfile `json:"storageProfile,omitempty"`

	// The publishing profile of a gallery image Version.
	PublishingProfile *GalleryImageVersionPublishingProfile `json:"publishingProfile,omitempty"`

	// This is the safety profile of the Gallery Image Version.
	SafetyProfile *GalleryImageVersionSafetyProfile `json:"safetyProfile,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *GalleryProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; This is the replication status of the gallery image version.
	ReplicationStatus *ReplicationStatus `json:"replicationStatus,omitempty" azure:"ro"`
}

// GalleryImageVersionPublishingProfile - The publishing profile of a gallery image Version.
type GalleryImageVersionPublishingProfile struct {
	// The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property
	// is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`

	// The number of replicas of the Image Version to be created per region. This property would take effect for a region when
	// regionalReplicaCount is not specified. This property is updatable.
	ReplicaCount *int32 `json:"replicaCount,omitempty"`

	// Optional parameter which specifies the mode to be used for replication. This property is not updatable.
	ReplicationMode *ReplicationMode `json:"replicationMode,omitempty"`

	// Specifies the storage account type to be used to store the image. This property is not updatable.
	StorageAccountType *StorageAccountType `json:"storageAccountType,omitempty"`

	// The target extended locations where the Image Version is going to be replicated to. This property is updatable.
	TargetExtendedLocations []*GalleryTargetExtendedLocation `json:"targetExtendedLocations,omitempty"`

	// The target regions where the Image Version is going to be replicated to. This property is updatable.
	TargetRegions []*TargetRegion `json:"targetRegions,omitempty"`

	// READ-ONLY; The timestamp for when the gallery image version is published.
	PublishedDate *time.Time `json:"publishedDate,omitempty" azure:"ro"`
}

// GalleryImageVersionSafetyProfile - This is the safety profile of the Gallery Image Version.
type GalleryImageVersionSafetyProfile struct {
	// Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
	AllowDeletionOfReplicatedLocations *bool `json:"allowDeletionOfReplicatedLocations,omitempty"`

	// READ-ONLY; A list of Policy Violations that have been reported for this Gallery Image Version.
	PolicyViolations []*PolicyViolation `json:"policyViolations,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether this image has been reported as violating Microsoft's policies.
	ReportedForPolicyViolation *bool `json:"reportedForPolicyViolation,omitempty" azure:"ro"`
}

// GalleryImageVersionStorageProfile - This is the storage profile of a Gallery Image Version.
type GalleryImageVersionStorageProfile struct {
	// A list of data disk images.
	DataDiskImages []*GalleryDataDiskImage `json:"dataDiskImages,omitempty"`

	// This is the OS disk image.
	OSDiskImage *GalleryOSDiskImage `json:"osDiskImage,omitempty"`

	// The source of the gallery artifact version.
	Source *GalleryArtifactVersionFullSource `json:"source,omitempty"`
}

// GalleryImageVersionUpdate - Specifies information about the gallery image version that you want to update.
type GalleryImageVersionUpdate struct {
	// Describes the properties of a gallery image version.
	Properties *GalleryImageVersionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryImageVersionsClientBeginCreateOrUpdateOptions contains the optional parameters for the GalleryImageVersionsClient.BeginCreateOrUpdate
// method.
type GalleryImageVersionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryImageVersionsClientBeginDeleteOptions contains the optional parameters for the GalleryImageVersionsClient.BeginDelete
// method.
type GalleryImageVersionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryImageVersionsClientBeginUpdateOptions contains the optional parameters for the GalleryImageVersionsClient.BeginUpdate
// method.
type GalleryImageVersionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryImageVersionsClientGetOptions contains the optional parameters for the GalleryImageVersionsClient.Get method.
type GalleryImageVersionsClientGetOptions struct {
	// The expand expression to apply on the operation.
	Expand *ReplicationStatusTypes
}

// GalleryImageVersionsClientListByGalleryImageOptions contains the optional parameters for the GalleryImageVersionsClient.ListByGalleryImage
// method.
type GalleryImageVersionsClientListByGalleryImageOptions struct {
	// placeholder for future optional parameters
}

// GalleryImagesClientBeginCreateOrUpdateOptions contains the optional parameters for the GalleryImagesClient.BeginCreateOrUpdate
// method.
type GalleryImagesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryImagesClientBeginDeleteOptions contains the optional parameters for the GalleryImagesClient.BeginDelete method.
type GalleryImagesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryImagesClientBeginUpdateOptions contains the optional parameters for the GalleryImagesClient.BeginUpdate method.
type GalleryImagesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GalleryImagesClientGetOptions contains the optional parameters for the GalleryImagesClient.Get method.
type GalleryImagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// GalleryImagesClientListByGalleryOptions contains the optional parameters for the GalleryImagesClient.ListByGallery method.
type GalleryImagesClientListByGalleryOptions struct {
	// placeholder for future optional parameters
}

// GalleryList - The List Galleries operation response.
type GalleryList struct {
	// REQUIRED; A list of galleries.
	Value []*Gallery `json:"value,omitempty"`

	// The uri to fetch the next page of galleries. Call ListNext() with this to fetch the next page of galleries.
	NextLink *string `json:"nextLink,omitempty"`
}

// GalleryOSDiskImage - This is the OS disk image.
type GalleryOSDiskImage struct {
	// The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
	HostCaching *HostCaching `json:"hostCaching,omitempty"`

	// The source for the disk image.
	Source *GalleryDiskImageSource `json:"source,omitempty"`

	// READ-ONLY; This property indicates the size of the VHD to be created.
	SizeInGB *int32 `json:"sizeInGB,omitempty" azure:"ro"`
}

// GalleryProperties - Describes the properties of a Shared Image Gallery.
type GalleryProperties struct {
	// The description of this Shared Image Gallery resource. This property is updatable.
	Description *string `json:"description,omitempty"`

	// Describes the gallery unique name.
	Identifier *GalleryIdentifier `json:"identifier,omitempty"`

	// Profile for gallery sharing to subscription or tenant
	SharingProfile *SharingProfile `json:"sharingProfile,omitempty"`

	// Contains information about the soft deletion policy of the gallery.
	SoftDeletePolicy *SoftDeletePolicy `json:"softDeletePolicy,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *GalleryProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Sharing status of current gallery.
	SharingStatus *SharingStatus `json:"sharingStatus,omitempty" azure:"ro"`
}

// GallerySharingProfileClientBeginUpdateOptions contains the optional parameters for the GallerySharingProfileClient.BeginUpdate
// method.
type GallerySharingProfileClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

type GalleryTargetExtendedLocation struct {
	// Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
	Encryption *EncryptionImages `json:"encryption,omitempty"`

	// The name of the extended location.
	ExtendedLocation *GalleryExtendedLocation `json:"extendedLocation,omitempty"`

	// The number of replicas of the Image Version to be created per extended location. This property is updatable.
	ExtendedLocationReplicaCount *int32 `json:"extendedLocationReplicaCount,omitempty"`

	// The name of the region.
	Name *string `json:"name,omitempty"`

	// Specifies the storage account type to be used to store the image. This property is not updatable.
	StorageAccountType *StorageAccountType `json:"storageAccountType,omitempty"`
}

// GalleryUpdate - Specifies information about the Shared Image Gallery that you want to update.
type GalleryUpdate struct {
	// Describes the properties of a Shared Image Gallery.
	Properties *GalleryProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GrantAccessData - Data used for requesting a SAS.
type GrantAccessData struct {
	// REQUIRED
	Access *AccessLevel `json:"access,omitempty"`

	// REQUIRED; Time duration in seconds until the SAS access expires.
	DurationInSeconds *int32 `json:"durationInSeconds,omitempty"`

	// Set this flag to true to get additional SAS for VM guest state
	GetSecureVMGuestStateSAS *bool `json:"getSecureVMGuestStateSAS,omitempty"`
}

// HardwareProfile - Specifies the hardware settings for the virtual machine.
type HardwareProfile struct {
	// Specifies the size of the virtual machine.
	// The enum data type is currently deprecated and will be removed by December 23rd 2023.
	// Recommended way to get the list of available sizes is using these APIs:
	// List all available virtual machine sizes in an availability set [https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes]
	// List all available virtual machine sizes in a region [https://docs.microsoft.com/rest/api/compute/resourceskus/list]
	// List all available virtual machine sizes for resizing [https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes].
	// For more information about virtual machine sizes, see Sizes for
	// virtual machines [https://docs.microsoft.com/azure/virtual-machines/sizes].
	// The available VM sizes depend on region and availability set.
	VMSize *VirtualMachineSizeTypes `json:"vmSize,omitempty"`

	// Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01.
	// This feature is still in preview mode and is not supported for VirtualMachineScaleSet.
	// Please follow the instructions in VM Customization [https://aka.ms/vmcustomization] for more details.
	VMSizeProperties *VMSizeProperties `json:"vmSizeProperties,omitempty"`
}

// Image - The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual
// machine. If SourceImage is provided, the destination virtual hard drive must not
// exist.
type Image struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The extended location of the Image.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Describes the properties of an Image.
	Properties *ImageProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImageDataDisk - Describes a data disk.
type ImageDataDisk struct {
	// REQUIRED; Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and
	// therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty"`

	// The Virtual Hard Disk.
	BlobURI *string `json:"blobUri,omitempty"`

	// Specifies the caching requirements.
	// Possible values are:
	// None
	// ReadOnly
	// ReadWrite
	// Default: None for Standard storage. ReadOnly for Premium storage
	Caching *CachingTypes `json:"caching,omitempty"`

	// Specifies the customer managed disk encryption set resource id for the managed image disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`

	// Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual
	// machine image.
	// This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// The managedDisk.
	ManagedDisk *SubResource `json:"managedDisk,omitempty"`

	// The snapshot.
	Snapshot *SubResource `json:"snapshot,omitempty"`

	// Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot
	// be used with OS Disk.
	StorageAccountType *StorageAccountTypes `json:"storageAccountType,omitempty"`
}

// ImageDisk - Describes a image disk.
type ImageDisk struct {
	// The Virtual Hard Disk.
	BlobURI *string `json:"blobUri,omitempty"`

	// Specifies the caching requirements.
	// Possible values are:
	// None
	// ReadOnly
	// ReadWrite
	// Default: None for Standard storage. ReadOnly for Premium storage
	Caching *CachingTypes `json:"caching,omitempty"`

	// Specifies the customer managed disk encryption set resource id for the managed image disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`

	// Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual
	// machine image.
	// This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// The managedDisk.
	ManagedDisk *SubResource `json:"managedDisk,omitempty"`

	// The snapshot.
	Snapshot *SubResource `json:"snapshot,omitempty"`

	// Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot
	// be used with OS Disk.
	StorageAccountType *StorageAccountTypes `json:"storageAccountType,omitempty"`
}

// ImageDiskReference - The source image used for creating the disk.
type ImageDiskReference struct {
	// A relative uri containing a community Azure Compute Gallery image reference.
	CommunityGalleryImageID *string `json:"communityGalleryImageId,omitempty"`

	// A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
	ID *string `json:"id,omitempty"`

	// If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image
	// to use. For OS disks, this field is null.
	Lun *int32 `json:"lun,omitempty"`

	// A relative uri containing a direct shared Azure Compute Gallery image reference.
	SharedGalleryImageID *string `json:"sharedGalleryImageId,omitempty"`
}

// ImageListResult - The List Image operation response.
type ImageListResult struct {
	// REQUIRED; The list of Images.
	Value []*Image `json:"value,omitempty"`

	// The uri to fetch the next page of Images. Call ListNext() with this to fetch the next page of Images.
	NextLink *string `json:"nextLink,omitempty"`
}

// ImageOSDisk - Describes an Operating System disk.
type ImageOSDisk struct {
	// REQUIRED; The OS State. For managed images, use Generalized.
	OSState *OperatingSystemStateTypes `json:"osState,omitempty"`

	// REQUIRED; This property allows you to specify the type of the OS that is included in the disk if creating a VM from a custom
	// image.
	// Possible values are:
	// Windows
	// Linux
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// The Virtual Hard Disk.
	BlobURI *string `json:"blobUri,omitempty"`

	// Specifies the caching requirements.
	// Possible values are:
	// None
	// ReadOnly
	// ReadWrite
	// Default: None for Standard storage. ReadOnly for Premium storage
	Caching *CachingTypes `json:"caching,omitempty"`

	// Specifies the customer managed disk encryption set resource id for the managed image disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`

	// Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual
	// machine image.
	// This value cannot be larger than 1023 GB
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// The managedDisk.
	ManagedDisk *SubResource `json:"managedDisk,omitempty"`

	// The snapshot.
	Snapshot *SubResource `json:"snapshot,omitempty"`

	// Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot
	// be used with OS Disk.
	StorageAccountType *StorageAccountTypes `json:"storageAccountType,omitempty"`
}

// ImageProperties - Describes the properties of an Image.
type ImageProperties struct {
	// Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image
	// source is a blob, then we need the user to specify the value, if the source is
	// managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the
	// source managed resource.
	HyperVGeneration *HyperVGenerationTypes `json:"hyperVGeneration,omitempty"`

	// The source virtual machine from which Image is created.
	SourceVirtualMachine *SubResource `json:"sourceVirtualMachine,omitempty"`

	// Specifies the storage settings for the virtual machine disks.
	StorageProfile *ImageStorageProfile `json:"storageProfile,omitempty"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ImagePurchasePlan - Describes the gallery image definition purchase plan. This is used by marketplace images.
type ImagePurchasePlan struct {
	// The plan ID.
	Name *string `json:"name,omitempty"`

	// The product ID.
	Product *string `json:"product,omitempty"`

	// The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
}

// ImageReference - Specifies information about the image to use. You can specify information about platform images, marketplace
// images, or virtual machine images. This element is required when you want to use a platform
// image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference
// publisher and offer can only be set when you create the scale set.
type ImageReference struct {
	// Specified the community gallery image unique id for vm deployment. This can be fetched from community gallery image GET
	// call.
	CommunityGalleryImageID *string `json:"communityGalleryImageId,omitempty"`

	// Resource Id
	ID *string `json:"id,omitempty"`

	// Specifies the offer of the platform image or marketplace image used to create the virtual machine.
	Offer *string `json:"offer,omitempty"`

	// The image publisher.
	Publisher *string `json:"publisher,omitempty"`

	// The image SKU.
	SKU *string `json:"sku,omitempty"`

	// Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.
	SharedGalleryImageID *string `json:"sharedGalleryImageId,omitempty"`

	// Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats
	// are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers.
	// Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image
	// will not automatically update after deploy time even if a new version becomes
	// available. Please do not use field 'version' for gallery image deployment, gallery image should always use 'id' field for
	// deployment, to use 'latest' version of gallery image, just set
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
	// in the 'id' field without version input.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; Specifies in decimal numbers, the version of platform image or marketplace image used to create the virtual
	// machine. This readonly field differs from 'version', only if the value specified in
	// 'version' field is 'latest'.
	ExactVersion *string `json:"exactVersion,omitempty" azure:"ro"`
}

// ImageStorageProfile - Describes a storage profile.
type ImageStorageProfile struct {
	// Specifies the parameters that are used to add a data disk to a virtual machine.
	// For more information about disks, see About disks and VHDs for Azure virtual machines [https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview].
	DataDisks []*ImageDataDisk `json:"dataDisks,omitempty"`

	// Specifies information about the operating system disk used by the virtual machine.
	// For more information about disks, see About disks and VHDs for Azure virtual machines [https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview].
	OSDisk *ImageOSDisk `json:"osDisk,omitempty"`

	// Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions
	// that provide Zone Redundant Storage (ZRS).
	ZoneResilient *bool `json:"zoneResilient,omitempty"`
}

// ImageUpdate - The source user image virtual hard disk. Only tags may be updated.
type ImageUpdate struct {
	// Describes the properties of an Image.
	Properties *ImageProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ImagesClientBeginCreateOrUpdateOptions contains the optional parameters for the ImagesClient.BeginCreateOrUpdate method.
type ImagesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ImagesClientBeginDeleteOptions contains the optional parameters for the ImagesClient.BeginDelete method.
type ImagesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ImagesClientBeginUpdateOptions contains the optional parameters for the ImagesClient.BeginUpdate method.
type ImagesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ImagesClientGetOptions contains the optional parameters for the ImagesClient.Get method.
type ImagesClientGetOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// ImagesClientListByResourceGroupOptions contains the optional parameters for the ImagesClient.ListByResourceGroup method.
type ImagesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ImagesClientListOptions contains the optional parameters for the ImagesClient.List method.
type ImagesClientListOptions struct {
	// placeholder for future optional parameters
}

// InnerError - Inner error details.
type InnerError struct {
	// The internal error message or exception dump.
	Errordetail *string `json:"errordetail,omitempty"`

	// The exception type.
	Exceptiontype *string `json:"exceptiontype,omitempty"`
}

// InstanceSKU - The role instance SKU.
type InstanceSKU struct {
	// READ-ONLY; The sku name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The tier of the cloud service role instance.
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// InstanceViewStatus - Instance view status.
type InstanceViewStatus struct {
	// The status code.
	Code *string `json:"code,omitempty"`

	// The short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`

	// The level code.
	Level *StatusLevelTypes `json:"level,omitempty"`

	// The detailed status message, including for alerts and error messages.
	Message *string `json:"message,omitempty"`

	// The time of the status.
	Time *time.Time `json:"time,omitempty"`
}

// InstanceViewStatusesSummary - Instance view statuses.
type InstanceViewStatusesSummary struct {
	// READ-ONLY; The summary.
	StatusesSummary []*StatusCodeCount `json:"statusesSummary,omitempty" azure:"ro"`
}

// KeyForDiskEncryptionSet - Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
type KeyForDiskEncryptionSet struct {
	// REQUIRED; Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled
	// value.
	KeyURL *string `json:"keyUrl,omitempty"`

	// Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault
	// subscription is not the same as the Disk Encryption Set subscription.
	SourceVault *SourceVault `json:"sourceVault,omitempty"`
}

// KeyVaultAndKeyReference - Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the
// encryptionKey
type KeyVaultAndKeyReference struct {
	// REQUIRED; Url pointing to a key or secret in KeyVault
	KeyURL *string `json:"keyUrl,omitempty"`

	// REQUIRED; Resource id of the KeyVault containing the key or secret
	SourceVault *SourceVault `json:"sourceVault,omitempty"`
}

// KeyVaultAndSecretReference - Key Vault Secret Url and vault id of the encryption key
type KeyVaultAndSecretReference struct {
	// REQUIRED; Url pointing to a key or secret in KeyVault
	SecretURL *string `json:"secretUrl,omitempty"`

	// REQUIRED; Resource id of the KeyVault containing the key or secret
	SourceVault *SourceVault `json:"sourceVault,omitempty"`
}

// KeyVaultKeyReference - Describes a reference to Key Vault Key
type KeyVaultKeyReference struct {
	// REQUIRED; The URL referencing a key encryption key in Key Vault.
	KeyURL *string `json:"keyUrl,omitempty"`

	// REQUIRED; The relative URL of the Key Vault containing the key.
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// KeyVaultSecretReference - Describes a reference to Key Vault Secret
type KeyVaultSecretReference struct {
	// REQUIRED; The URL referencing a secret in a Key Vault.
	SecretURL *string `json:"secretUrl,omitempty"`

	// REQUIRED; The relative URL of the Key Vault containing the secret.
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// LastPatchInstallationSummary - Describes the properties of the last installed patch summary.
type LastPatchInstallationSummary struct {
	// READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	Error *APIError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The number of all available patches but excluded explicitly by a customer-specified exclusion list match.
	ExcludedPatchCount *int32 `json:"excludedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The count of patches that failed installation.
	FailedPatchCount *int32 `json:"failedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension
	// logs.
	InstallationActivityID *string `json:"installationActivityId,omitempty" azure:"ro"`

	// READ-ONLY; The count of patches that successfully installed.
	InstalledPatchCount *int32 `json:"installedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation began.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the operation ran out of time before it completed all its intended actions
	MaintenanceWindowExceeded *bool `json:"maintenanceWindowExceeded,omitempty" azure:"ro"`

	// READ-ONLY; The number of all available patches but not going to be installed because it didn't match a classification or
	// inclusion list entry.
	NotSelectedPatchCount *int32 `json:"notSelectedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of all available patches expected to be installed over the course of the patch installation operation.
	PendingPatchCount *int32 `json:"pendingPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation began.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes.
	// At that point it will become "Unknown", "Failed", "Succeeded", or
	// "CompletedWithWarnings."
	Status *PatchOperationStatus `json:"status,omitempty" azure:"ro"`
}

// LatestGalleryImageVersion - The gallery image version with latest version in a particular region.
type LatestGalleryImageVersion struct {
	// The name of the latest version in the region.
	LatestVersionName *string `json:"latestVersionName,omitempty"`

	// region of the Gallery Image Version.
	Location *string `json:"location,omitempty"`
}

// LinuxConfiguration - Specifies the Linux operating system settings on the virtual machine.
// For a list of supported Linux distributions, see Linux on Azure-Endorsed Distributions [https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros].
type LinuxConfiguration struct {
	// Specifies whether password authentication should be disabled.
	DisablePasswordAuthentication *bool `json:"disablePasswordAuthentication,omitempty"`

	// Indicates whether VMAgent Platform Updates is enabled for the Linux virtual machine. Default value is false.
	EnableVMAgentPlatformUpdates *bool `json:"enableVMAgentPlatformUpdates,omitempty"`

	// [Preview Feature] Specifies settings related to VM Guest Patching on Linux.
	PatchSettings *LinuxPatchSettings `json:"patchSettings,omitempty"`

	// Indicates whether virtual machine agent should be provisioned on the virtual machine.
	// When this property is not specified in the request body, default behavior is to set it to true. This will ensure that VM
	// Agent is installed on the VM so that extensions can be added to the VM later.
	ProvisionVMAgent *bool `json:"provisionVMAgent,omitempty"`

	// Specifies the ssh key configuration for a Linux OS.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// LinuxParameters - Input for InstallPatches on a Linux VM, as directly received by the API
type LinuxParameters struct {
	// The update classifications to select when installing patches for Linux.
	ClassificationsToInclude []*VMGuestPatchClassificationLinux `json:"classificationsToInclude,omitempty"`

	// This is used as a maintenance run identifier for Auto VM Guest Patching in Linux.
	MaintenanceRunID *string `json:"maintenanceRunId,omitempty"`

	// packages to exclude in the patch operation. Format: packageName_packageVersion
	PackageNameMasksToExclude []*string `json:"packageNameMasksToExclude,omitempty"`

	// packages to include in the patch operation. Format: packageName_packageVersion
	PackageNameMasksToInclude []*string `json:"packageNameMasksToInclude,omitempty"`
}

// LinuxPatchSettings - Specifies settings related to VM Guest Patching on Linux.
type LinuxPatchSettings struct {
	// Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.
	// Possible values are:
	// ImageDefault - You control the timing of patch assessments on a virtual machine.
	// AutomaticByPlatform - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
	AssessmentMode *LinuxPatchAssessmentMode `json:"assessmentMode,omitempty"`

	// Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux.
	AutomaticByPlatformSettings *LinuxVMGuestPatchAutomaticByPlatformSettings `json:"automaticByPlatformSettings,omitempty"`

	// Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale
	// set with OrchestrationMode as Flexible.
	// Possible values are:
	// ImageDefault - The virtual machine's default patching configuration is used.
	// AutomaticByPlatform - The virtual machine will be automatically updated by the platform. The property provisionVMAgent
	// must be true
	PatchMode *LinuxVMGuestPatchMode `json:"patchMode,omitempty"`
}

// LinuxVMGuestPatchAutomaticByPlatformSettings - Specifies additional settings to be applied when patch mode AutomaticByPlatform
// is selected in Linux patch settings.
type LinuxVMGuestPatchAutomaticByPlatformSettings struct {
	// Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
	RebootSetting *LinuxVMGuestPatchAutomaticByPlatformRebootSetting `json:"rebootSetting,omitempty"`
}

// ListUsagesResult - The List Usages operation response.
type ListUsagesResult struct {
	// REQUIRED; The list of compute resource usages.
	Value []*Usage `json:"value,omitempty"`

	// The URI to fetch the next page of compute resource usage information. Call ListNext() with this to fetch the next page
	// of compute resource usage information.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoadBalancerConfiguration - Describes the load balancer configuration.
type LoadBalancerConfiguration struct {
	// REQUIRED; The name of the Load balancer
	Name *string `json:"name,omitempty"`

	// REQUIRED; Properties of the load balancer configuration.
	Properties *LoadBalancerConfigurationProperties `json:"properties,omitempty"`

	// Resource Id
	ID *string `json:"id,omitempty"`
}

// LoadBalancerConfigurationProperties - Describes the properties of the load balancer configuration.
type LoadBalancerConfigurationProperties struct {
	// REQUIRED; Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each
	// load balancer configuration must have exactly one frontend IP configuration.
	FrontendIPConfigurations []*LoadBalancerFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
}

// LoadBalancerFrontendIPConfiguration - Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP
// address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
type LoadBalancerFrontendIPConfiguration struct {
	// REQUIRED; The name of the resource that is unique within the set of frontend IP configurations used by the load balancer.
	// This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Properties of load balancer frontend ip configuration.
	Properties *LoadBalancerFrontendIPConfigurationProperties `json:"properties,omitempty"`
}

// LoadBalancerFrontendIPConfigurationProperties - Describes a cloud service IP Configuration
type LoadBalancerFrontendIPConfigurationProperties struct {
	// The virtual network private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The reference to the public ip address resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`

	// The reference to the virtual network subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
}

// LogAnalyticsClientBeginExportRequestRateByIntervalOptions contains the optional parameters for the LogAnalyticsClient.BeginExportRequestRateByInterval
// method.
type LogAnalyticsClientBeginExportRequestRateByIntervalOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LogAnalyticsClientBeginExportThrottledRequestsOptions contains the optional parameters for the LogAnalyticsClient.BeginExportThrottledRequests
// method.
type LogAnalyticsClientBeginExportThrottledRequestsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LogAnalyticsInputBase - Api input base class for LogAnalytics Api.
type LogAnalyticsInputBase struct {
	// REQUIRED; SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
	BlobContainerSasURI *string `json:"blobContainerSasUri,omitempty"`

	// REQUIRED; From time of the query
	FromTime *time.Time `json:"fromTime,omitempty"`

	// REQUIRED; To time of the query
	ToTime *time.Time `json:"toTime,omitempty"`

	// Group query result by Client Application ID.
	GroupByClientApplicationID *bool `json:"groupByClientApplicationId,omitempty"`

	// Group query result by Operation Name.
	GroupByOperationName *bool `json:"groupByOperationName,omitempty"`

	// Group query result by Resource Name.
	GroupByResourceName *bool `json:"groupByResourceName,omitempty"`

	// Group query result by Throttle Policy applied.
	GroupByThrottlePolicy *bool `json:"groupByThrottlePolicy,omitempty"`

	// Group query result by User Agent.
	GroupByUserAgent *bool `json:"groupByUserAgent,omitempty"`
}

// LogAnalyticsOperationResult - LogAnalytics operation status response
type LogAnalyticsOperationResult struct {
	// READ-ONLY; LogAnalyticsOutput
	Properties *LogAnalyticsOutput `json:"properties,omitempty" azure:"ro"`
}

// LogAnalyticsOutput - LogAnalytics output properties
type LogAnalyticsOutput struct {
	// READ-ONLY; Output file Uri path to blob container.
	Output *string `json:"output,omitempty" azure:"ro"`
}

// MaintenanceRedeployStatus - Maintenance Operation Status.
type MaintenanceRedeployStatus struct {
	// True, if customer is allowed to perform Maintenance.
	IsCustomerInitiatedMaintenanceAllowed *bool `json:"isCustomerInitiatedMaintenanceAllowed,omitempty"`

	// Message returned for the last Maintenance Operation.
	LastOperationMessage *string `json:"lastOperationMessage,omitempty"`

	// The Last Maintenance Operation Result Code.
	LastOperationResultCode *MaintenanceOperationResultCodeTypes `json:"lastOperationResultCode,omitempty"`

	// End Time for the Maintenance Window.
	MaintenanceWindowEndTime *time.Time `json:"maintenanceWindowEndTime,omitempty"`

	// Start Time for the Maintenance Window.
	MaintenanceWindowStartTime *time.Time `json:"maintenanceWindowStartTime,omitempty"`

	// End Time for the Pre Maintenance Window.
	PreMaintenanceWindowEndTime *time.Time `json:"preMaintenanceWindowEndTime,omitempty"`

	// Start Time for the Pre Maintenance Window.
	PreMaintenanceWindowStartTime *time.Time `json:"preMaintenanceWindowStartTime,omitempty"`
}

// ManagedArtifact - The managed artifact.
type ManagedArtifact struct {
	// REQUIRED; The managed artifact id.
	ID *string `json:"id,omitempty"`
}

// ManagedDiskParameters - The parameters of a managed disk.
type ManagedDiskParameters struct {
	// Specifies the customer managed disk encryption set resource id for the managed disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`

	// Resource Id
	ID *string `json:"id,omitempty"`

	// Specifies the security profile for the managed disk.
	SecurityProfile *VMDiskSecurityProfile `json:"securityProfile,omitempty"`

	// Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot
	// be used with OS Disk.
	StorageAccountType *StorageAccountTypes `json:"storageAccountType,omitempty"`
}

// NetworkInterfaceReference - Describes a network interface reference.
type NetworkInterfaceReference struct {
	// Resource Id
	ID *string `json:"id,omitempty"`

	// Describes a network interface reference properties.
	Properties *NetworkInterfaceReferenceProperties `json:"properties,omitempty"`
}

// NetworkInterfaceReferenceProperties - Describes a network interface reference properties.
type NetworkInterfaceReferenceProperties struct {
	// Specify what happens to the network interface when the VM is deleted
	DeleteOption *DeleteOptions `json:"deleteOption,omitempty"`

	// Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`
}

// NetworkProfile - Specifies the network interfaces or the networking configuration of the virtual machine.
type NetworkProfile struct {
	// specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
	NetworkAPIVersion *NetworkAPIVersion `json:"networkApiVersion,omitempty"`

	// Specifies the networking configurations that will be used to create the virtual machine networking resources.
	NetworkInterfaceConfigurations []*VirtualMachineNetworkInterfaceConfiguration `json:"networkInterfaceConfigurations,omitempty"`

	// Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
	NetworkInterfaces []*NetworkInterfaceReference `json:"networkInterfaces,omitempty"`
}

// OSDisk - Specifies information about the operating system disk used by the virtual machine.
// For more information about disks, see About disks and VHDs for Azure virtual machines [https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview].
type OSDisk struct {
	// REQUIRED; Specifies how the virtual machine should be created.
	// Possible values are:
	// Attach \u2013 This value is used when you are using a specialized disk to create the virtual machine.
	// FromImage \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform
	// image, you also use the imageReference element described above. If you are
	// using a marketplace image, you also use the plan element previously described.
	CreateOption *DiskCreateOptionTypes `json:"createOption,omitempty"`

	// Specifies the caching requirements.
	// Possible values are:
	// None
	// ReadOnly
	// ReadWrite
	// Default: None for Standard storage. ReadOnly for Premium storage.
	Caching *CachingTypes `json:"caching,omitempty"`

	// Specifies whether OS Disk should be deleted or detached upon VM deletion.
	// Possible values:
	// Delete If this value is used, the OS disk is deleted when VM is deleted.
	// Detach If this value is used, the os disk is retained after VM is deleted.
	// The default value is set to detach. For an ephemeral OS Disk, the default value is set to Delete. User cannot change the
	// delete option for ephemeral OS Disk.
	DeleteOption *DiskDeleteOptionTypes `json:"deleteOption,omitempty"`

	// Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.
	DiffDiskSettings *DiffDiskSettings `json:"diffDiskSettings,omitempty"`

	// Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a
	// virtual machine image.
	// diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Specifies the encryption settings for the OS Disk.
	// Minimum api-version: 2015-06-15
	EncryptionSettings *DiskEncryptionSettings `json:"encryptionSettings,omitempty"`

	// The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine.
	// If SourceImage is provided, the destination virtual hard drive must not
	// exist.
	Image *VirtualHardDisk `json:"image,omitempty"`

	// The managed disk parameters.
	ManagedDisk *ManagedDiskParameters `json:"managedDisk,omitempty"`

	// The disk name.
	Name *string `json:"name,omitempty"`

	// This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or
	// a specialized VHD.
	// Possible values are:
	// Windows
	// Linux
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// The virtual hard disk.
	Vhd *VirtualHardDisk `json:"vhd,omitempty"`

	// Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
}

// OSDiskImage - Contains the os disk image information.
type OSDiskImage struct {
	// REQUIRED; The operating system of the osDiskImage.
	OperatingSystem *OperatingSystemTypes `json:"operatingSystem,omitempty"`
}

// OSDiskImageEncryption - Contains encryption settings for an OS disk image.
type OSDiskImageEncryption struct {
	// A relative URI containing the resource ID of the disk encryption set.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// This property specifies the security profile of an OS disk image.
	SecurityProfile *OSDiskImageSecurityProfile `json:"securityProfile,omitempty"`
}

// OSDiskImageSecurityProfile - Contains security profile for an OS disk image.
type OSDiskImageSecurityProfile struct {
	// confidential VM encryption types
	ConfidentialVMEncryptionType *ConfidentialVMEncryptionType `json:"confidentialVMEncryptionType,omitempty"`

	// secure VM disk encryption set id
	SecureVMDiskEncryptionSetID *string `json:"secureVMDiskEncryptionSetId,omitempty"`
}

// OSFamily - Describes a cloud service OS family.
type OSFamily struct {
	// OS family properties.
	Properties *OSFamilyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OSFamilyListResult - The list operation result.
type OSFamilyListResult struct {
	// REQUIRED; The list of resources.
	Value []*OSFamily `json:"value,omitempty"`

	// The URI to fetch the next page of resources. Use this to get the next page of resources. Do this till nextLink is null
	// to fetch all the resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// OSFamilyProperties - OS family properties.
type OSFamilyProperties struct {
	// READ-ONLY; The OS family label.
	Label *string `json:"label,omitempty" azure:"ro"`

	// READ-ONLY; The OS family name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; List of OS versions belonging to this family.
	Versions []*OSVersionPropertiesBase `json:"versions,omitempty" azure:"ro"`
}

// OSProfile - Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once
// VM is provisioned.
type OSProfile struct {
	// Specifies the password of the administrator account.
	// Minimum-length (Windows): 8 characters
	// Minimum-length (Linux): 6 characters
	// Max-length (Windows): 123 characters
	// Max-length (Linux): 72 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
	// "Password22", "iloveyou!"
	// For resetting the password, see How to reset the Remote Desktop service or its login password in a Windows VM [https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp]
	// For resetting root password, see Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension
	// [https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection]
	AdminPassword *string `json:"adminPassword,omitempty"`

	// Specifies the name of the administrator account.
	// This property cannot be updated after the VM is created.
	// Windows-only restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length (Linux): 1 character
	// Max-length (Linux): 64 characters
	// Max-length (Windows): 20 characters.
	AdminUsername *string `json:"adminUsername,omitempty"`

	// Specifies whether extension operations should be allowed on the virtual machine.
	// This may only be set to False when no extensions are present on the virtual machine.
	AllowExtensionOperations *bool `json:"allowExtensionOperations,omitempty"`

	// Specifies the host OS name of the virtual machine.
	// This name cannot be updated after the VM is created.
	// Max-length (Windows): 15 characters
	// Max-length (Linux): 64 characters.
	// For naming conventions and restrictions see Azure infrastructure services implementation guidelines [https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules].
	ComputerName *string `json:"computerName,omitempty"`

	// Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved
	// as a file on the Virtual Machine. The maximum length of the binary array is
	// 65535 bytes.
	// Note: Do not pass any secrets or passwords in customData property
	// This property cannot be updated after the VM is created.
	// customData is passed to the VM to be saved as a file, for more information see Custom Data on Azure VMs [https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/]
	// For using cloud-init for your Linux VM, see Using cloud-init to customize a Linux VM during creation [https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init]
	CustomData *string `json:"customData,omitempty"`

	// Specifies the Linux operating system settings on the virtual machine.
	// For a list of supported Linux distributions, see Linux on Azure-Endorsed Distributions [https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros].
	LinuxConfiguration *LinuxConfiguration `json:"linuxConfiguration,omitempty"`

	// Optional property which must either be set to True or omitted.
	RequireGuestProvisionSignal *bool `json:"requireGuestProvisionSignal,omitempty"`

	// Specifies set of certificates that should be installed onto the virtual machine. To install certificates on a virtual machine
	// it is recommended to use the Azure Key Vault virtual machine extension for
	// Linux [https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux] or the Azure Key Vault virtual machine
	// extension for Windows
	// [https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows].
	Secrets []*VaultSecretGroup `json:"secrets,omitempty"`

	// Specifies Windows operating system settings on the virtual machine.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
}

// OSVersion - Describes a cloud service OS version.
type OSVersion struct {
	// OS version properties.
	Properties *OSVersionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OSVersionListResult - The list operation result.
type OSVersionListResult struct {
	// REQUIRED; The list of resources.
	Value []*OSVersion `json:"value,omitempty"`

	// The URI to fetch the next page of resources. Use this to get the next page of resources. Do this till nextLink is null
	// to fetch all the resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// OSVersionProperties - OS version properties.
type OSVersionProperties struct {
	// READ-ONLY; The family of this OS version.
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; The family label of this OS version.
	FamilyLabel *string `json:"familyLabel,omitempty" azure:"ro"`

	// READ-ONLY; Specifies whether this OS version is active.
	IsActive *bool `json:"isActive,omitempty" azure:"ro"`

	// READ-ONLY; Specifies whether this is the default OS version for its family.
	IsDefault *bool `json:"isDefault,omitempty" azure:"ro"`

	// READ-ONLY; The OS version label.
	Label *string `json:"label,omitempty" azure:"ro"`

	// READ-ONLY; The OS version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// OSVersionPropertiesBase - Configuration view of an OS version.
type OSVersionPropertiesBase struct {
	// READ-ONLY; Specifies whether this OS version is active.
	IsActive *bool `json:"isActive,omitempty" azure:"ro"`

	// READ-ONLY; Specifies whether this is the default OS version for its family.
	IsDefault *bool `json:"isDefault,omitempty" azure:"ro"`

	// READ-ONLY; The OS version label.
	Label *string `json:"label,omitempty" azure:"ro"`

	// READ-ONLY; The OS version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// OperationListResult - The List Compute Operation operation response.
type OperationListResult struct {
	// READ-ONLY; The list of compute operations
	Value []*OperationValue `json:"value,omitempty" azure:"ro"`
}

// OperationValue - Describes the properties of a Compute Operation value.
type OperationValue struct {
	// Describes the properties of a Compute Operation Value Display.
	Display *OperationValueDisplay `json:"display,omitempty"`

	// READ-ONLY; The name of the compute operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the compute operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationValueDisplay - Describes the properties of a Compute Operation Value Display.
type OperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OrchestrationServiceStateInput - The input for OrchestrationServiceState
type OrchestrationServiceStateInput struct {
	// REQUIRED; The action to be performed.
	Action *OrchestrationServiceStateAction `json:"action,omitempty"`

	// REQUIRED; The name of the service.
	ServiceName *OrchestrationServiceNames `json:"serviceName,omitempty"`
}

// OrchestrationServiceSummary - Summary for an orchestration service of a virtual machine scale set.
type OrchestrationServiceSummary struct {
	// READ-ONLY; The name of the service.
	ServiceName *OrchestrationServiceNames `json:"serviceName,omitempty" azure:"ro"`

	// READ-ONLY; The current state of the service.
	ServiceState *OrchestrationServiceState `json:"serviceState,omitempty" azure:"ro"`
}

// PatchInstallationDetail - Information about a specific patch that was encountered during an installation action.
type PatchInstallationDetail struct {
	// READ-ONLY; The classification(s) of the patch as provided by the patch publisher.
	Classifications []*string `json:"classifications,omitempty" azure:"ro"`

	// READ-ONLY; The state of the patch after the installation operation completed.
	InstallationState *PatchInstallationState `json:"installationState,omitempty" azure:"ro"`

	// READ-ONLY; The KBID of the patch. Only applies to Windows patches.
	KbID *string `json:"kbId,omitempty" azure:"ro"`

	// READ-ONLY; The friendly name of the patch.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; A unique identifier for the patch.
	PatchID *string `json:"patchId,omitempty" azure:"ro"`

	// READ-ONLY; The version string of the package. It may conform to Semantic Versioning. Only applies to Linux.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// PatchSettings - Specifies settings related to VM Guest Patching on Windows.
type PatchSettings struct {
	// Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.
	// Possible values are:
	// ImageDefault - You control the timing of patch assessments on a virtual machine.
	// AutomaticByPlatform - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
	AssessmentMode *WindowsPatchAssessmentMode `json:"assessmentMode,omitempty"`

	// Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Windows.
	AutomaticByPlatformSettings *WindowsVMGuestPatchAutomaticByPlatformSettings `json:"automaticByPlatformSettings,omitempty"`

	// Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must
	// be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.
	EnableHotpatching *bool `json:"enableHotpatching,omitempty"`

	// Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale
	// set with OrchestrationMode as Flexible.
	// Possible values are:
	// Manual - You control the application of patches to a virtual machine. You do this by applying patches manually inside the
	// VM. In this mode, automatic updates are disabled; the property
	// WindowsConfiguration.enableAutomaticUpdates must be false
	// AutomaticByOS - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates
	// must be true.
	// AutomaticByPlatform - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and
	// WindowsConfiguration.enableAutomaticUpdates must be true
	PatchMode *WindowsVMGuestPatchMode `json:"patchMode,omitempty"`
}

// PirCommunityGalleryResource - Base information about the community gallery resource in pir.
type PirCommunityGalleryResource struct {
	// The identifier information of community gallery.
	Identifier *CommunityGalleryIdentifier `json:"identifier,omitempty"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PirResource - The Resource model definition.
type PirResource struct {
	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`
}

// PirSharedGalleryResource - Base information about the shared gallery resource in pir.
type PirSharedGalleryResource struct {
	// The identifier information of shared gallery.
	Identifier *SharedGalleryIdentifier `json:"identifier,omitempty"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`
}

// Plan - Specifies information about the marketplace image used to create the virtual machine. This element is only used
// for marketplace images. Before you can use a marketplace image from an API, you must
// enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click
// Want to deploy programmatically, Get Started ->. Enter any required
// information and then click Save.
type Plan struct {
	// The plan ID.
	Name *string `json:"name,omitempty"`

	// Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
	Product *string `json:"product,omitempty"`

	// The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
}

// PolicyViolation - A policy violation reported against a gallery artifact.
type PolicyViolation struct {
	// Describes the nature of the policy violation.
	Category *PolicyViolationCategory `json:"category,omitempty"`

	// Describes specific details about why this policy violation was reported.
	Details *string `json:"details,omitempty"`
}

// PriorityMixPolicy - Specifies the target splits for Spot and Regular priority VMs within a scale set with flexible orchestration
// mode.
// With this property the customer is able to specify the base number of regular priority VMs created as the VMSS flex instance
// scales out and the split between Spot and Regular priority VMs after this
// base target has been reached.
type PriorityMixPolicy struct {
	// The base number of regular priority VMs that will be created in this scale set as it scales out.
	BaseRegularPriorityCount *int32 `json:"baseRegularPriorityCount,omitempty"`

	// The percentage of VM instances, after the base regular priority count has been reached, that are expected to use regular
	// priority.
	RegularPriorityPercentageAboveBase *int32 `json:"regularPriorityPercentageAboveBase,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; private endpoint connection Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; private endpoint connection name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; private endpoint connection type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private link resources
type PrivateEndpointConnectionListResult struct {
	// The uri to fetch the next page of snapshots. Call ListNext() with this to fetch the next page of snapshots.
	NextLink *string `json:"nextLink,omitempty"`

	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between DiskAccess and Virtual Network.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; private link resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; private link resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; private link resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// PropertyUpdatesInProgress - Properties of the disk for which update is pending.
type PropertyUpdatesInProgress struct {
	// The target performance tier of the disk if a tier change operation is in progress.
	TargetTier *string `json:"targetTier,omitempty"`
}

// ProximityPlacementGroup - Specifies information about the proximity placement group.
type ProximityPlacementGroup struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a Proximity Placement Group.
	Properties *ProximityPlacementGroupProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// Specifies the Availability Zone where virtual machine, virtual machine scale set or availability set associated with the
	// proximity placement group can be created.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProximityPlacementGroupListResult - The List Proximity Placement Group operation response.
type ProximityPlacementGroupListResult struct {
	// REQUIRED; The list of proximity placement groups
	Value []*ProximityPlacementGroup `json:"value,omitempty"`

	// The URI to fetch the next page of proximity placement groups.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProximityPlacementGroupProperties - Describes the properties of a Proximity Placement Group.
type ProximityPlacementGroupProperties struct {
	// Describes colocation status of the Proximity Placement Group.
	ColocationStatus *InstanceViewStatus `json:"colocationStatus,omitempty"`

	// Specifies the user intent of the proximity placement group.
	Intent *ProximityPlacementGroupPropertiesIntent `json:"intent,omitempty"`

	// Specifies the type of the proximity placement group.
	// Possible values are:
	// Standard : Co-locate resources within an Azure region or Availability Zone.
	// Ultra : For future use.
	ProximityPlacementGroupType *ProximityPlacementGroupType `json:"proximityPlacementGroupType,omitempty"`

	// READ-ONLY; A list of references to all availability sets in the proximity placement group.
	AvailabilitySets []*SubResourceWithColocationStatus `json:"availabilitySets,omitempty" azure:"ro"`

	// READ-ONLY; A list of references to all virtual machine scale sets in the proximity placement group.
	VirtualMachineScaleSets []*SubResourceWithColocationStatus `json:"virtualMachineScaleSets,omitempty" azure:"ro"`

	// READ-ONLY; A list of references to all virtual machines in the proximity placement group.
	VirtualMachines []*SubResourceWithColocationStatus `json:"virtualMachines,omitempty" azure:"ro"`
}

// ProximityPlacementGroupPropertiesIntent - Specifies the user intent of the proximity placement group.
type ProximityPlacementGroupPropertiesIntent struct {
	// Specifies possible sizes of virtual machines that can be created in the proximity placement group.
	VMSizes []*string `json:"vmSizes,omitempty"`
}

// ProximityPlacementGroupUpdate - Specifies information about the proximity placement group.
type ProximityPlacementGroupUpdate struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ProximityPlacementGroupsClientCreateOrUpdateOptions contains the optional parameters for the ProximityPlacementGroupsClient.CreateOrUpdate
// method.
type ProximityPlacementGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProximityPlacementGroupsClientDeleteOptions contains the optional parameters for the ProximityPlacementGroupsClient.Delete
// method.
type ProximityPlacementGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProximityPlacementGroupsClientGetOptions contains the optional parameters for the ProximityPlacementGroupsClient.Get method.
type ProximityPlacementGroupsClientGetOptions struct {
	// includeColocationStatus=true enables fetching the colocation status of all the resources in the proximity placement group.
	IncludeColocationStatus *string
}

// ProximityPlacementGroupsClientListByResourceGroupOptions contains the optional parameters for the ProximityPlacementGroupsClient.ListByResourceGroup
// method.
type ProximityPlacementGroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ProximityPlacementGroupsClientListBySubscriptionOptions contains the optional parameters for the ProximityPlacementGroupsClient.ListBySubscription
// method.
type ProximityPlacementGroupsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ProximityPlacementGroupsClientUpdateOptions contains the optional parameters for the ProximityPlacementGroupsClient.Update
// method.
type ProximityPlacementGroupsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProxyOnlyResource - The ProxyOnly Resource model definition.
type ProxyOnlyResource struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for an Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PublicIPAddressSKU - Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
type PublicIPAddressSKU struct {
	// Specify public IP sku name
	Name *PublicIPAddressSKUName `json:"name,omitempty"`

	// Specify public IP sku tier
	Tier *PublicIPAddressSKUTier `json:"tier,omitempty"`
}

// PurchasePlan - Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
type PurchasePlan struct {
	// REQUIRED; The plan ID.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference
	// element.
	Product *string `json:"product,omitempty"`

	// REQUIRED; The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
}

// RecommendedMachineConfiguration - The properties describe the recommended machine configuration for this Image Definition.
// These properties are updatable.
type RecommendedMachineConfiguration struct {
	// Describes the resource range.
	Memory *ResourceRange `json:"memory,omitempty"`

	// Describes the resource range.
	VCPUs *ResourceRange `json:"vCPUs,omitempty"`
}

// RecoveryWalkResponse - Response after calling a manual recovery walk
type RecoveryWalkResponse struct {
	// READ-ONLY; The next update domain that needs to be walked. Null means walk spanning all update domains has been completed
	NextPlatformUpdateDomain *int32 `json:"nextPlatformUpdateDomain,omitempty" azure:"ro"`

	// READ-ONLY; Whether the recovery walk was performed
	WalkPerformed *bool `json:"walkPerformed,omitempty" azure:"ro"`
}

// RegionalReplicationStatus - This is the regional replication status.
type RegionalReplicationStatus struct {
	// READ-ONLY; The details of the replication status.
	Details *string `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; It indicates progress of the replication job.
	Progress *int32 `json:"progress,omitempty" azure:"ro"`

	// READ-ONLY; The region to which the gallery image version is being replicated to.
	Region *string `json:"region,omitempty" azure:"ro"`

	// READ-ONLY; This is the regional replication state.
	State *ReplicationState `json:"state,omitempty" azure:"ro"`
}

// RegionalSharingStatus - Gallery regional sharing status
type RegionalSharingStatus struct {
	// Details of gallery regional sharing failure.
	Details *string `json:"details,omitempty"`

	// Region name
	Region *string `json:"region,omitempty"`

	// READ-ONLY; Gallery sharing state in current region
	State *SharingState `json:"state,omitempty" azure:"ro"`
}

// ReplicationStatus - This is the replication status of the gallery image version.
type ReplicationStatus struct {
	// READ-ONLY; This is the aggregated replication status based on all the regional replication status flags.
	AggregatedState *AggregatedReplicationState `json:"aggregatedState,omitempty" azure:"ro"`

	// READ-ONLY; This is a summary of replication status for each region.
	Summary []*RegionalReplicationStatus `json:"summary,omitempty" azure:"ro"`
}

// RequestRateByIntervalInput - Api request input for LogAnalytics getRequestRateByInterval Api.
type RequestRateByIntervalInput struct {
	// REQUIRED; SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
	BlobContainerSasURI *string `json:"blobContainerSasUri,omitempty"`

	// REQUIRED; From time of the query
	FromTime *time.Time `json:"fromTime,omitempty"`

	// REQUIRED; Interval value in minutes used to create LogAnalytics call rate logs.
	IntervalLength *IntervalInMins `json:"intervalLength,omitempty"`

	// REQUIRED; To time of the query
	ToTime *time.Time `json:"toTime,omitempty"`

	// Group query result by Client Application ID.
	GroupByClientApplicationID *bool `json:"groupByClientApplicationId,omitempty"`

	// Group query result by Operation Name.
	GroupByOperationName *bool `json:"groupByOperationName,omitempty"`

	// Group query result by Resource Name.
	GroupByResourceName *bool `json:"groupByResourceName,omitempty"`

	// Group query result by Throttle Policy applied.
	GroupByThrottlePolicy *bool `json:"groupByThrottlePolicy,omitempty"`

	// Group query result by User Agent.
	GroupByUserAgent *bool `json:"groupByUserAgent,omitempty"`
}

// Resource - The Resource model definition.
type Resource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceInstanceViewStatus - Instance view status.
type ResourceInstanceViewStatus struct {
	// The level code.
	Level *StatusLevelTypes `json:"level,omitempty"`

	// READ-ONLY; The status code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty" azure:"ro"`

	// READ-ONLY; The detailed status message, including for alerts and error messages.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The time of the status.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// ResourceRange - Describes the resource range.
type ResourceRange struct {
	// The maximum number of the resource.
	Max *int32 `json:"max,omitempty"`

	// The minimum number of the resource.
	Min *int32 `json:"min,omitempty"`
}

// ResourceSKU - Describes an available Compute SKU.
type ResourceSKU struct {
	// READ-ONLY; The api versions that support this SKU.
	APIVersions []*string `json:"apiVersions,omitempty" azure:"ro"`

	// READ-ONLY; A name value pair to describe the capability.
	Capabilities []*ResourceSKUCapabilities `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the number of virtual machines in the scale set.
	Capacity *ResourceSKUCapacity `json:"capacity,omitempty" azure:"ro"`

	// READ-ONLY; Metadata for retrieving price info.
	Costs []*ResourceSKUCosts `json:"costs,omitempty" azure:"ro"`

	// READ-ONLY; The Family of this particular SKU.
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; A list of locations and availability zones in those locations where the SKU is available.
	LocationInfo []*ResourceSKULocationInfo `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available.
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The name of SKU.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*ResourceSKURestrictions `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY; The Size of the SKU.
	Size *string `json:"size,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the tier of virtual machines in a scale set.
	// Possible Values:
	// Standard
	// Basic
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// ResourceSKUCapabilities - Describes The SKU capabilities object.
type ResourceSKUCapabilities struct {
	// READ-ONLY; An invariant to describe the feature.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// ResourceSKUCapacity - Describes scaling information of a SKU.
type ResourceSKUCapacity struct {
	// READ-ONLY; The default capacity.
	Default *int64 `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; The maximum capacity that can be set.
	Maximum *int64 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The minimum capacity.
	Minimum *int64 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The scale type applicable to the sku.
	ScaleType *ResourceSKUCapacityScaleType `json:"scaleType,omitempty" azure:"ro"`
}

// ResourceSKUCosts - Describes metadata for retrieving price info.
type ResourceSKUCosts struct {
	// READ-ONLY; An invariant to show the extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty" azure:"ro"`

	// READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterID,omitempty" azure:"ro"`

	// READ-ONLY; The multiplier is needed to extend the base metered cost.
	Quantity *int64 `json:"quantity,omitempty" azure:"ro"`
}

// ResourceSKULocationInfo - Describes an available Compute SKU Location Information.
type ResourceSKULocationInfo struct {
	// READ-ONLY; The names of extended locations.
	ExtendedLocations []*string `json:"extendedLocations,omitempty" azure:"ro"`

	// READ-ONLY; Location of the SKU
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The type of the extended location.
	Type *ExtendedLocationType `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Details of capabilities available to a SKU in specific zones.
	ZoneDetails []*ResourceSKUZoneDetails `json:"zoneDetails,omitempty" azure:"ro"`

	// READ-ONLY; List of availability zones where the SKU is supported.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// ResourceSKURestrictionInfo - Describes an available Compute SKU Restriction Information.
type ResourceSKURestrictionInfo struct {
	// READ-ONLY; Locations where the SKU is restricted
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; List of availability zones where the SKU is restricted.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// ResourceSKURestrictions - Describes scaling information of a SKU.
type ResourceSKURestrictions struct {
	// READ-ONLY; The reason for restriction.
	ReasonCode *ResourceSKURestrictionsReasonCode `json:"reasonCode,omitempty" azure:"ro"`

	// READ-ONLY; The information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSKURestrictionInfo `json:"restrictionInfo,omitempty" azure:"ro"`

	// READ-ONLY; The type of restrictions.
	Type *ResourceSKURestrictionsType `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// ResourceSKUZoneDetails - Describes The zonal capabilities of a SKU.
type ResourceSKUZoneDetails struct {
	// READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities []*ResourceSKUCapabilities `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name []*string `json:"name,omitempty" azure:"ro"`
}

// ResourceSKUsClientListOptions contains the optional parameters for the ResourceSKUsClient.List method.
type ResourceSKUsClientListOptions struct {
	// The filter to apply on the operation. Only location filter is supported currently.
	Filter *string
	// To Include Extended Locations information or not in the response.
	IncludeExtendedLocations *string
}

// ResourceSKUsResult - The List Resource Skus operation response.
type ResourceSKUsResult struct {
	// REQUIRED; The list of skus available for the subscription.
	Value []*ResourceSKU `json:"value,omitempty"`

	// The URI to fetch the next page of Resource Skus. Call ListNext() with this URI to fetch the next page of Resource Skus
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceURIList - The List resources which are encrypted with the disk encryption set.
type ResourceURIList struct {
	// REQUIRED; A list of IDs or Owner IDs of resources which are encrypted with the disk encryption set.
	Value []*string `json:"value,omitempty"`

	// The uri to fetch the next page of encrypted resources. Call ListNext() with this to fetch the next page of encrypted resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceWithOptionalLocation - The Resource model definition with location property as optional.
type ResourceWithOptionalLocation struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorePoint - Restore Point details.
type RestorePoint struct {
	// The restore point properties.
	Properties *RestorePointProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorePointCollection - Create or update Restore Point collection parameters.
type RestorePointCollection struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The restore point collection properties.
	Properties *RestorePointCollectionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorePointCollectionListResult - The List restore point collection operation response.
type RestorePointCollectionListResult struct {
	// The uri to fetch the next page of RestorePointCollections. Call ListNext() with this to fetch the next page of RestorePointCollections
	NextLink *string `json:"nextLink,omitempty"`

	// Gets the list of restore point collections.
	Value []*RestorePointCollection `json:"value,omitempty"`
}

// RestorePointCollectionProperties - The restore point collection properties.
type RestorePointCollectionProperties struct {
	// The properties of the source resource that this restore point collection is created from.
	Source *RestorePointCollectionSourceProperties `json:"source,omitempty"`

	// READ-ONLY; The provisioning state of the restore point collection.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique id of the restore point collection.
	RestorePointCollectionID *string `json:"restorePointCollectionId,omitempty" azure:"ro"`

	// READ-ONLY; A list containing all restore points created under this restore point collection.
	RestorePoints []*RestorePoint `json:"restorePoints,omitempty" azure:"ro"`
}

// RestorePointCollectionSourceProperties - The properties of the source resource that this restore point collection is created
// from.
type RestorePointCollectionSourceProperties struct {
	// Resource Id of the source resource used to create this restore point collection
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Location of the source resource used to create this restore point collection.
	Location *string `json:"location,omitempty" azure:"ro"`
}

// RestorePointCollectionUpdate - Update Restore Point collection parameters.
type RestorePointCollectionUpdate struct {
	// The restore point collection properties.
	Properties *RestorePointCollectionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// RestorePointCollectionsClientBeginDeleteOptions contains the optional parameters for the RestorePointCollectionsClient.BeginDelete
// method.
type RestorePointCollectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RestorePointCollectionsClientCreateOrUpdateOptions contains the optional parameters for the RestorePointCollectionsClient.CreateOrUpdate
// method.
type RestorePointCollectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// RestorePointCollectionsClientGetOptions contains the optional parameters for the RestorePointCollectionsClient.Get method.
type RestorePointCollectionsClientGetOptions struct {
	// The expand expression to apply on the operation. If expand=restorePoints, server will return all contained restore points
	// in the restorePointCollection.
	Expand *RestorePointCollectionExpandOptions
}

// RestorePointCollectionsClientListAllOptions contains the optional parameters for the RestorePointCollectionsClient.ListAll
// method.
type RestorePointCollectionsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// RestorePointCollectionsClientListOptions contains the optional parameters for the RestorePointCollectionsClient.List method.
type RestorePointCollectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// RestorePointCollectionsClientUpdateOptions contains the optional parameters for the RestorePointCollectionsClient.Update
// method.
type RestorePointCollectionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// RestorePointInstanceView - The instance view of a restore point.
type RestorePointInstanceView struct {
	// The disk restore points information.
	DiskRestorePoints []*DiskRestorePointInstanceView `json:"diskRestorePoints,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`
}

// RestorePointProperties - The restore point properties.
type RestorePointProperties struct {
	// ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent
	// is accepted as a valid input. Please refer to
	// https://aka.ms/RestorePoints for more details.
	ConsistencyMode *ConsistencyModeTypes `json:"consistencyMode,omitempty"`

	// List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks
	// will be included.
	ExcludeDisks []*APIEntityReference `json:"excludeDisks,omitempty"`

	// Resource Id of the source restore point from which a copy needs to be created.
	SourceRestorePoint *APIEntityReference `json:"sourceRestorePoint,omitempty"`

	// Gets the creation time of the restore point.
	TimeCreated *time.Time `json:"timeCreated,omitempty"`

	// READ-ONLY; The restore point instance view.
	InstanceView *RestorePointInstanceView `json:"instanceView,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state of the restore point.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the details of the VM captured at the time of the restore point creation.
	SourceMetadata *RestorePointSourceMetadata `json:"sourceMetadata,omitempty" azure:"ro"`
}

// RestorePointSourceMetadata - Describes the properties of the Virtual Machine for which the restore point was created. The
// properties provided are a subset and the snapshot of the overall Virtual Machine properties captured at the
// time of the restore point creation.
type RestorePointSourceMetadata struct {
	// Gets the diagnostics profile.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`

	// Gets the hardware profile.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`

	// Gets the license type, which is for bring your own license scenario.
	LicenseType *string `json:"licenseType,omitempty"`

	// Location of the VM from which the restore point was created.
	Location *string `json:"location,omitempty"`

	// Gets the OS profile.
	OSProfile *OSProfile `json:"osProfile,omitempty"`

	// Gets the security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// Gets the storage profile.
	StorageProfile *RestorePointSourceVMStorageProfile `json:"storageProfile,omitempty"`

	// Gets the virtual machine unique id.
	VMID *string `json:"vmId,omitempty"`
}

// RestorePointSourceVMDataDisk - Describes a data disk.
type RestorePointSourceVMDataDisk struct {
	// Gets the caching type.
	Caching *CachingTypes `json:"caching,omitempty"`

	// Gets the disk restore point Id.
	DiskRestorePoint *APIEntityReference `json:"diskRestorePoint,omitempty"`

	// Gets the initial disk size in GB for blank data disks, and the new desired size for existing OS and Data disks.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Gets the logical unit number.
	Lun *int32 `json:"lun,omitempty"`

	// Gets the managed disk details
	ManagedDisk *ManagedDiskParameters `json:"managedDisk,omitempty"`

	// Gets the disk name.
	Name *string `json:"name,omitempty"`
}

// RestorePointSourceVMOSDisk - Describes an Operating System disk.
type RestorePointSourceVMOSDisk struct {
	// Gets the caching type.
	Caching *CachingTypes `json:"caching,omitempty"`

	// Gets the disk restore point Id.
	DiskRestorePoint *APIEntityReference `json:"diskRestorePoint,omitempty"`

	// Gets the disk size in GB.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Gets the disk encryption settings.
	EncryptionSettings *DiskEncryptionSettings `json:"encryptionSettings,omitempty"`

	// Gets the managed disk details
	ManagedDisk *ManagedDiskParameters `json:"managedDisk,omitempty"`

	// Gets the disk name.
	Name *string `json:"name,omitempty"`

	// Gets the Operating System type.
	OSType *OperatingSystemType `json:"osType,omitempty"`
}

// RestorePointSourceVMStorageProfile - Describes the storage profile.
type RestorePointSourceVMStorageProfile struct {
	// Gets the data disks of the VM captured at the time of the restore point creation.
	DataDisks []*RestorePointSourceVMDataDisk `json:"dataDisks,omitempty"`

	// Gets the OS disk of the VM captured at the time of the restore point creation.
	OSDisk *RestorePointSourceVMOSDisk `json:"osDisk,omitempty"`
}

// RestorePointsClientBeginCreateOptions contains the optional parameters for the RestorePointsClient.BeginCreate method.
type RestorePointsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RestorePointsClientBeginDeleteOptions contains the optional parameters for the RestorePointsClient.BeginDelete method.
type RestorePointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RestorePointsClientGetOptions contains the optional parameters for the RestorePointsClient.Get method.
type RestorePointsClientGetOptions struct {
	// The expand expression to apply on the operation. 'InstanceView' retrieves information about the run-time state of a restore
	// point.
	Expand *RestorePointExpandOptions
}

// RetrieveBootDiagnosticsDataResult - The SAS URIs of the console screenshot and serial log blobs.
type RetrieveBootDiagnosticsDataResult struct {
	// READ-ONLY; The console screenshot blob URI
	ConsoleScreenshotBlobURI *string `json:"consoleScreenshotBlobUri,omitempty" azure:"ro"`

	// READ-ONLY; The serial console log blob URI.
	SerialConsoleLogBlobURI *string `json:"serialConsoleLogBlobUri,omitempty" azure:"ro"`
}

// RoleInstance - Describes the cloud service role instance.
type RoleInstance struct {
	// Role instance properties.
	Properties *RoleInstanceProperties `json:"properties,omitempty"`

	// The role instance SKU.
	SKU *InstanceSKU `json:"sku,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleInstanceListResult - The list operation result.
type RoleInstanceListResult struct {
	// REQUIRED; The list of resources.
	Value []*RoleInstance `json:"value,omitempty"`

	// The URI to fetch the next page of resources. Use this to get the next page of resources. Do this till nextLink is null
	// to fetch all the resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleInstanceNetworkProfile - Describes the network profile for the role instance.
type RoleInstanceNetworkProfile struct {
	// READ-ONLY; Specifies the list of resource Ids for the network interfaces associated with the role instance.
	NetworkInterfaces []*SubResource `json:"networkInterfaces,omitempty" azure:"ro"`
}

// RoleInstanceProperties - Role instance properties.
type RoleInstanceProperties struct {
	// The instance view of the role instance.
	InstanceView *RoleInstanceView `json:"instanceView,omitempty"`

	// Describes the network profile for the role instance.
	NetworkProfile *RoleInstanceNetworkProfile `json:"networkProfile,omitempty"`
}

// RoleInstanceView - The instance view of the role instance.
type RoleInstanceView struct {
	// READ-ONLY; The Fault Domain.
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty" azure:"ro"`

	// READ-ONLY; The Update Domain.
	PlatformUpdateDomain *int32 `json:"platformUpdateDomain,omitempty" azure:"ro"`

	// READ-ONLY; Specifies a unique identifier generated internally for the cloud service associated with this role instance.
	// NOTE: If you are using Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details.
	PrivateID *string `json:"privateId,omitempty" azure:"ro"`

	// READ-ONLY
	Statuses []*ResourceInstanceViewStatus `json:"statuses,omitempty" azure:"ro"`
}

// RoleInstances - Specifies a list of role instances from the cloud service.
type RoleInstances struct {
	// REQUIRED; List of cloud service role instance names. Value of '*' will signify all role instances of the cloud service.
	RoleInstances []*string `json:"roleInstances,omitempty"`
}

// RollbackStatusInfo - Information about rollback on failed VM instances after a OS Upgrade operation.
type RollbackStatusInfo struct {
	// READ-ONLY; The number of instances which failed to rollback.
	FailedRolledbackInstanceCount *int32 `json:"failedRolledbackInstanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Error details if OS rollback failed.
	RollbackError *APIError `json:"rollbackError,omitempty" azure:"ro"`

	// READ-ONLY; The number of instances which have been successfully rolled back.
	SuccessfullyRolledbackInstanceCount *int32 `json:"successfullyRolledbackInstanceCount,omitempty" azure:"ro"`
}

// RollingUpgradePolicy - The configuration parameters used while performing a rolling upgrade.
type RollingUpgradePolicy struct {
	// Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent
	// to determine the batch size.
	EnableCrossZoneUpgrade *bool `json:"enableCrossZoneUpgrade,omitempty"`

	// The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one
	// batch. As this is a maximum, unhealthy instances in previous or future batches
	// can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter
	// is 20%.
	MaxBatchInstancePercent *int32 `json:"maxBatchInstancePercent,omitempty"`

	// The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either
	// as a result of being upgraded, or by being found in an unhealthy state by
	// the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting
	// any batch. The default value for this parameter is 20%.
	MaxUnhealthyInstancePercent *int32 `json:"maxUnhealthyInstancePercent,omitempty"`

	// The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check
	// will happen after each batch is upgraded. If this percentage is ever exceeded,
	// the rolling update aborts. The default value for this parameter is 20%.
	MaxUnhealthyUpgradedInstancePercent *int32 `json:"maxUnhealthyUpgradedInstancePercent,omitempty"`

	// The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time
	// duration should be specified in ISO 8601 format. The default value is 0 seconds
	// (PT0S).
	PauseTimeBetweenBatches *string `json:"pauseTimeBetweenBatches,omitempty"`

	// Upgrade all unhealthy instances in a scale set before any healthy instances.
	PrioritizeUnhealthyInstances *bool `json:"prioritizeUnhealthyInstances,omitempty"`
}

// RollingUpgradeProgressInfo - Information about the number of virtual machine instances in each upgrade state.
type RollingUpgradeProgressInfo struct {
	// READ-ONLY; The number of instances that have failed to be upgraded successfully.
	FailedInstanceCount *int32 `json:"failedInstanceCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of instances that are currently being upgraded.
	InProgressInstanceCount *int32 `json:"inProgressInstanceCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of instances that have not yet begun to be upgraded.
	PendingInstanceCount *int32 `json:"pendingInstanceCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of instances that have been successfully upgraded.
	SuccessfulInstanceCount *int32 `json:"successfulInstanceCount,omitempty" azure:"ro"`
}

// RollingUpgradeRunningStatus - Information about the current running state of the overall upgrade.
type RollingUpgradeRunningStatus struct {
	// READ-ONLY; Code indicating the current status of the upgrade.
	Code *RollingUpgradeStatusCode `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The last action performed on the rolling upgrade.
	LastAction *RollingUpgradeActionType `json:"lastAction,omitempty" azure:"ro"`

	// READ-ONLY; Last action time of the upgrade.
	LastActionTime *time.Time `json:"lastActionTime,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the upgrade.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// RollingUpgradeStatusInfo - The status of the latest virtual machine scale set rolling upgrade.
type RollingUpgradeStatusInfo struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The status of the latest virtual machine scale set rolling upgrade.
	Properties *RollingUpgradeStatusInfoProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RollingUpgradeStatusInfoProperties - The status of the latest virtual machine scale set rolling upgrade.
type RollingUpgradeStatusInfoProperties struct {
	// READ-ONLY; Error details for this upgrade, if there are any.
	Error *APIError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The rolling upgrade policies applied for this upgrade.
	Policy *RollingUpgradePolicy `json:"policy,omitempty" azure:"ro"`

	// READ-ONLY; Information about the number of virtual machine instances in each upgrade state.
	Progress *RollingUpgradeProgressInfo `json:"progress,omitempty" azure:"ro"`

	// READ-ONLY; Information about the current running state of the overall upgrade.
	RunningStatus *RollingUpgradeRunningStatus `json:"runningStatus,omitempty" azure:"ro"`
}

// RunCommandDocument - Describes the properties of a Run Command.
type RunCommandDocument struct {
	// REQUIRED; The VM run command description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The VM run command id.
	ID *string `json:"id,omitempty"`

	// REQUIRED; The VM run command label.
	Label *string `json:"label,omitempty"`

	// REQUIRED; The Operating System type.
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// REQUIRED; The VM run command schema.
	Schema *string `json:"$schema,omitempty"`

	// REQUIRED; The script to be executed.
	Script []*string `json:"script,omitempty"`

	// The parameters used by the script.
	Parameters []*RunCommandParameterDefinition `json:"parameters,omitempty"`
}

// RunCommandDocumentBase - Describes the properties of a Run Command metadata.
type RunCommandDocumentBase struct {
	// REQUIRED; The VM run command description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The VM run command id.
	ID *string `json:"id,omitempty"`

	// REQUIRED; The VM run command label.
	Label *string `json:"label,omitempty"`

	// REQUIRED; The Operating System type.
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// REQUIRED; The VM run command schema.
	Schema *string `json:"$schema,omitempty"`
}

// RunCommandInput - Capture Virtual Machine parameters.
type RunCommandInput struct {
	// REQUIRED; The run command id.
	CommandID *string `json:"commandId,omitempty"`

	// The run command parameters.
	Parameters []*RunCommandInputParameter `json:"parameters,omitempty"`

	// Optional. The script to be executed. When this value is given, the given script will override the default script of the
	// command.
	Script []*string `json:"script,omitempty"`
}

// RunCommandInputParameter - Describes the properties of a run command parameter.
type RunCommandInputParameter struct {
	// REQUIRED; The run command parameter name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The run command parameter value.
	Value *string `json:"value,omitempty"`
}

// RunCommandListResult - The List Virtual Machine operation response.
type RunCommandListResult struct {
	// REQUIRED; The list of virtual machine run commands.
	Value []*RunCommandDocumentBase `json:"value,omitempty"`

	// The uri to fetch the next page of run commands. Call ListNext() with this to fetch the next page of run commands.
	NextLink *string `json:"nextLink,omitempty"`
}

// RunCommandParameterDefinition - Describes the properties of a run command parameter.
type RunCommandParameterDefinition struct {
	// REQUIRED; The run command parameter name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The run command parameter type.
	Type *string `json:"type,omitempty"`

	// The run command parameter default value.
	DefaultValue *string `json:"defaultValue,omitempty"`

	// The run command parameter required.
	Required *bool `json:"required,omitempty"`
}

type RunCommandResult struct {
	// Run command operation response.
	Value []*InstanceViewStatus `json:"value,omitempty"`
}

// SKU - Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set
// is currently on, you need to deallocate the VMs in the scale set before you modify the
// SKU name.
type SKU struct {
	// Specifies the number of virtual machines in the scale set.
	Capacity *int64 `json:"capacity,omitempty"`

	// The sku name.
	Name *string `json:"name,omitempty"`

	// Specifies the tier of virtual machines in a scale set.
	// Possible Values:
	// Standard
	// Basic
	Tier *string `json:"tier,omitempty"`
}

// SSHConfiguration - SSH configuration for Linux based VMs running on Azure
type SSHConfiguration struct {
	// The list of SSH public keys used to authenticate with linux based VMs.
	PublicKeys []*SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey - Contains information about SSH certificate public key and the path on the Linux VM where the public key
// is placed.
type SSHPublicKey struct {
	// SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa
	// format.
	// For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
	KeyData *string `json:"keyData,omitempty"`

	// Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key
	// is appended to the file. Example: /home/user/.ssh/authorized_keys
	Path *string `json:"path,omitempty"`
}

// SSHPublicKeyGenerateKeyPairResult - Response from generation of an SSH key pair.
type SSHPublicKeyGenerateKeyPairResult struct {
	// REQUIRED; The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}
	ID *string `json:"id,omitempty"`

	// REQUIRED; Private key portion of the key pair used to authenticate to a virtual machine through ssh. The private key is
	// returned in RFC3447 format and should be treated as a secret.
	PrivateKey *string `json:"privateKey,omitempty"`

	// REQUIRED; Public key portion of the key pair used to authenticate to a virtual machine through ssh. The public key is in
	// ssh-rsa format.
	PublicKey *string `json:"publicKey,omitempty"`
}

// SSHPublicKeyResource - Specifies information about the SSH public key.
type SSHPublicKeyResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the SSH public key.
	Properties *SSHPublicKeyResourceProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SSHPublicKeyResourceProperties - Properties of the SSH public key.
type SSHPublicKeyResourceProperties struct {
	// SSH public key used to authenticate to a virtual machine through ssh. If this property is not initially provided when the
	// resource is created, the publicKey property will be populated when
	// generateKeyPair is called. If the public key is provided upon resource creation, the provided public key needs to be at
	// least 2048-bit and in ssh-rsa format.
	PublicKey *string `json:"publicKey,omitempty"`
}

// SSHPublicKeyUpdateResource - Specifies information about the SSH public key.
type SSHPublicKeyUpdateResource struct {
	// Properties of the SSH public key.
	Properties *SSHPublicKeyResourceProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// SSHPublicKeysClientCreateOptions contains the optional parameters for the SSHPublicKeysClient.Create method.
type SSHPublicKeysClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SSHPublicKeysClientDeleteOptions contains the optional parameters for the SSHPublicKeysClient.Delete method.
type SSHPublicKeysClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SSHPublicKeysClientGenerateKeyPairOptions contains the optional parameters for the SSHPublicKeysClient.GenerateKeyPair
// method.
type SSHPublicKeysClientGenerateKeyPairOptions struct {
	// placeholder for future optional parameters
}

// SSHPublicKeysClientGetOptions contains the optional parameters for the SSHPublicKeysClient.Get method.
type SSHPublicKeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// SSHPublicKeysClientListByResourceGroupOptions contains the optional parameters for the SSHPublicKeysClient.ListByResourceGroup
// method.
type SSHPublicKeysClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SSHPublicKeysClientListBySubscriptionOptions contains the optional parameters for the SSHPublicKeysClient.ListBySubscription
// method.
type SSHPublicKeysClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// SSHPublicKeysClientUpdateOptions contains the optional parameters for the SSHPublicKeysClient.Update method.
type SSHPublicKeysClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SSHPublicKeysGroupListResult - The list SSH public keys operation response.
type SSHPublicKeysGroupListResult struct {
	// REQUIRED; The list of SSH public keys
	Value []*SSHPublicKeyResource `json:"value,omitempty"`

	// The URI to fetch the next page of SSH public keys. Call ListNext() with this URI to fetch the next page of SSH public keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScaleInPolicy - Describes a scale-in policy for a virtual machine scale set.
type ScaleInPolicy struct {
	// This property allows you to specify if virtual machines chosen for removal have to be force deleted when a virtual machine
	// scale set is being scaled-in.(Feature in Preview)
	ForceDeletion *bool `json:"forceDeletion,omitempty"`

	// The rules to be followed when scaling-in a virtual machine scale set.
	// Possible values are:
	// Default When a virtual machine scale set is scaled in, the scale set will first be balanced across zones if it is a zonal
	// scale set. Then, it will be balanced across Fault Domains as far as possible.
	// Within each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not protected from scale-in.
	// OldestVM When a virtual machine scale set is being scaled-in, the oldest virtual machines that are not protected from scale-in
	// will be chosen for removal. For zonal virtual machine scale sets, the
	// scale set will first be balanced across zones. Within each zone, the oldest virtual machines that are not protected will
	// be chosen for removal.
	// NewestVM When a virtual machine scale set is being scaled-in, the newest virtual machines that are not protected from scale-in
	// will be chosen for removal. For zonal virtual machine scale sets, the
	// scale set will first be balanced across zones. Within each zone, the newest virtual machines that are not protected will
	// be chosen for removal.
	Rules []*VirtualMachineScaleSetScaleInRules `json:"rules,omitempty"`
}

type ScheduledEventsProfile struct {
	// Specifies Terminate Scheduled Event related configurations.
	TerminateNotificationProfile *TerminateNotificationProfile `json:"terminateNotificationProfile,omitempty"`
}

// SecurityProfile - Specifies the Security profile settings for the virtual machine or virtual machine scale set.
type SecurityProfile struct {
	// This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual
	// machine scale set. This will enable the encryption for all the disks
	// including Resource/Temp disk at host itself.
	// Default: The Encryption at host will be disabled unless this property is set to true for the resource.
	EncryptionAtHost *bool `json:"encryptionAtHost,omitempty"`

	// Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings.
	// Default: UefiSettings will not be enabled unless this property is set.
	SecurityType *SecurityTypes `json:"securityType,omitempty"`

	// Specifies the security settings like secure boot and vTPM used while creating the virtual machine.
	// Minimum api-version: 2020-12-01
	UefiSettings *UefiSettings `json:"uefiSettings,omitempty"`
}

type ShareInfoElement struct {
	// READ-ONLY; A relative URI containing the ID of the VM that has the disk attached.
	VMURI *string `json:"vmUri,omitempty" azure:"ro"`
}

// SharedGalleriesClientGetOptions contains the optional parameters for the SharedGalleriesClient.Get method.
type SharedGalleriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SharedGalleriesClientListOptions contains the optional parameters for the SharedGalleriesClient.List method.
type SharedGalleriesClientListOptions struct {
	// The query parameter to decide what shared galleries to fetch when doing listing operations.
	SharedTo *SharedToValues
}

// SharedGallery - Specifies information about the Shared Gallery that you want to create or update.
type SharedGallery struct {
	// The identifier information of shared gallery.
	Identifier *SharedGalleryIdentifier `json:"identifier,omitempty"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`
}

// SharedGalleryDataDiskImage - This is the data disk image.
type SharedGalleryDataDiskImage struct {
	// REQUIRED; This property specifies the logical unit number of the data disk. This value is used to identify data disks within
	// the Virtual Machine and therefore must be unique for each data disk attached to the
	// Virtual Machine.
	Lun *int32 `json:"lun,omitempty"`

	// The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
	HostCaching *SharedGalleryHostCaching `json:"hostCaching,omitempty"`

	// READ-ONLY; This property indicates the size of the VHD to be created.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty" azure:"ro"`
}

// SharedGalleryDiskImage - This is the disk image base class.
type SharedGalleryDiskImage struct {
	// The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
	HostCaching *SharedGalleryHostCaching `json:"hostCaching,omitempty"`

	// READ-ONLY; This property indicates the size of the VHD to be created.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty" azure:"ro"`
}

// SharedGalleryIdentifier - The identifier information of shared gallery.
type SharedGalleryIdentifier struct {
	// The unique id of this shared gallery.
	UniqueID *string `json:"uniqueId,omitempty"`
}

// SharedGalleryImage - Specifies information about the gallery image definition that you want to create or update.
type SharedGalleryImage struct {
	// The identifier information of shared gallery.
	Identifier *SharedGalleryIdentifier `json:"identifier,omitempty"`

	// Describes the properties of a gallery image definition.
	Properties *SharedGalleryImageProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`
}

// SharedGalleryImageList - The List Shared Gallery Images operation response.
type SharedGalleryImageList struct {
	// REQUIRED; A list of shared gallery images.
	Value []*SharedGalleryImage `json:"value,omitempty"`

	// The uri to fetch the next page of shared gallery images. Call ListNext() with this to fetch the next page of shared gallery
	// images.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedGalleryImageProperties - Describes the properties of a gallery image definition.
type SharedGalleryImageProperties struct {
	// REQUIRED; This is the gallery image definition identifier.
	Identifier *GalleryImageIdentifier `json:"identifier,omitempty"`

	// REQUIRED; This property allows the user to specify whether the virtual machines created under this image are 'Generalized'
	// or 'Specialized'.
	OSState *OperatingSystemStateTypes `json:"osState,omitempty"`

	// REQUIRED; This property allows you to specify the type of the OS that is included in the disk when creating a VM from a
	// managed image.
	// Possible values are:
	// Windows
	// Linux
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// The architecture of the image. Applicable to OS disks only.
	Architecture *Architecture `json:"architecture,omitempty"`

	// Describes the disallowed disk types.
	Disallowed *Disallowed `json:"disallowed,omitempty"`

	// The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property
	// is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// End-user license agreement for the current community gallery image.
	Eula *string `json:"eula,omitempty"`

	// A list of gallery image features.
	Features []*GalleryImageFeature `json:"features,omitempty"`

	// The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
	HyperVGeneration *HyperVGeneration `json:"hyperVGeneration,omitempty"`

	// Privacy statement uri for the current community gallery image.
	PrivacyStatementURI *string `json:"privacyStatementUri,omitempty"`

	// Describes the gallery image definition purchase plan. This is used by marketplace images.
	PurchasePlan *ImagePurchasePlan `json:"purchasePlan,omitempty"`

	// The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
	Recommended *RecommendedMachineConfiguration `json:"recommended,omitempty"`
}

// SharedGalleryImageVersion - Specifies information about the gallery image version that you want to create or update.
type SharedGalleryImageVersion struct {
	// The identifier information of shared gallery.
	Identifier *SharedGalleryIdentifier `json:"identifier,omitempty"`

	// Describes the properties of a gallery image version.
	Properties *SharedGalleryImageVersionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`
}

// SharedGalleryImageVersionList - The List Shared Gallery Image versions operation response.
type SharedGalleryImageVersionList struct {
	// REQUIRED; A list of shared gallery images versions.
	Value []*SharedGalleryImageVersion `json:"value,omitempty"`

	// The uri to fetch the next page of shared gallery image versions. Call ListNext() with this to fetch the next page of shared
	// gallery image versions.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedGalleryImageVersionProperties - Describes the properties of a gallery image version.
type SharedGalleryImageVersionProperties struct {
	// The end of life date of the gallery image version Definition. This property can be used for decommissioning purposes. This
	// property is updatable.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty"`

	// If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`

	// The published date of the gallery image version Definition. This property can be used for decommissioning purposes. This
	// property is updatable.
	PublishedDate *time.Time `json:"publishedDate,omitempty"`

	// Describes the storage profile of the image version.
	StorageProfile *SharedGalleryImageVersionStorageProfile `json:"storageProfile,omitempty"`
}

// SharedGalleryImageVersionStorageProfile - This is the storage profile of a Gallery Image Version.
type SharedGalleryImageVersionStorageProfile struct {
	// A list of data disk images.
	DataDiskImages []*SharedGalleryDataDiskImage `json:"dataDiskImages,omitempty"`

	// This is the OS disk image.
	OSDiskImage *SharedGalleryOSDiskImage `json:"osDiskImage,omitempty"`
}

// SharedGalleryImageVersionsClientGetOptions contains the optional parameters for the SharedGalleryImageVersionsClient.Get
// method.
type SharedGalleryImageVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SharedGalleryImageVersionsClientListOptions contains the optional parameters for the SharedGalleryImageVersionsClient.List
// method.
type SharedGalleryImageVersionsClientListOptions struct {
	// The query parameter to decide what shared galleries to fetch when doing listing operations.
	SharedTo *SharedToValues
}

// SharedGalleryImagesClientGetOptions contains the optional parameters for the SharedGalleryImagesClient.Get method.
type SharedGalleryImagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SharedGalleryImagesClientListOptions contains the optional parameters for the SharedGalleryImagesClient.List method.
type SharedGalleryImagesClientListOptions struct {
	// The query parameter to decide what shared galleries to fetch when doing listing operations.
	SharedTo *SharedToValues
}

// SharedGalleryList - The List Shared Galleries operation response.
type SharedGalleryList struct {
	// REQUIRED; A list of shared galleries.
	Value []*SharedGallery `json:"value,omitempty"`

	// The uri to fetch the next page of shared galleries. Call ListNext() with this to fetch the next page of shared galleries.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedGalleryOSDiskImage - This is the OS disk image.
type SharedGalleryOSDiskImage struct {
	// The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
	HostCaching *SharedGalleryHostCaching `json:"hostCaching,omitempty"`

	// READ-ONLY; This property indicates the size of the VHD to be created.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty" azure:"ro"`
}

// SharingProfile - Profile for gallery sharing to subscription or tenant
type SharingProfile struct {
	// Information of community gallery if current gallery is shared to community.
	CommunityGalleryInfo *CommunityGalleryInfo `json:"communityGalleryInfo,omitempty"`

	// This property allows you to specify the permission of sharing gallery.
	// Possible values are:
	// Private
	// Groups
	// Community
	Permissions *GallerySharingPermissionTypes `json:"permissions,omitempty"`

	// READ-ONLY; A list of sharing profile groups.
	Groups []*SharingProfileGroup `json:"groups,omitempty" azure:"ro"`
}

// SharingProfileGroup - Group of the gallery sharing profile
type SharingProfileGroup struct {
	// A list of subscription/tenant ids the gallery is aimed to be shared to.
	IDs []*string `json:"ids,omitempty"`

	// This property allows you to specify the type of sharing group.
	// Possible values are:
	// Subscriptions
	// AADTenants
	Type *SharingProfileGroupTypes `json:"type,omitempty"`
}

// SharingStatus - Sharing status of current gallery.
type SharingStatus struct {
	// Summary of all regional sharing status.
	Summary []*RegionalSharingStatus `json:"summary,omitempty"`

	// READ-ONLY; Aggregated sharing state of current gallery.
	AggregatedState *SharingState `json:"aggregatedState,omitempty" azure:"ro"`
}

// SharingUpdate - Specifies information about the gallery sharing profile update.
type SharingUpdate struct {
	// REQUIRED; This property allows you to specify the operation type of gallery sharing update.
	// Possible values are:
	// Add
	// Remove
	// Reset
	OperationType *SharingUpdateOperationTypes `json:"operationType,omitempty"`

	// A list of sharing profile groups.
	Groups []*SharingProfileGroup `json:"groups,omitempty"`
}

// Snapshot resource.
type Snapshot struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The extended location where the snapshot will be created. Extended location cannot be changed.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Snapshot resource properties.
	Properties *SnapshotProperties `json:"properties,omitempty"`

	// The snapshots sku name. Can be StandardLRS, PremiumLRS, or Standard_ZRS. This is an optional parameter for incremental
	// snapshot and the default behavior is the SKU will be set to the same sku as the
	// previous snapshot
	SKU *SnapshotSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Unused. Always Null.
	ManagedBy *string `json:"managedBy,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotList - The List Snapshots operation response.
type SnapshotList struct {
	// REQUIRED; A list of snapshots.
	Value []*Snapshot `json:"value,omitempty"`

	// The uri to fetch the next page of snapshots. Call ListNext() with this to fetch the next page of snapshots.
	NextLink *string `json:"nextLink,omitempty"`
}

// SnapshotProperties - Snapshot resource properties.
type SnapshotProperties struct {
	// REQUIRED; Disk source information. CreationData information cannot be changed after the disk has been created.
	CreationData *CreationData `json:"creationData,omitempty"`

	// Percentage complete for the background copy when a resource is created via the CopyStart operation.
	CompletionPercent *float32 `json:"completionPercent,omitempty"`

	// Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
	CopyCompletionError *CopyCompletionError `json:"copyCompletionError,omitempty"`

	// Additional authentication requirements when exporting or uploading to a disk or snapshot.
	DataAccessAuthMode *DataAccessAuthMode `json:"dataAccessAuthMode,omitempty"`

	// ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`

	// If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this
	// field is present for updates or creation with other options, it indicates a
	// resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`

	// Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
	EncryptionSettingsCollection *EncryptionSettingsCollection `json:"encryptionSettingsCollection,omitempty"`

	// The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
	HyperVGeneration *HyperVGeneration `json:"hyperVGeneration,omitempty"`

	// Whether a snapshot is incremental. Incremental snapshots on the same disk occupy less space than full snapshots and can
	// be diffed.
	Incremental *bool `json:"incremental,omitempty"`

	// Policy for accessing the disk via network.
	NetworkAccessPolicy *NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`

	// The Operating System type.
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// Policy for controlling export on the disk.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Purchase plan information for the image from which the source disk for the snapshot was originally created.
	PurchasePlan *DiskPurchasePlan `json:"purchasePlan,omitempty"`

	// Contains the security related information for the resource.
	SecurityProfile *DiskSecurityProfile `json:"securityProfile,omitempty"`

	// List of supported capabilities for the image from which the source disk from the snapshot was originally created.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`

	// Indicates the OS on a snapshot supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`

	// READ-ONLY; The size of the disk in bytes. This field is read only.
	DiskSizeBytes *int64 `json:"diskSizeBytes,omitempty" azure:"ro"`

	// READ-ONLY; The state of the snapshot.
	DiskState *DiskState `json:"diskState,omitempty" azure:"ro"`

	// READ-ONLY; Incremental snapshots for a disk share an incremental snapshot family id. The Get Page Range Diff API can only
	// be called on incremental snapshots with the same family id.
	IncrementalSnapshotFamilyID *string `json:"incrementalSnapshotFamilyId,omitempty" azure:"ro"`

	// READ-ONLY; The disk provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The time when the snapshot was created.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; Unique Guid identifying the resource.
	UniqueID *string `json:"uniqueId,omitempty" azure:"ro"`
}

// SnapshotSKU - The snapshots sku name. Can be StandardLRS, PremiumLRS, or Standard_ZRS. This is an optional parameter for
// incremental snapshot and the default behavior is the SKU will be set to the same sku as the
// previous snapshot
type SnapshotSKU struct {
	// The sku name.
	Name *SnapshotStorageAccountTypes `json:"name,omitempty"`

	// READ-ONLY; The sku tier.
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// SnapshotUpdate - Snapshot update resource.
type SnapshotUpdate struct {
	// Snapshot resource update properties.
	Properties *SnapshotUpdateProperties `json:"properties,omitempty"`

	// The snapshots sku name. Can be StandardLRS, PremiumLRS, or Standard_ZRS. This is an optional parameter for incremental
	// snapshot and the default behavior is the SKU will be set to the same sku as the
	// previous snapshot
	SKU *SnapshotSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// SnapshotUpdateProperties - Snapshot resource update properties.
type SnapshotUpdateProperties struct {
	// Additional authentication requirements when exporting or uploading to a disk or snapshot.
	DataAccessAuthMode *DataAccessAuthMode `json:"dataAccessAuthMode,omitempty"`

	// ARM id of the DiskAccess resource for using private endpoints on disks.
	DiskAccessID *string `json:"diskAccessId,omitempty"`

	// If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this
	// field is present for updates or creation with other options, it indicates a
	// resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
	Encryption *Encryption `json:"encryption,omitempty"`

	// Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
	EncryptionSettingsCollection *EncryptionSettingsCollection `json:"encryptionSettingsCollection,omitempty"`

	// Policy for accessing the disk via network.
	NetworkAccessPolicy *NetworkAccessPolicy `json:"networkAccessPolicy,omitempty"`

	// the Operating System type.
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// Policy for controlling export on the disk.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// List of supported capabilities for the image from which the OS disk was created.
	SupportedCapabilities *SupportedCapabilities `json:"supportedCapabilities,omitempty"`

	// Indicates the OS on a snapshot supports hibernation.
	SupportsHibernation *bool `json:"supportsHibernation,omitempty"`
}

// SnapshotsClientBeginCreateOrUpdateOptions contains the optional parameters for the SnapshotsClient.BeginCreateOrUpdate
// method.
type SnapshotsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientBeginDeleteOptions contains the optional parameters for the SnapshotsClient.BeginDelete method.
type SnapshotsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientBeginGrantAccessOptions contains the optional parameters for the SnapshotsClient.BeginGrantAccess method.
type SnapshotsClientBeginGrantAccessOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientBeginRevokeAccessOptions contains the optional parameters for the SnapshotsClient.BeginRevokeAccess method.
type SnapshotsClientBeginRevokeAccessOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientBeginUpdateOptions contains the optional parameters for the SnapshotsClient.BeginUpdate method.
type SnapshotsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SnapshotsClientGetOptions contains the optional parameters for the SnapshotsClient.Get method.
type SnapshotsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientListByResourceGroupOptions contains the optional parameters for the SnapshotsClient.ListByResourceGroup
// method.
type SnapshotsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsClientListOptions contains the optional parameters for the SnapshotsClient.List method.
type SnapshotsClientListOptions struct {
	// placeholder for future optional parameters
}

// SoftDeletePolicy - Contains information about the soft deletion policy of the gallery.
type SoftDeletePolicy struct {
	// Enables soft-deletion for resources in this gallery, allowing them to be recovered within retention time.
	IsSoftDeleteEnabled *bool `json:"isSoftDeleteEnabled,omitempty"`
}

// SourceVault - The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
type SourceVault struct {
	// Resource Id
	ID *string `json:"id,omitempty"`
}

// SpotRestorePolicy - Specifies the Spot-Try-Restore properties for the virtual machine scale set.
// With this property customer can enable or disable automatic restore of the evicted Spot VMSS VM instances opportunistically
// based on capacity availability and pricing constraint.
type SpotRestorePolicy struct {
	// Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be tried to be restored opportunistically based
	// on capacity availability and pricing constraints
	Enabled *bool `json:"enabled,omitempty"`

	// Timeout value expressed as an ISO 8601 time duration after which the platform will not try to restore the VMSS SPOT instances
	RestoreTimeout *string `json:"restoreTimeout,omitempty"`
}

// StatusCodeCount - The status code and count of the cloud service instance view statuses
type StatusCodeCount struct {
	// READ-ONLY; The instance view status code
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Number of instances having this status code
	Count *int32 `json:"count,omitempty" azure:"ro"`
}

// StorageProfile - Specifies the storage settings for the virtual machine disks.
type StorageProfile struct {
	// Specifies the parameters that are used to add a data disk to a virtual machine.
	// For more information about disks, see About disks and VHDs for Azure virtual machines [https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview].
	DataDisks []*DataDisk `json:"dataDisks,omitempty"`

	// Specifies the disk controller type configured for the VM.
	// NOTE: This property will be set to the default disk controller type if not specified provided virtual machine is being
	// created as a hyperVGeneration: V2 based on the capabilities of the operating
	// system disk and VM size from the the specified minimum api version.
	// You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration
	// which implicitly deallocates and reallocates the VM.
	// Minimum api-version: 2022-08-01
	DiskControllerType *DiskControllerTypes `json:"diskControllerType,omitempty"`

	// Specifies information about the image to use. You can specify information about platform images, marketplace images, or
	// virtual machine images. This element is required when you want to use a platform
	// image, marketplace image, or virtual machine image, but is not used in other creation operations.
	ImageReference *ImageReference `json:"imageReference,omitempty"`

	// Specifies information about the operating system disk used by the virtual machine.
	// For more information about disks, see About disks and VHDs for Azure virtual machines [https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview].
	OSDisk *OSDisk `json:"osDisk,omitempty"`
}

type SubResource struct {
	// Resource Id
	ID *string `json:"id,omitempty"`
}

type SubResourceReadOnly struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`
}

type SubResourceWithColocationStatus struct {
	// Describes colocation status of a resource in the Proximity Placement Group.
	ColocationStatus *InstanceViewStatus `json:"colocationStatus,omitempty"`

	// Resource Id
	ID *string `json:"id,omitempty"`
}

// SupportedCapabilities - List of supported capabilities persisted on the disk resource for VM use.
type SupportedCapabilities struct {
	// True if the image from which the OS disk is created supports accelerated networking.
	AcceleratedNetwork *bool `json:"acceleratedNetwork,omitempty"`

	// CPU architecture supported by an OS disk.
	Architecture *Architecture `json:"architecture,omitempty"`

	// The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI.
	DiskControllerTypes *string `json:"diskControllerTypes,omitempty"`
}

// SystemData - The system meta data relating to this resource.
type SystemData struct {
	// READ-ONLY; Specifies the time in UTC at which the Cloud Service (extended support) resource was created.
	// Minimum api-version: 2022-04-04.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the time in UTC at which the Cloud Service (extended support) resource was last modified.
	// Minimum api-version: 2022-04-04.
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty" azure:"ro"`
}

// TargetRegion - Describes the target region information.
type TargetRegion struct {
	// REQUIRED; The name of the region.
	Name *string `json:"name,omitempty"`

	// Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
	Encryption *EncryptionImages `json:"encryption,omitempty"`

	// Contains the flag setting to hide an image when users specify version='latest'
	ExcludeFromLatest *bool `json:"excludeFromLatest,omitempty"`

	// The number of replicas of the Image Version to be created per region. This property is updatable.
	RegionalReplicaCount *int32 `json:"regionalReplicaCount,omitempty"`

	// Specifies the storage account type to be used to store the image. This property is not updatable.
	StorageAccountType *StorageAccountType `json:"storageAccountType,omitempty"`
}

type TerminateNotificationProfile struct {
	// Specifies whether the Terminate Scheduled event is enabled or disabled.
	Enable *bool `json:"enable,omitempty"`

	// Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event
	// before the event is auto approved (timed out). The configuration must be
	// specified in ISO 8601 format, the default value is 5 minutes (PT5M)
	NotBeforeTimeout *string `json:"notBeforeTimeout,omitempty"`
}

// ThrottledRequestsInput - Api request input for LogAnalytics getThrottledRequests Api.
type ThrottledRequestsInput struct {
	// REQUIRED; SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
	BlobContainerSasURI *string `json:"blobContainerSasUri,omitempty"`

	// REQUIRED; From time of the query
	FromTime *time.Time `json:"fromTime,omitempty"`

	// REQUIRED; To time of the query
	ToTime *time.Time `json:"toTime,omitempty"`

	// Group query result by Client Application ID.
	GroupByClientApplicationID *bool `json:"groupByClientApplicationId,omitempty"`

	// Group query result by Operation Name.
	GroupByOperationName *bool `json:"groupByOperationName,omitempty"`

	// Group query result by Resource Name.
	GroupByResourceName *bool `json:"groupByResourceName,omitempty"`

	// Group query result by Throttle Policy applied.
	GroupByThrottlePolicy *bool `json:"groupByThrottlePolicy,omitempty"`

	// Group query result by User Agent.
	GroupByUserAgent *bool `json:"groupByUserAgent,omitempty"`
}

// UefiSettings - Specifies the security settings like secure boot and vTPM used while creating the virtual machine.
// Minimum api-version: 2020-12-01
type UefiSettings struct {
	// Specifies whether secure boot should be enabled on the virtual machine.
	// Minimum api-version: 2020-12-01
	SecureBootEnabled *bool `json:"secureBootEnabled,omitempty"`

	// Specifies whether vTPM should be enabled on the virtual machine.
	// Minimum api-version: 2020-12-01
	VTpmEnabled *bool `json:"vTpmEnabled,omitempty"`
}

// UpdateDomain - Defines an update domain for the cloud service.
type UpdateDomain struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`
}

// UpdateDomainListResult - The list operation result.
type UpdateDomainListResult struct {
	// REQUIRED; The list of resources.
	Value []*UpdateDomain `json:"value,omitempty"`

	// The URI to fetch the next page of resources. Use this to get the next page of resources. Do this till nextLink is null
	// to fetch all the resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// UpdateResource - The Update Resource model definition.
type UpdateResource struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// UpdateResourceDefinition - The Update Resource model definition.
type UpdateResourceDefinition struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpgradeOperationHistoricalStatusInfo - Virtual Machine Scale Set OS Upgrade History operation response.
type UpgradeOperationHistoricalStatusInfo struct {
	// READ-ONLY; Resource location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Information about the properties of the upgrade operation.
	Properties *UpgradeOperationHistoricalStatusInfoProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpgradeOperationHistoricalStatusInfoProperties - Describes each OS upgrade on the Virtual Machine Scale Set.
type UpgradeOperationHistoricalStatusInfoProperties struct {
	// READ-ONLY; Error Details for this upgrade if there are any.
	Error *APIError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Counts of the VMs in each state.
	Progress *RollingUpgradeProgressInfo `json:"progress,omitempty" azure:"ro"`

	// READ-ONLY; Information about OS rollback if performed
	RollbackInfo *RollbackStatusInfo `json:"rollbackInfo,omitempty" azure:"ro"`

	// READ-ONLY; Information about the overall status of the upgrade operation.
	RunningStatus *UpgradeOperationHistoryStatus `json:"runningStatus,omitempty" azure:"ro"`

	// READ-ONLY; Invoker of the Upgrade Operation
	StartedBy *UpgradeOperationInvoker `json:"startedBy,omitempty" azure:"ro"`

	// READ-ONLY; Image Reference details
	TargetImageReference *ImageReference `json:"targetImageReference,omitempty" azure:"ro"`
}

// UpgradeOperationHistoryStatus - Information about the current running state of the overall upgrade.
type UpgradeOperationHistoryStatus struct {
	// READ-ONLY; Code indicating the current status of the upgrade.
	Code *UpgradeState `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; End time of the upgrade.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the upgrade.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// UpgradePolicy - Describes an upgrade policy - automatic, manual, or rolling.
type UpgradePolicy struct {
	// Configuration parameters used for performing automatic OS Upgrade.
	AutomaticOSUpgradePolicy *AutomaticOSUpgradePolicy `json:"automaticOSUpgradePolicy,omitempty"`

	// Specifies the mode of an upgrade to virtual machines in the scale set.
	// Possible values are:
	// Manual - You control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade
	// action.
	// Automatic - All virtual machines in the scale set are automatically updated at the same time.
	Mode *UpgradeMode `json:"mode,omitempty"`

	// The configuration parameters used while performing a rolling upgrade.
	RollingUpgradePolicy *RollingUpgradePolicy `json:"rollingUpgradePolicy,omitempty"`
}

// Usage - Describes Compute Resource Usage.
type Usage struct {
	// REQUIRED; The current usage of the resource.
	CurrentValue *int32 `json:"currentValue,omitempty"`

	// REQUIRED; The maximum permitted usage of the resource.
	Limit *int64 `json:"limit,omitempty"`

	// REQUIRED; The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`

	// REQUIRED; An enum describing the unit of usage measurement.
	Unit *string `json:"unit,omitempty"`
}

// UsageClientListOptions contains the optional parameters for the UsageClient.List method.
type UsageClientListOptions struct {
	// placeholder for future optional parameters
}

// UsageName - The Usage Names.
type UsageName struct {
	// The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The name of the resource.
	Value *string `json:"value,omitempty"`
}

type UserArtifactManage struct {
	// REQUIRED; Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
	Install *string `json:"install,omitempty"`

	// REQUIRED; Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
	Remove *string `json:"remove,omitempty"`

	// Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove
	// command on the previous version and install command on the current version
	// of the gallery application. This is limited to 4096 characters.
	Update *string `json:"update,omitempty"`
}

// UserArtifactSettings - Additional settings for the VM app that contains the target package and config file name when it
// is deployed to target VM or VM scale set.
type UserArtifactSettings struct {
	// Optional. The name to assign the downloaded config file on the VM. This is limited to 4096 characters. If not specified,
	// the config file will be named the Gallery Application name appended with
	// "_config".
	ConfigFileName *string `json:"configFileName,omitempty"`

	// Optional. The name to assign the downloaded package file on the VM. This is limited to 4096 characters. If not specified,
	// the package file will be named the same as the Gallery Application name.
	PackageFileName *string `json:"packageFileName,omitempty"`
}

// UserArtifactSource - The source image from which the Image Version is going to be created.
type UserArtifactSource struct {
	// REQUIRED; Required. The mediaLink of the artifact, must be a readable storage page blob.
	MediaLink *string `json:"mediaLink,omitempty"`

	// Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
	DefaultConfigurationLink *string `json:"defaultConfigurationLink,omitempty"`
}

type UserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// VMDiskSecurityProfile - Specifies the security profile settings for the managed disk.
// NOTE: It can only be set for Confidential VMs
type VMDiskSecurityProfile struct {
	// Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key
	// encrypted ConfidentialVM OS Disk and VMGuest blob.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`

	// Specifies the EncryptionType of the managed disk.
	// It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, and VMGuestStateOnly
	// for encryption of just the VMGuestState blob.
	// NOTE: It can be set for only Confidential VMs.
	SecurityEncryptionType *SecurityEncryptionTypes `json:"securityEncryptionType,omitempty"`
}

// VMGalleryApplication - Specifies the required information to reference a compute gallery application version
type VMGalleryApplication struct {
	// REQUIRED; Specifies the GalleryApplicationVersion resource id on the form of
	// /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
	PackageReferenceID *string `json:"packageReferenceId,omitempty"`

	// Optional, Specifies the uri to an azure blob that will replace the default configuration for the package if provided
	ConfigurationReference *string `json:"configurationReference,omitempty"`

	// If set to true, when a new Gallery Application version is available in PIR/SIG, it will be automatically updated for the
	// VM/VMSS
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`

	// Optional, Specifies the order in which the packages have to be installed
	Order *int32 `json:"order,omitempty"`

	// Optional, Specifies a passthrough value for more generic context.
	Tags *string `json:"tags,omitempty"`

	// Optional, If true, any failure for any operation in the VmApplication will fail the deployment
	TreatFailureAsDeploymentFailure *bool `json:"treatFailureAsDeploymentFailure,omitempty"`
}

// VMImagesInEdgeZoneListResult - The List VmImages in EdgeZone operation response.
type VMImagesInEdgeZoneListResult struct {
	// The URI to fetch the next page of VMImages in EdgeZone. Call ListNext() with this URI to fetch the next page of VmImages.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of VMImages in EdgeZone
	Value []*VirtualMachineImageResource `json:"value,omitempty"`
}

type VMScaleSetConvertToSinglePlacementGroupInput struct {
	// Id of the placement group in which you want future virtual machine instances to be placed. To query placement group Id,
	// please use Virtual Machine Scale Set VMs - Get API. If not provided, the
	// platform will choose one with maximum number of virtual machine instances.
	ActivePlacementGroupID *string `json:"activePlacementGroupId,omitempty"`
}

// VMSizeProperties - Specifies VM Size Property settings on the virtual machine.
type VMSizeProperties struct {
	// Specifies the number of vCPUs available for the VM.
	// When this property is not specified in the request body the default behavior is to set it to the value of vCPUs available
	// for that VM size exposed in api response of List all available virtual machine
	// sizes in a region [https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list] .
	VCPUsAvailable *int32 `json:"vCPUsAvailable,omitempty"`

	// Specifies the vCPU to physical core ratio.
	// When this property is not specified in the request body the default behavior is set to the value of vCPUsPerCore for the
	// VM Size exposed in api response of List all available virtual machine sizes in
	// a region [https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list]
	// Setting this property to 1 also means that hyper-threading is disabled.
	VCPUsPerCore *int32 `json:"vCPUsPerCore,omitempty"`
}

// VaultCertificate - Describes a single certificate reference in a Key Vault, and where the certificate should reside on
// the VM.
type VaultCertificate struct {
	// For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified
	// certificate store is implicitly in the LocalMachine account.
	// For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name <UppercaseThumbprint>.crt
	// for the X509 certificate file and <UppercaseThumbprint>.prv for private
	// key. Both of these files are .pem formatted.
	CertificateStore *string `json:"certificateStore,omitempty"`

	// This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault,
	// see Add a key or secret to the key vault
	// [https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add]. In this case, your certificate needs to be It
	// is the Base64 encoding of the following JSON Object which is encoded in UTF-8:
	// {
	// "data":"",
	// "dataType":"pfx",
	// "password":""
	// }
	// To install certificates on a virtual machine it is recommended to use the Azure Key Vault virtual machine extension for
	// Linux
	// [https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux] or the Azure Key Vault virtual machine extension
	// for Windows
	// [https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows].
	CertificateURL *string `json:"certificateUrl,omitempty"`
}

// VaultSecretGroup - Describes a set of certificates which are all in the same Key Vault.
type VaultSecretGroup struct {
	// The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
	SourceVault *SubResource `json:"sourceVault,omitempty"`

	// The list of key vault references in SourceVault which contain certificates.
	VaultCertificates []*VaultCertificate `json:"vaultCertificates,omitempty"`
}

// VirtualHardDisk - Describes the uri of a disk.
type VirtualHardDisk struct {
	// Specifies the virtual hard disk's uri.
	URI *string `json:"uri,omitempty"`
}

// VirtualMachine - Describes a Virtual Machine.
type VirtualMachine struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the virtual machine, if configured.
	Identity *VirtualMachineIdentity `json:"identity,omitempty"`

	// Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace
	// images. Before you can use a marketplace image from an API, you must
	// enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click
	// Want to deploy programmatically, Get Started ->. Enter any required
	// information and then click Save.
	Plan *Plan `json:"plan,omitempty"`

	// Describes the properties of a Virtual Machine.
	Properties *VirtualMachineProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// The virtual machine zones.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The virtual machine child extension resources.
	Resources []*VirtualMachineExtension `json:"resources,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineAgentInstanceView - The instance view of the VM Agent running on the virtual machine.
type VirtualMachineAgentInstanceView struct {
	// The virtual machine extension handler instance view.
	ExtensionHandlers []*VirtualMachineExtensionHandlerInstanceView `json:"extensionHandlers,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// The VM Agent full version.
	VMAgentVersion *string `json:"vmAgentVersion,omitempty"`
}

// VirtualMachineAssessPatchesResult - Describes the properties of an AssessPatches result.
type VirtualMachineAssessPatchesResult struct {
	// READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension
	// logs.
	AssessmentActivityID *string `json:"assessmentActivityId,omitempty" azure:"ro"`

	// READ-ONLY; The list of patches that have been detected as available for installation.
	AvailablePatches []*VirtualMachineSoftwarePatchProperties `json:"availablePatches,omitempty" azure:"ro"`

	// READ-ONLY; The number of critical or security patches that have been detected as available and not yet installed.
	CriticalAndSecurityPatchCount *int32 `json:"criticalAndSecurityPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	Error *APIError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The number of all available patches excluding critical and security.
	OtherPatchCount *int32 `json:"otherPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete
	// installation but the reboot has not yet occurred.
	RebootPending *bool `json:"rebootPending,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation began.
	StartDateTime *time.Time `json:"startDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes.
	// At that point it will become "Unknown", "Failed", "Succeeded", or
	// "CompletedWithWarnings."
	Status *PatchOperationStatus `json:"status,omitempty" azure:"ro"`
}

// VirtualMachineCaptureParameters - Capture Virtual Machine parameters.
type VirtualMachineCaptureParameters struct {
	// REQUIRED; The destination container name.
	DestinationContainerName *string `json:"destinationContainerName,omitempty"`

	// REQUIRED; Specifies whether to overwrite the destination virtual hard disk, in case of conflict.
	OverwriteVhds *bool `json:"overwriteVhds,omitempty"`

	// REQUIRED; The captured virtual hard disk's name prefix.
	VhdPrefix *string `json:"vhdPrefix,omitempty"`
}

// VirtualMachineCaptureResult - Output of virtual machine capture operation.
type VirtualMachineCaptureResult struct {
	// Resource Id
	ID *string `json:"id,omitempty"`

	// READ-ONLY; the version of the content
	ContentVersion *string `json:"contentVersion,omitempty" azure:"ro"`

	// READ-ONLY; parameters of the captured virtual machine
	Parameters interface{} `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; a list of resource items of the captured virtual machine
	Resources []interface{} `json:"resources,omitempty" azure:"ro"`

	// READ-ONLY; the schema of the captured virtual machine
	Schema *string `json:"$schema,omitempty" azure:"ro"`
}

// VirtualMachineExtension - Describes a Virtual Machine Extension.
type VirtualMachineExtension struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a Virtual Machine Extension.
	Properties *VirtualMachineExtensionProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineExtensionHandlerInstanceView - The instance view of a virtual machine extension handler.
type VirtualMachineExtensionHandlerInstanceView struct {
	// The extension handler status.
	Status *InstanceViewStatus `json:"status,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
}

// VirtualMachineExtensionImage - Describes a Virtual Machine Extension Image.
type VirtualMachineExtensionImage struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a Virtual Machine Extension Image.
	Properties *VirtualMachineExtensionImageProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineExtensionImageProperties - Describes the properties of a Virtual Machine Extension Image.
type VirtualMachineExtensionImageProperties struct {
	// REQUIRED; The type of role (IaaS or PaaS) this extension supports.
	ComputeRole *string `json:"computeRole,omitempty"`

	// REQUIRED; The schema defined by publisher, where extension consumers should provide settings in a matching schema.
	HandlerSchema *string `json:"handlerSchema,omitempty"`

	// REQUIRED; The operating system this extension supports.
	OperatingSystem *string `json:"operatingSystem,omitempty"`

	// Whether the handler can support multiple extensions.
	SupportsMultipleExtensions *bool `json:"supportsMultipleExtensions,omitempty"`

	// Whether the extension can be used on xRP VMScaleSets. By default existing extensions are usable on scalesets, but there
	// might be cases where a publisher wants to explicitly indicate the extension is
	// only enabled for CRP VMs but not VMSS.
	VMScaleSetEnabled *bool `json:"vmScaleSetEnabled,omitempty"`
}

// VirtualMachineExtensionImagesClientGetOptions contains the optional parameters for the VirtualMachineExtensionImagesClient.Get
// method.
type VirtualMachineExtensionImagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineExtensionImagesClientListTypesOptions contains the optional parameters for the VirtualMachineExtensionImagesClient.ListTypes
// method.
type VirtualMachineExtensionImagesClientListTypesOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineExtensionImagesClientListVersionsOptions contains the optional parameters for the VirtualMachineExtensionImagesClient.ListVersions
// method.
type VirtualMachineExtensionImagesClientListVersionsOptions struct {
	// The filter to apply on the operation.
	Filter  *string
	Orderby *string
	Top     *int32
}

// VirtualMachineExtensionInstanceView - The instance view of a virtual machine extension.
type VirtualMachineExtensionInstanceView struct {
	// The virtual machine extension name.
	Name *string `json:"name,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// The resource status information.
	Substatuses []*InstanceViewStatus `json:"substatuses,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
}

// VirtualMachineExtensionProperties - Describes the properties of a Virtual Machine Extension.
type VirtualMachineExtensionProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension
	// available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`

	// How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The virtual machine extension instance view.
	InstanceView *VirtualMachineExtensionInstanceView `json:"instanceView,omitempty"`

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// The extensions protected settings that are passed by reference, and consumed from key vault
	ProtectedSettingsFromKeyVault *KeyVaultSecretReference `json:"protectedSettingsFromKeyVault,omitempty"`

	// The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`

	// Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting
	// to the VM will not be suppressed regardless of this value). The default is false.
	SuppressFailures *bool `json:"suppressFailures,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualMachineExtensionUpdate - Describes a Virtual Machine Extension.
type VirtualMachineExtensionUpdate struct {
	// Describes the properties of a Virtual Machine Extension.
	Properties *VirtualMachineExtensionUpdateProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineExtensionUpdateProperties - Describes the properties of a Virtual Machine Extension.
type VirtualMachineExtensionUpdateProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension
	// available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`

	// How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// The extensions protected settings that are passed by reference, and consumed from key vault
	ProtectedSettingsFromKeyVault *KeyVaultSecretReference `json:"protectedSettingsFromKeyVault,omitempty"`

	// The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`

	// Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting
	// to the VM will not be suppressed regardless of this value). The default is false.
	SuppressFailures *bool `json:"suppressFailures,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
}

// VirtualMachineExtensionsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachineExtensionsClient.BeginCreateOrUpdate
// method.
type VirtualMachineExtensionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineExtensionsClientBeginDeleteOptions contains the optional parameters for the VirtualMachineExtensionsClient.BeginDelete
// method.
type VirtualMachineExtensionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineExtensionsClientBeginUpdateOptions contains the optional parameters for the VirtualMachineExtensionsClient.BeginUpdate
// method.
type VirtualMachineExtensionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineExtensionsClientGetOptions contains the optional parameters for the VirtualMachineExtensionsClient.Get method.
type VirtualMachineExtensionsClientGetOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineExtensionsClientListOptions contains the optional parameters for the VirtualMachineExtensionsClient.List
// method.
type VirtualMachineExtensionsClientListOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineExtensionsListResult - The List Extension operation response
type VirtualMachineExtensionsListResult struct {
	// The list of extensions
	Value []*VirtualMachineExtension `json:"value,omitempty"`
}

// VirtualMachineHealthStatus - The health status of the VM.
type VirtualMachineHealthStatus struct {
	// READ-ONLY; The health status information for the VM.
	Status *InstanceViewStatus `json:"status,omitempty" azure:"ro"`
}

// VirtualMachineIPTag - Contains the IP tag associated with the public IP address.
type VirtualMachineIPTag struct {
	// IP tag type. Example: FirstPartyUsage.
	IPTagType *string `json:"ipTagType,omitempty"`

	// IP tag associated with the public IP. Example: SQL, Storage etc.
	Tag *string `json:"tag,omitempty"`
}

// VirtualMachineIdentity - Identity for the virtual machine.
type VirtualMachineIdentity struct {
	// The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes both an implicitly
	// created identity and a set of user assigned identities. The type 'None' will
	// remove any identities from the virtual machine.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the Virtual Machine. The user identity dictionary key references will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of virtual machine identity. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id associated with the virtual machine. This property will only be provided for a system assigned
	// identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// VirtualMachineImage - Describes a Virtual Machine Image.
type VirtualMachineImage struct {
	// REQUIRED; The supported Azure location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The name of the resource.
	Name *string `json:"name,omitempty"`

	// The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource Id
	ID *string `json:"id,omitempty"`

	// Describes the properties of a Virtual Machine Image.
	Properties *VirtualMachineImageProperties `json:"properties,omitempty"`

	// Specifies the tags that are assigned to the virtual machine. For more information about using tags, see Using tags to organize
	// your Azure resources
	// [https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md].
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineImageFeature - Specifies additional capabilities supported by the image
type VirtualMachineImageFeature struct {
	// The name of the feature.
	Name *string `json:"name,omitempty"`

	// The corresponding value for the feature.
	Value *string `json:"value,omitempty"`
}

// VirtualMachineImageProperties - Describes the properties of a Virtual Machine Image.
type VirtualMachineImageProperties struct {
	// Specifies the Architecture Type
	Architecture *ArchitectureTypes `json:"architecture,omitempty"`

	// Describes automatic OS upgrade properties on the image.
	AutomaticOSUpgradeProperties *AutomaticOSUpgradeProperties `json:"automaticOSUpgradeProperties,omitempty"`
	DataDiskImages               []*DataDiskImage              `json:"dataDiskImages,omitempty"`

	// Specifies disallowed configuration for the VirtualMachine created from the image
	Disallowed *DisallowedConfiguration      `json:"disallowed,omitempty"`
	Features   []*VirtualMachineImageFeature `json:"features,omitempty"`

	// Specifies the HyperVGeneration Type
	HyperVGeneration *HyperVGenerationTypes `json:"hyperVGeneration,omitempty"`

	// Contains the os disk image information.
	OSDiskImage *OSDiskImage `json:"osDiskImage,omitempty"`

	// Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
	Plan *PurchasePlan `json:"plan,omitempty"`
}

// VirtualMachineImageResource - Virtual machine image resource information.
type VirtualMachineImageResource struct {
	// REQUIRED; The supported Azure location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The name of the resource.
	Name *string `json:"name,omitempty"`

	// The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource Id
	ID *string `json:"id,omitempty"`

	// Specifies the tags that are assigned to the virtual machine. For more information about using tags, see Using tags to organize
	// your Azure resources
	// [https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md].
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineImagesClientGetOptions contains the optional parameters for the VirtualMachineImagesClient.Get method.
type VirtualMachineImagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImagesClientListByEdgeZoneOptions contains the optional parameters for the VirtualMachineImagesClient.ListByEdgeZone
// method.
type VirtualMachineImagesClientListByEdgeZoneOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImagesClientListOffersOptions contains the optional parameters for the VirtualMachineImagesClient.ListOffers
// method.
type VirtualMachineImagesClientListOffersOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImagesClientListOptions contains the optional parameters for the VirtualMachineImagesClient.List method.
type VirtualMachineImagesClientListOptions struct {
	// The expand expression to apply on the operation.
	Expand  *string
	Orderby *string
	Top     *int32
}

// VirtualMachineImagesClientListPublishersOptions contains the optional parameters for the VirtualMachineImagesClient.ListPublishers
// method.
type VirtualMachineImagesClientListPublishersOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImagesClientListSKUsOptions contains the optional parameters for the VirtualMachineImagesClient.ListSKUs
// method.
type VirtualMachineImagesClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImagesEdgeZoneClientGetOptions contains the optional parameters for the VirtualMachineImagesEdgeZoneClient.Get
// method.
type VirtualMachineImagesEdgeZoneClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImagesEdgeZoneClientListOffersOptions contains the optional parameters for the VirtualMachineImagesEdgeZoneClient.ListOffers
// method.
type VirtualMachineImagesEdgeZoneClientListOffersOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImagesEdgeZoneClientListOptions contains the optional parameters for the VirtualMachineImagesEdgeZoneClient.List
// method.
type VirtualMachineImagesEdgeZoneClientListOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
	// Specifies the order of the results returned. Formatted as an OData query.
	Orderby *string
	// An integer value specifying the number of images to return that matches supplied values.
	Top *int32
}

// VirtualMachineImagesEdgeZoneClientListPublishersOptions contains the optional parameters for the VirtualMachineImagesEdgeZoneClient.ListPublishers
// method.
type VirtualMachineImagesEdgeZoneClientListPublishersOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineImagesEdgeZoneClientListSKUsOptions contains the optional parameters for the VirtualMachineImagesEdgeZoneClient.ListSKUs
// method.
type VirtualMachineImagesEdgeZoneClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineInstallPatchesParameters - Input for InstallPatches as directly received by the API
type VirtualMachineInstallPatchesParameters struct {
	// REQUIRED; Defines when it is acceptable to reboot a VM during a software update operation.
	RebootSetting *VMGuestPatchRebootSetting `json:"rebootSetting,omitempty"`

	// Input for InstallPatches on a Linux VM, as directly received by the API
	LinuxParameters *LinuxParameters `json:"linuxParameters,omitempty"`

	// Specifies the maximum amount of time that the operation will run. It must be an ISO 8601-compliant duration string such
	// as PT4H (4 hours)
	MaximumDuration *string `json:"maximumDuration,omitempty"`

	// Input for InstallPatches on a Windows VM, as directly received by the API
	WindowsParameters *WindowsParameters `json:"windowsParameters,omitempty"`
}

// VirtualMachineInstallPatchesResult - The result summary of an installation operation.
type VirtualMachineInstallPatchesResult struct {
	// READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	Error *APIError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches that were not installed due to the user blocking their installation.
	ExcludedPatchCount *int32 `json:"excludedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches that could not be installed due to some issue. See errors for details.
	FailedPatchCount *int32 `json:"failedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension
	// logs.
	InstallationActivityID *string `json:"installationActivityId,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches successfully installed.
	InstalledPatchCount *int32 `json:"installedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation ran out of time before it completed all its intended actions.
	MaintenanceWindowExceeded *bool `json:"maintenanceWindowExceeded,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches that were detected as available for install, but did not meet the operation's criteria.
	NotSelectedPatchCount *int32 `json:"notSelectedPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The patches that were installed during the operation.
	Patches []*PatchInstallationDetail `json:"patches,omitempty" azure:"ro"`

	// READ-ONLY; The number of patches that were identified as meeting the installation criteria, but were not able to be installed.
	// Typically this happens when maintenanceWindowExceeded == true.
	PendingPatchCount *int32 `json:"pendingPatchCount,omitempty" azure:"ro"`

	// READ-ONLY; The reboot state of the VM following completion of the operation.
	RebootStatus *VMGuestPatchRebootStatus `json:"rebootStatus,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the operation began.
	StartDateTime *time.Time `json:"startDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes.
	// At that point it will become "Failed", "Succeeded", "Unknown" or "CompletedWithWarnings."
	Status *PatchOperationStatus `json:"status,omitempty" azure:"ro"`
}

// VirtualMachineInstanceView - The instance view of a virtual machine.
type VirtualMachineInstanceView struct {
	// Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status.
	// You can easily view the output of your console log.
	// Azure also enables you to see a screenshot of the VM from the hypervisor.
	BootDiagnostics *BootDiagnosticsInstanceView `json:"bootDiagnostics,omitempty"`

	// The computer name assigned to the virtual machine.
	ComputerName *string `json:"computerName,omitempty"`

	// The virtual machine disk information.
	Disks []*DiskInstanceView `json:"disks,omitempty"`

	// The extensions information.
	Extensions []*VirtualMachineExtensionInstanceView `json:"extensions,omitempty"`

	// Specifies the HyperVGeneration Type associated with a resource
	HyperVGeneration *HyperVGenerationType `json:"hyperVGeneration,omitempty"`

	// The Maintenance Operation status on the virtual machine.
	MaintenanceRedeployStatus *MaintenanceRedeployStatus `json:"maintenanceRedeployStatus,omitempty"`

	// The Operating System running on the virtual machine.
	OSName *string `json:"osName,omitempty"`

	// The version of Operating System running on the virtual machine.
	OSVersion *string `json:"osVersion,omitempty"`

	// [Preview Feature] The status of virtual machine patch operations.
	PatchStatus *VirtualMachinePatchStatus `json:"patchStatus,omitempty"`

	// Specifies the fault domain of the virtual machine.
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`

	// Specifies the update domain of the virtual machine.
	PlatformUpdateDomain *int32 `json:"platformUpdateDomain,omitempty"`

	// The Remote desktop certificate thumbprint.
	RdpThumbPrint *string `json:"rdpThumbPrint,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// The VM Agent running on the virtual machine.
	VMAgent *VirtualMachineAgentInstanceView `json:"vmAgent,omitempty"`

	// READ-ONLY; Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when
	// the virtual machine is associated with a dedicated host group that has automatic
	// placement enabled.
	// Minimum api-version: 2020-06-01.
	AssignedHost *string `json:"assignedHost,omitempty" azure:"ro"`

	// READ-ONLY; The health status for the VM.
	VMHealth *VirtualMachineHealthStatus `json:"vmHealth,omitempty" azure:"ro"`
}

// VirtualMachineListResult - The List Virtual Machine operation response.
type VirtualMachineListResult struct {
	// REQUIRED; The list of virtual machines.
	Value []*VirtualMachine `json:"value,omitempty"`

	// The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch the next page of Virtual Machines.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineNetworkInterfaceConfiguration - Describes a virtual machine network interface configurations.
type VirtualMachineNetworkInterfaceConfiguration struct {
	// REQUIRED; The network interface configuration name.
	Name *string `json:"name,omitempty"`

	// Describes a virtual machine network profile's IP configuration.
	Properties *VirtualMachineNetworkInterfaceConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineNetworkInterfaceConfigurationProperties - Describes a virtual machine network profile's IP configuration.
type VirtualMachineNetworkInterfaceConfigurationProperties struct {
	// REQUIRED; Specifies the IP configurations of the network interface.
	IPConfigurations []*VirtualMachineNetworkInterfaceIPConfiguration `json:"ipConfigurations,omitempty"`

	// The dns settings to be applied on the network interfaces.
	DNSSettings *VirtualMachineNetworkInterfaceDNSSettingsConfiguration `json:"dnsSettings,omitempty"`

	// Specify what happens to the network interface when the VM is deleted
	DeleteOption *DeleteOptions `json:"deleteOption,omitempty"`

	// Specifies whether the network interface is disabled for tcp state tracking.
	DisableTCPStateTracking *bool        `json:"disableTcpStateTracking,omitempty"`
	DscpConfiguration       *SubResource `json:"dscpConfiguration,omitempty"`

	// Specifies whether the network interface is accelerated networking-enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`

	// Specifies whether the network interface is FPGA networking-enabled.
	EnableFpga *bool `json:"enableFpga,omitempty"`

	// Whether IP forwarding enabled on this NIC.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`

	// The network security group.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`

	// Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`
}

// VirtualMachineNetworkInterfaceDNSSettingsConfiguration - Describes a virtual machines network configuration's DNS settings.
type VirtualMachineNetworkInterfaceDNSSettingsConfiguration struct {
	// List of DNS servers IP addresses
	DNSServers []*string `json:"dnsServers,omitempty"`
}

// VirtualMachineNetworkInterfaceIPConfiguration - Describes a virtual machine network profile's IP configuration.
type VirtualMachineNetworkInterfaceIPConfiguration struct {
	// REQUIRED; The IP configuration name.
	Name *string `json:"name,omitempty"`

	// Describes a virtual machine network interface IP configuration properties.
	Properties *VirtualMachineNetworkInterfaceIPConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineNetworkInterfaceIPConfigurationProperties - Describes a virtual machine network interface IP configuration
// properties.
type VirtualMachineNetworkInterfaceIPConfigurationProperties struct {
	// Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend
	// address pools of multiple application gateways. Multiple virtual machines
	// cannot use the same application gateway.
	ApplicationGatewayBackendAddressPools []*SubResource `json:"applicationGatewayBackendAddressPools,omitempty"`

	// Specifies an array of references to application security group.
	ApplicationSecurityGroups []*SubResource `json:"applicationSecurityGroups,omitempty"`

	// Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address
	// pools of one public and one internal load balancer. [Multiple virtual
	// machines cannot use the same basic sku load balancer].
	LoadBalancerBackendAddressPools []*SubResource `json:"loadBalancerBackendAddressPools,omitempty"`

	// Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`

	// Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default
	// is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
	PrivateIPAddressVersion *IPVersions `json:"privateIPAddressVersion,omitempty"`

	// The publicIPAddressConfiguration.
	PublicIPAddressConfiguration *VirtualMachinePublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`

	// Specifies the identifier of the subnet.
	Subnet *SubResource `json:"subnet,omitempty"`
}

// VirtualMachinePatchStatus - The status of virtual machine patch operations.
type VirtualMachinePatchStatus struct {
	// The available patch summary of the latest assessment operation for the virtual machine.
	AvailablePatchSummary *AvailablePatchSummary `json:"availablePatchSummary,omitempty"`

	// The installation summary of the latest installation operation for the virtual machine.
	LastPatchInstallationSummary *LastPatchInstallationSummary `json:"lastPatchInstallationSummary,omitempty"`

	// READ-ONLY; The enablement status of the specified patchMode
	ConfigurationStatuses []*InstanceViewStatus `json:"configurationStatuses,omitempty" azure:"ro"`
}

// VirtualMachineProperties - Describes the properties of a Virtual Machine.
type VirtualMachineProperties struct {
	// Specifies additional capabilities enabled or disabled on the virtual machine.
	AdditionalCapabilities *AdditionalCapabilities `json:"additionalCapabilities,omitempty"`

	// Specifies the gallery applications that should be made available to the VM/VMSS
	ApplicationProfile *ApplicationProfile `json:"applicationProfile,omitempty"`

	// Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified
	// in the same availability set are allocated to different nodes to maximize
	// availability. For more information about availability sets, see Availability sets overview [https://docs.microsoft.com/azure/virtual-machines/availability-set-overview].
	// For more information on Azure planned maintenance, see Maintenance and updates for Virtual Machines in Azure [https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates]
	// Currently, a VM can only be added to availability set at creation time. The availability set to which the VM is being added
	// should be under the same resource group as the availability set resource. An
	// existing VM cannot be added to an availability set.
	// This property cannot exist along with a non-null properties.virtualMachineScaleSet reference.
	AvailabilitySet *SubResource `json:"availabilitySet,omitempty"`

	// Specifies the billing related details of a Azure Spot virtual machine.
	// Minimum api-version: 2019-03-01.
	BillingProfile *BillingProfile `json:"billingProfile,omitempty"`

	// Specifies information about the capacity reservation that is used to allocate virtual machine.
	// Minimum api-version: 2021-04-01.
	CapacityReservation *CapacityReservationProfile `json:"capacityReservation,omitempty"`

	// Specifies the boot diagnostic settings state.
	// Minimum api-version: 2015-06-15.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`

	// Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set.
	// For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
	// For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
	EvictionPolicy *VirtualMachineEvictionPolicyTypes `json:"evictionPolicy,omitempty"`

	// Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes
	// (inclusive) and should be specified in ISO 8601 format. The default value is 90
	// minutes (PT1H30M).
	// Minimum api-version: 2020-06-01
	ExtensionsTimeBudget *string `json:"extensionsTimeBudget,omitempty"`

	// Specifies the hardware settings for the virtual machine.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`

	// Specifies information about the dedicated host that the virtual machine resides in.
	// Minimum api-version: 2018-10-01.
	Host *SubResource `json:"host,omitempty"`

	// Specifies information about the dedicated host group that the virtual machine resides in.
	// Minimum api-version: 2020-06-01.
	// NOTE: User cannot specify both host and hostGroup properties.
	HostGroup *SubResource `json:"hostGroup,omitempty"`

	// Specifies that the image or disk that is being used was licensed on-premises.
	// Possible values for Windows Server operating system are:
	// WindowsClient
	// WindowsServer
	// Possible values for Linux Server operating system are:
	// RHELBYOS (for RHEL)
	// SLESBYOS (for SUSE)
	// For more information, see Azure Hybrid Use Benefit for Windows Server [https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing]
	// Azure Hybrid Use Benefit for Linux Server [https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux]
	// Minimum api-version: 2015-06-15
	LicenseType *string `json:"licenseType,omitempty"`

	// Specifies the network interfaces of the virtual machine.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// Specifies the operating system settings used while creating the virtual machine. Some of the settings cannot be changed
	// once VM is provisioned.
	OSProfile *OSProfile `json:"osProfile,omitempty"`

	// Specifies the scale set logical fault domain into which the Virtual Machine will be created. By default, the Virtual Machine
	// will by automatically assigned to a fault domain that best maintains
	// balance across available fault domains.
	// This is applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set.The Virtual Machine Scale
	// Set that is referenced, must have 'platformFaultDomainCount' > 1.This property
	// cannot be updated once the Virtual Machine is created.Fault domain assignment can be viewed in the Virtual Machine Instance
	// View.
	// Minimum api‐version: 2020‐12‐01
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`

	// Specifies the priority for the virtual machine.
	// Minimum api-version: 2019-03-01
	Priority *VirtualMachinePriorityTypes `json:"priority,omitempty"`

	// Specifies information about the proximity placement group that the virtual machine should be assigned to.
	// Minimum api-version: 2018-04-01.
	ProximityPlacementGroup *SubResource `json:"proximityPlacementGroup,omitempty"`

	// Specifies Scheduled Event related configurations.
	ScheduledEventsProfile *ScheduledEventsProfile `json:"scheduledEventsProfile,omitempty"`

	// Specifies the Security related profile settings for the virtual machine.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// Specifies the storage settings for the virtual machine disks.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here.
	// Minimum api-version: 2021-03-01
	UserData *string `json:"userData,omitempty"`

	// Specifies information about the virtual machine scale set that the virtual machine should be assigned to. Virtual machines
	// specified in the same virtual machine scale set are allocated to different
	// nodes to maximize availability. Currently, a VM can only be added to virtual machine scale set at creation time. An existing
	// VM cannot be added to a virtual machine scale set.
	// This property cannot exist along with a non-null properties.availabilitySet reference.
	// Minimum api‐version: 2019‐03‐01
	VirtualMachineScaleSet *SubResource `json:"virtualMachineScaleSet,omitempty"`

	// READ-ONLY; The virtual machine instance view.
	InstanceView *VirtualMachineInstanceView `json:"instanceView,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the time at which the Virtual Machine resource was created.
	// Minimum api-version: 2021-11-01.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the VM unique ID which is a 128-bits identifier that is encoded and stored in all Azure IaaS VMs SMBIOS
	// and can be read using platform BIOS commands.
	VMID *string `json:"vmId,omitempty" azure:"ro"`
}

// VirtualMachinePublicIPAddressConfiguration - Describes a virtual machines IP Configuration's PublicIPAddress configuration
type VirtualMachinePublicIPAddressConfiguration struct {
	// REQUIRED; The publicIP address configuration name.
	Name *string `json:"name,omitempty"`

	// Describes a virtual machines IP Configuration's PublicIPAddress configuration
	Properties *VirtualMachinePublicIPAddressConfigurationProperties `json:"properties,omitempty"`

	// Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
	SKU *PublicIPAddressSKU `json:"sku,omitempty"`
}

// VirtualMachinePublicIPAddressConfigurationProperties - Describes a virtual machines IP Configuration's PublicIPAddress
// configuration
type VirtualMachinePublicIPAddressConfigurationProperties struct {
	// The dns settings to be applied on the publicIP addresses .
	DNSSettings *VirtualMachinePublicIPAddressDNSSettingsConfiguration `json:"dnsSettings,omitempty"`

	// Specify what happens to the public IP address when the VM is deleted
	DeleteOption *DeleteOptions `json:"deleteOption,omitempty"`

	// The list of IP tags associated with the public IP address.
	IPTags []*VirtualMachineIPTag `json:"ipTags,omitempty"`

	// The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default
	// is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
	PublicIPAddressVersion *IPVersions `json:"publicIPAddressVersion,omitempty"`

	// Specify the public IP allocation type
	PublicIPAllocationMethod *PublicIPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`

	// The PublicIPPrefix from which to allocate publicIP addresses.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
}

// VirtualMachinePublicIPAddressDNSSettingsConfiguration - Describes a virtual machines network configuration's DNS settings.
type VirtualMachinePublicIPAddressDNSSettingsConfiguration struct {
	// REQUIRED; The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label
	// is the concatenation of the domain name label and vm network profile unique ID.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
}

// VirtualMachineReimageParameters - Parameters for Reimaging Virtual Machine. NOTE: Virtual Machine OS disk will always be
// reimaged
type VirtualMachineReimageParameters struct {
	// Specifies whether to reimage temp disk. Default value: false. Note: This temp disk reimage parameter is only supported
	// for VM/VMSS with Ephemeral OS disk.
	TempDisk *bool `json:"tempDisk,omitempty"`
}

// VirtualMachineRunCommand - Describes a Virtual Machine run command.
type VirtualMachineRunCommand struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Describes the properties of a Virtual Machine run command.
	Properties *VirtualMachineRunCommandProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineRunCommandInstanceView - The instance view of a virtual machine run command.
type VirtualMachineRunCommandInstanceView struct {
	// Script end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Script error stream.
	Error *string `json:"error,omitempty"`

	// Communicate script configuration errors or execution messages.
	ExecutionMessage *string `json:"executionMessage,omitempty"`

	// Script execution status.
	ExecutionState *ExecutionState `json:"executionState,omitempty"`

	// Exit code returned from script execution.
	ExitCode *int32 `json:"exitCode,omitempty"`

	// Script output stream.
	Output *string `json:"output,omitempty"`

	// Script start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`
}

// VirtualMachineRunCommandProperties - Describes the properties of a Virtual Machine run command.
type VirtualMachineRunCommandProperties struct {
	// Optional. If set to true, provisioning will complete as soon as the script starts and will not wait for script to complete.
	AsyncExecution *bool `json:"asyncExecution,omitempty"`

	// Specifies the Azure storage blob where script error stream will be uploaded.
	ErrorBlobURI *string `json:"errorBlobUri,omitempty"`

	// Specifies the Azure storage blob where script output stream will be uploaded.
	OutputBlobURI *string `json:"outputBlobUri,omitempty"`

	// The parameters used by the script.
	Parameters []*RunCommandInputParameter `json:"parameters,omitempty"`

	// The parameters used by the script.
	ProtectedParameters []*RunCommandInputParameter `json:"protectedParameters,omitempty"`

	// Specifies the user account password on the VM when executing the run command.
	RunAsPassword *string `json:"runAsPassword,omitempty"`

	// Specifies the user account on the VM when executing the run command.
	RunAsUser *string `json:"runAsUser,omitempty"`

	// The source of the run command script.
	Source *VirtualMachineRunCommandScriptSource `json:"source,omitempty"`

	// The timeout in seconds to execute the run command.
	TimeoutInSeconds *int32 `json:"timeoutInSeconds,omitempty"`

	// READ-ONLY; The virtual machine run command instance view.
	InstanceView *VirtualMachineRunCommandInstanceView `json:"instanceView,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualMachineRunCommandScriptSource - Describes the script sources for run command.
type VirtualMachineRunCommandScriptSource struct {
	// Specifies a commandId of predefined built-in script.
	CommandID *string `json:"commandId,omitempty"`

	// Specifies the script content to be executed on the VM.
	Script *string `json:"script,omitempty"`

	// Specifies the script download location.
	ScriptURI *string `json:"scriptUri,omitempty"`
}

// VirtualMachineRunCommandUpdate - Describes a Virtual Machine run command.
type VirtualMachineRunCommandUpdate struct {
	// Describes the properties of a Virtual Machine run command.
	Properties *VirtualMachineRunCommandProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineRunCommandsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachineRunCommandsClient.BeginCreateOrUpdate
// method.
type VirtualMachineRunCommandsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineRunCommandsClientBeginDeleteOptions contains the optional parameters for the VirtualMachineRunCommandsClient.BeginDelete
// method.
type VirtualMachineRunCommandsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineRunCommandsClientBeginUpdateOptions contains the optional parameters for the VirtualMachineRunCommandsClient.BeginUpdate
// method.
type VirtualMachineRunCommandsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineRunCommandsClientGetByVirtualMachineOptions contains the optional parameters for the VirtualMachineRunCommandsClient.GetByVirtualMachine
// method.
type VirtualMachineRunCommandsClientGetByVirtualMachineOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineRunCommandsClientGetOptions contains the optional parameters for the VirtualMachineRunCommandsClient.Get
// method.
type VirtualMachineRunCommandsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineRunCommandsClientListByVirtualMachineOptions contains the optional parameters for the VirtualMachineRunCommandsClient.ListByVirtualMachine
// method.
type VirtualMachineRunCommandsClientListByVirtualMachineOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineRunCommandsClientListOptions contains the optional parameters for the VirtualMachineRunCommandsClient.List
// method.
type VirtualMachineRunCommandsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineRunCommandsListResult - The List run command operation response
type VirtualMachineRunCommandsListResult struct {
	// REQUIRED; The list of run commands
	Value []*VirtualMachineRunCommand `json:"value,omitempty"`

	// The uri to fetch the next page of run commands.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSet - Describes a Virtual Machine Scale Set.
type VirtualMachineScaleSet struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The extended location of the Virtual Machine Scale Set.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the virtual machine scale set, if configured.
	Identity *VirtualMachineScaleSetIdentity `json:"identity,omitempty"`

	// Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace
	// images. Before you can use a marketplace image from an API, you must
	// enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click
	// Want to deploy programmatically, Get Started ->. Enter any required
	// information and then click Save.
	Plan *Plan `json:"plan,omitempty"`

	// Describes the properties of a Virtual Machine Scale Set.
	Properties *VirtualMachineScaleSetProperties `json:"properties,omitempty"`

	// The virtual machine scale set sku.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetDataDisk - Describes a virtual machine scale set data disk.
type VirtualMachineScaleSetDataDisk struct {
	// REQUIRED; The create option.
	CreateOption *DiskCreateOptionTypes `json:"createOption,omitempty"`

	// REQUIRED; Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and
	// therefore must be unique for each data disk attached to a VM.
	Lun *int32 `json:"lun,omitempty"`

	// Specifies the caching requirements.
	// Possible values are:
	// None
	// ReadOnly
	// ReadWrite
	// Default: None for Standard storage. ReadOnly for Premium storage
	Caching *CachingTypes `json:"caching,omitempty"`

	// Specifies whether data disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with
	// Flexible OrchestrationMode only).
	// Possible values:
	// Delete If this value is used, the data disk is deleted when the VMSS Flex VM is deleted.
	// Detach If this value is used, the data disk is retained after VMSS Flex VM is deleted.
	// The default value is set to Delete.
	DeleteOption *DiskDeleteOptionTypes `json:"deleteOption,omitempty"`

	// Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not
	// specified, a default value would be assigned based on diskSizeGB.
	DiskIOPSReadWrite *int64 `json:"diskIOPSReadWrite,omitempty"`

	// Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS.
	// If not specified, a default value would be assigned based on diskSizeGB.
	DiskMBpsReadWrite *int64 `json:"diskMBpsReadWrite,omitempty"`

	// Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a
	// virtual machine image.
	// diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// The managed disk parameters.
	ManagedDisk *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`

	// The disk name.
	Name *string `json:"name,omitempty"`

	// Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
}

// VirtualMachineScaleSetExtension - Describes a Virtual Machine Scale Set Extension.
type VirtualMachineScaleSetExtension struct {
	// The name of the extension.
	Name *string `json:"name,omitempty"`

	// Describes the properties of a Virtual Machine Scale Set Extension.
	Properties *VirtualMachineScaleSetExtensionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetExtensionListResult - The List VM scale set extension operation response.
type VirtualMachineScaleSetExtensionListResult struct {
	// REQUIRED; The list of VM scale set extensions.
	Value []*VirtualMachineScaleSetExtension `json:"value,omitempty"`

	// The uri to fetch the next page of VM scale set extensions. Call ListNext() with this to fetch the next page of VM scale
	// set extensions.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetExtensionProfile - Describes a virtual machine scale set extension profile.
type VirtualMachineScaleSetExtensionProfile struct {
	// The virtual machine scale set child extension resources.
	Extensions []*VirtualMachineScaleSetExtension `json:"extensions,omitempty"`

	// Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes
	// (inclusive) and should be specified in ISO 8601 format. The default value is 90
	// minutes (PT1H30M).
	// Minimum api-version: 2020-06-01
	ExtensionsTimeBudget *string `json:"extensionsTimeBudget,omitempty"`
}

// VirtualMachineScaleSetExtensionProperties - Describes the properties of a Virtual Machine Scale Set Extension.
type VirtualMachineScaleSetExtensionProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension
	// available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`

	// If a value is provided and is different from the previous value, the extension handler will be forced to update even if
	// the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// The extensions protected settings that are passed by reference, and consumed from key vault
	ProtectedSettingsFromKeyVault *KeyVaultSecretReference `json:"protectedSettingsFromKeyVault,omitempty"`

	// Collection of extension names after which this extension needs to be provisioned.
	ProvisionAfterExtensions []*string `json:"provisionAfterExtensions,omitempty"`

	// The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`

	// Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting
	// to the VM will not be suppressed regardless of this value). The default is false.
	SuppressFailures *bool `json:"suppressFailures,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetExtensionUpdate - Describes a Virtual Machine Scale Set Extension.
type VirtualMachineScaleSetExtensionUpdate struct {
	// Describes the properties of a Virtual Machine Scale Set Extension.
	Properties *VirtualMachineScaleSetExtensionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the extension.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetExtensionsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachineScaleSetExtensionsClient.BeginCreateOrUpdate
// method.
type VirtualMachineScaleSetExtensionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetExtensionsClientBeginDeleteOptions contains the optional parameters for the VirtualMachineScaleSetExtensionsClient.BeginDelete
// method.
type VirtualMachineScaleSetExtensionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetExtensionsClientBeginUpdateOptions contains the optional parameters for the VirtualMachineScaleSetExtensionsClient.BeginUpdate
// method.
type VirtualMachineScaleSetExtensionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetExtensionsClientGetOptions contains the optional parameters for the VirtualMachineScaleSetExtensionsClient.Get
// method.
type VirtualMachineScaleSetExtensionsClientGetOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineScaleSetExtensionsClientListOptions contains the optional parameters for the VirtualMachineScaleSetExtensionsClient.List
// method.
type VirtualMachineScaleSetExtensionsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetHardwareProfile - Specifies the hardware settings for the virtual machine scale set.
type VirtualMachineScaleSetHardwareProfile struct {
	// Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01.
	// Please follow the instructions in VM Customization [https://aka.ms/vmcustomization] for more details.
	VMSizeProperties *VMSizeProperties `json:"vmSizeProperties,omitempty"`
}

// VirtualMachineScaleSetIPConfiguration - Describes a virtual machine scale set network profile's IP configuration.
type VirtualMachineScaleSetIPConfiguration struct {
	// REQUIRED; The IP configuration name.
	Name *string `json:"name,omitempty"`

	// Resource Id
	ID *string `json:"id,omitempty"`

	// Describes a virtual machine scale set network profile's IP configuration properties.
	Properties *VirtualMachineScaleSetIPConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetIPConfigurationProperties - Describes a virtual machine scale set network profile's IP configuration
// properties.
type VirtualMachineScaleSetIPConfigurationProperties struct {
	// Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address
	// pools of multiple application gateways. Multiple scale sets cannot use the
	// same application gateway.
	ApplicationGatewayBackendAddressPools []*SubResource `json:"applicationGatewayBackendAddressPools,omitempty"`

	// Specifies an array of references to application security group.
	ApplicationSecurityGroups []*SubResource `json:"applicationSecurityGroups,omitempty"`

	// Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address
	// pools of one public and one internal load balancer. Multiple scale sets cannot
	// use the same basic sku load balancer.
	LoadBalancerBackendAddressPools []*SubResource `json:"loadBalancerBackendAddressPools,omitempty"`

	// Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools
	// of one public and one internal load balancer. Multiple scale sets cannot use
	// the same basic sku load balancer.
	LoadBalancerInboundNatPools []*SubResource `json:"loadBalancerInboundNatPools,omitempty"`

	// Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`

	// Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default
	// is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
	PrivateIPAddressVersion *IPVersion `json:"privateIPAddressVersion,omitempty"`

	// The publicIPAddressConfiguration.
	PublicIPAddressConfiguration *VirtualMachineScaleSetPublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`

	// Specifies the identifier of the subnet.
	Subnet *APIEntityReference `json:"subnet,omitempty"`
}

// VirtualMachineScaleSetIPTag - Contains the IP tag associated with the public IP address.
type VirtualMachineScaleSetIPTag struct {
	// IP tag type. Example: FirstPartyUsage.
	IPTagType *string `json:"ipTagType,omitempty"`

	// IP tag associated with the public IP. Example: SQL, Storage etc.
	Tag *string `json:"tag,omitempty"`
}

// VirtualMachineScaleSetIdentity - Identity for the virtual machine scale set.
type VirtualMachineScaleSetIdentity struct {
	// The type of identity used for the virtual machine scale set. The type 'SystemAssigned, UserAssigned' includes both an implicitly
	// created identity and a set of user assigned identities. The type 'None'
	// will remove any identities from the virtual machine scale set.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the virtual machine scale set. The user identity dictionary key references
	// will be ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of virtual machine scale set identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id associated with the virtual machine scale set. This property will only be provided for a system
	// assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetInstanceView - The instance view of a virtual machine scale set.
type VirtualMachineScaleSetInstanceView struct {
	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// READ-ONLY; The extensions information.
	Extensions []*VirtualMachineScaleSetVMExtensionsSummary `json:"extensions,omitempty" azure:"ro"`

	// READ-ONLY; The orchestration services information.
	OrchestrationServices []*OrchestrationServiceSummary `json:"orchestrationServices,omitempty" azure:"ro"`

	// READ-ONLY; The instance view status summary for the virtual machine scale set.
	VirtualMachine *VirtualMachineScaleSetInstanceViewStatusesSummary `json:"virtualMachine,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetInstanceViewStatusesSummary - Instance view statuses summary for virtual machines of a virtual machine
// scale set.
type VirtualMachineScaleSetInstanceViewStatusesSummary struct {
	// READ-ONLY; The extensions information.
	StatusesSummary []*VirtualMachineStatusCodeCount `json:"statusesSummary,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetListOSUpgradeHistory - List of Virtual Machine Scale Set OS Upgrade History operation response.
type VirtualMachineScaleSetListOSUpgradeHistory struct {
	// REQUIRED; The list of OS upgrades performed on the virtual machine scale set.
	Value []*UpgradeOperationHistoricalStatusInfo `json:"value,omitempty"`

	// The uri to fetch the next page of OS Upgrade History. Call ListNext() with this to fetch the next page of history of upgrades.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListResult - The List Virtual Machine operation response.
type VirtualMachineScaleSetListResult struct {
	// REQUIRED; The list of virtual machine scale sets.
	Value []*VirtualMachineScaleSet `json:"value,omitempty"`

	// The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with this to fetch the next page of VMSS.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListSKUsResult - The Virtual Machine Scale Set List Skus operation response.
type VirtualMachineScaleSetListSKUsResult struct {
	// REQUIRED; The list of skus available for the virtual machine scale set.
	Value []*VirtualMachineScaleSetSKU `json:"value,omitempty"`

	// The uri to fetch the next page of Virtual Machine Scale Set Skus. Call ListNext() with this to fetch the next page of VMSS
	// Skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListWithLinkResult - The List Virtual Machine operation response.
type VirtualMachineScaleSetListWithLinkResult struct {
	// REQUIRED; The list of virtual machine scale sets.
	Value []*VirtualMachineScaleSet `json:"value,omitempty"`

	// The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with this to fetch the next page of Virtual
	// Machine Scale Sets.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetManagedDiskParameters - Describes the parameters of a ScaleSet managed disk.
type VirtualMachineScaleSetManagedDiskParameters struct {
	// Specifies the customer managed disk encryption set resource id for the managed disk.
	DiskEncryptionSet *DiskEncryptionSetParameters `json:"diskEncryptionSet,omitempty"`

	// Specifies the security profile for the managed disk.
	SecurityProfile *VMDiskSecurityProfile `json:"securityProfile,omitempty"`

	// Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot
	// be used with OS Disk.
	StorageAccountType *StorageAccountTypes `json:"storageAccountType,omitempty"`
}

// VirtualMachineScaleSetNetworkConfiguration - Describes a virtual machine scale set network profile's network configurations.
type VirtualMachineScaleSetNetworkConfiguration struct {
	// REQUIRED; The network configuration name.
	Name *string `json:"name,omitempty"`

	// Resource Id
	ID *string `json:"id,omitempty"`

	// Describes a virtual machine scale set network profile's IP configuration.
	Properties *VirtualMachineScaleSetNetworkConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetNetworkConfigurationDNSSettings - Describes a virtual machines scale sets network configuration's
// DNS settings.
type VirtualMachineScaleSetNetworkConfigurationDNSSettings struct {
	// List of DNS servers IP addresses
	DNSServers []*string `json:"dnsServers,omitempty"`
}

// VirtualMachineScaleSetNetworkConfigurationProperties - Describes a virtual machine scale set network profile's IP configuration.
type VirtualMachineScaleSetNetworkConfigurationProperties struct {
	// REQUIRED; Specifies the IP configurations of the network interface.
	IPConfigurations []*VirtualMachineScaleSetIPConfiguration `json:"ipConfigurations,omitempty"`

	// The dns settings to be applied on the network interfaces.
	DNSSettings *VirtualMachineScaleSetNetworkConfigurationDNSSettings `json:"dnsSettings,omitempty"`

	// Specify what happens to the network interface when the VM is deleted
	DeleteOption *DeleteOptions `json:"deleteOption,omitempty"`

	// Specifies whether the network interface is disabled for tcp state tracking.
	DisableTCPStateTracking *bool `json:"disableTcpStateTracking,omitempty"`

	// Specifies whether the network interface is accelerated networking-enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`

	// Specifies whether the network interface is FPGA networking-enabled.
	EnableFpga *bool `json:"enableFpga,omitempty"`

	// Whether IP forwarding enabled on this NIC.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`

	// The network security group.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`

	// Specifies the primary network interface in case the virtual machine has more than 1 network interface.
	Primary *bool `json:"primary,omitempty"`
}

// VirtualMachineScaleSetNetworkProfile - Describes a virtual machine scale set network profile.
type VirtualMachineScaleSetNetworkProfile struct {
	// A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The
	// reference will be in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
	HealthProbe *APIEntityReference `json:"healthProbe,omitempty"`

	// specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
	// for Virtual Machine Scale Set with orchestration mode 'Flexible'
	NetworkAPIVersion *NetworkAPIVersion `json:"networkApiVersion,omitempty"`

	// The list of network configurations.
	NetworkInterfaceConfigurations []*VirtualMachineScaleSetNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
}

// VirtualMachineScaleSetOSDisk - Describes a virtual machine scale set operating system disk.
type VirtualMachineScaleSetOSDisk struct {
	// REQUIRED; Specifies how the virtual machines in the scale set should be created.
	// The only allowed value is: FromImage \u2013 This value is used when you are using an image to create the virtual machine.
	// If you are using a platform image, you also use the imageReference element
	// described above. If you are using a marketplace image, you also use the plan element previously described.
	CreateOption *DiskCreateOptionTypes `json:"createOption,omitempty"`

	// Specifies the caching requirements.
	// Possible values are:
	// None
	// ReadOnly
	// ReadWrite
	// Default: None for Standard storage. ReadOnly for Premium storage
	Caching *CachingTypes `json:"caching,omitempty"`

	// Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with
	// Flexible OrchestrationMode only).
	// Possible values:
	// Delete If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.
	// Detach If this value is used, the OS disk is retained after VMSS Flex VM is deleted.
	// The default value is set to Delete. For an Ephemeral OS Disk, the default value is set to Delete. User cannot change the
	// delete option for Ephemeral OS Disk.
	DeleteOption *DiskDeleteOptionTypes `json:"deleteOption,omitempty"`

	// Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.
	DiffDiskSettings *DiffDiskSettings `json:"diffDiskSettings,omitempty"`

	// Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a
	// virtual machine image.
	// diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Specifies information about the unmanaged user image to base the scale set on.
	Image *VirtualHardDisk `json:"image,omitempty"`

	// The managed disk parameters.
	ManagedDisk *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`

	// The disk name.
	Name *string `json:"name,omitempty"`

	// This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or
	// a specialized VHD.
	// Possible values are:
	// Windows
	// Linux
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// Specifies the container urls that are used to store operating system disks for the scale set.
	VhdContainers []*string `json:"vhdContainers,omitempty"`

	// Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
}

// VirtualMachineScaleSetOSProfile - Describes a virtual machine scale set OS profile.
type VirtualMachineScaleSetOSProfile struct {
	// Specifies the password of the administrator account.
	// Minimum-length (Windows): 8 characters
	// Minimum-length (Linux): 6 characters
	// Max-length (Windows): 123 characters
	// Max-length (Linux): 72 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
	// "Password22", "iloveyou!"
	// For resetting the password, see How to reset the Remote Desktop service or its login password in a Windows VM [https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp]
	// For resetting root password, see Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension
	// [https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection]
	AdminPassword *string `json:"adminPassword,omitempty"`

	// Specifies the name of the administrator account.
	// Windows-only restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length (Linux): 1 character
	// Max-length (Linux): 64 characters
	// Max-length (Windows): 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`

	// Specifies whether extension operations should be allowed on the virtual machine scale set.
	// This may only be set to False when no extensions are present on the virtual machine scale set.
	AllowExtensionOperations *bool `json:"allowExtensionOperations,omitempty"`

	// Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to
	// 15 characters long.
	ComputerNamePrefix *string `json:"computerNamePrefix,omitempty"`

	// Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved
	// as a file on the Virtual Machine. The maximum length of the binary array is
	// 65535 bytes.
	// For using cloud-init for your VM, see Using cloud-init to customize a Linux VM during creation [https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init]
	CustomData *string `json:"customData,omitempty"`

	// Specifies the Linux operating system settings on the virtual machine.
	// For a list of supported Linux distributions, see Linux on Azure-Endorsed Distributions [https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros].
	LinuxConfiguration *LinuxConfiguration `json:"linuxConfiguration,omitempty"`

	// Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates
	// on a virtual machine it is recommended to use the Azure Key Vault virtual
	// machine extension for Linux [https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux] or the Azure
	// Key Vault virtual machine extension for Windows
	// [https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows].
	Secrets []*VaultSecretGroup `json:"secrets,omitempty"`

	// Specifies Windows operating system settings on the virtual machine.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
}

// VirtualMachineScaleSetProperties - Describes the properties of a Virtual Machine Scale Set.
type VirtualMachineScaleSetProperties struct {
	// Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance:
	// whether the Virtual Machines have the capability to support attaching
	// managed data disks with UltraSSD_LRS storage account type.
	AdditionalCapabilities *AdditionalCapabilities `json:"additionalCapabilities,omitempty"`

	// Policy for automatic repairs.
	AutomaticRepairsPolicy *AutomaticRepairsPolicy `json:"automaticRepairsPolicy,omitempty"`

	// When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This
	// property will hence ensure that the extensions do not run on the extra
	// overprovisioned VMs.
	DoNotRunExtensionsOnOverprovisionedVMs *bool `json:"doNotRunExtensionsOnOverprovisionedVMs,omitempty"`

	// Specifies information about the dedicated host group that the virtual machine scale set resides in.
	// Minimum api-version: 2020-06-01.
	HostGroup *SubResource `json:"hostGroup,omitempty"`

	// Specifies the orchestration mode for the virtual machine scale set.
	OrchestrationMode *OrchestrationMode `json:"orchestrationMode,omitempty"`

	// Specifies whether the Virtual Machine Scale Set should be overprovisioned.
	Overprovision *bool `json:"overprovision,omitempty"`

	// Fault Domain count for each placement group.
	PlatformFaultDomainCount *int32 `json:"platformFaultDomainCount,omitempty"`

	// Specifies the desired targets for mixing Spot and Regular priority VMs within the same VMSS Flex instance.
	PriorityMixPolicy *PriorityMixPolicy `json:"priorityMixPolicy,omitempty"`

	// Specifies information about the proximity placement group that the virtual machine scale set should be assigned to.
	// Minimum api-version: 2018-04-01.
	ProximityPlacementGroup *SubResource `json:"proximityPlacementGroup,omitempty"`

	// Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
	ScaleInPolicy *ScaleInPolicy `json:"scaleInPolicy,omitempty"`

	// When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup
	// is true, it may be modified to false. However, if singlePlacementGroup
	// is false, it may not be modified to true.
	SinglePlacementGroup *bool `json:"singlePlacementGroup,omitempty"`

	// Specifies the Spot Restore properties for the virtual machine scale set.
	SpotRestorePolicy *SpotRestorePolicy `json:"spotRestorePolicy,omitempty"`

	// The upgrade policy.
	UpgradePolicy *UpgradePolicy `json:"upgradePolicy,omitempty"`

	// The virtual machine profile.
	VirtualMachineProfile *VirtualMachineScaleSetVMProfile `json:"virtualMachineProfile,omitempty"`

	// Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property
	// can only be set if the zones property of the scale set contains more than
	// one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
	ZoneBalance *bool `json:"zoneBalance,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the time at which the Virtual Machine Scale Set resource was created.
	// Minimum api-version: 2021-11-01.
	TimeCreated *time.Time `json:"timeCreated,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
	UniqueID *string `json:"uniqueId,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetPublicIPAddressConfiguration - Describes a virtual machines scale set IP Configuration's PublicIPAddress
// configuration
type VirtualMachineScaleSetPublicIPAddressConfiguration struct {
	// REQUIRED; The publicIP address configuration name.
	Name *string `json:"name,omitempty"`

	// Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
	Properties *VirtualMachineScaleSetPublicIPAddressConfigurationProperties `json:"properties,omitempty"`

	// Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
	SKU *PublicIPAddressSKU `json:"sku,omitempty"`
}

// VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings - Describes a virtual machines scale sets network configuration's
// DNS settings.
type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings struct {
	// REQUIRED; The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels
	// of the PublicIPAddress resources that will be created
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
}

// VirtualMachineScaleSetPublicIPAddressConfigurationProperties - Describes a virtual machines scale set IP Configuration's
// PublicIPAddress configuration
type VirtualMachineScaleSetPublicIPAddressConfigurationProperties struct {
	// The dns settings to be applied on the publicIP addresses .
	DNSSettings *VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings `json:"dnsSettings,omitempty"`

	// Specify what happens to the public IP when the VM is deleted
	DeleteOption *DeleteOptions `json:"deleteOption,omitempty"`

	// The list of IP tags associated with the public IP address.
	IPTags []*VirtualMachineScaleSetIPTag `json:"ipTags,omitempty"`

	// The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default
	// is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
	PublicIPAddressVersion *IPVersion `json:"publicIPAddressVersion,omitempty"`

	// The PublicIPPrefix from which to allocate publicIP addresses.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
}

// VirtualMachineScaleSetReimageParameters - Describes a Virtual Machine Scale Set VM Reimage Parameters.
type VirtualMachineScaleSetReimageParameters struct {
	// The virtual machine scale set instance ids. Omitting the virtual machine scale set instance ids will result in the operation
	// being performed on all virtual machines in the virtual machine scale set.
	InstanceIDs []*string `json:"instanceIds,omitempty"`

	// Specifies whether to reimage temp disk. Default value: false. Note: This temp disk reimage parameter is only supported
	// for VM/VMSS with Ephemeral OS disk.
	TempDisk *bool `json:"tempDisk,omitempty"`
}

// VirtualMachineScaleSetRollingUpgradesClientBeginCancelOptions contains the optional parameters for the VirtualMachineScaleSetRollingUpgradesClient.BeginCancel
// method.
type VirtualMachineScaleSetRollingUpgradesClientBeginCancelOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetRollingUpgradesClientBeginStartExtensionUpgradeOptions contains the optional parameters for the VirtualMachineScaleSetRollingUpgradesClient.BeginStartExtensionUpgrade
// method.
type VirtualMachineScaleSetRollingUpgradesClientBeginStartExtensionUpgradeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetRollingUpgradesClientBeginStartOSUpgradeOptions contains the optional parameters for the VirtualMachineScaleSetRollingUpgradesClient.BeginStartOSUpgrade
// method.
type VirtualMachineScaleSetRollingUpgradesClientBeginStartOSUpgradeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetRollingUpgradesClientGetLatestOptions contains the optional parameters for the VirtualMachineScaleSetRollingUpgradesClient.GetLatest
// method.
type VirtualMachineScaleSetRollingUpgradesClientGetLatestOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetSKU - Describes an available virtual machine scale set sku.
type VirtualMachineScaleSetSKU struct {
	// READ-ONLY; Specifies the number of virtual machines in the scale set.
	Capacity *VirtualMachineScaleSetSKUCapacity `json:"capacity,omitempty" azure:"ro"`

	// READ-ONLY; The type of resource the sku applies to.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The Sku.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetSKUCapacity - Describes scaling information of a sku.
type VirtualMachineScaleSetSKUCapacity struct {
	// READ-ONLY; The default capacity.
	DefaultCapacity *int64 `json:"defaultCapacity,omitempty" azure:"ro"`

	// READ-ONLY; The maximum capacity that can be set.
	Maximum *int64 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The minimum capacity.
	Minimum *int64 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The scale type applicable to the sku.
	ScaleType *VirtualMachineScaleSetSKUScaleType `json:"scaleType,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetStorageProfile - Describes a virtual machine scale set storage profile.
type VirtualMachineScaleSetStorageProfile struct {
	// Specifies the parameters that are used to add data disks to the virtual machines in the scale set.
	// For more information about disks, see About disks and VHDs for Azure virtual machines [https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview].
	DataDisks          []*VirtualMachineScaleSetDataDisk `json:"dataDisks,omitempty"`
	DiskControllerType *string                           `json:"diskControllerType,omitempty"`

	// Specifies information about the image to use. You can specify information about platform images, marketplace images, or
	// virtual machine images. This element is required when you want to use a platform
	// image, marketplace image, or virtual machine image, but is not used in other creation operations.
	ImageReference *ImageReference `json:"imageReference,omitempty"`

	// Specifies information about the operating system disk used by the virtual machines in the scale set.
	// For more information about disks, see About disks and VHDs for Azure virtual machines [https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview].
	OSDisk *VirtualMachineScaleSetOSDisk `json:"osDisk,omitempty"`
}

// VirtualMachineScaleSetUpdate - Describes a Virtual Machine Scale Set.
type VirtualMachineScaleSetUpdate struct {
	// The identity of the virtual machine scale set, if configured.
	Identity *VirtualMachineScaleSetIdentity `json:"identity,omitempty"`

	// The purchase plan when deploying a virtual machine scale set from VM Marketplace images.
	Plan *Plan `json:"plan,omitempty"`

	// Describes the properties of a Virtual Machine Scale Set.
	Properties *VirtualMachineScaleSetUpdateProperties `json:"properties,omitempty"`

	// The virtual machine scale set sku.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineScaleSetUpdateIPConfiguration - Describes a virtual machine scale set network profile's IP configuration.
// NOTE: The subnet of a scale set may be modified as long as the original subnet and the new subnet are in the same virtual
// network
type VirtualMachineScaleSetUpdateIPConfiguration struct {
	// Resource Id
	ID *string `json:"id,omitempty"`

	// The IP configuration name.
	Name *string `json:"name,omitempty"`

	// Describes a virtual machine scale set network profile's IP configuration properties.
	Properties *VirtualMachineScaleSetUpdateIPConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetUpdateIPConfigurationProperties - Describes a virtual machine scale set network profile's IP configuration
// properties.
type VirtualMachineScaleSetUpdateIPConfigurationProperties struct {
	// The application gateway backend address pools.
	ApplicationGatewayBackendAddressPools []*SubResource `json:"applicationGatewayBackendAddressPools,omitempty"`

	// Specifies an array of references to application security group.
	ApplicationSecurityGroups []*SubResource `json:"applicationSecurityGroups,omitempty"`

	// The load balancer backend address pools.
	LoadBalancerBackendAddressPools []*SubResource `json:"loadBalancerBackendAddressPools,omitempty"`

	// The load balancer inbound nat pools.
	LoadBalancerInboundNatPools []*SubResource `json:"loadBalancerInboundNatPools,omitempty"`

	// Specifies the primary IP Configuration in case the network interface has more than one IP Configuration.
	Primary *bool `json:"primary,omitempty"`

	// Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default
	// is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
	PrivateIPAddressVersion *IPVersion `json:"privateIPAddressVersion,omitempty"`

	// The publicIPAddressConfiguration.
	PublicIPAddressConfiguration *VirtualMachineScaleSetUpdatePublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`

	// The subnet.
	Subnet *APIEntityReference `json:"subnet,omitempty"`
}

// VirtualMachineScaleSetUpdateNetworkConfiguration - Describes a virtual machine scale set network profile's network configurations.
type VirtualMachineScaleSetUpdateNetworkConfiguration struct {
	// Resource Id
	ID *string `json:"id,omitempty"`

	// The network configuration name.
	Name *string `json:"name,omitempty"`

	// Describes a virtual machine scale set updatable network profile's IP configuration.Use this object for updating network
	// profile's IP Configuration.
	Properties *VirtualMachineScaleSetUpdateNetworkConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetUpdateNetworkConfigurationProperties - Describes a virtual machine scale set updatable network profile's
// IP configuration.Use this object for updating network profile's IP Configuration.
type VirtualMachineScaleSetUpdateNetworkConfigurationProperties struct {
	// The dns settings to be applied on the network interfaces.
	DNSSettings *VirtualMachineScaleSetNetworkConfigurationDNSSettings `json:"dnsSettings,omitempty"`

	// Specify what happens to the network interface when the VM is deleted
	DeleteOption *DeleteOptions `json:"deleteOption,omitempty"`

	// Specifies whether the network interface is disabled for tcp state tracking.
	DisableTCPStateTracking *bool `json:"disableTcpStateTracking,omitempty"`

	// Specifies whether the network interface is accelerated networking-enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`

	// Specifies whether the network interface is FPGA networking-enabled.
	EnableFpga *bool `json:"enableFpga,omitempty"`

	// Whether IP forwarding enabled on this NIC.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`

	// The virtual machine scale set IP Configuration.
	IPConfigurations []*VirtualMachineScaleSetUpdateIPConfiguration `json:"ipConfigurations,omitempty"`

	// The network security group.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`

	// Whether this is a primary NIC on a virtual machine.
	Primary *bool `json:"primary,omitempty"`
}

// VirtualMachineScaleSetUpdateNetworkProfile - Describes a virtual machine scale set network profile.
type VirtualMachineScaleSetUpdateNetworkProfile struct {
	// A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The
	// reference will be in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
	HealthProbe *APIEntityReference `json:"healthProbe,omitempty"`

	// specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
	// for Virtual Machine Scale Set with orchestration mode 'Flexible'
	NetworkAPIVersion *NetworkAPIVersion `json:"networkApiVersion,omitempty"`

	// The list of network configurations.
	NetworkInterfaceConfigurations []*VirtualMachineScaleSetUpdateNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
}

// VirtualMachineScaleSetUpdateOSDisk - Describes virtual machine scale set operating system disk Update Object. This should
// be used for Updating VMSS OS Disk.
type VirtualMachineScaleSetUpdateOSDisk struct {
	// The caching type.
	Caching *CachingTypes `json:"caching,omitempty"`

	// Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with
	// Flexible OrchestrationMode only).
	// Possible values:
	// Delete If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.
	// Detach If this value is used, the OS disk is retained after VMSS Flex VM is deleted.
	// The default value is set to Delete. For an Ephemeral OS Disk, the default value is set to Delete. User cannot change the
	// delete option for Ephemeral OS Disk.
	DeleteOption *DiskDeleteOptionTypes `json:"deleteOption,omitempty"`

	// Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a
	// virtual machine image.
	// diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before using it to attach to the Virtual Machine.
	// If SourceImage is provided, the destination VirtualHardDisk should not
	// exist.
	Image *VirtualHardDisk `json:"image,omitempty"`

	// The managed disk parameters.
	ManagedDisk *VirtualMachineScaleSetManagedDiskParameters `json:"managedDisk,omitempty"`

	// The list of virtual hard disk container uris.
	VhdContainers []*string `json:"vhdContainers,omitempty"`

	// Specifies whether writeAccelerator should be enabled or disabled on the disk.
	WriteAcceleratorEnabled *bool `json:"writeAcceleratorEnabled,omitempty"`
}

// VirtualMachineScaleSetUpdateOSProfile - Describes a virtual machine scale set OS profile.
type VirtualMachineScaleSetUpdateOSProfile struct {
	// A base-64 encoded string of custom data.
	CustomData *string `json:"customData,omitempty"`

	// The Linux Configuration of the OS profile.
	LinuxConfiguration *LinuxConfiguration `json:"linuxConfiguration,omitempty"`

	// The List of certificates for addition to the VM.
	Secrets []*VaultSecretGroup `json:"secrets,omitempty"`

	// The Windows Configuration of the OS profile.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
}

// VirtualMachineScaleSetUpdateProperties - Describes the properties of a Virtual Machine Scale Set.
type VirtualMachineScaleSetUpdateProperties struct {
	// Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance:
	// whether the Virtual Machines have the capability to support attaching
	// managed data disks with UltraSSD_LRS storage account type.
	AdditionalCapabilities *AdditionalCapabilities `json:"additionalCapabilities,omitempty"`

	// Policy for automatic repairs.
	AutomaticRepairsPolicy *AutomaticRepairsPolicy `json:"automaticRepairsPolicy,omitempty"`

	// When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This
	// property will hence ensure that the extensions do not run on the extra
	// overprovisioned VMs.
	DoNotRunExtensionsOnOverprovisionedVMs *bool `json:"doNotRunExtensionsOnOverprovisionedVMs,omitempty"`

	// Specifies whether the Virtual Machine Scale Set should be overprovisioned.
	Overprovision *bool `json:"overprovision,omitempty"`

	// Specifies information about the proximity placement group that the virtual machine scale set should be assigned to.
	// Minimum api-version: 2018-04-01.
	ProximityPlacementGroup *SubResource `json:"proximityPlacementGroup,omitempty"`

	// Specifies the policies applied when scaling in Virtual Machines in the Virtual Machine Scale Set.
	ScaleInPolicy *ScaleInPolicy `json:"scaleInPolicy,omitempty"`

	// When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup
	// is true, it may be modified to false. However, if singlePlacementGroup
	// is false, it may not be modified to true.
	SinglePlacementGroup *bool `json:"singlePlacementGroup,omitempty"`

	// The upgrade policy.
	UpgradePolicy *UpgradePolicy `json:"upgradePolicy,omitempty"`

	// The virtual machine profile.
	VirtualMachineProfile *VirtualMachineScaleSetUpdateVMProfile `json:"virtualMachineProfile,omitempty"`
}

// VirtualMachineScaleSetUpdatePublicIPAddressConfiguration - Describes a virtual machines scale set IP Configuration's PublicIPAddress
// configuration
type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration struct {
	// The publicIP address configuration name.
	Name *string `json:"name,omitempty"`

	// Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
	Properties *VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties - Describes a virtual machines scale set IP Configuration's
// PublicIPAddress configuration
type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties struct {
	// The dns settings to be applied on the publicIP addresses .
	DNSSettings *VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings `json:"dnsSettings,omitempty"`

	// Specify what happens to the public IP when the VM is deleted
	DeleteOption *DeleteOptions `json:"deleteOption,omitempty"`

	// The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// The PublicIPPrefix from which to allocate publicIP addresses.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
}

// VirtualMachineScaleSetUpdateStorageProfile - Describes a virtual machine scale set storage profile.
type VirtualMachineScaleSetUpdateStorageProfile struct {
	// The data disks.
	DataDisks          []*VirtualMachineScaleSetDataDisk `json:"dataDisks,omitempty"`
	DiskControllerType *string                           `json:"diskControllerType,omitempty"`

	// The image reference.
	ImageReference *ImageReference `json:"imageReference,omitempty"`

	// The OS disk.
	OSDisk *VirtualMachineScaleSetUpdateOSDisk `json:"osDisk,omitempty"`
}

// VirtualMachineScaleSetUpdateVMProfile - Describes a virtual machine scale set virtual machine profile.
type VirtualMachineScaleSetUpdateVMProfile struct {
	// Specifies the billing related details of a Azure Spot VMSS.
	// Minimum api-version: 2019-03-01.
	BillingProfile *BillingProfile `json:"billingProfile,omitempty"`

	// The virtual machine scale set diagnostics profile.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`

	// The virtual machine scale set extension profile.
	ExtensionProfile *VirtualMachineScaleSetExtensionProfile `json:"extensionProfile,omitempty"`

	// Specifies the hardware profile related details of a scale set.
	// Minimum api-version: 2021-11-01.
	HardwareProfile *VirtualMachineScaleSetHardwareProfile `json:"hardwareProfile,omitempty"`

	// The license type, which is for bring your own license scenario.
	LicenseType *string `json:"licenseType,omitempty"`

	// The virtual machine scale set network profile.
	NetworkProfile *VirtualMachineScaleSetUpdateNetworkProfile `json:"networkProfile,omitempty"`

	// The virtual machine scale set OS profile.
	OSProfile *VirtualMachineScaleSetUpdateOSProfile `json:"osProfile,omitempty"`

	// Specifies Scheduled Event related configurations.
	ScheduledEventsProfile *ScheduledEventsProfile `json:"scheduledEventsProfile,omitempty"`

	// The virtual machine scale set Security profile
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// The virtual machine scale set storage profile.
	StorageProfile *VirtualMachineScaleSetUpdateStorageProfile `json:"storageProfile,omitempty"`

	// UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here.
	// Minimum api-version: 2021-03-01
	UserData *string `json:"userData,omitempty"`
}

// VirtualMachineScaleSetVM - Describes a virtual machine scale set virtual machine.
type VirtualMachineScaleSetVM struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// The identity of the virtual machine, if configured.
	Identity *VirtualMachineIdentity `json:"identity,omitempty"`

	// Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace
	// images. Before you can use a marketplace image from an API, you must
	// enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click
	// Want to deploy programmatically, Get Started ->. Enter any required
	// information and then click Save.
	Plan *Plan `json:"plan,omitempty"`

	// Describes the properties of a virtual machine scale set virtual machine.
	Properties *VirtualMachineScaleSetVMProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The virtual machine instance ID.
	InstanceID *string `json:"instanceId,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The virtual machine child extension resources.
	Resources []*VirtualMachineExtension `json:"resources,omitempty" azure:"ro"`

	// READ-ONLY; The virtual machine SKU.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The virtual machine zones.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetVMExtension - Describes a VMSS VM Extension.
type VirtualMachineScaleSetVMExtension struct {
	// Describes the properties of a Virtual Machine Extension.
	Properties *VirtualMachineExtensionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the extension.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetVMExtensionUpdate - Describes a VMSS VM Extension.
type VirtualMachineScaleSetVMExtensionUpdate struct {
	// Describes the properties of a Virtual Machine Extension.
	Properties *VirtualMachineExtensionUpdateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the extension.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetVMExtensionsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachineScaleSetVMExtensionsClient.BeginCreateOrUpdate
// method.
type VirtualMachineScaleSetVMExtensionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMExtensionsClientBeginDeleteOptions contains the optional parameters for the VirtualMachineScaleSetVMExtensionsClient.BeginDelete
// method.
type VirtualMachineScaleSetVMExtensionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMExtensionsClientBeginUpdateOptions contains the optional parameters for the VirtualMachineScaleSetVMExtensionsClient.BeginUpdate
// method.
type VirtualMachineScaleSetVMExtensionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMExtensionsClientGetOptions contains the optional parameters for the VirtualMachineScaleSetVMExtensionsClient.Get
// method.
type VirtualMachineScaleSetVMExtensionsClientGetOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineScaleSetVMExtensionsClientListOptions contains the optional parameters for the VirtualMachineScaleSetVMExtensionsClient.List
// method.
type VirtualMachineScaleSetVMExtensionsClientListOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineScaleSetVMExtensionsListResult - The List VMSS VM Extension operation response
type VirtualMachineScaleSetVMExtensionsListResult struct {
	// The list of VMSS VM extensions
	Value []*VirtualMachineScaleSetVMExtension `json:"value,omitempty"`
}

// VirtualMachineScaleSetVMExtensionsSummary - Extensions summary for virtual machines of a virtual machine scale set.
type VirtualMachineScaleSetVMExtensionsSummary struct {
	// READ-ONLY; The extension name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The extensions information.
	StatusesSummary []*VirtualMachineStatusCodeCount `json:"statusesSummary,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetVMInstanceIDs - Specifies a list of virtual machine instance IDs from the VM scale set.
type VirtualMachineScaleSetVMInstanceIDs struct {
	// The virtual machine scale set instance ids. Omitting the virtual machine scale set instance ids will result in the operation
	// being performed on all virtual machines in the virtual machine scale set.
	InstanceIDs []*string `json:"instanceIds,omitempty"`
}

// VirtualMachineScaleSetVMInstanceRequiredIDs - Specifies a list of virtual machine instance IDs from the VM scale set.
type VirtualMachineScaleSetVMInstanceRequiredIDs struct {
	// REQUIRED; The virtual machine scale set instance ids.
	InstanceIDs []*string `json:"instanceIds,omitempty"`
}

// VirtualMachineScaleSetVMInstanceView - The instance view of a virtual machine scale set VM.
type VirtualMachineScaleSetVMInstanceView struct {
	// Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status.
	// You can easily view the output of your console log.
	// Azure also enables you to see a screenshot of the VM from the hypervisor.
	BootDiagnostics *BootDiagnosticsInstanceView `json:"bootDiagnostics,omitempty"`

	// The disks information.
	Disks []*DiskInstanceView `json:"disks,omitempty"`

	// The extensions information.
	Extensions []*VirtualMachineExtensionInstanceView `json:"extensions,omitempty"`

	// The Maintenance Operation status on the virtual machine.
	MaintenanceRedeployStatus *MaintenanceRedeployStatus `json:"maintenanceRedeployStatus,omitempty"`

	// The placement group in which the VM is running. If the VM is deallocated it will not have a placementGroupId.
	PlacementGroupID *string `json:"placementGroupId,omitempty"`

	// The Fault Domain count.
	PlatformFaultDomain *int32 `json:"platformFaultDomain,omitempty"`

	// The Update Domain count.
	PlatformUpdateDomain *int32 `json:"platformUpdateDomain,omitempty"`

	// The Remote desktop certificate thumbprint.
	RdpThumbPrint *string `json:"rdpThumbPrint,omitempty"`

	// The resource status information.
	Statuses []*InstanceViewStatus `json:"statuses,omitempty"`

	// The VM Agent running on the virtual machine.
	VMAgent *VirtualMachineAgentInstanceView `json:"vmAgent,omitempty"`

	// READ-ONLY; Resource id of the dedicated host, on which the virtual machine is allocated through automatic placement, when
	// the virtual machine is associated with a dedicated host group that has automatic
	// placement enabled.
	// Minimum api-version: 2020-06-01.
	AssignedHost *string `json:"assignedHost,omitempty" azure:"ro"`

	// READ-ONLY; The health status for the VM.
	VMHealth *VirtualMachineHealthStatus `json:"vmHealth,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetVMListResult - The List Virtual Machine Scale Set VMs operation response.
type VirtualMachineScaleSetVMListResult struct {
	// REQUIRED; The list of virtual machine scale sets VMs.
	Value []*VirtualMachineScaleSetVM `json:"value,omitempty"`

	// The uri to fetch the next page of Virtual Machine Scale Set VMs. Call ListNext() with this to fetch the next page of VMSS
	// VMs
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetVMNetworkProfileConfiguration - Describes a virtual machine scale set VM network profile.
type VirtualMachineScaleSetVMNetworkProfileConfiguration struct {
	// The list of network configurations.
	NetworkInterfaceConfigurations []*VirtualMachineScaleSetNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
}

// VirtualMachineScaleSetVMProfile - Describes a virtual machine scale set virtual machine profile.
type VirtualMachineScaleSetVMProfile struct {
	// Specifies the gallery applications that should be made available to the VM/VMSS
	ApplicationProfile *ApplicationProfile `json:"applicationProfile,omitempty"`

	// Specifies the billing related details of a Azure Spot VMSS.
	// Minimum api-version: 2019-03-01.
	BillingProfile *BillingProfile `json:"billingProfile,omitempty"`

	// Specifies the capacity reservation related details of a scale set.
	// Minimum api-version: 2021-04-01.
	CapacityReservation *CapacityReservationProfile `json:"capacityReservation,omitempty"`

	// Specifies the boot diagnostic settings state.
	// Minimum api-version: 2015-06-15.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`

	// Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set.
	// For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
	// For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
	EvictionPolicy *VirtualMachineEvictionPolicyTypes `json:"evictionPolicy,omitempty"`

	// Specifies a collection of settings for extensions installed on virtual machines in the scale set.
	ExtensionProfile *VirtualMachineScaleSetExtensionProfile `json:"extensionProfile,omitempty"`

	// Specifies the hardware profile related details of a scale set.
	// Minimum api-version: 2021-11-01.
	HardwareProfile *VirtualMachineScaleSetHardwareProfile `json:"hardwareProfile,omitempty"`

	// Specifies that the image or disk that is being used was licensed on-premises.
	// Possible values for Windows Server operating system are:
	// WindowsClient
	// WindowsServer
	// Possible values for Linux Server operating system are:
	// RHELBYOS (for RHEL)
	// SLESBYOS (for SUSE)
	// For more information, see Azure Hybrid Use Benefit for Windows Server [https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing]
	// Azure Hybrid Use Benefit for Linux Server [https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux]
	// Minimum api-version: 2015-06-15
	LicenseType *string `json:"licenseType,omitempty"`

	// Specifies properties of the network interfaces of the virtual machines in the scale set.
	NetworkProfile *VirtualMachineScaleSetNetworkProfile `json:"networkProfile,omitempty"`

	// Specifies the operating system settings for the virtual machines in the scale set.
	OSProfile *VirtualMachineScaleSetOSProfile `json:"osProfile,omitempty"`

	// Specifies the priority for the virtual machines in the scale set.
	// Minimum api-version: 2017-10-30-preview
	Priority *VirtualMachinePriorityTypes `json:"priority,omitempty"`

	// Specifies Scheduled Event related configurations.
	ScheduledEventsProfile *ScheduledEventsProfile `json:"scheduledEventsProfile,omitempty"`

	// Specifies the Security related profile settings for the virtual machines in the scale set.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// Specifies the storage settings for the virtual machine disks.
	StorageProfile *VirtualMachineScaleSetStorageProfile `json:"storageProfile,omitempty"`

	// UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets
	// in here.
	// Minimum api-version: 2021-03-01
	UserData *string `json:"userData,omitempty"`
}

// VirtualMachineScaleSetVMProperties - Describes the properties of a virtual machine scale set virtual machine.
type VirtualMachineScaleSetVMProperties struct {
	// Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the
	// virtual machine has the capability to support attaching managed data disks with
	// UltraSSD_LRS storage account type.
	AdditionalCapabilities *AdditionalCapabilities `json:"additionalCapabilities,omitempty"`

	// Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified
	// in the same availability set are allocated to different nodes to maximize
	// availability. For more information about availability sets, see Availability sets overview [https://docs.microsoft.com/azure/virtual-machines/availability-set-overview].
	// For more information on Azure planned maintenance, see Maintenance and updates for Virtual Machines in Azure [https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates]
	// Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability
	// set.
	AvailabilitySet *SubResource `json:"availabilitySet,omitempty"`

	// Specifies the boot diagnostic settings state.
	// Minimum api-version: 2015-06-15.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`

	// Specifies the hardware settings for the virtual machine.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`

	// Specifies that the image or disk that is being used was licensed on-premises.
	// Possible values for Windows Server operating system are:
	// WindowsClient
	// WindowsServer
	// Possible values for Linux Server operating system are:
	// RHELBYOS (for RHEL)
	// SLESBYOS (for SUSE)
	// For more information, see Azure Hybrid Use Benefit for Windows Server [https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing]
	// Azure Hybrid Use Benefit for Linux Server [https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux]
	// Minimum api-version: 2015-06-15
	LicenseType *string `json:"licenseType,omitempty"`

	// Specifies the network interfaces of the virtual machine.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// Specifies the network profile configuration of the virtual machine.
	NetworkProfileConfiguration *VirtualMachineScaleSetVMNetworkProfileConfiguration `json:"networkProfileConfiguration,omitempty"`

	// Specifies the operating system settings for the virtual machine.
	OSProfile *OSProfile `json:"osProfile,omitempty"`

	// Specifies the protection policy of the virtual machine.
	ProtectionPolicy *VirtualMachineScaleSetVMProtectionPolicy `json:"protectionPolicy,omitempty"`

	// Specifies the Security related profile settings for the virtual machine.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`

	// Specifies the storage settings for the virtual machine disks.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here.
	// Minimum api-version: 2021-03-01
	UserData *string `json:"userData,omitempty"`

	// READ-ONLY; The virtual machine instance view.
	InstanceView *VirtualMachineScaleSetVMInstanceView `json:"instanceView,omitempty" azure:"ro"`

	// READ-ONLY; Specifies whether the latest model has been applied to the virtual machine.
	LatestModelApplied *bool `json:"latestModelApplied,omitempty" azure:"ro"`

	// READ-ONLY; Specifies whether the model applied to the virtual machine is the model of the virtual machine scale set or
	// the customized model for the virtual machine.
	ModelDefinitionApplied *string `json:"modelDefinitionApplied,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Azure VM unique ID.
	VMID *string `json:"vmId,omitempty" azure:"ro"`
}

// VirtualMachineScaleSetVMProtectionPolicy - The protection policy of a virtual machine scale set VM.
type VirtualMachineScaleSetVMProtectionPolicy struct {
	// Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.
	ProtectFromScaleIn *bool `json:"protectFromScaleIn,omitempty"`

	// Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied
	// to the virtual machine scale set VM.
	ProtectFromScaleSetActions *bool `json:"protectFromScaleSetActions,omitempty"`
}

// VirtualMachineScaleSetVMReimageParameters - Describes a Virtual Machine Scale Set VM Reimage Parameters.
type VirtualMachineScaleSetVMReimageParameters struct {
	// Specifies whether to reimage temp disk. Default value: false. Note: This temp disk reimage parameter is only supported
	// for VM/VMSS with Ephemeral OS disk.
	TempDisk *bool `json:"tempDisk,omitempty"`
}

// VirtualMachineScaleSetVMRunCommandsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachineScaleSetVMRunCommandsClient.BeginCreateOrUpdate
// method.
type VirtualMachineScaleSetVMRunCommandsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMRunCommandsClientBeginDeleteOptions contains the optional parameters for the VirtualMachineScaleSetVMRunCommandsClient.BeginDelete
// method.
type VirtualMachineScaleSetVMRunCommandsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMRunCommandsClientBeginUpdateOptions contains the optional parameters for the VirtualMachineScaleSetVMRunCommandsClient.BeginUpdate
// method.
type VirtualMachineScaleSetVMRunCommandsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMRunCommandsClientGetOptions contains the optional parameters for the VirtualMachineScaleSetVMRunCommandsClient.Get
// method.
type VirtualMachineScaleSetVMRunCommandsClientGetOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineScaleSetVMRunCommandsClientListOptions contains the optional parameters for the VirtualMachineScaleSetVMRunCommandsClient.List
// method.
type VirtualMachineScaleSetVMRunCommandsClientListOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// VirtualMachineScaleSetVMsClientBeginDeallocateOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginDeallocate
// method.
type VirtualMachineScaleSetVMsClientBeginDeallocateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientBeginDeleteOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginDelete
// method.
type VirtualMachineScaleSetVMsClientBeginDeleteOptions struct {
	// Optional parameter to force delete a virtual machine from a VM scale set. (Feature in Preview)
	ForceDeletion *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientBeginPerformMaintenanceOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginPerformMaintenance
// method.
type VirtualMachineScaleSetVMsClientBeginPerformMaintenanceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientBeginPowerOffOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginPowerOff
// method.
type VirtualMachineScaleSetVMsClientBeginPowerOffOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The parameter to request non-graceful VM shutdown. True value for this flag indicates non-graceful shutdown whereas false
	// indicates otherwise. Default value for this flag is false if not specified
	SkipShutdown *bool
}

// VirtualMachineScaleSetVMsClientBeginRedeployOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginRedeploy
// method.
type VirtualMachineScaleSetVMsClientBeginRedeployOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientBeginReimageAllOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginReimageAll
// method.
type VirtualMachineScaleSetVMsClientBeginReimageAllOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientBeginReimageOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginReimage
// method.
type VirtualMachineScaleSetVMsClientBeginReimageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// Parameters for the Reimaging Virtual machine in ScaleSet.
	VMScaleSetVMReimageInput *VirtualMachineScaleSetVMReimageParameters
}

// VirtualMachineScaleSetVMsClientBeginRestartOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginRestart
// method.
type VirtualMachineScaleSetVMsClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientBeginRunCommandOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginRunCommand
// method.
type VirtualMachineScaleSetVMsClientBeginRunCommandOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientBeginStartOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginStart
// method.
type VirtualMachineScaleSetVMsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientBeginUpdateOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.BeginUpdate
// method.
type VirtualMachineScaleSetVMsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetVMsClientGetInstanceViewOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.GetInstanceView
// method.
type VirtualMachineScaleSetVMsClientGetInstanceViewOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetVMsClientGetOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.Get
// method.
type VirtualMachineScaleSetVMsClientGetOptions struct {
	// The expand expression to apply on the operation. 'InstanceView' will retrieve the instance view of the virtual machine.
	// 'UserData' will retrieve the UserData of the virtual machine.
	Expand *InstanceViewTypes
}

// VirtualMachineScaleSetVMsClientListOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.List
// method.
type VirtualMachineScaleSetVMsClientListOptions struct {
	// The expand expression to apply to the operation. Allowed values are 'instanceView'.
	Expand *string
	// The filter to apply to the operation. Allowed values are 'startswith(instanceView/statuses/code, 'PowerState') eq true',
	// 'properties/latestModelApplied eq true', 'properties/latestModelApplied eq
	// false'.
	Filter *string
	// The list parameters. Allowed values are 'instanceView', 'instanceView/statuses'.
	Select *string
}

// VirtualMachineScaleSetVMsClientRetrieveBootDiagnosticsDataOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.RetrieveBootDiagnosticsData
// method.
type VirtualMachineScaleSetVMsClientRetrieveBootDiagnosticsDataOptions struct {
	// Expiration duration in minutes for the SAS URIs with a value between 1 to 1440 minutes.
	// NOTE: If not specified, SAS URIs will be generated with a default expiration duration of 120 minutes.
	SasURIExpirationTimeInMinutes *int32
}

// VirtualMachineScaleSetVMsClientSimulateEvictionOptions contains the optional parameters for the VirtualMachineScaleSetVMsClient.SimulateEviction
// method.
type VirtualMachineScaleSetVMsClientSimulateEvictionOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginCreateOrUpdate
// method.
type VirtualMachineScaleSetsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetsClientBeginDeallocateOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginDeallocate
// method.
type VirtualMachineScaleSetsClientBeginDeallocateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// A list of virtual machine instance IDs from the VM scale set.
	VMInstanceIDs *VirtualMachineScaleSetVMInstanceIDs
}

// VirtualMachineScaleSetsClientBeginDeleteInstancesOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginDeleteInstances
// method.
type VirtualMachineScaleSetsClientBeginDeleteInstancesOptions struct {
	// Optional parameter to force delete virtual machines from the VM scale set. (Feature in Preview)
	ForceDeletion *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetsClientBeginDeleteOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginDelete
// method.
type VirtualMachineScaleSetsClientBeginDeleteOptions struct {
	// Optional parameter to force delete a VM scale set. (Feature in Preview)
	ForceDeletion *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetsClientBeginPerformMaintenanceOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginPerformMaintenance
// method.
type VirtualMachineScaleSetsClientBeginPerformMaintenanceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// A list of virtual machine instance IDs from the VM scale set.
	VMInstanceIDs *VirtualMachineScaleSetVMInstanceIDs
}

// VirtualMachineScaleSetsClientBeginPowerOffOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginPowerOff
// method.
type VirtualMachineScaleSetsClientBeginPowerOffOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The parameter to request non-graceful VM shutdown. True value for this flag indicates non-graceful shutdown whereas false
	// indicates otherwise. Default value for this flag is false if not specified
	SkipShutdown *bool
	// A list of virtual machine instance IDs from the VM scale set.
	VMInstanceIDs *VirtualMachineScaleSetVMInstanceIDs
}

// VirtualMachineScaleSetsClientBeginRedeployOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginRedeploy
// method.
type VirtualMachineScaleSetsClientBeginRedeployOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// A list of virtual machine instance IDs from the VM scale set.
	VMInstanceIDs *VirtualMachineScaleSetVMInstanceIDs
}

// VirtualMachineScaleSetsClientBeginReimageAllOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginReimageAll
// method.
type VirtualMachineScaleSetsClientBeginReimageAllOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// A list of virtual machine instance IDs from the VM scale set.
	VMInstanceIDs *VirtualMachineScaleSetVMInstanceIDs
}

// VirtualMachineScaleSetsClientBeginReimageOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginReimage
// method.
type VirtualMachineScaleSetsClientBeginReimageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// Parameters for Reimaging VM ScaleSet.
	VMScaleSetReimageInput *VirtualMachineScaleSetReimageParameters
}

// VirtualMachineScaleSetsClientBeginRestartOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginRestart
// method.
type VirtualMachineScaleSetsClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// A list of virtual machine instance IDs from the VM scale set.
	VMInstanceIDs *VirtualMachineScaleSetVMInstanceIDs
}

// VirtualMachineScaleSetsClientBeginSetOrchestrationServiceStateOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginSetOrchestrationServiceState
// method.
type VirtualMachineScaleSetsClientBeginSetOrchestrationServiceStateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetsClientBeginStartOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginStart
// method.
type VirtualMachineScaleSetsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// A list of virtual machine instance IDs from the VM scale set.
	VMInstanceIDs *VirtualMachineScaleSetVMInstanceIDs
}

// VirtualMachineScaleSetsClientBeginUpdateInstancesOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginUpdateInstances
// method.
type VirtualMachineScaleSetsClientBeginUpdateInstancesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetsClientBeginUpdateOptions contains the optional parameters for the VirtualMachineScaleSetsClient.BeginUpdate
// method.
type VirtualMachineScaleSetsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineScaleSetsClientConvertToSinglePlacementGroupOptions contains the optional parameters for the VirtualMachineScaleSetsClient.ConvertToSinglePlacementGroup
// method.
type VirtualMachineScaleSetsClientConvertToSinglePlacementGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetsClientForceRecoveryServiceFabricPlatformUpdateDomainWalkOptions contains the optional parameters
// for the VirtualMachineScaleSetsClient.ForceRecoveryServiceFabricPlatformUpdateDomainWalk method.
type VirtualMachineScaleSetsClientForceRecoveryServiceFabricPlatformUpdateDomainWalkOptions struct {
	// The placement group id for which the manual recovery walk is requested.
	PlacementGroupID *string
	// The zone in which the manual recovery walk is requested for cross zone virtual machine scale set
	Zone *string
}

// VirtualMachineScaleSetsClientGetInstanceViewOptions contains the optional parameters for the VirtualMachineScaleSetsClient.GetInstanceView
// method.
type VirtualMachineScaleSetsClientGetInstanceViewOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetsClientGetOSUpgradeHistoryOptions contains the optional parameters for the VirtualMachineScaleSetsClient.GetOSUpgradeHistory
// method.
type VirtualMachineScaleSetsClientGetOSUpgradeHistoryOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetsClientGetOptions contains the optional parameters for the VirtualMachineScaleSetsClient.Get method.
type VirtualMachineScaleSetsClientGetOptions struct {
	// The expand expression to apply on the operation. 'UserData' retrieves the UserData property of the VM scale set that was
	// provided by the user during the VM scale set Create/Update operation
	Expand *ExpandTypesForGetVMScaleSets
}

// VirtualMachineScaleSetsClientListAllOptions contains the optional parameters for the VirtualMachineScaleSetsClient.ListAll
// method.
type VirtualMachineScaleSetsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetsClientListByLocationOptions contains the optional parameters for the VirtualMachineScaleSetsClient.ListByLocation
// method.
type VirtualMachineScaleSetsClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetsClientListOptions contains the optional parameters for the VirtualMachineScaleSetsClient.List method.
type VirtualMachineScaleSetsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineScaleSetsClientListSKUsOptions contains the optional parameters for the VirtualMachineScaleSetsClient.ListSKUs
// method.
type VirtualMachineScaleSetsClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineSize - Describes the properties of a VM size.
type VirtualMachineSize struct {
	// The maximum number of data disks that can be attached to the virtual machine size.
	MaxDataDiskCount *int32 `json:"maxDataDiskCount,omitempty"`

	// The amount of memory, in MB, supported by the virtual machine size.
	MemoryInMB *int32 `json:"memoryInMB,omitempty"`

	// The name of the virtual machine size.
	Name *string `json:"name,omitempty"`

	// The number of cores supported by the virtual machine size. For Constrained vCPU capable VM sizes, this number represents
	// the total vCPUs of quota that the VM uses. For accurate vCPU count, please
	// refer to https://docs.microsoft.com/azure/virtual-machines/constrained-vcpu or https://docs.microsoft.com/rest/api/compute/resourceskus/list
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`

	// The OS disk size, in MB, allowed by the virtual machine size.
	OSDiskSizeInMB *int32 `json:"osDiskSizeInMB,omitempty"`

	// The resource disk size, in MB, allowed by the virtual machine size.
	ResourceDiskSizeInMB *int32 `json:"resourceDiskSizeInMB,omitempty"`
}

// VirtualMachineSizeListResult - The List Virtual Machine operation response.
type VirtualMachineSizeListResult struct {
	// The list of virtual machine sizes.
	Value []*VirtualMachineSize `json:"value,omitempty"`
}

// VirtualMachineSizesClientListOptions contains the optional parameters for the VirtualMachineSizesClient.List method.
type VirtualMachineSizesClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineSoftwarePatchProperties - Describes the properties of a Virtual Machine software patch.
type VirtualMachineSoftwarePatchProperties struct {
	// READ-ONLY; The activity ID of the operation that produced this result. It is used to correlate across CRP and extension
	// logs.
	ActivityID *string `json:"activityId,omitempty" azure:"ro"`

	// READ-ONLY; Describes the availability of a given patch.
	AssessmentState *PatchAssessmentState `json:"assessmentState,omitempty" azure:"ro"`

	// READ-ONLY; The classification(s) of the patch as provided by the patch publisher.
	Classifications []*string `json:"classifications,omitempty" azure:"ro"`

	// READ-ONLY; The KBID of the patch. Only applies to Windows patches.
	KbID *string `json:"kbId,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp of the last update to this patch record.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The friendly name of the patch.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; A unique identifier for the patch.
	PatchID *string `json:"patchId,omitempty" azure:"ro"`

	// READ-ONLY; The UTC timestamp when the repository published this patch.
	PublishedDate *time.Time `json:"publishedDate,omitempty" azure:"ro"`

	// READ-ONLY; Describes the reboot requirements of the patch.
	RebootBehavior *VMGuestPatchRebootBehavior `json:"rebootBehavior,omitempty" azure:"ro"`

	// READ-ONLY; The version number of the patch. This property applies only to Linux patches.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// VirtualMachineStatusCodeCount - The status code and count of the virtual machine scale set instance view status summary.
type VirtualMachineStatusCodeCount struct {
	// READ-ONLY; The instance view status code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The number of instances having a particular status code.
	Count *int32 `json:"count,omitempty" azure:"ro"`
}

// VirtualMachineUpdate - Describes a Virtual Machine Update.
type VirtualMachineUpdate struct {
	// The identity of the virtual machine, if configured.
	Identity *VirtualMachineIdentity `json:"identity,omitempty"`

	// Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace
	// images. Before you can use a marketplace image from an API, you must
	// enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click
	// Want to deploy programmatically, Get Started ->. Enter any required
	// information and then click Save.
	Plan *Plan `json:"plan,omitempty"`

	// Describes the properties of a Virtual Machine.
	Properties *VirtualMachineProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// The virtual machine zones.
	Zones []*string `json:"zones,omitempty"`
}

// VirtualMachinesClientBeginAssessPatchesOptions contains the optional parameters for the VirtualMachinesClient.BeginAssessPatches
// method.
type VirtualMachinesClientBeginAssessPatchesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginCaptureOptions contains the optional parameters for the VirtualMachinesClient.BeginCapture method.
type VirtualMachinesClientBeginCaptureOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginConvertToManagedDisksOptions contains the optional parameters for the VirtualMachinesClient.BeginConvertToManagedDisks
// method.
type VirtualMachinesClientBeginConvertToManagedDisksOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachinesClient.BeginCreateOrUpdate
// method.
type VirtualMachinesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginDeallocateOptions contains the optional parameters for the VirtualMachinesClient.BeginDeallocate
// method.
type VirtualMachinesClientBeginDeallocateOptions struct {
	// Optional parameter to hibernate a virtual machine. (Feature in Preview)
	Hibernate *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginDeleteOptions contains the optional parameters for the VirtualMachinesClient.BeginDelete method.
type VirtualMachinesClientBeginDeleteOptions struct {
	// Optional parameter to force delete virtual machines.
	ForceDeletion *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginInstallPatchesOptions contains the optional parameters for the VirtualMachinesClient.BeginInstallPatches
// method.
type VirtualMachinesClientBeginInstallPatchesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginPerformMaintenanceOptions contains the optional parameters for the VirtualMachinesClient.BeginPerformMaintenance
// method.
type VirtualMachinesClientBeginPerformMaintenanceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginPowerOffOptions contains the optional parameters for the VirtualMachinesClient.BeginPowerOff
// method.
type VirtualMachinesClientBeginPowerOffOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The parameter to request non-graceful VM shutdown. True value for this flag indicates non-graceful shutdown whereas false
	// indicates otherwise. Default value for this flag is false if not specified
	SkipShutdown *bool
}

// VirtualMachinesClientBeginReapplyOptions contains the optional parameters for the VirtualMachinesClient.BeginReapply method.
type VirtualMachinesClientBeginReapplyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginRedeployOptions contains the optional parameters for the VirtualMachinesClient.BeginRedeploy
// method.
type VirtualMachinesClientBeginRedeployOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginReimageOptions contains the optional parameters for the VirtualMachinesClient.BeginReimage method.
type VirtualMachinesClientBeginReimageOptions struct {
	// Parameters supplied to the Reimage Virtual Machine operation.
	Parameters *VirtualMachineReimageParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginRestartOptions contains the optional parameters for the VirtualMachinesClient.BeginRestart method.
type VirtualMachinesClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginRunCommandOptions contains the optional parameters for the VirtualMachinesClient.BeginRunCommand
// method.
type VirtualMachinesClientBeginRunCommandOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStartOptions contains the optional parameters for the VirtualMachinesClient.BeginStart method.
type VirtualMachinesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginUpdateOptions contains the optional parameters for the VirtualMachinesClient.BeginUpdate method.
type VirtualMachinesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientGeneralizeOptions contains the optional parameters for the VirtualMachinesClient.Generalize method.
type VirtualMachinesClientGeneralizeOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientGetOptions contains the optional parameters for the VirtualMachinesClient.Get method.
type VirtualMachinesClientGetOptions struct {
	// The expand expression to apply on the operation. 'InstanceView' retrieves a snapshot of the runtime properties of the virtual
	// machine that is managed by the platform and can change outside of control
	// plane operations. 'UserData' retrieves the UserData property as part of the VM model view that was provided by the user
	// during the VM Create/Update operation.
	Expand *InstanceViewTypes
}

// VirtualMachinesClientInstanceViewOptions contains the optional parameters for the VirtualMachinesClient.InstanceView method.
type VirtualMachinesClientInstanceViewOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListAllOptions contains the optional parameters for the VirtualMachinesClient.ListAll method.
type VirtualMachinesClientListAllOptions struct {
	// The system query option to filter VMs returned in the response. Allowed value is 'virtualMachineScaleSet/id' eq
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmssName}'
	Filter *string
	// statusOnly=true enables fetching run time status of all Virtual Machines in the subscription.
	StatusOnly *string
}

// VirtualMachinesClientListAvailableSizesOptions contains the optional parameters for the VirtualMachinesClient.ListAvailableSizes
// method.
type VirtualMachinesClientListAvailableSizesOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListByLocationOptions contains the optional parameters for the VirtualMachinesClient.ListByLocation
// method.
type VirtualMachinesClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListOptions contains the optional parameters for the VirtualMachinesClient.List method.
type VirtualMachinesClientListOptions struct {
	// The system query option to filter VMs returned in the response. Allowed value is 'virtualMachineScaleSet/id' eq
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmssName}'
	Filter *string
}

// VirtualMachinesClientRetrieveBootDiagnosticsDataOptions contains the optional parameters for the VirtualMachinesClient.RetrieveBootDiagnosticsData
// method.
type VirtualMachinesClientRetrieveBootDiagnosticsDataOptions struct {
	// Expiration duration in minutes for the SAS URIs with a value between 1 to 1440 minutes.
	// NOTE: If not specified, SAS URIs will be generated with a default expiration duration of 120 minutes.
	SasURIExpirationTimeInMinutes *int32
}

// VirtualMachinesClientSimulateEvictionOptions contains the optional parameters for the VirtualMachinesClient.SimulateEviction
// method.
type VirtualMachinesClientSimulateEvictionOptions struct {
	// placeholder for future optional parameters
}

// WinRMConfiguration - Describes Windows Remote Management configuration of the VM
type WinRMConfiguration struct {
	// The list of Windows Remote Management listeners
	Listeners []*WinRMListener `json:"listeners,omitempty"`
}

// WinRMListener - Describes Protocol and thumbprint of Windows Remote Management listener
type WinRMListener struct {
	// This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault,
	// see Add a key or secret to the key vault
	// [https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add]. In this case, your certificate needs to be It
	// is the Base64 encoding of the following JSON Object which is encoded in UTF-8:
	// {
	// "data":"",
	// "dataType":"pfx",
	// "password":""
	// }
	// To install certificates on a virtual machine it is recommended to use the Azure Key Vault virtual machine extension for
	// Linux
	// [https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux] or the Azure Key Vault virtual machine extension
	// for Windows
	// [https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows].
	CertificateURL *string `json:"certificateUrl,omitempty"`

	// Specifies the protocol of WinRM listener.
	// Possible values are:
	// http
	// https
	Protocol *ProtocolTypes `json:"protocol,omitempty"`
}

// WindowsConfiguration - Specifies Windows operating system settings on the virtual machine.
type WindowsConfiguration struct {
	// Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is
	// used by Windows Setup.
	AdditionalUnattendContent []*AdditionalUnattendContent `json:"additionalUnattendContent,omitempty"`

	// Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true.
	// For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.
	EnableAutomaticUpdates *bool `json:"enableAutomaticUpdates,omitempty"`

	// Indicates whether VMAgent Platform Updates is enabled for the Windows virtual machine. Default value is false.
	EnableVMAgentPlatformUpdates *bool `json:"enableVMAgentPlatformUpdates,omitempty"`

	// [Preview Feature] Specifies settings related to VM Guest Patching on Windows.
	PatchSettings *PatchSettings `json:"patchSettings,omitempty"`

	// Indicates whether virtual machine agent should be provisioned on the virtual machine.
	// When this property is not specified in the request body, default behavior is to set it to true. This will ensure that VM
	// Agent is installed on the VM so that extensions can be added to the VM later.
	ProvisionVMAgent *bool `json:"provisionVMAgent,omitempty"`

	// Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
	// Possible values can be TimeZoneInfo.Id [https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id]
	// value from time zones returned by TimeZoneInfo.GetSystemTimeZones
	// [https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones].
	TimeZone *string `json:"timeZone,omitempty"`

	// Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
	WinRM *WinRMConfiguration `json:"winRM,omitempty"`
}

// WindowsParameters - Input for InstallPatches on a Windows VM, as directly received by the API
type WindowsParameters struct {
	// The update classifications to select when installing patches for Windows.
	ClassificationsToInclude []*VMGuestPatchClassificationWindows `json:"classificationsToInclude,omitempty"`

	// Filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true.
	ExcludeKbsRequiringReboot *bool `json:"excludeKbsRequiringReboot,omitempty"`

	// Kbs to exclude in the patch operation
	KbNumbersToExclude []*string `json:"kbNumbersToExclude,omitempty"`

	// Kbs to include in the patch operation
	KbNumbersToInclude []*string `json:"kbNumbersToInclude,omitempty"`

	// This is used to install patches that were published on or before this given max published date.
	MaxPatchPublishDate *time.Time `json:"maxPatchPublishDate,omitempty"`
}

// WindowsVMGuestPatchAutomaticByPlatformSettings - Specifies additional settings to be applied when patch mode AutomaticByPlatform
// is selected in Windows patch settings.
type WindowsVMGuestPatchAutomaticByPlatformSettings struct {
	// Specifies the reboot setting for all AutomaticByPlatform patch installation operations.
	RebootSetting *WindowsVMGuestPatchAutomaticByPlatformRebootSetting `json:"rebootSetting,omitempty"`
}
