//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

const (
	moduleName    = "armapimanagement"
	moduleVersion = "v1.0.0"
)

// APIManagementSKUCapacityScaleType - The scale type applicable to the sku.
type APIManagementSKUCapacityScaleType string

const (
	APIManagementSKUCapacityScaleTypeAutomatic APIManagementSKUCapacityScaleType = "Automatic"
	APIManagementSKUCapacityScaleTypeManual    APIManagementSKUCapacityScaleType = "Manual"
	APIManagementSKUCapacityScaleTypeNone      APIManagementSKUCapacityScaleType = "None"
)

// PossibleAPIManagementSKUCapacityScaleTypeValues returns the possible values for the APIManagementSKUCapacityScaleType const type.
func PossibleAPIManagementSKUCapacityScaleTypeValues() []APIManagementSKUCapacityScaleType {
	return []APIManagementSKUCapacityScaleType{
		APIManagementSKUCapacityScaleTypeAutomatic,
		APIManagementSKUCapacityScaleTypeManual,
		APIManagementSKUCapacityScaleTypeNone,
	}
}

// APIManagementSKURestrictionsReasonCode - The reason for restriction.
type APIManagementSKURestrictionsReasonCode string

const (
	APIManagementSKURestrictionsReasonCodeQuotaID                     APIManagementSKURestrictionsReasonCode = "QuotaId"
	APIManagementSKURestrictionsReasonCodeNotAvailableForSubscription APIManagementSKURestrictionsReasonCode = "NotAvailableForSubscription"
)

// PossibleAPIManagementSKURestrictionsReasonCodeValues returns the possible values for the APIManagementSKURestrictionsReasonCode const type.
func PossibleAPIManagementSKURestrictionsReasonCodeValues() []APIManagementSKURestrictionsReasonCode {
	return []APIManagementSKURestrictionsReasonCode{
		APIManagementSKURestrictionsReasonCodeQuotaID,
		APIManagementSKURestrictionsReasonCodeNotAvailableForSubscription,
	}
}

// APIManagementSKURestrictionsType - The type of restrictions.
type APIManagementSKURestrictionsType string

const (
	APIManagementSKURestrictionsTypeLocation APIManagementSKURestrictionsType = "Location"
	APIManagementSKURestrictionsTypeZone     APIManagementSKURestrictionsType = "Zone"
)

// PossibleAPIManagementSKURestrictionsTypeValues returns the possible values for the APIManagementSKURestrictionsType const type.
func PossibleAPIManagementSKURestrictionsTypeValues() []APIManagementSKURestrictionsType {
	return []APIManagementSKURestrictionsType{
		APIManagementSKURestrictionsTypeLocation,
		APIManagementSKURestrictionsTypeZone,
	}
}

// APIType - Type of API.
type APIType string

const (
	APITypeGraphql   APIType = "graphql"
	APITypeHTTP      APIType = "http"
	APITypeSoap      APIType = "soap"
	APITypeWebsocket APIType = "websocket"
)

// PossibleAPITypeValues returns the possible values for the APIType const type.
func PossibleAPITypeValues() []APIType {
	return []APIType{
		APITypeGraphql,
		APITypeHTTP,
		APITypeSoap,
		APITypeWebsocket,
	}
}

// APIVersionSetContractDetailsVersioningScheme - An value that determines where the API Version identifier will be located
// in a HTTP request.
type APIVersionSetContractDetailsVersioningScheme string

const (
	APIVersionSetContractDetailsVersioningSchemeHeader  APIVersionSetContractDetailsVersioningScheme = "Header"
	APIVersionSetContractDetailsVersioningSchemeQuery   APIVersionSetContractDetailsVersioningScheme = "Query"
	APIVersionSetContractDetailsVersioningSchemeSegment APIVersionSetContractDetailsVersioningScheme = "Segment"
)

// PossibleAPIVersionSetContractDetailsVersioningSchemeValues returns the possible values for the APIVersionSetContractDetailsVersioningScheme const type.
func PossibleAPIVersionSetContractDetailsVersioningSchemeValues() []APIVersionSetContractDetailsVersioningScheme {
	return []APIVersionSetContractDetailsVersioningScheme{
		APIVersionSetContractDetailsVersioningSchemeHeader,
		APIVersionSetContractDetailsVersioningSchemeQuery,
		APIVersionSetContractDetailsVersioningSchemeSegment,
	}
}

type AccessIDName string

const (
	AccessIDNameAccess    AccessIDName = "access"
	AccessIDNameGitAccess AccessIDName = "gitAccess"
)

// PossibleAccessIDNameValues returns the possible values for the AccessIDName const type.
func PossibleAccessIDNameValues() []AccessIDName {
	return []AccessIDName{
		AccessIDNameAccess,
		AccessIDNameGitAccess,
	}
}

// AccessType - The type of access to be used for the storage account.
type AccessType string

const (
	// AccessTypeAccessKey - Use access key.
	AccessTypeAccessKey AccessType = "AccessKey"
	// AccessTypeSystemAssignedManagedIdentity - Use system assigned managed identity.
	AccessTypeSystemAssignedManagedIdentity AccessType = "SystemAssignedManagedIdentity"
	// AccessTypeUserAssignedManagedIdentity - Use user assigned managed identity.
	AccessTypeUserAssignedManagedIdentity AccessType = "UserAssignedManagedIdentity"
)

// PossibleAccessTypeValues returns the possible values for the AccessType const type.
func PossibleAccessTypeValues() []AccessType {
	return []AccessType{
		AccessTypeAccessKey,
		AccessTypeSystemAssignedManagedIdentity,
		AccessTypeUserAssignedManagedIdentity,
	}
}

// AlwaysLog - Specifies for what type of messages sampling settings should not apply.
type AlwaysLog string

const (
	// AlwaysLogAllErrors - Always log all erroneous request regardless of sampling settings.
	AlwaysLogAllErrors AlwaysLog = "allErrors"
)

// PossibleAlwaysLogValues returns the possible values for the AlwaysLog const type.
func PossibleAlwaysLogValues() []AlwaysLog {
	return []AlwaysLog{
		AlwaysLogAllErrors,
	}
}

// ApimIdentityType - The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an
// implicitly created identity and a set of user assigned identities. The type 'None' will remove any
// identities from the service.
type ApimIdentityType string

const (
	ApimIdentityTypeNone                       ApimIdentityType = "None"
	ApimIdentityTypeSystemAssigned             ApimIdentityType = "SystemAssigned"
	ApimIdentityTypeSystemAssignedUserAssigned ApimIdentityType = "SystemAssigned, UserAssigned"
	ApimIdentityTypeUserAssigned               ApimIdentityType = "UserAssigned"
)

// PossibleApimIdentityTypeValues returns the possible values for the ApimIdentityType const type.
func PossibleApimIdentityTypeValues() []ApimIdentityType {
	return []ApimIdentityType{
		ApimIdentityTypeNone,
		ApimIdentityTypeSystemAssigned,
		ApimIdentityTypeSystemAssignedUserAssigned,
		ApimIdentityTypeUserAssigned,
	}
}

type AppType string

const (
	// AppTypeDeveloperPortal - User create request was sent by new developer portal.
	AppTypeDeveloperPortal AppType = "developerPortal"
	// AppTypePortal - User create request was sent by legacy developer portal.
	AppTypePortal AppType = "portal"
)

// PossibleAppTypeValues returns the possible values for the AppType const type.
func PossibleAppTypeValues() []AppType {
	return []AppType{
		AppTypeDeveloperPortal,
		AppTypePortal,
	}
}

// AsyncOperationStatus - Status of an async operation.
type AsyncOperationStatus string

const (
	AsyncOperationStatusStarted    AsyncOperationStatus = "Started"
	AsyncOperationStatusInProgress AsyncOperationStatus = "InProgress"
	AsyncOperationStatusSucceeded  AsyncOperationStatus = "Succeeded"
	AsyncOperationStatusFailed     AsyncOperationStatus = "Failed"
)

// PossibleAsyncOperationStatusValues returns the possible values for the AsyncOperationStatus const type.
func PossibleAsyncOperationStatusValues() []AsyncOperationStatus {
	return []AsyncOperationStatus{
		AsyncOperationStatusStarted,
		AsyncOperationStatusInProgress,
		AsyncOperationStatusSucceeded,
		AsyncOperationStatusFailed,
	}
}

type AuthorizationMethod string

const (
	AuthorizationMethodHEAD    AuthorizationMethod = "HEAD"
	AuthorizationMethodOPTIONS AuthorizationMethod = "OPTIONS"
	AuthorizationMethodTRACE   AuthorizationMethod = "TRACE"
	AuthorizationMethodGET     AuthorizationMethod = "GET"
	AuthorizationMethodPOST    AuthorizationMethod = "POST"
	AuthorizationMethodPUT     AuthorizationMethod = "PUT"
	AuthorizationMethodPATCH   AuthorizationMethod = "PATCH"
	AuthorizationMethodDELETE  AuthorizationMethod = "DELETE"
)

// PossibleAuthorizationMethodValues returns the possible values for the AuthorizationMethod const type.
func PossibleAuthorizationMethodValues() []AuthorizationMethod {
	return []AuthorizationMethod{
		AuthorizationMethodHEAD,
		AuthorizationMethodOPTIONS,
		AuthorizationMethodTRACE,
		AuthorizationMethodGET,
		AuthorizationMethodPOST,
		AuthorizationMethodPUT,
		AuthorizationMethodPATCH,
		AuthorizationMethodDELETE,
	}
}

// BackendProtocol - Backend communication protocol.
type BackendProtocol string

const (
	// BackendProtocolHTTP - The Backend is a RESTful service.
	BackendProtocolHTTP BackendProtocol = "http"
	// BackendProtocolSoap - The Backend is a SOAP service.
	BackendProtocolSoap BackendProtocol = "soap"
)

// PossibleBackendProtocolValues returns the possible values for the BackendProtocol const type.
func PossibleBackendProtocolValues() []BackendProtocol {
	return []BackendProtocol{
		BackendProtocolHTTP,
		BackendProtocolSoap,
	}
}

type BearerTokenSendingMethod string

const (
	BearerTokenSendingMethodAuthorizationHeader BearerTokenSendingMethod = "authorizationHeader"
	BearerTokenSendingMethodQuery               BearerTokenSendingMethod = "query"
)

// PossibleBearerTokenSendingMethodValues returns the possible values for the BearerTokenSendingMethod const type.
func PossibleBearerTokenSendingMethodValues() []BearerTokenSendingMethod {
	return []BearerTokenSendingMethod{
		BearerTokenSendingMethodAuthorizationHeader,
		BearerTokenSendingMethodQuery,
	}
}

// BearerTokenSendingMethods - Form of an authorization grant, which the client uses to request the access token.
type BearerTokenSendingMethods string

const (
	// BearerTokenSendingMethodsAuthorizationHeader - Access token will be transmitted in the Authorization header using Bearer
	// schema
	BearerTokenSendingMethodsAuthorizationHeader BearerTokenSendingMethods = "authorizationHeader"
	// BearerTokenSendingMethodsQuery - Access token will be transmitted as query parameters.
	BearerTokenSendingMethodsQuery BearerTokenSendingMethods = "query"
)

// PossibleBearerTokenSendingMethodsValues returns the possible values for the BearerTokenSendingMethods const type.
func PossibleBearerTokenSendingMethodsValues() []BearerTokenSendingMethods {
	return []BearerTokenSendingMethods{
		BearerTokenSendingMethodsAuthorizationHeader,
		BearerTokenSendingMethodsQuery,
	}
}

// CertificateConfigurationStoreName - The System.Security.Cryptography.x509certificates.StoreName certificate store location.
// Only Root and CertificateAuthority are valid locations.
type CertificateConfigurationStoreName string

const (
	CertificateConfigurationStoreNameCertificateAuthority CertificateConfigurationStoreName = "CertificateAuthority"
	CertificateConfigurationStoreNameRoot                 CertificateConfigurationStoreName = "Root"
)

// PossibleCertificateConfigurationStoreNameValues returns the possible values for the CertificateConfigurationStoreName const type.
func PossibleCertificateConfigurationStoreNameValues() []CertificateConfigurationStoreName {
	return []CertificateConfigurationStoreName{
		CertificateConfigurationStoreNameCertificateAuthority,
		CertificateConfigurationStoreNameRoot,
	}
}

// CertificateSource - Certificate Source.
type CertificateSource string

const (
	CertificateSourceBuiltIn  CertificateSource = "BuiltIn"
	CertificateSourceCustom   CertificateSource = "Custom"
	CertificateSourceKeyVault CertificateSource = "KeyVault"
	CertificateSourceManaged  CertificateSource = "Managed"
)

// PossibleCertificateSourceValues returns the possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{
		CertificateSourceBuiltIn,
		CertificateSourceCustom,
		CertificateSourceKeyVault,
		CertificateSourceManaged,
	}
}

// CertificateStatus - Certificate Status.
type CertificateStatus string

const (
	CertificateStatusCompleted  CertificateStatus = "Completed"
	CertificateStatusFailed     CertificateStatus = "Failed"
	CertificateStatusInProgress CertificateStatus = "InProgress"
)

// PossibleCertificateStatusValues returns the possible values for the CertificateStatus const type.
func PossibleCertificateStatusValues() []CertificateStatus {
	return []CertificateStatus{
		CertificateStatusCompleted,
		CertificateStatusFailed,
		CertificateStatusInProgress,
	}
}

type ClientAuthenticationMethod string

const (
	// ClientAuthenticationMethodBasic - Basic Client Authentication method.
	ClientAuthenticationMethodBasic ClientAuthenticationMethod = "Basic"
	// ClientAuthenticationMethodBody - Body based Authentication method.
	ClientAuthenticationMethodBody ClientAuthenticationMethod = "Body"
)

// PossibleClientAuthenticationMethodValues returns the possible values for the ClientAuthenticationMethod const type.
func PossibleClientAuthenticationMethodValues() []ClientAuthenticationMethod {
	return []ClientAuthenticationMethod{
		ClientAuthenticationMethodBasic,
		ClientAuthenticationMethodBody,
	}
}

type ConfigurationIDName string

const (
	ConfigurationIDNameConfiguration ConfigurationIDName = "configuration"
)

// PossibleConfigurationIDNameValues returns the possible values for the ConfigurationIDName const type.
func PossibleConfigurationIDNameValues() []ConfigurationIDName {
	return []ConfigurationIDName{
		ConfigurationIDNameConfiguration,
	}
}

// Confirmation - Determines the type of confirmation e-mail that will be sent to the newly created user.
type Confirmation string

const (
	// ConfirmationInvite - Send an e-mail inviting the user to sign-up and complete registration.
	ConfirmationInvite Confirmation = "invite"
	// ConfirmationSignup - Send an e-mail to the user confirming they have successfully signed up.
	ConfirmationSignup Confirmation = "signup"
)

// PossibleConfirmationValues returns the possible values for the Confirmation const type.
func PossibleConfirmationValues() []Confirmation {
	return []Confirmation{
		ConfirmationInvite,
		ConfirmationSignup,
	}
}

// ConnectionStatus - The connection status.
type ConnectionStatus string

const (
	ConnectionStatusConnected    ConnectionStatus = "Connected"
	ConnectionStatusDegraded     ConnectionStatus = "Degraded"
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	ConnectionStatusUnknown      ConnectionStatus = "Unknown"
)

// PossibleConnectionStatusValues returns the possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{
		ConnectionStatusConnected,
		ConnectionStatusDegraded,
		ConnectionStatusDisconnected,
		ConnectionStatusUnknown,
	}
}

// ConnectivityCheckProtocol - The request's protocol. Specific protocol configuration can be available based on this selection.
// The specified destination address must be coherent with this value.
type ConnectivityCheckProtocol string

const (
	ConnectivityCheckProtocolHTTP  ConnectivityCheckProtocol = "HTTP"
	ConnectivityCheckProtocolHTTPS ConnectivityCheckProtocol = "HTTPS"
	ConnectivityCheckProtocolTCP   ConnectivityCheckProtocol = "TCP"
)

// PossibleConnectivityCheckProtocolValues returns the possible values for the ConnectivityCheckProtocol const type.
func PossibleConnectivityCheckProtocolValues() []ConnectivityCheckProtocol {
	return []ConnectivityCheckProtocol{
		ConnectivityCheckProtocolHTTP,
		ConnectivityCheckProtocolHTTPS,
		ConnectivityCheckProtocolTCP,
	}
}

// ConnectivityStatusType - Resource Connectivity Status Type identifier.
type ConnectivityStatusType string

const (
	ConnectivityStatusTypeFailure      ConnectivityStatusType = "failure"
	ConnectivityStatusTypeInitializing ConnectivityStatusType = "initializing"
	ConnectivityStatusTypeSuccess      ConnectivityStatusType = "success"
)

// PossibleConnectivityStatusTypeValues returns the possible values for the ConnectivityStatusType const type.
func PossibleConnectivityStatusTypeValues() []ConnectivityStatusType {
	return []ConnectivityStatusType{
		ConnectivityStatusTypeFailure,
		ConnectivityStatusTypeInitializing,
		ConnectivityStatusTypeSuccess,
	}
}

// ContentFormat - Format of the Content in which the API is getting imported.
type ContentFormat string

const (
	// ContentFormatGraphqlLink - The GraphQL API endpoint hosted on a publicly accessible internet address.
	ContentFormatGraphqlLink ContentFormat = "graphql-link"
	// ContentFormatOpenapi - The contents are inline and Content Type is a OpenAPI 3.0 YAML Document.
	ContentFormatOpenapi ContentFormat = "openapi"
	// ContentFormatOpenapiJSON - The contents are inline and Content Type is a OpenAPI 3.0 JSON Document.
	ContentFormatOpenapiJSON ContentFormat = "openapi+json"
	// ContentFormatOpenapiJSONLink - The OpenAPI 3.0 JSON document is hosted on a publicly accessible internet address.
	ContentFormatOpenapiJSONLink ContentFormat = "openapi+json-link"
	// ContentFormatOpenapiLink - The OpenAPI 3.0 YAML document is hosted on a publicly accessible internet address.
	ContentFormatOpenapiLink ContentFormat = "openapi-link"
	// ContentFormatSwaggerJSON - The contents are inline and Content Type is a OpenAPI 2.0 JSON Document.
	ContentFormatSwaggerJSON ContentFormat = "swagger-json"
	// ContentFormatSwaggerLinkJSON - The OpenAPI 2.0 JSON document is hosted on a publicly accessible internet address.
	ContentFormatSwaggerLinkJSON ContentFormat = "swagger-link-json"
	// ContentFormatWadlLinkJSON - The WADL document is hosted on a publicly accessible internet address.
	ContentFormatWadlLinkJSON ContentFormat = "wadl-link-json"
	// ContentFormatWadlXML - The contents are inline and Content type is a WADL document.
	ContentFormatWadlXML ContentFormat = "wadl-xml"
	// ContentFormatWsdl - The contents are inline and the document is a WSDL/Soap document.
	ContentFormatWsdl ContentFormat = "wsdl"
	// ContentFormatWsdlLink - The WSDL document is hosted on a publicly accessible internet address.
	ContentFormatWsdlLink ContentFormat = "wsdl-link"
)

// PossibleContentFormatValues returns the possible values for the ContentFormat const type.
func PossibleContentFormatValues() []ContentFormat {
	return []ContentFormat{
		ContentFormatGraphqlLink,
		ContentFormatOpenapi,
		ContentFormatOpenapiJSON,
		ContentFormatOpenapiJSONLink,
		ContentFormatOpenapiLink,
		ContentFormatSwaggerJSON,
		ContentFormatSwaggerLinkJSON,
		ContentFormatWadlLinkJSON,
		ContentFormatWadlXML,
		ContentFormatWsdl,
		ContentFormatWsdlLink,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DataMaskingMode - Data masking mode.
type DataMaskingMode string

const (
	// DataMaskingModeHide - Hide the presence of an entity.
	DataMaskingModeHide DataMaskingMode = "Hide"
	// DataMaskingModeMask - Mask the value of an entity.
	DataMaskingModeMask DataMaskingMode = "Mask"
)

// PossibleDataMaskingModeValues returns the possible values for the DataMaskingMode const type.
func PossibleDataMaskingModeValues() []DataMaskingMode {
	return []DataMaskingMode{
		DataMaskingModeHide,
		DataMaskingModeMask,
	}
}

type ExportAPI string

const (
	ExportAPITrue ExportAPI = "true"
)

// PossibleExportAPIValues returns the possible values for the ExportAPI const type.
func PossibleExportAPIValues() []ExportAPI {
	return []ExportAPI{
		ExportAPITrue,
	}
}

type ExportFormat string

const (
	// ExportFormatOpenapi - Export the Api Definition in OpenAPI 3.0 Specification as YAML document to Storage Blob.
	ExportFormatOpenapi ExportFormat = "openapi-link"
	// ExportFormatOpenapiJSON - Export the Api Definition in OpenAPI 3.0 Specification as JSON document to Storage Blob.
	ExportFormatOpenapiJSON ExportFormat = "openapi+json-link"
	// ExportFormatSwagger - Export the Api Definition in OpenAPI 2.0 Specification as JSON document to the Storage Blob.
	ExportFormatSwagger ExportFormat = "swagger-link"
	// ExportFormatWadl - Export the Api Definition in WADL Schema to Storage Blob.
	ExportFormatWadl ExportFormat = "wadl-link"
	// ExportFormatWsdl - Export the Api Definition in WSDL Schema to Storage Blob. This is only supported for APIs of Type `soap`
	ExportFormatWsdl ExportFormat = "wsdl-link"
)

// PossibleExportFormatValues returns the possible values for the ExportFormat const type.
func PossibleExportFormatValues() []ExportFormat {
	return []ExportFormat{
		ExportFormatOpenapi,
		ExportFormatOpenapiJSON,
		ExportFormatSwagger,
		ExportFormatWadl,
		ExportFormatWsdl,
	}
}

// ExportResultFormat - Format in which the API Details are exported to the Storage Blob with Sas Key valid for 5 minutes.
type ExportResultFormat string

const (
	// ExportResultFormatOpenAPI - Export the API Definition in OpenAPI Specification 3.0 to Storage Blob.
	ExportResultFormatOpenAPI ExportResultFormat = "openapi-link"
	// ExportResultFormatSwagger - The API Definition is exported in OpenAPI Specification 2.0 format to the Storage Blob.
	ExportResultFormatSwagger ExportResultFormat = "swagger-link-json"
	// ExportResultFormatWadl - Export the API Definition in WADL Schema to Storage Blob.
	ExportResultFormatWadl ExportResultFormat = "wadl-link-json"
	// ExportResultFormatWsdl - The API Definition is exported in WSDL Schema to Storage Blob. This is only supported for APIs
	// of Type `soap`
	ExportResultFormatWsdl ExportResultFormat = "wsdl-link+xml"
)

// PossibleExportResultFormatValues returns the possible values for the ExportResultFormat const type.
func PossibleExportResultFormatValues() []ExportResultFormat {
	return []ExportResultFormat{
		ExportResultFormatOpenAPI,
		ExportResultFormatSwagger,
		ExportResultFormatWadl,
		ExportResultFormatWsdl,
	}
}

type GrantType string

const (
	// GrantTypeAuthorizationCode - Authorization Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.1.
	GrantTypeAuthorizationCode GrantType = "authorizationCode"
	// GrantTypeClientCredentials - Client Credentials Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.4.
	GrantTypeClientCredentials GrantType = "clientCredentials"
	// GrantTypeImplicit - Implicit Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.2.
	GrantTypeImplicit GrantType = "implicit"
	// GrantTypeResourceOwnerPassword - Resource Owner Password Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.3.
	GrantTypeResourceOwnerPassword GrantType = "resourceOwnerPassword"
)

// PossibleGrantTypeValues returns the possible values for the GrantType const type.
func PossibleGrantTypeValues() []GrantType {
	return []GrantType{
		GrantTypeAuthorizationCode,
		GrantTypeClientCredentials,
		GrantTypeImplicit,
		GrantTypeResourceOwnerPassword,
	}
}

// GroupType - Group type.
type GroupType string

const (
	GroupTypeCustom   GroupType = "custom"
	GroupTypeSystem   GroupType = "system"
	GroupTypeExternal GroupType = "external"
)

// PossibleGroupTypeValues returns the possible values for the GroupType const type.
func PossibleGroupTypeValues() []GroupType {
	return []GroupType{
		GroupTypeCustom,
		GroupTypeSystem,
		GroupTypeExternal,
	}
}

// HTTPCorrelationProtocol - Sets correlation protocol to use for Application Insights diagnostics.
type HTTPCorrelationProtocol string

const (
	// HTTPCorrelationProtocolLegacy - Inject Request-Id and Request-Context headers with request correlation data. See https://github.com/dotnet/corefx/blob/master/src/System.Diagnostics.DiagnosticSource/src/HttpCorrelationProtocol.md.
	HTTPCorrelationProtocolLegacy HTTPCorrelationProtocol = "Legacy"
	// HTTPCorrelationProtocolNone - Do not read and inject correlation headers.
	HTTPCorrelationProtocolNone HTTPCorrelationProtocol = "None"
	// HTTPCorrelationProtocolW3C - Inject Trace Context headers. See https://w3c.github.io/trace-context.
	HTTPCorrelationProtocolW3C HTTPCorrelationProtocol = "W3C"
)

// PossibleHTTPCorrelationProtocolValues returns the possible values for the HTTPCorrelationProtocol const type.
func PossibleHTTPCorrelationProtocolValues() []HTTPCorrelationProtocol {
	return []HTTPCorrelationProtocol{
		HTTPCorrelationProtocolLegacy,
		HTTPCorrelationProtocolNone,
		HTTPCorrelationProtocolW3C,
	}
}

// HostnameType - Hostname type.
type HostnameType string

const (
	HostnameTypeDeveloperPortal HostnameType = "DeveloperPortal"
	HostnameTypeManagement      HostnameType = "Management"
	HostnameTypePortal          HostnameType = "Portal"
	HostnameTypeProxy           HostnameType = "Proxy"
	HostnameTypeScm             HostnameType = "Scm"
)

// PossibleHostnameTypeValues returns the possible values for the HostnameType const type.
func PossibleHostnameTypeValues() []HostnameType {
	return []HostnameType{
		HostnameTypeDeveloperPortal,
		HostnameTypeManagement,
		HostnameTypePortal,
		HostnameTypeProxy,
		HostnameTypeScm,
	}
}

type IdentityProviderType string

const (
	// IdentityProviderTypeAAD - Azure Active Directory as Identity provider.
	IdentityProviderTypeAAD IdentityProviderType = "aad"
	// IdentityProviderTypeAADB2C - Azure Active Directory B2C as Identity provider.
	IdentityProviderTypeAADB2C IdentityProviderType = "aadB2C"
	// IdentityProviderTypeFacebook - Facebook as Identity provider.
	IdentityProviderTypeFacebook IdentityProviderType = "facebook"
	// IdentityProviderTypeGoogle - Google as Identity provider.
	IdentityProviderTypeGoogle IdentityProviderType = "google"
	// IdentityProviderTypeMicrosoft - Microsoft Live as Identity provider.
	IdentityProviderTypeMicrosoft IdentityProviderType = "microsoft"
	// IdentityProviderTypeTwitter - Twitter as Identity provider.
	IdentityProviderTypeTwitter IdentityProviderType = "twitter"
)

// PossibleIdentityProviderTypeValues returns the possible values for the IdentityProviderType const type.
func PossibleIdentityProviderTypeValues() []IdentityProviderType {
	return []IdentityProviderType{
		IdentityProviderTypeAAD,
		IdentityProviderTypeAADB2C,
		IdentityProviderTypeFacebook,
		IdentityProviderTypeGoogle,
		IdentityProviderTypeMicrosoft,
		IdentityProviderTypeTwitter,
	}
}

// IssueType - The type of issue.
type IssueType string

const (
	IssueTypeAgentStopped        IssueType = "AgentStopped"
	IssueTypeDNSResolution       IssueType = "DnsResolution"
	IssueTypeGuestFirewall       IssueType = "GuestFirewall"
	IssueTypeNetworkSecurityRule IssueType = "NetworkSecurityRule"
	IssueTypePlatform            IssueType = "Platform"
	IssueTypePortThrottled       IssueType = "PortThrottled"
	IssueTypeSocketBind          IssueType = "SocketBind"
	IssueTypeUnknown             IssueType = "Unknown"
	IssueTypeUserDefinedRoute    IssueType = "UserDefinedRoute"
)

// PossibleIssueTypeValues returns the possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{
		IssueTypeAgentStopped,
		IssueTypeDNSResolution,
		IssueTypeGuestFirewall,
		IssueTypeNetworkSecurityRule,
		IssueTypePlatform,
		IssueTypePortThrottled,
		IssueTypeSocketBind,
		IssueTypeUnknown,
		IssueTypeUserDefinedRoute,
	}
}

// KeyType - The Key to be used to generate token for user.
type KeyType string

const (
	KeyTypePrimary   KeyType = "primary"
	KeyTypeSecondary KeyType = "secondary"
)

// PossibleKeyTypeValues returns the possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{
		KeyTypePrimary,
		KeyTypeSecondary,
	}
}

// LoggerType - Logger type.
type LoggerType string

const (
	// LoggerTypeApplicationInsights - Azure Application Insights as log destination.
	LoggerTypeApplicationInsights LoggerType = "applicationInsights"
	// LoggerTypeAzureEventHub - Azure Event Hub as log destination.
	LoggerTypeAzureEventHub LoggerType = "azureEventHub"
	// LoggerTypeAzureMonitor - Azure Monitor
	LoggerTypeAzureMonitor LoggerType = "azureMonitor"
)

// PossibleLoggerTypeValues returns the possible values for the LoggerType const type.
func PossibleLoggerTypeValues() []LoggerType {
	return []LoggerType{
		LoggerTypeApplicationInsights,
		LoggerTypeAzureEventHub,
		LoggerTypeAzureMonitor,
	}
}

// Method - The HTTP method to be used.
type Method string

const (
	MethodGET  Method = "GET"
	MethodPOST Method = "POST"
)

// PossibleMethodValues returns the possible values for the Method const type.
func PossibleMethodValues() []Method {
	return []Method{
		MethodGET,
		MethodPOST,
	}
}

// NameAvailabilityReason - Invalid indicates the name provided does not match the resource provider’s naming requirements
// (incorrect length, unsupported characters, etc.) AlreadyExists indicates that the name is already in use
// and is therefore unavailable.
type NameAvailabilityReason string

const (
	NameAvailabilityReasonValid         NameAvailabilityReason = "Valid"
	NameAvailabilityReasonInvalid       NameAvailabilityReason = "Invalid"
	NameAvailabilityReasonAlreadyExists NameAvailabilityReason = "AlreadyExists"
)

// PossibleNameAvailabilityReasonValues returns the possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{
		NameAvailabilityReasonValid,
		NameAvailabilityReasonInvalid,
		NameAvailabilityReasonAlreadyExists,
	}
}

type NotificationName string

const (
	// NotificationNameAccountClosedPublisher - The following email recipients and users will receive email notifications when
	// developer closes his account.
	NotificationNameAccountClosedPublisher NotificationName = "AccountClosedPublisher"
	// NotificationNameBCC - The following recipients will receive blind carbon copies of all emails sent to developers.
	NotificationNameBCC NotificationName = "BCC"
	// NotificationNameNewApplicationNotificationMessage - The following email recipients and users will receive email notifications
	// when new applications are submitted to the application gallery.
	NotificationNameNewApplicationNotificationMessage NotificationName = "NewApplicationNotificationMessage"
	// NotificationNameNewIssuePublisherNotificationMessage - The following email recipients and users will receive email notifications
	// when a new issue or comment is submitted on the developer portal.
	NotificationNameNewIssuePublisherNotificationMessage NotificationName = "NewIssuePublisherNotificationMessage"
	// NotificationNamePurchasePublisherNotificationMessage - The following email recipients and users will receive email notifications
	// about new API product subscriptions.
	NotificationNamePurchasePublisherNotificationMessage NotificationName = "PurchasePublisherNotificationMessage"
	// NotificationNameQuotaLimitApproachingPublisherNotificationMessage - The following email recipients and users will receive
	// email notifications when subscription usage gets close to usage quota.
	NotificationNameQuotaLimitApproachingPublisherNotificationMessage NotificationName = "QuotaLimitApproachingPublisherNotificationMessage"
	// NotificationNameRequestPublisherNotificationMessage - The following email recipients and users will receive email notifications
	// about subscription requests for API products requiring approval.
	NotificationNameRequestPublisherNotificationMessage NotificationName = "RequestPublisherNotificationMessage"
)

// PossibleNotificationNameValues returns the possible values for the NotificationName const type.
func PossibleNotificationNameValues() []NotificationName {
	return []NotificationName{
		NotificationNameAccountClosedPublisher,
		NotificationNameBCC,
		NotificationNameNewApplicationNotificationMessage,
		NotificationNameNewIssuePublisherNotificationMessage,
		NotificationNamePurchasePublisherNotificationMessage,
		NotificationNameQuotaLimitApproachingPublisherNotificationMessage,
		NotificationNameRequestPublisherNotificationMessage,
	}
}

// OperationNameFormat - The format of the Operation Name for Application Insights telemetries. Default is Name.
type OperationNameFormat string

const (
	// OperationNameFormatName - API_NAME;rev=API_REVISION - OPERATION_NAME
	OperationNameFormatName OperationNameFormat = "Name"
	// OperationNameFormatURL - HTTP_VERB URL
	OperationNameFormatURL OperationNameFormat = "Url"
)

// PossibleOperationNameFormatValues returns the possible values for the OperationNameFormat const type.
func PossibleOperationNameFormatValues() []OperationNameFormat {
	return []OperationNameFormat{
		OperationNameFormatName,
		OperationNameFormatURL,
	}
}

// Origin - The origin of the issue.
type Origin string

const (
	OriginInbound  Origin = "Inbound"
	OriginLocal    Origin = "Local"
	OriginOutbound Origin = "Outbound"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginInbound,
		OriginLocal,
		OriginOutbound,
	}
}

// PlatformVersion - Compute Platform Version running the service.
type PlatformVersion string

const (
	// PlatformVersionMtv1 - Platform running the service on Multi Tenant V1 platform.
	PlatformVersionMtv1 PlatformVersion = "mtv1"
	// PlatformVersionStv1 - Platform running the service on Single Tenant V1 platform.
	PlatformVersionStv1 PlatformVersion = "stv1"
	// PlatformVersionStv2 - Platform running the service on Single Tenant V2 platform.
	PlatformVersionStv2 PlatformVersion = "stv2"
	// PlatformVersionUndetermined - Platform version cannot be determined, as compute platform is not deployed.
	PlatformVersionUndetermined PlatformVersion = "undetermined"
)

// PossiblePlatformVersionValues returns the possible values for the PlatformVersion const type.
func PossiblePlatformVersionValues() []PlatformVersion {
	return []PlatformVersion{
		PlatformVersionMtv1,
		PlatformVersionStv1,
		PlatformVersionStv2,
		PlatformVersionUndetermined,
	}
}

// PolicyContentFormat - Format of the policyContent.
type PolicyContentFormat string

const (
	// PolicyContentFormatRawxml - The contents are inline and Content type is a non XML encoded policy document.
	PolicyContentFormatRawxml PolicyContentFormat = "rawxml"
	// PolicyContentFormatRawxmlLink - The policy document is not Xml encoded and is hosted on a http endpoint accessible from
	// the API Management service.
	PolicyContentFormatRawxmlLink PolicyContentFormat = "rawxml-link"
	// PolicyContentFormatXML - The contents are inline and Content type is an XML document.
	PolicyContentFormatXML PolicyContentFormat = "xml"
	// PolicyContentFormatXMLLink - The policy XML document is hosted on a http endpoint accessible from the API Management service.
	PolicyContentFormatXMLLink PolicyContentFormat = "xml-link"
)

// PossiblePolicyContentFormatValues returns the possible values for the PolicyContentFormat const type.
func PossiblePolicyContentFormatValues() []PolicyContentFormat {
	return []PolicyContentFormat{
		PolicyContentFormatRawxml,
		PolicyContentFormatRawxmlLink,
		PolicyContentFormatXML,
		PolicyContentFormatXMLLink,
	}
}

type PolicyExportFormat string

const (
	// PolicyExportFormatRawxml - The contents are inline and Content type is a non XML encoded policy document.
	PolicyExportFormatRawxml PolicyExportFormat = "rawxml"
	// PolicyExportFormatXML - The contents are inline and Content type is an XML document.
	PolicyExportFormatXML PolicyExportFormat = "xml"
)

// PossiblePolicyExportFormatValues returns the possible values for the PolicyExportFormat const type.
func PossiblePolicyExportFormatValues() []PolicyExportFormat {
	return []PolicyExportFormat{
		PolicyExportFormatRawxml,
		PolicyExportFormatXML,
	}
}

type PolicyIDName string

const (
	PolicyIDNamePolicy PolicyIDName = "policy"
)

// PossiblePolicyIDNameValues returns the possible values for the PolicyIDName const type.
func PossiblePolicyIDNameValues() []PolicyIDName {
	return []PolicyIDName{
		PolicyIDNamePolicy,
	}
}

type PolicyScopeContract string

const (
	PolicyScopeContractTenant    PolicyScopeContract = "Tenant"
	PolicyScopeContractProduct   PolicyScopeContract = "Product"
	PolicyScopeContractAPI       PolicyScopeContract = "Api"
	PolicyScopeContractOperation PolicyScopeContract = "Operation"
	PolicyScopeContractAll       PolicyScopeContract = "All"
)

// PossiblePolicyScopeContractValues returns the possible values for the PolicyScopeContract const type.
func PossiblePolicyScopeContractValues() []PolicyScopeContract {
	return []PolicyScopeContract{
		PolicyScopeContractTenant,
		PolicyScopeContractProduct,
		PolicyScopeContractAPI,
		PolicyScopeContractOperation,
		PolicyScopeContractAll,
	}
}

// PortalRevisionStatus - Status of the portal's revision.
type PortalRevisionStatus string

const (
	// PortalRevisionStatusCompleted - Portal's revision publishing completed.
	PortalRevisionStatusCompleted PortalRevisionStatus = "completed"
	// PortalRevisionStatusFailed - Portal's revision publishing failed.
	PortalRevisionStatusFailed PortalRevisionStatus = "failed"
	// PortalRevisionStatusPending - Portal's revision has been queued.
	PortalRevisionStatusPending PortalRevisionStatus = "pending"
	// PortalRevisionStatusPublishing - Portal's revision is being published.
	PortalRevisionStatusPublishing PortalRevisionStatus = "publishing"
)

// PossiblePortalRevisionStatusValues returns the possible values for the PortalRevisionStatus const type.
func PossiblePortalRevisionStatusValues() []PortalRevisionStatus {
	return []PortalRevisionStatus{
		PortalRevisionStatusCompleted,
		PortalRevisionStatusFailed,
		PortalRevisionStatusPending,
		PortalRevisionStatusPublishing,
	}
}

// PreferredIPVersion - The IP version to be used. Only IPv4 is supported for now.
type PreferredIPVersion string

const (
	PreferredIPVersionIPv4 PreferredIPVersion = "IPv4"
)

// PossiblePreferredIPVersionValues returns the possible values for the PreferredIPVersion const type.
func PossiblePreferredIPVersionValues() []PreferredIPVersion {
	return []PreferredIPVersion{
		PreferredIPVersionIPv4,
	}
}

// PrivateEndpointConnectionProvisioningState - The current provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = "Creating"
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = "Deleting"
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = "Failed"
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns the possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{
		PrivateEndpointConnectionProvisioningStateCreating,
		PrivateEndpointConnectionProvisioningStateDeleting,
		PrivateEndpointConnectionProvisioningStateFailed,
		PrivateEndpointConnectionProvisioningStateSucceeded,
	}
}

// PrivateEndpointServiceConnectionStatus - The private endpoint connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	PrivateEndpointServiceConnectionStatusPending  PrivateEndpointServiceConnectionStatus = "Pending"
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns the possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{
		PrivateEndpointServiceConnectionStatusApproved,
		PrivateEndpointServiceConnectionStatusPending,
		PrivateEndpointServiceConnectionStatusRejected,
	}
}

// ProductState - whether product is published or not. Published products are discoverable by users of developer portal. Non
// published products are visible only to administrators. Default state of Product is
// notPublished.
type ProductState string

const (
	ProductStateNotPublished ProductState = "notPublished"
	ProductStatePublished    ProductState = "published"
)

// PossibleProductStateValues returns the possible values for the ProductState const type.
func PossibleProductStateValues() []ProductState {
	return []ProductState{
		ProductStateNotPublished,
		ProductStatePublished,
	}
}

type Protocol string

const (
	ProtocolHTTP  Protocol = "http"
	ProtocolHTTPS Protocol = "https"
	ProtocolWs    Protocol = "ws"
	ProtocolWss   Protocol = "wss"
)

// PossibleProtocolValues returns the possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{
		ProtocolHTTP,
		ProtocolHTTPS,
		ProtocolWs,
		ProtocolWss,
	}
}

// PublicNetworkAccess - Whether or not public endpoint access is allowed for this API Management service. Value is optional
// but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
// exclusive access method. Default value is 'Enabled'
type PublicNetworkAccess string

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	PublicNetworkAccessEnabled  PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
	}
}

// ResourceSKUCapacityScaleType - The scale type applicable to the sku.
type ResourceSKUCapacityScaleType string

const (
	// ResourceSKUCapacityScaleTypeAutomatic - Supported scale type automatic.
	ResourceSKUCapacityScaleTypeAutomatic ResourceSKUCapacityScaleType = "automatic"
	// ResourceSKUCapacityScaleTypeManual - Supported scale type manual.
	ResourceSKUCapacityScaleTypeManual ResourceSKUCapacityScaleType = "manual"
	// ResourceSKUCapacityScaleTypeNone - Scaling not supported.
	ResourceSKUCapacityScaleTypeNone ResourceSKUCapacityScaleType = "none"
)

// PossibleResourceSKUCapacityScaleTypeValues returns the possible values for the ResourceSKUCapacityScaleType const type.
func PossibleResourceSKUCapacityScaleTypeValues() []ResourceSKUCapacityScaleType {
	return []ResourceSKUCapacityScaleType{
		ResourceSKUCapacityScaleTypeAutomatic,
		ResourceSKUCapacityScaleTypeManual,
		ResourceSKUCapacityScaleTypeNone,
	}
}

// SKUType - Name of the Sku.
type SKUType string

const (
	// SKUTypeBasic - Basic SKU of Api Management.
	SKUTypeBasic SKUType = "Basic"
	// SKUTypeConsumption - Consumption SKU of Api Management.
	SKUTypeConsumption SKUType = "Consumption"
	// SKUTypeDeveloper - Developer SKU of Api Management.
	SKUTypeDeveloper SKUType = "Developer"
	// SKUTypeIsolated - Isolated SKU of Api Management.
	SKUTypeIsolated SKUType = "Isolated"
	// SKUTypePremium - Premium SKU of Api Management.
	SKUTypePremium SKUType = "Premium"
	// SKUTypeStandard - Standard SKU of Api Management.
	SKUTypeStandard SKUType = "Standard"
)

// PossibleSKUTypeValues returns the possible values for the SKUType const type.
func PossibleSKUTypeValues() []SKUType {
	return []SKUType{
		SKUTypeBasic,
		SKUTypeConsumption,
		SKUTypeDeveloper,
		SKUTypeIsolated,
		SKUTypePremium,
		SKUTypeStandard,
	}
}

// SamplingType - Sampling type.
type SamplingType string

const (
	// SamplingTypeFixed - Fixed-rate sampling.
	SamplingTypeFixed SamplingType = "fixed"
)

// PossibleSamplingTypeValues returns the possible values for the SamplingType const type.
func PossibleSamplingTypeValues() []SamplingType {
	return []SamplingType{
		SamplingTypeFixed,
	}
}

// SchemaType - Schema Type. Immutable.
type SchemaType string

const (
	// SchemaTypeJSON - Json schema type.
	SchemaTypeJSON SchemaType = "json"
	// SchemaTypeXML - Xml schema type.
	SchemaTypeXML SchemaType = "xml"
)

// PossibleSchemaTypeValues returns the possible values for the SchemaType const type.
func PossibleSchemaTypeValues() []SchemaType {
	return []SchemaType{
		SchemaTypeJSON,
		SchemaTypeXML,
	}
}

type SettingsTypeName string

const (
	SettingsTypeNamePublic SettingsTypeName = "public"
)

// PossibleSettingsTypeNameValues returns the possible values for the SettingsTypeName const type.
func PossibleSettingsTypeNameValues() []SettingsTypeName {
	return []SettingsTypeName{
		SettingsTypeNamePublic,
	}
}

// Severity - The severity of the issue.
type Severity string

const (
	SeverityError   Severity = "Error"
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns the possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{
		SeverityError,
		SeverityWarning,
	}
}

// SoapAPIType - Type of API to create.
// * http creates a REST API
// * soap creates a SOAP pass-through API
// * websocket creates websocket API
// * graphql creates GraphQL API.
type SoapAPIType string

const (
	// SoapAPITypeGraphQL - Imports the API having a GraphQL front end.
	SoapAPITypeGraphQL SoapAPIType = "graphql"
	// SoapAPITypeSoapPassThrough - Imports the SOAP API having a SOAP front end.
	SoapAPITypeSoapPassThrough SoapAPIType = "soap"
	// SoapAPITypeSoapToRest - Imports a SOAP API having a RESTful front end.
	SoapAPITypeSoapToRest SoapAPIType = "http"
	// SoapAPITypeWebSocket - Imports the API having a Websocket front end.
	SoapAPITypeWebSocket SoapAPIType = "websocket"
)

// PossibleSoapAPITypeValues returns the possible values for the SoapAPIType const type.
func PossibleSoapAPITypeValues() []SoapAPIType {
	return []SoapAPIType{
		SoapAPITypeGraphQL,
		SoapAPITypeSoapPassThrough,
		SoapAPITypeSoapToRest,
		SoapAPITypeWebSocket,
	}
}

// State - Status of the issue.
type State string

const (
	// StateClosed - The issue was closed.
	StateClosed State = "closed"
	// StateOpen - The issue is opened.
	StateOpen State = "open"
	// StateProposed - The issue is proposed.
	StateProposed State = "proposed"
	// StateRemoved - The issue was removed.
	StateRemoved State = "removed"
	// StateResolved - The issue is now resolved.
	StateResolved State = "resolved"
)

// PossibleStateValues returns the possible values for the State const type.
func PossibleStateValues() []State {
	return []State{
		StateClosed,
		StateOpen,
		StateProposed,
		StateRemoved,
		StateResolved,
	}
}

// SubscriptionState - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription
// is blocked, and the subscriber cannot call any APIs of the product, * submitted – the
// subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription
// request has been denied by an administrator, * cancelled – the
// subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration
// date and was deactivated.
type SubscriptionState string

const (
	SubscriptionStateSuspended SubscriptionState = "suspended"
	SubscriptionStateActive    SubscriptionState = "active"
	SubscriptionStateExpired   SubscriptionState = "expired"
	SubscriptionStateSubmitted SubscriptionState = "submitted"
	SubscriptionStateRejected  SubscriptionState = "rejected"
	SubscriptionStateCancelled SubscriptionState = "cancelled"
)

// PossibleSubscriptionStateValues returns the possible values for the SubscriptionState const type.
func PossibleSubscriptionStateValues() []SubscriptionState {
	return []SubscriptionState{
		SubscriptionStateSuspended,
		SubscriptionStateActive,
		SubscriptionStateExpired,
		SubscriptionStateSubmitted,
		SubscriptionStateRejected,
		SubscriptionStateCancelled,
	}
}

type TemplateName string

const (
	TemplateNameAccountClosedDeveloper                            TemplateName = "accountClosedDeveloper"
	TemplateNameApplicationApprovedNotificationMessage            TemplateName = "applicationApprovedNotificationMessage"
	TemplateNameConfirmSignUpIdentityDefault                      TemplateName = "confirmSignUpIdentityDefault"
	TemplateNameEmailChangeIdentityDefault                        TemplateName = "emailChangeIdentityDefault"
	TemplateNameInviteUserNotificationMessage                     TemplateName = "inviteUserNotificationMessage"
	TemplateNameNewCommentNotificationMessage                     TemplateName = "newCommentNotificationMessage"
	TemplateNameNewDeveloperNotificationMessage                   TemplateName = "newDeveloperNotificationMessage"
	TemplateNameNewIssueNotificationMessage                       TemplateName = "newIssueNotificationMessage"
	TemplateNamePasswordResetByAdminNotificationMessage           TemplateName = "passwordResetByAdminNotificationMessage"
	TemplateNamePasswordResetIdentityDefault                      TemplateName = "passwordResetIdentityDefault"
	TemplateNamePurchaseDeveloperNotificationMessage              TemplateName = "purchaseDeveloperNotificationMessage"
	TemplateNameQuotaLimitApproachingDeveloperNotificationMessage TemplateName = "quotaLimitApproachingDeveloperNotificationMessage"
	TemplateNameRejectDeveloperNotificationMessage                TemplateName = "rejectDeveloperNotificationMessage"
	TemplateNameRequestDeveloperNotificationMessage               TemplateName = "requestDeveloperNotificationMessage"
)

// PossibleTemplateNameValues returns the possible values for the TemplateName const type.
func PossibleTemplateNameValues() []TemplateName {
	return []TemplateName{
		TemplateNameAccountClosedDeveloper,
		TemplateNameApplicationApprovedNotificationMessage,
		TemplateNameConfirmSignUpIdentityDefault,
		TemplateNameEmailChangeIdentityDefault,
		TemplateNameInviteUserNotificationMessage,
		TemplateNameNewCommentNotificationMessage,
		TemplateNameNewDeveloperNotificationMessage,
		TemplateNameNewIssueNotificationMessage,
		TemplateNamePasswordResetByAdminNotificationMessage,
		TemplateNamePasswordResetIdentityDefault,
		TemplateNamePurchaseDeveloperNotificationMessage,
		TemplateNameQuotaLimitApproachingDeveloperNotificationMessage,
		TemplateNameRejectDeveloperNotificationMessage,
		TemplateNameRequestDeveloperNotificationMessage,
	}
}

// UserState - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer
// portal or call any APIs of subscribed products. Default state is Active.
type UserState string

const (
	// UserStateActive - User state is active.
	UserStateActive UserState = "active"
	// UserStateBlocked - User is blocked. Blocked users cannot authenticate at developer portal or call API.
	UserStateBlocked UserState = "blocked"
	// UserStateDeleted - User account is closed. All identities and related entities are removed.
	UserStateDeleted UserState = "deleted"
	// UserStatePending - User account is pending. Requires identity confirmation before it can be made active.
	UserStatePending UserState = "pending"
)

// PossibleUserStateValues returns the possible values for the UserState const type.
func PossibleUserStateValues() []UserState {
	return []UserState{
		UserStateActive,
		UserStateBlocked,
		UserStateDeleted,
		UserStatePending,
	}
}

// Verbosity - The verbosity level applied to traces emitted by trace policies.
type Verbosity string

const (
	// VerbosityError - Only traces with 'severity' set to 'error' will be sent to the logger attached to this diagnostic instance.
	VerbosityError Verbosity = "error"
	// VerbosityInformation - Traces with 'severity' set to 'information' and 'error' will be sent to the logger attached to this
	// diagnostic instance.
	VerbosityInformation Verbosity = "information"
	// VerbosityVerbose - All the traces emitted by trace policies will be sent to the logger attached to this diagnostic instance.
	VerbosityVerbose Verbosity = "verbose"
)

// PossibleVerbosityValues returns the possible values for the Verbosity const type.
func PossibleVerbosityValues() []Verbosity {
	return []Verbosity{
		VerbosityError,
		VerbosityInformation,
		VerbosityVerbose,
	}
}

// VersioningScheme - An value that determines where the API Version identifier will be located in a HTTP request.
type VersioningScheme string

const (
	// VersioningSchemeHeader - The API Version is passed in a HTTP header.
	VersioningSchemeHeader VersioningScheme = "Header"
	// VersioningSchemeQuery - The API Version is passed in a query parameter.
	VersioningSchemeQuery VersioningScheme = "Query"
	// VersioningSchemeSegment - The API Version is passed in a path segment.
	VersioningSchemeSegment VersioningScheme = "Segment"
)

// PossibleVersioningSchemeValues returns the possible values for the VersioningScheme const type.
func PossibleVersioningSchemeValues() []VersioningScheme {
	return []VersioningScheme{
		VersioningSchemeHeader,
		VersioningSchemeQuery,
		VersioningSchemeSegment,
	}
}

// VirtualNetworkType - The type of VPN in which API Management service needs to be configured in. None (Default Value) means
// the API Management service is not part of any Virtual Network, External means the API Management
// deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management
// deployment is setup inside a Virtual Network having an Intranet Facing Endpoint
// only.
type VirtualNetworkType string

const (
	// VirtualNetworkTypeExternal - The service is part of Virtual Network and it is accessible from Internet.
	VirtualNetworkTypeExternal VirtualNetworkType = "External"
	// VirtualNetworkTypeInternal - The service is part of Virtual Network and it is only accessible from within the virtual network.
	VirtualNetworkTypeInternal VirtualNetworkType = "Internal"
	// VirtualNetworkTypeNone - The service is not part of any Virtual Network.
	VirtualNetworkTypeNone VirtualNetworkType = "None"
)

// PossibleVirtualNetworkTypeValues returns the possible values for the VirtualNetworkType const type.
func PossibleVirtualNetworkTypeValues() []VirtualNetworkType {
	return []VirtualNetworkType{
		VirtualNetworkTypeExternal,
		VirtualNetworkTypeInternal,
		VirtualNetworkTypeNone,
	}
}
