/* { dg-do compile } */
/* { dg-options "-march=rv64gcv_zvfh_zvl4096b -mabi=lp64d -O3 -fno-schedule-insns -fno-schedule-insns2" } */
/* { dg-final { check-function-bodies "**" "" } } */

#include "def.h"

/*
** mov0:
**	lbu\s+[a-x0-9]+,0\s*\([a-x0-9]+\)
**	sb\s+[a-x0-9]+,0\s*\([a-x0-9]+\)
**  ret
*/
void mov0 (int8_t *in, int8_t *out)
{
  v1qi v = *(v1qi*)in;
  *(v1qi*)out = v;
}

/*
** mov1:
**	lhu\s+[a-x0-9]+,0\s*\([a-x0-9]+\)
**	sh\s+[a-x0-9]+,0\s*\([a-x0-9]+\)
**  ret
*/
void mov1 (int8_t *in, int8_t *out)
{
  v2qi v = *(v2qi*)in;
  *(v2qi*)out = v;
}

/*
** mov2:
**	lw\s+[a-x0-9]+,0\s*\([a-x0-9]+\)
**	sw\s+[a-x0-9]+,0\s*\([a-x0-9]+\)
**  ret
*/
void mov2 (int8_t *in, int8_t *out)
{
  v4qi v = *(v4qi*)in;
  *(v4qi*)out = v;
}

/*
** mov3:
**	ld\s+[a-x0-9]+,0\s*\([a-x0-9]+\)
**	sd\s+[a-x0-9]+,0\s*\([a-x0-9]+\)
**  ret
*/
void mov3 (int8_t *in, int8_t *out)
{
  v8qi v = *(v8qi*)in;
  *(v8qi*)out = v;
}

/*
** mov4:
**	vsetivli\s+zero,\s*16,\s*e8,\s*mf8,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov4 (int8_t *in, int8_t *out)
{
  v16qi v = *(v16qi*)in;
  *(v16qi*)out = v;
}

/*
** mov5:
**	li\s+[a-x0-9]+,32
**	vsetvli\s+zero,\s*[a-x0-9]+,\s*e8,\s*mf8,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov5 (int8_t *in, int8_t *out)
{
  v32qi v = *(v32qi*)in;
  *(v32qi*)out = v;
}

/*
** mov6:
**	li\s+[a-x0-9]+,64
**	vsetvli\s+zero,\s*[a-x0-9]+,\s*e8,\s*mf8,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov6 (int8_t *in, int8_t *out)
{
  v64qi v = *(v64qi*)in;
  *(v64qi*)out = v;
}

/*
** mov7:
**	li\s+[a-x0-9]+,128
**	vsetvli\s+zero,\s*[a-x0-9]+,\s*e8,\s*mf4,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov7 (int8_t *in, int8_t *out)
{
  v128qi v = *(v128qi*)in;
  *(v128qi*)out = v;
}

/*
** mov8:
**	li\s+[a-x0-9]+,256
**	vsetvli\s+zero,\s*[a-x0-9]+,\s*e8,\s*mf2,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov8 (int8_t *in, int8_t *out)
{
  v256qi v = *(v256qi*)in;
  *(v256qi*)out = v;
}

/*
** mov9:
**	li\s+[a-x0-9]+,512
**	vsetvli\s+zero,\s*[a-x0-9]+,\s*e8,\s*m1,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov9 (int8_t *in, int8_t *out)
{
  v512qi v = *(v512qi*)in;
  *(v512qi*)out = v;
}

/*
** mov10:
**	li\s+[a-x0-9]+,1024
**	vsetvli\s+zero,\s*[a-x0-9]+,\s*e8,\s*m2,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov10 (int8_t *in, int8_t *out)
{
  v1024qi v = *(v1024qi*)in;
  *(v1024qi*)out = v;
}

/*
** mov11:
**	li\s+[a-x0-9]+,4096
**	addi\s+[a-x0-9]+,[a-x0-9]+,-2048
**	vsetvli\s+zero,\s*[a-x0-9]+,\s*e8,\s*m4,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov11 (int8_t *in, int8_t *out)
{
  v2048qi v = *(v2048qi*)in;
  *(v2048qi*)out = v;
}

/*
** mov12:
**	li\s+[a-x0-9]+,4096
**	vsetvli\s+zero,\s*[a-x0-9]+,\s*e8,\s*m8,\s*t[au],\s*m[au]
**	vle8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**	vse8\.v\s+(?:v[0-9]|v[1-2][0-9]|v3[0-1]),0\s*\([a-x0-9]+\)
**  ret
*/
void mov12 (int8_t *in, int8_t *out)
{
  v4096qi v = *(v4096qi*)in;
  *(v4096qi*)out = v;
}
