/* { dg-do run { target { riscv_vector } } } */
/* { dg-options "-O2" } */

#include<cstdalign>
#include<cmath>
#include<cstddef>
#include<cstdint>
#include<iomanip>
#include<ios>
#include<iostream>
#include<memory>
#include<type_traits>
#include"riscv_vector.h"

using std::addressof;
using std::cerr;
using std::endl;
using std::int8_t;
using std::int16_t;
using std::int32_t;
using std::int64_t;
using std::uint8_t;
using std::uint16_t;
using std::uint32_t;
using std::uint64_t;
using std::ptrdiff_t;
using std::size_t;
using float16_t = _Float16;
using float32_t = float;
using float64_t = double;

template<class T, class T2>
constexpr T uint_to_float(T2 val) noexcept
{
  return *reinterpret_cast<T*>(&val);
}

constexpr const auto &f16(uint_to_float<float16_t, uint16_t>);
constexpr const auto &f32(uint_to_float<float32_t, uint32_t>);
constexpr const auto &f64(uint_to_float<float64_t, uint64_t>);

template<class T>
struct To_uint
{
  using type = std::conditional_t<
    sizeof(T) == 1, uint8_t, std::conditional_t<
      sizeof(T) == 2, uint16_t, std::conditional_t<
        sizeof(T) == 4, uint32_t, std::conditional_t<
          sizeof(T) == 8, uint64_t, void
        >
      >
    >
  >;
};

// isnan() does not support half type
template<class T>
struct To_float
{
  using type = std::conditional_t<
    std::is_same<T, float16_t>::value, float, std::conditional_t<
      std::is_same<T, float32_t>::value, float, std::conditional_t<
        std::is_same<T, float64_t>::value, double, float
      >
    >
  >;
};

template<class T>
using To_uint_t = typename To_uint<T>::type;

template<class T>
using To_isnan_float = typename To_float<T>::type;

template <class T>
void print_float(std::ostream &os, T val)
{
  using std::setw;
  os << std::hex << std::setfill('0') << setw(sizeof(T) * 2) << *reinterpret_cast<To_uint_t<T>*>(addressof(val)) << setw(0) << std::dec;
}

template <class T>
bool __attribute__((noinline))
check(const T *a, const T *b, size_t size)
{
  bool rv = true;
  for (size_t i = 0; i < (size / sizeof(T)); ++i) {
    if (reinterpret_cast<const To_uint_t<T> *>(a)[i] ==
        reinterpret_cast<const To_uint_t<T> *>(b)[i])
      continue;
    // floating negative zero == positive zero
    if ((std::is_floating_point_v<T> || std::is_same<T, float16_t>::value) &&
        (a[i] == b[i]))
      continue;
    // if both result are NaN, return true
    if ((std::is_same<T, float16_t>::value || std::is_floating_point_v<T>) &&
         std::isnan(static_cast<To_isnan_float<T>>(a[i])) &&
         std::isnan(static_cast<To_isnan_float<T>>(b[i])))
      continue;

    if (std::is_same<T, float16_t>::value) {
      cerr << std::hex << std::setfill('0') << std::setw(sizeof(T) * 2) << "["
           << i
           << "] result/golden:" << reinterpret_cast<const To_uint_t<T> *>(a)[i]
           << " != " << reinterpret_cast<const To_uint_t<T> *>(b)[i]
           << std::setw(0) << std::dec << endl;
    } else if constexpr (std::is_floating_point_v<T>) {
      cerr << "[" << i << "] result/golden:" << a[i] << "(";
      print_float(cerr, a[i]);
      cerr << ") != " << b[i] << "(";
      print_float(cerr, b[i]);
      cerr << ")" << endl;
    } else if constexpr (std::is_unsigned_v<T>) {
      cerr << "[" << i << "] result/golden: " << static_cast<uintmax_t>(a[i])
           << " != " << static_cast<uintmax_t>(b[i]) << endl;
    } else {
      cerr << "[" << i << "] result/golden:" << static_cast<intmax_t>(a[i])
           << " != " << static_cast<intmax_t>(b[i]) << endl;
    }
    rv = false;
  }
  return rv;
}

template <class T>
bool __attribute__((noinline))
check(const T a, const T golden)
{
  return check(addressof(a), addressof(golden), sizeof(T));
}



int main()
{
int return_value = 0;

size_t var_105 = 44u;
int32_t var_104 [] = {1965848711, -2086525137, -1803848050, 19567, -971536639, -1516385, -1, -807288451, 1, 69, -31113418};
size_t var_102 = 4u;
uint32_t var_101 [] = {1207313030u};
size_t var_99 = 15u;
uint8_t var_98 [] = {143u, 148u, 202u, 255u, 188u, 255u, 0u, 255u, 6u, 180u, 211u, 220u, 74u, 255u, 255u};
size_t var_96 = 2u;
uint16_t var_95 [] = {23766u};
uint32_t var_93 = 0u;
uint16_t var_91 [] = {49193u, 32352u, 9900u, 50089u};
uint16_t var_90 [] = {8891u, 57230u, 34982u};
uint16_t var_89 [] = {64061u, 52315u, 5021u};
uint16_t var_88 [] = {47003u};
int16_t var_87 [] = {-16180, 30442, -27639, -2800, 830, -16129, -24130, -24162, -16463, -16169, 9534, 6951, -29131, 8446, 24062};
uint8_t var_86 [] = {143u, 148u, 202u, 128u, 17u, 16u, 255u, 228u, 6u, 194u, 211u, 220u, 222u, 21u, 122u};
uint8_t var_85 [] = {152u, 3u, 124u, 172u, 129u, 175u, 37u, 69u, 235u, 55u, 186u, 250u, 194u, 199u, 244u};
uint64_t var_84 [] = {12545546372818825490u, 11634332929896642629u, 8733307811728114002u, 10860918623888276979u, 13489704078894613242u, 12413343993784960166u, 16106584277487222643u, 17042485112267319282u, 1684173737373229617u, 17871315199092643074u, 951050746696388267u, 5459702402058790198u, 14019717647186298924u, 5369338442959214891u, 14110032050054313318u};
uint64_t var_83 [] = {453774957859413236u, 6362459136171675404u, 967023828260427162u, 12332913600458807293u, 16921541007825084037u, 9616351827595519342u, 4247057396342547430u, 3809196068723072942u, 7431902286811921209u, 16629558845849341371u, 4458394429727454425u, 9250508760572153319u, 14924070495082841269u, 13738313966692186811u, 16877854274515520325u};
uint32_t var_82 [] = {1899881686u, 4080147581u, 2925343604u, 2936075900u, 4087201558u, 3727908130u, 1834017022u, 1518736660u, 733377872u, 907382512u};
uint32_t var_81 [] = {2204325838u};
uint16_t var_80 [] = {9064u, 36296u, 60321u, 552u, 61009u, 18827u, 18467u, 43553u, 8017u, 23645u, 41010u, 59795u, 16542u, 27096u, 46517u};
uint16_t var_79 [] = {63636u, 48200u, 63911u, 38172u, 65121u, 10226u, 42802u, 47807u, 36396u, 64207u, 7490u, 28781u, 24484u, 50212u, 47986u};
int32_t var_78 [] = {335332773, -2086525137, -1803848050, -861408915, -971536639, 89936413, -2128483556, -807288451, 1502472335, -1955364480, -639688186};
int32_t var_77 [] = {1965848711, 652198142, -654070005, 1282394958, 116719467, -1552777423, -52631872, 1455473636, 1916330932, 583051848, -1991258695};
uint32_t var_76 [] = {257189920u, 3908288874u, 4183117108u, 2985059984u, 4123446506u, 2586755754u, 1658155355u, 2054753754u, 2564238526u, 3891115063u, 2225254278u};
int32_t var_75 [] = {-235217549, -1765672370, 1092350198, -1701266898, 670572350, -788863284, 1240998336, -754510421, -1247918767, -436390665, -612945923};
uint64_t var_74 [] = {4538530792723095896u, 6728936314959424800u, 2414113211559319956u, 12007796423392768971u, 3601171482854517865u, 9629278271958260054u, 18242975527941306396u, 5160839807466719679u, 10245972782247532531u, 8853619422007764491u, 12041607275968659794u};
float64_t var_73 [] = {f64(8614060269474079662u), f64(12623683513218469367u), f64(11442194130057405520u), f64(6446105459198133268u), f64(380366903168625857u), f64(11473821136348234467u), f64(10058995585649001695u), f64(18250868123612936794u), f64(5822372664793573930u), f64(16528043770874104422u), f64(8552228426542510914u)};
// 7.039563158960176e+267, -2.1523339088794933e-81, -2.3863183489576286e-160, 8.745373785501378e+122, 3.1384579041605856e-283, -3.095650602331732e-158, -8.433135015760508e-253, -3.0795123331668087e+295, 1.7325021691170963e+81, -2.0363221572114366e+180, 4.978209728821851e+263

float64_t var_72 [] = {f64(3222442400634673465u), f64(49194355626135158u), f64(2619282863356225021u), f64(6202680391960624283u), f64(1894242076897167076u), f64(1473372219557024753u), f64(17948058332808594980u), f64(254766907045106756u), f64(5187702104895708698u), f64(17778229566843173273u), f64(15532650994783644871u)};
// 2.9261835584954886e-93, 2.1911430950940748e-305, 1.4067526365316684e-133, 4.6666902875718115e+106, 4.838617816764193e-182, 3.511247376604861e-210, -1.7581509460613583e+275, 1.2583108701066947e-291, 6.469667332696177e+38, -7.859407112445776e+263, -5.976033249736235e+113

int64_t var_71 [] = {5467749319186423848, -7667147751918509541, 593800074853473953, 6413262534774302136, 75427966376313524, 278644057209885757, 2969472779674870036, -5130814726456529304, -8496445620946198940, -5900460087019451181, -7035951954069660754};
uint16_t var_70 [] = {26357u, 35477u, 47484u, 46678u, 15433u, 30209u, 7010u, 17975u, 42110u, 9965u, 53873u};
uint64_t var_69 [] = {6442896275987497358u, 1563305414183179185u, 11193158183361973134u, 13636247099056349041u, 4490219238087428372u, 4573189455769797535u, 10624409184260926054u, 5514956187784411809u, 14501128089956573992u, 5109065909563099152u, 16213535287239099256u, 6283107178585528281u, 16632340116542335185u, 600060285728974968u, 3827913824182081159u};
uint64_t var_68 [] = {2067686263881693258u, 12371655115140460276u, 898390373048189950u, 649754230264648168u, 5012504791569343805u, 16874164695526011894u, 16924833210622228183u, 2805562827512188045u, 7465072367629716071u, 17045412384807346826u, 8575978714610309445u, 5748474768467091028u, 11979473091765990948u, 13760319101215726700u, 1788882170843726304u};
uint64_t var_67 [] = {4831708823516042734u, 3668152558332136794u, 9484665288845422345u, 921775477519817043u, 7038957512716032076u, 8368267462872907232u, 13525987403698074826u, 9033485416066501490u, 14922672290664661089u, 11277078323581784284u, 13748574820511946879u, 16280599129456136593u, 3424378972987661323u, 1750712290855073655u, 3947210869617561148u};
int16_t var_66 [] = {-24080, 24998, 9989, 20569, -2601, -10539, 12368, -29086, -7522, 1120, -13834, -17597, -5726, 2135, 29590};
uint8_t var_65 [] = {198u, 97u, 138u, 69u, 159u, 72u, 79u, 78u, 123u, 105u, 196u, 103u, 159u, 8u, 136u};
uint64_t var_64 [] = {14458637845423620742u, 10388543624287621821u, 1839618755313470511u, 15806879456819668453u, 11992843568410882569u, 17888054540471465292u, 16607055758216148595u, 10559588498955483388u, 16974549766507248252u, 18388996532108708959u, 6425574481918877909u, 4778349236525994346u, 933240166161765083u, 7918613081773265217u, 9419843050025446081u};
uint32_t var_63 [] = {786592415u, 3404752857u, 3845531527u, 3354073765u, 2261301168u, 3335412765u, 3988068717u, 3181127872u, 2948165023u, 2676932394u, 3500541227u};
uint32_t var_62 [] = {3512996747u, 3014603841u, 234827873u, 2359951919u, 774620885u, 3966492724u, 643827065u, 1817286301u, 2112613584u, 2206939407u, 1193735501u, 1704965662u, 3096558447u, 3455432162u, 2782347083u};
size_t var_61 = 5u;
size_t var_60 = 5u;
uint8_t var_59 = 87u;
uint32_t var_58 = 1207313030u;
uint64_t var_57 = 8520709894933587159u;
size_t var_56 = 7u;
uint16_t var_55 = 3639u;
int64_t var_54 = -1207966290208329859;
__riscv_vsetvl_e16m8(15);
vuint16m8_t var_8 = __riscv_vid_v_u16m8(15);
// 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14

__riscv_vsetvl_e16mf2(4);
vuint16mf2_t var_20 = __riscv_vle16_v_u16mf2(var_91, 4);
// 49193, 32352, 9900, 50089

__riscv_vsetvl_e16m1(3);
vuint16m1_t var_21 = __riscv_vle16_v_u16m1(var_90, 3);
// 8891, 57230, 34982

vuint16m1_t var_22 = __riscv_vle16_v_u16m1(var_89, 3);
// 64061, 52315, 5021

__riscv_vsetvl_e16m2(15);
vint16m2_t var_24 = __riscv_vle16_v_i16m2(var_87, 15);
// -16180, 30442, -27639, -2800, 830, -16129, -24130, -24162, -16463, -16169, 9534, 6951, -29131, 8446, 24062

vuint8m1_t var_26 = __riscv_vle8_v_u8m1(var_86, 15);
// 143, 148, 202, 128, 17, 16, 255, 228, 6, 194, 211, 220, 222, 21, 122

vuint64m8_t var_28 = __riscv_vle64_v_u64m8(var_84, 15);
// 12545546372818825490, 11634332929896642629, 8733307811728114002, 10860918623888276979, 13489704078894613242, 12413343993784960166, 16106584277487222643, 17042485112267319282, 1684173737373229617, 17871315199092643074, 951050746696388267, 5459702402058790198, 14019717647186298924, 5369338442959214891, 14110032050054313318

vuint64m8_t var_29 = __riscv_vle64_v_u64m8(var_83, 15);
// 453774957859413236, 6362459136171675404, 967023828260427162, 12332913600458807293, 16921541007825084037, 9616351827595519342, 4247057396342547430, 3809196068723072942, 7431902286811921209, 16629558845849341371, 4458394429727454425, 9250508760572153319, 14924070495082841269, 13738313966692186811, 16877854274515520325

__riscv_vsetvl_e32m4(10);
vuint32m4_t var_30 = __riscv_vle32_v_u32m4(var_82, 10);
// 1899881686, 4080147581, 2925343604, 2936075900, 4087201558, 3727908130, 1834017022, 1518736660, 733377872, 907382512

__riscv_vsetvl_e16m2(15);
vuint16m2_t var_32 = __riscv_vle16_v_u16m2(var_80, 15);
// 9064, 36296, 60321, 552, 61009, 18827, 18467, 43553, 8017, 23645, 41010, 59795, 16542, 27096, 46517

vuint16m2_t var_33 = __riscv_vle16_v_u16m2(var_79, 15);
// 63636, 48200, 63911, 38172, 65121, 10226, 42802, 47807, 36396, 64207, 7490, 28781, 24484, 50212, 47986

__riscv_vsetvl_e32m4(11);
vint32m4_t var_34 = __riscv_vle32_v_i32m4(var_78, 11);
// 335332773, -2086525137, -1803848050, -861408915, -971536639, 89936413, -2128483556, -807288451, 1502472335, -1955364480, -639688186

vint32m4_t var_35 = __riscv_vle32_v_i32m4(var_77, 11);
// 1965848711, 652198142, -654070005, 1282394958, 116719467, -1552777423, -52631872, 1455473636, 1916330932, 583051848, -1991258695

vuint32m4_t var_36 = __riscv_vle32_v_u32m4(var_76, 11);
// 257189920, 3908288874, 4183117108, 2985059984, 4123446506, 2586755754, 1658155355, 2054753754, 2564238526, 3891115063, 2225254278

vuint64m8_t var_39 = __riscv_vle64_v_u64m8(var_74, 11);
// 4538530792723095896, 6728936314959424800, 2414113211559319956, 12007796423392768971, 3601171482854517865, 9629278271958260054, 18242975527941306396, 5160839807466719679, 10245972782247532531, 8853619422007764491, 12041607275968659794

vfloat64m8_t var_40 = __riscv_vle64_v_f64m8(var_73, 11);
// 7.039563158960176e+267, -2.1523339088794933e-81, -2.3863183489576286e-160, 8.745373785501378e+122, 3.1384579041605856e-283, -3.095650602331732e-158, -8.433135015760508e-253, -3.0795123331668087e+295, 1.7325021691170963e+81, -2.0363221572114366e+180, 4.978209728821851e+263

vfloat64m8_t var_41 = __riscv_vle64_v_f64m8(var_72, 11);
// 2.9261835584954886e-93, 2.1911430950940748e-305, 1.4067526365316684e-133, 4.6666902875718115e+106, 4.838617816764193e-182, 3.511247376604861e-210, -1.7581509460613583e+275, 1.2583108701066947e-291, 6.469667332696177e+38, -7.859407112445776e+263, -5.976033249736235e+113

vint64m8_t var_44 = __riscv_vle64_v_i64m8(var_71, 11);
// 5467749319186423848, -7667147751918509541, 593800074853473953, 6413262534774302136, 75427966376313524, 278644057209885757, 2969472779674870036, -5130814726456529304, -8496445620946198940, -5900460087019451181, -7035951954069660754

vuint16m2_t var_45 = __riscv_vle16_v_u16m2(var_70, 11);
// 26357, 35477, 47484, 46678, 15433, 30209, 7010, 17975, 42110, 9965, 53873

__riscv_vsetvl_e64m8(15);
vuint64m8_t var_46 = __riscv_vle64_v_u64m8(var_69, 15);
// 6442896275987497358, 1563305414183179185, 11193158183361973134, 13636247099056349041, 4490219238087428372, 4573189455769797535, 10624409184260926054, 5514956187784411809, 14501128089956573992, 5109065909563099152, 16213535287239099256, 6283107178585528281, 16632340116542335185, 600060285728974968, 3827913824182081159

vuint64m8_t var_47 = __riscv_vle64_v_u64m8(var_68, 15);
// 2067686263881693258, 12371655115140460276, 898390373048189950, 649754230264648168, 5012504791569343805, 16874164695526011894, 16924833210622228183, 2805562827512188045, 7465072367629716071, 17045412384807346826, 8575978714610309445, 5748474768467091028, 11979473091765990948, 13760319101215726700, 1788882170843726304

vuint64m8_t var_48 = __riscv_vle64_v_u64m8(var_67, 15);
// 4831708823516042734, 3668152558332136794, 9484665288845422345, 921775477519817043, 7038957512716032076, 8368267462872907232, 13525987403698074826, 9033485416066501490, 14922672290664661089, 11277078323581784284, 13748574820511946879, 16280599129456136593, 3424378972987661323, 1750712290855073655, 3947210869617561148

vint16m2_t var_49 = __riscv_vle16_v_i16m2(var_66, 15);
// -24080, 24998, 9989, 20569, -2601, -10539, 12368, -29086, -7522, 1120, -13834, -17597, -5726, 2135, 29590

vuint8m1_t var_50 = __riscv_vle8_v_u8m1(var_65, 15);
// 198, 97, 138, 69, 159, 72, 79, 78, 123, 105, 196, 103, 159, 8, 136

vuint64m8_t var_51 = __riscv_vle64_v_u64m8(var_64, 15);
// 14458637845423620742, 10388543624287621821, 1839618755313470511, 15806879456819668453, 11992843568410882569, 17888054540471465292, 16607055758216148595, 10559588498955483388, 16974549766507248252, 18388996532108708959, 6425574481918877909, 4778349236525994346, 933240166161765083, 7918613081773265217, 9419843050025446081

__riscv_vsetvl_e32m4(11);
vuint32m4_t var_52 = __riscv_vle32_v_u32m4(var_63, 11);
// 786592415, 3404752857, 3845531527, 3354073765, 2261301168, 3335412765, 3988068717, 3181127872, 2948165023, 2676932394, 3500541227

__riscv_vsetvl_e32m4(15);
vuint32m4_t var_53 = __riscv_vle32_v_u32m4(var_62, 15);
// 3512996747, 3014603841, 234827873, 2359951919, 774620885, 3966492724, 643827065, 1817286301, 2112613584, 2206939407, 1193735501, 1704965662, 3096558447, 3455432162, 2782347083

__riscv_vsetvl_e16m8(15);
uint16_t var_7 = __riscv_vmv_x_s_u16m8_u16(var_8);
// 0

__riscv_vsetvl_e16mf2(4);
uint16_t var_19 = __riscv_vmv_x_s_u16mf2_u16(var_20);
// 49193

__riscv_vsetvl_e64m8(15);
vbool8_t var_25 = __riscv_vmadc_vv_u64m8_b8(var_28, var_29, 15);
// 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m4(1);
vuint32m4_t var_92 = __riscv_vminu_vx_u32m4(var_30, var_93, 1);
// 0

__riscv_vsetvl_e16m2(15);
vuint16m2_t var_14 = __riscv_vxor_vv_u16m2(var_32, var_33, 15);
// 56316, 12672, 4614, 38708, 4144, 28281, 61201, 4254, 37245, 42642, 48496, 39422, 7994, 44540, 3783

__riscv_vsetvl_e64m8(11);
vbool8_t var_38 = __riscv_vmfgt_vv_f64m8_b8(var_40, var_41, 11);
// 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool8_t var_43 = __riscv_vmseq_vx_i64m8_b8(var_44, var_54, 11);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool8_t var_42 = __riscv_vmsltu_vx_u16m2_b8(var_45, var_55, 11);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e64m8(15);
vuint64m8_t var_10 = __riscv_vnmsac_vv_u64m8(var_46, var_47, var_48, 15);
// 17730367217512192706, 13587514079205060073, 17006207964878783904, 399033182996474169, 7031375956492894968, 14246225807182425695, 8368573498063517888, 12016458229188596951, 4201530155301433889, 6917675740557523320, 7055050722106851901, 4551486304604362309, 9608429971601401157, 7096072642612805188, 15090163692241774087

vbool8_t var_5 = __riscv_vmseq_vx_u8m1_b8(var_50, var_59, 15);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vint16m2_t var_17 = __riscv_vmulhsu_vx_i16m2(var_24, var_19, 15);
// -12146, 22850, -20747, -2102, 623, -12107, -18113, -18137, -12358, -12137, 7156, 5217, -21867, 6339, 18061

vuint64m8_t var_4 = __riscv_vsrl_vx_u64m8_mu(var_5, var_10, var_51, var_60, 15);
// 17730367217512192706, 13587514079205060073, 17006207964878783904, 399033182996474169, 7031375956492894968, 14246225807182425695, 8368573498063517888, 12016458229188596951, 4201530155301433889, 6917675740557523320, 7055050722106851901, 4551486304604362309, 9608429971601401157, 7096072642612805188, 15090163692241774087

vbool8_t var_9 = __riscv_vmadc_vv_i16m2_b8(var_17, var_49, 15);
// 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vuint32m4_t var_2 = __riscv_vncvt_x_x_w_u32m4_mu(var_9, var_53, var_4, 15);
// 2030803650, 3014603841, 234827873, 3591973177, 774620885, 1394372191, 643827065, 4045083863, 1674932769, 2206939407, 1193735501, 1704965662, 3397690693, 3455432162, 2782347083

vuint32m4_t var_0 = __riscv_vwmaccu_vx_u32m4_mu(var_9, var_2, var_7, var_14, 15);
// 2030803650, 3014603841, 234827873, 3591973177, 774620885, 1394372191, 643827065, 4045083863, 1674932769, 2206939407, 1193735501, 1704965662, 3397690693, 3455432162, 2782347083

vuint16m2_t var_1 = __riscv_vnsrl_wx_u16m2(var_0, var_61, 15);
// 23766, 31138, 63875, 51529, 24118, 58226, 43, 55462, 43921, 22984, 14250, 64944, 9514, 44463, 47610

__riscv_vsetvl_e32m4(11);
vbool8_t var_3 = __riscv_vmadc_vvm_u32m4_b8(var_0, var_52, var_9, 11);
// 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m4(10);
vuint32m4_t var_6 = __riscv_vmv_s_x_u32m4_tu(var_0, var_58, 10);
// 1207313030, 3014603841, 234827873, 3591973177, 774620885, 1394372191, 643827065, 4045083863, 1674932769, 2206939407, 1193735501, 1704965662, 3397690693, 3455432162, 2782347083

__riscv_vsetvl_e8m1(15);
vuint8m1_t var_16 = __riscv_vnclipu_wx_u8m1_mu(var_25, var_26, var_1, var_56, 0, 15);
// 143, 148, 202, 255, 188, 255, 0, 255, 6, 180, 211, 220, 74, 255, 255

__riscv_vsetvl_e16m2(3);
vuint16m1_t var_18 = __riscv_vredminu_vs_u16m2_u16m1_tu(var_21, var_1, var_22, 3);
// 23766

__riscv_vsetvl_e8m1(11);
vbool8_t var_11 = __riscv_vmsif_m_b8_mu(var_3, var_42, var_43, 11);
// 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m4(1);
vuint32m4_t var_15 = __riscv_vrgather_vv_u32m4(var_6, var_92, 1);
// 1207313030

__riscv_vsetvl_e8m1(15);
__riscv_vse8_v_u8m1(var_85, var_16, 15);
__riscv_vsetvl_e16m1(1);
__riscv_vse16_v_u16m1(var_88, var_18, 1);
__riscv_vsetvl_e64m8(11);
vbool8_t var_12 = __riscv_vmsgeu_vx_u64m8_b8_mu(var_11, var_38, var_39, var_57, 11);
// 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m4(1);
__riscv_vse32_v_u32m4(var_81, var_15, 1);
if(!check(var_85, var_98, var_99)) {cerr << "check 97 fails" << endl; return_value = 1;}
if(!check(var_88, var_95, var_96)) {cerr << "check 94 fails" << endl; return_value = 1;}
__riscv_vsetvl_e32m4(11);
vint32m4_t var_13 = __riscv_vsra_vv_i32m4_mu(var_12, var_34, var_35, var_36, 11);
// 1965848711, -2086525137, -1803848050, 19567, -971536639, -1516385, -1, -807288451, 1, 69, -31113418

if(!check(var_81, var_101, var_102)) {cerr << "check 100 fails" << endl; return_value = 1;}
__riscv_vse32_v_i32m4(var_75, var_13, 11);
if(!check(var_75, var_104, var_105)) {cerr << "check 103 fails" << endl; return_value = 1;}
if (return_value)
  __builtin_abort ();
return return_value;
}
