/* { dg-do compile { target { powerpc*-*-linux* } } } */
/* { dg-require-effective-target powerpc_float128_sw_ok } */
/* { dg-options "-O2 -mdejagnu-cpu=power7 -mfloat128 -mno-regnames" } */

#ifndef __FLOAT128__
#error "-mfloat128 is not supported."
#endif

/* Pick a constant to load that cannot be generated by the power10 lxvkq
   instruction.  */
#ifdef __LONG_DOUBLE_IEEE128__
#define TYPE long double
#define TEN  10.0L

#else
#define TYPE __float128
#define TEN  10.0Q
#endif

/* Test to make sure vector registers are used for passing IEEE 128-bit
   floating point values and returning them. Also make sure the 'q' suffix is
   handled for __float128.  */
TYPE one (void) { return TEN; }
void store (TYPE a, TYPE *p) { *p = a; }

/* This regexp captures the different vector load/stores that can be generated:

	lxvd2x	-- big endian power7/power8, little endian power8
	lvx	-- Altivec
	lxv	-- D-form power9
	lxvx	-- X-form power9
	plxv	-- prefixed power10
	stxvd2x	-- big endian power7/power8, little endian power8
	stvx	-- Altivec
	stxvx	-- X-form vector store (power9/power10).
	stv	-- D-form vector store (power9 and above).
	pstv	-- prefixed vector store (power10 and above).  */

/* { dg-final { scan-assembler {\mlxvd2x 34\M|\mlvx 2\M|\mp?lxvx? 34\M} } } */
/* { dg-final { scan-assembler {\mstxvd2x 34\M|\mstvx 2\M|\mp?stxvx? 34\M} } } */
