/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.editor.Sequence;

public class Consensus {
    private int[][] matrix;
    private String cons = "";
    public static final String DEFAULT_SEQUENCE_NAME = "Consensus";

    public Consensus(File matrixFile, Vector seqs, float fplural, float setcase, int identity) {
        Matrix mat = new Matrix(matrixFile);
        this.matrix = mat.getMatrix();
        this.calculateCons(mat, seqs, fplural, setcase, identity);
    }

    public Consensus(String matrixJar, String matrixFileName, Vector seqs, float fplural, float setcase, int identity) {
        this(new Matrix(matrixJar, matrixFileName), seqs, fplural, setcase, identity);
    }

    public Consensus(Matrix mat, Vector seqs, float fplural, float setcase, int identity) {
        this.matrix = mat.getMatrix();
        this.calculateCons(mat, seqs, fplural, setcase, identity);
    }

    private void calculateCons(Matrix mat, Vector seqs, float fplural, float setcase, int identity) {
        int nseqs = seqs.size();
        int mlen = this.getMaxSequenceLength(seqs);
        String nocon = "-";
        if (((Sequence)seqs.get(0)).isProtein()) {
            nocon = "x";
        }
        String res = "";
        int matsize = mat.getIDimension();
        float[] identical = new float[matsize];
        float[] matching = new float[matsize];
        float[] score = new float[nseqs];
        float contri = 0.0f;
        float contrj = 0.0f;
        for (int k = 0; k < mlen; ++k) {
            int m2;
            String s2;
            int j;
            int m1;
            String s1;
            int i;
            res = nocon;
            for (i = 0; i < matsize; ++i) {
                identical[i] = 0.0f;
                matching[i] = 0.0f;
            }
            for (i = 0; i < nseqs; ++i) {
                score[i] = 0.0f;
            }
            for (i = 0; i < nseqs; ++i) {
                s1 = this.getResidue(seqs, i, k);
                m1 = mat.getMatrixIndex(s1);
                if (m1 >= 0) {
                    int n = m1;
                    identical[n] = identical[n] + this.getSequenceWeight(seqs, i);
                }
                for (j = i + 1; j < nseqs; ++j) {
                    s2 = this.getResidue(seqs, j, k);
                    m2 = mat.getMatrixIndex(s2);
                    if (m1 < 0 || m2 < 0) continue;
                    contri = (float)this.matrix[m1][m2] * this.getSequenceWeight(seqs, j) + score[i];
                    contrj = (float)this.matrix[m1][m2] * this.getSequenceWeight(seqs, i) + score[j];
                    score[i] = contri;
                    score[j] = contrj;
                }
            }
            int highindex = -1;
            float max = -2.1474836E9f;
            for (i = 0; i < nseqs; ++i) {
                if (!(score[i] > max) && (score[i] != max || !this.getResidue(seqs, highindex, k).equals("-") && !this.getResidue(seqs, highindex, k).equals("."))) continue;
                highindex = i;
                max = score[i];
            }
            for (i = 0; i < nseqs; ++i) {
                s1 = this.getResidue(seqs, i, k);
                m1 = mat.getMatrixIndex(s1);
                if (m1 == -1) {
                    JOptionPane.showMessageDialog(null, "<html>Jemboss Alignment Viewer; cannot find the residue <em>'" + s1 + "'</em> in the scoring matrix <em>'" + mat.getCurrentMatrixName() + "'</em></html>", "Error", 0);
                    return;
                }
                if (matching[m1] != 0.0f) continue;
                for (j = 0; j < nseqs; ++j) {
                    if (i == j) continue;
                    s2 = this.getResidue(seqs, j, k);
                    m2 = mat.getMatrixIndex(s2);
                    if (m1 < 0 || m2 < 0 || this.matrix[m1][m2] <= 0) continue;
                    int n = m1;
                    matching[n] = matching[n] + this.getSequenceWeight(seqs, j);
                }
            }
            int matchingmaxindex = 0;
            int identicalmaxindex = 0;
            for (i = 0; i < nseqs; ++i) {
                s1 = this.getResidue(seqs, i, k);
                m1 = mat.getMatrixIndex(s1);
                if (m1 < 0 || !(identical[m1] > identical[identicalmaxindex])) continue;
                identicalmaxindex = m1;
            }
            for (i = 0; i < nseqs; ++i) {
                s1 = this.getResidue(seqs, i, k);
                m1 = mat.getMatrixIndex(s1);
                if (m1 < 0) continue;
                if (matching[m1] > matching[matchingmaxindex]) {
                    matchingmaxindex = m1;
                    continue;
                }
                if (matching[m1] != matching[matchingmaxindex] || !(identical[m1] > identical[matchingmaxindex])) continue;
                matchingmaxindex = m1;
            }
            s1 = this.getResidue(seqs, highindex, k);
            m1 = mat.getMatrixIndex(s1);
            if (m1 >= 0 && matching[m1] >= fplural && !s1.equals("-") && !s1.equals(".")) {
                res = s1;
            }
            if (matching[m1] <= setcase) {
                res = res.toLowerCase();
            }
            if (identity > 0) {
                j = 0;
                for (i = 0; i < nseqs; ++i) {
                    s1 = this.getResidue(seqs, i, k);
                    m1 = mat.getMatrixIndex(s1);
                    if (matchingmaxindex != m1 || s1.equals("-") || s1.equals(".")) continue;
                    ++j;
                }
                if (j < identity) {
                    res = nocon;
                }
            }
            this.cons = this.cons.concat(res);
        }
    }

    public boolean isEqualSequenceLength(Vector seqs) {
        int len = 0;
        int numseq = 0;
        Enumeration enumer = seqs.elements();
        while (enumer.hasMoreElements()) {
            Sequence seq = (Sequence)enumer.nextElement();
            if (numseq > 0 && len != seq.getLength()) {
                return false;
            }
            len = seq.getLength();
            ++numseq;
        }
        return true;
    }

    public int getMaxSequenceLength(Vector seqs) {
        int len = 0;
        Enumeration enumer = seqs.elements();
        while (enumer.hasMoreElements()) {
            Sequence seq = (Sequence)enumer.nextElement();
            if (len >= seq.getLength()) continue;
            len = seq.getLength();
        }
        return len;
    }

    public Sequence getConsensusSequence() {
        return new Sequence(DEFAULT_SEQUENCE_NAME, this.cons);
    }

    public float getSequenceWeight(Vector seqs, int i) {
        return ((Sequence)seqs.get(i)).getWeight();
    }

    public String getResidue(Vector seqs, int i, int k) {
        String res = "-";
        try {
            res = ((Sequence)seqs.get(i)).getSequence().substring(k, k + 1);
        }
        catch (StringIndexOutOfBoundsException sexp) {
            // empty catch block
        }
        return res;
    }

    public static void main(String[] args) {
        Vector<Sequence> seqs = new Vector<Sequence>();
        seqs.add(new Sequence("MHQDGISSMNQLGGLFVNGRPQ"));
        seqs.add(new Sequence("-MQNSHSGVNQLGGVFVNGRPQ"));
        seqs.add(new Sequence("STPLGQGRVNQLGGVFINGRPP"));
        seqs.add(new Sequence("STPLGQGRVNQLGGVFINGRPP"));
        seqs.add(new Sequence("-MEQTYGEVNQLGGVFVNGRPE"));
        seqs.add(new Sequence("-MEQTYGEVNQLGGVFVNGRPE"));
        seqs.add(new Sequence("MHQDGISSMNQLGGLFVNGRPH"));
        seqs.add(new Sequence("MHQDGISSMNQLGGLFVNGRPR"));
        seqs.add(new Sequence("MHQDGISSMNQLLGLFVNGRPR"));
        seqs.add(new Sequence("MHQDGISSMNQLLGGGGGGGGR"));
        new Consensus(new File("/packages/emboss_dev/tcarver/emboss/emboss/emboss/data/EBLOSUM62"), seqs, 49.75f, 0.0f, 0);
    }
}

