/*++

Copyright (c)  1999  - 2014, Intel Corporation. All rights reserved

  This program and the accompanying materials are licensed and made available under
  the terms and conditions of the BSD License that accompanies this distribution.
  The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.php.

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.



Module Name:

  IgdOpRn.ASL

Abstract:

  IGD OpRegion/Software SCI Reference Code for the Baytrail Family.
  This file contains the interrupt handler code for the Integrated
  Graphics Device (IGD) OpRegion/Software SCI mechanism.

--*/


//NOTES:
//
// (1)  The code contained in this file inherits the scope in which it
//      was included.  So BIOS developers must be sure to include this
//      file in the scope associated with the graphics device
//      (ex. \_SB.PCI0.GFX0).
// (2)  Create a _L06 method under the GPE scope to handle the event
//      generated by the graphics driver.  The _L06 method must call
//      the GSCI method in this file.
// (3)  The MCHP operation region assumes that _ADR and _BBN names
//      corresponding to bus 0, device0, function 0 have been declared
//      under the PCI0 scope.
// (4)  Before the first execution of the GSCI method, the base address
//      of the GMCH SCI OpRegion must be programmed where the driver can
//      access it. A 32bit scratch register at 0xFC in the IGD PCI
//      configuration space (B0/D2/F0/R0FCh) is used for this purpose.

//  Define an OperationRegion to cover the GMCH PCI configuration space as
//  described in the IGD OpRegion specificiation.

//  Define an OperationRegion to cover the IGD PCI configuration space as
//  described in the IGD OpRegion specificiation.

OperationRegion(IGDP, PCI_Config,0x00,0x100)
Field(IGDP, AnyAcc, NoLock, Preserve)
{
  Offset(0x10),  // GTTMMADR
  MADR,   32,
  Offset(0x50),  // GMCH Graphics Control Register
  ,   1,
  GIVD,   1,     // IGD VGA disable bit
  ,   1,
  GUMA,   5,     // Stolen memory size
  ,   8,
  Offset(0x54),
  ,   4,
  GMFN,   1,     // Gfx function 1 enable
  ,   27,
  Offset(0x5C),  // Stolen Memory Base Address
  GSTM,   32,
  Offset(0xE0),  // Reg 0xE8, SWSCI control register
  GSSE,   1,     // Graphics SCI event (1=event pending)
  GSSB,   14,    // Graphics SCI scratchpad bits
  GSES,   1,     // Graphics event select (1=SCI)
  Offset(0xE4),
  ASLE,   8,     // Reg 0xE4, ASLE interrupt register
  ,   24,    // Only use first byte of ASLE reg
  Offset(0xFC),
  ASLS,   32,    // Reg 0xFC, Address of the IGD OpRegion
}

Method (MCHK, 0, Serialized)
{

  If (LNotEqual (MADR, 0xFFFFFFFF))
  {
    OperationRegion(IGMM,SystemMemory,MADR,0x3000)
    Field(IGMM,AnyAcc, NoLock, Preserve)
    {
      Offset(0X20C8),
      ,    4,
      DCFE,    4,                     // DISPLAY_CLOCK_FREQUENCY_ENCODING
    }
  }
}


//  Define an OperationRegion to cover the IGD OpRegion layout.

OperationRegion(IGDM, SystemMemory, ASLB, 0x2000)
Field(IGDM, AnyAcc, NoLock, Preserve)
{

  // OpRegion Header

  SIGN,   128,                    // Signature-"IntelGraphicsMem"
  SIZE,   32,                     // OpRegion Size
  OVER,   32,                     // OpRegion Version
  SVER,   256,                    // System BIOS Version
  VVER,   128,                    // VBIOS Version
  GVER,   128,                    // Driver version
  MBOX,   32,                     // Mailboxes supported
  DMOD,   32,                     // Driver Model
  PCON,   32,                     // 96, Platform Configuration

  // OpRegion Mailbox 1 (Public ACPI Methods)
  // Note: Mailbox 1 is normally reserved for desktop platforms.

  Offset(0x100),
  DRDY,   32,                     // Driver readiness (ACPI notification)
  CSTS,   32,                     // Notification status
  CEVT,   32,                     // Current event
  Offset(0x120),
  DIDL,   32,                     // Supported display device ID list
  DDL2,   32,                     // Allows for 8 devices
  DDL3,   32,
  DDL4,   32,
  DDL5,   32,
  DDL6,   32,
  DDL7,   32,
  DDL8,   32,
  CPDL,   32,                     // Currently present display list
  CPL2,   32,                     // Allows for 8 devices
  CPL3,   32,
  CPL4,   32,
  CPL5,   32,
  CPL6,   32,
  CPL7,   32,
  CPL8,   32,
  CAD1,   32,                     // Currently active display list
  CAL2,   32,                     // Allows for 8 devices
  CAL3,   32,
  CAL4,   32,
  CAL5,   32,
  CAL6,   32,
  CAL7,   32,
  CAL8,   32,
  NADL,   32,                     // Next active display list
  NDL2,   32,                     // Allows for 8 devices
  NDL3,   32,
  NDL4,   32,
  NDL5,   32,
  NDL6,   32,
  NDL7,   32,
  NDL8,   32,
  ASLP,   32,                     // ASL sleep timeout
  TIDX,   32,                     // Toggle table index
  CHPD,   32,                     // Current hot plug enable indicator
  CLID,   32,                     // Current lid state indicator
  CDCK,   32,                     // Current docking state indicator
  SXSW,   32,                     // Display switch notify on resume
  EVTS,   32,                     // Events supported by ASL (diag only)
  CNOT,   32,                     // Current OS notifications (diag only)
  NRDY,   32,

  // OpRegion Mailbox 2 (Software SCI Interface)

  Offset(0x200),                  // SCIC
  SCIE,   1,                      // SCI entry bit (1=call unserviced)
  GEFC,   4,                      // Entry function code
  GXFC,   3,                      // Exit result
  GESF,   8,                      // Entry/exit sub-function/parameter
  ,   16,                     // SCIC[31:16] reserved
  Offset(0x204),                  // PARM
  PARM,   32,                     // PARM register (extra parameters)
  DSLP,   32,                     // Driver sleep time out

  // OpRegion Mailbox 3 (BIOS to Driver Notification)
  // Note: Mailbox 3 is normally reserved for desktop platforms.

  Offset(0x300),
  ARDY,   32,                     // Driver readiness (power conservation)
  ASLC,   32,                     // ASLE interrupt command/status
  TCHE,   32,                     // Technology enabled indicator
  ALSI,   32,                     // Current ALS illuminance reading
  BCLP,   32,                     // Backlight brightness
  PFIT,   32,                     // Panel fitting state or request
  CBLV,   32,                     // Current brightness level
  BCLM,   320,                    // Backlight brightness level duty cycle mapping table
  CPFM,   32,                     // Current panel fitting mode
  EPFM,   32,                     // Enabled panel fitting modes
  PLUT,   592,                    // Optional. 74-byte Panel LUT Table
  PFMB,   32,                     // Optional. PWM Frequency and Minimum Brightness
  CCDV,   32,                     // Optional. Gamma, Brightness, Contrast values.
  PCFT,   32,                     // Optional. Power Conservation Features

  Offset(0x3B6),
  STAT,   32,                     // Status register

  // OpRegion Mailbox 4 (VBT)

  Offset(0x400),
  GVD1,   0xC000,                 // 6K bytes maximum VBT image

  // OpRegion Mailbox 5 (BIOS to Driver Notification Extension)

  Offset(0x1C00),
  PHED,   32,                     // Panel Header
  BDDC,   2048,                   // Panel EDID (Max 256 bytes)

}



// Convert boot display type into a port mask.

Name (DBTB, Package()
{
  0x0000,                         // Automatic
  0x0007,                         // Port-0 : Integrated CRT
  0x0038,                         // Port-1 : DVO-A, or Integrated LVDS
  0x01C0,                         // Port-2 : SDVO-B, or SDVO-B/C
  0x0E00,                         // Port-3 : SDVO-C
  0x003F,                         // [CRT + DVO-A / Integrated LVDS]
  0x01C7,                         // [CRT + SDVO-B] or [CRT + SDVO-B/C]
  0x0E07,                         // [CRT + SDVO-C]
  0x01F8,                         // [DVO-A / Integrated LVDS + SDVO-B]
  0x0E38,                         // [DVO-A / Integrated LVDS + SDVO-C]
  0x0FC0,                         // [SDVO-B + SDVO-C]
  0x0000,                         // Reserved
  0x0000,                         // Reserved
  0x0000,                         // Reserved
  0x0000,                         // Reserved
  0x0000,                         // Reserved
  0x7000,                         // Port-4: Integrated TV
  0x7007,                         // [Integrated TV + CRT]
  0x7038,                         // [Integrated TV + LVDS]
  0x71C0,                         // [Integrated TV + DVOB]
  0x7E00                          // [Integrated TV + DVOC]
})

// Core display clock value table.

Name (CDCT, Package()
{
  Package() {160},
  Package() {200},
  Package() {267},
  Package() {320},
  Package() {356},
  Package() {400},
})

// Defined exit result values:

Name (SUCC, 1)                          // Exit result: Success
Name (NVLD, 2)                          // Exit result: Invalid parameter
Name (CRIT, 4)                          // Exit result: Critical failure
Name (NCRT, 6)                          // Exit result: Non-critical failure


/************************************************************************;
;*
;* Name: GSCI
;*
;* Description: Handles an SCI generated by the graphics driver.  The
;*              PARM and SCIC input fields are parsed to determine the
;*              functionality requested by the driver.  GBDA or SBCB
;*              is called based on the input data in SCIC.
;*
;* Usage:       The method must be called in response to a GPE 06 event
;*              which will be generated by the graphics driver.
;*              Ex: Method(\_GPE._L06) {Return(\_SB.PCI0.GFX0.GSCI())}
;*
;* Input:       PARM and SCIC are indirect inputs
;*
;* Output:      PARM and SIC are indirect outputs
;*
;* References:  GBDA (Get BIOS Data method), SBCB (System BIOS Callback
;*              method)
;*
;************************************************************************/

Method (GSCI, 0, Serialized)
{
  Include("IgdOGBDA.ASL") // "Get BIOS Data" Functions
  Include("IgdOSBCB.ASL") // "System BIOS CallBacks"

  If (LEqual(GEFC, 4))
  {
    Store(GBDA(), GXFC)     // Process Get BIOS Data functions
  }

  If (LEqual(GEFC, 6))
  {
    Store(SBCB(), GXFC)     // Process BIOS Callback functions
  }

  Store(0, GEFC)                  // Wipe out the entry function code
  Store(1, SCIS)                  // Clear the GUNIT SCI status bit in PCH ACPI I/O space.
  Store(0, GSSE)                  // Clear the SCI generation bit in PCI space.
  Store(0, SCIE)                  // Clr SCI serviced bit to signal completion

  Return(Zero)
}

// Include MOBLFEAT.ASL for mobile systems only.  Remove for desktop.
Include("IgdOMOBF.ASL")     // IGD SCI mobile features
