      SUBROUTINE fdjac2(fcn,M,N,X,Fvec,Lauto,Gudrun,Fjac,Ldfjac,Iflag,
     &                  Epsfcn,Wa,Lckinv)
      IMPLICIT NONE
c-----------------------------------------------------------------------
c     fdjac2.f, Release 1, Subroutine Version 1.3, Modified 14 Feb 1995.
c-----------------------------------------------------------------------
      INTEGER M,N,Ldfjac,Iflag
      DOUBLE PRECISION Epsfcn
      DOUBLE PRECISION X(N),Fvec(M),Fjac(Ldfjac,N),Wa(M)
      LOGICAL Lauto,Gudrun,dpeq
      EXTERNAL fcn,dpeq
C     **********
C
C     SUBROUTINE FDJAC2
C
C     THIS SUBROUTINE COMPUTES A FORWARD-DIFFERENCE APPROXIMATION
C     TO THE M BY N JACOBIAN MATRIX ASSOCIATED WITH A SPECIFIED
C     PROBLEM OF M FUNCTIONS IN N VARIABLES.
C
C     THE SUBROUTINE STATEMENT IS
C
C       SUBROUTINE FDJAC2(FCN,M,N,X,FVEC,FJAC,LDFJAC,IFLAG,EPSFCN,WA)
C
C     WHERE
C
C       FCN IS THE NAME OF THE USER-SUPPLIED SUBROUTINE WHICH
C         CALCULATES THE FUNCTIONS. FCN MUST BE DECLARED
C         IN AN EXTERNAL STATEMENT IN THE USER CALLING
C         PROGRAM, AND SHOULD BE WRITTEN AS FOLLOWS.
c         lckinv is added to constrain the estimation inside the
c         invertibility and stationarity regions.
C
C         SUBROUTINE FCN(M,N,X,FVEC,IFLAG,lckinv)
C         INTEGER M,N,IFLAG
C         DOUBLE PRECISION X(N),FVEC(M)
C         ----------
C         CALCULATE THE FUNCTIONS AT X AND
C         RETURN THIS VECTOR IN FVEC.
C         ----------
C         RETURN
C         END
C
C         THE VALUE OF IFLAG SHOULD NOT BE CHANGED BY FCN UNLESS
C         THE USER WANTS TO TERMINATE EXECUTION OF FDJAC2.
C         IN THIS CASE SET IFLAG TO A NEGATIVE INTEGER.
C
C       M IS A POSITIVE INTEGER INPUT VARIABLE SET TO THE NUMBER
C         OF FUNCTIONS.
C
C       N IS A POSITIVE INTEGER INPUT VARIABLE SET TO THE NUMBER
C         OF VARIABLES. N MUST NOT EXCEED M.
C
C       X IS AN INPUT ARRAY OF LENGTH N.
C
C       FVEC IS AN INPUT ARRAY OF LENGTH M WHICH MUST CONTAIN THE
C         FUNCTIONS EVALUATED AT X.
C
C       FJAC IS AN OUTPUT M BY N ARRAY WHICH CONTAINS THE
C         APPROXIMATION TO THE JACOBIAN MATRIX EVALUATED AT X.
C
C       LDFJAC IS A POSITIVE INTEGER INPUT VARIABLE NOT LESS THAN M
C         WHICH SPECIFIES THE LEADING DIMENSION OF THE ARRAY FJAC.
C
C       IFLAG IS AN INTEGER VARIABLE WHICH CAN BE USED TO TERMINATE
C         THE EXECUTION OF FDJAC2. SEE DESCRIPTION OF FCN.
C
C       EPSFCN IS AN INPUT VARIABLE USED IN DETERMINING A SUITABLE
C         STEP LENGTH FOR THE FORWARD-DIFFERENCE APPROXIMATION. THIS
C         APPROXIMATION ASSUMES THAT THE RELATIVE ERRORS IN THE
C         FUNCTIONS ARE OF THE ORDER OF EPSFCN. IF EPSFCN IS LESS
C         THAN THE MACHINE PRECISION, IT IS ASSUMED THAT THE RELATIVE
C         ERRORS IN THE FUNCTIONS ARE OF THE ORDER OF THE MACHINE
C         PRECISION.
C
C       WA IS A WORK ARRAY OF LENGTH M.
C
C     SUBPROGRAMS CALLED
C
C       USER-SUPPLIED ...... FCN
C
C       MINPACK-SUPPLIED ... DPMPAR
C
C       FORTRAN-SUPPLIED ... DABS,DMAX1,DSQRT
C
C     ARGONNE NATIONAL LABORATORY. MINPACK PROJECT. MARCH 1980.
C     BURTON S. GARBOW, KENNETH E. HILLSTROM, JORGE J. MORE
C
C     **********
      INTEGER i,j
      LOGICAL Lckinv
      DOUBLE PRECISION eps,epsmch,h,temp,zero
      DOUBLE PRECISION dpmpar
      DATA zero/0.0D0/
C
C     EPSMCH IS THE MACHINE PRECISION.
C
      epsmch=dpmpar(1)
C
      eps=dsqrt(dmax1(Epsfcn,epsmch))
      DO j=1,N
       temp=X(j)
       h=eps*dabs(temp)
       IF(dpeq(h,zero))h=eps
       X(j)=temp+h
       CALL fcn(M,N,X,Wa,Lauto,Gudrun,Iflag,Lckinv)
       IF(Iflag.lt.0)GO TO 10
       X(j)=temp
       DO i=1,M
        Fjac(i,j)=(Wa(i)-Fvec(i))/h
       END DO
      END DO
   10 RETURN
C
C     LAST CARD OF SUBROUTINE FDJAC2.
C
      END
