#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# AGS games developed by Wormwood Studios:
# - Primordia
# - Strangeland
###

script_version=20231017.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID_PRIMORDIA='primordia'
GAME_NAME_PRIMORDIA='Primordia'

GAME_ID_STRANGELAND='strangeland'
GAME_NAME_STRANGELAND='Strangeland'

# Game archives

## Primordia

ARCHIVE_BASE_PRIMORDIA_2_NAME='primordia_3_0a_65125.sh'
ARCHIVE_BASE_PRIMORDIA_2_MD5='5b096e36b814c16c0ce067046e194c94'
ARCHIVE_BASE_PRIMORDIA_2_SIZE='1500000'
ARCHIVE_BASE_PRIMORDIA_2_VERSION='3.0a-gog65125'
ARCHIVE_BASE_PRIMORDIA_2_URL='https://www.gog.com/game/primordia'

ARCHIVE_BASE_PRIMORDIA_1_NAME='primordia_3_58594.sh'
ARCHIVE_BASE_PRIMORDIA_1_MD5='3cd92a7767d561f2d982014117ee0576'
ARCHIVE_BASE_PRIMORDIA_1_SIZE='1500000'
ARCHIVE_BASE_PRIMORDIA_1_VERSION='3.0-gog58594'

ARCHIVE_BASE_PRIMORDIA_0_NAME='primordia_italian_53699.sh'
ARCHIVE_BASE_PRIMORDIA_0_MD5='812917de017fde37b1c448f156e4ae7d'
ARCHIVE_BASE_PRIMORDIA_0_SIZE='1500000'
ARCHIVE_BASE_PRIMORDIA_0_VERSION='2.6-gog53699'

## Strangeland

ARCHIVE_BASE_STRANGELAND_3_NAME='strangeland_3_57270.sh'
ARCHIVE_BASE_STRANGELAND_3_MD5='68e18616d01d902c0982a3a1d1a8e3cd'
ARCHIVE_BASE_STRANGELAND_3_SIZE='4400000'
ARCHIVE_BASE_STRANGELAND_3_VERSION='3.0-gog57270'
ARCHIVE_BASE_STRANGELAND_3_URL='https://www.gog.com/game/strangeland'

ARCHIVE_BASE_STRANGELAND_2_NAME='strangeland_2_7_55701.sh'
ARCHIVE_BASE_STRANGELAND_2_MD5='719e693167ba8014aea03b858d9cd9c1'
ARCHIVE_BASE_STRANGELAND_2_SIZE='4400000'
ARCHIVE_BASE_STRANGELAND_2_VERSION='2.7-gog55701'

ARCHIVE_BASE_STRANGELAND_1_NAME='strangeland_2_6c_54396.sh'
ARCHIVE_BASE_STRANGELAND_1_MD5='afa5999b3074480966c2226f2356f6b9'
ARCHIVE_BASE_STRANGELAND_1_SIZE='4400000'
ARCHIVE_BASE_STRANGELAND_1_VERSION='2.6c-gog54396'

ARCHIVE_BASE_STRANGELAND_0_NAME='strangeland_2_3a_49446.sh'
ARCHIVE_BASE_STRANGELAND_0_MD5='a313a7ee812815b5e53ebc643c53da76'
ARCHIVE_BASE_STRANGELAND_0_SIZE='4400000'
ARCHIVE_BASE_STRANGELAND_0_VERSION='2.3a-gog49446'


CONTENT_PATH_DEFAULT_PRIMORDIA='data/noarch/game'
CONTENT_PATH_DEFAULT_STRANGELAND='data/noarch/game/data'
CONTENT_GAME_MAIN_FILES='
ENGV.tmp
Music
Sounds
*.ags
*.cfg
*.exe
*.ogv
*.tra
*.vox'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_SCUMMID='ags'
APP_MAIN_ICON_PRIMORDIA='Primordia.exe'
## Strangeland.exe is too big, wrestool crashes when trying to handle it.
APP_MAIN_ICON_STRANGELAND='winsetup.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

icons_inclusion
content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
