#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40k: Gladius
###

script_version=20230928.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='warhammer-40k-gladius'
GAME_NAME='Warhammer 40,000: Gladius - Relics of War'

ARCHIVE_BASE_43_NAME='warhammer_40_000_gladius_relics_of_war_1_12_03_67548.sh'
ARCHIVE_BASE_43_MD5='9bbcc5e63c4793fddceea5d8b8fbe1d8'
ARCHIVE_BASE_43_SIZE='3254164'
ARCHIVE_BASE_43_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_43_URL='https://www.gog.com/game/warhammer_40000_gladius_relics_of_war'

ARCHIVE_BASE_42_NAME='warhammer_40_000_gladius_relics_of_war_1_12_02_66467.sh'
ARCHIVE_BASE_42_MD5='cba472dd4cd2dc4c58d24473b1c25438'
ARCHIVE_BASE_42_SIZE='3300000'
ARCHIVE_BASE_42_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_41_NAME='warhammer_40_000_gladius_relics_of_war_1_12_01_65129.sh'
ARCHIVE_BASE_41_MD5='949846714b12f4831c6a689b52639113'
ARCHIVE_BASE_41_SIZE='3300000'
ARCHIVE_BASE_41_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_40_NAME='warhammer_40_000_gladius_relics_of_war_1_11_04_64361.sh'
ARCHIVE_BASE_40_MD5='eb7bcdf1a43f47dbc7407e309fd209a3'
ARCHIVE_BASE_40_SIZE='3200000'
ARCHIVE_BASE_40_VERSION='1.11.4-gog64361'
ARCHIVE_BASE_40_URL='https://www.gog.com/game/warhammer_40000_gladius_relics_of_war'

ARCHIVE_BASE_39_NAME='warhammer_40_000_gladius_relics_of_war_1_11_03_63999.sh'
ARCHIVE_BASE_39_MD5='b6deb32bd58a1736409159daf880e0e3'
ARCHIVE_BASE_39_SIZE='3200000'
ARCHIVE_BASE_39_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_38_NAME='warhammer_40_000_gladius_relics_of_war_1_11_02_63492.sh'
ARCHIVE_BASE_38_MD5='fcd73136618b7072aecce4e36ec82c1f'
ARCHIVE_BASE_38_SIZE='3200000'
ARCHIVE_BASE_38_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_37_NAME='warhammer_40_000_gladius_relics_of_war_1_11_01_01_61928.sh'
ARCHIVE_BASE_37_MD5='ce9bf8747bd257bc795a9680cbb3f2ee'
ARCHIVE_BASE_37_SIZE='3200000'
ARCHIVE_BASE_37_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_36_NAME='warhammer_40_000_gladius_relics_of_war_1_11_00_00a_60903.sh'
ARCHIVE_BASE_36_MD5='86fdc89c34b88d03334dca339c5a2c94'
ARCHIVE_BASE_36_SIZE='3200000'
ARCHIVE_BASE_36_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_35_NAME='warhammer_40_000_gladius_relics_of_war_1_10_01_00_57375.sh'
ARCHIVE_BASE_35_MD5='924bba1e75fdc323d72f24eccc2856a7'
ARCHIVE_BASE_35_SIZE='2900000'
ARCHIVE_BASE_35_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_34_NAME='warhammer_40_000_gladius_relics_of_war_1_10_00_00_56240.sh'
ARCHIVE_BASE_34_MD5='a1f2b4d24fe4756f58033a3e687a6e2a'
ARCHIVE_BASE_34_SIZE='2900000'
ARCHIVE_BASE_34_VERSION='1.10.00-gog56240'

ARCHIVE_BASE_33_NAME='warhammer_40_000_gladius_relics_of_war_v1_09_03_00_54377.sh'
ARCHIVE_BASE_33_MD5='f3271281015c34f1ce3c6974998d886f'
ARCHIVE_BASE_33_SIZE='2900000'
ARCHIVE_BASE_33_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_32_NAME='warhammer_40_000_gladius_relics_of_war_1_09_00_00_51561.sh'
ARCHIVE_BASE_32_MD5='358d8305f4f9ad5a9c55bbf8d37f08f3'
ARCHIVE_BASE_32_SIZE='2900000'
ARCHIVE_BASE_32_VERSION='1.9.0.0-gog51561'

ARCHIVE_BASE_31_NAME='warhammer_40_000_gladius_relics_of_war_1_08_04_01_49548.sh'
ARCHIVE_BASE_31_MD5='d2e88289b1b7b1ebe1037d999f14578e'
ARCHIVE_BASE_31_SIZE='2600000'
ARCHIVE_BASE_31_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_30_NAME='warhammer_40_000_gladius_relics_of_war_1_08_04_49482.sh'
ARCHIVE_BASE_30_MD5='8d1aaad3998bd8fa86565ad9e810a562'
ARCHIVE_BASE_30_SIZE='2600000'
ARCHIVE_BASE_30_VERSION='1.8.4-gog49482'

ARCHIVE_BASE_29_NAME='warhammer_40_000_gladius_relics_of_war_1_08_03_00_48497.sh'
ARCHIVE_BASE_29_MD5='5f0a15c13a84b0069de9397ffc46281a'
ARCHIVE_BASE_29_SIZE='2600000'
ARCHIVE_BASE_29_VERSION='1.8.3-gog48497'

ARCHIVE_BASE_28_NAME='warhammer_40_000_gladius_relics_of_war_1_07_04_44200.sh'
ARCHIVE_BASE_28_MD5='b8534d0956159736ee49f207da516ba6'
ARCHIVE_BASE_28_SIZE='2600000'
ARCHIVE_BASE_28_VERSION='1.7.4-gog44200'

ARCHIVE_BASE_27_NAME='warhammer_40_000_gladius_relics_of_war_1_07_03_43452.sh'
ARCHIVE_BASE_27_MD5='8350b6521fb0b66b31892d67f849cbcd'
ARCHIVE_BASE_27_SIZE='2600000'
ARCHIVE_BASE_27_VERSION='1.7.3-gog43452'

ARCHIVE_BASE_26_NAME='warhammer_40_000_gladius_relics_of_war_1_07_01_42686.sh'
ARCHIVE_BASE_26_MD5='e6c3cedfa4c9e5b51daa2e9b6b89c86b'
ARCHIVE_BASE_26_SIZE='2600000'
ARCHIVE_BASE_26_VERSION='1.7.1-gog42686'

ARCHIVE_BASE_25_NAME='warhammer_40_000_gladius_relics_of_war_1_07_00_42663.sh'
ARCHIVE_BASE_25_MD5='7b79c17dc30f78fafdc19759aa97f012'
ARCHIVE_BASE_25_SIZE='2600000'
ARCHIVE_BASE_25_VERSION='1.7.0-gog42663'

ARCHIVE_BASE_24_NAME='warhammer_40_000_gladius_relics_of_war_1_06_4b_41966.sh'
ARCHIVE_BASE_24_MD5='dbdcdd7450f009ffd2c5feae2fbc9fd2'
ARCHIVE_BASE_24_SIZE='2300000'
ARCHIVE_BASE_24_VERSION='1.6.4b-gog41966'

ARCHIVE_BASE_23_NAME='warhammer_40_000_gladius_relics_of_war_1_06_4a_40621.sh'
ARCHIVE_BASE_23_MD5='59a4a1ba453420a970edb886a0f179f0'
ARCHIVE_BASE_23_SIZE='2300000'
ARCHIVE_BASE_23_VERSION='1.6.4a-gog40621'

ARCHIVE_BASE_22_NAME='warhammer_40_000_gladius_relics_of_war_1_06_03_01_39396.sh'
ARCHIVE_BASE_22_MD5='a307b99b6d5b55ec19cd9d6747a5929b'
ARCHIVE_BASE_22_SIZE='2300000'
ARCHIVE_BASE_22_VERSION='1.6.3.1-gog39396'

ARCHIVE_BASE_21_NAME='warhammer_40_000_gladius_relics_of_war_1_06_02_38991.sh'
ARCHIVE_BASE_21_MD5='6d4455466f5f14bcfa49fb8730982837'
ARCHIVE_BASE_21_SIZE='2300000'
ARCHIVE_BASE_21_VERSION='1.6.2-gog38991'

ARCHIVE_BASE_20_NAME='warhammer_40_000_gladius_relics_of_war_1_05_01_36614.sh'
ARCHIVE_BASE_20_MD5='faf0d5df1a800d8102bdf20309aa9b6c'
ARCHIVE_BASE_20_SIZE='2200000'
ARCHIVE_BASE_20_VERSION='1.5.1-gog36614'

ARCHIVE_BASE_19_NAME='warhammer_40_000_gladius_relics_of_war_1_05_00_36394.sh'
ARCHIVE_BASE_19_MD5='84cb0b1a6f64fe2e239c4cd94fa34f92'
ARCHIVE_BASE_19_SIZE='2200000'
ARCHIVE_BASE_19_VERSION='1.5.0-gog36394'

ARCHIVE_BASE_18_NAME='warhammer_40_000_gladius_relics_of_war_1_04_07_36064.sh'
ARCHIVE_BASE_18_MD5='d42c72ef55cb2a42487f8173d26b2260'
ARCHIVE_BASE_18_SIZE='2300000'
ARCHIVE_BASE_18_VERSION='1.4.7-gog36064'

ARCHIVE_BASE_17_NAME='warhammer_40_000_gladius_relics_of_war_1_04_06_35728.sh'
ARCHIVE_BASE_17_MD5='012ed368d39019fde24d18fbec0656b6'
ARCHIVE_BASE_17_SIZE='2300000'
ARCHIVE_BASE_17_VERSION='1.4.6-gog35728'

ARCHIVE_BASE_16_NAME='warhammer_40_000_gladius_relics_of_war_1_04_05_01_35243.sh'
ARCHIVE_BASE_16_MD5='5b35850082c4c02a0eb37e19ba747f30'
ARCHIVE_BASE_16_SIZE='2300000'
ARCHIVE_BASE_16_VERSION='1.4.5.1-gog35243'

ARCHIVE_BASE_15_NAME='warhammer_40_000_gladius_relics_of_war_1_04_05_00_35202.sh'
ARCHIVE_BASE_15_MD5='972ef197130ab89e2bfe4db660d46f13'
ARCHIVE_BASE_15_SIZE='2300000'
ARCHIVE_BASE_15_VERSION='1.4.5.0-gog35202'

ARCHIVE_BASE_14_NAME='warhammer_40_000_gladius_relics_of_war_1_04_04_00_34697.sh'
ARCHIVE_BASE_14_MD5='14dae75096f06ae63d232adc19dfef21'
ARCHIVE_BASE_14_SIZE='2100000'
ARCHIVE_BASE_14_VERSION='1.4.4.0-gog34697'

ARCHIVE_BASE_13_NAME='warhammer_40_000_gladius_relics_of_war_1_04_03_01_34357.sh'
ARCHIVE_BASE_13_MD5='b174fa2e2f68a077e12f8b30fa3a35f0'
ARCHIVE_BASE_13_SIZE='2100000'
ARCHIVE_BASE_13_VERSION='1.4.3.1-gog34357'

ARCHIVE_BASE_12_NAME='warhammer_40_000_gladius_relics_of_war_1_04_03_34214.sh'
ARCHIVE_BASE_12_MD5='2d15061d4dbaef7d4e1cf6d7f187488e'
ARCHIVE_BASE_12_SIZE='2100000'
ARCHIVE_BASE_12_VERSION='1.4.3-gog34214'

ARCHIVE_BASE_11_NAME='warhammer_40_000_gladius_relics_of_war_1_04_01_33591.sh'
ARCHIVE_BASE_11_MD5='54c5c2a4c6763d922c718703ad480df9'
ARCHIVE_BASE_11_SIZE='2100000'
ARCHIVE_BASE_11_VERSION='1.4.1-gog33591'

ARCHIVE_BASE_10_NAME='warhammer_40_000_gladius_relics_of_war_1_04_01_33276.sh'
ARCHIVE_BASE_10_MD5='7e46463d849b90daa75bb3430cffe7e9'
ARCHIVE_BASE_10_SIZE='2100000'
ARCHIVE_BASE_10_VERSION='1.4.1-gog33276'

ARCHIVE_BASE_9_NAME='warhammer_40_000_gladius_relics_of_war_1_04_00_33227.sh'
ARCHIVE_BASE_9_MD5='cd2eb9299dddb4b3007bcb819a490ac9'
ARCHIVE_BASE_9_SIZE='2100000'
ARCHIVE_BASE_9_VERSION='1.4.0-gog33227'

ARCHIVE_BASE_8_NAME='warhammer_40_000_gladius_relics_of_war_1_03_08_32868.sh'
ARCHIVE_BASE_8_MD5='0739ede31aa10db01b2afef9f66c5e12'
ARCHIVE_BASE_8_SIZE='2100000'
ARCHIVE_BASE_8_VERSION='1.3.8-gog32868'

ARCHIVE_BASE_7_NAME='warhammer_40_000_gladius_relics_of_war_1_03_07_32417.sh'
ARCHIVE_BASE_7_MD5='c7b2c3399b54c40b52f8355460f9f95d'
ARCHIVE_BASE_7_SIZE='2100000'
ARCHIVE_BASE_7_VERSION='1.3.7-gog32417'

ARCHIVE_BASE_6_NAME='warhammer_40_000_gladius_relics_of_war_1_03_05_31840.sh'
ARCHIVE_BASE_6_MD5='3d44bb09b3beee7ea34e17b621f9ff03'
ARCHIVE_BASE_6_SIZE='2100000'
ARCHIVE_BASE_6_VERSION='1.3.5-gog31840'

ARCHIVE_BASE_5_NAME='warhammer_40_000_gladius_relics_of_war_1_03_04_06_31598.sh'
ARCHIVE_BASE_5_MD5='fa36d050eb352b52082beea3ef414324'
ARCHIVE_BASE_5_SIZE='2100000'
ARCHIVE_BASE_5_VERSION='1.3.4-gog31598'

ARCHIVE_BASE_4_NAME='warhammer_40_000_gladius_relics_of_war_1_03_03_31235.sh'
ARCHIVE_BASE_4_MD5='6e80aca35b75153c5c469584edf332fa'
ARCHIVE_BASE_4_SIZE='2000000'
ARCHIVE_BASE_4_VERSION='1.3.3-gog31235'

ARCHIVE_BASE_3_NAME='warhammer_40_000_gladius_relics_of_war_1_03_02a_31191.sh'
ARCHIVE_BASE_3_MD5='365ed8bc91dae2e38d2fe075601f372c'
ARCHIVE_BASE_3_SIZE='2000000'
ARCHIVE_BASE_3_VERSION='1.3.2-gog31191'

ARCHIVE_BASE_2_NAME='warhammer_40_000_gladius_relics_of_war_1_03_01_31091.sh'
ARCHIVE_BASE_2_MD5='57d2c488752a9bf1fd24843b232db78b'
ARCHIVE_BASE_2_SIZE='2000000'
ARCHIVE_BASE_2_VERSION='1.3.1-gog31091'

ARCHIVE_BASE_1_NAME='warhammer_40_000_gladius_relics_of_war_1_03_00_31042.sh'
ARCHIVE_BASE_1_MD5='c169fb5b60a2bf04a0e0ae625d53239b'
ARCHIVE_BASE_1_SIZE='2000000'
ARCHIVE_BASE_1_VERSION='1.3.0-gog31042'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/Binaries/Linux-x86_64"
## The game binary is linked against libsteam_api.so.
CONTENT_LIBS_BIN_FILES='
libavcodec.so.58
libavformat.so.58
libavutil.so.56
libcrypto.so.1.1
libboost_locale.so.1.65.1
libboost_system.so.1.65.1
libboost_thread.so.1.65.1
libEOSSDK-Linux-Shipping.so
libicudata.so.60
libicui18n.so.60
libicuuc.so.60
libjemalloc.so.1
libjpeg.so.8
libsteam_api.so
libswresample.so.3'
CONTENT_GAME_BIN_FILES='
Binaries/Linux-x86_64/Gladius.bin'
CONTENT_GAME_DATA_FILES='
Data
Documents
Manuals
Resources
*.doc
*.pdf'

APP_MAIN_PREFIX_TYPE='none'
APP_MAIN_EXE='Binaries/Linux-x86_64/Gladius.bin'
APP_MAIN_ICON='Data/Video/Textures/Icon.png'
## Run the game binary from its parent directory.
APP_MAIN_PRERUN='# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")
'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libcurl.so.4
libdl.so.2
libfreetype.so.6
libgcc_s.so.1
libglfw.so.3
libminiupnpc.so.17
libm.so.6
libopenal.so.1
libpng16.so.16
libpthread.so.0
librt.so.1
libstdc++.so.6
libvorbisfile.so.3
libvulkan.so.1
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
