#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40k: Gladius expansions:
# - Lord of Skulls
# - Reinforcement Pack
# - Tyranids
# - Chaos Space Marines
# - Fortification Pack
# - T'au
# - Assault Pack
# - Craftworld Aeldari
# - Specialist Pack
# - Adeptus Mechanicus
# - Escalation Pack
# - Adepta Sororitas
# - Firepower Pack
###

script_version=20230928.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='warhammer-40k-gladius'
GAME_NAME='Warhammer 40,000: Gladius'

EXPANSION_ID_LORDOFSKULLS='lord-of-skulls'
EXPANSION_NAME_LORDOFSKULLS='Lord of Skulls'

EXPANSION_ID_REINFORCEMENTPACK='reinforcement-pack'
EXPANSION_NAME_REINFORCEMENTPACK='Reinforcement Pack'

EXPANSION_ID_TYRANIDS='tyranids'
EXPANSION_NAME_TYRANIDS='Tyranids'

EXPANSION_ID_CHAOSSPACEMARINES='chaos-space-marines'
EXPANSION_NAME_CHAOSSPACEMARINES='Chaos Space Marines'

EXPANSION_ID_FORTIFICATIONPACK='fortification-pack'
EXPANSION_NAME_FORTIFICATIONPACK='Fortification Pack'

EXPANSION_ID_TAU='tau'
EXPANSION_NAME_TAU='Tʼau'

EXPANSION_ID_ASSAULTPACK='assault-pack'
EXPANSION_NAME_ASSAULTPACK='Assault Pack'

EXPANSION_ID_AELDARI='craftworld-aeldari'
EXPANSION_NAME_AELDARI='Craftworld Aeldari'

EXPANSION_ID_SPECIALIST='specialist-pack'
EXPANSION_NAME_SPECIALIST='Specialist Pack'

EXPANSION_ID_MECHANICUS='adeptus-mechanicus'
EXPANSION_NAME_MECHANICUS='Adeptus Mechanicus'

EXPANSION_ID_ESCALATION='escalation-pack'
EXPANSION_NAME_ESCALATION='Escalation Pack'

EXPANSION_ID_SORORITAS='adepta-sororitas'
EXPANSION_NAME_SORORITAS='Adepta Sororitas'

EXPANSION_ID_FIREPOWER='firepower-pack'
EXPANSION_NAME_FIREPOWER='Firepower Pack'

# Archives

## Lord of Skulls

ARCHIVE_BASE_LORDOFSKULLS_14_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_12_03_67548.sh'
ARCHIVE_BASE_LORDOFSKULLS_14_MD5='b0481ff1c15b0393bfd7c1b1c8d80709'
ARCHIVE_BASE_LORDOFSKULLS_14_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_14_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_LORDOFSKULLS_14_URL='https://www.gog.com/game/warhammer_40000_gladius_relics_of_war_lord_of_skulls'

ARCHIVE_BASE_LORDOFSKULLS_13_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_12_02_66467.sh'
ARCHIVE_BASE_LORDOFSKULLS_13_MD5='a110c4f9d61434c323af7ffc83c50149'
ARCHIVE_BASE_LORDOFSKULLS_13_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_13_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_LORDOFSKULLS_12_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_12_01_65129.sh'
ARCHIVE_BASE_LORDOFSKULLS_12_MD5='e785f66dca47430a33137d8f6bb453d5'
ARCHIVE_BASE_LORDOFSKULLS_12_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_12_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_LORDOFSKULLS_11_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_11_04_64361.sh'
ARCHIVE_BASE_LORDOFSKULLS_11_MD5='82bf8335b67ecfc66ca0a58abfee40b6'
ARCHIVE_BASE_LORDOFSKULLS_11_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_11_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_LORDOFSKULLS_10_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_11_03_63999.sh'
ARCHIVE_BASE_LORDOFSKULLS_10_MD5='4e668e6ec3236b496acd86579ce19494'
ARCHIVE_BASE_LORDOFSKULLS_10_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_10_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_LORDOFSKULLS_9_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_11_02_63492.sh'
ARCHIVE_BASE_LORDOFSKULLS_9_MD5='92ab6a1f5365381791949ccb29d1a343'
ARCHIVE_BASE_LORDOFSKULLS_9_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_9_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_LORDOFSKULLS_8_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_11_01_01_61928.sh'
ARCHIVE_BASE_LORDOFSKULLS_8_MD5='a5712fff8f73b24c14a17d563dae0d66'
ARCHIVE_BASE_LORDOFSKULLS_8_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_8_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_LORDOFSKULLS_7_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_11_00_00a_60903.sh'
ARCHIVE_BASE_LORDOFSKULLS_7_MD5='93e50305bdc6fc50995916fe477d4a38'
ARCHIVE_BASE_LORDOFSKULLS_7_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_7_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_LORDOFSKULLS_6_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_10_01_00_57375.sh'
ARCHIVE_BASE_LORDOFSKULLS_6_MD5='ad8818e83aec830eb11385cfbf1c3d10'
ARCHIVE_BASE_LORDOFSKULLS_6_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_6_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_LORDOFSKULLS_5_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_10_00_00_56240.sh'
ARCHIVE_BASE_LORDOFSKULLS_5_MD5='ae75bcc9c551f8aa8c75386c8dc990dd'
ARCHIVE_BASE_LORDOFSKULLS_5_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_5_VERSION='1.10.00-gog56240'

ARCHIVE_BASE_LORDOFSKULLS_4_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_v1_09_03_00_54377.sh'
ARCHIVE_BASE_LORDOFSKULLS_4_MD5='a3e949e976d3248ea338a4555454c804'
ARCHIVE_BASE_LORDOFSKULLS_4_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_4_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_LORDOFSKULLS_3_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_09_00_00_51561.sh'
ARCHIVE_BASE_LORDOFSKULLS_3_MD5='0ef437b23d184b66381bc08b2f812e49'
ARCHIVE_BASE_LORDOFSKULLS_3_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_3_VERSION='1.9.0.0-gog51561'

ARCHIVE_BASE_LORDOFSKULLS_2_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_08_04_01_49548.sh'
ARCHIVE_BASE_LORDOFSKULLS_2_MD5='a5cad7f6b77e112e10172709f531bb76'
ARCHIVE_BASE_LORDOFSKULLS_2_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_2_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_LORDOFSKULLS_1_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_08_04_49482.sh'
ARCHIVE_BASE_LORDOFSKULLS_1_MD5='ee41700636fe2fc62b03394b03dc815a'
ARCHIVE_BASE_LORDOFSKULLS_1_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_1_VERSION='1.8.4-gog49482'

ARCHIVE_BASE_LORDOFSKULLS_0_NAME='warhammer_40_000_gladius_relics_of_war_lord_of_skulls_1_08_03_00_48497.sh'
ARCHIVE_BASE_LORDOFSKULLS_0_MD5='c82d9fcec65bda458a5c13478a79d5d5'
ARCHIVE_BASE_LORDOFSKULLS_0_SIZE='1400'
ARCHIVE_BASE_LORDOFSKULLS_0_VERSION='1.8.3-gog48497'

## Reinforcement Pack

ARCHIVE_BASE_REINFORCEMENTPACK_15_NAME='warhammer_40_000_gladius_reinforcement_pack_1_12_03_67548.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_15_MD5='290f8f6e2a054d2fcc543318b3636063'
ARCHIVE_BASE_REINFORCEMENTPACK_15_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_15_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_REINFORCEMENTPACK_15_URL='https://www.gog.com/game/warhammer_40000_gladius_reinforcement_pack'

ARCHIVE_BASE_REINFORCEMENTPACK_14_NAME='warhammer_40_000_gladius_reinforcement_pack_1_12_02_66467.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_14_MD5='faca8bd157b7aa9b3248be383f31f29e'
ARCHIVE_BASE_REINFORCEMENTPACK_14_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_14_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_REINFORCEMENTPACK_13_NAME='warhammer_40_000_gladius_reinforcement_pack_1_12_01_65129.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_13_MD5='da7c29d25cbc577b267fe4bc17f13bb7'
ARCHIVE_BASE_REINFORCEMENTPACK_13_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_13_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_REINFORCEMENTPACK_12_NAME='warhammer_40_000_gladius_reinforcement_pack_1_11_04_64361.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_12_MD5='145f5a09d46543718f8bcc8b643f6807'
ARCHIVE_BASE_REINFORCEMENTPACK_12_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_12_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_REINFORCEMENTPACK_11_NAME='warhammer_40_000_gladius_reinforcement_pack_1_11_03_63999.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_11_MD5='db21441a889ab2d697fdc70657b25f7b'
ARCHIVE_BASE_REINFORCEMENTPACK_11_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_11_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_REINFORCEMENTPACK_10_NAME='warhammer_40_000_gladius_reinforcement_pack_1_11_02_63492.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_10_MD5='34bf7b77c7a8145dbbde3b6d2f9e9eed'
ARCHIVE_BASE_REINFORCEMENTPACK_10_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_10_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_REINFORCEMENTPACK_9_NAME='warhammer_40_000_gladius_reinforcement_pack_1_11_01_01_61928.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_9_MD5='c091f0a69e1c5ff2c99e21322f9382b2'
ARCHIVE_BASE_REINFORCEMENTPACK_9_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_9_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_REINFORCEMENTPACK_8_NAME='warhammer_40_000_gladius_reinforcement_pack_1_11_00_00a_60903.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_8_MD5='d0a97ebea17db6282ea776d6f781f686'
ARCHIVE_BASE_REINFORCEMENTPACK_8_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_8_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_REINFORCEMENTPACK_7_NAME='warhammer_40_000_gladius_reinforcement_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_7_MD5='59ac7359ac72a1f40f5ba237fcee8698'
ARCHIVE_BASE_REINFORCEMENTPACK_7_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_7_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_REINFORCEMENTPACK_6_NAME='warhammer_40_000_gladius_reinforcement_pack_1_10_00_00_56240.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_6_MD5='ddacdb79bd0b99cc44ad23d5084d4625'
ARCHIVE_BASE_REINFORCEMENTPACK_6_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_6_VERSION='1.10.00-gog56240'

ARCHIVE_BASE_REINFORCEMENTPACK_5_NAME='warhammer_40_000_gladius_reinforcement_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_5_MD5='20cce6c9a3a012a4b2d3fda7101606f4'
ARCHIVE_BASE_REINFORCEMENTPACK_5_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_5_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_REINFORCEMENTPACK_4_NAME='warhammer_40_000_gladius_reinforcement_pack_1_09_00_00_51561.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_4_MD5='7ac7816cb1416dbb6011fddf882ddef6'
ARCHIVE_BASE_REINFORCEMENTPACK_4_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_4_VERSION='1.9.0.0-gog51561'

ARCHIVE_BASE_REINFORCEMENTPACK_3_NAME='warhammer_40_000_gladius_reinforcement_pack_1_08_04_01_49548.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_3_MD5='72e9d71403328df72d4505096c98c423'
ARCHIVE_BASE_REINFORCEMENTPACK_3_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_3_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_REINFORCEMENTPACK_2_NAME='warhammer_40_000_gladius_reinforcement_pack_1_08_04_49482.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_2_MD5='41fa1efb966efa00384f95550ca64292'
ARCHIVE_BASE_REINFORCEMENTPACK_2_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_2_VERSION='1.8.4-gog49482'

ARCHIVE_BASE_REINFORCEMENTPACK_1_NAME='warhammer_40_000_gladius_reinforcement_pack_1_08_03_00_48497.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_1_MD5='df71e99b1c6aabfce4af48ab25896fef'
ARCHIVE_BASE_REINFORCEMENTPACK_1_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_1_VERSION='1.8.3-gog48497'

ARCHIVE_BASE_REINFORCEMENTPACK_0_NAME='warhammer_40_000_gladius_reinforcement_pack_1_07_04_44200.sh'
ARCHIVE_BASE_REINFORCEMENTPACK_0_MD5='013e6db4458c5fe0c39b3a33bdda68e5'
ARCHIVE_BASE_REINFORCEMENTPACK_0_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENTPACK_0_VERSION='1.7.4-gog44200'

## Tyranids

ARCHIVE_BASE_TYRANIDS_15_NAME='warhammer_40_000_gladius_tyranids_1_12_03_67548.sh'
ARCHIVE_BASE_TYRANIDS_15_MD5='6fd672b4230bceebc496e7ce7aa455b4'
ARCHIVE_BASE_TYRANIDS_15_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_15_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_TYRANIDS_15_URL='https://www.gog.com/game/warhammer_40000_gladius_tyranids'

ARCHIVE_BASE_TYRANIDS_14_NAME='warhammer_40_000_gladius_tyranids_1_12_02_66467.sh'
ARCHIVE_BASE_TYRANIDS_14_MD5='af2e485b04a2bc70f785bfb4c478b814'
ARCHIVE_BASE_TYRANIDS_14_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_14_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_TYRANIDS_13_NAME='warhammer_40_000_gladius_tyranids_1_12_01_65129.sh'
ARCHIVE_BASE_TYRANIDS_13_MD5='abe90ceb23dfa0a9b1c7ab2fee37960b'
ARCHIVE_BASE_TYRANIDS_13_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_13_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_TYRANIDS_12_NAME='warhammer_40_000_gladius_tyranids_1_11_04_64361.sh'
ARCHIVE_BASE_TYRANIDS_12_MD5='53da0257c7ae0ca6c4b2712a70f8b666'
ARCHIVE_BASE_TYRANIDS_12_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_12_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_TYRANIDS_11_NAME='warhammer_40_000_gladius_tyranids_1_11_03_63999.sh'
ARCHIVE_BASE_TYRANIDS_11_MD5='7728a3532c0d460ec0f39387561b9452'
ARCHIVE_BASE_TYRANIDS_11_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_11_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_TYRANIDS_10_NAME='warhammer_40_000_gladius_tyranids_1_11_02_63492.sh'
ARCHIVE_BASE_TYRANIDS_10_MD5='fd870b487ddcc8d516d8c37452a1ee9e'
ARCHIVE_BASE_TYRANIDS_10_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_10_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_TYRANIDS_9_NAME='warhammer_40_000_gladius_tyranids_1_11_01_01_61928.sh'
ARCHIVE_BASE_TYRANIDS_9_MD5='2f98accc0d615e19b71322a7e336e2fc'
ARCHIVE_BASE_TYRANIDS_9_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_9_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_TYRANIDS_8_NAME='warhammer_40_000_gladius_tyranids_1_11_00_00a_60903.sh'
ARCHIVE_BASE_TYRANIDS_8_MD5='cfc139f01e93116ed1723e00fd7f69cd'
ARCHIVE_BASE_TYRANIDS_8_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_8_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_TYRANIDS_7_NAME='warhammer_40_000_gladius_tyranids_1_10_01_00_57375.sh'
ARCHIVE_BASE_TYRANIDS_7_MD5='30934475a2b0c8f794234d5e38f504cc'
ARCHIVE_BASE_TYRANIDS_7_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_7_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_TYRANIDS_6_NAME='warhammer_40_000_gladius_tyranids_1_10_00_00_56240.sh'
ARCHIVE_BASE_TYRANIDS_6_MD5='4f0cd73e5ae1a583b387c44e6120d058'
ARCHIVE_BASE_TYRANIDS_6_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_6_VERSION='1.10.00-gog56240'

ARCHIVE_BASE_TYRANIDS_5_NAME='warhammer_40_000_gladius_tyranids_v1_09_03_00_54377.sh'
ARCHIVE_BASE_TYRANIDS_5_MD5='ac2e7f57d90a405688304573e6332443'
ARCHIVE_BASE_TYRANIDS_5_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_5_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_TYRANIDS_4_NAME='warhammer_40_000_gladius_tyranids_1_09_00_00_51561.sh'
ARCHIVE_BASE_TYRANIDS_4_MD5='ad76fba163b7a1a5ee6d85b9ddae3d4e'
ARCHIVE_BASE_TYRANIDS_4_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_4_VERSION='1.9.0.0-gog51561'

ARCHIVE_BASE_TYRANIDS_3_NAME='warhammer_40_000_gladius_tyranids_1_08_04_01_49548.sh'
ARCHIVE_BASE_TYRANIDS_3_MD5='a6e5921db60b6a366619354b1eb47d23'
ARCHIVE_BASE_TYRANIDS_3_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_3_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_TYRANIDS_2_NAME='warhammer_40_000_gladius_tyranids_1_08_04_49482.sh'
ARCHIVE_BASE_TYRANIDS_2_MD5='c1b60aa111982d3ee20b5df4c2e62805'
ARCHIVE_BASE_TYRANIDS_2_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_2_VERSION='1.8.4-gog49482'

ARCHIVE_BASE_TYRANIDS_1_NAME='warhammer_40_000_gladius_tyranids_1_08_03_00_48497.sh'
ARCHIVE_BASE_TYRANIDS_1_MD5='65c73ad8cf9cb7c8c15e2c23d95534f9'
ARCHIVE_BASE_TYRANIDS_1_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_1_VERSION='1.8.3-gog48497'

ARCHIVE_BASE_TYRANIDS_0_NAME='warhammer_40_000_gladius_tyranids_1_07_04_44200.sh'
ARCHIVE_BASE_TYRANIDS_0_MD5='c6c04852f1a3128dbfa267c89f1c9626'
ARCHIVE_BASE_TYRANIDS_0_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_0_VERSION='1.7.4-gog44200'

## Chaos Space Marines

ARCHIVE_BASE_CHAOSSPACEMARINES_14_NAME='warhammer_40_000_gladius_chaos_space_marines_1_12_03_67548.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_14_MD5='5103e5a13f5e04f6a0d4ce2124ae9b8f'
ARCHIVE_BASE_CHAOSSPACEMARINES_14_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_14_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_CHAOSSPACEMARINES_14_URL='https://www.gog.com/game/warhammer_40000_gladius_chaos_space_marines'

ARCHIVE_BASE_CHAOSSPACEMARINES_13_NAME='warhammer_40_000_gladius_chaos_space_marines_1_12_02_66467.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_13_MD5='b1defe799af31d27a34fc89bbb8b152a'
ARCHIVE_BASE_CHAOSSPACEMARINES_13_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_13_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_CHAOSSPACEMARINES_12_NAME='warhammer_40_000_gladius_chaos_space_marines_1_12_01_65129.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_12_MD5='d5bf9f812fd553b6e27d439b26861fe2'
ARCHIVE_BASE_CHAOSSPACEMARINES_12_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_12_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_CHAOSSPACEMARINES_11_NAME='warhammer_40_000_gladius_chaos_space_marines_1_11_04_64361.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_11_MD5='2c613e93f92197efb004a4d590f6412e'
ARCHIVE_BASE_CHAOSSPACEMARINES_11_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_11_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_CHAOSSPACEMARINES_10_NAME='warhammer_40_000_gladius_chaos_space_marines_1_11_03_63999.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_10_MD5='0234e3c9468ebc77a036be0ba7367198'
ARCHIVE_BASE_CHAOSSPACEMARINES_10_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_10_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_CHAOSSPACEMARINES_9_NAME='warhammer_40_000_gladius_chaos_space_marines_1_11_02_63492.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_9_MD5='ae3ddbfcb74e8b48744171cb21c5d4ad'
ARCHIVE_BASE_CHAOSSPACEMARINES_9_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_9_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_CHAOSSPACEMARINES_8_NAME='warhammer_40_000_gladius_chaos_space_marines_1_11_01_01_61928.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_8_MD5='84527e5160e6a51f6e4a753dde384113'
ARCHIVE_BASE_CHAOSSPACEMARINES_8_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_8_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_CHAOSSPACEMARINES_7_NAME='warhammer_40_000_gladius_chaos_space_marines_1_11_00_00a_60903.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_7_MD5='e455e8beb4ff92a9a058dbe6762ef3ae'
ARCHIVE_BASE_CHAOSSPACEMARINES_7_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_7_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_CHAOSSPACEMARINES_6_NAME='warhammer_40_000_gladius_chaos_space_marines_1_10_01_00_57375.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_6_MD5='88542a8341638e1d51e2758c9886e2c6'
ARCHIVE_BASE_CHAOSSPACEMARINES_6_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_6_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_CHAOSSPACEMARINES_5_NAME='warhammer_40_000_gladius_chaos_space_marines_1_10_00_00_56240.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_5_MD5='714486a73be8a881ff361d116c683781'
ARCHIVE_BASE_CHAOSSPACEMARINES_5_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_5_VERSION='1.10.00-gog56240'

ARCHIVE_BASE_CHAOSSPACEMARINES_4_NAME='warhammer_40_000_gladius_chaos_space_marines_v1_09_03_00_54377.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_4_MD5='ed2c64df977669d9413648347c883a35'
ARCHIVE_BASE_CHAOSSPACEMARINES_4_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_4_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_CHAOSSPACEMARINES_3_NAME='warhammer_40_000_gladius_chaos_space_marines_1_09_00_00_51561.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_3_MD5='6149f72401cc58a15d78a0baf918a30e'
ARCHIVE_BASE_CHAOSSPACEMARINES_3_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_3_VERSION='1.9.0.0-gog51561'

ARCHIVE_BASE_CHAOSSPACEMARINES_2_NAME='warhammer_40_000_gladius_chaos_space_marines_1_08_04_01_49548.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_2_MD5='37894d5cd89aaa67dc841d2f5023ebf2'
ARCHIVE_BASE_CHAOSSPACEMARINES_2_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_2_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_CHAOSSPACEMARINES_1_NAME='warhammer_40_000_gladius_chaos_space_marines_1_08_04_49482.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_1_MD5='c950444e3f931cd680cc2ca73472a750'
ARCHIVE_BASE_CHAOSSPACEMARINES_1_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_1_VERSION='1.8.4-gog49482'

ARCHIVE_BASE_CHAOSSPACEMARINES_0_NAME='warhammer_40_000_gladius_chaos_space_marines_1_08_03_00_48497.sh'
ARCHIVE_BASE_CHAOSSPACEMARINES_0_MD5='feb977030b0ded00e343dbc4343ea3a9'
ARCHIVE_BASE_CHAOSSPACEMARINES_0_SIZE='1400'
ARCHIVE_BASE_CHAOSSPACEMARINES_0_VERSION='1.8.3-gog48497'

## Fortification Pack

ARCHIVE_BASE_FORTIFICATIONPACK_14_NAME='warhammer_40_000_gladius_fortification_pack_1_12_03_67548.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_14_MD5='32c26b39aaa8329f20bddccc4059a257'
ARCHIVE_BASE_FORTIFICATIONPACK_14_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_14_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_FORTIFICATIONPACK_14_URL='https://www.gog.com/game/warhammer_40000_gladius_fortification_pack'

ARCHIVE_BASE_FORTIFICATIONPACK_13_NAME='warhammer_40_000_gladius_fortification_pack_1_12_02_66467.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_13_MD5='350fcf7c79abcde18ea3dc8c99d7c187'
ARCHIVE_BASE_FORTIFICATIONPACK_13_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_13_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_FORTIFICATIONPACK_12_NAME='warhammer_40_000_gladius_fortification_pack_1_12_01_65129.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_12_MD5='413662ca6fa9f355fc1c3b91fdd1893a'
ARCHIVE_BASE_FORTIFICATIONPACK_12_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_12_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_FORTIFICATIONPACK_11_NAME='warhammer_40_000_gladius_fortification_pack_1_11_04_64361.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_11_MD5='90d66263e66f30aa7c6df35ec2b0d276'
ARCHIVE_BASE_FORTIFICATIONPACK_11_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_11_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_FORTIFICATIONPACK_10_NAME='warhammer_40_000_gladius_fortification_pack_1_11_03_63999.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_10_MD5='12b072e381eaa4f9c3a6a5f73ec732f7'
ARCHIVE_BASE_FORTIFICATIONPACK_10_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_10_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_FORTIFICATIONPACK_9_NAME='warhammer_40_000_gladius_fortification_pack_1_11_02_63492.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_9_MD5='5ddc8deb3dff7468aafcbcc7d113113e'
ARCHIVE_BASE_FORTIFICATIONPACK_9_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_9_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_FORTIFICATIONPACK_8_NAME='warhammer_40_000_gladius_fortification_pack_1_11_01_01_61928.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_8_MD5='8ba94836c6f3b5a9e57cfd348ec4586c'
ARCHIVE_BASE_FORTIFICATIONPACK_8_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_8_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_FORTIFICATIONPACK_7_NAME='warhammer_40_000_gladius_fortification_pack_1_11_00_00a_60903.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_7_MD5='3391348e814870851358778b9da5628f'
ARCHIVE_BASE_FORTIFICATIONPACK_7_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_7_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_FORTIFICATIONPACK_6_NAME='warhammer_40_000_gladius_fortification_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_6_MD5='859c6d14d76a4b1a43880ea89e01ed27'
ARCHIVE_BASE_FORTIFICATIONPACK_6_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_6_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_FORTIFICATIONPACK_5_NAME='warhammer_40_000_gladius_fortification_pack_1_10_00_00_56240.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_5_MD5='19540010034a2725d2f9c486a9e91236'
ARCHIVE_BASE_FORTIFICATIONPACK_5_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_5_VERSION='1.10.00-gog56240'

ARCHIVE_BASE_FORTIFICATIONPACK_4_NAME='warhammer_40_000_gladius_fortification_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_4_MD5='4221b279557e7af587ec6207f8654071'
ARCHIVE_BASE_FORTIFICATIONPACK_4_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_4_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_FORTIFICATIONPACK_3_NAME='warhammer_40_000_gladius_fortification_pack_1_09_00_00_51561.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_3_MD5='26c7ab91d50520e1c422a0361d07d652'
ARCHIVE_BASE_FORTIFICATIONPACK_3_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_3_VERSION='1.9.0.0-gog51561'

ARCHIVE_BASE_FORTIFICATIONPACK_2_NAME='warhammer_40_000_gladius_fortification_pack_1_08_04_01_49548.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_2_MD5='d485b048b4c1d391c7671ecc4c88e66d'
ARCHIVE_BASE_FORTIFICATIONPACK_2_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_2_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_FORTIFICATIONPACK_1_NAME='warhammer_40_000_gladius_fortification_pack_1_08_04_49482.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_1_MD5='bb18a4f2ad479d062799bc0ce9c6df96'
ARCHIVE_BASE_FORTIFICATIONPACK_1_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_1_VERSION='1.8.4-gog49482'

ARCHIVE_BASE_FORTIFICATIONPACK_0_NAME='warhammer_40_000_gladius_fortification_pack_1_08_03_00_48497.sh'
ARCHIVE_BASE_FORTIFICATIONPACK_0_MD5='d9d80442a8212482e255803ec3dabd2d'
ARCHIVE_BASE_FORTIFICATIONPACK_0_SIZE='1400'
ARCHIVE_BASE_FORTIFICATIONPACK_0_VERSION='1.8.3-gog48497'

## T'au

ARCHIVE_BASE_TAU_11_NAME='warhammer_40_000_gladius_t_au_1_12_03_67548.sh'
ARCHIVE_BASE_TAU_11_MD5='c0dd6e15c253f1b58a0d596fec8d1531'
ARCHIVE_BASE_TAU_11_SIZE='1396'
ARCHIVE_BASE_TAU_11_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_TAU_11_URL='https://www.gog.com/game/warhammer_40000_gladius_tau'

ARCHIVE_BASE_TAU_10_NAME='warhammer_40_000_gladius_t_au_1_12_02_66467.sh'
ARCHIVE_BASE_TAU_10_MD5='dfc4e44bc2416941e58fbc3629c31961'
ARCHIVE_BASE_TAU_10_SIZE='1400'
ARCHIVE_BASE_TAU_10_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_TAU_9_NAME='warhammer_40_000_gladius_t_au_1_12_01_65129.sh'
ARCHIVE_BASE_TAU_9_MD5='623f6f59ba8ba7d8362d9d80a9ada2b5'
ARCHIVE_BASE_TAU_9_SIZE='1400'
ARCHIVE_BASE_TAU_9_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_TAU_8_NAME='warhammer_40_000_gladius_t_au_1_11_04_64361.sh'
ARCHIVE_BASE_TAU_8_MD5='b8d20922d142704e61dbb8dbe83ce2b0'
ARCHIVE_BASE_TAU_8_SIZE='1400'
ARCHIVE_BASE_TAU_8_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_TAU_7_NAME='warhammer_40_000_gladius_t_au_1_11_03_63999.sh'
ARCHIVE_BASE_TAU_7_MD5='6d6f35fce4e502003c0706d65e4fb141'
ARCHIVE_BASE_TAU_7_SIZE='1400'
ARCHIVE_BASE_TAU_7_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_TAU_6_NAME='warhammer_40_000_gladius_t_au_1_11_02_63492.sh'
ARCHIVE_BASE_TAU_6_MD5='540179d5d5cb922117dbc58b5aefd8b1'
ARCHIVE_BASE_TAU_6_SIZE='1400'
ARCHIVE_BASE_TAU_6_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_TAU_5_NAME='warhammer_40_000_gladius_t_au_1_11_01_01_61928.sh'
ARCHIVE_BASE_TAU_5_MD5='b11c5b238351b794657640c2015d08c1'
ARCHIVE_BASE_TAU_5_SIZE='1400'
ARCHIVE_BASE_TAU_5_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_TAU_4_NAME='warhammer_40_000_gladius_t_au_1_11_00_00a_60903.sh'
ARCHIVE_BASE_TAU_4_MD5='e4c09c3cd5dabd4ac59c17d59390b6bb'
ARCHIVE_BASE_TAU_4_SIZE='1400'
ARCHIVE_BASE_TAU_4_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_TAU_3_NAME='warhammer_40_000_gladius_t_au_1_10_01_00_57375.sh'
ARCHIVE_BASE_TAU_3_MD5='1f7770a75d1c846aca32f905cd4ce51f'
ARCHIVE_BASE_TAU_3_SIZE='1400'
ARCHIVE_BASE_TAU_3_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_TAU_2_NAME='warhammer_40_000_gladius_t_au_1_10_00_00_56240.sh'
ARCHIVE_BASE_TAU_2_MD5='f4c6193877f33d9092a783ce6fc8f216'
ARCHIVE_BASE_TAU_2_SIZE='1400'
ARCHIVE_BASE_TAU_2_VERSION='1.10.00-gog56240'
ARCHIVE_BASE_TAU_2_URL='https://www.gog.com/game/warhammer_40000_gladius_tau'

ARCHIVE_BASE_TAU_1_NAME='warhammer_40_000_gladius_t_au_v1_09_03_00_54377.sh'
ARCHIVE_BASE_TAU_1_MD5='22b575c6ce8da35f7d57335662de4747'
ARCHIVE_BASE_TAU_1_SIZE='1400'
ARCHIVE_BASE_TAU_1_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_TAU_0_NAME='warhammer_40_000_gladius_t_au_1_09_02_00_51924.sh'
ARCHIVE_BASE_TAU_0_MD5='6577b1fa7b9c0869a89bcca4688afdf0'
ARCHIVE_BASE_TAU_0_SIZE='1400'
ARCHIVE_BASE_TAU_0_VERSION='1.9.2.0-gog51924'

## Assault Pack

ARCHIVE_BASE_ASSAULTPACK_11_NAME='warhammer_40_000_gladius_assault_pack_1_12_03_67548.sh'
ARCHIVE_BASE_ASSAULTPACK_11_MD5='9e56693f4d1623a9c7dcc9c2cf63a59a'
ARCHIVE_BASE_ASSAULTPACK_11_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_11_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_ASSAULTPACK_11_URL='https://www.gog.com/game/warhammer_40000_gladius_assault_pack'

ARCHIVE_BASE_ASSAULTPACK_10_NAME='warhammer_40_000_gladius_assault_pack_1_12_02_66467.sh'
ARCHIVE_BASE_ASSAULTPACK_10_MD5='216b4fe704bb1ca204c96fa41c38ce3d'
ARCHIVE_BASE_ASSAULTPACK_10_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_10_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_ASSAULTPACK_9_NAME='warhammer_40_000_gladius_assault_pack_1_12_01_65129.sh'
ARCHIVE_BASE_ASSAULTPACK_9_MD5='61bdea025f49cf76f3ec81030833e319'
ARCHIVE_BASE_ASSAULTPACK_9_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_9_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_ASSAULTPACK_8_NAME='warhammer_40_000_gladius_assault_pack_1_11_04_64361.sh'
ARCHIVE_BASE_ASSAULTPACK_8_MD5='aae3f873d640d36f3821921efb7525c2'
ARCHIVE_BASE_ASSAULTPACK_8_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_8_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_ASSAULTPACK_7_NAME='warhammer_40_000_gladius_assault_pack_1_11_03_63999.sh'
ARCHIVE_BASE_ASSAULTPACK_7_MD5='6303b55a3fd73b2da4b142cbcb9e7538'
ARCHIVE_BASE_ASSAULTPACK_7_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_7_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_ASSAULTPACK_6_NAME='warhammer_40_000_gladius_assault_pack_1_11_02_63492.sh'
ARCHIVE_BASE_ASSAULTPACK_6_MD5='8a66b24528b10e5a6090128781f4844f'
ARCHIVE_BASE_ASSAULTPACK_6_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_6_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_ASSAULTPACK_5_NAME='warhammer_40_000_gladius_assault_pack_1_11_01_01_61928.sh'
ARCHIVE_BASE_ASSAULTPACK_5_MD5='4fb30f28a05ec1d47f27147904e99d9d'
ARCHIVE_BASE_ASSAULTPACK_5_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_5_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_ASSAULTPACK_4_NAME='warhammer_40_000_gladius_assault_pack_1_11_00_00a_60903.sh'
ARCHIVE_BASE_ASSAULTPACK_4_MD5='2a3e05859a742a7b7f78a4c91810b850'
ARCHIVE_BASE_ASSAULTPACK_4_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_4_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_ASSAULTPACK_3_NAME='warhammer_40_000_gladius_assault_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_ASSAULTPACK_3_MD5='69d3d257e8caa70c7af8bd50b6963e0a'
ARCHIVE_BASE_ASSAULTPACK_3_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_3_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_ASSAULTPACK_2_NAME='warhammer_40_000_gladius_assault_pack_1_10_00_00_56240.sh'
ARCHIVE_BASE_ASSAULTPACK_2_MD5='b2731b3c867c3bdc7b8057674e58b9c9'
ARCHIVE_BASE_ASSAULTPACK_2_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_2_VERSION='1.10.00-gog56240'

ARCHIVE_BASE_ASSAULTPACK_1_NAME='warhammer_40_000_gladius_assault_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_ASSAULTPACK_1_MD5='8812a45df8fa62523f655ecc2a1dbd46'
ARCHIVE_BASE_ASSAULTPACK_1_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_1_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_ASSAULTPACK_0_NAME='warhammer_40_000_gladius_assault_pack_1_09_02_00_51924.sh'
ARCHIVE_BASE_ASSAULTPACK_0_MD5='dfb2965d3461665f218d21f492fa55db'
ARCHIVE_BASE_ASSAULTPACK_0_SIZE='1400'
ARCHIVE_BASE_ASSAULTPACK_0_VERSION='1.9.2.0-gog51924'

## Craftworld Aeldari

ARCHIVE_BASE_AELDARI_9_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_12_03_67548.sh'
ARCHIVE_BASE_AELDARI_9_MD5='a9ed6a70658299ab82d2934f7b572151'
ARCHIVE_BASE_AELDARI_9_SIZE='1400'
ARCHIVE_BASE_AELDARI_9_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_AELDARI_9_URL='https://www.gog.com/game/warhammer_40000_gladius_craftworld_aeldari'

ARCHIVE_BASE_AELDARI_8_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_12_02_66467.sh'
ARCHIVE_BASE_AELDARI_8_MD5='c53d51c70b7cce9423d72451b0f6d4b9'
ARCHIVE_BASE_AELDARI_8_SIZE='1400'
ARCHIVE_BASE_AELDARI_8_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_AELDARI_7_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_12_01_65129.sh'
ARCHIVE_BASE_AELDARI_7_MD5='a9286a0a182903f864525d6d65c085d7'
ARCHIVE_BASE_AELDARI_7_SIZE='1400'
ARCHIVE_BASE_AELDARI_7_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_AELDARI_6_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_11_04_64361.sh'
ARCHIVE_BASE_AELDARI_6_MD5='2c2b76c50ee3d7c29fd24c8aea0fe6e0'
ARCHIVE_BASE_AELDARI_6_SIZE='1400'
ARCHIVE_BASE_AELDARI_6_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_AELDARI_5_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_11_03_63999.sh'
ARCHIVE_BASE_AELDARI_5_MD5='5ba5d85909185df3eece60d8ff3cab50'
ARCHIVE_BASE_AELDARI_5_SIZE='1400'
ARCHIVE_BASE_AELDARI_5_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_AELDARI_4_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_11_02_63492.sh'
ARCHIVE_BASE_AELDARI_4_MD5='584210653a8107fb0c72e65e3630d0a3'
ARCHIVE_BASE_AELDARI_4_SIZE='1400'
ARCHIVE_BASE_AELDARI_4_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_AELDARI_3_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_11_01_01_61928.sh'
ARCHIVE_BASE_AELDARI_3_MD5='def52a830d9a4e8f2983d7955cb029b4'
ARCHIVE_BASE_AELDARI_3_SIZE='1400'
ARCHIVE_BASE_AELDARI_3_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_AELDARI_2_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_11_00_00a_60903.sh'
ARCHIVE_BASE_AELDARI_2_MD5='27b367823225debbe9bd51fad1f140c3'
ARCHIVE_BASE_AELDARI_2_SIZE='1400'
ARCHIVE_BASE_AELDARI_2_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_AELDARI_1_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_10_01_00_57375.sh'
ARCHIVE_BASE_AELDARI_1_MD5='b3698a59f99611fb8431a76ea50ef35d'
ARCHIVE_BASE_AELDARI_1_SIZE='1400'
ARCHIVE_BASE_AELDARI_1_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_AELDARI_0_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_10_00_00_56240.sh'
ARCHIVE_BASE_AELDARI_0_MD5='cf102626dce941c695edf39b4c951eac'
ARCHIVE_BASE_AELDARI_0_SIZE='1400'
ARCHIVE_BASE_AELDARI_0_VERSION='1.10.00-gog56240'

## Specialist Pack

ARCHIVE_BASE_SPECIALIST_9_NAME='warhammer_40_000_gladius_specialist_pack_1_12_03_67548.sh'
ARCHIVE_BASE_SPECIALIST_9_MD5='f8e1aaacc5a30496abae99c8a6965799'
ARCHIVE_BASE_SPECIALIST_9_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_9_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_SPECIALIST_9_URL='https://www.gog.com/game/warhammer_40000_gladius_specialist_pack'

ARCHIVE_BASE_SPECIALIST_8_NAME='warhammer_40_000_gladius_specialist_pack_1_12_02_66467.sh'
ARCHIVE_BASE_SPECIALIST_8_MD5='c4bbace2fdfb190808836651085613ba'
ARCHIVE_BASE_SPECIALIST_8_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_8_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_SPECIALIST_7_NAME='warhammer_40_000_gladius_specialist_pack_1_12_01_65129.sh'
ARCHIVE_BASE_SPECIALIST_7_MD5='248fe5a0cdef854365199921e3087450'
ARCHIVE_BASE_SPECIALIST_7_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_7_VERSION='1.12.1-gog65129'

ARCHIVE_BASE_SPECIALIST_6_NAME='warhammer_40_000_gladius_specialist_pack_1_11_04_64361.sh'
ARCHIVE_BASE_SPECIALIST_6_MD5='5f44ab4c03bf70047e6716000a29f910'
ARCHIVE_BASE_SPECIALIST_6_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_6_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_SPECIALIST_5_NAME='warhammer_40_000_gladius_specialist_pack_1_11_03_63999.sh'
ARCHIVE_BASE_SPECIALIST_5_MD5='fb6382c4ff29f91e07721bc5227d6d0b'
ARCHIVE_BASE_SPECIALIST_5_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_5_VERSION='1.11.3-gog63999'

ARCHIVE_BASE_SPECIALIST_4_NAME='warhammer_40_000_gladius_specialist_pack_1_11_02_63492.sh'
ARCHIVE_BASE_SPECIALIST_4_MD5='d9eb0e07259a86f44883147535f53612'
ARCHIVE_BASE_SPECIALIST_4_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_4_VERSION='1.11.2-gog63492'

ARCHIVE_BASE_SPECIALIST_3_NAME='warhammer_40_000_gladius_specialist_pack_1_11_01_01_61928.sh'
ARCHIVE_BASE_SPECIALIST_3_MD5='538f9295de797e59857894d75d18d628'
ARCHIVE_BASE_SPECIALIST_3_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_3_VERSION='1.11.1.1-gog61928'

ARCHIVE_BASE_SPECIALIST_2_NAME='warhammer_40_000_gladius_specialist_pack_1_11_00_00a_60903.sh'
ARCHIVE_BASE_SPECIALIST_2_MD5='a2ebc5f5dfca5bb324508e3c97b08a28'
ARCHIVE_BASE_SPECIALIST_2_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_2_VERSION='1.11.0-gog60903'

ARCHIVE_BASE_SPECIALIST_1_NAME='warhammer_40_000_gladius_specialist_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_SPECIALIST_1_MD5='b0b788d180a82919048621796f68fb1e'
ARCHIVE_BASE_SPECIALIST_1_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_1_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_SPECIALIST_0_NAME='warhammer_40_000_gladius_specialist_pack_1_10_00_00_56240.sh'
ARCHIVE_BASE_SPECIALIST_0_MD5='50a51ae3072b4055ed94d9669837a0b5'
ARCHIVE_BASE_SPECIALIST_0_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_0_VERSION='1.10.00-gog56240'

## Adeptus Mechanicus

ARCHIVE_BASE_MECHANICUS_2_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_12_03_67548.sh'
ARCHIVE_BASE_MECHANICUS_2_MD5='0be493045812d7ee50c5c7846b60151e'
ARCHIVE_BASE_MECHANICUS_2_SIZE='1400'
ARCHIVE_BASE_MECHANICUS_2_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_MECHANICUS_2_URL='https://www.gog.com/game/warhammer_40000_gladius_adeptus_mechanicus'

ARCHIVE_BASE_MECHANICUS_1_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_12_02_66467.sh'
ARCHIVE_BASE_MECHANICUS_1_MD5='3fc2e9aa4b61f72e77efca96259d8d81'
ARCHIVE_BASE_MECHANICUS_1_SIZE='1400'
ARCHIVE_BASE_MECHANICUS_1_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_MECHANICUS_0_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_12_01_65129.sh'
ARCHIVE_BASE_MECHANICUS_0_MD5='92d3b04f8dc3e20160d9a7af78d825fe'
ARCHIVE_BASE_MECHANICUS_0_SIZE='1400'
ARCHIVE_BASE_MECHANICUS_0_VERSION='1.12.1-gog65129'

## Escalation Pack

ARCHIVE_BASE_ESCALATION_2_NAME='warhammer_40_000_gladius_escalation_pack_1_12_03_67548.sh'
ARCHIVE_BASE_ESCALATION_2_MD5='ce318c4cc0ee526f1abcd18ddbd4937c'
ARCHIVE_BASE_ESCALATION_2_SIZE='1400'
ARCHIVE_BASE_ESCALATION_2_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_ESCALATION_2_URL='https://www.gog.com/game/warhammer_40000_gladius_adeptus_mechanicus'

ARCHIVE_BASE_ESCALATION_1_NAME='warhammer_40_000_gladius_escalation_pack_1_12_02_66467.sh'
ARCHIVE_BASE_ESCALATION_1_MD5='5d5d688ac18a2be168fa4c83ea8335bf'
ARCHIVE_BASE_ESCALATION_1_SIZE='1400'
ARCHIVE_BASE_ESCALATION_1_VERSION='1.12.2-gog66467'

ARCHIVE_BASE_ESCALATION_0_NAME='warhammer_40_000_gladius_escalation_pack_1_12_01_65129.sh'
ARCHIVE_BASE_ESCALATION_0_MD5='2ad678ed86d572559a6dfd8c2a5cd164'
ARCHIVE_BASE_ESCALATION_0_SIZE='1400'
ARCHIVE_BASE_ESCALATION_0_VERSION='1.12.1-gog65129'

## Adepta Sororitas

ARCHIVE_BASE_SORORITAS_1_NAME='warhammer_40_000_gladius_adepta_sororitas_1_12_03_67548.sh'
ARCHIVE_BASE_SORORITAS_1_MD5='1c69d1ce8301b0fb42f10718a4271761'
ARCHIVE_BASE_SORORITAS_1_SIZE='1400'
ARCHIVE_BASE_SORORITAS_1_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_SORORITAS_1_URL='https://www.gog.com/game/warhammer_40000_gladius_adepta_sororitas'

ARCHIVE_BASE_SORORITAS_0_NAME='warhammer_40_000_gladius_adepta_sororitas_1_12_02_66467.sh'
ARCHIVE_BASE_SORORITAS_0_MD5='e9f9ff4344c78055702e889d540e4fd3'
ARCHIVE_BASE_SORORITAS_0_SIZE='1400'
ARCHIVE_BASE_SORORITAS_0_VERSION='1.12.2-gog66467'

## Firepower Pack

ARCHIVE_BASE_FIREPOWER_1_NAME='warhammer_40_000_gladius_firepower_pack_1_12_03_67548.sh'
ARCHIVE_BASE_FIREPOWER_1_MD5='4f5adaaf42d40278df28bae531313c1d'
ARCHIVE_BASE_FIREPOWER_1_SIZE='1400'
ARCHIVE_BASE_FIREPOWER_1_VERSION='1.12.3-gog67548'
ARCHIVE_BASE_FIREPOWER_1_URL='https://www.gog.com/game/warhammer_40000_gladius_firepower_pack'

ARCHIVE_BASE_FIREPOWER_0_NAME='warhammer_40_000_gladius_firepower_pack_1_12_02_66467.sh'
ARCHIVE_BASE_FIREPOWER_0_MD5='1a415d3091dd76e2d3162ba67c43c22a'
ARCHIVE_BASE_FIREPOWER_0_SIZE='1400'
ARCHIVE_BASE_FIREPOWER_0_VERSION='1.12.2-gog66467'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Data/*.dlc'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
