#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2018 Jacek Szafarkiewicz
# SPDX-FileCopyrightText: © 2018 Phil Morrell
set -o errexit

###
# Unreal Tournament
###

script_version=20231017.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='unreal-tournament'
GAME_NAME='Unreal Tournament'

# Archives

## Unreal Tournament (game installer)
## This game is no longer available for sale from gog.com since 2022-12-23.

ARCHIVE_BASE_0_NAME='setup_ut_goty_2.0.0.5.exe'
ARCHIVE_BASE_0_MD5='0d25ec835648710a098aff7106187f38'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
## Do not convert file paths to lowercase.
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--progress=1 --silent'
ARCHIVE_BASE_0_SIZE='640000'
ARCHIVE_BASE_0_VERSION='469c-gog2.0.0.5'

## Native Linux engine

ARCHIVE_REQUIRED_ENGINE_0_NAME='OldUnreal-UTPatch469c-Linux-amd64.tar.bz2'
ARCHIVE_REQUIRED_ENGINE_0_MD5='6cd032e70460b1393d9514ffe81dcb1a'
ARCHIVE_REQUIRED_ENGINE_0_URL='https://github.com/OldUnreal/UnrealTournamentPatches/releases/tag/v469c'

# Archives content

## Unreal Tournament (game installer)

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_DATA_FILES='
Maps
Music
Sounds
Textures'
CONTENT_DOC_DATA_FILES='
Help
Manual'

## Native Linux engine

CONTENT_PATH_DEFAULT_ENGINE='.'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT_ENGINE}/System64"
CONTENT_LIBS_BIN_FILES='
ALAudio.so
Cluster.so
Core.so
Editor.so
Engine.so
Fire.so
IpDrv.so
libfmod.so.13
OpenGLDrv.so
Render.so
SDLDrv.so
udemo.so
UWeb.so
XOpenGLDrv.so'
CONTENT_GAME_BIN_PATH="$CONTENT_PATH_DEFAULT_ENGINE"
CONTENT_GAME_BIN_FILES='
System
System64'
CONTENT_GAME0_DATA_PATH="$CONTENT_PATH_DEFAULT_ENGINE"
CONTENT_GAME0_DATA_FILES='
SystemLocalized
Textures
Web'
CONTENT_DOC0_DATA_PATH="$CONTENT_PATH_DEFAULT_ENGINE"
CONTENT_DOC0_DATA_FILES='
Help
LICENSE.md'


APP_MAIN_EXE='System64/ut-bin-amd64'
APP_MAIN_ICON='System/Unreal.ico'
## Run the game binary from its parent directory
APP_MAIN_PRERUN='# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")
'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libmpg123.so.0
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libxmp.so.4'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Chek for the presence of required extra archives

archive_initialize_required \
	'ARCHIVE_ENGINE' \
	'ARCHIVE_REQUIRED_ENGINE_0'

# The game engine looks for libmpg123.so instead of libmpg123.so.0

case "$(option_value 'package')" in
	('arch')
		# Arch Linux already provides the unversioned .so
	;;
	('gentoo'|'egentoo')
		# Gentoo already provides the unversioned .so
	;;
	('deb')
		library_source="$(path_libraries_system)/libmpg123.so.0"
		library_destination="$(package_path 'PKG_BIN')$(path_libraries)/libmpg123.so"
		mkdir --parents "$(dirname "$library_destination")"
		ln --symbolic "$library_source" "$library_destination"
	;;
esac

# Extract game data

archive_extraction_default
archive_extraction 'ARCHIVE_ENGINE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path 'GAME_BIN')"

	# Drop some shipped libraries
	rm \
		'System64/libmpg123.so' \
		'System64/libopenal.so.1' \
		'System64/libSDL2-2.0.so.0' \
		'System64/libxmp.so.4'
)

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
