#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions:
# - Arachnoid Portrait Pack
# - Plantoids Species Pack
# - Leviathans Story Pack
# - Horizon Signal
# - Utopia
# - Anniversary Portraits
# - Synthetic Dawn Story Pack
# - Apocalypse
# - Humanoids Species Pack
# - Distant Stars Story Pack
# - MegaCorp
# - Ancient Relics Story Pack
# - Lithoids Species Pack
# - Federations
# - Necroids Species Pack
# - Nemesis
# - Aquatics Species Pack
# - Overlord
# - Toxoids Species Pack
# - First Contact Story Pack
# - Galactic Paragons
# - Astral Planes
###

script_version=20231125.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_ARACHNOID='arachnoid'
EXPANSION_NAME_ARACHNOID='Arachnoid Portrait Pack'

EXPANSION_ID_PLANTOID='plantoid'
EXPANSION_NAME_PLANTOID='Plantoids Species Pack'

EXPANSION_ID_LEVIATHANS='leviathans'
EXPANSION_NAME_LEVIATHANS='Leviathans Story Pack'

EXPANSION_ID_HORIZONSIGNAL='horizon-signal'
EXPANSION_NAME_HORIZONSIGNAL='Horizon Signal'

EXPANSION_ID_UTOPIA='utopia'
EXPANSION_NAME_UTOPIA='Utopia'

EXPANSION_ID_ANNIVERSARY='anniversary'
EXPANSION_NAME_ANNIVERSARY='Anniversary Portraits'

EXPANSION_ID_SYNTHETICDAWN='synthetic-dawn'
EXPANSION_NAME_SYNTHETICDAWN='Synthetic Dawn Story Pack'

EXPANSION_ID_APOCALYPSE='apocalypse'
EXPANSION_NAME_APOCALYPSE='Apocalypse'

EXPANSION_ID_HUMANOIDS='humanoids'
EXPANSION_NAME_HUMANOIDS='Humanoids Species Pack'

EXPANSION_ID_DISTANTSTARS='distant-stars'
EXPANSION_NAME_DISTANTSTARS='Distant Stars Story Pack'

EXPANSION_ID_MEGACORP='megacorp'
EXPANSION_NAME_MEGACORP='MegaCorp'

EXPANSION_ID_ANCIENTRELICS='ancient-relics'
EXPANSION_NAME_ANCIENTRELICS='Ancient Relics Story Pack'

EXPANSION_ID_LITHOIDS='lithoids'
EXPANSION_NAME_LITHOIDS='Lithoids Species Pack'

EXPANSION_ID_FEDERATIONS='federations'
EXPANSION_NAME_FEDERATIONS='Federations'

EXPANSION_ID_NECROIDS='necroids'
EXPANSION_NAME_NECROIDS='Necroids Species Pack'

EXPANSION_ID_NEMESIS='nemesis'
EXPANSION_NAME_NEMESIS='Nemesis'

EXPANSION_ID_AQUATICS='aquatics'
EXPANSION_NAME_AQUATICS='Aquatics Species Pack'

EXPANSION_ID_OVERLORD='overlord'
EXPANSION_NAME_OVERLORD='Overlord'

EXPANSION_ID_TOXOIDS='toxoids'
EXPANSION_NAME_TOXOIDS='Toxoids Species Pack'

EXPANSION_ID_FIRSTCONTACT='first-contact'
EXPANSION_NAME_FIRSTCONTACT='First Contact Story Pack'

EXPANSION_ID_PARAGONS='galactic-paragons'
EXPANSION_NAME_PARAGONS='Galactic Paragons'

EXPANSION_ID_PLANES='astral-planes'
EXPANSION_NAME_PLANES='Astral Planes'

# Archives

## Arachnoid Portrait Pack

ARCHIVE_BASE_ARACHNOID_48_NAME='stellaris_arachnoid_portrait_pack_3_10_1_69202.sh'
ARCHIVE_BASE_ARACHNOID_48_MD5='931f682a272e92444530a2fa1b1d7d11'
ARCHIVE_BASE_ARACHNOID_48_SIZE='1136'
ARCHIVE_BASE_ARACHNOID_48_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_ARACHNOID_48_URL='https://www.gog.com/game/stellaris_galaxy_edition_upgrade_pack'

ARCHIVE_BASE_ARACHNOID_47_NAME='stellaris_arachnoid_portrait_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_ARACHNOID_47_MD5='b5759e9e28af9b420d35d627296e9cea'
ARCHIVE_BASE_ARACHNOID_47_SIZE='1136'
ARCHIVE_BASE_ARACHNOID_47_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_ARACHNOID_46_NAME='stellaris_arachnoid_portrait_pack_3_9_3_68314.sh'
ARCHIVE_BASE_ARACHNOID_46_MD5='7e9c3036c905d049728186576f8a56eb'
ARCHIVE_BASE_ARACHNOID_46_SIZE='1136'
ARCHIVE_BASE_ARACHNOID_46_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_ARACHNOID_43_NAME='stellaris_arachnoid_portrait_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_ARACHNOID_43_MD5='3c4a57c69955b4b7fc63e46ea06684a5'
ARCHIVE_BASE_ARACHNOID_43_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_43_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_ARACHNOID_39_NAME='stellaris_arachnoid_portrait_pack_3_7_4_63489.sh'
ARCHIVE_BASE_ARACHNOID_39_MD5='e4d76799d90bf18a2666460bae14db93'
ARCHIVE_BASE_ARACHNOID_39_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_39_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_ARACHNOID_36_NAME='stellaris_arachnoid_portrait_pack_3_6_1_60754.sh'
ARCHIVE_BASE_ARACHNOID_36_MD5='41240ed75d7100557b57914ee66c1f49'
ARCHIVE_BASE_ARACHNOID_36_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_36_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_ARACHNOID_34_NAME='stellaris_arachnoid_portrait_pack_3_5_3_59410.sh'
ARCHIVE_BASE_ARACHNOID_34_MD5='6aff6463161944a265b502f434577fc9'
ARCHIVE_BASE_ARACHNOID_34_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_34_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_ARACHNOID_32_NAME='stellaris_arachnoid_portrait_pack_3_4_5_56913.sh'
ARCHIVE_BASE_ARACHNOID_32_MD5='ace768013cc7aaa46182586349432ddf'
ARCHIVE_BASE_ARACHNOID_32_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_32_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_ARACHNOID_28_NAME='stellaris_arachnoid_portrait_pack_3_3_4_54421.sh'
ARCHIVE_BASE_ARACHNOID_28_MD5='2d7bd0d2246fcec48ca8bbf8cdb456e8'
ARCHIVE_BASE_ARACHNOID_28_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_28_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_ARACHNOID_24_NAME='stellaris_arachnoid_portrait_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_ARACHNOID_24_MD5='fab840f6c4a70dcb7c19c913d711af20'
ARCHIVE_BASE_ARACHNOID_24_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_24_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_ARACHNOID_23_NAME='stellaris_arachnoid_portrait_pack_3_1_1_50008.sh'
ARCHIVE_BASE_ARACHNOID_23_MD5='0ccdf6386dc2b9c062e9d272550392a1'
ARCHIVE_BASE_ARACHNOID_23_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_23_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_ARACHNOID_22_NAME='stellaris_arachnoid_portrait_pack_3_0_3_47193.sh'
ARCHIVE_BASE_ARACHNOID_22_MD5='d9619c256ed79a50cce26398b9ac8c11'
ARCHIVE_BASE_ARACHNOID_22_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_22_VERSION='3.0.3-gog47193'

## Plantoids Species Pack

ARCHIVE_BASE_PLANTOID_45_NAME='stellaris_plantoids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_PLANTOID_45_MD5='f46acc22db074dabbfffdc552fe10ab3'
ARCHIVE_BASE_PLANTOID_45_SIZE='1156'
ARCHIVE_BASE_PLANTOID_45_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_PLANTOID_45_URL='https://www.gog.com/game/stellaris_plantoids_species_pack'

ARCHIVE_BASE_PLANTOID_44_NAME='stellaris_plantoids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_PLANTOID_44_MD5='a6bde010ae32ebc8b7827d54dd873f29'
ARCHIVE_BASE_PLANTOID_44_SIZE='1156'
ARCHIVE_BASE_PLANTOID_44_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_PLANTOID_43_NAME='stellaris_plantoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_PLANTOID_43_MD5='f38e8c826f876f52cea68b69f85ca079'
ARCHIVE_BASE_PLANTOID_43_SIZE='1156'
ARCHIVE_BASE_PLANTOID_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_PLANTOID_40_NAME='stellaris_plantoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_PLANTOID_40_MD5='c64fed3a260b17bdb07e439dc20304c7'
ARCHIVE_BASE_PLANTOID_40_SIZE='1200'
ARCHIVE_BASE_PLANTOID_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_PLANTOID_39_NAME='stellaris_plantoids_species_pack_3_8_3_1_64953.sh'
ARCHIVE_BASE_PLANTOID_39_MD5='7b0cec949d962b027bc7bd108d79eeaf'
ARCHIVE_BASE_PLANTOID_39_SIZE='1200'
ARCHIVE_BASE_PLANTOID_39_VERSION='3.8.3.1-gog64953'

ARCHIVE_BASE_PLANTOID_36_NAME='stellaris_plantoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_PLANTOID_36_MD5='5a2a9101e09cddc83e29c802b33639ed'
ARCHIVE_BASE_PLANTOID_36_SIZE='1200'
ARCHIVE_BASE_PLANTOID_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_PLANTOID_33_NAME='stellaris_plantoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_PLANTOID_33_MD5='298bdd7c0f717f90c2045d0c9a68c1c9'
ARCHIVE_BASE_PLANTOID_33_SIZE='1200'
ARCHIVE_BASE_PLANTOID_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_PLANTOID_31_NAME='stellaris_plantoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_PLANTOID_31_MD5='fabc6b9d5580dac6a456da962a765709'
ARCHIVE_BASE_PLANTOID_31_SIZE='1200'
ARCHIVE_BASE_PLANTOID_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_PLANTOID_29_NAME='stellaris_plantoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_PLANTOID_29_MD5='b2b5023834509b4a5c2a12bb345380a1'
ARCHIVE_BASE_PLANTOID_29_SIZE='1200'
ARCHIVE_BASE_PLANTOID_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_PLANTOID_25_NAME='stellaris_plantoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_PLANTOID_25_MD5='b8ea82b781639c7031ea53d4e155c5d1'
ARCHIVE_BASE_PLANTOID_25_SIZE='1200'
ARCHIVE_BASE_PLANTOID_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_PLANTOID_21_NAME='stellaris_plantoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_PLANTOID_21_MD5='260d8bc704b93f307d31807efbb5568f'
ARCHIVE_BASE_PLANTOID_21_SIZE='1200'
ARCHIVE_BASE_PLANTOID_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_PLANTOID_20_NAME='stellaris_plantoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_PLANTOID_20_MD5='fb947af6a98e45645b482a484bd6d42e'
ARCHIVE_BASE_PLANTOID_20_SIZE='1200'
ARCHIVE_BASE_PLANTOID_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_PLANTOID_19_NAME='stellaris_plantoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_PLANTOID_19_MD5='d1dc616e45d6d035ed3414687228f95a'
ARCHIVE_BASE_PLANTOID_19_SIZE='1200'
ARCHIVE_BASE_PLANTOID_19_VERSION='3.0.3-gog47193'

## Leviathans Story Pack

ARCHIVE_BASE_LEVIATHANS_45_NAME='stellaris_leviathans_story_pack_3_10_1_69202.sh'
ARCHIVE_BASE_LEVIATHANS_45_MD5='f598f3ad41111dd3deb9c3adfd959d1d'
ARCHIVE_BASE_LEVIATHANS_45_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_45_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_LEVIATHANS_45_URL='https://www.gog.com/game/stellaris_leviathans_story_pack'

ARCHIVE_BASE_LEVIATHANS_44_NAME='stellaris_leviathans_story_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_LEVIATHANS_44_MD5='abcf0e606c6a1fe3e02f0c89e886625e'
ARCHIVE_BASE_LEVIATHANS_44_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_44_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_LEVIATHANS_43_NAME='stellaris_leviathans_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_LEVIATHANS_43_MD5='12ed6b4e72c61d7d5a2223acfe3dec45'
ARCHIVE_BASE_LEVIATHANS_43_SIZE='58744'
ARCHIVE_BASE_LEVIATHANS_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_LEVIATHANS_40_NAME='stellaris_leviathans_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_LEVIATHANS_40_MD5='575490fe9da72c0211e65e42e2667544'
ARCHIVE_BASE_LEVIATHANS_40_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_LEVIATHANS_36_NAME='stellaris_leviathans_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_LEVIATHANS_36_MD5='e9bc3c4a49159663d905892a0f7f5a75'
ARCHIVE_BASE_LEVIATHANS_36_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_LEVIATHANS_33_NAME='stellaris_leviathans_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_LEVIATHANS_33_MD5='9ef91ba3bb1633cf4cb907f5de892817'
ARCHIVE_BASE_LEVIATHANS_33_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_LEVIATHANS_31_NAME='stellaris_leviathans_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_LEVIATHANS_31_MD5='46f80e45435155c5c94aa1f3bbabf797'
ARCHIVE_BASE_LEVIATHANS_31_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_LEVIATHANS_29_NAME='stellaris_leviathans_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_LEVIATHANS_29_MD5='514ca47c97e6edf951697ba361df53bd'
ARCHIVE_BASE_LEVIATHANS_29_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_LEVIATHANS_25_NAME='stellaris_leviathans_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_LEVIATHANS_25_MD5='367a1abfe37c32461302cf84c9bdd551'
ARCHIVE_BASE_LEVIATHANS_25_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_LEVIATHANS_21_NAME='stellaris_leviathans_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_LEVIATHANS_21_MD5='33a7db46efae680eb6718ccd6c386e53'
ARCHIVE_BASE_LEVIATHANS_21_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_LEVIATHANS_20_NAME='stellaris_leviathans_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_LEVIATHANS_20_MD5='162521d883f491fcb4e397b9a60c46fd'
ARCHIVE_BASE_LEVIATHANS_20_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_LEVIATHANS_19_NAME='stellaris_leviathans_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_LEVIATHANS_19_MD5='70f70d4656a3b3069bec4b138b1c27d5'
ARCHIVE_BASE_LEVIATHANS_19_SIZE='59000'
ARCHIVE_BASE_LEVIATHANS_19_VERSION='3.0.3-gog47193'

## Horizon Signal

ARCHIVE_BASE_HORIZONSIGNAL_48_NAME='stellaris_horizon_signal_3_10_1_69202.sh'
ARCHIVE_BASE_HORIZONSIGNAL_48_MD5='a9202280248dd8bfae3cacaa835702ab'
ARCHIVE_BASE_HORIZONSIGNAL_48_SIZE='1136'
ARCHIVE_BASE_HORIZONSIGNAL_48_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_HORIZONSIGNAL_48_URL='https://www.gog.com/game/stellaris_horizon_signal'

ARCHIVE_BASE_HORIZONSIGNAL_47_NAME='stellaris_horizon_signal_3_10_0_2_68987.sh'
ARCHIVE_BASE_HORIZONSIGNAL_47_MD5='a24a2c346eda018bdfee52e9270d0c66'
ARCHIVE_BASE_HORIZONSIGNAL_47_SIZE='1136'
ARCHIVE_BASE_HORIZONSIGNAL_47_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_HORIZONSIGNAL_46_NAME='stellaris_horizon_signal_3_9_3_68314.sh'
ARCHIVE_BASE_HORIZONSIGNAL_46_MD5='b3b8eb00b7ca9c70445bf8b13641ae5e'
ARCHIVE_BASE_HORIZONSIGNAL_46_SIZE='1136'
ARCHIVE_BASE_HORIZONSIGNAL_46_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_HORIZONSIGNAL_43_NAME='stellaris_horizon_signal_3_8_4_1_65337.sh'
ARCHIVE_BASE_HORIZONSIGNAL_43_MD5='97befa175f3b19a1bb0457ef9342b477'
ARCHIVE_BASE_HORIZONSIGNAL_43_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_43_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_HORIZONSIGNAL_39_NAME='stellaris_horizon_signal_3_7_4_63489.sh'
ARCHIVE_BASE_HORIZONSIGNAL_39_MD5='2c110df9fde65ba833611299f9089f11'
ARCHIVE_BASE_HORIZONSIGNAL_39_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_39_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_HORIZONSIGNAL_36_NAME='stellaris_horizon_signal_3_6_1_60754.sh'
ARCHIVE_BASE_HORIZONSIGNAL_36_MD5='2aa466583664f7849a8887288cc11c64'
ARCHIVE_BASE_HORIZONSIGNAL_36_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_36_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_HORIZONSIGNAL_34_NAME='stellaris_horizon_signal_3_5_3_59410.sh'
ARCHIVE_BASE_HORIZONSIGNAL_34_MD5='d8ed88b305b2b59eff219050dfefaaeb'
ARCHIVE_BASE_HORIZONSIGNAL_34_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_34_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_HORIZONSIGNAL_32_NAME='stellaris_horizon_signal_3_4_5_56913.sh'
ARCHIVE_BASE_HORIZONSIGNAL_32_MD5='6799f7b49323c768c3db7a2744e07e09'
ARCHIVE_BASE_HORIZONSIGNAL_32_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_32_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_HORIZONSIGNAL_28_NAME='stellaris_horizon_signal_3_3_4_54421.sh'
ARCHIVE_BASE_HORIZONSIGNAL_28_MD5='80c81dc86845976789437875b8fd3b2e'
ARCHIVE_BASE_HORIZONSIGNAL_28_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_28_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_HORIZONSIGNAL_24_NAME='stellaris_horizon_signal_3_2_1_1_51520.sh'
ARCHIVE_BASE_HORIZONSIGNAL_24_MD5='d9153fc1cf20a225e55cb001aa6b8c51'
ARCHIVE_BASE_HORIZONSIGNAL_24_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_24_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_HORIZONSIGNAL_23_NAME='stellaris_horizon_signal_3_1_1_50008.sh'
ARCHIVE_BASE_HORIZONSIGNAL_23_MD5='5c64e490ee6ac5e72816be2530e90f2b'
ARCHIVE_BASE_HORIZONSIGNAL_23_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_23_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_HORIZONSIGNAL_22_NAME='stellaris_horizon_signal_3_0_3_47193.sh'
ARCHIVE_BASE_HORIZONSIGNAL_22_MD5='40ddcd078680c3ab2bb5e98d7658bfa9'
ARCHIVE_BASE_HORIZONSIGNAL_22_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_22_VERSION='3.0.3-gog47193'

## Utopia

ARCHIVE_BASE_UTOPIA_43_NAME='stellaris_utopia_3_10_1_69202.sh'
ARCHIVE_BASE_UTOPIA_43_MD5='09cd47f044d34cfdde5ef304ac98275d'
ARCHIVE_BASE_UTOPIA_43_SIZE='75324'
ARCHIVE_BASE_UTOPIA_43_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_UTOPIA_43_URL='https://www.gog.com/game/stellaris_utopia'

ARCHIVE_BASE_UTOPIA_42_NAME='stellaris_utopia_3_10_0_2_68987.sh'
ARCHIVE_BASE_UTOPIA_42_MD5='56e133c664fa914c20470499c27d1151'
ARCHIVE_BASE_UTOPIA_42_SIZE='75328'
ARCHIVE_BASE_UTOPIA_42_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_UTOPIA_41_NAME='stellaris_utopia_3_9_3_68314.sh'
ARCHIVE_BASE_UTOPIA_41_MD5='b720f9ac6deec5dda989e0b52c2cee80'
ARCHIVE_BASE_UTOPIA_41_SIZE='75324'
ARCHIVE_BASE_UTOPIA_41_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_UTOPIA_38_NAME='stellaris_utopia_3_8_4_1_65337.sh'
ARCHIVE_BASE_UTOPIA_38_MD5='f37db816affaea32fa037afcf05e6f5c'
ARCHIVE_BASE_UTOPIA_38_SIZE='76000'
ARCHIVE_BASE_UTOPIA_38_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_UTOPIA_34_NAME='stellaris_utopia_3_7_4_63489.sh'
ARCHIVE_BASE_UTOPIA_34_MD5='757c0a5000d03c0c977ea3feb4ac4bec'
ARCHIVE_BASE_UTOPIA_34_SIZE='76000'
ARCHIVE_BASE_UTOPIA_34_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_UTOPIA_31_NAME='stellaris_utopia_3_6_1_60754.sh'
ARCHIVE_BASE_UTOPIA_31_MD5='6942f80fac13261e2de34e350d96e6b8'
ARCHIVE_BASE_UTOPIA_31_SIZE='76000'
ARCHIVE_BASE_UTOPIA_31_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_UTOPIA_29_NAME='stellaris_utopia_3_5_3_59410.sh'
ARCHIVE_BASE_UTOPIA_29_MD5='b71a7c123fa029a65fdeee0f46112560'
ARCHIVE_BASE_UTOPIA_29_SIZE='76000'
ARCHIVE_BASE_UTOPIA_29_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_UTOPIA_27_NAME='stellaris_utopia_3_4_5_56913.sh'
ARCHIVE_BASE_UTOPIA_27_MD5='c78bbd8859e22b93534f8aeec16ef08f'
ARCHIVE_BASE_UTOPIA_27_SIZE='76000'
ARCHIVE_BASE_UTOPIA_27_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_UTOPIA_23_NAME='stellaris_utopia_3_3_4_54421.sh'
ARCHIVE_BASE_UTOPIA_23_MD5='9b4715a94ffdca001ff56e6e6d9a807d'
ARCHIVE_BASE_UTOPIA_23_SIZE='76000'
ARCHIVE_BASE_UTOPIA_23_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_UTOPIA_19_NAME='stellaris_utopia_3_2_1_1_51520.sh'
ARCHIVE_BASE_UTOPIA_19_MD5='bb6b18eabd4e45d846468e1c38d2e7ea'
ARCHIVE_BASE_UTOPIA_19_SIZE='76000'
ARCHIVE_BASE_UTOPIA_19_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_UTOPIA_18_NAME='stellaris_utopia_3_1_1_50008.sh'
ARCHIVE_BASE_UTOPIA_18_MD5='129501ad6bf862bc04aa775f6538e7fe'
ARCHIVE_BASE_UTOPIA_18_SIZE='76000'
ARCHIVE_BASE_UTOPIA_18_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_UTOPIA_17_NAME='stellaris_utopia_3_0_3_47193.sh'
ARCHIVE_BASE_UTOPIA_17_MD5='0987db58e4cb8629714bbe9b2d01906e'
ARCHIVE_BASE_UTOPIA_17_SIZE='76000'
ARCHIVE_BASE_UTOPIA_17_VERSION='3.0.3-gog47193'

## Anniversary Portraits

### Starting with game release 3.7.2,
### this expansion is included in the base game.

ARCHIVE_BASE_ANNIVERSARY_35_NAME='stellaris_anniversary_portraits_3_6_1_60754.sh'
ARCHIVE_BASE_ANNIVERSARY_35_MD5='13d5ed75ed18ae47fd8377a3c0f58eec'
ARCHIVE_BASE_ANNIVERSARY_35_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_35_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_ANNIVERSARY_33_NAME='stellaris_anniversary_portraits_3_5_3_59410.sh'
ARCHIVE_BASE_ANNIVERSARY_33_MD5='7fb42ed038df8658a160a1a575e92ca4'
ARCHIVE_BASE_ANNIVERSARY_33_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_33_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_ANNIVERSARY_31_NAME='stellaris_anniversary_portraits_3_4_5_56913.sh'
ARCHIVE_BASE_ANNIVERSARY_31_MD5='3e31e34d9abb5118a704b904275a14c5'
ARCHIVE_BASE_ANNIVERSARY_31_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_31_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_ANNIVERSARY_27_NAME='stellaris_anniversary_portraits_3_3_4_54421.sh'
ARCHIVE_BASE_ANNIVERSARY_27_MD5='d61fc4a3daaebdfa73b002e1865d65f8'
ARCHIVE_BASE_ANNIVERSARY_27_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_27_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_ANNIVERSARY_23_NAME='stellaris_anniversary_portraits_3_2_1_1_51520.sh'
ARCHIVE_BASE_ANNIVERSARY_23_MD5='8ef72fb6a3a0f648d5c484bad729194c'
ARCHIVE_BASE_ANNIVERSARY_23_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_23_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_ANNIVERSARY_22_NAME='stellaris_anniversary_portraits_3_1_1_50008.sh'
ARCHIVE_BASE_ANNIVERSARY_22_MD5='d6a97a96a73effc93e41f247b86db8e3'
ARCHIVE_BASE_ANNIVERSARY_22_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_22_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_ANNIVERSARY_21_NAME='stellaris_anniversary_portraits_3_0_3_47193.sh'
ARCHIVE_BASE_ANNIVERSARY_21_MD5='53b0dd554774acd8aa821b5be741b4d8'
ARCHIVE_BASE_ANNIVERSARY_21_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_21_VERSION='3.0.3-gog47193'

## Synthetic Dawn Story Pack

ARCHIVE_BASE_SYNTHETICDAWN_44_NAME='stellaris_synthetic_dawn_story_pack_3_10_1_69202.sh'
ARCHIVE_BASE_SYNTHETICDAWN_44_MD5='890a5306863d5e1d800b383273adc3e8'
ARCHIVE_BASE_SYNTHETICDAWN_44_SIZE='48564'
ARCHIVE_BASE_SYNTHETICDAWN_44_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_SYNTHETICDAWN_44_URL='https://www.gog.com/game/stellaris_synthetic_dawn_story_pack'

ARCHIVE_BASE_SYNTHETICDAWN_43_NAME='stellaris_synthetic_dawn_story_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_SYNTHETICDAWN_43_MD5='f5667ee774fe9387250a457a458c04a9'
ARCHIVE_BASE_SYNTHETICDAWN_43_SIZE='48564'
ARCHIVE_BASE_SYNTHETICDAWN_43_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_SYNTHETICDAWN_42_NAME='stellaris_synthetic_dawn_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_SYNTHETICDAWN_42_MD5='b2f35b4c887634e98fbce5e737dd78d1'
ARCHIVE_BASE_SYNTHETICDAWN_42_SIZE='48564'
ARCHIVE_BASE_SYNTHETICDAWN_42_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_SYNTHETICDAWN_39_NAME='stellaris_synthetic_dawn_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_SYNTHETICDAWN_39_MD5='8752ebda6f3ff2a6f1f3ae38ee50e3e8'
ARCHIVE_BASE_SYNTHETICDAWN_39_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_39_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_SYNTHETICDAWN_35_NAME='stellaris_synthetic_dawn_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_SYNTHETICDAWN_35_MD5='09458636f871c76f7e22cc468a7a9f41'
ARCHIVE_BASE_SYNTHETICDAWN_35_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_35_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_SYNTHETICDAWN_32_NAME='stellaris_synthetic_dawn_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_SYNTHETICDAWN_32_MD5='1e203e5c19fe5c63400cf566fea62164'
ARCHIVE_BASE_SYNTHETICDAWN_32_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_32_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_SYNTHETICDAWN_30_NAME='stellaris_synthetic_dawn_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_SYNTHETICDAWN_30_MD5='8f6b7a85ca65572e15f61d724ea99317'
ARCHIVE_BASE_SYNTHETICDAWN_30_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_30_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_SYNTHETICDAWN_28_NAME='stellaris_synthetic_dawn_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_SYNTHETICDAWN_28_MD5='cbcd2a2c6d1b088b634842b9d4abb941'
ARCHIVE_BASE_SYNTHETICDAWN_28_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_28_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_SYNTHETICDAWN_24_NAME='stellaris_synthetic_dawn_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_SYNTHETICDAWN_24_MD5='b89665cf745898060051099d606a889d'
ARCHIVE_BASE_SYNTHETICDAWN_24_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_24_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_SYNTHETICDAWN_20_NAME='stellaris_synthetic_dawn_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_SYNTHETICDAWN_20_MD5='9b00445bf6b381832f6de06e2f5b7827'
ARCHIVE_BASE_SYNTHETICDAWN_20_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_20_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_SYNTHETICDAWN_19_NAME='stellaris_synthetic_dawn_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_SYNTHETICDAWN_19_MD5='69ba65596bc537841adc7c70ff0778a9'
ARCHIVE_BASE_SYNTHETICDAWN_19_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_19_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_SYNTHETICDAWN_18_NAME='stellaris_synthetic_dawn_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_SYNTHETICDAWN_18_MD5='b4231ca3b95b4bdb9e9a2e33c747d8c5'
ARCHIVE_BASE_SYNTHETICDAWN_18_SIZE='49000'
ARCHIVE_BASE_SYNTHETICDAWN_18_VERSION='3.0.3-gog47193'

## Apocalypse

ARCHIVE_BASE_APOCALYPSE_33_NAME='stellaris_apocalypse_3_10_1_69202.sh'
ARCHIVE_BASE_APOCALYPSE_33_MD5='ac4266364748ada11f6119d659934617'
ARCHIVE_BASE_APOCALYPSE_33_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_33_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_APOCALYPSE_33_URL='https://www.gog.com/game/stellaris_apocalypse'

ARCHIVE_BASE_APOCALYPSE_32_NAME='stellaris_apocalypse_3_10_0_2_68987.sh'
ARCHIVE_BASE_APOCALYPSE_32_MD5='84b1b5c099f9a1ade045491ec1000dc3'
ARCHIVE_BASE_APOCALYPSE_32_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_32_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_APOCALYPSE_31_NAME='stellaris_apocalypse_3_9_3_68314.sh'
ARCHIVE_BASE_APOCALYPSE_31_MD5='1e81c558321b0c494118f5eaa320a31a'
ARCHIVE_BASE_APOCALYPSE_31_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_APOCALYPSE_28_NAME='stellaris_apocalypse_3_8_4_1_65337.sh'
ARCHIVE_BASE_APOCALYPSE_28_MD5='a01fd114beedaae30f8036532aeaa3a5'
ARCHIVE_BASE_APOCALYPSE_28_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_APOCALYPSE_24_NAME='stellaris_apocalypse_3_7_4_63489.sh'
ARCHIVE_BASE_APOCALYPSE_24_MD5='635fad17d0a6dbcb51bc4bc134f7a2fc'
ARCHIVE_BASE_APOCALYPSE_24_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_APOCALYPSE_21_NAME='stellaris_apocalypse_3_6_1_60754.sh'
ARCHIVE_BASE_APOCALYPSE_21_MD5='ba7aa69bc21ddc041767975d6891c394'
ARCHIVE_BASE_APOCALYPSE_21_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_APOCALYPSE_19_NAME='stellaris_apocalypse_3_5_3_59410.sh'
ARCHIVE_BASE_APOCALYPSE_19_MD5='40e997269f2806e26c3cef5b604009e2'
ARCHIVE_BASE_APOCALYPSE_19_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_APOCALYPSE_17_NAME='stellaris_apocalypse_3_4_5_56913.sh'
ARCHIVE_BASE_APOCALYPSE_17_MD5='2294a815d331a90c2a226ea679d1b9c2'
ARCHIVE_BASE_APOCALYPSE_17_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_APOCALYPSE_13_NAME='stellaris_apocalypse_3_3_4_54421.sh'
ARCHIVE_BASE_APOCALYPSE_13_MD5='df86d7aa67f4be37822523fef72d15ee'
ARCHIVE_BASE_APOCALYPSE_13_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_APOCALYPSE_9_NAME='stellaris_apocalypse_3_2_1_1_51520.sh'
ARCHIVE_BASE_APOCALYPSE_9_MD5='0db5f6b23432efa4941f7e4e89ff9488'
ARCHIVE_BASE_APOCALYPSE_9_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_APOCALYPSE_8_NAME='stellaris_apocalypse_3_1_1_50008.sh'
ARCHIVE_BASE_APOCALYPSE_8_MD5='a4d25b308d2daf3c81fef2aef33727da'
ARCHIVE_BASE_APOCALYPSE_8_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_APOCALYPSE_7_NAME='stellaris_apocalypse_3_0_3_47193.sh'
ARCHIVE_BASE_APOCALYPSE_7_MD5='3cdf97dedf2514fbb1e9fd123cb253b7'
ARCHIVE_BASE_APOCALYPSE_7_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_7_VERSION='3.0.3-gog47193'

## Humanoids Species Pack

ARCHIVE_BASE_HUMANOIDS_45_NAME='stellaris_humanoids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_HUMANOIDS_45_MD5='ec7e9435a832ba018b188834412be163'
ARCHIVE_BASE_HUMANOIDS_45_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_45_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_HUMANOIDS_45_URL='https://www.gog.com/game/stellaris_humanoids_species_pack'

ARCHIVE_BASE_HUMANOIDS_44_NAME='stellaris_humanoids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_HUMANOIDS_44_MD5='3c81b11d1da6888915d7fcd4ceb3c51b'
ARCHIVE_BASE_HUMANOIDS_44_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_44_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_HUMANOIDS_43_NAME='stellaris_humanoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_HUMANOIDS_43_MD5='d970689331dfae6ad559b4dd8d146080'
ARCHIVE_BASE_HUMANOIDS_43_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_HUMANOIDS_40_NAME='stellaris_humanoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_HUMANOIDS_40_MD5='435cdbbe3a8affded29b3b6f9d36125a'
ARCHIVE_BASE_HUMANOIDS_40_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_HUMANOIDS_36_NAME='stellaris_humanoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_HUMANOIDS_36_MD5='de7661496eba8a9d125b44f3075a71b7'
ARCHIVE_BASE_HUMANOIDS_36_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_HUMANOIDS_33_NAME='stellaris_humanoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_HUMANOIDS_33_MD5='5124b47dce3c7a7282087e521920fee9'
ARCHIVE_BASE_HUMANOIDS_33_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_HUMANOIDS_31_NAME='stellaris_humanoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_HUMANOIDS_31_MD5='9f92e8b6853b26bc31da38b5a0991a37'
ARCHIVE_BASE_HUMANOIDS_31_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_HUMANOIDS_29_NAME='stellaris_humanoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_HUMANOIDS_29_MD5='5fcd93a54b01f93bae743d49bf61860b'
ARCHIVE_BASE_HUMANOIDS_29_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_HUMANOIDS_25_NAME='stellaris_humanoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_HUMANOIDS_25_MD5='b7ccaa9303516274f7945882bd6a2d2f'
ARCHIVE_BASE_HUMANOIDS_25_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_HUMANOIDS_21_NAME='stellaris_humanoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_HUMANOIDS_21_MD5='d56625b5ce55405530929bea32852f54'
ARCHIVE_BASE_HUMANOIDS_21_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_HUMANOIDS_20_NAME='stellaris_humanoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_HUMANOIDS_20_MD5='974908ceeb80ade57dfa00c957604d06'
ARCHIVE_BASE_HUMANOIDS_20_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_HUMANOIDS_19_NAME='stellaris_humanoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_HUMANOIDS_19_MD5='9dc8511383a7c36c54660d6d77d61117'
ARCHIVE_BASE_HUMANOIDS_19_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_19_VERSION='3.0.3-gog47193'

## Distant Stars Story Pack

ARCHIVE_BASE_DISTANTSTARS_44_NAME='stellaris_distant_stars_story_pack_3_10_1_69202.sh'
ARCHIVE_BASE_DISTANTSTARS_44_MD5='dded9ea4d706cf390388acac2784e767'
ARCHIVE_BASE_DISTANTSTARS_44_SIZE='21148'
ARCHIVE_BASE_DISTANTSTARS_44_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_DISTANTSTARS_44_URL='https://www.gog.com/game/stellaris_distant_stars_story_pack'

ARCHIVE_BASE_DISTANTSTARS_43_NAME='stellaris_distant_stars_story_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_DISTANTSTARS_43_MD5='ff3a4082c63e06295ddb436ae5a3964a'
ARCHIVE_BASE_DISTANTSTARS_43_SIZE='21148'
ARCHIVE_BASE_DISTANTSTARS_43_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_DISTANTSTARS_42_NAME='stellaris_distant_stars_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_DISTANTSTARS_42_MD5='9a03b641cc29f77008530d21e64f5232'
ARCHIVE_BASE_DISTANTSTARS_42_SIZE='21148'
ARCHIVE_BASE_DISTANTSTARS_42_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_DISTANTSTARS_39_NAME='stellaris_distant_stars_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_DISTANTSTARS_39_MD5='dcbb606208a16bc8f5f413239bfe69a4'
ARCHIVE_BASE_DISTANTSTARS_39_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_39_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_DISTANTSTARS_35_NAME='stellaris_distant_stars_story_pack_3_7_4_63489.sh'
ARCHIVE_BASE_DISTANTSTARS_35_MD5='d2989715cc656a73c1e2ca922bba10aa'
ARCHIVE_BASE_DISTANTSTARS_35_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_35_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_DISTANTSTARS_32_NAME='stellaris_distant_stars_story_pack_3_6_1_60754.sh'
ARCHIVE_BASE_DISTANTSTARS_32_MD5='1581145f5d4f4dbb491f3d3e1624577d'
ARCHIVE_BASE_DISTANTSTARS_32_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_32_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_DISTANTSTARS_30_NAME='stellaris_distant_stars_story_pack_3_5_3_59410.sh'
ARCHIVE_BASE_DISTANTSTARS_30_MD5='5ca6cc0d7554484af76e491211d75233'
ARCHIVE_BASE_DISTANTSTARS_30_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_30_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_DISTANTSTARS_28_NAME='stellaris_distant_stars_story_pack_3_4_5_56913.sh'
ARCHIVE_BASE_DISTANTSTARS_28_MD5='b2e6d53683346c48d44a058abd18eff9'
ARCHIVE_BASE_DISTANTSTARS_28_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_28_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_DISTANTSTARS_24_NAME='stellaris_distant_stars_story_pack_3_3_4_54421.sh'
ARCHIVE_BASE_DISTANTSTARS_24_MD5='1ca0abfacce33943685ad442ebf9d81a'
ARCHIVE_BASE_DISTANTSTARS_24_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_24_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_DISTANTSTARS_20_NAME='stellaris_distant_stars_story_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_DISTANTSTARS_20_MD5='a24264507765c470fa5d579b02fc8e32'
ARCHIVE_BASE_DISTANTSTARS_20_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_20_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_DISTANTSTARS_19_NAME='stellaris_distant_stars_story_pack_3_1_1_50008.sh'
ARCHIVE_BASE_DISTANTSTARS_19_MD5='31eeae1be998363fec20a8a09affd7b4'
ARCHIVE_BASE_DISTANTSTARS_19_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_19_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_DISTANTSTARS_18_NAME='stellaris_distant_stars_story_pack_3_0_3_47193.sh'
ARCHIVE_BASE_DISTANTSTARS_18_MD5='a19db33750977b3334a553f8c4259bf4'
ARCHIVE_BASE_DISTANTSTARS_18_SIZE='22000'
ARCHIVE_BASE_DISTANTSTARS_18_VERSION='3.0.3-gog47193'

## MegaCorp

ARCHIVE_BASE_MEGACORP_30_NAME='stellaris_megacorp_3_10_1_69202.sh'
ARCHIVE_BASE_MEGACORP_30_MD5='c1f6bdde4832e94df24d75e7ae2a5383'
ARCHIVE_BASE_MEGACORP_30_SIZE='130940'
ARCHIVE_BASE_MEGACORP_30_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_MEGACORP_30_URL='https://www.gog.com/game/stellaris_megacorp'

ARCHIVE_BASE_MEGACORP_29_NAME='stellaris_megacorp_3_10_0_2_68987.sh'
ARCHIVE_BASE_MEGACORP_29_MD5='55f0cfa082c93e363c44d2edabc3f881'
ARCHIVE_BASE_MEGACORP_29_SIZE='130940'
ARCHIVE_BASE_MEGACORP_29_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_MEGACORP_28_NAME='stellaris_megacorp_3_9_3_68314.sh'
ARCHIVE_BASE_MEGACORP_28_MD5='b4bf123675295aa81910698500cdd33b'
ARCHIVE_BASE_MEGACORP_28_SIZE='130940'
ARCHIVE_BASE_MEGACORP_28_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_MEGACORP_25_NAME='stellaris_megacorp_3_8_4_1_65337.sh'
ARCHIVE_BASE_MEGACORP_25_MD5='3b00aacd428ef943bbbd7a4d0e6b50b2'
ARCHIVE_BASE_MEGACORP_25_SIZE='140000'
ARCHIVE_BASE_MEGACORP_25_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_MEGACORP_21_NAME='stellaris_megacorp_3_7_4_63489.sh'
ARCHIVE_BASE_MEGACORP_21_MD5='5b9573bb4261bd177dad3f4acc74a6a1'
ARCHIVE_BASE_MEGACORP_21_SIZE='140000'
ARCHIVE_BASE_MEGACORP_21_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_MEGACORP_18_NAME='stellaris_megacorp_3_6_1_60754.sh'
ARCHIVE_BASE_MEGACORP_18_MD5='af184beefdd7efc6f2d3973bf0d50c71'
ARCHIVE_BASE_MEGACORP_18_SIZE='140000'
ARCHIVE_BASE_MEGACORP_18_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_MEGACORP_16_NAME='stellaris_megacorp_3_5_3_59410.sh'
ARCHIVE_BASE_MEGACORP_16_MD5='2a95d9ff26ed58860be33c860c41fd63'
ARCHIVE_BASE_MEGACORP_16_SIZE='140000'
ARCHIVE_BASE_MEGACORP_16_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_MEGACORP_14_NAME='stellaris_megacorp_3_4_5_56913.sh'
ARCHIVE_BASE_MEGACORP_14_MD5='893df0403e44e6e36060756740230147'
ARCHIVE_BASE_MEGACORP_14_SIZE='140000'
ARCHIVE_BASE_MEGACORP_14_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_MEGACORP_10_NAME='stellaris_megacorp_3_3_4_54421.sh'
ARCHIVE_BASE_MEGACORP_10_MD5='44fb07a81f15d0954088f4bfd88fb933'
ARCHIVE_BASE_MEGACORP_10_SIZE='140000'
ARCHIVE_BASE_MEGACORP_10_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_MEGACORP_6_NAME='stellaris_megacorp_3_2_1_1_51520.sh'
ARCHIVE_BASE_MEGACORP_6_MD5='5965b8b2b51ae9e3dca5726c5d466792'
ARCHIVE_BASE_MEGACORP_6_SIZE='140000'
ARCHIVE_BASE_MEGACORP_6_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_MEGACORP_5_NAME='stellaris_megacorp_3_1_1_50008.sh'
ARCHIVE_BASE_MEGACORP_5_MD5='fa01a1fb786ae3625437bd23275ac401'
ARCHIVE_BASE_MEGACORP_5_SIZE='140000'
ARCHIVE_BASE_MEGACORP_5_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_MEGACORP_4_NAME='stellaris_megacorp_3_0_3_47193.sh'
ARCHIVE_BASE_MEGACORP_4_MD5='8992c77ac7de034c7d3deceb656fb3f6'
ARCHIVE_BASE_MEGACORP_4_SIZE='140000'
ARCHIVE_BASE_MEGACORP_4_VERSION='3.0.3-gog47193'

## Ancient Relics Story Pack

ARCHIVE_BASE_ANCIENTRELICS_33_NAME='stellaris_ancient_relics_3_10_1_69202.sh'
ARCHIVE_BASE_ANCIENTRELICS_33_MD5='83283896b79b4b81325f62a5a2b83281'
ARCHIVE_BASE_ANCIENTRELICS_33_SIZE='33060'
ARCHIVE_BASE_ANCIENTRELICS_33_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_ANCIENTRELICS_33_URL='https://www.gog.com/game/stellaris_ancient_relics_story_pack'

ARCHIVE_BASE_ANCIENTRELICS_32_NAME='stellaris_ancient_relics_3_10_0_2_68987.sh'
ARCHIVE_BASE_ANCIENTRELICS_32_MD5='b6eb34e2fcf75b524dae760a30ee802b'
ARCHIVE_BASE_ANCIENTRELICS_32_SIZE='33060'
ARCHIVE_BASE_ANCIENTRELICS_32_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_ANCIENTRELICS_31_NAME='stellaris_ancient_relics_3_9_3_68314.sh'
ARCHIVE_BASE_ANCIENTRELICS_31_MD5='19909812633ca0d83ad774683f60451f'
ARCHIVE_BASE_ANCIENTRELICS_31_SIZE='33060'
ARCHIVE_BASE_ANCIENTRELICS_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_ANCIENTRELICS_28_NAME='stellaris_ancient_relics_3_8_4_1_65337.sh'
ARCHIVE_BASE_ANCIENTRELICS_28_MD5='491929cb272a6a866020c69a94f3e01b'
ARCHIVE_BASE_ANCIENTRELICS_28_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_ANCIENTRELICS_24_NAME='stellaris_ancient_relics_3_7_4_63489.sh'
ARCHIVE_BASE_ANCIENTRELICS_24_MD5='51f5bc20188137581737a446b1b7498b'
ARCHIVE_BASE_ANCIENTRELICS_24_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_ANCIENTRELICS_21_NAME='stellaris_ancient_relics_3_6_1_60754.sh'
ARCHIVE_BASE_ANCIENTRELICS_21_MD5='40806c04f94d933aa555bc9d9605396c'
ARCHIVE_BASE_ANCIENTRELICS_21_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_ANCIENTRELICS_19_NAME='stellaris_ancient_relics_3_5_3_59410.sh'
ARCHIVE_BASE_ANCIENTRELICS_19_MD5='1052a7d2b77ba0ebbd8af19767952b47'
ARCHIVE_BASE_ANCIENTRELICS_19_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_ANCIENTRELICS_17_NAME='stellaris_ancient_relics_3_4_5_56913.sh'
ARCHIVE_BASE_ANCIENTRELICS_17_MD5='b7536ac852bebe9b12a359c4c0a6ca5e'
ARCHIVE_BASE_ANCIENTRELICS_17_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_ANCIENTRELICS_13_NAME='stellaris_ancient_relics_3_3_4_54421.sh'
ARCHIVE_BASE_ANCIENTRELICS_13_MD5='c09ef087df7e271758b4b8a47a1353bd'
ARCHIVE_BASE_ANCIENTRELICS_13_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_ANCIENTRELICS_9_NAME='stellaris_ancient_relics_3_2_1_1_51520.sh'
ARCHIVE_BASE_ANCIENTRELICS_9_MD5='45de001d3d2b3999d6c4c8948fc22458'
ARCHIVE_BASE_ANCIENTRELICS_9_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_ANCIENTRELICS_8_NAME='stellaris_ancient_relics_3_1_1_50008.sh'
ARCHIVE_BASE_ANCIENTRELICS_8_MD5='ec441d202f321a3d8b23af35fed33531'
ARCHIVE_BASE_ANCIENTRELICS_8_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_ANCIENTRELICS_7_NAME='stellaris_ancient_relics_3_0_3_47193.sh'
ARCHIVE_BASE_ANCIENTRELICS_7_MD5='d98a169dca98257b3944517d98cd17a0'
ARCHIVE_BASE_ANCIENTRELICS_7_SIZE='34000'
ARCHIVE_BASE_ANCIENTRELICS_7_VERSION='3.0.3-gog47193'

## Lithoids Species Pack

ARCHIVE_BASE_LITHOIDS_33_NAME='stellaris_lithoids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_LITHOIDS_33_MD5='95a043b540c05e66d5aa6444cde39a78'
ARCHIVE_BASE_LITHOIDS_33_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_33_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_LITHOIDS_33_URL='https://www.gog.com/game/stellaris_lithoids_species_pack'

ARCHIVE_BASE_LITHOIDS_32_NAME='stellaris_lithoids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_LITHOIDS_32_MD5='7b67f6a6bed2c9a78cf23ede66fa4a9d'
ARCHIVE_BASE_LITHOIDS_32_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_32_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_LITHOIDS_31_NAME='stellaris_lithoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_LITHOIDS_31_MD5='baecdaa00168fe891ff419b71334f313'
ARCHIVE_BASE_LITHOIDS_31_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_LITHOIDS_28_NAME='stellaris_lithoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_LITHOIDS_28_MD5='65723d6948a9380c1397b280f9bc20f4'
ARCHIVE_BASE_LITHOIDS_28_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_LITHOIDS_24_NAME='stellaris_lithoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_LITHOIDS_24_MD5='bfc5632131852032fda229260aa179d6'
ARCHIVE_BASE_LITHOIDS_24_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_LITHOIDS_21_NAME='stellaris_lithoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_LITHOIDS_21_MD5='0adc3e342f420e26a04b256595eee248'
ARCHIVE_BASE_LITHOIDS_21_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_LITHOIDS_19_NAME='stellaris_lithoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_LITHOIDS_19_MD5='30bac0aa5302f556fb13511df2e8194b'
ARCHIVE_BASE_LITHOIDS_19_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_LITHOIDS_17_NAME='stellaris_lithoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_LITHOIDS_17_MD5='54fb17af3ed8b442074c83cf2b818693'
ARCHIVE_BASE_LITHOIDS_17_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_LITHOIDS_13_NAME='stellaris_lithoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_LITHOIDS_13_MD5='cde1e9ed0deaeff8850242e4157783be'
ARCHIVE_BASE_LITHOIDS_13_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_LITHOIDS_9_NAME='stellaris_lithoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_LITHOIDS_9_MD5='ed5aca5df6d72a84f0572200e1d432fe'
ARCHIVE_BASE_LITHOIDS_9_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_LITHOIDS_8_NAME='stellaris_lithoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_LITHOIDS_8_MD5='c935a54a2e9ac78d195440d7ca1391f9'
ARCHIVE_BASE_LITHOIDS_8_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_LITHOIDS_7_NAME='stellaris_lithoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_LITHOIDS_7_MD5='44a8e1008468825af82ec138be388fe9'
ARCHIVE_BASE_LITHOIDS_7_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_7_VERSION='3.0.3-gog47193'

## Federations

ARCHIVE_BASE_FEDERATIONS_25_NAME='stellaris_federations_3_10_1_69202.sh'
ARCHIVE_BASE_FEDERATIONS_25_MD5='2597c00c7e2e775c05a11c3b695d5db3'
ARCHIVE_BASE_FEDERATIONS_25_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_25_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_FEDERATIONS_25_URL='https://www.gog.com/game/stellaris_federations'

ARCHIVE_BASE_FEDERATIONS_24_NAME='stellaris_federations_3_10_0_2_68987.sh'
ARCHIVE_BASE_FEDERATIONS_24_MD5='1cb0a687189ef805856709e9f8c8e0ad'
ARCHIVE_BASE_FEDERATIONS_24_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_24_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_FEDERATIONS_23_NAME='stellaris_federations_3_9_3_68314.sh'
ARCHIVE_BASE_FEDERATIONS_23_MD5='5c2ecccea91eeeea578cd2925a5621eb'
ARCHIVE_BASE_FEDERATIONS_23_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_23_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_FEDERATIONS_20_NAME='stellaris_federations_3_8_4_1_65337.sh'
ARCHIVE_BASE_FEDERATIONS_20_MD5='6fd1449caf09cfd06baff37237aff954'
ARCHIVE_BASE_FEDERATIONS_20_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_20_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_FEDERATIONS_16_NAME='stellaris_federations_3_7_4_63489.sh'
ARCHIVE_BASE_FEDERATIONS_16_MD5='df6d008a05e26559ba65d184e52d5926'
ARCHIVE_BASE_FEDERATIONS_16_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_16_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_FEDERATIONS_13_NAME='stellaris_federations_3_6_1_60754.sh'
ARCHIVE_BASE_FEDERATIONS_13_MD5='7f86c6a7c6d13946528a58c90c7eebc8'
ARCHIVE_BASE_FEDERATIONS_13_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_13_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_FEDERATIONS_11_NAME='stellaris_federations_3_5_3_59410.sh'
ARCHIVE_BASE_FEDERATIONS_11_MD5='02dee79bf1c26ba1b1cfca5103dccdca'
ARCHIVE_BASE_FEDERATIONS_11_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_11_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_FEDERATIONS_9_NAME='stellaris_federations_3_4_5_56913.sh'
ARCHIVE_BASE_FEDERATIONS_9_MD5='96170769d5fef74f2aedf9f3fd85f656'
ARCHIVE_BASE_FEDERATIONS_9_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_9_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_FEDERATIONS_5_NAME='stellaris_federations_3_3_4_54421.sh'
ARCHIVE_BASE_FEDERATIONS_5_MD5='d0dcbaef570563bb87dd16e600e162bd'
ARCHIVE_BASE_FEDERATIONS_5_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_5_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_FEDERATIONS_1_NAME='stellaris_federations_3_2_2_51685.sh'
ARCHIVE_BASE_FEDERATIONS_1_MD5='df17fc878abd4eb957e147feb5b7e39b'
ARCHIVE_BASE_FEDERATIONS_1_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_1_VERSION='3.2.2-gog51685'

## Nemesis

ARCHIVE_BASE_NEMESIS_12_NAME='stellaris_nemesis_3_10_1_69202.sh'
ARCHIVE_BASE_NEMESIS_12_MD5='a947e9923334ef68652edbb24191e20c'
ARCHIVE_BASE_NEMESIS_12_SIZE='38856'
ARCHIVE_BASE_NEMESIS_12_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_NEMESIS_12_URL='https://www.gog.com/game/stellaris_nemesis'

ARCHIVE_BASE_NEMESIS_11_NAME='stellaris_nemesis_3_10_0_2_68987.sh'
ARCHIVE_BASE_NEMESIS_11_MD5='83964f37d25affd9132d6e49baf6d76b'
ARCHIVE_BASE_NEMESIS_11_SIZE='38856'
ARCHIVE_BASE_NEMESIS_11_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_NEMESIS_10_NAME='stellaris_nemesis_3_9_3_68314.sh'
ARCHIVE_BASE_NEMESIS_10_MD5='105f2c56365c3b2b3c329806e4b5272b'
ARCHIVE_BASE_NEMESIS_10_SIZE='38856'
ARCHIVE_BASE_NEMESIS_10_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_NEMESIS_7_NAME='stellaris_nemesis_3_8_4_1_65337.sh'
ARCHIVE_BASE_NEMESIS_7_MD5='ea624db6ea0f9f485cb194c1358dda62'
ARCHIVE_BASE_NEMESIS_7_SIZE='40000'
ARCHIVE_BASE_NEMESIS_7_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_NEMESIS_3_NAME='stellaris_nemesis_3_7_4_63489.sh'
ARCHIVE_BASE_NEMESIS_3_MD5='9fa7ca1ebe2ffb736787f18bf2611311'
ARCHIVE_BASE_NEMESIS_3_SIZE='40000'
ARCHIVE_BASE_NEMESIS_3_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_NEMESIS_0_NAME='stellaris_nemesis_3_6_1_60754.sh'
ARCHIVE_BASE_NEMESIS_0_MD5='ec08053da0ef60ea42a974b26892031a'
ARCHIVE_BASE_NEMESIS_0_SIZE='40000'
ARCHIVE_BASE_NEMESIS_0_VERSION='3.6.1-gog60754'

## Necroids Species Pack

ARCHIVE_BASE_NECROIDS_18_NAME='stellaris_necroids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_NECROIDS_18_MD5='a9478a35f71b02a14de72bda03692b34'
ARCHIVE_BASE_NECROIDS_18_SIZE='49524'
ARCHIVE_BASE_NECROIDS_18_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_NECROIDS_18_URL='https://www.gog.com/game/stellaris_necroids_species_pack'

ARCHIVE_BASE_NECROIDS_17_NAME='stellaris_necroids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_NECROIDS_17_MD5='3949c02f1d073b1174ae274a9a3998ff'
ARCHIVE_BASE_NECROIDS_17_SIZE='49524'
ARCHIVE_BASE_NECROIDS_17_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_NECROIDS_16_NAME='stellaris_necroids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_NECROIDS_16_MD5='8afbc28fb3af625dd145381e44fe7bde'
ARCHIVE_BASE_NECROIDS_16_SIZE='49524'
ARCHIVE_BASE_NECROIDS_16_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_NECROIDS_13_NAME='stellaris_necroids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_NECROIDS_13_MD5='2614b147a120b97e0d5e4f0a24719f82'
ARCHIVE_BASE_NECROIDS_13_SIZE='50000'
ARCHIVE_BASE_NECROIDS_13_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_NECROIDS_9_NAME='stellaris_necroids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_NECROIDS_9_MD5='631269beefca458e901a727af53e09d0'
ARCHIVE_BASE_NECROIDS_9_SIZE='50000'
ARCHIVE_BASE_NECROIDS_9_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_NECROIDS_6_NAME='stellaris_necroids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_NECROIDS_6_MD5='13605c18c7d483b3c8abeff2d60c65f7'
ARCHIVE_BASE_NECROIDS_6_SIZE='50000'
ARCHIVE_BASE_NECROIDS_6_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_NECROIDS_4_NAME='stellaris_necroids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_NECROIDS_4_MD5='23faec896d52d6f2773e19838f365113'
ARCHIVE_BASE_NECROIDS_4_SIZE='50000'
ARCHIVE_BASE_NECROIDS_4_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_NECROIDS_2_NAME='stellaris_necroids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_NECROIDS_2_MD5='e64ecf03e49671cedf3e164709a5837a'
ARCHIVE_BASE_NECROIDS_2_SIZE='50000'
ARCHIVE_BASE_NECROIDS_2_VERSION='3.4.5-gog56913'

## Aquatics Species Pack

ARCHIVE_BASE_AQUATICS_16_NAME='stellaris_aquatics_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_AQUATICS_16_MD5='b542b48d85eba5667315557aca340278'
ARCHIVE_BASE_AQUATICS_16_SIZE='121448'
ARCHIVE_BASE_AQUATICS_16_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_AQUATICS_16_URL='https://www.gog.com/game/stellaris_aquatics_species_pack'

ARCHIVE_BASE_AQUATICS_15_NAME='stellaris_aquatics_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_AQUATICS_15_MD5='bf594d37a181e555dcfcbe772e45a650'
ARCHIVE_BASE_AQUATICS_15_SIZE='121448'
ARCHIVE_BASE_AQUATICS_15_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_AQUATICS_14_NAME='stellaris_aquatics_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_AQUATICS_14_MD5='39294019e3f068916fea06f68e35b1ee'
ARCHIVE_BASE_AQUATICS_14_SIZE='121448'
ARCHIVE_BASE_AQUATICS_14_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_AQUATICS_11_NAME='stellaris_aquatics_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_AQUATICS_11_MD5='34a45daa4a4d1bf204dc9798917692b5'
ARCHIVE_BASE_AQUATICS_11_SIZE='130000'
ARCHIVE_BASE_AQUATICS_11_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_AQUATICS_7_NAME='stellaris_aquatics_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_AQUATICS_7_MD5='f825b3f150a7d936b04b3f5bd35d9f5b'
ARCHIVE_BASE_AQUATICS_7_SIZE='130000'
ARCHIVE_BASE_AQUATICS_7_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_AQUATICS_4_NAME='stellaris_aquatics_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_AQUATICS_4_MD5='5cfdb2861b8c3de9c83798799b477ad6'
ARCHIVE_BASE_AQUATICS_4_SIZE='130000'
ARCHIVE_BASE_AQUATICS_4_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_AQUATICS_2_NAME='stellaris_aquatics_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_AQUATICS_2_MD5='7e3210b2d64b851907a97ed3455ad035'
ARCHIVE_BASE_AQUATICS_2_SIZE='130000'
ARCHIVE_BASE_AQUATICS_2_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_AQUATICS_0_NAME='stellaris_aquatics_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_AQUATICS_0_MD5='0d6fe86d3ec24b114742a333b8de4a3b'
ARCHIVE_BASE_AQUATICS_0_SIZE='130000'
ARCHIVE_BASE_AQUATICS_0_VERSION='3.4.5-gog56913'

## Overlord

ARCHIVE_BASE_OVERLORD_7_NAME='stellaris_overlord_3_10_1_69202.sh'
ARCHIVE_BASE_OVERLORD_7_MD5='ae491975383cfcfc35da0b1b4e003cc0'
ARCHIVE_BASE_OVERLORD_7_SIZE='100180'
ARCHIVE_BASE_OVERLORD_7_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_OVERLORD_7_URL='https://www.gog.com/game/stellaris_overlord'

ARCHIVE_BASE_OVERLORD_6_NAME='stellaris_overlord_3_10_0_2_68987.sh'
ARCHIVE_BASE_OVERLORD_6_MD5='031c07da495842109040c6449a2b4db4'
ARCHIVE_BASE_OVERLORD_6_SIZE='100184'
ARCHIVE_BASE_OVERLORD_6_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_OVERLORD_5_NAME='stellaris_overlord_3_9_3_68314.sh'
ARCHIVE_BASE_OVERLORD_5_MD5='580bcbdf375ead938c80956f27e1069d'
ARCHIVE_BASE_OVERLORD_5_SIZE='100180'
ARCHIVE_BASE_OVERLORD_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_OVERLORD_2_NAME='stellaris_overlord_3_8_4_1_65337.sh'
ARCHIVE_BASE_OVERLORD_2_MD5='e1c1700fa00f2c2d0c86ec4d7d1d63ea'
ARCHIVE_BASE_OVERLORD_2_SIZE='110000'
ARCHIVE_BASE_OVERLORD_2_VERSION='3.8.4.1-gog65337'

## Toxoids Species Pack

ARCHIVE_BASE_TOXOIDS_9_NAME='stellaris_toxoids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_TOXOIDS_9_MD5='ff0eea40c4c5a3d94a137236ce5c6d9e'
ARCHIVE_BASE_TOXOIDS_9_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_9_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_TOXOIDS_9_URL='https://www.gog.com/game/stellaris_toxoids_species_pack'

ARCHIVE_BASE_TOXOIDS_8_NAME='stellaris_toxoids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_TOXOIDS_8_MD5='64c56e55ccfd2fb146425982b8d8e852'
ARCHIVE_BASE_TOXOIDS_8_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_8_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_TOXOIDS_7_NAME='stellaris_toxoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_TOXOIDS_7_MD5='69ee5d18ffe310c64ee61934ec64aa1f'
ARCHIVE_BASE_TOXOIDS_7_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_7_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_TOXOIDS_4_NAME='stellaris_toxoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_TOXOIDS_4_MD5='90926bd74621bf180a074d4721b594f9'
ARCHIVE_BASE_TOXOIDS_4_SIZE='42000'
ARCHIVE_BASE_TOXOIDS_4_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_TOXOIDS_0_NAME='stellaris_toxoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_TOXOIDS_0_MD5='e6af2b93063b67bc78d6a44c70caee1c'
ARCHIVE_BASE_TOXOIDS_0_SIZE='42000'
ARCHIVE_BASE_TOXOIDS_0_VERSION='3.7.4-gog63489'

## First Contact Story Pack

ARCHIVE_BASE_FIRSTCONTACT_7_NAME='stellaris_first_contact_story_pack_3_10_1_69202.sh'
ARCHIVE_BASE_FIRSTCONTACT_7_MD5='6645fe45272746e062a182494b07e001'
ARCHIVE_BASE_FIRSTCONTACT_7_SIZE='1152'
ARCHIVE_BASE_FIRSTCONTACT_7_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_FIRSTCONTACT_7_URL='https://www.gog.com/game/stellaris_first_contact_story_pack'

ARCHIVE_BASE_FIRSTCONTACT_6_NAME='stellaris_first_contact_story_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_FIRSTCONTACT_6_MD5='087d177826e2aea2dcafcec8bd9e3d68'
ARCHIVE_BASE_FIRSTCONTACT_6_SIZE='1152'
ARCHIVE_BASE_FIRSTCONTACT_6_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_FIRSTCONTACT_5_NAME='stellaris_first_contact_story_pack_3_9_3_68314.sh'
ARCHIVE_BASE_FIRSTCONTACT_5_MD5='870a8a53a98f020d9cb55e2b962b6172'
ARCHIVE_BASE_FIRSTCONTACT_5_SIZE='1152'
ARCHIVE_BASE_FIRSTCONTACT_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_FIRSTCONTACT_2_NAME='stellaris_first_contact_story_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_FIRSTCONTACT_2_MD5='dd862bf0d12f5bf0a7a7c116a57f2bbb'
ARCHIVE_BASE_FIRSTCONTACT_2_SIZE='1200'
ARCHIVE_BASE_FIRSTCONTACT_2_VERSION='3.8.4.1-gog65337'

## Galactic Paragons

ARCHIVE_BASE_PARAGONS_7_NAME='stellaris_galactic_paragons_3_10_1_69202.sh'
ARCHIVE_BASE_PARAGONS_7_MD5='a51b35147b8737a83dc2c87d1e15c6e7'
ARCHIVE_BASE_PARAGONS_7_SIZE='1152'
ARCHIVE_BASE_PARAGONS_7_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_PARAGONS_7_URL='https://www.gog.com/game/stellaris_galactic_paragons'

ARCHIVE_BASE_PARAGONS_6_NAME='stellaris_galactic_paragons_3_10_0_2_68987.sh'
ARCHIVE_BASE_PARAGONS_6_MD5='0a9ca705958130bf0472b47e91506afb'
ARCHIVE_BASE_PARAGONS_6_SIZE='1152'
ARCHIVE_BASE_PARAGONS_6_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_PARAGONS_5_NAME='stellaris_galactic_paragons_3_9_3_68314.sh'
ARCHIVE_BASE_PARAGONS_5_MD5='4e1ad6ceb7a5e3bb6d55d1bc7547954e'
ARCHIVE_BASE_PARAGONS_5_SIZE='1152'
ARCHIVE_BASE_PARAGONS_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_PARAGONS_2_NAME='stellaris_galactic_paragons_3_8_4_1_65337.sh'
ARCHIVE_BASE_PARAGONS_2_MD5='e47a7ab7c264021f49b8419e1aedc580'
ARCHIVE_BASE_PARAGONS_2_SIZE='1200'
ARCHIVE_BASE_PARAGONS_2_VERSION='3.8.4.1-gog65337'

## Astral Planes

ARCHIVE_BASE_PLANES_1_NAME='stellaris_astral_planes_3_10_1_69202.sh'
ARCHIVE_BASE_PLANES_1_MD5='9c1e948d507f71c367502ad0b27b8556'
ARCHIVE_BASE_PLANES_1_SIZE='47104'
ARCHIVE_BASE_PLANES_1_VERSION='3.10.1-gog69202'
ARCHIVE_BASE_PLANES_1_URL='https://www.gog.com/game/stellaris_astral_planes'

ARCHIVE_BASE_PLANES_0_NAME='stellaris_astral_planes_3_10_0_2_68987.sh'
ARCHIVE_BASE_PLANES_0_MD5='02a08ebe68c3394d121724e3d7f2221c'
ARCHIVE_BASE_PLANES_0_SIZE='47104'
ARCHIVE_BASE_PLANES_0_VERSION='3.10.0.2-gog68987'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
