#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Slay the Princess
###

script_version=20231109.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='slay-the-princess'
GAME_NAME='Slay the Princess'

ARCHIVE_BASE_2_NAME='slay_the_princess_linux_1_0g_release_68787.sh'
ARCHIVE_BASE_2_MD5='3b8417d581d1d721ab4016720a1ea881'
ARCHIVE_BASE_2_SIZE='10989272'
ARCHIVE_BASE_2_VERSION='1.0g-gog68787'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/slay_the_princess'

ARCHIVE_BASE_1_NAME='slay_the_princess_linux_1_0f_release_68611.sh'
ARCHIVE_BASE_1_MD5='a4fd4334624bbc469a481fc874df2750'
ARCHIVE_BASE_1_SIZE='11003752'
ARCHIVE_BASE_1_VERSION='1.0f-gog68611'

ARCHIVE_BASE_0_NAME='slay_the_princess_linux_1_0d_release_68521.sh'
ARCHIVE_BASE_0_MD5='7acf7f8093cdddff8d484aa4043e5c51'
ARCHIVE_BASE_0_SIZE='11014500'
ARCHIVE_BASE_0_VERSION='1.0d-gog68521'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib/py3-linux-x86_64"
CONTENT_LIBS_BIN_FILES='
librenpython.so'
CONTENT_GAME_BIN_FILES='
lib/py3-linux-x86_64/python
lib/py3-linux-x86_64/pythonw
lib/py3-linux-x86_64/zsync
lib/py3-linux-x86_64/zsyncmake 
lib/py3-linux-x86_64/SlaythePrincess'
CONTENT_GAME_DATA_ARCHIVE_1_FILES='
game/archive.rpa.split00'
CONTENT_GAME_DATA_ARCHIVE_2_FILES='
game/archive.rpa.split01
game/archive.rpa.split02'
CONTENT_GAME_DATA_FILES='
game
renpy
lib/python3.9
SlaythePrincess.py'

APP_MAIN_EXE='lib/py3-linux-x86_64/SlaythePrincess'
APP_MAIN_ICON='../support/icon.png'
## The game crashes on launch when SDL_VIDEODRIVER is set to "wayland".
APP_MAIN_PRERUN='# The game crashes on launch when SDL_VIDEODRIVER is set to "wayland".
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_ARCHIVE_1
PKG_DATA_ARCHIVE_2
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_ARCHIVE_ID="${PKG_DATA_ID}-archive"
PKG_DATA_ARCHIVE_1_ID="${PKG_DATA_ARCHIVE_ID}-1"
PKG_DATA_ARCHIVE_2_ID="${PKG_DATA_ARCHIVE_ID}-2"
PKG_DATA_ARCHIVE_DESCRIPTION="$PKG_DATA_DESCRIPTION - data"
PKG_DATA_ARCHIVE_1_DESCRIPTION="$PKG_DATA_ARCHIVE_DESCRIPTION - 1"
PKG_DATA_ARCHIVE_2_DESCRIPTION="$PKG_DATA_ARCHIVE_DESCRIPTION - 2"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_ARCHIVE_1 $PKG_DATA_ARCHIVE_2"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libpthread.so.0
libutil.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

## Rebuild the huge file from its chunks.
huge_file='game/archive.rpa'
PKG_DATA_POSTINST_RUN="$(package_postinst_actions 'PKG_DATA')
$(huge_file_concatenate "$huge_file")"
PKG_DATA_PRERM_RUN="$(package_prerm_actions 'PKG_DATA')
$(huge_file_delete "$huge_file")"

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
