#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Shadow Gambit
###

script_version=20230923.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='shadow-gambit'
GAME_NAME='Shadow Gambit: The Cursed Crew'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_DEMO_0_NAME='setup_shadow_gambit_the_cursed_crew_demo_1.0.46.r37840.d_(64bit)_(66564).exe'
ARCHIVE_BASE_DEMO_0_MD5='ad6c5d562cb5166301b82311495eb4fc'
ARCHIVE_BASE_DEMO_0_EXTRACTOR='innoextract'
## Do not convert the paths to lower case.
ARCHIVE_BASE_DEMO_0_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_DEMO_0_PART1_NAME='setup_shadow_gambit_the_cursed_crew_demo_1.0.46.r37840.d_(64bit)_(66564)-1.bin'
ARCHIVE_BASE_DEMO_0_PART1_MD5='2ed0f7c0fe3bcba3cfe562ff687743cc'
ARCHIVE_BASE_DEMO_0_PART2_NAME='setup_shadow_gambit_the_cursed_crew_demo_1.0.46.r37840.d_(64bit)_(66564)-2.bin'
ARCHIVE_BASE_DEMO_0_PART2_MD5='cf8746aaa4ff9b40366c562367155876'
ARCHIVE_BASE_DEMO_0_PART3_NAME='setup_shadow_gambit_the_cursed_crew_demo_1.0.46.r37840.d_(64bit)_(66564)-3.bin'
ARCHIVE_BASE_DEMO_0_PART3_MD5='190c8d547cd6f3217a10038079431c9c'
ARCHIVE_BASE_DEMO_0_SIZE='16000000'
ARCHIVE_BASE_DEMO_0_VERSION='1.0.46-gog66564'
ARCHIVE_BASE_DEMO_0_URL='https://www.gog.com/game/shadow_gambit_the_cursed_crew_demo'

UNITY3D_NAME='ShadowGambit_TCC'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_BUNDLES1_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/aa/StandaloneWindows64/mis_*"
CONTENT_GAME_DATA_BUNDLES2_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/aa/StandaloneWindows64/main_*"
CONTENT_GAME_DATA_BUNDLES3_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/aa/StandaloneWindows64"

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Local/ShadowGambit_TCC_Demo'

PACKAGES_LIST='PKG_BIN PKG_DATA_BUNDLES1 PKG_DATA_BUNDLES2 PKG_DATA_BUNDLES3 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_BUNDLES1_ID="${PKG_DATA_ID}-bundles-1"
PKG_DATA_BUNDLES2_ID="${PKG_DATA_ID}-bundles-2"
PKG_DATA_BUNDLES3_ID="${PKG_DATA_ID}-bundles-3"
PKG_DATA_BUNDLES1_ID_DEMO="${PKG_DATA_ID_DEMO}-bundles-1"
PKG_DATA_BUNDLES2_ID_DEMO="${PKG_DATA_ID_DEMO}-bundles-2"
PKG_DATA_BUNDLES3_ID_DEMO="${PKG_DATA_ID_DEMO}-bundles-3"
PKG_DATA_BUNDLES1_DESCRIPTION="$PKG_DATA_DESCRIPTION - bundles - 1"
PKG_DATA_BUNDLES2_DESCRIPTION="$PKG_DATA_DESCRIPTION - bundles - 2"
PKG_DATA_BUNDLES3_DESCRIPTION="$PKG_DATA_DESCRIPTION - bundles - 3"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_BUNDLES1_ID $PKG_DATA_BUNDLES2_ID $PKG_DATA_BUNDLES3_ID"
PKG_DATA_DEPS_DEMO="${PKG_DATA_DEPS_DEMO:-} $PKG_DATA_BUNDLES1_ID_DEMO $PKG_DATA_BUNDLES2_ID_DEMO $PKG_DATA_BUNDLES3_ID_DEMO"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Prevent the inclusion of unwanted files
	rm --force --recursive \
		'commonappdata' \
		'tmp'
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
