#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Baldur's Gate 3
###

script_version=20231103.3

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='baldurs-gate-3'
GAME_NAME='Baldurʼs Gate Ⅲ'

ARCHIVE_BASE_PATCH3_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008).exe'
ARCHIVE_BASE_PATCH3_0_MD5='e2da307eb714d2e746048e8fb7d646a4'
ARCHIVE_BASE_PATCH3_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH3_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-1.bin'
ARCHIVE_BASE_PATCH3_0_PART1_MD5='c1f97403bf1b7aef31aac7ac8a05c52c'
ARCHIVE_BASE_PATCH3_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-2.bin'
ARCHIVE_BASE_PATCH3_0_PART2_MD5='f758ba3cb8c8b92ec3f87d1b923b7c11'
ARCHIVE_BASE_PATCH3_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-3.bin'
ARCHIVE_BASE_PATCH3_0_PART3_MD5='0a74176898bbe90ba6df280d002c608f'
ARCHIVE_BASE_PATCH3_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-4.bin'
ARCHIVE_BASE_PATCH3_0_PART4_MD5='2839a599a52492bf7fc7e21a0f948792'
ARCHIVE_BASE_PATCH3_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-5.bin'
ARCHIVE_BASE_PATCH3_0_PART5_MD5='e6662560a171acf293da789ba73e66a5'
ARCHIVE_BASE_PATCH3_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-6.bin'
ARCHIVE_BASE_PATCH3_0_PART6_MD5='3fa48d0c2cbdb8d2bed0d7b1120e4807'
ARCHIVE_BASE_PATCH3_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-7.bin'
ARCHIVE_BASE_PATCH3_0_PART7_MD5='435d3b387cbd7f77149f4fd48e97172e'
ARCHIVE_BASE_PATCH3_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-8.bin'
ARCHIVE_BASE_PATCH3_0_PART8_MD5='3e6a2f03e58ec7067c9cebffc913144d'
ARCHIVE_BASE_PATCH3_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-9.bin'
ARCHIVE_BASE_PATCH3_0_PART9_MD5='9560938b6aa92559096c7db471c437fa'
ARCHIVE_BASE_PATCH3_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-10.bin'
ARCHIVE_BASE_PATCH3_0_PART10_MD5='42e9165bd6665754052936cf5949269a'
ARCHIVE_BASE_PATCH3_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-11.bin'
ARCHIVE_BASE_PATCH3_0_PART11_MD5='b536ed99f08843c8bb6c7af50f3a14b9'
ARCHIVE_BASE_PATCH3_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-12.bin'
ARCHIVE_BASE_PATCH3_0_PART12_MD5='86a43810f51761fd09a653f1b89e9936'
ARCHIVE_BASE_PATCH3_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-13.bin'
ARCHIVE_BASE_PATCH3_0_PART13_MD5='83d3432202ca5a775952afc001086a03'
ARCHIVE_BASE_PATCH3_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-14.bin'
ARCHIVE_BASE_PATCH3_0_PART14_MD5='db7dcdd36279cf06e014b3d51d06e978'
ARCHIVE_BASE_PATCH3_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-15.bin'
ARCHIVE_BASE_PATCH3_0_PART15_MD5='9e472641d3c34199dfeba8851f7bdcf5'
ARCHIVE_BASE_PATCH3_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-16.bin'
ARCHIVE_BASE_PATCH3_0_PART16_MD5='1f7d14f63ecafdbbcd727de7ac38223c'
ARCHIVE_BASE_PATCH3_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-17.bin'
ARCHIVE_BASE_PATCH3_0_PART17_MD5='f1359a59c61a955f0620febc487a1269'
ARCHIVE_BASE_PATCH3_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-18.bin'
ARCHIVE_BASE_PATCH3_0_PART18_MD5='bfd969ab39637c49b64f7cfaa1f20804'
ARCHIVE_BASE_PATCH3_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-19.bin'
ARCHIVE_BASE_PATCH3_0_PART19_MD5='e8eae4f90a2cea5bcbdee08a1b712aef'
ARCHIVE_BASE_PATCH3_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-20.bin'
ARCHIVE_BASE_PATCH3_0_PART20_MD5='b88525457e4b590b78c34f40e1ba60f0'
ARCHIVE_BASE_PATCH3_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-21.bin'
ARCHIVE_BASE_PATCH3_0_PART21_MD5='d74266b799d4d911838cf9173c87fda6'
ARCHIVE_BASE_PATCH3_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-22.bin'
ARCHIVE_BASE_PATCH3_0_PART22_MD5='75b917c7abbf4483a82b56b5395e39c0'
ARCHIVE_BASE_PATCH3_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-23.bin'
ARCHIVE_BASE_PATCH3_0_PART23_MD5='bd518745958733216fb50f9fce5cb494'
ARCHIVE_BASE_PATCH3_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-24.bin'
ARCHIVE_BASE_PATCH3_0_PART24_MD5='404946034a46864f9172c7b9cf13002b'
ARCHIVE_BASE_PATCH3_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-25.bin'
ARCHIVE_BASE_PATCH3_0_PART25_MD5='f6255a2a3130642c3f96fd43252e9dec'
ARCHIVE_BASE_PATCH3_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-26.bin'
ARCHIVE_BASE_PATCH3_0_PART26_MD5='d2bbcc99329999915b2b478e9d9218e4'
ARCHIVE_BASE_PATCH3_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-27.bin'
ARCHIVE_BASE_PATCH3_0_PART27_MD5='3e8cc3d3b3028f065e73296dcc714712'
ARCHIVE_BASE_PATCH3_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-28.bin'
ARCHIVE_BASE_PATCH3_0_PART28_MD5='1ad835b73e36f5fd9706f5a3e3ccd276'
ARCHIVE_BASE_PATCH3_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-29.bin'
ARCHIVE_BASE_PATCH3_0_PART29_MD5='27564ccea2ef5b369feee3b246631060'
ARCHIVE_BASE_PATCH3_0_PART30_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-30.bin'
ARCHIVE_BASE_PATCH3_0_PART30_MD5='c3729516a6fb77dad2f760ef9d21bb9a'
ARCHIVE_BASE_PATCH3_0_PART31_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3767641_-_patch_patch3_hotfix3__(64bit)_(68008)-31.bin'
ARCHIVE_BASE_PATCH3_0_PART31_MD5='5fb4854aaac674f56a563dc4616b8792'
ARCHIVE_BASE_PATCH3_0_SIZE='156835644'
ARCHIVE_BASE_PATCH3_0_VERSION='4.1.1.3767641-gog68008'
ARCHIVE_BASE_PATCH3_0_URL='https://www.gog.com/game/baldurs_gate_iii'

ARCHIVE_BASE_PATCH2_0_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336).exe'
ARCHIVE_BASE_PATCH2_0_MD5='6eeac06fdc264d09052dd52a5d8f85fb'
ARCHIVE_BASE_PATCH2_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH2_0_PART1_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-1.bin'
ARCHIVE_BASE_PATCH2_0_PART1_MD5='a8ac39fc4ddd9dc8c8b451ddceb2bed7'
ARCHIVE_BASE_PATCH2_0_PART2_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-2.bin'
ARCHIVE_BASE_PATCH2_0_PART2_MD5='1e1806b014056b87e1d8d38310d27843'
ARCHIVE_BASE_PATCH2_0_PART3_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-3.bin'
ARCHIVE_BASE_PATCH2_0_PART3_MD5='3caaa1250e79563a94689b6cc7777226'
ARCHIVE_BASE_PATCH2_0_PART4_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-4.bin'
ARCHIVE_BASE_PATCH2_0_PART4_MD5='c73405adb39664c2580444be4d8f1e77'
ARCHIVE_BASE_PATCH2_0_PART5_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-5.bin'
ARCHIVE_BASE_PATCH2_0_PART5_MD5='d380505dfa53dfda7cfd446781cadc1e'
ARCHIVE_BASE_PATCH2_0_PART6_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-6.bin'
ARCHIVE_BASE_PATCH2_0_PART6_MD5='bbd932a09811206b178cbaaa3e1961f4'
ARCHIVE_BASE_PATCH2_0_PART7_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-7.bin'
ARCHIVE_BASE_PATCH2_0_PART7_MD5='9096d0e0d58509b010366140d74d0387'
ARCHIVE_BASE_PATCH2_0_PART8_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-8.bin'
ARCHIVE_BASE_PATCH2_0_PART8_MD5='bbfceef39180a8066727f23c9e494f9a'
ARCHIVE_BASE_PATCH2_0_PART9_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-9.bin'
ARCHIVE_BASE_PATCH2_0_PART9_MD5='5a118078fc27f3aa102023ef6f0f8b38'
ARCHIVE_BASE_PATCH2_0_PART10_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-10.bin'
ARCHIVE_BASE_PATCH2_0_PART10_MD5='0f221f4cb8c70bec4a76f605842e4b5a'
ARCHIVE_BASE_PATCH2_0_PART11_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-11.bin'
ARCHIVE_BASE_PATCH2_0_PART11_MD5='03bb396186275434f3630dcaea22f847'
ARCHIVE_BASE_PATCH2_0_PART12_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-12.bin'
ARCHIVE_BASE_PATCH2_0_PART12_MD5='94e6c7a3957f0692587dd1e17e57bd6b'
ARCHIVE_BASE_PATCH2_0_PART13_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-13.bin'
ARCHIVE_BASE_PATCH2_0_PART13_MD5='0e492c7302256ec45e5f01cb6d86f194'
ARCHIVE_BASE_PATCH2_0_PART14_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-14.bin'
ARCHIVE_BASE_PATCH2_0_PART14_MD5='2d476b947cd51d52d5406eb22772b370'
ARCHIVE_BASE_PATCH2_0_PART15_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-15.bin'
ARCHIVE_BASE_PATCH2_0_PART15_MD5='932de8332ecef4512f15942f306e35d9'
ARCHIVE_BASE_PATCH2_0_PART16_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-16.bin'
ARCHIVE_BASE_PATCH2_0_PART16_MD5='e7fd6a1d8b1191726d29beeb671db49a'
ARCHIVE_BASE_PATCH2_0_PART17_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-17.bin'
ARCHIVE_BASE_PATCH2_0_PART17_MD5='586951c282b7937106f303a80911245b'
ARCHIVE_BASE_PATCH2_0_PART18_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-18.bin'
ARCHIVE_BASE_PATCH2_0_PART18_MD5='f9a7d5f8dacd3469bdb79126bd4838e7'
ARCHIVE_BASE_PATCH2_0_PART19_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-19.bin'
ARCHIVE_BASE_PATCH2_0_PART19_MD5='9099f94ffe643239596ce857c1720e08'
ARCHIVE_BASE_PATCH2_0_PART20_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-20.bin'
ARCHIVE_BASE_PATCH2_0_PART20_MD5='9e20afbabdaea6d69bc51045da768f69'
ARCHIVE_BASE_PATCH2_0_PART21_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-21.bin'
ARCHIVE_BASE_PATCH2_0_PART21_MD5='4230156c15022f0634edd98542020683'
ARCHIVE_BASE_PATCH2_0_PART22_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-22.bin'
ARCHIVE_BASE_PATCH2_0_PART22_MD5='0471d8d45cd5eb7accdd16c563c1e972'
ARCHIVE_BASE_PATCH2_0_PART23_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-23.bin'
ARCHIVE_BASE_PATCH2_0_PART23_MD5='50d0b713eaa36adaf530f9bf87600baa'
ARCHIVE_BASE_PATCH2_0_PART24_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-24.bin'
ARCHIVE_BASE_PATCH2_0_PART24_MD5='05c0bdfd7c1b01083d511054f6a9f23a'
ARCHIVE_BASE_PATCH2_0_PART25_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-25.bin'
ARCHIVE_BASE_PATCH2_0_PART25_MD5='96141571c42a53a9bf78960e4c7d83ab'
ARCHIVE_BASE_PATCH2_0_PART26_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-26.bin'
ARCHIVE_BASE_PATCH2_0_PART26_MD5='3e23b9e016c006fae2c3c60a5af44a47'
ARCHIVE_BASE_PATCH2_0_PART27_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-27.bin'
ARCHIVE_BASE_PATCH2_0_PART27_MD5='b50cb9a55312f948909ee57c6ed09469'
ARCHIVE_BASE_PATCH2_0_PART28_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-28.bin'
ARCHIVE_BASE_PATCH2_0_PART28_MD5='24910c2975faf1762a177df3cb95c593'
ARCHIVE_BASE_PATCH2_0_PART29_NAME='setup_baldurs_gate_3_release_-_v4.1.1.3700362_-_patch_patch2_hotfix2__(64bit)_(67336)-29.bin'
ARCHIVE_BASE_PATCH2_0_PART29_MD5='2e4c222aabc70fd6068ad8834aaa7b2c'
ARCHIVE_BASE_PATCH2_0_SIZE='145464212'
ARCHIVE_BASE_PATCH2_0_VERSION='4.1.1.3700362-gog67336'
ARCHIVE_BASE_PATCH2_0_URL='https://www.gog.com/game/baldurs_gate_iii'

ARCHIVE_BASE_PATCH1_0_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052).exe'
ARCHIVE_BASE_PATCH1_0_MD5='09401cf3b960c56032b9c8d5492d2316'
ARCHIVE_BASE_PATCH1_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH1_0_PART1_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-1.bin'
ARCHIVE_BASE_PATCH1_0_PART1_MD5='f3a8409e3f4dd3db98bc5df6ce0742f5'
ARCHIVE_BASE_PATCH1_0_PART2_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-2.bin'
ARCHIVE_BASE_PATCH1_0_PART2_MD5='9135194fb160d8d8fb35aac207b668b3'
ARCHIVE_BASE_PATCH1_0_PART3_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-3.bin'
ARCHIVE_BASE_PATCH1_0_PART3_MD5='489c13ad3282beb71aa3de4db880fade'
ARCHIVE_BASE_PATCH1_0_PART4_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-4.bin'
ARCHIVE_BASE_PATCH1_0_PART4_MD5='24caf894181a2d7be008bfd6bce865a6'
ARCHIVE_BASE_PATCH1_0_PART5_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-5.bin'
ARCHIVE_BASE_PATCH1_0_PART5_MD5='17a4f372bd3d56a3b531eb2bf1c9f14d'
ARCHIVE_BASE_PATCH1_0_PART6_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-6.bin'
ARCHIVE_BASE_PATCH1_0_PART6_MD5='5897dad5e3de1419b13ea78ffb200510'
ARCHIVE_BASE_PATCH1_0_PART7_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-7.bin'
ARCHIVE_BASE_PATCH1_0_PART7_MD5='f652711efa1f8328d097be81527260f4'
ARCHIVE_BASE_PATCH1_0_PART8_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-8.bin'
ARCHIVE_BASE_PATCH1_0_PART8_MD5='748370642aefced9eb5647cc4e431828'
ARCHIVE_BASE_PATCH1_0_PART9_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-9.bin'
ARCHIVE_BASE_PATCH1_0_PART9_MD5='01e5e27b88c2d9a610136fafdb4b8f02'
ARCHIVE_BASE_PATCH1_0_PART10_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-10.bin'
ARCHIVE_BASE_PATCH1_0_PART10_MD5='084d3daf2161b8054e5a4d58fd859e80'
ARCHIVE_BASE_PATCH1_0_PART11_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-11.bin'
ARCHIVE_BASE_PATCH1_0_PART11_MD5='6a2e64ba408cfacc1cf4d4c87ef0ef7b'
ARCHIVE_BASE_PATCH1_0_PART12_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-12.bin'
ARCHIVE_BASE_PATCH1_0_PART12_MD5='c7936ac74791438308efb79b748a1a9e'
ARCHIVE_BASE_PATCH1_0_PART13_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-13.bin'
ARCHIVE_BASE_PATCH1_0_PART13_MD5='262a4d8e4c34d382a6220acf44205b84'
ARCHIVE_BASE_PATCH1_0_PART14_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-14.bin'
ARCHIVE_BASE_PATCH1_0_PART14_MD5='ccf42f75bdd18740ddc3680ece6c06b2'
ARCHIVE_BASE_PATCH1_0_PART15_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-15.bin'
ARCHIVE_BASE_PATCH1_0_PART15_MD5='2e2558d1b7c1d5252afcb6a0542b3848'
ARCHIVE_BASE_PATCH1_0_PART16_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-16.bin'
ARCHIVE_BASE_PATCH1_0_PART16_MD5='a7d40cc96e64cdb85aeccc2471900acc'
ARCHIVE_BASE_PATCH1_0_PART17_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-17.bin'
ARCHIVE_BASE_PATCH1_0_PART17_MD5='53b77f130bc641baf7e26007f9fc3849'
ARCHIVE_BASE_PATCH1_0_PART18_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-18.bin'
ARCHIVE_BASE_PATCH1_0_PART18_MD5='26ecb989f6d025bb4ab5ea726cacb496'
ARCHIVE_BASE_PATCH1_0_PART19_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-19.bin'
ARCHIVE_BASE_PATCH1_0_PART19_MD5='8f507b0da3729dba21989460f96d3781'
ARCHIVE_BASE_PATCH1_0_PART20_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-20.bin'
ARCHIVE_BASE_PATCH1_0_PART20_MD5='40493a3fb33da7202533823f1444b526'
ARCHIVE_BASE_PATCH1_0_PART21_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-21.bin'
ARCHIVE_BASE_PATCH1_0_PART21_MD5='8f2abd65aaaae133ac4e6233efda0654'
ARCHIVE_BASE_PATCH1_0_PART22_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-22.bin'
ARCHIVE_BASE_PATCH1_0_PART22_MD5='f5a21a6a93328adb55459b28d7096608'
ARCHIVE_BASE_PATCH1_0_PART23_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-23.bin'
ARCHIVE_BASE_PATCH1_0_PART23_MD5='0f2f3783421bbf5c7c714b0d99dc0bc2'
ARCHIVE_BASE_PATCH1_0_PART24_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-24.bin'
ARCHIVE_BASE_PATCH1_0_PART24_MD5='11ee20ad29f1dfa7ba9618664c974fa9'
ARCHIVE_BASE_PATCH1_0_PART25_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-25.bin'
ARCHIVE_BASE_PATCH1_0_PART25_MD5='4c93abd831b0469f2061f27b6ecaebe0'
ARCHIVE_BASE_PATCH1_0_PART26_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-26.bin'
ARCHIVE_BASE_PATCH1_0_PART26_MD5='610b63465163f61c5e645092800bc3d9'
ARCHIVE_BASE_PATCH1_0_PART27_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-27.bin'
ARCHIVE_BASE_PATCH1_0_PART27_MD5='9e81fa436fb596f0ae071ae1d7d660d6'
ARCHIVE_BASE_PATCH1_0_PART28_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3669438_-_patch_patch1_data_fix_(64bit)_(67052)-28.bin'
ARCHIVE_BASE_PATCH1_0_PART28_MD5='8581ed928d138c89a05d68a116684d7a'
ARCHIVE_BASE_PATCH1_0_SIZE='140000000'
ARCHIVE_BASE_PATCH1_0_VERSION='4.1.1.3669438-gog67052'

ARCHIVE_BASE_PATCH0_0_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683).exe'
ARCHIVE_BASE_PATCH0_0_MD5='986cbd346ca2444eba5ca65921557abc'
ARCHIVE_BASE_PATCH0_0_TYPE='innosetup'
ARCHIVE_BASE_PATCH0_0_PART1_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-1.bin'
ARCHIVE_BASE_PATCH0_0_PART1_MD5='14c9146c4ef5c86dae1edcc4ffcf5953'
ARCHIVE_BASE_PATCH0_0_PART2_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-2.bin'
ARCHIVE_BASE_PATCH0_0_PART2_MD5='2768930a5a1f20998c087c483c298d4e'
ARCHIVE_BASE_PATCH0_0_PART3_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-3.bin'
ARCHIVE_BASE_PATCH0_0_PART3_MD5='f6de17882cf9c14bf4d9c35d1408b370'
ARCHIVE_BASE_PATCH0_0_PART4_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-4.bin'
ARCHIVE_BASE_PATCH0_0_PART4_MD5='57821851b52dbc96735e19ed4cea4412'
ARCHIVE_BASE_PATCH0_0_PART5_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-5.bin'
ARCHIVE_BASE_PATCH0_0_PART5_MD5='2699c17f29e4385685fedf8f4c722942'
ARCHIVE_BASE_PATCH0_0_PART6_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-6.bin'
ARCHIVE_BASE_PATCH0_0_PART6_MD5='dfda5cb12822ab47d0fbec331a3bf4e9'
ARCHIVE_BASE_PATCH0_0_PART7_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-7.bin'
ARCHIVE_BASE_PATCH0_0_PART7_MD5='a9c6c86ba6b752fdfe3b17e2bb671da9'
ARCHIVE_BASE_PATCH0_0_PART8_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-8.bin'
ARCHIVE_BASE_PATCH0_0_PART8_MD5='6b8124c98e89a4476fd5ebc5fb6eac4e'
ARCHIVE_BASE_PATCH0_0_PART9_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-9.bin'
ARCHIVE_BASE_PATCH0_0_PART9_MD5='0b40958f3d74bc799e39c0b6757dd210'
ARCHIVE_BASE_PATCH0_0_PART10_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-10.bin'
ARCHIVE_BASE_PATCH0_0_PART10_MD5='274034a44d58e127f845664c7ba290ee'
ARCHIVE_BASE_PATCH0_0_PART11_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-11.bin'
ARCHIVE_BASE_PATCH0_0_PART11_MD5='2f4d7c82fb650731a2e215d28b4aefc8'
ARCHIVE_BASE_PATCH0_0_PART12_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-12.bin'
ARCHIVE_BASE_PATCH0_0_PART12_MD5='bd3a022fe59b2089d97e5f3905bc3962'
ARCHIVE_BASE_PATCH0_0_PART13_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-13.bin'
ARCHIVE_BASE_PATCH0_0_PART13_MD5='712abe64604b05e2fbbc7bd9aacb1413'
ARCHIVE_BASE_PATCH0_0_PART14_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-14.bin'
ARCHIVE_BASE_PATCH0_0_PART14_MD5='4dfd9e4a56ce1d63293a0e7bcc66e7a4'
ARCHIVE_BASE_PATCH0_0_PART15_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-15.bin'
ARCHIVE_BASE_PATCH0_0_PART15_MD5='512fa657892ca991d3f626e21f2d6821'
ARCHIVE_BASE_PATCH0_0_PART16_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-16.bin'
ARCHIVE_BASE_PATCH0_0_PART16_MD5='e364b2302d2e23e79478eceda835b95f'
ARCHIVE_BASE_PATCH0_0_PART17_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-17.bin'
ARCHIVE_BASE_PATCH0_0_PART17_MD5='0623bd7550eb187d569ee66cf2bad6c1'
ARCHIVE_BASE_PATCH0_0_PART18_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-18.bin'
ARCHIVE_BASE_PATCH0_0_PART18_MD5='886a04f956eb69f6a644dd9faff319d0'
ARCHIVE_BASE_PATCH0_0_PART19_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-19.bin'
ARCHIVE_BASE_PATCH0_0_PART19_MD5='c6d3c5c670066872c7e0cf78162d96ad'
ARCHIVE_BASE_PATCH0_0_PART20_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-20.bin'
ARCHIVE_BASE_PATCH0_0_PART20_MD5='6517b23d62e752d5f28e607157690f9b'
ARCHIVE_BASE_PATCH0_0_PART21_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-21.bin'
ARCHIVE_BASE_PATCH0_0_PART21_MD5='e80bbbd92fa5992792679bf0f46d32ad'
ARCHIVE_BASE_PATCH0_0_PART22_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-22.bin'
ARCHIVE_BASE_PATCH0_0_PART22_MD5='16c82788a087f3ad44939854aed5b812'
ARCHIVE_BASE_PATCH0_0_PART23_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-23.bin'
ARCHIVE_BASE_PATCH0_0_PART23_MD5='ee096b68eb210b732348d31e940702ea'
ARCHIVE_BASE_PATCH0_0_PART24_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-24.bin'
ARCHIVE_BASE_PATCH0_0_PART24_MD5='df2a50351cc593ebaf7316afe7a0ae72'
ARCHIVE_BASE_PATCH0_0_PART25_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-25.bin'
ARCHIVE_BASE_PATCH0_0_PART25_MD5='1db116cd2f589addfa9cf258429c085b'
ARCHIVE_BASE_PATCH0_0_PART26_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-26.bin'
ARCHIVE_BASE_PATCH0_0_PART26_MD5='f937efd190dc0a93b918061f97d24ba9'
ARCHIVE_BASE_PATCH0_0_PART27_NAME='setup_baldurs_gate_3_live_-_v4.1.1.3635601_-_patch0_hotfix2.1_(64bit)_(66683)-27.bin'
ARCHIVE_BASE_PATCH0_0_PART27_MD5='2c61a47bea3ed93960382139ba15c6b7'
ARCHIVE_BASE_PATCH0_0_SIZE='131000000'
ARCHIVE_BASE_PATCH0_0_VERSION='4.1.1.3635601-gog66683'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
bin'
CONTENT_GAME_L10N_VOICES_FILES='
data/localization/voice.pak
data/localization/voicemeta.pak'
CONTENT_GAME_L10N_COMMON_FILES='
data/localization/english.pak
data/localization/english_animations.pak'
CONTENT_GAME_L10N_FR_FILES='
data/localization/french'
CONTENT_GAME_DATA_MODELS_FILES='
data/models.pak'
CONTENT_GAME_DATA_SOUNDS_FILES='
data/sharedsounds.pak
data/sharedsoundbanks.pak'
CONTENT_GAME_DATA_TEXTURES_1_FILES='
data/gustav_textures.pak
data/textures.pak
data/textures_1.pak'
CONTENT_GAME_DATA_TEXTURES_2_FILES='
data/textures_2.pak
data/textures_3.pak
data/virtualtextures.pak'
CONTENT_GAME_DATA_TEXTURES_3_FILES='
data/virtualtextures_1.pak
data/virtualtextures_2.pak'
CONTENT_GAME_DATA_TEXTURES_4_FILES='
data/virtualtextures_3.pak
data/virtualtextures_4.pak'
CONTENT_GAME_DATA_TEXTURES_5_FILES='
data/virtualtextures_5.pak
data/virtualtextures_6.pak'
CONTENT_GAME_DATA_TEXTURES_6_FILES='
data/virtualtextures_7.pak
data/virtualtextures_8.pak'
CONTENT_GAME_DATA_TEXTURES_7_FILES='
data/virtualtextures_9.pak
data/virtualtextures_10.pak'
CONTENT_GAME_DATA_TEXTURES_8_FILES='
data/virtualtextures_11.pak
data/virtualtextures_12.pak'
CONTENT_GAME_DATA_TEXTURES_9_FILES='
data/virtualtextures_13.pak
data/virtualtextures_14.pak'
CONTENT_GAME_DATA_TEXTURES_10_FILES='
data/virtualtextures_15.pak
data/virtualtextures_16.pak'
CONTENT_GAME_DATA_TEXTURES_11_FILES='
data/virtualtextures_17.pak
data/virtualtextures_18.pak'
CONTENT_GAME_DATA_PATCH0_FILES='
data/patch0_hotfix*.pak'
CONTENT_GAME_DATA_PATCH1_FILES='
data/patch1.pak'
CONTENT_GAME_DATA_PATCH2_FILES='
data/patch2.pak
data/patch2_hotfix*.pak'
CONTENT_GAME_DATA_PATCH3_FILES='
data/patch3_hotfix*.pak'
CONTENT_GAME_DATA_FILES='
data/assets.pak
data/day0.pak
data/diceset??.pak
data/effects.pak
data/engine.pak
data/engineshaders.pak
data/game.pak
data/gameplatform.pak
data/gustav_navcloud.pak
data/gustav_video.pak
data/icons.pak
data/lowtex.pak
data/materials.pak
data/shared.pak'

HUGE_FILES_DATA='
data/gustav.pak'
## The _PATCH3 suffix is doubled so this matches:
## PKG_DATA_PATCH3 in the context of ARCHIVE_BASE_PATCH3
## but does not match:
## PKG_DATA in the context of ARCHIVE_BASE_PATCH3
HUGE_FILES_DATA_PATCH3_PATCH3='
data/patch3.pak'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Local/Larian Studios/Baldur's Gate 3"
## mfc140u.dll is required
WINE_WINETRICKS_VERBS='mfc140'

APP_MAIN_EXE='bin/bg3.exe'
## Run the game binary from its parent directory
APP_MAIN_PRERUN='# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")
'

PACKAGES_LIST_BASE='
PKG_BIN
PKG_L10N_VOICES
PKG_L10N_COMMON
PKG_L10N_EN
PKG_L10N_FR
PKG_DATA_MODELS
PKG_DATA_SOUNDS
PKG_DATA_TEXTURES_1
PKG_DATA_TEXTURES_2
PKG_DATA_TEXTURES_3
PKG_DATA_TEXTURES_4
PKG_DATA_TEXTURES_5
PKG_DATA_TEXTURES_6
PKG_DATA_TEXTURES_7
PKG_DATA_TEXTURES_8
PKG_DATA_TEXTURES_9
PKG_DATA_TEXTURES_10
PKG_DATA_TEXTURES_11
PKG_DATA'
PACKAGES_LIST_PATCH0="
PKG_DATA_PATCH0
$PACKAGES_LIST_BASE"
PACKAGES_LIST_PATCH1="
PKG_DATA_PATCH1
$PACKAGES_LIST_PATCH0"
PACKAGES_LIST_PATCH2="
PKG_DATA_PATCH2
$PACKAGES_LIST_PATCH1"
PACKAGES_LIST_PATCH3="
PKG_DATA_PATCH3
$PACKAGES_LIST_PATCH2"

PKG_L10N_COMMON_ID="${GAME_ID}-l10n-common"
PKG_L10N_COMMON_DESCRIPTION='localizations - shared files'

PKG_L10N_VOICES_ID="${GAME_ID}-l10n-voices"
PKG_L10N_VOICES_DESCRIPTION="$PKG_L10N_DESCRIPTION - voices"

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_EN_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_FR_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_EN_DESCRIPTION='English localization'
PKG_L10N_FR_DESCRIPTION='French localization'
PKG_L10N_DEPS="$PKG_L10N_COMMON_ID $PKG_L10N_VOICES_ID"
PKG_L10N_EN_DEPS="$PKG_L10N_DEPS"
PKG_L10N_FR_DEPS="$PKG_L10N_DEPS"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_MODELS_ID="${PKG_DATA_ID}-models"
PKG_DATA_MODELS_DESCRIPTION="$PKG_DATA_DESCRIPTION - models"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_MODELS_ID"

PKG_DATA_SOUNDS_ID="${PKG_DATA_ID}-sounds"
PKG_DATA_SOUNDS_DESCRIPTION="$PKG_DATA_DESCRIPTION - sounds"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_SOUNDS_ID"

PKG_DATA_TEXTURES_ID="${PKG_DATA_ID}-textures"
PKG_DATA_TEXTURES_1_ID="${PKG_DATA_TEXTURES_ID}-1"
PKG_DATA_TEXTURES_2_ID="${PKG_DATA_TEXTURES_ID}-2"
PKG_DATA_TEXTURES_3_ID="${PKG_DATA_TEXTURES_ID}-3"
PKG_DATA_TEXTURES_4_ID="${PKG_DATA_TEXTURES_ID}-4"
PKG_DATA_TEXTURES_5_ID="${PKG_DATA_TEXTURES_ID}-5"
PKG_DATA_TEXTURES_6_ID="${PKG_DATA_TEXTURES_ID}-6"
PKG_DATA_TEXTURES_7_ID="${PKG_DATA_TEXTURES_ID}-7"
PKG_DATA_TEXTURES_8_ID="${PKG_DATA_TEXTURES_ID}-8"
PKG_DATA_TEXTURES_9_ID="${PKG_DATA_TEXTURES_ID}-9"
PKG_DATA_TEXTURES_10_ID="${PKG_DATA_TEXTURES_ID}-10"
PKG_DATA_TEXTURES_11_ID="${PKG_DATA_TEXTURES_ID}-11"
PKG_DATA_TEXTURES_DESCRIPTION="$PKG_DATA_DESCRIPTION - textures"
PKG_DATA_TEXTURES_1_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 1"
PKG_DATA_TEXTURES_2_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 2"
PKG_DATA_TEXTURES_3_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 3"
PKG_DATA_TEXTURES_4_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 4"
PKG_DATA_TEXTURES_5_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 5"
PKG_DATA_TEXTURES_6_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 6"
PKG_DATA_TEXTURES_7_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 7"
PKG_DATA_TEXTURES_8_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 8"
PKG_DATA_TEXTURES_9_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 9"
PKG_DATA_TEXTURES_10_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 10"
PKG_DATA_TEXTURES_11_DESCRIPTION="$PKG_DATA_TEXTURES_DESCRIPTION - 11"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_TEXTURES_1_ID $PKG_DATA_TEXTURES_2_ID $PKG_DATA_TEXTURES_3_ID $PKG_DATA_TEXTURES_4_ID $PKG_DATA_TEXTURES_5_ID $PKG_DATA_TEXTURES_6_ID $PKG_DATA_TEXTURES_7_ID $PKG_DATA_TEXTURES_8_ID $PKG_DATA_TEXTURES_9_ID $PKG_DATA_TEXTURES_10_ID $PKG_DATA_TEXTURES_11_ID"

PKG_DATA_PATCH0_ID="${PKG_DATA_ID}-patch0"
PKG_DATA_PATCH1_ID="${PKG_DATA_ID}-patch1"
PKG_DATA_PATCH2_ID="${PKG_DATA_ID}-patch2"
PKG_DATA_PATCH3_ID="${PKG_DATA_ID}-patch3"
PKG_DATA_PATCH0_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch0"
PKG_DATA_PATCH1_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch1"
PKG_DATA_PATCH2_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch2"
PKG_DATA_PATCH3_DESCRIPTION="$PKG_DATA_DESCRIPTION - patch3"
PKG_DATA_DEPS_PATCH0="${PKG_DATA_DEPS:-} $PKG_DATA_PATCH0_ID"
PKG_DATA_DEPS_PATCH1="$PKG_DATA_DEPS_PATCH0 $PKG_DATA_PATCH1_ID"
PKG_DATA_DEPS_PATCH2="$PKG_DATA_DEPS_PATCH1 $PKG_DATA_PATCH2_ID"
PKG_DATA_DEPS_PATCH3="$PKG_DATA_DEPS_PATCH2 $PKG_DATA_PATCH3_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_L10N_ID $PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Generate localizations configuration

l10n_config_source="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/data/localization/language.lsx"
l10n_config_pattern='<attribute id="Value" value=".*" type="20" />'

l10n_config_destination_en="$(package_path 'PKG_L10N_EN')$(path_game_data)/data/localization/language.lsx"
l10n_config_replacement_en='<attribute id="Value" value="English" type="20" />'
mkdir --parents "$(dirname "$l10n_config_destination_en")"
sed --expression="s;${l10n_config_pattern};${l10n_config_replacement_en};" \
	"$l10n_config_source" > "$l10n_config_destination_en"

l10n_config_destination_fr="$(package_path 'PKG_L10N_FR')$(path_game_data)/data/localization/language.lsx"
l10n_config_replacement_fr='<attribute id="Value" value="French" type="20" />'
mkdir --parents "$(dirname "$l10n_config_destination_fr")"
sed --expression="s;${l10n_config_pattern};${l10n_config_replacement_fr};" \
	"$l10n_config_source" > "$l10n_config_destination_fr"

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
case "${LANG%_*}" in
	('fr')
		message='version %s :'
		lang_en='anglaise'
		lang_fr='française'
	;;
	('en'|*)
		message='%s version:'
		lang_en='English'
		lang_fr='French'
	;;
esac
printf '\n'
## English localization
printf "$message" "$lang_en"
print_instructions $(packages_get_list | sed 's/PKG_L10N_FR//')
## French localization
printf "$message" "$lang_fr"
print_instructions $(packages_get_list | sed 's/PKG_L10N_EN//')

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
