#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Nine Noir Lives
# send your bug reports to contact@dotslashplay.it
###

script_version=20231017.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='nine-noir-lives'
GAME_NAME='Nine Noir Lives'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_DEMO_0_NAME='setup_nine_noir_lives_demo_1.02_(46357).exe'
ARCHIVE_BASE_DEMO_0_MD5='f22c232ad0d7c1512b0aa90611f67340'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_SIZE='550000'
ARCHIVE_BASE_DEMO_0_VERSION='1.02-gog46357'
ARCHIVE_BASE_DEMO_0_URL='https://www.gog.com/game/nine_noir_lives_demo'

VISIONAIRE_NAME='nnl'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_FILES="
${VISIONAIRE_NAME}.vis
*.vc
*.vi
*.vs
*.vt
*.vv"

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Local/Silvernode Studios/NNL Demo'

PKG_DATA_PROVIDES="
${GAME_ID}-data"

PKG_BIN_ARCH='32'
PKG_BIN_PROVIDES="
$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default
## Delete broken 256×256 icon
broken_icon="$(package_path 'PKG_DATA')$(path_icons)/256x256/apps/$(game_id).png"
rm --force "$broken_icon"
rmdir --ignore-fail-on-non-empty --parents "$(dirname "$broken_icon")"

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
