/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHSERVICESETTINGDATA_H_
#define OPENDRIM_SSHSERVICESETTINGDATA_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_SettingData.h"
#include "CIM_SettingDataAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_SSHServiceSettingData_classnames[] = {"OpenDRIM_SSHServiceSettingData"};
static string OpenDRIM_SSHServiceSettingData_NAMESPACE = _NAMESPACE;
const static string SettingData_role = "SettingData";
const static char* SettingData_classnames[] = {"OpenDRIM_SSHSettingData"};
const static string SettingData_NAMESPACE = _NAMESPACE;

const static string ManagedElement_role = "ManagedElement";
const static char* ManagedElement_classnames[] = {"OpenDRIM_SSHProtocolService"};
const static string ManagedElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_SSHServiceSettingData {

public:
	
	Objectpath ManagedElement;
	bool ManagedElement_isNULL;
	
	Objectpath SettingData;
	bool SettingData_isNULL;
	
	unsigned short IsDefault;
	bool IsDefault_isNULL;
	
	unsigned short IsCurrent;
	bool IsCurrent_isNULL;
	
	unsigned short IsNext;
	bool IsNext_isNULL;
	
	unsigned short IsMinimum;
	bool IsMinimum_isNULL;
	
	unsigned short IsMaximum;
	bool IsMaximum_isNULL;
	
	unsigned short IsPending;
	bool IsPending_isNULL;
	
	OpenDRIM_SSHServiceSettingData() {
		ManagedElement_isNULL = true;
		SettingData_isNULL = true;
		IsDefault_isNULL = true;
		IsCurrent_isNULL = true;
		IsNext_isNULL = true;
		IsMinimum_isNULL = true;
		IsMaximum_isNULL = true;
		IsPending_isNULL = true;
	}
	
	~OpenDRIM_SSHServiceSettingData() {}
	
	string getKeys() const {
		return CF_toLowCase(".ManagedElement=\"" + CF_quoteString(ManagedElement.toString()) + "\""".SettingData=\"" + CF_quoteString(SettingData.toString()) + "\"");
	}

	int getManagedElement(Objectpath& value) const {
		if (ManagedElement_isNULL==true)
			return NOT_FOUND;
		value = ManagedElement;
		return OK;
	}
	
	int setManagedElement(const Objectpath& newValue) {
		ManagedElement = newValue;
		ManagedElement.setNamespace(ManagedElement_NAMESPACE);
		ManagedElement_isNULL = false;
		return OK;
	}

	int getSettingData(Objectpath& value) const {
		if (SettingData_isNULL==true)
			return NOT_FOUND;
		value = SettingData;
		return OK;
	}
	
	int setSettingData(const Objectpath& newValue) {
		SettingData = newValue;
		SettingData.setNamespace(SettingData_NAMESPACE);
		SettingData_isNULL = false;
		return OK;
	}

	int getIsDefault(unsigned short& value) const {
		if (IsDefault_isNULL==true)
			return NOT_FOUND;
		value = IsDefault;
		return OK;
	}
	
	int setIsDefault(const unsigned short& newValue) {
		IsDefault = newValue;
		IsDefault_isNULL = false;
		return OK;
	}

	int getIsCurrent(unsigned short& value) const {
		if (IsCurrent_isNULL==true)
			return NOT_FOUND;
		value = IsCurrent;
		return OK;
	}
	
	int setIsCurrent(const unsigned short& newValue) {
		IsCurrent = newValue;
		IsCurrent_isNULL = false;
		return OK;
	}

	int getIsNext(unsigned short& value) const {
		if (IsNext_isNULL==true)
			return NOT_FOUND;
		value = IsNext;
		return OK;
	}
	
	int setIsNext(const unsigned short& newValue) {
		IsNext = newValue;
		IsNext_isNULL = false;
		return OK;
	}

	int getIsMinimum(unsigned short& value) const {
		if (IsMinimum_isNULL==true)
			return NOT_FOUND;
		value = IsMinimum;
		return OK;
	}
	
	int setIsMinimum(const unsigned short& newValue) {
		IsMinimum = newValue;
		IsMinimum_isNULL = false;
		return OK;
	}

	int getIsMaximum(unsigned short& value) const {
		if (IsMaximum_isNULL==true)
			return NOT_FOUND;
		value = IsMaximum;
		return OK;
	}
	
	int setIsMaximum(const unsigned short& newValue) {
		IsMaximum = newValue;
		IsMaximum_isNULL = false;
		return OK;
	}

	int getIsPending(unsigned short& value) const {
		if (IsPending_isNULL==true)
			return NOT_FOUND;
		value = IsPending;
		return OK;
	}
	
	int setIsPending(const unsigned short& newValue) {
		IsPending = newValue;
		IsPending_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_SSHSERVICESETTINGDATA_H_*/
