/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_SoftwareIdentityAccess.h"

int SoftwareInventory_OpenDRIM_SoftwareIdentity_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SoftwareIdentity_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SoftwareIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SoftwareIdentity>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	string stdOut, stdErr;
	string line;
	vector<string> software_info;
	bool isDebPack;
	
	//check if installed packages are deb or rpm
	if(CF_isExist("/usr/bin/dpkg"))
	{
		isDebPack = true;
		CF_runCommand("dpkg -l", stdOut, stdErr, errorMessage);
		
		stringstream ss (stringstream::in | stringstream::out);
		ss << stdOut;
		
		while(getline(ss, line))
		{
			if (! (CF_startsWith(line, "|") or CF_startsWith(line, "+") or CF_startsWith(line, "Desired=")))
			{
				OpenDRIM_SoftwareIdentity instance;
				CF_splitTextBySpace(software_info, line);
				instance.setInstanceID(software_info[1]);
				if(discriminant=="ei")
					CF_assert(SoftwareInventory_OpenDRIM_SoftwareIdentity_populate(instance, isDebPack, line, errorMessage));
				result.push_back(instance);
			}
		}
	}
	else
	{
		isDebPack = false;
		CF_runCommand("rpm -qa", stdOut, stdErr, errorMessage);
		
		stringstream ss (stringstream::in | stringstream::out);
		ss << stdOut;
		
		while(getline(ss, line))
		{
			OpenDRIM_SoftwareIdentity instance;
			CF_splitTextBySpace(software_info, line);
			instance.setInstanceID(software_info[0]);
			if (discriminant == "ei")
				CF_assert(SoftwareInventory_OpenDRIM_SoftwareIdentity_populate(instance, isDebPack, line, errorMessage));
			result.push_back(instance);
		}
	}
	
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SoftwareIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SoftwareIdentity& instance, const char** properties, string& errorMessage) {
	_E_;
	string command;
	vector<string> Software_lines;
	bool isDebPack;
	
	//check if installed packages are deb or rpm
	if(CF_isExist("/usr/bin/dpkg"))
	{
		isDebPack = true;
		command = "dpkg -l " + instance.InstanceID;
		CF_assert(CF_runCommandToLines(command, Software_lines, 0, errorMessage))
		
		//if this instance exists this command returns string with 5 rows,
		//otherwise it's result will be "No packages found matching .. " (1 row)
		if (Software_lines.size() > 1)
		{
			CF_assert(SoftwareInventory_OpenDRIM_SoftwareIdentity_populate(instance, isDebPack, Software_lines[5], errorMessage));
		}
		else
		{
			errorMessage = "No instance";
			return NOT_FOUND;
		}
	}
	else
	{
		isDebPack = false;
		command = "rpm -qi " + instance.InstanceID;
		CF_assert(CF_runCommandToLines(command, Software_lines, 0, errorMessage));
		
		//if this instance exists this command returns string with 5 rows, 
		//otherwise it's result will be "Package .. is not installed " (1 row)
		if (Software_lines.size() > 1)
		{
			CF_assert(SoftwareInventory_OpenDRIM_SoftwareIdentity_populate(instance, isDebPack, instance.InstanceID, errorMessage));
		}
		else
		{
			errorMessage = "No instance";
			return NOT_FOUND;
		}
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SoftwareIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentity& newInstance, const OpenDRIM_SoftwareIdentity& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_SoftwareIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_SoftwareIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_SoftwareIdentity_populate(OpenDRIM_SoftwareIdentity& instance, bool isDebPackage, string& soft_line, string& errorMessage) {
	_E_;
	string elem_name ="";
	vector<string> software_info;
	
	//check if installed packages are deb or rpm
	if(isDebPackage)
	{
		//soft_line returns full information about current software for .deb
		CF_splitTextBySpace(software_info, soft_line);
		instance.setVersionString(software_info[2]);
		
		elem_name = software_info[3];
		if(software_info.size() > 4)
		{			
			for(size_t i=4; i<software_info.size(); i++)
			elem_name += " " + software_info[i];
		}
		instance.setElementName(elem_name);
		
		//if first string is "rc" this software is uninstalled
		if(software_info[0] == "rc")
			instance.setIsEntity(false);
		//if first string is "ii" this software is installed
		else 
			instance.setIsEntity(true);
	}
	else
	{
		CF_splitText(software_info, soft_line, "-");

		instance.setElementName(software_info[software_info.size()-2]);
		instance.setVersionString(software_info[software_info.size()-1]);
		instance.setIsEntity(true);
	}
	_L_;
	return OK;
}

