/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_RUNNINGOSACCESS_H_
#define OPENDRIM_RUNNINGOSACCESS_H_

#include "OS_Common.h"

#include "OpenDRIM_RunningOS.h"
#include "assocOpenDRIM_RunningOS.h"

int OS_OpenDRIM_RunningOS_load(const CMPIBroker* broker, string& errorMessage);

int OS_OpenDRIM_RunningOS_unload(string& errorMessage);

int OS_OpenDRIM_RunningOS_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RunningOS>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_RunningOS_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RunningOS& instance, const char** properties, string& errorMessage);

int OS_OpenDRIM_RunningOS_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RunningOS& newInstance, const OpenDRIM_RunningOS& oldInstance, const char** properties, string& errorMessage);

int OS_OpenDRIM_RunningOS_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RunningOS& instance, string& errorMessage);

int OS_OpenDRIM_RunningOS_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RunningOS& instance, string& errorMessage);

int OS_OpenDRIM_RunningOS_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_RunningOS_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_RunningOS_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_RunningOS>& OpenDRIM_RunningOS_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_RunningOS_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_RunningOS>& OpenDRIM_RunningOS_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_RunningOS_populate(OpenDRIM_RunningOS& instance, string& errorMessage);

#endif /*OPENDRIM_RUNNINGOSACCESS_H_*/
