/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import jnlp.sample.jardiff.JarDiff;
import jnlp.sample.servlet.DownloadRequest;
import jnlp.sample.servlet.DownloadResponse;
import jnlp.sample.servlet.ErrorResponseException;
import jnlp.sample.servlet.JnlpResource;
import jnlp.sample.servlet.Logger;
import jnlp.sample.servlet.ResourceCatalog;
import jnlp.sample.util.VersionString;

public class JarDiffHandler {
    private static final int BUF_SIZE = 32768;
    private static final String JARDIFF_MIMETYPE = "application/x-java-archive-diff";
    private HashMap _jarDiffEntries = new HashMap();
    private static Logger _log = null;
    private ServletContext _servletContext = null;
    private String _jarDiffMimeType = null;

    public JarDiffHandler(ServletContext servletContext, Logger logger) {
        this._servletContext = servletContext;
        _log = logger;
        this._jarDiffMimeType = this._servletContext.getMimeType("xyz.jardiff");
        if (this._jarDiffMimeType == null) {
            this._jarDiffMimeType = JARDIFF_MIMETYPE;
        }
    }

    public synchronized DownloadResponse getJarDiffEntry(ResourceCatalog resourceCatalog, DownloadRequest downloadRequest, JnlpResource jnlpResource) {
        if (downloadRequest.getCurrentVersionId() == null) {
            return null;
        }
        boolean bl = JarDiffHandler.isJavawsVersion(downloadRequest, "1.0*");
        JarDiffKey jarDiffKey = new JarDiffKey(jnlpResource.getName(), downloadRequest.getCurrentVersionId(), jnlpResource.getReturnVersionId(), !bl);
        JarDiffEntry jarDiffEntry = (JarDiffEntry)this._jarDiffEntries.get(jarDiffKey);
        if (jarDiffEntry == null) {
            File file;
            if (_log.isInformationalLevel()) {
                _log.addInformational("servlet.log.info.jardiff.gen", jnlpResource.getName(), downloadRequest.getCurrentVersionId(), jnlpResource.getReturnVersionId());
            }
            if ((file = this.generateJarDiff(resourceCatalog, downloadRequest, jnlpResource, bl)) == null) {
                _log.addWarning("servlet.log.warning.jardiff.failed", jnlpResource.getName(), downloadRequest.getCurrentVersionId(), jnlpResource.getReturnVersionId());
            }
            jarDiffEntry = new JarDiffEntry(file);
            this._jarDiffEntries.put(jarDiffKey, jarDiffEntry);
        }
        if (jarDiffEntry.getJarDiffFile() == null) {
            return null;
        }
        return DownloadResponse.getFileDownloadResponse(jarDiffEntry.getJarDiffFile(), this._jarDiffMimeType, jarDiffEntry.getJarDiffFile().lastModified(), jnlpResource.getReturnVersionId());
    }

    public static boolean isJavawsVersion(DownloadRequest downloadRequest, String string) {
        String string2 = "javaws";
        String string3 = downloadRequest.getHttpRequest().getHeader("User-Agent");
        if (!string3.startsWith("javaws-")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                int n = string4.indexOf(string2);
                if (n == -1) continue;
                string4 = string4.substring(n + string2.length() + 1);
                return VersionString.contains(string, string4);
            }
            return false;
        }
        int n = string3.indexOf("-");
        if (n == -1) {
            return false;
        }
        int n2 = string3.indexOf("/");
        if (n2 == -1 || n2 < n) {
            return false;
        }
        String string5 = string3.substring(n + 1, n2);
        return VersionString.contains(string, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean download(URL uRL, File file) {
        _log.addDebug("JarDiffHandler:  Doing download");
        boolean bl = true;
        boolean bl2 = false;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n = 0;
            int n2 = 0;
            byte[] byArray = new byte[32768];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                n2 += n;
            }
            _log.addDebug("total read: " + n2);
            _log.addDebug("Wrote URL " + uRL.toString() + " to file " + file);
        }
        catch (IOException iOException) {
            _log.addDebug("Got exception while downloading resource: " + iOException);
            bl = false;
            if (file != null) {
                bl2 = true;
            }
        }
        finally {
            try {
                bufferedInputStream.close();
                bufferedInputStream = null;
            }
            catch (IOException iOException) {
                _log.addDebug("Got exception while downloading resource: " + iOException);
            }
            try {
                filterOutputStream.close();
                filterOutputStream = null;
            }
            catch (IOException iOException) {
                _log.addDebug("Got exception while downloading resource: " + iOException);
            }
            if (bl2) {
                file.delete();
            }
        }
        return bl;
    }

    private String getRealPath(String string) throws IOException {
        File file;
        URL uRL = this._servletContext.getResource(string);
        File file2 = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        if (uRL != null && this.download(uRL, file = File.createTempFile("temp", ".jar", file2))) {
            String string2 = file.getPath();
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File generateJarDiff(ResourceCatalog resourceCatalog, DownloadRequest downloadRequest, JnlpResource jnlpResource, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        DownloadRequest downloadRequest2 = downloadRequest.getFromDownloadRequest();
        try {
            JnlpResource jnlpResource2 = resourceCatalog.lookupResource(downloadRequest2);
            String string = this._servletContext.getRealPath(jnlpResource.getPath());
            String string2 = this._servletContext.getRealPath(jnlpResource2.getPath());
            if (string == null && (string = this.getRealPath(jnlpResource.getPath())) != null) {
                bl3 = true;
            }
            if (string2 == null && (string2 = this.getRealPath(jnlpResource2.getPath())) != null) {
                bl2 = true;
            }
            if (string == null) return null;
            if (string2 == null) {
                return null;
            }
            File file = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
            File file2 = File.createTempFile("jnlp", ".jardiff", file);
            _log.addDebug("Generating Jardiff between " + string2 + " and " + string + " Store in " + file2);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            JarDiff.createPatch(string2, string, fileOutputStream, !bl);
            ((OutputStream)fileOutputStream).close();
            try {
                if (file2.length() >= new File(string).length()) {
                    _log.addDebug("JarDiff discarded - since it is bigger");
                    File file3 = null;
                    return file3;
                }
                File file4 = new File(string + ".pack.gz");
                if (file4.exists()) {
                    _log.addDebug("generated jardiff size: " + file2.length());
                    _log.addDebug("packed requesting file size: " + file4.length());
                    if (file2.length() >= file4.length()) {
                        _log.addDebug("JarDiff discarded - packed version of requesting file is smaller");
                        File file5 = null;
                        return file5;
                    }
                }
                _log.addDebug("JarDiff generation succeeded");
                File file6 = file2;
                return file6;
            }
            finally {
                if (bl3) {
                    new File(string).delete();
                }
                if (bl2) {
                    new File(string2).delete();
                }
            }
        }
        catch (IOException iOException) {
            _log.addDebug("Failed to genereate jardiff", iOException);
            return null;
        }
        catch (ErrorResponseException errorResponseException) {
            _log.addDebug("Failed to genereate jardiff", errorResponseException);
            return null;
        }
    }

    private static class JarDiffEntry {
        private File _jardiffFile;

        public JarDiffEntry(File file) {
            this._jardiffFile = file;
        }

        public File getJarDiffFile() {
            return this._jardiffFile;
        }
    }

    private static class JarDiffKey
    implements Comparable {
        private String _name;
        private String _fromVersionId;
        private String _toVersionId;
        private boolean _minimal;

        public JarDiffKey(String string, String string2, String string3, boolean bl) {
            this._name = string;
            this._fromVersionId = string2;
            this._toVersionId = string3;
            this._minimal = bl;
        }

        public String getName() {
            return this._name;
        }

        public String getFromVersionId() {
            return this._fromVersionId;
        }

        public String getToVersionId() {
            return this._toVersionId;
        }

        public boolean isMinimal() {
            return this._minimal;
        }

        public int compareTo(Object object) {
            if (!(object instanceof JarDiffKey)) {
                return -1;
            }
            JarDiffKey jarDiffKey = (JarDiffKey)object;
            int n = this._name.compareTo(jarDiffKey.getName());
            if (n != 0) {
                return n;
            }
            n = this._fromVersionId.compareTo(jarDiffKey.getFromVersionId());
            if (n != 0) {
                return n;
            }
            if (this._minimal != jarDiffKey.isMinimal()) {
                return -1;
            }
            return this._toVersionId.compareTo(jarDiffKey.getToVersionId());
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            return this._name.hashCode() + this._fromVersionId.hashCode() + this._toVersionId.hashCode();
        }
    }
}

