/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class EnumFieldReferenceInitializer
extends SimplifiedVisitor
implements ElementValueVisitor,
InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private MemberVisitor enumFieldFinder = new AllAttributeVisitor(new AllInstructionVisitor(this));
    private String enumTypeName;
    private String enumConstantName;
    private boolean enumConstantNameFound;
    private Clazz referencedEnumClass;
    private Field referencedEnumField;

    @Override
    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        if (enumConstantElementValue.referencedClasses != null && enumConstantElementValue.referencedClasses.length > 0) {
            this.referencedEnumClass = enumConstantElementValue.referencedClasses[0];
            if (this.referencedEnumClass != null) {
                this.enumTypeName = enumConstantElementValue.getTypeName(clazz);
                this.enumConstantName = enumConstantElementValue.getConstantName(clazz);
                this.referencedEnumField = null;
                this.referencedEnumClass.methodAccept("<clinit>", "()V", this.enumFieldFinder);
                if (this.referencedEnumField == null) {
                    this.referencedEnumField = this.referencedEnumClass.findField(this.enumConstantName, this.enumTypeName);
                }
                enumConstantElementValue.referencedField = this.referencedEnumField;
            }
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -77: 
            case 18: 
            case 19: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.enumConstantNameFound = this.enumConstantName.equals(stringConstant.getString(clazz));
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        if (this.enumConstantNameFound) {
            if (this.enumTypeName.equals(fieldrefConstant.getType(clazz))) {
                this.referencedEnumField = (Field)fieldrefConstant.referencedMember;
            }
            this.enumConstantNameFound = false;
        }
    }
}

