/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalUtil;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

class SamRecordIntervalIterator
implements CloseableIterator<SAMRecord> {
    private static final int DEFAULT_MAX_READ_LENGTH_GUESS = 16384;
    private final SAMFileReader samReader;
    private final Iterator<Interval> mergedIntervalsIterator;
    private PeekableIterator<SAMRecord> samIterator = null;
    private int lastSequenceIndex = -1;
    private int lastPosition = -1;

    public SamRecordIntervalIterator(SAMFileReader samReader, List<Interval> uniqueIntervals) {
        this(samReader, uniqueIntervals, 16384);
    }

    public SamRecordIntervalIterator(SAMFileReader samReader, List<Interval> uniqueIntervals, int maxReadLengthGuess) {
        IntervalUtil.assertOrderedNonOverlapping(uniqueIntervals.iterator(), samReader.getFileHeader().getSequenceDictionary());
        if (!samReader.hasIndex()) {
            throw new IllegalArgumentException("SAMFileReader does not support query");
        }
        this.samReader = samReader;
        this.mergedIntervalsIterator = this.mergeCloseIntervals(uniqueIntervals, maxReadLengthGuess).iterator();
        this.advanceInterval();
    }

    private List<Interval> mergeCloseIntervals(List<Interval> uniqueIntervals, int maxReadLengthGuess) {
        ArrayList<Interval> ret = new ArrayList<Interval>();
        if (uniqueIntervals.isEmpty()) {
            return ret;
        }
        Interval accumulatingInterval = uniqueIntervals.get(0);
        for (int i = 1; i < uniqueIntervals.size(); ++i) {
            Interval thisInterval = uniqueIntervals.get(i);
            if (!accumulatingInterval.getSequence().equals(thisInterval.getSequence()) || thisInterval.getStart() - accumulatingInterval.getEnd() > maxReadLengthGuess) {
                ret.add(accumulatingInterval);
                accumulatingInterval = thisInterval;
                continue;
            }
            accumulatingInterval = new Interval(accumulatingInterval.getSequence(), accumulatingInterval.getStart(), thisInterval.getEnd());
        }
        ret.add(accumulatingInterval);
        return ret;
    }

    private void advanceInterval() {
        if (this.samIterator != null) {
            this.samIterator.close();
        }
        this.samIterator = null;
        while (this.mergedIntervalsIterator.hasNext()) {
            Interval nextInterval = this.mergedIntervalsIterator.next();
            this.samIterator = new PeekableIterator(this.samReader.queryOverlapping(nextInterval.getSequence(), nextInterval.getStart(), nextInterval.getEnd()));
            this.advanceSamIterator();
            if (this.samIterator.hasNext()) break;
            this.samIterator.close();
            this.samIterator = null;
        }
    }

    private void advanceSamIterator() {
        SAMRecord rec;
        while (this.samIterator.hasNext() && (rec = this.samIterator.peek()).getReferenceIndex() <= this.lastSequenceIndex && rec.getAlignmentStart() <= this.lastPosition) {
            this.samIterator.next();
        }
    }

    public void close() {
        if (this.samIterator != null) {
            this.samIterator.close();
            this.samIterator = null;
        }
    }

    public boolean hasNext() {
        return this.samIterator != null && this.samIterator.hasNext();
    }

    public SAMRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SAMRecord rec = this.samIterator.next();
        this.lastSequenceIndex = rec.getReferenceIndex();
        this.lastPosition = rec.getAlignmentStart();
        if (!this.samIterator.hasNext()) {
            this.advanceInterval();
        }
        return rec;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported: remove");
    }
}

