/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.collections;

import java.io.PrintStream;
import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class LoggingNestedIntegerArray<T>
extends NestedIntegerArray<T> {
    private PrintStream log;
    private String logEntryLabel;
    public static final String HEADER_LINE_PREFIX = "# ";

    public LoggingNestedIntegerArray(PrintStream log, String logEntryLabel, int ... dimensions) {
        super(dimensions);
        if (log == null) {
            throw new ReviewedStingException("Log output stream must not be null");
        }
        this.log = log;
        this.logEntryLabel = logEntryLabel != null ? logEntryLabel : "";
        StringBuilder logHeaderLine = new StringBuilder();
        logHeaderLine.append(HEADER_LINE_PREFIX);
        logHeaderLine.append(this.logEntryLabel);
        for (int dimension : dimensions) {
            logHeaderLine.append("\t");
            logHeaderLine.append(dimension);
        }
        this.log.println(logHeaderLine.toString());
    }

    @Override
    public T get(int ... keys) {
        StringBuilder logEntry = new StringBuilder();
        logEntry.append(this.logEntryLabel);
        logEntry.append("\t");
        logEntry.append((Object)NestedIntegerArrayOperation.GET);
        logEntry.append("\t");
        for (int key : keys) {
            logEntry.append("\t");
            logEntry.append(key);
        }
        this.log.println(logEntry.toString());
        return super.get(keys);
    }

    @Override
    public boolean put(T value, int ... keys) {
        StringBuilder logEntry = new StringBuilder();
        logEntry.append(this.logEntryLabel);
        logEntry.append("\t");
        logEntry.append((Object)NestedIntegerArrayOperation.PUT);
        logEntry.append("\t");
        logEntry.append(value);
        for (int key : keys) {
            logEntry.append("\t");
            logEntry.append(key);
        }
        this.log.println(logEntry.toString());
        return super.put(value, keys);
    }

    public static enum NestedIntegerArrayOperation {
        GET,
        PUT;

    }
}

