/* $Id: 7eff376e4512a1a228d812e3282f213fd5ad9763 $ */
#ifndef TRPATH_CONVERT_INCLUDED
#define TRPATH_CONVERT_INCLUDED

#include "transcriptome.h"
#include "ef64.h"
#include "compress.h"

#include "list.h"
#include "intlistpool.h"
#include "univcoord.h"
#include "listpool.h"
#include "pathpool.h"
#include "transcriptpool.h"
#include "hitlistpool.h"


extern void
Trpath_convert_sense (bool *solvedp, int *found_score,
		      List_T *unsolved_sense_paths_gplus, List_T *unsolved_sense_paths_gminus,
		      List_T *sense_paths_gplus, List_T *sense_paths_gminus,

		      List_T sense_trpaths,
		      
		      Compress_T query_compress_fwd, Compress_T query_compress_rev, int querylength,
		      Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
		      Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		      Hitlistpool_T hitlistpool);

extern void
Trpath_convert_antisense (bool *solvedp, int *found_score,
			  List_T *unsolved_antisense_paths_gplus, List_T *unsolved_antisense_paths_gminus,
			  List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,

			  List_T antisense_trpaths,

			  Compress_T query_compress_fwd, Compress_T query_compress_rev, int querylength,
			  Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
			  Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
			  Hitlistpool_T hitlistpool);

extern void
Trpath_convert_setup (Transcriptome_T transcriptome_in,
		      EF64_T chromosome_ef64_in);


#endif
