/* $Id: 854ac6524673d2ce67d2ef37e599b9fb7cab7f19 $ */
#ifndef STAGE1HR_INCLUDED
#define STAGE1HR_INCLUDED

typedef struct Stage1_T *Stage1_T;

#include "bool.h"
#include "univcoord.h"
#include "types.h"
#include "mode.h"
#include "pass.h"

#include "reader.h"
#include "genomicpos.h"
#include "indexdb.h"
#include "shortread.h"
#include "iit-read-univ.h"
#include "ef64.h"

#include "genome.h"
#include "transcriptome.h"
#include "genomebits.h"

#include "mergeinfo.h"
#include "splice.h"
#include "indel.h"

#include "knownsplicing.h"
#include "knownindels.h"
#include "spliceendsgen.h"

#include "trdiagpool.h"
#include "univdiagpool.h"
#include "uintlistpool.h"
#include "intlistpool.h"
#include "univcoord.h"
#include "listpool.h"
#include "pathpool.h"
#include "trpathpool.h"
#include "hitlistpool.h"


#define T Stage1_T
struct T {
  /* Results */

  /* Trdiagonals */
  Trnum_T *sense_trnums;	/* Could have duplicates */
  Trcoord_T *sense_troffsets;
  Trcoord_T *sense_trhighs;
  Trcoord_T *sense_trdiagonals;	/* Could have multiple trdiagonals for the same trnum */
  int *sense_tstarts;
  int *sense_tends;
  int n_sense_trdiagonals;

  Trnum_T *antisense_trnums;	/* Could have duplicates */
  Trcoord_T *antisense_troffsets;
  Trcoord_T *antisense_trhighs;
  Trcoord_T *antisense_trdiagonals; /* Could have multiple trdiagonals for the same trnum */
  int *antisense_tstarts;
  int *antisense_tends;
  int n_antisense_trdiagonals;

  /* Trpaths */
  List_T sense_trpaths;
  List_T antisense_trpaths;


  /* Univdiagonals */
  bool exact_paths_computed_p;

  /* From Kmer_prevalent, re-used by Kmer_widest */
  Univcoord_T *all_univdiagonals_gplus; /* Memory is aligned */
  Univcoord_T *all_univdiagonals_gminus; /* Memory is aligned */
  int all_nunivdiagonals_gplus;
  int all_nunivdiagonals_gminus;
  int max_npositions_gplus;
  int max_npositions_gminus;

#if 0
  /* Univdiagonal links */
  Univcoordtable_T stored_paths_gplus;	/* For storing paths of each univdiagonal */
  Univcoordtable_T stored_paths_gminus;
  Univcoordtableuint_T stored_methods_gplus;	 /* For storing methods of each univdiagonal */
  Univcoordtableuint_T stored_methods_gminus;
#endif

  /* Paths */
  List_T unsolved_sense_paths_gplus;
  List_T unsolved_sense_paths_gminus;
  List_T unsolved_antisense_paths_gplus;
  List_T unsolved_antisense_paths_gminus;

  List_T unextended_sense_paths_gplus;
  List_T unextended_sense_paths_gminus;
  List_T unextended_antisense_paths_gplus;
  List_T unextended_antisense_paths_gminus;


  /* These are the univdiagonals where sense and antisense coords have been merged */
  /* Facilitate Kmer procedures that generate univdiagonals */
  /* Aligned memory as a result of merging */
  Univcoord_T *univdiagonals_gplus;
  Univcoord_T *univdiagonals_gminus;
  int nunivdiagonals_gplus;
  int nunivdiagonals_gminus;

  /* Paths found so far */
  Path_T *sense_paths_gplus;
  Path_T *sense_paths_gminus;
  Path_T *antisense_paths_gplus;
  Path_T *antisense_paths_gminus;

  /* These are the univdiagonals corresponding to the paths found so far */
  /* Need to be aligned memory for merging */
  Univcoord_T *sense_coords_gplus;
  Univcoord_T *sense_coords_gminus;
  Univcoord_T *antisense_coords_gplus;
  Univcoord_T *antisense_coords_gminus;

  int *sense_indices_gplus;
  int *sense_indices_gminus;
  int *antisense_indices_gplus;
  int *antisense_indices_gminus;

  int n_sense_paths_gplus;
  int n_sense_paths_gminus;
  int n_antisense_paths_gplus;
  int n_antisense_paths_gminus;

  int nunique_sense_coords_gplus;
  int nunique_sense_coords_gminus;
  int nunique_antisense_coords_gplus;
  int nunique_antisense_coords_gminus;

  Reader_T reader;
  Reader_T tr_reader;

  /* Initialized by Stage1_fill_all_positions */
  bool *validp;			/* Need only one, since we allocate
				   forward_oligos[querypos] and
				   revcomp_oligos[querypos] at same
				   time */
  bool *tr_validp;

  bool all_oligos_gen_filledp;
  bool all_positions_gen_filledp;

  Oligospace_T *forward_oligos;
  Oligospace_T *revcomp_oligos;
  Oligospace_T *tr_forward_oligos;
  Oligospace_T *tr_revcomp_oligos;

  /* Need plus_retrievedp and minus_retrievedp because
     Extension_search and Tr_extension_search can retrieve either plus
     or minus */
  bool *retrievedp_allocated;
  bool *plus_retrievedp;	       /* points to above[index1interval-1] */
  bool *minus_retrievedp;	       /* points to above[index1interval-1] */

  bool *tr_retrievedp_allocated;
  bool *tr_plus_retrievedp;
  bool *tr_minus_retrievedp;

#ifdef LARGE_GENOMES
  unsigned char **positions_high_allocated;
  unsigned char **plus_positions_high; /* points to above[index1interval-1] */
  unsigned char **minus_positions_high; /* points to above[index1interval-1] */
#endif

  /* plus positions are the alignments to the plus genome strand of
     the forward oligo, and also the alignments to the minus genome
     strand of the revcomp oligo */
  UINT4 **positions_allocated;
  UINT4 **plus_positions; /* points to above[index1interval-1] */
  UINT4 **minus_positions; /* points to above[index1interval-1] */
  int *plus_diagterms;
  int *minus_diagterms;

  UINT4 **tr_positions_allocated;
  UINT4 **tr_plus_positions;
  UINT4 **tr_minus_positions;

  int *npositions_allocated;
  int *plus_npositions;		/* points to above[index1interval-1] */
  int *minus_npositions;	/* points to above[index1interval-1] */

  int *tr_npositions_allocated;
  int *tr_plus_npositions;
  int *tr_minus_npositions;
  
  /* Memory allocated for mismatch_positions in Substring_new (Genome_mismatches_{left,right}),
     and for Distant_rna_solve */
  /* int *mismatch_positions_alloc; */
  int *positions_alloc;

  /* Memory allocated for indelinfo */
  Indelinfo_T indelinfo;

  /* Memory allocated for spliceinfo in kmer-search.c and
     path-solve.c, used by Splice_resolve_sense and
     Splice_resolve_antisense */
  Spliceinfo_T spliceinfo;

  Mergeinfo_uint4_T mergeinfo_tr;
#ifdef LARGE_GENOMES
  Mergeinfo_uint8_T mergeinfo;
#else
  Mergeinfo_uint4_T mergeinfo;
#endif

  /* Memory allocated for Segment_identify in segment-search.c, and
     Merge_diagonals in kmer-search.c (which needs four sets of
     arrays) */
#ifdef LARGE_GENOMES
  unsigned char **stream_high_alloc, **gplus_stream_high_array_5, **gminus_stream_high_array_5, **gplus_stream_high_array_3, **gminus_stream_high_array_3;
  UINT4 **stream_low_alloc, **gplus_stream_low_array_5, **gminus_stream_low_array_5, **gplus_stream_low_array_3, **gminus_stream_low_array_3;
#endif

  int streamspace_max_alloc;	/* Entries in streamspace_alloc */
  Univcoord_T *streamspace_alloc;
  Univcoord_T **streamptr_alloc, **gplus_stream_array_5, **gminus_stream_array_5, **gplus_stream_array_3, **gminus_stream_array_3;
  Trcoord_T **tplus_stream_array, **tminus_stream_array;

  int *streamsize_alloc, *tplus_streamsize_array, *tminus_streamsize_array,
    *gplus_streamsize_array_5, *gminus_streamsize_array_5, *gplus_streamsize_array_3, *gminus_streamsize_array_3;
  int *querypos_diagterm_alloc, *tplus_diagterm_array, *tminus_diagterm_array,
    *gplus_diagterm_array_5, *gminus_diagterm_array_5, *gplus_diagterm_array_3, *gminus_diagterm_array_3;

  /* Returned from Extension_search and used for distant splicing */
  List_T queryfwd_plus_set;
  List_T queryfwd_minus_set;
  List_T queryrev_plus_set;
  List_T queryrev_minus_set;

  /* Returned from Tr_extension_search */
  List_T tr_queryfwd_plus_set;
  List_T tr_queryfwd_minus_set;
  List_T tr_queryrev_plus_set;
  List_T tr_queryrev_minus_set;

#if 0
  /* Intermediate calculations for transcriptome */
  /* Returned from Transcriptome_search_ends and used for Transcriptome_search_complete */
  Trcoord_T *tplus_positions_5, *tminus_positions_5, *tplus_positions_3, *tminus_positions_3;
  int n_tplus_positions_5, n_tminus_positions_5, n_tplus_positions_3, n_tminus_positions_3;
  int tplus_diagterm_5, tminus_diagterm_5, tplus_diagterm_3, tminus_diagterm_3;
#endif
};


extern void
Stage1_list_trpaths (T this);

extern void
Stage1_list_paths (T this);

extern void
Stage1_list_univdiagonals (T this);

extern void
Stage1_trdiagonals_gc (T this);

extern void
Stage1_free (T *old, Trdiagpool_T trdiagpool, Univdiagpool_T univdiagpool,
	     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
	     Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
	     Pathpool_T pathpool, Trpathpool_T trpathpool,
	     Transcriptpool_T transcriptpool, Hitlistpool_T hitlistpool, bool free_paths_p);

extern T
Stage1_new (char *queryuc_ptr, int querylength);

extern void
Stage1_dump (T this, int querylength);
extern void
Stage1_dump_tr (T this, int querylength);

extern void
Stage1_init_end_gen (T this, int querylength, int genestrand);
extern void
Stage1_init_end_oligos_tr (T this, int querylength);
extern void
Stage1_init_end_positions_tr (T this, int querylength);
extern void
Stage1_init_end2_positions_tr (T this, int querylength);

extern void
Stage1_fill_all_oligos_gen (T this, int querylength, int genestrand);
extern void
Stage1_fill_all_oligos_tr (T this, int querylength);

extern void
Stage1_fill_all_positions_gen (T this, int querylength, int genestrand);
extern void
Stage1_fill_all_positions_tr (T this, int querylength);


extern void
Stage1_extend_unextended_paths (T this, Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
				int genestrand, Compress_T query_compress_fwd, Compress_T query_compress_rev,
				Knownsplicing_T knownsplicing, Knownindels_T knownindels,
				int *mismatch_positions_alloc, Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
				int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
				Chrpos_T overall_end_distance, bool paired_end_p, bool first_read_p,
				Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
				Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
				Pathpool_T pathpool, Transcriptpool_T transcriptpool,
				Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, Spliceendsgen_T spliceendsgen);

extern List_T
Stage1_flatten_paths (T this, Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
		      int genestrand, Compress_T query_compress_fwd, Compress_T query_compress_rev,
		      Knownsplicing_T knownsplicing, Knownindels_T knownindels,
		      int *mismatch_positions_alloc, Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
		      int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
		      Chrpos_T overall_end_distance, bool paired_end_p, bool first_read_p,
		      Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		      Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
		      Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		      Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, Spliceendsgen_T spliceendsgen);

extern void
Stage1hr_setup (Indexdb_T indexdb_fwd_in, Indexdb_T indexdb_rev_in, Indexdb_T indexdb_tr_in,
		EF64_T repetitive_ef64_in, int index1part_in, int index1interval_in,
		int index1part_tr_in, int index1interval_tr_in, 
		Chrpos_T shortsplicedist_novelend_in, Transcriptome_T transcriptome_in);

#undef T
#endif

