/* $Id: bc130687e2b2c355c428e5726c3b7415eef4227c $ */
#ifndef STAGE1HR_SINGLE_INCLUDED
#define STAGE1HR_SINGLE_INCLUDED

#include "stage1hr-single.h"

#include "bool.h"
#include "transcriptome.h"

#include "ef64.h"
#include "path.h"

#include "types.h"
#include "compress.h"
#include "shortread.h"
#include "knownsplicing.h"
#include "knownindels.h"

#include "intlistpool.h"
#include "univcoord.h"
#include "trdiagpool.h"
#include "univdiagpool.h"
#include "hitlistpool.h"
#include "trpathpool.h"
#include "pathpool.h"
#include "vectorpool.h"
#include "transcriptpool.h"
#include "spliceendsgen.h"

#include "pass.h"

#define T Stage1_T

extern Method_T
single_read_next_method_trdiagonal (Method_T last_method, T this, int querylength);

extern Method_T
single_read_next_method_tr (int *found_score, Method_T last_method,

			    List_T *sense_trpaths, List_T *antisense_trpaths,

			    T this, int genestrand, int querylength,
			    int *mismatch_positions_alloc,
			    Compress_T query_compress_fwd, Compress_T query_compress_rev,

			    int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			 
			    Trdiagpool_T trdiagpool,
			    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
			    Listpool_T listpool, Trpathpool_T trpathpool, Pathpool_T pathpool,
			    Hitlistpool_T hitlistpool, bool appendp);

extern Method_T
single_read_next_method_univdiagonal (Method_T last_method,
				      Univcoord_T **univdiagonals_gplus, int *nunivdiagonals_gplus,
				      Univcoord_T **univdiagonals_gminus, int *nunivdiagonals_gminus,
				      T this, T mate, int genestrand, int querylength,
				      Chrpos_T overall_max_distance, bool first_read_p);

extern Method_T
single_read_next_method_gen (int *found_score, Method_T last_method,

			     List_T *sense_paths_gplus, List_T *sense_paths_gminus, 
			     List_T *antisense_paths_gplus, List_T *antisense_paths_gminus, 

			     T this, EF64_T repetitive_ef64, int genestrand,

			     Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
			     Knownsplicing_T knownsplicing, Knownindels_T knownindels,
			     int *mismatch_positions_alloc, Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			     Compress_T query_compress_fwd, Compress_T query_compress_rev,

			     int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
			     Chrpos_T overall_max_distance, Chrpos_T overall_end_distance,
			 
			     Univdiagpool_T univdiagpool,
			     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
			     Univcoordlistpool_T univcoordlistpool, Listpool_T listpool, 
			     Pathpool_T pathpool, Transcriptpool_T transcriptpool,
			     Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, Spliceendsgen_T spliceendsgen,
			     bool paired_end_p, bool first_read_p, bool appendp);

extern void
single_read_unsolved_tr (int *found_score,

			 List_T *sense_paths_gplus, List_T *sense_paths_gminus, 
			 List_T *antisense_paths_gplus, List_T *antisense_paths_gminus, 

			 T this, Shortread_T queryseq, int querylength, Knownsplicing_T knownsplicing,
			 Compress_T query_compress_fwd, Compress_T query_compress_rev,

			 int max_insertionlen, int max_deletionlen,
			 
			 Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
			 Univcoordlistpool_T univcoordlistpool, Listpool_T listpool, 
			 Pathpool_T pathpool, Transcriptpool_T transcriptpool,
			 Hitlistpool_T hitlistpool);

extern bool
single_read (int *found_score, Method_T *last_method,

	     List_T *sense_paths_gplus, List_T *sense_paths_gminus,
	     List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,

	     T this, EF64_T repetitive_ef64, int genestrand,

	     Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
	     Knownsplicing_T knownsplicing, Knownindels_T knownindels,
	     int *mismatch_positions_alloc, Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
	     Compress_T query_compress_fwd, Compress_T query_compress_rev,

	     int localdb_nmismatches_allowed, int max_insertionlen, int max_deletionlen,
	     Chrpos_T overall_max_distance, Chrpos_T overall_end_distance,
			 
	     Trdiagpool_T trdiagpool, Univdiagpool_T univdiagpool,
	     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
	     Univcoordlistpool_T univcoordlistpool, Listpool_T listpool, 
	     Trpathpool_T trpathpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
	     Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, Spliceendsgen_T spliceendsgen,
	     bool paired_end_p, bool first_read_p, Method_T final_univdiagonal_method);

extern Path_T *
Stage1_single_read (int *npaths_primary, int *npaths_altloc, int *first_absmq, int *second_absmq,
		    Shortread_T queryseq, EF64_T repetitive_ef64,
		    Knownsplicing_T knownsplicing, Knownindels_T knownindels,
		    Trdiagpool_T trdiagpool, Univdiagpool_T univdiagpool,
		    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		    Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
		    Trpathpool_T trpathpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		    Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, 
		    Spliceendsgen_T spliceendsgen, bool single_cell_p, Pass_T pass);


extern void
Stage1hr_single_setup (Mode_T mode_in, int index1part_in, int index1interval_in, int index1part_tr_in,
		       Transcriptome_T transcriptome_in, bool genome_align_p_in,
		       bool transcriptome_align_p_in,
		       double user_nmismatches_filter_float_in, double user_mincoverage_filter_float_in,
		       double max_middle_insertions_float_in, double max_middle_deletions_float_in,
		       bool splicingp_in, Chrpos_T shortsplicedist_in, Chrpos_T shortsplicedist_novelend_in);

#undef T
#endif

