/* $Id: 001d2bb99aac2affc5864188771452c178c9e83e $ */
#ifndef SPLICEENDS_INCLUDED
#define SPLICEENDS_INCLUDED

typedef struct Spliceends_T *Spliceends_T;

#include "bool.h"
#include "types.h"	/* For Splicetype_T */
#include "genomicpos.h"
#include "univcoord.h"
#include "chrnum.h"

#include "compress.h"
#include "genomebits.h"
#include "knownsplicing.h"
#include "indexdb.h"
#include "localdb-read.h"
#include "spliceendsgen.h"
#include "mergeinfo.h"
#include "stage1hr.h"


#define T Spliceends_T
struct T {
  int id;
  bool checkedout_p;

  int nspliceends;
  Splicetype_T splicetype;
  int sensedir;

  int *mismatch_positions_left;
  int *mismatch_positions_right;

  int *matchlengths;		/* Not currently used */
  int *trimends;		/* splice_qpos */
  Univcoord_T *partners;	/* positions, not diagonals */

  int *medial_nmismatches;	/* Not currently used */
  int *distal_nmismatches;

  double *ambig_probs;
  double *distal_probs;
};


extern void
Spliceends_setup (bool *circularp_in,
		  Genomebits_T genomebits_in, Genomebits_T genomebits_alt_in,
		  Univcoord_T genomelength_in, Indexdb_T indexdb_in,
		  int index1part_in, int index1interval_in, Chrpos_T shortsplicedist_indexdb_in,
		  Localdb_T localdb_in, Chrpos_T shortsplicedist_localdb_in,
		  bool allow_soft_clips_p_in, bool novelsplicingp, bool knownsplicingp);

extern void
Spliceends_free (T *old);

extern T
Spliceends_new (int id, int querylength);

extern int
Spliceends_trim_qstart_nosplice (int *nmismatches_to_trimpos, int *mismatch_positions, int total_nmismatches, 
				 int pos5, int pos3);

extern int
Spliceends_trimmed_qstarts (T *new, int *nosplice_trimpos, int *farsplice_trimpos,
			    int *nosplice_nmismatches, int *farsplice_nmismatches,
			    bool *splice5p, Splicetype_T *splicetype5, double *ambig_prob_5,
			    int try_sensedir, Univcoord_T univdiagonal, int querylength,
			    int qend, int exon_origin, Chrnum_T chrnum, Univcoord_T chroffset,
			    bool plusp, int genestrand, int localdb_nmismatches_allowed, bool innerp, bool salvagep,
			    int *mismatch_positions_alloc, Univcoord_T *novel_diagonals_alloc,
			    unsigned short *localdb_alloc, int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
			    Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
			    Stage1_T stage1, Knownsplicing_T knownsplicing, Spliceendsgen_T spliceendsgen,
			    Compress_T query_compress, char *queryptr,
			    Genomebits_T genomebits, Genomebits_T genomebits_alt,
			    bool find_splices_p);

extern bool
Spliceends_qstart_trim (int *trimpos, int *nmismatches_to_trimpos,
			int *found_sensedir, Splicetype_T *splicetype, double *ambig_prob_qstart,
			Knownsplicing_T knownsplicing, int try_sensedir,
			Univcoord_T univdiagonal, int querylength,
			int pos3, int exon_origin, Chrnum_T chrnum, Univcoord_T chroffset,
			bool plusp, int genestrand, int *mismatch_positions_alloc,
			Spliceendsgen_T spliceendsgen, Compress_T query_compress, char *queryptr,
			Genomebits_T genomebits, Genomebits_T genomebits_alt, bool find_splices_p);

extern int
Spliceends_trim_qend_nosplice (int *nmismatches_to_trimpos, int *mismatch_positions, int total_nmismatches,
			       int pos5, int pos3, int querylength);
extern int
Spliceends_trimmed_qends (T *new, int *nosplice_trimpos, int *farsplice_trimpos,
			  int *nosplice_nmismatches, int *farsplice_nmismatches,
			  bool *splice3p, Splicetype_T *splicetype3, double *ambig_prob_3,
			  int try_sensedir, Univcoord_T univdiagonal, int querylength,
			  int qstart, int exon_origin, Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh,
			  bool plusp, int genestrand, int localdb_nmismatches_allowed, bool innerp, bool salvagep,
			  int *mismatch_positions_alloc, Univcoord_T *novel_diagonals_alloc,
			  unsigned short *localdb_alloc, int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
			  Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
			  Stage1_T stage1, Knownsplicing_T knownsplicing, Spliceendsgen_T spliceendsgen,
			  Compress_T query_compress, char *queryptr,
			  Genomebits_T genomebits, Genomebits_T genomebits_alt,
			  bool find_splices_p);

extern bool
Spliceends_qend_trim (int *trimpos, int *nmismatches_to_trimpos,
		      int *found_sensedir, Splicetype_T *splicetype, double *ambig_prob_qend,
		      Knownsplicing_T knownsplicing, int try_sensedir,
		      Univcoord_T univdiagonal, int querylength,
		      int pos5, int exon_origin, Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh,
		      bool plusp, int genestrand, int *mismatch_positions_alloc, 
		      Spliceendsgen_T spliceendsgen, Compress_T query_compress, char *queryptr,
		      Genomebits_T genomebits, Genomebits_T genomebits_alt,
		      bool find_splices_p);

extern Univcoord_T
Spliceends_qstart_resolve (int *local_nmismatches, int pos3, int querylength,
			   Univcoord_T low_univdiagonal, Univcoord_T high_univdiagonal,
			   Compress_T query_compress, char *queryptr, bool plusp, int genestrand,
			   Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			   int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
			   Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
			   int localdb_nmismatches_allowed);

extern Univcoord_T
Spliceends_qend_resolve (int *local_nmismatches, int pos5, int querylength,
			 Univcoord_T low_univdiagonal, Univcoord_T high_univdiagonal,
			 Compress_T query_compress, char *queryptr, bool plusp, int genestrand,
			 Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			 int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
			 Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
			 int localdb_nmismatches_allowed);

#undef T
#endif

