/* $Id: a5f421270044892c03c6d36d00582dbb9bb26864 $ */
#ifndef SEGMENT_SEARCH_INCLUDED
#define SEGMENT_SEARCH_INCLUDED
#ifdef HAVE_CONFIG_H
#include "config.h"		/* For HAVE_64_BIT */
#endif

#include "bool.h"
#include "types.h"
#include "univcoord.h"
#include "mode.h"
#include "genomicpos.h"
#include "method.h"
#include "pass.h"

#include "compress.h"
#include "shortread.h"
#include "iit-read-univ.h"
#include "ef64.h"

#include "stage1hr.h"
#include "resulthr.h"		/* For Pairtype_T */
#include "splice.h"
#include "knownsplicing.h"
#include "knownindels.h"
#include "record.h"

#ifdef PMAP
#include "oligoindex_pmap.h"
#else
/* #include "oligoindex_hr.h" */
#endif

#include "univdiagpool.h"
#include "intlistpool.h"
#include "uintlistpool.h"
#include "univcoord.h"
#include "listpool.h"
#include "pathpool.h"
#include "transcriptpool.h"
#include "vectorpool.h"
#include "hitlistpool.h"
#include "spliceendsgen.h"


extern struct Record_T *
Segment_identify_lower (int *nrecords,
#ifdef LARGE_GENOMES
			unsigned char **positions_high, UINT4 **positions_low,
#else
			Univcoord_T **positions,
#endif		  
			int *npositions, bool *validp, Oligospace_T *oligos,
			EF64_T repetitive_ef64,
			
			Univcoord_T **stream_alloc, int *streamsize_alloc,
			int *diagterm_alloc, Mergeinfo_T mergeinfo,
			Chrpos_T max_pairlength, Chrpos_T overall_max_distance, int querylength,
			Univcoord_T *ref_diagonals, int ref_ndiagonals, bool plusp);

extern struct Record_T *
Segment_identify_higher (int *nrecords,
#ifdef LARGE_GENOMES
			 unsigned char **positions_high, UINT4 **positions_low,
#else
			 Univcoord_T **positions,
#endif		  
			 int *npositions, bool *validp, Oligospace_T *oligos,
			 EF64_T repetitive_ef64,

			 Univcoord_T **stream_alloc, int *streamsize_alloc,
			 int *diagterm_alloc, Mergeinfo_T mergeinfo,
			 Chrpos_T max_pairlength, Chrpos_T overall_max_distance, int querylength,
			 Univcoord_T *ref_diagonals, int ref_ndiagonals, bool plusp);

extern struct Record_T *
Segment_identify (int *nrecords,
#ifdef LARGE_GENOMES
		  unsigned char **positions_high,
#endif		  
		  UINT4 **positions, int *npositions, bool *validp, Oligospace_T *oligos,
		  EF64_T repetitive_ef64,

#ifdef LARGE_GENOMES
		  unsigned char **stream_high_alloc, UINT4 **stream_low_alloc,
#else
		  Univcoord_T **stream_alloc,
#endif
		  int *streamsize_alloc, int *diagterm_alloc, Mergeinfo_T mergeinfo,
		  Chrpos_T overall_max_distance, int querylength, int sizelimit,
		  bool plusp);

extern void
Segment_search_all (int *found_score,

		    List_T *unextended_sense_paths_gplus, List_T *unextended_sense_paths_gminus,
		    List_T *unextended_antisense_paths_gplus, List_T *unextended_antisense_paths_gminus,
		    
		    List_T *sense_paths_gplus, List_T *sense_paths_gminus,
		    List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,

		    struct Record_T *plus_records, int plus_nrecords, 
		    struct Record_T *minus_records, int minus_nrecords,

		    Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
		    int *mismatch_positions_alloc, Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,

		    Stage1_T stage1, Knownsplicing_T knownsplicing, Knownindels_T knownindels,
		    Compress_T query_compress_fwd, Compress_T query_compress_rev,
		    int max_insertionlen, int max_deletionlen, int nmismatches_allowed,
		    Chrpos_T overall_max_distance, Chrpos_T overall_end_distance,
		    int genestrand, bool paired_end_p, bool first_read_p,
		    Univdiagpool_T univdiagpool, Intlistpool_T intlistpool,
		    Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		    Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		    Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, Spliceendsgen_T spliceendsgen,
		    Method_T method, bool find_splices_p);

extern void
Segment_search_setup (int index1part_in, int index1interval_in,
		      Univ_IIT_T chromosome_iit_in, int nchromosomes_in,
		      int circular_typeint_in, EF64_T chromosome_ef64_in, Mode_T mode_in);

extern void
Segment_search_cleanup ();

#endif

