/* $Id: 1b019eb2879c52dbaca404aa650427d602b6443f $ */
#ifndef GENOMEBITS_INDEL_INCLUDED
#define GENOMEBITS_INDEL_INCLUDED

#include "genomebits.h"
#include "bool.h"
#include "mode.h"
#include "compress.h"
#include "univcoord.h"

#define T Genomebits_T

extern int
Genomebits_indel_solve_high (int *best_trimpos, int *nmismatches_to_trimpos,
			     Univcoord_T univdiagonal, int querylength, int pos5, int pos3,
			     Compress_T query_compress, int *mismatch_positions_alloc,
			     Genomebits_T omebits, Genomebits_T omebits_alt,
			     bool plusp, int genestrand);

extern int
Genomebits_indel_solve_low (int *best_trimpos, int *nmismatches_to_trimpos,
			    Univcoord_T univdiagonal, int querylength, int pos5, int pos3,
			    Compress_T query_compress, int *mismatch_positions_alloc,
			    Genomebits_T omebits, Genomebits_T omebits_alt,
			    bool plusp, int genestrand);

extern void
Genomebits_indel_setup (int max_end_insertions_in, int max_end_deletions_in,
			bool query_unk_mismatch_p_in, bool genome_unk_mismatch_p_in,
			Mode_T mode, bool maskedp);

#undef T
#endif
