/* $Id: 67fbec1ccc58f9b656216306fe14b654b64e1acf $ */
#ifndef EXTENSION_SEARCH_INCLUDED
#define EXTENSION_SEARCH_INCLUDED

#include "method.h"
#include "types.h"
#include "genomicpos.h"
#include "mode.h"
#include "pass.h"

#include "list.h"
#include "iit-read-univ.h"
#include "ef64.h"
#include "genomebits.h"
#include "compress.h"
#include "shortread.h"

#include "stage1hr.h"
#include "indexdb.h"
#include "knownsplicing.h"
#include "knownindels.h"

#include "univdiagpool.h"
#include "intlistpool.h"
#include "uintlistpool.h"
#include "univcoord.h"
#include "listpool.h"
#include "pathpool.h"
#include "vectorpool.h"
#include "hitlistpool.h"

#include "spliceendsgen.h"
#include "mergeinfo.h"


#define T Elt_T
typedef struct T *T;
struct T {
  int min_qstart;
  int max_qend;

  int nmatches;

  Univdiag_T *all_univdiags;
  int n_all_univdiags;

  Univdiag_T *univdiags;	/* Filtered by binary search to generate lowi and highi */
  int nunivdiags;

  int lowi;
  int highi;
};


extern void
Extension_search_setup (Mode_T mode,
			Univcoord_T genomelength_in, int circular_typeint_in, bool *circularp_in, EF64_T chromosome_ef64_in,
			Genomebits_T genomebits_in, Genomebits_T genomebits_alt_in,
			Indexdb_T indexdb_fwd_in, Indexdb_T indexdb_rev_in,
			int index1part_in, int index1interval_in, int maxpaths_search_in);

extern void
Elt_gc (List_T *set, Listpool_T listpool, Univdiagpool_T univdiagpool);

extern void
Extension_search (int *found_score,

		  List_T *unextended_sense_paths_gplus, List_T *unextended_sense_paths_gminus,
		  List_T *unextended_antisense_paths_gplus, List_T *unextended_antisense_paths_gminus,
		  
		  List_T *sense_paths_gplus, List_T *sense_paths_gminus,
		  List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,
		  Stage1_T stage1, Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
		  Knownsplicing_T knownsplicing, Knownindels_T knownindels, int *mismatch_positions_alloc,
		  Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,

		  Compress_T query_compress_fwd, Compress_T query_compress_rev, 

		  Univdiagpool_T univdiagpool, Intlistpool_T intlistpool,
		  Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		  Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		  Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, Spliceendsgen_T spliceendsgen,

		  int max_insertionlen, int max_deletionlen, int nmismatches_allowed,
		  Chrpos_T overall_end_distance,
		  int genestrand, bool paired_end_p, bool first_read_p, Method_T method,
		  bool find_splices_p);

#undef T
#endif


