/* $Id: 3d976fee9594acfe46dc54be26b6b43bdabe9cc4 $ */
#ifndef TRANSCRIPT_INCLUDED
#define TRANSCRIPT_INCLUDED
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

typedef struct Transcript_T *Transcript_T;

#include "filestring.h"
#include "list.h"
#include "intlist.h"
#include "bool.h"
#include "genomicpos.h"
#include "iit-read-univ.h"
#include "outputtype.h"
#include "transcriptome.h"

#include "shortread.h"
#include "path.h"
#include "listpool.h"
#include "transcriptpool.h"

#include "transcript-velocity.h"


#define T Transcript_T
struct T {
  unsigned int num;	      /* Index in transcriptome */
  int genestrand;	/* gplusp: > 0 if transcript is on plus strand and < 0 if it is on minus strand */
  int tstart;	      /* Starting coordinate on transcript, corresponding to querystart.  0-based */
  int tend; /* Ending coordinate, corresponding to queryend.  If transcript_plusp is false, trend > trstart */

  int tstart_overhang;		/* Subtract from tstart if repair works */
  int tend_overhang;		/* Add to tend if repair works */

  List_T exons;

  int nexons;			/* Needed for velocity, since a 1-exon gene cannot be unspliced */
  int trlength;

  Velocity_T velocity;
};


static inline unsigned int
Transcript_num (T this) {
  return this->num;
}

static inline int
Transcript_start (T this) {
  return this->tstart;
}

static inline int
Transcript_end (T this) {
  return this->tend;
}

static inline int
Transcript_genestrand (T this) {
  return this->genestrand;
}

extern void
Transcript_list_gc (List_T *list, Listpool_T listpool, Transcriptpool_T transcriptpool);

extern T
Transcript_new (unsigned int num, int transcript_genestrand, int tstart, int tend,
		int tstart_overhang, int tend_overhang,
		List_T exons, int nexons, int trlength, Transcriptpool_T transcriptpool);

extern T
Transcript_copy (T old, Transcriptpool_T transcriptpool, Listpool_T listpool);
extern List_T
Transcript_copy_list (List_T old, Transcriptpool_T transcriptpool, Listpool_T listpool);
extern void
Transcript_list_ascendingp (List_T list);
extern List_T
Transcript_list_sort (List_T transcripts);
extern void
Transcript_print_nums (List_T list);
extern void
Transcript_print_list (Filestring_T fp, List_T transcripts,
		       Univ_IIT_T transcript_iit, char *header);

extern bool
Transcript_intersectp (List_T transcripts5, List_T transcripts3);

extern void
Transcript_intersection (Path_T path5, Path_T path3, Shortread_T queryseq5, Shortread_T queryseq3,
			 Listpool_T listpool, Transcriptpool_T transcriptpool);
extern int
Transcript_fragment_length (Path_T path5, Path_T path3, Shortread_T queryseq5, Shortread_T queryseq3);

extern void
Transcript_repair_tstart (T this, Listpool_T listpool, Transcriptpool_T transcriptpool);
extern void
Transcript_repair_tend (T this, Listpool_T listpool, Transcriptpool_T transcriptpool);
extern List_T
Transcript_remove_subset (List_T transcripts, List_T subset,
			  Listpool_T listpool, Transcriptpool_T transcriptpool);

extern void
Transcript_setup (int pairmax_transcriptome_in,
		  Outputtype_T output_type_in, Transcriptome_T transcriptome_in,
		  Univ_IIT_T transcript_iit_in);


#undef T
#endif

