/* $Id: baa6fdad936f45df21d329068008b6aa19fff887 $ */
#ifndef PATH_SOLVE_INCLUDED
#define PATH_SOLVE_INCLUDED

#include "types.h"
#include "genomicpos.h"
#include "univcoord.h"
#include "sense.h"
#include "method.h"
#include "pass.h"

#include "bool.h"
#include "list.h"
#include "univdiag.h"
#include "chrnum.h"
#include "compress.h"
#include "shortread.h"

#include "genomebits.h"
#include "localdb-read.h"
#include "indel.h"
#include "splice.h"
#include "knownsplicing.h"
#include "knownindels.h"

#ifdef LARGE_GENOMES
#include "uint8listpool.h"
#else
#include "uintlistpool.h"
#endif

#include "intlistpool.h"
#include "uintlistpool.h"
#include "univdiagpool.h"
#include "listpool.h"
#include "hitlistpool.h"
#include "pathpool.h"
#include "spliceendsgen.h"

#include "path.h"


#define T Path_T
typedef struct T *T;


/* Used by kmer-search, extension-search, and segment-search */
/* Unsolved paths are those that could not be found using indel
   resolve or splice resolve functions.  They potentially represent
   splice plus indels, which require a more complicated solution,
   deferred until later */
extern void
Path_solve_from_diagonals (int *found_score, bool *found_transcriptp,
			   List_T *unsolved_sense_paths, List_T *unsolved_antisense_paths,
			   List_T *unextended_sense_paths, List_T *unextended_antisense_paths,
			   List_T *sense_paths, List_T *antisense_paths,

			   Univcoord_T middle_diagonal_univdiagonal, int middle_diagonal_qstart, int middle_diagonal_qend,
			   int middle_nmismatches, List_T qend_univdiags, List_T qstart_univdiags,
			   
			   Shortread_T queryseq, char *queryptr, int querylength, int *mismatch_positions_alloc,
			   Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
			   int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
			   Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,

			   Indelinfo_T indelinfo, Spliceinfo_T spliceinfo,
			   Knownsplicing_T knownsplicing, Knownindels_T knownindels,
			   Compress_T query_compress, Compress_T query_compress_fwd, Compress_T query_compress_rev,
			   Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh,
			   bool plusp, int genestrand,
			   int max_insertionlen, int max_deletionlen, int nmismatches_allowed,
			   Chrpos_T overall_end_distance_genome, bool paired_end_p, bool first_read_p,
			   Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
			   Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
			   Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, Spliceendsgen_T spliceendsgen,
			   Method_T method, Pass_T pass);

extern void
Path_solve_from_ends (int *found_score, bool *found_transcriptp, List_T *unsolved_paths, List_T *paths,
		      Univcoord_T univdiagonal_i, int pos5_0, int pos3_0,
		      Univcoord_T univdiagonal_j, int pos5_1, int pos3_1,
		      bool plusp, int sensedir, int genestrand,
		      Compress_T query_compress, Compress_T query_compress_fwd, Compress_T query_compress_rev,
		      Shortread_T queryseq, int querylength,
		      Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh,
		      Indelinfo_T indelinfo, Spliceinfo_T spliceinfo, Knownsplicing_T knownsplicing,
		      Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		      Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool, Transcriptpool_T transcriptpool,
		      Hitlistpool_T hitlistpool, int max_insertionlen, int max_deletionlen,
		      int nmismatches_allowed, Method_T method);

extern bool
Path_solve_exact (int *found_score, bool *found_transcriptp, List_T *sense_paths, List_T *antisense_paths,
		  Univcoord_T univdiagonal, int pos5, int pos3, bool plusp, int genestrand,
		  Compress_T query_compress, Compress_T query_compress_fwd, Compress_T query_compress_rev,
		  Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
		  Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh,
		  Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		  Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
		  Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool,
		  int nmismatches_allowed, Method_T method);

extern List_T
Path_extend (bool *completep, int *found_score, bool *found_transcriptp,
	     T original_path, Shortread_T queryseq, char *queryptr, int querylength,
	     int *mismatch_positions_alloc, Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
	     int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
	     Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
	     Indelinfo_T indelinfo, Spliceinfo_T spliceinfo,
	     Knownsplicing_T knownsplicing, Knownindels_T knownindels,
	     Compress_T query_compress, Compress_T query_compress_fwd, Compress_T query_compress_rev,
	     int genestrand, int max_insertionlen, int max_deletionlen, Chrpos_T overall_end_distance,
	     int nmismatches_allowed, bool paired_end_p, bool lowp,
	     Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
	     Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
	     Vectorpool_T vectorpool, Hitlistpool_T hitlistpool,
	     Spliceendsgen_T spliceendsgen, Pass_T pass, bool extend_qstart_p, bool extend_qend_p);

extern void
Path_qstart_resolve (int *found_score, T path,
		     Univcoord_T low_univdiagonal, Univcoord_T high_univdiagonal,
		     char *queryptr, int querylength,
		     Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
		     int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
		     Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
		     Indelinfo_T indelinfo, Spliceinfo_T spliceinfo,
		     Knownsplicing_T knownsplicing,
		     Compress_T query_compress, Compress_T query_compress_fwd, Compress_T query_compress_rev,
		     int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
		     Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
		     Listpool_T listpool, Pathpool_T pathpool);

extern void
Path_qend_resolve (int *found_score, T path,
		   Univcoord_T low_univdiagonal, Univcoord_T high_univdiagonal,
		   char *queryptr, int querylength,
		   Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
		   int streamspace_max_alloc, Univcoord_T *streamspace_alloc,
		   Univcoord_T **streamptr_alloc, int *streamsize_alloc, Mergeinfo_T mergeinfo,
		   Indelinfo_T indelinfo, Spliceinfo_T spliceinfo,
		   Knownsplicing_T knownsplicing,
		   Compress_T query_compress, Compress_T query_compress_fwd, Compress_T query_compress_rev,
		   int genestrand, int nmismatches_allowed, int max_insertionlen, int max_deletionlen,
		   Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
		   Listpool_T listpool, Pathpool_T pathpool);

extern void
Path_solve_setup (bool *circularp_in, Transcriptome_T transcriptome_in,
		  Genomebits_T genomebits_in, Genomebits_T genomebits_alt_in, Univcoord_T genomelength_in,
		  Localdb_T localdb_in, int min_intronlength_in,
		  bool novelsplicingp_in, bool knownsplicingp_in);

#undef T
#endif

