static char rcsid[] = "$Id: method.c 226364 2023-03-07 02:58:57Z twu $";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "method.h"

#include <stdlib.h>

char *
Method_string (Method_T method) {
  /* May want to turn on NO_COMPARE in substring.c also */
  switch (method) {
  case KMER_EXACT: return "exact";
  case EXT: return "ext";
  case TR_ENDS: return "tr.ends";
  case TR_EXT: return "tr.ext";
  case TR_COMPLETE: return "tr.complete";
  case KMER_APPROX: return "approx";
  case SEGMENT1: return "seg1";
  case SEGMENT2: return "seg2";
  case FUSION: return "fusion";
  default: abort();
  }
}


void
Method_samprint (Filestring_T fp, Method_T method) {
  switch (method) {
  case KMER_EXACT: FPRINTF(fp,"\tXG:Z:exact"); break;
  case EXT: FPRINTF(fp,"\tXG:Z:ext"); break;
  case TR_ENDS: FPRINTF(fp,"\tXG:Z:tr.ends"); break;
  case TR_EXT: FPRINTF(fp,"\tXG:Z:tr.ext"); break;
  case TR_COMPLETE: FPRINTF(fp,"\tXG:Z:tr.complete"); break;
  case KMER_APPROX: FPRINTF(fp,"\tXG:Z:approx"); break;
  case SEGMENT1: FPRINTF(fp,"\tXG:Z:seg1"); break;
  case SEGMENT2: FPRINTF(fp,"\tXG:Z:seg2"); break;
  case FUSION: FPRINTF(fp,"\tXG:Z:fusion"); break;
  default: abort();
  }

  return;
}

void
Method_print (Filestring_T fp, Method_T method) {
  switch (method) {
  case KMER_EXACT: FPRINTF(fp,"\tmethod:exact"); break;
  case EXT: FPRINTF(fp,"\tmethod:ext"); break;
  case TR_ENDS: FPRINTF(fp,"\tmethod:tr.ends"); break;
  case TR_EXT: FPRINTF(fp,"\tmethod:tr.ext"); break;
  case TR_COMPLETE: FPRINTF(fp,"\tmethod:tr.complete"); break;
  case KMER_APPROX: FPRINTF(fp,"\tmethod:approx"); break;
  case SEGMENT1: FPRINTF(fp,"\tmethod:seg1"); break;
  case SEGMENT2: FPRINTF(fp,"\tmethod:seg2"); break;
  case FUSION: FPRINTF(fp,"\tmethod:fusion"); break;
  default: abort();
  }

  return;
}

