/* $Id: 547222620ce73a2525ac7b7cb4b5e8971f2ed7d3 $ */
#ifndef KMER_SEARCH_INCLUDED
#define KMER_SEARCH_INCLUDED

#include "list.h"
#include "indexdb.h"
#include "iit-read-univ.h"
#include "ef64.h"
#include "transcriptome.h"
#include "compress.h"
#include "shortread.h"
#include "genomebits.h"
#include "indel.h"

#include "bool.h"
#include "pass.h"
#include "univdiag.h"
#include "stage1hr.h"
#include "mergeinfo.h"
#include "knownsplicing.h"
#include "knownindels.h"

#include "intlistpool.h"
#include "uintlistpool.h"
#include "univcoord.h"
#include "pathpool.h"
#include "transcriptpool.h"
#include "vectorpool.h"
#include "listpool.h"
#include "hitlistpool.h"
#include "spliceendsgen.h"


/* Does not take paired_end_p as a parameter.  ? Generates both sense and antisense */
extern void
Kmer_search_exact (bool *any_insufficientp, int *found_score, bool *found_transcriptp,
			       
		   List_T *sense_paths_gplus, List_T *sense_paths_gminus,
		   List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,
		   Compress_T query_compress_fwd, Compress_T query_compress_rev,
		   Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
		   Stage1_T stage1, int genestrand, int nmismatches_allowed,
		   Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		   Univcoordlistpool_T univcoordlistpool,
		   Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
		   Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool);


/* Takes sizelimit because merging can be expensive */
extern void
Kmer_search_approx (int *found_score, bool *found_transcriptp,
		    List_T *unsolved_sense_paths_gplus, List_T *unsolved_sense_paths_gminus,
		    List_T *unsolved_antisense_paths_gplus, List_T *unsolved_antisense_paths_gminus,
		    
		    List_T *sense_paths_gplus, List_T *sense_paths_gminus,
		    List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,
		    
		    Compress_T query_compress_fwd, Compress_T query_compress_rev,
		    Shortread_T queryseq, int querylength,
		    Stage1_T stage1, Knownsplicing_T knownsplicing,
		    int genestrand, int nmismatches_allowed,
		    int max_insertionlen, int max_deletionlen, int max_gaplen, int sizelimit,
		    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		    Univcoordlistpool_T univcoordlistpool,
		    Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool, 
		    Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool);

extern void
Kmer_search_setup (int index1part_in, int index1interval_in, EF64_T chromosome_ef64_in,
		   Genomebits_T genomebits_in, Genomebits_T genomebits_alt_in,
		   Univcoord_T genomelength_in, bool splicingp_in);
#endif
