/*
 * easy_spice - a spice front end
 * Copyright (C) 2001-2004 Routoure Jean-Marc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*  This part of the code Contains the routines for the interface */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "easyspice.h"


extern EasySpice *easyspice;

/* Big button at the top of the interface */
void
on_visu_schem_clicked                  (GtkButton       *button,
                                        EasySpice   *es)
{
  gchar *buf;
  FILE *gschem_lockfile;

  clean_log(es);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: Stopped opening the schematic\n"));
    return;
  }

  write_log(_("Starting gschem...\n"));
  if ((gschem_lockfile=fopen("easyspice.gschem.lockfile","r"))!=NULL) {
    create_quickmessage(_("Notice"),_("It seems that an existing\n"
			       "gschem session exists.\n\n"
			       "If not, consider deleting the\n"
			       "easyspice.gschem.lockfile."));
    fclose(gschem_lockfile);
  }
  else {
    buf=g_strdup_printf ("(touch easyspice.gschem.lockfile ; gschem %s ;"
			 " rm easyspice.gschem.lockfile) &", 
			 es->file_schematic);
    if (VERBOSE1)
      printf("executing: \"%s\"\n",buf);
    system(buf);
    g_free(buf);
  }
}


void
on_gen_netlist_clicked                 (GtkButton       *button,
                                        EasySpice  *es)
{
  gchar *buf;

  clean_log(es);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: Stopped generating the netlist\n"));
    return;
  }
  
  /* TO BE DONE: test if the schematic has been saved  */
  write_log(_("Creating netlist\n"));
  buf=g_strdup_printf ("%s %s %s",
		       es->geda->gnetlist_command_line, es->file_spice_netlist, es->file_schematic);
  write_log(_("Netlist created\n"));
  if (VERBOSE1)
    printf("executing: \"%s\"\n",buf);
  system(buf);
  g_free(buf);
  
  netlist_read(es->netlist,es->file_spice_netlist);
  if (netlist_test(es, TRUE) == 0) {
    netlist2easy(es, es->netlist);
    led_ok(es->win_main);
  }
  else {
    led_false(es->win_main);
  }
  
  gtk_widget_set_sensitive(lookup_widget (es->win_main, "op_hbox_device"),FALSE);
  gtk_widget_set_sensitive(lookup_widget (es->win_main, "op_hbox_polarisation"),FALSE);
}


void
on_visu_netlist_clicked                (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: project name missing, stopped showing the netlist\n"));
    return;
  }
  textfile_view(es->textviewer, es->file_spice_netlist);
}


/********************* Simulation Buttons ********************/
void
on_op_ok_clicked                       (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  led_off(es->win_main);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: project name missing, stopped simulation\n"));
    return;
  }
  if (netlist_test(es, FALSE)==0) {
    spice_variables_get_entries(es->win_main, es->spice_vars);
    simul(es, SIMUL_OP);
  }
  else  
    write_log(_("error(s) in the netlist\n No simulation done\n"));
}

void
on_dc_ok_clicked                       (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  led_off(es->win_main);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: project name missing, stopped simulation\n"));
    return;
  }
  if ( netlist_test(es, FALSE) ) 
    write_log(_("error(s) in the netlist\n No simulation done\n"));
  else {
    spice_variables_get_entries(es->win_main, es->spice_vars);
    if (spice_test_field(es, SIMUL_DC)) {
      simul(es, SIMUL_DC);
    }
  }
}


void
on_ac_ok_clicked                       (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  led_off(es->win_main);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: project name missing, stopped simulation\n"));
    return;
  }
  if (netlist_test(es, FALSE)) 
    write_log(_("error(s) in the netlist\n No simulation done\n"));
  else {
    spice_variables_get_entries(es->win_main, es->spice_vars);
    if (spice_test_field(es, SIMUL_AC)) {
      simul(es, SIMUL_AC);
    }
  }
}


void
on_tran_ok_clicked                     (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  led_off(es->win_main);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: project name missing, stopped simulation\n"));
    return;
  }
  if (netlist_test(es, FALSE)) 
    write_log(_("error(s) in the netlist\n No simulation done"));
  else {
    spice_variables_get_entries(es->win_main, es->spice_vars);
    if (spice_test_field(es, SIMUL_TRAN)) {
      simul(es, SIMUL_TRAN);
    }
  }
}


void
on_tf_ok_clicked                       (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  led_off(es->win_main);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: project name missing, stopped simulation\n"));
    return;
  }
  if (netlist_test(es, FALSE)) 
    create_quickmessage(_("Error"),_("error(s) in the netlist\n"
			      "No simulation done\n"));
  else {
    spice_variables_get_entries(es->win_main, es->spice_vars);
    if (spice_test_field(es, SIMUL_TF)) {
      simul(es, SIMUL_TF);
    }
  }
}


void
on_noise_ok_clicked                    (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  led_off(es->win_main);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: project name missing, stopped simulation\n"));
    return;
  }
  if (netlist_test(es, FALSE)) 
    write_log(_("error(s) in the netlist\n No simulation done\n"));
  else {
    spice_variables_get_entries(es->win_main, es->spice_vars);
    if (spice_test_field(es, SIMUL_NOISE)) {
      simul(es, SIMUL_NOISE);
    }
  }
}



/*  spice menu : will be done one day */
void
on_spice_default_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_plot_res_activate                   (GtkMenuItem     *menuitem,
                                        ExternalProgramms *ep)
{
  gchar *buf;
  buf=g_strdup_printf("%s plot.cir &", ep->plot_command);
  system(buf);
  g_free(buf);
}


/* --------------- change label when box changed ----------- */

void 
on_param_enable_pressed                (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkWidget *win_prin;
  GtkWidget *param_hbox_name;
  GtkWidget *param_hbox_param;
  GtkWidget *param_hbox_val;
  
  win_prin = es->win_main;

  param_hbox_name=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_name");
  param_hbox_param=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_param");
  param_hbox_val=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_val");

  if (get_gtk_toggle_button(win_prin,"param_enable")) {
    gtk_widget_set_sensitive(param_hbox_name,FALSE);
    gtk_widget_set_sensitive(param_hbox_param,FALSE);
    gtk_widget_set_sensitive(param_hbox_val,FALSE);
   }
  else {
    gtk_widget_set_sensitive(param_hbox_name,TRUE);
    gtk_widget_set_sensitive(param_hbox_param,TRUE);
    gtk_widget_set_sensitive(param_hbox_val,TRUE);
  }
}


void
on_param_lin_pressed                   (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkWidget *win_prin;
  GtkWidget *param_hbox_start,*param_hbox_stop,*param_hbox_step,*param_hbox_list;
  GtkLabel *param_label_step;

  win_prin = es->win_main;

  param_hbox_start=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_start");
  param_hbox_stop=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_stop");
  param_hbox_step=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_step");
  param_hbox_list=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_list");
  param_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (win_prin), "param_label_step"));
  gtk_widget_set_sensitive(param_hbox_start,TRUE);
  gtk_widget_set_sensitive(param_hbox_stop,TRUE);
  gtk_widget_set_sensitive(param_hbox_step,TRUE);
  gtk_widget_set_sensitive(param_hbox_list,FALSE);
  gtk_label_set_text (param_label_step,_("Step"));
}


void
on_param_dec_pressed                   (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkWidget *win_prin;
  GtkWidget *param_hbox_start,*param_hbox_stop,*param_hbox_step,*param_hbox_list;
  GtkLabel *param_label_step;

  win_prin = es->win_main;

  param_hbox_start=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_start");
  param_hbox_stop=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_stop");
  param_hbox_step=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_step");
  param_hbox_list=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_list");
  param_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (win_prin), "param_label_step"));
  gtk_widget_set_sensitive(param_hbox_start,TRUE);
  gtk_widget_set_sensitive(param_hbox_stop,TRUE);
  gtk_widget_set_sensitive(param_hbox_step,TRUE);
  gtk_widget_set_sensitive(param_hbox_list,FALSE);
  gtk_label_set_text (param_label_step,_("Pts/Dec"));
}


void
on_param_list_pressed                  (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkWidget *win_prin;
  GtkWidget *param_hbox_start,*param_hbox_stop,*param_hbox_step,*param_hbox_list;
  GtkLabel *param_label_step;

  win_prin = es->win_main;

  param_hbox_start=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_start");
  param_hbox_stop=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_stop");
  param_hbox_step=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_step");
  param_hbox_list=lookup_widget (GTK_WIDGET (win_prin), "param_hbox_list");
  param_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (win_prin), "param_label_step"));
  gtk_widget_set_sensitive(param_hbox_start,FALSE);
  gtk_widget_set_sensitive(param_hbox_stop,FALSE);
  gtk_widget_set_sensitive(param_hbox_step,FALSE);
  gtk_widget_set_sensitive(param_hbox_list,TRUE);
  gtk_label_set_text (param_label_step,_("Pts/Dec"));
}



void
on_ac_dec_pressed                      (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkLabel *ac_label_step;

  ac_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (es->win_main), "ac_label_step"));
  gtk_label_set_text (ac_label_step,_("Pts/decade"));
}


void
on_ac_lin_pressed                      (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkLabel *ac_label_step;

  ac_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (es->win_main), "ac_label_step"));
  gtk_label_set_text (ac_label_step,_("Number of Pts"));
}


void
on_ac_oct_pressed                      (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkLabel *ac_label_step;

  ac_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (es->win_main), "ac_label_step"));
  gtk_label_set_text (ac_label_step,_("Pts/octave"));
}


void
on_noise_dec_pressed                   (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkLabel *noise_label_step;

  noise_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (es->win_main), "noise_label_step"));
  gtk_label_set_text (noise_label_step,_("Pts/decade"));
}


void
on_noise_lin_pressed                   (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkLabel *noise_label_step;

  noise_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (es->win_main), "noise_label_step"));
  gtk_label_set_text (noise_label_step, _("Number of Pts"));
}


void
on_noise_oct_pressed                   (GtkButton       *button,
                                        EasySpice       *es)
{
  GtkLabel *noise_label_step;

  noise_label_step=GTK_LABEL(lookup_widget (GTK_WIDGET (es->win_main), "noise_label_step"));
  gtk_label_set_text (noise_label_step,_("Pts/octave"));
}



void
on_plot_reset_clicked                  (GtkButton       *button,
                                        EasySpice       *es)
{
  write_log(_("Warning: this funciton is not implemented yet\n"));
  printf("Entered on_plot_reset_clicked. Not implemented yet!\n");
}

void
on_plot_ok_clicked                     (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  led_off(es->win_main);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: project name missing, stopped plotting\n"));
    return;
  }
  spice_variables_get_entries(es->win_main, es->spice_vars);

  create_spice_plot_file(es, es->current_n_step,es->current_simul);
  start_plot(es);
}


void
on_plot_xscale_default_clicked         (GtkButton       *button,
                                        EasySpice       *es)
{
  gtk_widget_set_sensitive(lookup_widget (GTK_WIDGET (es->win_main), "plot_x"),FALSE);
}


void
on_plot_xscale_value_clicked           (GtkButton       *button,
                                        EasySpice       *es)
{
  gtk_widget_set_sensitive(lookup_widget (GTK_WIDGET (es->win_main), "plot_x"),TRUE);
}

/* callback when window manager try to destroy a dialog */
gboolean
do_not_destroy                         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide_on_delete(widget);
  return TRUE;
}

void
on_op_node_changed                     (GtkEditable     *editable,
                                        EasySpice       *es)
{
  gchar *res_name;
  GList *tmp;
  KeyValue *op_result;

  if (VERBOSE2)
    printf("Value of op_node entry changed\n");

  res_name=get_gtk_entry(es->win_main, "op_node");

  tmp=g_list_find_custom(es->netlist->op_result, res_name,
			 (GCompareFunc) keyvalue_compare_key);

  if (tmp == NULL) {
    if (DEBUG)
      printf("  resultname \"%s\" not in list\n", res_name);
    return;
  }
  op_result= tmp->data;

  set_gtk_entry(op_result->value, es->win_main, "op_polarisation_value");
}


void
on_op_device_changed                   (GtkEditable     *editable,
                                        EasySpice *es)
{
  gchar *dev_name, *dev_item;
  GList *dev_result_names=NULL, *tmp;
  SpiceDevice *dev;

  if (VERBOSE2)
    printf("Value in op_device entry changed\n");

  dev_name=get_gtk_entry(es->win_main,"op_device");

  /* Search for the device in the list */
  tmp=g_list_find_custom(es->netlist->devices, dev_name,
			 (GCompareFunc) spicedevice_compare_name);
  if (tmp == NULL) {
    if (DEBUG)
      printf("  device \"%s\" not in list\n",dev_name);
    return;
  }
  dev=tmp->data;
  
  if (DEBUG)
    printf("  %s, %s\n",dev_name, dev->name);

  for (tmp=g_list_first(dev->result); tmp!=NULL; tmp=g_list_next(tmp)) {
    dev_result_names=g_list_append(dev_result_names,
				   g_strdup(((KeyValue*)(tmp->data))->key));
    if (DEBUG)
      printf("*%s*\n",((KeyValue*)(tmp->data))->key);
  }

  /* update the value field if the device changes */
  dev_item=g_strdup(get_gtk_entry(es->win_main, "op_item"));

  /* commented out: NULL means deleting the list */
  if (dev_result_names != NULL) {
    gtk_combo_set_popdown_strings(GTK_COMBO(lookup_widget(es->win_main,"op_item_combo")), dev_result_names);
    if (g_list_find_custom(dev->result, dev_item,
			   (GCompareFunc) keyvalue_compare_key) != NULL) {
      set_gtk_entry(dev_item, es->win_main, "op_item");
    }
  }
  g_free(dev_item);
}


void
on_op_item_changed                     (GtkEditable     *editable,
                                        EasySpice *es)
{
  gchar *dev_name, *device_item;
  GList *tmp;
  SpiceDevice *dev;
  KeyValue *dev_res;

  if (VERBOSE2)
    printf("Value of op_item entry changed\n");

  dev_name=get_gtk_entry(es->win_main,"op_device");
  device_item=get_gtk_entry(es->win_main,"op_item");

  /* Search device on the list */
  tmp=g_list_find_custom(es->netlist->devices, dev_name,
			 (GCompareFunc) spicedevice_compare_name);
  if (tmp == NULL) {
    if (DEBUG)
      printf("  device \"%s\" not in list\n", dev_name);
    return;
  }
  dev=tmp->data;
  /* Search on the device result list */
  tmp=g_list_find_custom(dev->result, device_item,
			 (GCompareFunc) keyvalue_compare_key);
  if (tmp == NULL) {
    if (DEBUG)
      printf("  device element \"%s\" not in list\n", device_item);
    return;
  }
  dev_res=tmp->data;
  
  if (DEBUG)
    printf("  device=%s, item=%s\n", dev_name, device_item);
  
  if (dev_res->value != NULL)
    set_gtk_entry(dev_res->value, es->win_main,"op_device_value");
  else
    set_gtk_entry("", es->win_main,"op_device_value");
}


void
on_viewerspiceoutput_clicked           (GtkButton       *button,
                                        EasySpice *es)
{
  clean_log(es);
  if (strlen(es->project) == 0) {
    write_log(_("Error: No project name specified\n"));
    write_log(_("Error: Stopped showing the spice output\n"));
    return;
  }
  textfile_view(es->textviewer, es->file_spice_results);
}


/********** TEXTVIEWER DIALOG ********************/
void
on_textviewer_button_close_clicked (GtkButton *button, Textviewer *tv)
{
  gtk_widget_destroy(tv->dialog);
  tv->dialog = NULL;
}

void
on_textviewer_destroy (GtkDialog *dialog, Textviewer *tv)
{
  tv->dialog = NULL;
}

/********** GEDA SETTINGS DIALOG ********************/
void
on_geda_setup_destroy                    (GtkDialog       *dialog,
					  GedaSettings    *geda)
{
  geda->dialog=NULL;
}

void
on_geda_setup_default_clicked          (GtkButton       *button,
                                        GedaSettings    *geda)
{
  geda_settings_default(geda);
  geda_settings_set_entries(geda->dialog, geda);
}

void
on_geda_setup_ok_clicked               (GtkButton       *button,
                                        GedaSettings    *geda)
{
  geda_settings_get_entries(geda->dialog, geda);
  gtk_widget_destroy (geda->dialog);
  geda->dialog = NULL;
  geda_create_config (geda);
}

void
on_geda_setup_cancel_clicked           (GtkButton       *button,
                                        GedaSettings    *geda)
{
  gtk_widget_destroy (geda->dialog);
  geda->dialog=NULL;
}

/********** COMMANDS DIALOG ********************/
void
on_command_setup_destroy                 (GtkDialog       *dialog,
					  ExternalProgramms  *prog)
{
  prog->dialog=NULL;
}


void
on_command_setup_default_clicked       (GtkButton       *button,
                                        ExternalProgramms *prog)
{
  commands_set_default(prog);
  commands_set_entries(prog->dialog, prog);
}


void
on_command_setup_cancel_clicked        (GtkButton       *button,
                                        ExternalProgramms *prog)
{
  gtk_widget_destroy (prog->dialog);
  prog->dialog=NULL;
}


void
on_command_setup_ok_clicked            (GtkButton       *button,
                                        ExternalProgramms *prog)
{
  commands_get_entries(prog->dialog, prog);
  gtk_widget_destroy (prog->dialog);
  prog->dialog=NULL;
}

/******************** QUICKMESSAGE DIALOG ********************/
void
on_quickmessage_ok_clicked             (GtkButton *button,
					GtkWidget *dialog)
{
  gtk_widget_destroy (dialog);
}

/******************** VERIFY QUIT DIALOG ********************/
void
on_verify_quit_button_no_clicked       (GtkButton       *button,
					GtkWidget *dialog)
{
  gtk_widget_destroy(dialog);
}

void
on_verify_quit_button_yes_clicked       (GtkButton       *button,
					GtkWidget *dialog)
{
  gtk_widget_destroy(dialog);
  
  /* misc clean ups */
  destroy_plot(easyspice);
  spicelibrary_delete(easyspice->spicelibrary);
  postprocessing_delete(easyspice->postproc);
  
  gtk_main_quit();
}


/********************* POSTPROCESSING DIALOG ********************/
void
on_postprocessing_destroy              (GtkWidget       *widget,
					PostProcessing *postproc)
{
  postproc->dialog=NULL;
}

void
on_postprocessing_button_cancel_clicked
                                        (GtkButton       *button,
					 PostProcessing *postproc)
{
  gtk_widget_destroy(postproc->dialog);
  postproc->dialog=NULL;
}

void
on_postprocessing_button_ok_clicked    (GtkButton       *button,
                                        PostProcessing *postproc)
{
  postprocessing_get_entries(postproc);
  gtk_widget_destroy(postproc->dialog);
  postproc->dialog=NULL;
}

/********************* LIBRARY DIALOG ********************/
void
on_library_dialog_destroy              (GtkWidget       *widget,
                                        SpiceLibrary *spicelib)
{
  /* TODO: destroy/free the model */
  gtk_widget_destroy(spicelib->dialog);
  spicelib->dialog=NULL;
}


void
on_library_dialog_add_clicked          (GtkButton       *button,
                                        SpiceLibrary *spicelib)
{
  GtkFileSelection *file_dialog;
  
  file_dialog=(GtkFileSelection*)gtk_file_selection_new(_("select a library"));
  g_object_set_data(G_OBJECT(file_dialog), "spicelib", (gpointer) spicelib);
  
  gtk_signal_connect_object(GTK_OBJECT(file_dialog->ok_button),"clicked",
			    GTK_SIGNAL_FUNC(on_library_file_select),
			    GTK_OBJECT(file_dialog));
  gtk_signal_connect_object_after(GTK_OBJECT(file_dialog->ok_button),"clicked",
				  (GtkSignalFunc) gtk_widget_destroy,
				  GTK_OBJECT(file_dialog));
  gtk_signal_connect_object(GTK_OBJECT(file_dialog->cancel_button),"clicked",
			    (GtkSignalFunc) gtk_widget_destroy,
			    GTK_OBJECT(file_dialog));
  gtk_widget_show(GTK_WIDGET(file_dialog));
}

void
on_library_file_select           (GtkWidget *file_dialog,
				  gpointer user_data)
{
  SpiceLibrary *spicelib;
  GtkTreeView *treeview;
  GtkTreeIter iter;
  GtkTreeModel *model;
  gchar *filename;

  spicelib=g_object_get_data(G_OBJECT(file_dialog), "spicelib");
  /* TODO: remove local path from filename */
  filename=g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_dialog)));

  printf("filename:%s\n", filename);
  treeview = GTK_TREE_VIEW(lookup_widget(spicelib->dialog, "treeview1"));
  model = gtk_tree_view_get_model(treeview);
  
  gtk_list_store_append (GTK_LIST_STORE(model), &iter);
  gtk_list_store_set(GTK_LIST_STORE(model), &iter,
		     0, filename,
		     -1);
}


void
on_library_dialog_remove_clicked       (GtkButton       *button,
                                        SpiceLibrary *spicelib)
{
  GtkTreeView *treeview;
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkTreeSelection *selection;

  treeview = GTK_TREE_VIEW(lookup_widget(spicelib->dialog, "treeview1"));
  model = gtk_tree_view_get_model(treeview);
  selection = gtk_tree_view_get_selection(treeview);

  if (gtk_tree_selection_get_selected (selection, NULL, &iter))
    gtk_list_store_remove (GTK_LIST_STORE(model), &iter);
}


void
on_library_dialog_edit_clicked         (GtkButton       *button,
                                        SpiceLibrary  *spicelib)
{
  GtkTreeView *treeview;
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkTreeSelection *selection;
  gchar *libname, *buf;

  treeview = GTK_TREE_VIEW(lookup_widget(spicelib->dialog, "treeview1"));
  model = gtk_tree_view_get_model(treeview);
  selection = gtk_tree_view_get_selection(treeview);

  if (gtk_tree_selection_get_selected (selection, NULL, &iter)) {
    gtk_tree_model_get(model, &iter,
		       0, &libname,
		       -1);
    buf=g_strdup_printf("%s %s &", easyspice->commands->editor, libname);
    if (VERBOSE1) 
      printf("executing: \"%s\"\n",buf);
    system(buf);
    g_free(libname);
    g_free(buf);
  }
}


void
on_library_dialog_cancel_clicked       (GtkButton       *button,
                                        SpiceLibrary *spicelib)
{
  /* TODO: destroy/free the model */
  gtk_widget_destroy(spicelib->dialog);
  spicelib->dialog=NULL;
}


void
on_library_dialog_ok_clicked           (GtkButton       *button,
                                        SpiceLibrary *spicelib)
{
  /* copy the model into the library list */
  GtkTreeView *treeview;
  GtkTreeIter iter;
  GtkTreeModel *model;
  gchar *libname;

  treeview = GTK_TREE_VIEW(lookup_widget(spicelib->dialog, "treeview1"));
  model = gtk_tree_view_get_model(treeview);
  
  /* free the current list and load the new one from the dialog */
  g_list_foreach(spicelib->libs, (GFunc) free_element, NULL);
  g_list_free(spicelib->libs);
  spicelib->libs=NULL;

  if (gtk_tree_model_get_iter_first (model, &iter)) {
    do {
      gtk_tree_model_get(model, &iter,
			 0, &libname,
			 -1);
      spicelib->libs= g_list_append(spicelib->libs, libname);
    } while (gtk_tree_model_iter_next(model, &iter));
  }
  gtk_widget_destroy(spicelib->dialog);
  spicelib->dialog=NULL;
}
